/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.server.BadRequestException;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.RequestCounter;
import org.languagetool.server.UserLimits;

final class ServerTools {
    private static final Pattern sentContentPattern = Pattern.compile("<sentcontent>.*</sentcontent>", 32);

    private ServerTools() {
    }

    @NotNull
    static String getLoggingInfo(String remoteAddress, Exception e, int errorCode, HttpExchange httpExchange, Map<String, String> params, long runtimeMillis, RequestCounter reqCounter) {
        String message = "";
        if (e != null) {
            message = message + "An error has occurred: '" + ServerTools.cleanUserTextFromMessage(e.getMessage(), params) + "', sending HTTP code " + errorCode + ". ";
        }
        message = message + "Access from " + remoteAddress + ", ";
        message = message + "HTTP user agent: " + ServerTools.getHttpUserAgent(httpExchange) + ", ";
        message = message + "User agent param: " + params.get("useragent") + ", ";
        if (params.get("v") != null) {
            message = message + "v: " + params.get("v") + ", ";
        }
        message = message + "Referrer: " + ServerTools.getHttpReferrer(httpExchange) + ", ";
        message = message + "language: " + params.get("language") + ", ";
        message = message + "h: " + reqCounter.getHandleCount() + ", ";
        message = message + "r: " + reqCounter.getRequestCount() + ", ";
        if (params.get("username") != null) {
            message = message + "user: " + params.get("username") + ", ";
        }
        if (params.get("apiKey") != null) {
            message = message + "apiKey: " + params.get("apiKey") + ", ";
        }
        if (params.get("tokenV2") != null) {
            message = message + "tokenV2: " + params.get("tokenV2") + ", ";
        }
        message = message + "time: " + runtimeMillis;
        return message;
    }

    @Nullable
    static String getHttpUserAgent(HttpExchange httpExchange) {
        return httpExchange.getRequestHeaders().getFirst("User-Agent");
    }

    @Nullable
    static String getHttpReferrer(HttpExchange httpExchange) {
        return httpExchange.getRequestHeaders().getFirst("Referer");
    }

    static String getSQLDatetimeString(Calendar date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date.getTime());
    }

    static String getSQLDateString(Calendar date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date.getTime());
    }

    static void print(String s) {
        ServerTools.print(s, System.out);
    }

    static void print(String s, PrintStream outputStream) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZ");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String now = dateFormat.format(new Date());
        outputStream.println(now + " " + s);
    }

    static void setCommonHeaders(HttpExchange httpExchange, String contentType, String allowOriginUrl) {
        httpExchange.getResponseHeaders().set("Content-Type", contentType);
        ServerTools.setAllowOrigin(httpExchange, allowOriginUrl);
    }

    static void setAllowOrigin(HttpExchange httpExchange, String allowOriginUrl) {
        if (allowOriginUrl != null) {
            httpExchange.getResponseHeaders().set("Access-Control-Allow-Origin", allowOriginUrl);
        }
    }

    static UserLimits getUserLimits(Map<String, String> params, HTTPServerConfig config) {
        if (params.get("token") != null) {
            return UserLimits.getLimitsFromToken(config, params.get("token"));
        }
        if (params.get("username") != null) {
            if (params.get("apiKey") != null && params.get("password") != null) {
                throw new BadRequestException("apiKey AND password was set, set only apiKey");
            }
            if (params.get("apiKey") != null) {
                return UserLimits.getLimitsByApiKey(config, params.get("username"), params.get("apiKey"));
            }
            if (params.get("password") != null) {
                return UserLimits.getLimitsFromUserAccount(config, params.get("username"), params.get("password"));
            }
            if (params.get("tokenV2") != null) {
                return UserLimits.getLimitsByAddonToken(config, params.get("username"), params.get("tokenV2"));
            }
            throw new BadRequestException("With 'username' set, you also need to specify 'apiKey'");
        }
        if (params.get("apiKey") != null) {
            throw new BadRequestException("apiKey was set, but username was not: " + params.get("apiKey"));
        }
        if (params.get("password") != null) {
            throw new BadRequestException("password was set, but username was not");
        }
        return UserLimits.getDefaultLimits(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    static JLanguageTool.Mode getMode(Map<String, String> params) {
        if (params.get("mode") == null) return JLanguageTool.Mode.ALL;
        String modeParam = params.get("mode");
        if ("textLevelOnly".equals(modeParam)) {
            return JLanguageTool.Mode.TEXTLEVEL_ONLY;
        }
        if ("allButTextLevelOnly".equals(modeParam)) {
            return JLanguageTool.Mode.ALL_BUT_TEXTLEVEL_ONLY;
        }
        if ("all".equals(modeParam)) {
            return JLanguageTool.Mode.ALL;
        }
        if (!"batch".equals(modeParam)) throw new BadRequestException("Mode must be one of 'textLevelOnly', 'allButTextLevelOnly', or 'all' but was: '" + modeParam + "'");
        return JLanguageTool.Mode.ALL;
    }

    @NotNull
    static String getModeForLog(JLanguageTool.Mode mode) {
        switch (mode) {
            case TEXTLEVEL_ONLY: {
                return "tlo";
            }
            case ALL_BUT_TEXTLEVEL_ONLY: {
                return "!tlo";
            }
            case ALL: {
                return "all";
            }
        }
        return "?";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    static JLanguageTool.Level getLevel(Map<String, String> params) {
        if (params.get("level") == null) return JLanguageTool.Level.DEFAULT;
        String param = params.get("level");
        if ("default".equals(param)) {
            return JLanguageTool.Level.DEFAULT;
        }
        if (!"picky".equals(param)) throw new BadRequestException("If 'level' is set, it must be set to 'default' or 'picky'");
        return JLanguageTool.Level.PICKY;
    }

    public static String cleanUserTextFromMessage(String s, Map<String, String> params) {
        if (params.getOrDefault("inputLogging", "").equals("no")) {
            return sentContentPattern.matcher(s).replaceAll("<< content removed >>");
        }
        return s;
    }
}

