/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filterpanel;

import java.io.IOException;
import java.net.URL;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import mediathek.gui.messages.TableModelChangeEvent;
import mediathek.javafx.filterpanel.FXSearchControl;
import mediathek.tool.FilterConfiguration;
import mediathek.tool.FilterDTO;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FXFilmToolBar
extends ToolBar {
    @FXML
    public Button btnDownloadFilmList;
    @FXML
    public Button btnFilmInfo;
    @FXML
    Button btnPlay;
    @FXML
    Button btnRecord;
    @FXML
    Button btnBookmark;
    @FXML
    Button btnManageAbos;
    @FXML
    ToggleButton btnShowBookmarkedMovies;
    @FXML
    Button btnManageBookMarks;
    @FXML
    Button btnShowFilter;
    @FXML
    FXSearchControl jfxSearchField;
    @FXML
    ToggleButton btnSearchThroughDescription;
    @FXML
    ComboBox<FilterDTO> filterSelect;
    private boolean searchfieldFocused;

    public FXFilmToolBar() {
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("/mediathek/res/programm/fxml/film_toolbar.fxml");
            FXMLLoader fxmlLoader = new FXMLLoader(url);
            fxmlLoader.setRoot((Object)this);
            fxmlLoader.setController((Object)this);
            fxmlLoader.load();
            this.setUpFilterSelect();
            MessageBus.getMessageBus().subscribe((Object)this);
        }
        catch (IOException e) {
            Logger logger = LogManager.getLogger(FXFilmToolBar.class);
            logger.error("Failed to load FXML!");
        }
    }

    @Handler
    private void handleTableModelChangeEvent(TableModelChangeEvent e) {
        if (e.active) {
            Platform.runLater(() -> {
                this.searchfieldFocused = this.jfxSearchField.isFocused();
                this.setDisable(true);
            });
        } else {
            Platform.runLater(() -> {
                this.setDisable(false);
                if (this.searchfieldFocused) {
                    this.jfxSearchField.requestFocus();
                    String searchText = this.jfxSearchField.getText();
                    if (!searchText.isEmpty()) {
                        this.jfxSearchField.positionCaret(searchText.length());
                    }
                }
            });
        }
    }

    private void setUpFilterSelect() {
        FilterConfiguration filterConfig = new FilterConfiguration();
        ObservableList availableFilters = FXCollections.observableArrayList(filterConfig.getAvailableFilters());
        FilterConfiguration.addAvailableFiltersObserver(() -> {
            availableFilters.clear();
            availableFilters.addAll(filterConfig.getAvailableFilters());
        });
        SingleSelectionModel selectionModel = this.filterSelect.getSelectionModel();
        FilterConfiguration.addCurrentFiltersObserver(arg_0 -> ((SingleSelectionModel)selectionModel).select(arg_0));
        this.filterSelect.setItems(availableFilters);
        selectionModel.select((Object)filterConfig.getCurrentFilter());
        selectionModel.selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue != null && !newValue.equals(filterConfig.getCurrentFilter())) {
                filterConfig.setCurrentFilter((FilterDTO)newValue);
            }
        });
    }
}

