/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.nwdiag.core.NServer;
import net.sourceforge.plantuml.nwdiag.core.NStackable;
import net.sourceforge.plantuml.nwdiag.core.Network;
import net.sourceforge.plantuml.nwdiag.core.NwGroup;
import net.sourceforge.plantuml.nwdiag.next.GridTextBlockDecorated;
import net.sourceforge.plantuml.nwdiag.next.NBar;
import net.sourceforge.plantuml.nwdiag.next.NPlayField;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class NwDiagram
extends UmlDiagram {
    private boolean initDone;
    private final Map<String, NServer> servers = new LinkedHashMap<String, NServer>();
    private final List<Network> networks = new ArrayList<Network>();
    private final List<NwGroup> groups = new ArrayList<NwGroup>();
    private NwGroup currentGroup = null;
    private final NPlayField playField = new NPlayField();
    private final List<NStackable> stack = new ArrayList<NStackable>();
    private final double margin = 5.0;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Nwdiag)");
    }

    public NwDiagram(ThemeStyle style, UmlSource source) {
        super(style, source, UmlDiagramType.NWDIAG, null);
    }

    public void init() {
        this.initDone = true;
    }

    private Network lastNetwork() {
        if (this.networks.size() == 0) {
            return null;
        }
        return this.networks.get(this.networks.size() - 1);
    }

    private Network stackedNetwork() {
        for (NStackable element : this.stack) {
            if (!(element instanceof Network)) continue;
            return (Network)element;
        }
        return null;
    }

    private NwGroup stakedGroup() {
        for (NStackable element : this.stack) {
            if (!(element instanceof NwGroup)) continue;
            return (NwGroup)element;
        }
        return null;
    }

    public CommandExecutionResult openGroup(String name) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        for (NStackable element : this.stack) {
            if (!(element instanceof NwGroup)) continue;
            return CommandExecutionResult.error("Cannot nest group");
        }
        NwGroup newGroup = new NwGroup(name);
        this.stack.add(0, newGroup);
        this.groups.add(newGroup);
        this.currentGroup = newGroup;
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult openNetwork(String name) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        for (NStackable element : this.stack) {
            if (!(element instanceof Network)) continue;
            return CommandExecutionResult.error("Cannot nest network");
        }
        Network network = this.createNetwork(name);
        this.stack.add(0, network);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult closeSomething() {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        if (this.stack.size() > 0) {
            this.stack.remove(0);
        }
        this.currentGroup = null;
        return CommandExecutionResult.ok();
    }

    private Network createNetwork(String name) {
        Network network = new Network(this.playField.getLast(), this.playField.createNewStage(), name);
        this.networks.add(network);
        return network;
    }

    public CommandExecutionResult link(String name1, String name2) {
        NServer server2;
        if (!this.initDone) {
            return this.errorNoInit();
        }
        if (this.lastNetwork() == null) {
            this.createNetwork(name1);
            server2 = NServer.create(name2);
        } else {
            NServer server1 = this.servers.get(name1);
            Network network1 = this.createNetwork("");
            network1.goInvisible();
            if (server1 != null) {
                server1.connectTo(this.lastNetwork());
            }
            server2 = new NServer(name2, server1.getBar());
        }
        this.servers.put(name2, server2);
        server2.connectTo(this.lastNetwork());
        this.playField.addInPlayfield(server2.getBar());
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult addElement(String name, String definition) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        if (this.currentGroup != null) {
            this.currentGroup.addName(name);
        }
        NServer server = null;
        if (this.lastNetwork() == null) {
            if (this.currentGroup != null) {
                return CommandExecutionResult.ok();
            }
            assert (this.currentGroup == null);
            Network network1 = this.createNetwork("");
            network1.goInvisible();
            server = NServer.create(name);
            this.servers.put(name, server);
            server.doNotPrintFirstLink();
        } else {
            server = this.servers.get(name);
            if (server == null) {
                server = NServer.create(name);
                this.servers.put(name, server);
            }
        }
        Map<String, String> props = this.toSet(definition);
        server.connectTo(this.lastNetwork(), props.get("address"));
        server.updateProperties(props);
        this.playField.addInPlayfield(server.getBar());
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult errorNoInit() {
        return CommandExecutionResult.error("Maybe you forget 'nwdiag {' in your diagram ?");
    }

    private Map<String, String> toSet(String definition) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (definition == null) {
            return result;
        }
        Pattern p = Pattern.compile("\\s*(\\w+)\\s*=\\s*(\"([^\"]*)\"|[^\\s,]+)");
        Matcher m = p.matcher(definition);
        while (m.find()) {
            String name = m.group(1);
            String value = m.group(3) == null ? m.group(2) : m.group(3);
            result.put(name, value);
        }
        return result;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                NwDiagram.this.drawMe(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return NwDiagram.this.getTotalDimension(stringBounder);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private StyleSignatureBasic getStyleDefinitionNetwork(SName sname) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.nwdiagDiagram, sname);
    }

    private TextBlock toTextBlockForNetworkName(String name, String s) {
        if (s != null) {
            name = name + "\\n" + s;
        }
        StyleBuilder styleBuilder = this.getSkinParam().getCurrentStyleBuilder();
        Style style = this.getStyleDefinitionNetwork(SName.network).getMergedStyle(styleBuilder);
        FontConfiguration fontConfiguration = style.getFontConfiguration(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet());
        return Display.getWithNewlines(name).create(fontConfiguration, HorizontalAlignment.RIGHT, new SpriteContainerEmpty());
    }

    private Dimension2D getTotalDimension(StringBounder stringBounder) {
        return TextBlockUtils.getMinMax(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                NwDiagram.this.drawMe(ug);
            }
        }, stringBounder, true).getDimension();
    }

    private void drawMe(UGraphic ug) {
        ug = ug.apply(new UTranslate(5.0, 5.0));
        StringBounder stringBounder = ug.getStringBounder();
        double deltaX = 0.0;
        double deltaY = 0.0;
        GridTextBlockDecorated grid = this.buildGrid(stringBounder);
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            String address = current.getOwnAdress();
            TextBlock desc = this.toTextBlockForNetworkName(current.getDisplayName(), address);
            Dimension2D dim = desc.calculateDimension(stringBounder);
            if (i == 0) {
                deltaY = (dim.getHeight() - 5.0) / 2.0;
            }
            deltaX = Math.max(deltaX, dim.getWidth());
        }
        double y = 0.0;
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            String address = current.getOwnAdress();
            TextBlock desc = this.toTextBlockForNetworkName(current.getDisplayName(), address);
            Dimension2D dim = desc.calculateDimension(stringBounder);
            desc.drawU(ug.apply(new UTranslate(deltaX - dim.getWidth(), y)));
            y += grid.lineHeight(stringBounder, i);
        }
        grid.drawU(ug.apply(new UTranslate(deltaX += 5.0, deltaY)));
        Dimension2D dimGrid = grid.calculateDimension(stringBounder);
        ug.apply(new UTranslate(dimGrid.getWidth() + deltaX + 5.0, dimGrid.getHeight() + deltaY + 5.0)).draw(new UEmpty(1.0, 1.0));
    }

    private Map<Network, String> getLinks(NServer element) {
        LinkedHashMap<Network, String> result = new LinkedHashMap<Network, String>();
        for (Network network : this.networks) {
            String s = element.getAdress(network);
            if (s == null) continue;
            result.put(network, s);
        }
        return result;
    }

    private GridTextBlockDecorated buildGrid(StringBounder stringBounder) {
        this.playField.fixGroups(this.groups, this.servers.values());
        GridTextBlockDecorated grid = new GridTextBlockDecorated(this.networks.size(), this.servers.size(), this.groups, this.networks, this.getSkinParam());
        Map<NBar, Integer> layout = this.playField.doLayout();
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            for (Map.Entry<String, NServer> ent : this.servers.entrySet()) {
                NServer server = ent.getValue();
                if (server.getMainNetworkNext() != current) continue;
                Map<Network, String> conns = this.getLinks(server);
                int col = layout.get(server.getBar());
                double topMargin = 15.0;
                NwGroup group = this.getGroupOf(server);
                if (group != null) {
                    topMargin += group.getTopHeaderHeight(stringBounder, this.getSkinParam());
                }
                grid.add(i, col, server.getLinkedElement(topMargin, conns, this.networks, this.getSkinParam()));
            }
        }
        return grid;
    }

    private NwGroup getGroupOf(NServer server) {
        for (NwGroup group : this.groups) {
            if (!group.contains(server)) continue;
            return group;
        }
        return null;
    }

    public CommandExecutionResult setProperty(String property, String value) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        if ("address".equalsIgnoreCase(property) && this.lastNetwork() != null) {
            this.lastNetwork().setOwnAdress(value);
        }
        if ("width".equalsIgnoreCase(property) && this.lastNetwork() != null) {
            this.lastNetwork().setFullWidth("full".equalsIgnoreCase(value));
        }
        if ("color".equalsIgnoreCase(property)) {
            HColor color;
            HColor hColor = color = value == null ? null : this.getSkinParam().getIHtmlColorSet().getColorOrWhite(this.getSkinParam().getThemeStyle(), value);
            if (this.currentGroup != null) {
                this.currentGroup.setColor(color);
            } else if (this.lastNetwork() != null) {
                this.lastNetwork().setColor(color);
            }
        }
        if ("description".equalsIgnoreCase(property)) {
            if (this.currentGroup == null) {
                this.lastNetwork().setDescription(value);
            } else {
                this.currentGroup.setDescription(value);
            }
        }
        return CommandExecutionResult.ok();
    }

    @Override
    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return ClockwiseTopRightBottomLeft.none();
    }
}

