/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.expression;

import java.util.Objects;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.tim.expression.Token;
import net.sourceforge.plantuml.tim.expression.TokenType;

public final class TValue {
    private final int intValue;
    private final String stringValue;
    private final JsonValue jsonValue;

    private TValue(int value) {
        this.intValue = value;
        this.stringValue = null;
        this.jsonValue = null;
    }

    private TValue(String stringValue) {
        this.intValue = 0;
        this.jsonValue = null;
        this.stringValue = Objects.requireNonNull(stringValue);
    }

    public TValue(JsonValue json) {
        this.jsonValue = json;
        this.intValue = 0;
        this.stringValue = null;
    }

    public static TValue fromInt(int v) {
        return new TValue(v);
    }

    public static TValue fromBoolean(boolean b) {
        return new TValue(b ? 1 : 0);
    }

    public static TValue fromJson(JsonValue json) {
        return new TValue(json);
    }

    public String toString() {
        if (this.jsonValue != null && this.jsonValue.isString()) {
            return this.jsonValue.asString();
        }
        if (this.jsonValue != null) {
            return this.jsonValue.toString();
        }
        if (this.stringValue == null) {
            return "" + this.intValue;
        }
        return this.stringValue;
    }

    public static TValue fromString(Token token) {
        if (token.getTokenType() != TokenType.QUOTED_STRING) {
            throw new IllegalArgumentException();
        }
        return new TValue(token.getSurface());
    }

    public static TValue fromString(String s) {
        return new TValue(s);
    }

    public static TValue fromNumber(Token token) {
        if (token.getTokenType() != TokenType.NUMBER) {
            throw new IllegalArgumentException();
        }
        return new TValue(Integer.parseInt(token.getSurface()));
    }

    public TValue add(TValue v2) {
        if (this.isNumber() && v2.isNumber()) {
            return new TValue(this.intValue + v2.intValue);
        }
        return new TValue(this.toString() + v2.toString());
    }

    public TValue minus(TValue v2) {
        if (this.isNumber() && v2.isNumber()) {
            return new TValue(this.intValue - v2.intValue);
        }
        return new TValue(this.toString() + v2.toString());
    }

    public TValue multiply(TValue v2) {
        if (this.isNumber() && v2.isNumber()) {
            return new TValue(this.intValue * v2.intValue);
        }
        return new TValue(this.toString() + "*" + v2.toString());
    }

    public TValue dividedBy(TValue v2) {
        if (this.isNumber() && v2.isNumber()) {
            return new TValue(this.intValue / v2.intValue);
        }
        return new TValue(this.toString() + "/" + v2.toString());
    }

    public boolean isNumber() {
        return this.jsonValue == null && this.stringValue == null;
    }

    public boolean isJson() {
        return this.jsonValue != null;
    }

    public boolean isString() {
        return this.stringValue != null;
    }

    public Token toToken() {
        if (this.isNumber()) {
            return new Token(this.toString(), TokenType.NUMBER, null);
        }
        if (this.isJson()) {
            return new Token(this.toString(), TokenType.JSON_DATA, this.jsonValue);
        }
        return new Token(this.toString(), TokenType.QUOTED_STRING, null);
    }

    public TValue greaterThanOrEquals(TValue v2) {
        if (this.isNumber() && v2.isNumber()) {
            return TValue.fromBoolean(this.intValue >= v2.intValue);
        }
        return TValue.fromBoolean(this.toString().compareTo(v2.toString()) >= 0);
    }

    public TValue greaterThan(TValue v2) {
        if (this.isNumber() && v2.isNumber()) {
            return TValue.fromBoolean(this.intValue > v2.intValue);
        }
        return TValue.fromBoolean(this.toString().compareTo(v2.toString()) > 0);
    }

    public TValue lessThanOrEquals(TValue v2) {
        if (this.isNumber() && v2.isNumber()) {
            return TValue.fromBoolean(this.intValue <= v2.intValue);
        }
        return TValue.fromBoolean(this.toString().compareTo(v2.toString()) <= 0);
    }

    public TValue lessThan(TValue v2) {
        if (this.isNumber() && v2.isNumber()) {
            return TValue.fromBoolean(this.intValue < v2.intValue);
        }
        return TValue.fromBoolean(this.toString().compareTo(v2.toString()) < 0);
    }

    public TValue equalsOperation(TValue v2) {
        if (this.isNumber() && v2.isNumber()) {
            return TValue.fromBoolean(this.intValue == v2.intValue);
        }
        return TValue.fromBoolean(this.toString().compareTo(v2.toString()) == 0);
    }

    public TValue notEquals(TValue v2) {
        if (this.isNumber() && v2.isNumber()) {
            return TValue.fromBoolean(this.intValue != v2.intValue);
        }
        return TValue.fromBoolean(this.toString().compareTo(v2.toString()) != 0);
    }

    public boolean toBoolean() {
        if (this.isNumber()) {
            return this.intValue != 0;
        }
        return this.toString().length() > 0;
    }

    public int toInt() {
        return this.intValue;
    }

    public TValue logicalAnd(TValue v2) {
        return TValue.fromBoolean(this.toBoolean() && v2.toBoolean());
    }

    public TValue logicalOr(TValue v2) {
        return TValue.fromBoolean(this.toBoolean() || v2.toBoolean());
    }

    public JsonValue toJson() {
        return this.jsonValue;
    }
}

