
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "historyitem_wrapper.h"

// inner classes

// Extra includes
#include <historyitem.h>
#include <qicon.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_HistoryItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::HistoryItem >()))
        return -1;

    ::HistoryItem *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_HistoryItem_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:HistoryItem", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: HistoryItem::HistoryItem(HistoryItem*)
    if (numArgs == 0) {
        overloadId = 0; // HistoryItem(HistoryItem*)
    } else if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX]), (pyArgs[0])))) {
        overloadId = 0; // HistoryItem(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_HistoryItem_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_HistoryItem_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX]), (pyArgs[0]))))
                        goto Sbk_HistoryItem_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_HistoryItem_Init_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::HistoryItem *cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // HistoryItem(HistoryItem*)
            cptr = new ::HistoryItem(cppArg0);
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::HistoryItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_HistoryItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_HistoryItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_HistoryItemFunc_appendChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.appendChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::appendChild(HistoryItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX]), (pyArg)))) {
        overloadId = 0; // appendChild(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_HistoryItemFunc_appendChild_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::HistoryItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // appendChild(HistoryItem*)
            cppSelf->appendChild(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_HistoryItemFunc_appendChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_HistoryItemFunc_changeParent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.changeParent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::changeParent(HistoryItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX]), (pyArg)))) {
        overloadId = 0; // changeParent(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_HistoryItemFunc_changeParent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::HistoryItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // changeParent(HistoryItem*)
            cppSelf->changeParent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_HistoryItemFunc_changeParent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_HistoryItemFunc_child(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.child";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::child(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // child(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_HistoryItemFunc_child_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // child(int)const
            HistoryItem * cppResult = const_cast<const ::HistoryItem *>(cppSelf)->child(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_HistoryItemFunc_child_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_HistoryItemFunc_childCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.childCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // childCount()const
            int cppResult = const_cast<const ::HistoryItem *>(cppSelf)->childCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_HistoryItemFunc_endTimestamp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.endTimestamp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // endTimestamp()const
            qint64 cppResult = const_cast<const ::HistoryItem *>(cppSelf)->endTimestamp();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_HistoryItemFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.icon";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // icon()const
            QIcon cppResult = const_cast<const ::HistoryItem *>(cppSelf)->icon();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_HistoryItemFunc_indexOfChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.indexOfChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::indexOfChild(HistoryItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX]), (pyArg)))) {
        overloadId = 0; // indexOfChild(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_HistoryItemFunc_indexOfChild_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::HistoryItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // indexOfChild(HistoryItem*)
            int cppResult = cppSelf->indexOfChild(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_HistoryItemFunc_indexOfChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_HistoryItemFunc_insertChild(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.insertChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertChild", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: HistoryItem::insertChild(int,HistoryItem*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insertChild(int,HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_HistoryItemFunc_insertChild_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::HistoryItem *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // insertChild(int,HistoryItem*)
            cppSelf->insertChild(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_HistoryItemFunc_insertChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_HistoryItemFunc_isTopLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.isTopLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTopLevel()const
            bool cppResult = const_cast<const ::HistoryItem *>(cppSelf)->isTopLevel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_HistoryItemFunc_parent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.parent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parent()const
            HistoryItem * cppResult = const_cast<const ::HistoryItem *>(cppSelf)->parent();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_HistoryItemFunc_prependChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.prependChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::prependChild(HistoryItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX]), (pyArg)))) {
        overloadId = 0; // prependChild(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_HistoryItemFunc_prependChild_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::HistoryItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // prependChild(HistoryItem*)
            cppSelf->prependChild(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_HistoryItemFunc_prependChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_HistoryItemFunc_removeChild(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.removeChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::removeChild(HistoryItem*)
    // 1: HistoryItem::removeChild(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // removeChild(int)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX]), (pyArg)))) {
        overloadId = 0; // removeChild(HistoryItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_HistoryItemFunc_removeChild_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // removeChild(HistoryItem * child)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::HistoryItem *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // removeChild(HistoryItem*)
                cppSelf->removeChild(cppArg0);
            }
            break;
        }
        case 1: // removeChild(int row)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // removeChild(int)
                cppSelf->removeChild(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_HistoryItemFunc_removeChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_HistoryItemFunc_row(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.row";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // row()
            int cppResult = cppSelf->row();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_HistoryItemFunc_setEndTimestamp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.setEndTimestamp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::setEndTimestamp(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setEndTimestamp(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_HistoryItemFunc_setEndTimestamp_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEndTimestamp(qint64)
            cppSelf->setEndTimestamp(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_HistoryItemFunc_setEndTimestamp_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_HistoryItemFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.setIcon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_HistoryItemFunc_setIcon_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_HistoryItemFunc_setIcon_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_HistoryItemFunc_setStartTimestamp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.setStartTimestamp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryItem::setStartTimestamp(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setStartTimestamp(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_HistoryItemFunc_setStartTimestamp_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStartTimestamp(qint64)
            cppSelf->setStartTimestamp(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_HistoryItemFunc_setStartTimestamp_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_HistoryItemFunc_startTimestamp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.HistoryItem.startTimestamp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startTimestamp()const
            qint64 cppResult = const_cast<const ::HistoryItem *>(cppSelf)->startTimestamp();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_HistoryItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_HistoryItem_methods[] = {
    {"appendChild", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_appendChild), METH_O},
    {"changeParent", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_changeParent), METH_O},
    {"child", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_child), METH_O},
    {"childCount", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_childCount), METH_NOARGS},
    {"endTimestamp", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_endTimestamp), METH_NOARGS},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_icon), METH_NOARGS},
    {"indexOfChild", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_indexOfChild), METH_O},
    {"insertChild", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_insertChild), METH_VARARGS},
    {"isTopLevel", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_isTopLevel), METH_NOARGS},
    {"parent", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_parent), METH_NOARGS},
    {"prependChild", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_prependChild), METH_O},
    {"removeChild", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_removeChild), METH_O},
    {"row", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_row), METH_NOARGS},
    {"setEndTimestamp", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_setEndTimestamp), METH_O},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_setIcon), METH_O},
    {"setStartTimestamp", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_setStartTimestamp), METH_O},
    {"startTimestamp", reinterpret_cast<PyCFunction>(Sbk_HistoryItemFunc_startTimestamp), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_HistoryItem_get_historyEntry(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->historyEntry)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->historyEntry))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->historyEntry)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]), &(cppSelf->historyEntry), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_HistoryItem_set_historyEntry(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'historyEntry' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_HISTORYENTRY_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'historyEntry', 'HistoryEntry' or convertible type expected");
        return -1;
    }

    ::History::HistoryEntry& cppOut_ptr = cppSelf->historyEntry;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_HistoryItem_get_title(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->title);
    return pyOut;
}
static int Sbk_HistoryItem_set_title(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'title' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'title', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->title;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_HistoryItem_get_canFetchMore(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->canFetchMore;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_HistoryItem_set_canFetchMore(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::HistoryItem *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_HISTORYITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'canFetchMore' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'canFetchMore', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->canFetchMore;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->canFetchMore = cppOut_local;

    return 0;
}

// Getters and Setters for HistoryItem
static PyGetSetDef Sbk_HistoryItem_getsetlist[] = {
    {const_cast<char *>("historyEntry"), Sbk_HistoryItem_get_historyEntry, Sbk_HistoryItem_set_historyEntry},
    {const_cast<char *>("title"), Sbk_HistoryItem_get_title, Sbk_HistoryItem_set_title},
    {const_cast<char *>("canFetchMore"), Sbk_HistoryItem_get_canFetchMore, Sbk_HistoryItem_set_canFetchMore},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_HistoryItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_HistoryItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_HistoryItem_Type = nullptr;
static SbkObjectType *Sbk_HistoryItem_TypeF(void)
{
    return _Sbk_HistoryItem_Type;
}

static PyType_Slot Sbk_HistoryItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_HistoryItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_HistoryItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_HistoryItem_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_HistoryItem_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_HistoryItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_HistoryItem_spec = {
    "1:PyFalkon.HistoryItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_HistoryItem_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void HistoryItem_PythonToCpp_HistoryItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_HistoryItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_HistoryItem_PythonToCpp_HistoryItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_HistoryItem_TypeF())))
        return HistoryItem_PythonToCpp_HistoryItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *HistoryItem_PTR_CppToPython_HistoryItem(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::HistoryItem *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_HistoryItem_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *HistoryItem_SignatureStrings[] = {
    "PyFalkon.HistoryItem(self,parent:PyFalkon.HistoryItem=0)",
    "PyFalkon.HistoryItem.appendChild(self,child:PyFalkon.HistoryItem)",
    "PyFalkon.HistoryItem.changeParent(self,parent:PyFalkon.HistoryItem)",
    "PyFalkon.HistoryItem.child(self,row:int)->PyFalkon.HistoryItem",
    "PyFalkon.HistoryItem.childCount(self)->int",
    "PyFalkon.HistoryItem.endTimestamp(self)->qint64",
    "PyFalkon.HistoryItem.icon(self)->PySide2.QtGui.QIcon",
    "PyFalkon.HistoryItem.indexOfChild(self,child:PyFalkon.HistoryItem)->int",
    "PyFalkon.HistoryItem.insertChild(self,row:int,child:PyFalkon.HistoryItem)",
    "PyFalkon.HistoryItem.isTopLevel(self)->bool",
    "PyFalkon.HistoryItem.parent(self)->PyFalkon.HistoryItem",
    "PyFalkon.HistoryItem.prependChild(self,child:PyFalkon.HistoryItem)",
    "1:PyFalkon.HistoryItem.removeChild(self,child:PyFalkon.HistoryItem)",
    "0:PyFalkon.HistoryItem.removeChild(self,row:int)",
    "PyFalkon.HistoryItem.row(self)->int",
    "PyFalkon.HistoryItem.setEndTimestamp(self,end:qint64)",
    "PyFalkon.HistoryItem.setIcon(self,icon:PySide2.QtGui.QIcon)",
    "PyFalkon.HistoryItem.setStartTimestamp(self,start:qint64)",
    "PyFalkon.HistoryItem.startTimestamp(self)->qint64",
    nullptr}; // Sentinel

void init_HistoryItem(PyObject *module)
{
    _Sbk_HistoryItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "HistoryItem",
        "HistoryItem*",
        &Sbk_HistoryItem_spec,
        &Shiboken::callCppDestructor< ::HistoryItem >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_HistoryItem_Type);
    InitSignatureStrings(pyType, HistoryItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_HistoryItem_Type), Sbk_HistoryItem_PropertyStrings);
    SbkPyFalkonTypes[SBK_HISTORYITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_HistoryItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_HistoryItem_TypeF(),
        HistoryItem_PythonToCpp_HistoryItem_PTR,
        is_HistoryItem_PythonToCpp_HistoryItem_PTR_Convertible,
        HistoryItem_PTR_CppToPython_HistoryItem);

    Shiboken::Conversions::registerConverterName(converter, "HistoryItem");
    Shiboken::Conversions::registerConverterName(converter, "HistoryItem*");
    Shiboken::Conversions::registerConverterName(converter, "HistoryItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::HistoryItem).name());



}
