
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "pageformdata_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PageFormData_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PageFormData >()))
        return -1;

    ::PageFormData *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PageFormData.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "PageFormData", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: PageFormData::PageFormData()
    // 1: PageFormData::PageFormData(PageFormData)
    if (numArgs == 0) {
        overloadId = 0; // PageFormData()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX]), (pyArgs[0])))) {
        overloadId = 1; // PageFormData(PageFormData)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PageFormData_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // PageFormData()
        {

            if (!PyErr_Occurred()) {
                // PageFormData()
                cptr = new ::PageFormData();
            }
            break;
        }
        case 1: // PageFormData(const PageFormData & PageFormData)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::PageFormData cppArg0_local;
            ::PageFormData *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // PageFormData(PageFormData)
                cptr = new ::PageFormData(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::PageFormData >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_PageFormData_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_PageFormData_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_PageFormDataFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PageFormData.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::PageFormData *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_PageFormData___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_PageFormData_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_PageFormData_methods[] = {
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_PageFormDataFunc_isValid), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_PageFormData___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_PageFormData_get_username(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->username);
    return pyOut;
}
static int Sbk_PageFormData_set_username(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'username' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'username', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->username;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PageFormData_get_password(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->password);
    return pyOut;
}
static int Sbk_PageFormData_set_password(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'password' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'password', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->password;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PageFormData_get_postData(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->postData)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->postData))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->postData)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &(cppSelf->postData), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_PageFormData_set_postData(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'postData' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'postData', 'QByteArray' or convertible type expected");
        return -1;
    }

    ::QByteArray& cppOut_ptr = cppSelf->postData;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for PageFormData
static PyGetSetDef Sbk_PageFormData_getsetlist[] = {
    {const_cast<char *>("username"), Sbk_PageFormData_get_username, Sbk_PageFormData_set_username},
    {const_cast<char *>("password"), Sbk_PageFormData_get_password, Sbk_PageFormData_set_password},
    {const_cast<char *>("postData"), Sbk_PageFormData_get_postData, Sbk_PageFormData_set_postData},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_PageFormData_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_PageFormData_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_PageFormData_Type = nullptr;
static SbkObjectType *Sbk_PageFormData_TypeF(void)
{
    return _Sbk_PageFormData_Type;
}

static PyType_Slot Sbk_PageFormData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PageFormData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PageFormData_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PageFormData_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_PageFormData_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PageFormData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_PageFormData_spec = {
    "1:PyFalkon.PageFormData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_PageFormData_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PageFormData_PythonToCpp_PageFormData_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_PageFormData_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PageFormData_PythonToCpp_PageFormData_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_PageFormData_TypeF())))
        return PageFormData_PythonToCpp_PageFormData_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PageFormData_PTR_CppToPython_PageFormData(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::PageFormData *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_PageFormData_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *PageFormData_COPY_CppToPython_PageFormData(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_PageFormData_TypeF(), new ::PageFormData(*reinterpret_cast<const ::PageFormData *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void PageFormData_PythonToCpp_PageFormData_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::PageFormData *>(cppOut) = *reinterpret_cast< ::PageFormData *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_PageFormData_PythonToCpp_PageFormData_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_PageFormData_TypeF())))
        return PageFormData_PythonToCpp_PageFormData_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *PageFormData_SignatureStrings[] = {
    "1:PyFalkon.PageFormData(self)",
    "0:PyFalkon.PageFormData(self,PageFormData:PyFalkon.PageFormData)",
    "PyFalkon.PageFormData.isValid(self)->bool",
    "PyFalkon.PageFormData.__copy__()",
    nullptr}; // Sentinel

void init_PageFormData(PyObject *module)
{
    _Sbk_PageFormData_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PageFormData",
        "PageFormData",
        &Sbk_PageFormData_spec,
        &Shiboken::callCppDestructor< ::PageFormData >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_PageFormData_Type);
    InitSignatureStrings(pyType, PageFormData_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_PageFormData_Type), Sbk_PageFormData_PropertyStrings);
    SbkPyFalkonTypes[SBK_PAGEFORMDATA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_PageFormData_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_PageFormData_TypeF(),
        PageFormData_PythonToCpp_PageFormData_PTR,
        is_PageFormData_PythonToCpp_PageFormData_PTR_Convertible,
        PageFormData_PTR_CppToPython_PageFormData,
        PageFormData_COPY_CppToPython_PageFormData);

    Shiboken::Conversions::registerConverterName(converter, "PageFormData");
    Shiboken::Conversions::registerConverterName(converter, "PageFormData*");
    Shiboken::Conversions::registerConverterName(converter, "PageFormData&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PageFormData).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PageFormData_PythonToCpp_PageFormData_COPY,
        is_PageFormData_PythonToCpp_PageFormData_COPY_Convertible);


    qRegisterMetaType< ::PageFormData >("PageFormData");
}
