
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "passwordentry_wrapper.h"

// inner classes

// Extra includes
#include <passwordmanager.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PasswordEntry_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PasswordEntry >()))
        return -1;

    ::PasswordEntry *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordEntry.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "PasswordEntry", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: PasswordEntry::PasswordEntry()
    // 1: PasswordEntry::PasswordEntry(PasswordEntry)
    if (numArgs == 0) {
        overloadId = 0; // PasswordEntry()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // PasswordEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_PasswordEntry_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // PasswordEntry()
        {

            if (!PyErr_Occurred()) {
                // PasswordEntry()
                cptr = new ::PasswordEntry();
            }
            break;
        }
        case 1: // PasswordEntry(const PasswordEntry & PasswordEntry)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::PasswordEntry cppArg0_local;
            ::PasswordEntry *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // PasswordEntry(PasswordEntry)
                cptr = new ::PasswordEntry(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::PasswordEntry >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_PasswordEntry_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_PasswordEntry_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_PasswordEntryFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.PasswordEntry.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::PasswordEntry *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_PasswordEntry___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_PasswordEntry_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_PasswordEntry_methods[] = {
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_PasswordEntryFunc_isValid), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_PasswordEntry___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_PasswordEntry_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), (pyArg)))) {
                // operator<(const PasswordEntry & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::PasswordEntry cppArg0_local;
                ::PasswordEntry *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_PasswordEntry_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), (pyArg)))) {
                // operator==(const PasswordEntry & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::PasswordEntry cppArg0_local;
                ::PasswordEntry *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_PasswordEntry_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_PasswordEntry_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

static PyObject *Sbk_PasswordEntry_get_id(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppSelf->id);
    return pyOut;
}
static int Sbk_PasswordEntry_set_id(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'id' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'id', 'QVariant' or convertible type expected");
        return -1;
    }

    ::QVariant& cppOut_ptr = cppSelf->id;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PasswordEntry_get_host(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->host);
    return pyOut;
}
static int Sbk_PasswordEntry_set_host(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'host' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'host', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->host;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PasswordEntry_get_username(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->username);
    return pyOut;
}
static int Sbk_PasswordEntry_set_username(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'username' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'username', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->username;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PasswordEntry_get_password(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->password);
    return pyOut;
}
static int Sbk_PasswordEntry_set_password(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'password' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'password', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->password;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PasswordEntry_get_data(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->data)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->data))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->data)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &(cppSelf->data), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_PasswordEntry_set_data(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'data' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'data', 'QByteArray' or convertible type expected");
        return -1;
    }

    ::QByteArray& cppOut_ptr = cppSelf->data;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PasswordEntry_get_updated(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->updated;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_PasswordEntry_set_updated(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'updated' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'updated', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->updated;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->updated = cppOut_local;

    return 0;
}

// Getters and Setters for PasswordEntry
static PyGetSetDef Sbk_PasswordEntry_getsetlist[] = {
    {const_cast<char *>("id"), Sbk_PasswordEntry_get_id, Sbk_PasswordEntry_set_id},
    {const_cast<char *>("host"), Sbk_PasswordEntry_get_host, Sbk_PasswordEntry_set_host},
    {const_cast<char *>("username"), Sbk_PasswordEntry_get_username, Sbk_PasswordEntry_set_username},
    {const_cast<char *>("password"), Sbk_PasswordEntry_get_password, Sbk_PasswordEntry_set_password},
    {const_cast<char *>("data"), Sbk_PasswordEntry_get_data, Sbk_PasswordEntry_set_data},
    {const_cast<char *>("updated"), Sbk_PasswordEntry_get_updated, Sbk_PasswordEntry_set_updated},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_PasswordEntry_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_PasswordEntry_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_PasswordEntry_Type = nullptr;
static SbkObjectType *Sbk_PasswordEntry_TypeF(void)
{
    return _Sbk_PasswordEntry_Type;
}

static PyType_Slot Sbk_PasswordEntry_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PasswordEntry_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PasswordEntry_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_PasswordEntry_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PasswordEntry_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_PasswordEntry_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PasswordEntry_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_PasswordEntry_spec = {
    "1:PyFalkon.PasswordEntry",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_PasswordEntry_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PasswordEntry_PythonToCpp_PasswordEntry_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_PasswordEntry_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PasswordEntry_PythonToCpp_PasswordEntry_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_PasswordEntry_TypeF())))
        return PasswordEntry_PythonToCpp_PasswordEntry_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PasswordEntry_PTR_CppToPython_PasswordEntry(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::PasswordEntry *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_PasswordEntry_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *PasswordEntry_COPY_CppToPython_PasswordEntry(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_PasswordEntry_TypeF(), new ::PasswordEntry(*reinterpret_cast<const ::PasswordEntry *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void PasswordEntry_PythonToCpp_PasswordEntry_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::PasswordEntry *>(cppOut) = *reinterpret_cast< ::PasswordEntry *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_PasswordEntry_PythonToCpp_PasswordEntry_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_PasswordEntry_TypeF())))
        return PasswordEntry_PythonToCpp_PasswordEntry_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *PasswordEntry_SignatureStrings[] = {
    "1:PyFalkon.PasswordEntry(self)",
    "0:PyFalkon.PasswordEntry(self,PasswordEntry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordEntry.isValid(self)->bool",
    "PyFalkon.PasswordEntry.__copy__()",
    nullptr}; // Sentinel

void init_PasswordEntry(PyObject *module)
{
    _Sbk_PasswordEntry_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PasswordEntry",
        "PasswordEntry",
        &Sbk_PasswordEntry_spec,
        &Shiboken::callCppDestructor< ::PasswordEntry >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_PasswordEntry_Type);
    InitSignatureStrings(pyType, PasswordEntry_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_PasswordEntry_Type), Sbk_PasswordEntry_PropertyStrings);
    SbkPyFalkonTypes[SBK_PASSWORDENTRY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_PasswordEntry_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_PasswordEntry_TypeF(),
        PasswordEntry_PythonToCpp_PasswordEntry_PTR,
        is_PasswordEntry_PythonToCpp_PasswordEntry_PTR_Convertible,
        PasswordEntry_PTR_CppToPython_PasswordEntry,
        PasswordEntry_COPY_CppToPython_PasswordEntry);

    Shiboken::Conversions::registerConverterName(converter, "PasswordEntry");
    Shiboken::Conversions::registerConverterName(converter, "PasswordEntry*");
    Shiboken::Conversions::registerConverterName(converter, "PasswordEntry&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PasswordEntry).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PasswordEntry_PythonToCpp_PasswordEntry_COPY,
        is_PasswordEntry_PythonToCpp_PasswordEntry_COPY_Convertible);


    qRegisterMetaType< ::PasswordEntry >("PasswordEntry");
}
