
/* Copyright © 2015-2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* This file generated from vk_entrypoints_gen.py, don't edit directly. */

#include "vk_common_entrypoints.h"

/* Weak aliases for all potential implementations. These will resolve to
 * NULL if they're not defined, which lets the resolve_entrypoint() function
 * either pick the correct entry point.
 *
 * MSVC uses different decorated names for 32-bit versus 64-bit. Declare
 * all argument sizes for 32-bit because computing the actual size would be
 * difficult.
 */




#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateInstance@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateInstance=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateInstance(const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyInstance@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyInstance=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyInstance(VkInstance instance, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDevices@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_EnumeratePhysicalDevices=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_EnumeratePhysicalDevices(VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetInstanceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetInstanceProcAddr=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL vk_common_GetInstanceProcAddr(VkInstance instance, const char* pName) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceVersion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_EnumerateInstanceVersion=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_EnumerateInstanceVersion(uint32_t* pApiVersion) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceLayerProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_EnumerateInstanceLayerProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_EnumerateInstanceLayerProperties(uint32_t* pPropertyCount, VkLayerProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateInstanceExtensionProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_EnumerateInstanceExtensionProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_EnumerateInstanceExtensionProperties(const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAndroidSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateAndroidSurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateAndroidSurfaceKHR(VkInstance instance, const VkAndroidSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayPlaneSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateDisplayPlaneSurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateDisplayPlaneSurfaceKHR(VkInstance instance, const VkDisplaySurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroySurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroySurfaceKHR(VkInstance instance, VkSurfaceKHR surface, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_VI_NN
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateViSurfaceNN@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateViSurfaceNN=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateViSurfaceNN(VkInstance instance, const VkViSurfaceCreateInfoNN* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_VI_NN
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWaylandSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateWaylandSurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateWaylandSurfaceKHR(VkInstance instance, const VkWaylandSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateWin32SurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateWin32SurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateWin32SurfaceKHR(VkInstance instance, const VkWin32SurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXlibSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateXlibSurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateXlibSurfaceKHR(VkInstance instance, const VkXlibSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateXcbSurfaceKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateXcbSurfaceKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateXcbSurfaceKHR(VkInstance instance, const VkXcbSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDirectFBSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateDirectFBSurfaceEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateDirectFBSurfaceEXT(VkInstance instance, const VkDirectFBSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImagePipeSurfaceFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateImagePipeSurfaceFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateImagePipeSurfaceFUCHSIA(VkInstance instance, const VkImagePipeSurfaceCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_GGP
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateStreamDescriptorSurfaceGGP@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateStreamDescriptorSurfaceGGP=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateStreamDescriptorSurfaceGGP(VkInstance instance, const VkStreamDescriptorSurfaceCreateInfoGGP* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_GGP
#ifdef VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateScreenSurfaceQNX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateScreenSurfaceQNX=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateScreenSurfaceQNX(VkInstance instance, const VkScreenSurfaceCreateInfoQNX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugReportCallbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateDebugReportCallbackEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateDebugReportCallbackEXT(VkInstance instance, const VkDebugReportCallbackCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugReportCallbackEXT* pCallback) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugReportCallbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyDebugReportCallbackEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyDebugReportCallbackEXT(VkInstance instance, VkDebugReportCallbackEXT callback, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugReportMessageEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DebugReportMessageEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DebugReportMessageEXT(VkInstance instance, VkDebugReportFlagsEXT flags, VkDebugReportObjectTypeEXT objectType, uint64_t object, size_t location, int32_t messageCode, const char* pLayerPrefix, const char* pMessage) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroups@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_EnumeratePhysicalDeviceGroups=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_EnumeratePhysicalDeviceGroups(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceGroupsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_EnumeratePhysicalDeviceGroupsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_EnumeratePhysicalDeviceGroupsKHR(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_IOS_MVK
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIOSSurfaceMVK@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateIOSSurfaceMVK=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateIOSSurfaceMVK(VkInstance instance, const VkIOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMacOSSurfaceMVK@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateMacOSSurfaceMVK=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateMacOSSurfaceMVK(VkInstance instance, const VkMacOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_MACOS_MVK
#ifdef VK_USE_PLATFORM_METAL_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateMetalSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateMetalSurfaceEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateMetalSurfaceEXT(VkInstance instance, const VkMetalSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_METAL_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDebugUtilsMessengerEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateDebugUtilsMessengerEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateDebugUtilsMessengerEXT(VkInstance instance, const VkDebugUtilsMessengerCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugUtilsMessengerEXT* pMessenger) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDebugUtilsMessengerEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyDebugUtilsMessengerEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyDebugUtilsMessengerEXT(VkInstance instance, VkDebugUtilsMessengerEXT messenger, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SubmitDebugUtilsMessageEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_SubmitDebugUtilsMessageEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_SubmitDebugUtilsMessageEXT(VkInstance instance, VkDebugUtilsMessageSeverityFlagBitsEXT messageSeverity, VkDebugUtilsMessageTypeFlagsEXT messageTypes, const VkDebugUtilsMessengerCallbackDataEXT* pCallbackData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateHeadlessSurfaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateHeadlessSurfaceEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateHeadlessSurfaceEXT(VkInstance instance, const VkHeadlessSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) __attribute__ ((weak));
#endif

const struct vk_instance_entrypoint_table vk_common_instance_entrypoints = {
    .CreateInstance = vk_common_CreateInstance,
    .DestroyInstance = vk_common_DestroyInstance,
    .EnumeratePhysicalDevices = vk_common_EnumeratePhysicalDevices,
    .GetInstanceProcAddr = vk_common_GetInstanceProcAddr,
    .EnumerateInstanceVersion = vk_common_EnumerateInstanceVersion,
    .EnumerateInstanceLayerProperties = vk_common_EnumerateInstanceLayerProperties,
    .EnumerateInstanceExtensionProperties = vk_common_EnumerateInstanceExtensionProperties,
#ifdef VK_USE_PLATFORM_ANDROID_KHR
    .CreateAndroidSurfaceKHR = vk_common_CreateAndroidSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateAndroidSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_ANDROID_KHR
    .CreateDisplayPlaneSurfaceKHR = vk_common_CreateDisplayPlaneSurfaceKHR,
    .DestroySurfaceKHR = vk_common_DestroySurfaceKHR,
#ifdef VK_USE_PLATFORM_VI_NN
    .CreateViSurfaceNN = vk_common_CreateViSurfaceNN,
#elif defined(_MSC_VER)
    .CreateViSurfaceNN = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_VI_NN
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
    .CreateWaylandSurfaceKHR = vk_common_CreateWaylandSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateWaylandSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .CreateWin32SurfaceKHR = vk_common_CreateWin32SurfaceKHR,
#elif defined(_MSC_VER)
    .CreateWin32SurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
    .CreateXlibSurfaceKHR = vk_common_CreateXlibSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateXlibSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
    .CreateXcbSurfaceKHR = vk_common_CreateXcbSurfaceKHR,
#elif defined(_MSC_VER)
    .CreateXcbSurfaceKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    .CreateDirectFBSurfaceEXT = vk_common_CreateDirectFBSurfaceEXT,
#elif defined(_MSC_VER)
    .CreateDirectFBSurfaceEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_FUCHSIA
    .CreateImagePipeSurfaceFUCHSIA = vk_common_CreateImagePipeSurfaceFUCHSIA,
#elif defined(_MSC_VER)
    .CreateImagePipeSurfaceFUCHSIA = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_GGP
    .CreateStreamDescriptorSurfaceGGP = vk_common_CreateStreamDescriptorSurfaceGGP,
#elif defined(_MSC_VER)
    .CreateStreamDescriptorSurfaceGGP = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_GGP
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    .CreateScreenSurfaceQNX = vk_common_CreateScreenSurfaceQNX,
#elif defined(_MSC_VER)
    .CreateScreenSurfaceQNX = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_SCREEN_QNX
    .CreateDebugReportCallbackEXT = vk_common_CreateDebugReportCallbackEXT,
    .DestroyDebugReportCallbackEXT = vk_common_DestroyDebugReportCallbackEXT,
    .DebugReportMessageEXT = vk_common_DebugReportMessageEXT,
    .EnumeratePhysicalDeviceGroups = vk_common_EnumeratePhysicalDeviceGroups,
    .EnumeratePhysicalDeviceGroupsKHR = vk_common_EnumeratePhysicalDeviceGroupsKHR,
#ifdef VK_USE_PLATFORM_IOS_MVK
    .CreateIOSSurfaceMVK = vk_common_CreateIOSSurfaceMVK,
#elif defined(_MSC_VER)
    .CreateIOSSurfaceMVK = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
    .CreateMacOSSurfaceMVK = vk_common_CreateMacOSSurfaceMVK,
#elif defined(_MSC_VER)
    .CreateMacOSSurfaceMVK = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_MACOS_MVK
#ifdef VK_USE_PLATFORM_METAL_EXT
    .CreateMetalSurfaceEXT = vk_common_CreateMetalSurfaceEXT,
#elif defined(_MSC_VER)
    .CreateMetalSurfaceEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_METAL_EXT
    .CreateDebugUtilsMessengerEXT = vk_common_CreateDebugUtilsMessengerEXT,
    .DestroyDebugUtilsMessengerEXT = vk_common_DestroyDebugUtilsMessengerEXT,
    .SubmitDebugUtilsMessageEXT = vk_common_SubmitDebugUtilsMessageEXT,
    .CreateHeadlessSurfaceEXT = vk_common_CreateHeadlessSurfaceEXT,
};


#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceQueueFamilyProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceMemoryProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceFeatures=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceFormatProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceImageFormatProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateDevice=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateDevice(VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceLayerProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_EnumerateDeviceLayerProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_EnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumerateDeviceExtensionProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_EnumerateDeviceExtensionProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_EnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSparseImageFormatProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceDisplayPropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPropertiesKHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlanePropertiesKHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneSupportedDisplaysKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDisplayPlaneSupportedDisplaysKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, uint32_t planeIndex, uint32_t* pDisplayCount, VkDisplayKHR* pDisplays) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDisplayModePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModePropertiesKHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDisplayModeKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateDisplayModeKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateDisplayModeKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, const VkDisplayModeCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDisplayModeKHR* pMode) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDisplayPlaneCapabilitiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkDisplayModeKHR mode, uint32_t planeIndex, VkDisplayPlaneCapabilitiesKHR* pCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSurfaceSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, VkSurfaceKHR surface, VkBool32* pSupported) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilitiesKHR* pSurfaceCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormatsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSurfaceFormatsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pSurfaceFormatCount, VkSurfaceFormatKHR* pSurfaceFormats) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSurfacePresentModesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct wl_display* display) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceWin32PresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceWin32PresentationSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vk_common_GetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXlibPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceXlibPresentationSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vk_common_GetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, Display* dpy, VisualID visualID) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceXcbPresentationSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceXcbPresentationSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vk_common_GetPhysicalDeviceXcbPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, xcb_connection_t* connection, xcb_visualid_t visual_id) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, IDirectFB* dfb) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceScreenPresentationSupportQNX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceScreenPresentationSupportQNX=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkBool32 VKAPI_CALL vk_common_GetPhysicalDeviceScreenPresentationSupportQNX(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct _screen_window* window) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_SCREEN_QNX
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkExternalMemoryHandleTypeFlagsNV externalHandleType, VkExternalImageFormatPropertiesNV* pExternalImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceFeatures2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFeatures2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceFeatures2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceFeatures2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceFormatProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceFormatProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceFormatProperties2KHR(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceImageFormatProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceImageFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceImageFormatProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceQueueFamilyProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceMemoryProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMemoryProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceMemoryProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceMemoryProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSparseImageFormatProperties2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceExternalBufferProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphoreProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceExternalSemaphoreProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceExternalSemaphoreProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFenceProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceExternalFenceProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceExternalFencePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceExternalFencePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceExternalFencePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ReleaseDisplayEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ReleaseDisplayEXT(VkPhysicalDevice physicalDevice, VkDisplayKHR display) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireXlibDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AcquireXlibDisplayEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AcquireXlibDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, VkDisplayKHR display) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRandROutputDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetRandROutputDisplayEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, RROutput rrOutput, VkDisplayKHR* pDisplay) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireWinrtDisplayNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AcquireWinrtDisplayNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AcquireWinrtDisplayNV(VkPhysicalDevice physicalDevice, VkDisplayKHR display) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetWinrtDisplayNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetWinrtDisplayNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetWinrtDisplayNV(VkPhysicalDevice physicalDevice, uint32_t deviceRelativeId, VkDisplayKHR* pDisplay) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilities2EXT* pSurfaceCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDevicePresentRectanglesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDevicePresentRectanglesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pRectCount, VkRect2D* pRects) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceMultisamplePropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceMultisamplePropertiesEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceMultisamplePropertiesEXT(VkPhysicalDevice physicalDevice, VkSampleCountFlagBits samples, VkMultisamplePropertiesEXT* pMultisampleProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkSurfaceCapabilities2KHR* pSurfaceCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfaceFormats2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSurfaceFormats2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceSurfaceFormats2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pSurfaceFormatCount, VkSurfaceFormat2KHR* pSurfaceFormats) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceDisplayProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayProperties2KHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlaneProperties2KHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayModeProperties2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDisplayModeProperties2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModeProperties2KHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDisplayPlaneCapabilities2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDisplayPlaneCapabilities2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkDisplayPlaneInfo2KHR* pDisplayPlaneInfo, VkDisplayPlaneCapabilities2KHR* pCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainEXT* pTimeDomains) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesNV* pProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSurfacePresentModes2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSurfacePresentModes2EXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceSurfacePresentModes2EXT(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterKHR* pCounters, VkPerformanceCounterDescriptionKHR* pCounterDescriptions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(VkPhysicalDevice physicalDevice, const VkQueryPoolPerformanceCreateInfoKHR* pPerformanceQueryCreateInfo, uint32_t* pNumPasses) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(VkPhysicalDevice physicalDevice, uint32_t* pCombinationCount, VkFramebufferMixedSamplesCombinationNV* pCombinations) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolProperties@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceToolProperties=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceToolProperties(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceToolPropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceToolPropertiesEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceToolPropertiesEXT(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceFragmentShadingRatesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceFragmentShadingRatesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceFragmentShadingRatesKHR(VkPhysicalDevice physicalDevice, uint32_t* pFragmentShadingRateCount, VkPhysicalDeviceFragmentShadingRateKHR* pFragmentShadingRates) __attribute__ ((weak));
#endif
#ifdef VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceVideoCapabilitiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceVideoCapabilitiesKHR(VkPhysicalDevice physicalDevice, const VkVideoProfileKHR* pVideoProfile, VkVideoCapabilitiesKHR* pCapabilities) __attribute__ ((weak));
#endif
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoFormatInfoKHR* pVideoFormatInfo, uint32_t* pVideoFormatPropertyCount, VkVideoFormatPropertiesKHR* pVideoFormatProperties) __attribute__ ((weak));
#endif
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireDrmDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AcquireDrmDisplayEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AcquireDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, VkDisplayKHR display) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDrmDisplayEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDrmDisplayEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, uint32_t connectorId, VkDisplayKHR* display) __attribute__ ((weak));
#endif

const struct vk_physical_device_entrypoint_table vk_common_physical_device_entrypoints = {
    .GetPhysicalDeviceProperties = vk_common_GetPhysicalDeviceProperties,
    .GetPhysicalDeviceQueueFamilyProperties = vk_common_GetPhysicalDeviceQueueFamilyProperties,
    .GetPhysicalDeviceMemoryProperties = vk_common_GetPhysicalDeviceMemoryProperties,
    .GetPhysicalDeviceFeatures = vk_common_GetPhysicalDeviceFeatures,
    .GetPhysicalDeviceFormatProperties = vk_common_GetPhysicalDeviceFormatProperties,
    .GetPhysicalDeviceImageFormatProperties = vk_common_GetPhysicalDeviceImageFormatProperties,
    .CreateDevice = vk_common_CreateDevice,
    .EnumerateDeviceLayerProperties = vk_common_EnumerateDeviceLayerProperties,
    .EnumerateDeviceExtensionProperties = vk_common_EnumerateDeviceExtensionProperties,
    .GetPhysicalDeviceSparseImageFormatProperties = vk_common_GetPhysicalDeviceSparseImageFormatProperties,
    .GetPhysicalDeviceDisplayPropertiesKHR = vk_common_GetPhysicalDeviceDisplayPropertiesKHR,
    .GetPhysicalDeviceDisplayPlanePropertiesKHR = vk_common_GetPhysicalDeviceDisplayPlanePropertiesKHR,
    .GetDisplayPlaneSupportedDisplaysKHR = vk_common_GetDisplayPlaneSupportedDisplaysKHR,
    .GetDisplayModePropertiesKHR = vk_common_GetDisplayModePropertiesKHR,
    .CreateDisplayModeKHR = vk_common_CreateDisplayModeKHR,
    .GetDisplayPlaneCapabilitiesKHR = vk_common_GetDisplayPlaneCapabilitiesKHR,
    .GetPhysicalDeviceSurfaceSupportKHR = vk_common_GetPhysicalDeviceSurfaceSupportKHR,
    .GetPhysicalDeviceSurfaceCapabilitiesKHR = vk_common_GetPhysicalDeviceSurfaceCapabilitiesKHR,
    .GetPhysicalDeviceSurfaceFormatsKHR = vk_common_GetPhysicalDeviceSurfaceFormatsKHR,
    .GetPhysicalDeviceSurfacePresentModesKHR = vk_common_GetPhysicalDeviceSurfacePresentModesKHR,
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
    .GetPhysicalDeviceWaylandPresentationSupportKHR = vk_common_GetPhysicalDeviceWaylandPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceWaylandPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceWin32PresentationSupportKHR = vk_common_GetPhysicalDeviceWin32PresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceWin32PresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
    .GetPhysicalDeviceXlibPresentationSupportKHR = vk_common_GetPhysicalDeviceXlibPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceXlibPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
    .GetPhysicalDeviceXcbPresentationSupportKHR = vk_common_GetPhysicalDeviceXcbPresentationSupportKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceXcbPresentationSupportKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
    .GetPhysicalDeviceDirectFBPresentationSupportEXT = vk_common_GetPhysicalDeviceDirectFBPresentationSupportEXT,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceDirectFBPresentationSupportEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
    .GetPhysicalDeviceScreenPresentationSupportQNX = vk_common_GetPhysicalDeviceScreenPresentationSupportQNX,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceScreenPresentationSupportQNX = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_SCREEN_QNX
    .GetPhysicalDeviceExternalImageFormatPropertiesNV = vk_common_GetPhysicalDeviceExternalImageFormatPropertiesNV,
    .GetPhysicalDeviceFeatures2 = vk_common_GetPhysicalDeviceFeatures2,
    .GetPhysicalDeviceFeatures2KHR = vk_common_GetPhysicalDeviceFeatures2KHR,
    .GetPhysicalDeviceProperties2 = vk_common_GetPhysicalDeviceProperties2,
    .GetPhysicalDeviceProperties2KHR = vk_common_GetPhysicalDeviceProperties2KHR,
    .GetPhysicalDeviceFormatProperties2 = vk_common_GetPhysicalDeviceFormatProperties2,
    .GetPhysicalDeviceFormatProperties2KHR = vk_common_GetPhysicalDeviceFormatProperties2KHR,
    .GetPhysicalDeviceImageFormatProperties2 = vk_common_GetPhysicalDeviceImageFormatProperties2,
    .GetPhysicalDeviceImageFormatProperties2KHR = vk_common_GetPhysicalDeviceImageFormatProperties2KHR,
    .GetPhysicalDeviceQueueFamilyProperties2 = vk_common_GetPhysicalDeviceQueueFamilyProperties2,
    .GetPhysicalDeviceQueueFamilyProperties2KHR = vk_common_GetPhysicalDeviceQueueFamilyProperties2KHR,
    .GetPhysicalDeviceMemoryProperties2 = vk_common_GetPhysicalDeviceMemoryProperties2,
    .GetPhysicalDeviceMemoryProperties2KHR = vk_common_GetPhysicalDeviceMemoryProperties2KHR,
    .GetPhysicalDeviceSparseImageFormatProperties2 = vk_common_GetPhysicalDeviceSparseImageFormatProperties2,
    .GetPhysicalDeviceSparseImageFormatProperties2KHR = vk_common_GetPhysicalDeviceSparseImageFormatProperties2KHR,
    .GetPhysicalDeviceExternalBufferProperties = vk_common_GetPhysicalDeviceExternalBufferProperties,
    .GetPhysicalDeviceExternalBufferPropertiesKHR = vk_common_GetPhysicalDeviceExternalBufferPropertiesKHR,
    .GetPhysicalDeviceExternalSemaphoreProperties = vk_common_GetPhysicalDeviceExternalSemaphoreProperties,
    .GetPhysicalDeviceExternalSemaphorePropertiesKHR = vk_common_GetPhysicalDeviceExternalSemaphorePropertiesKHR,
    .GetPhysicalDeviceExternalFenceProperties = vk_common_GetPhysicalDeviceExternalFenceProperties,
    .GetPhysicalDeviceExternalFencePropertiesKHR = vk_common_GetPhysicalDeviceExternalFencePropertiesKHR,
    .ReleaseDisplayEXT = vk_common_ReleaseDisplayEXT,
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .AcquireXlibDisplayEXT = vk_common_AcquireXlibDisplayEXT,
#elif defined(_MSC_VER)
    .AcquireXlibDisplayEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
    .GetRandROutputDisplayEXT = vk_common_GetRandROutputDisplayEXT,
#elif defined(_MSC_VER)
    .GetRandROutputDisplayEXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .AcquireWinrtDisplayNV = vk_common_AcquireWinrtDisplayNV,
#elif defined(_MSC_VER)
    .AcquireWinrtDisplayNV = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetWinrtDisplayNV = vk_common_GetWinrtDisplayNV,
#elif defined(_MSC_VER)
    .GetWinrtDisplayNV = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceSurfaceCapabilities2EXT = vk_common_GetPhysicalDeviceSurfaceCapabilities2EXT,
    .GetPhysicalDevicePresentRectanglesKHR = vk_common_GetPhysicalDevicePresentRectanglesKHR,
    .GetPhysicalDeviceMultisamplePropertiesEXT = vk_common_GetPhysicalDeviceMultisamplePropertiesEXT,
    .GetPhysicalDeviceSurfaceCapabilities2KHR = vk_common_GetPhysicalDeviceSurfaceCapabilities2KHR,
    .GetPhysicalDeviceSurfaceFormats2KHR = vk_common_GetPhysicalDeviceSurfaceFormats2KHR,
    .GetPhysicalDeviceDisplayProperties2KHR = vk_common_GetPhysicalDeviceDisplayProperties2KHR,
    .GetPhysicalDeviceDisplayPlaneProperties2KHR = vk_common_GetPhysicalDeviceDisplayPlaneProperties2KHR,
    .GetDisplayModeProperties2KHR = vk_common_GetDisplayModeProperties2KHR,
    .GetDisplayPlaneCapabilities2KHR = vk_common_GetDisplayPlaneCapabilities2KHR,
    .GetPhysicalDeviceCalibrateableTimeDomainsEXT = vk_common_GetPhysicalDeviceCalibrateableTimeDomainsEXT,
    .GetPhysicalDeviceCooperativeMatrixPropertiesNV = vk_common_GetPhysicalDeviceCooperativeMatrixPropertiesNV,
#ifdef VK_USE_PLATFORM_WIN32_KHR
    .GetPhysicalDeviceSurfacePresentModes2EXT = vk_common_GetPhysicalDeviceSurfacePresentModes2EXT,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceSurfacePresentModes2EXT = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_USE_PLATFORM_WIN32_KHR
    .EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR = vk_common_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR,
    .GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = vk_common_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR,
    .GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV = vk_common_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV,
    .GetPhysicalDeviceToolProperties = vk_common_GetPhysicalDeviceToolProperties,
    .GetPhysicalDeviceToolPropertiesEXT = vk_common_GetPhysicalDeviceToolPropertiesEXT,
    .GetPhysicalDeviceFragmentShadingRatesKHR = vk_common_GetPhysicalDeviceFragmentShadingRatesKHR,
#ifdef VK_ENABLE_BETA_EXTENSIONS
    .GetPhysicalDeviceVideoCapabilitiesKHR = vk_common_GetPhysicalDeviceVideoCapabilitiesKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceVideoCapabilitiesKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
    .GetPhysicalDeviceVideoFormatPropertiesKHR = vk_common_GetPhysicalDeviceVideoFormatPropertiesKHR,
#elif defined(_MSC_VER)
    .GetPhysicalDeviceVideoFormatPropertiesKHR = (PFN_vkVoidFunction)vk_entrypoint_stub,
#endif // VK_ENABLE_BETA_EXTENSIONS
    .AcquireDrmDisplayEXT = vk_common_AcquireDrmDisplayEXT,
    .GetDrmDisplayEXT = vk_common_GetDrmDisplayEXT,
};


#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceProcAddr@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceProcAddr=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL vk_common_GetDeviceProcAddr(VkDevice device, const char* pName) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDevice@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyDevice=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceQueue=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_QueueSubmit=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_QueueWaitIdle=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_QueueWaitIdle(VkQueue queue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeviceWaitIdle@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DeviceWaitIdle=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_DeviceWaitIdle(VkDevice device) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AllocateMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_FreeMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_MapMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UnmapMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_UnmapMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_UnmapMemory(VkDevice device, VkDeviceMemory memory) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FlushMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_FlushMappedMemoryRanges=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InvalidateMappedMemoryRanges@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_InvalidateMappedMemoryRanges=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryCommitment@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceMemoryCommitment=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetBufferMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_BindBufferMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetImageMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_BindImageMemory=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetImageSparseMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBindSparse@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_QueueBindSparse=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateFence=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFence@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyFence=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ResetFences=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetFenceStatus=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetFenceStatus(VkDevice device, VkFence fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitForFences@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_WaitForFences=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateSemaphore=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroySemaphore=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetEventStatus@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetEventStatus=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetEventStatus(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_SetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_SetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ResetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ResetEvent(VkDevice device, VkEvent event) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetQueryPoolResults=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ResetQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetQueryPoolEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ResetQueryPoolEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateBufferView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyBufferView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyBufferView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSubresourceLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetImageSubresourceLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateImageView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyImageView@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyImageView=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateShaderModule=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyShaderModule@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyShaderModule=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreatePipelineCache=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineCache@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyPipelineCache=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineCacheData@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPipelineCacheData=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergePipelineCaches@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_MergePipelineCaches=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateGraphicsPipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateGraphicsPipelines=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateComputePipelines@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateComputePipelines=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyPipeline=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreatePipelineLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPipelineLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyPipelineLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateSampler=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySampler@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroySampler=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateDescriptorSetLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorSetLayout@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyDescriptorSetLayout=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateDescriptorPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyDescriptorPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetDescriptorPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ResetDescriptorPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AllocateDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_FreeDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_UpdateDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateFramebuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyFramebuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyFramebuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRenderAreaGranularity@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetRenderAreaGranularity=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ResetCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AllocateCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AllocateCommandBuffers=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_FreeCommandBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_FreeCommandBuffers=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BeginCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_BeginCommandBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_EndCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_EndCommandBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_EndCommandBuffer(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ResetCommandBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ResetCommandBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipeline@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBindPipeline=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetViewport=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissor@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetScissor=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineWidth@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetLineWidth=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBias@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthBias=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetBlendConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetBlendConstants=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBounds@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthBounds=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilCompareMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetStencilCompareMask=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilWriteMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetStencilWriteMask=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilReference@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetStencilReference=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindDescriptorSets@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBindDescriptorSets=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindIndexBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBindIndexBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBindVertexBuffers=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDraw@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDraw=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexed@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawIndexed=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawMultiEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMultiIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawMultiIndexedEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawIndirect=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawIndexedIndirect=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatch@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDispatch=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchIndirect@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDispatchIndirect=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSubpassShadingHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSubpassShadingHUAWEI=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBlitImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyBufferToImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyImageToBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdUpdateBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdUpdateBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdFillBuffer@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdFillBuffer=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearColorImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdClearColorImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearDepthStencilImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdClearDepthStencilImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdClearAttachments@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdClearAttachments=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdResolveImage=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdResetEvent=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdWaitEvents=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdPipelineBarrier=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBeginQuery=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQuery@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdEndQuery=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBeginConditionalRenderingEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndConditionalRenderingEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdEndConditionalRenderingEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetQueryPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdResetQueryPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdWriteTimestamp=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyQueryPoolResults@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyQueryPoolResults=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushConstants@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdPushConstants=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBeginRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdNextSubpass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdEndRenderPass=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdEndRenderPass(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteCommands@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdExecuteCommands=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSharedSwapchainsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateSharedSwapchainsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateSwapchainKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySwapchainKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroySwapchainKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainImagesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetSwapchainImagesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImageKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AcquireNextImageKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueuePresentKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_QueuePresentKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectNameEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DebugMarkerSetObjectNameEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DebugMarkerSetObjectTagEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DebugMarkerSetObjectTagEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerBeginEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDebugMarkerBeginEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerEndEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDebugMarkerEndEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDebugMarkerInsertEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDebugMarkerInsertEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetMemoryWin32HandleNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory, VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdExecuteGeneratedCommandsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdExecuteGeneratedCommandsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdExecuteGeneratedCommandsNV(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPreprocessGeneratedCommandsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdPreprocessGeneratedCommandsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdPreprocessGeneratedCommandsNV(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindPipelineShaderGroupNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBindPipelineShaderGroupNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBindPipelineShaderGroupNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, uint32_t groupIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetGeneratedCommandsMemoryRequirementsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetGeneratedCommandsMemoryRequirementsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetGeneratedCommandsMemoryRequirementsNV(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateIndirectCommandsLayoutNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateIndirectCommandsLayoutNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateIndirectCommandsLayoutNV(VkDevice device, const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutNV* pIndirectCommandsLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyIndirectCommandsLayoutNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyIndirectCommandsLayoutNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyIndirectCommandsLayoutNV(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdPushDescriptorSetKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPool@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_TrimCommandPool=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_TrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_TrimCommandPoolKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_TrimCommandPoolKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_TrimCommandPoolKHR(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetMemoryWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryWin32HandlePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetMemoryWin32HandlePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetMemoryFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryFdPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetMemoryFdPropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd, VkMemoryFdPropertiesKHR* pMemoryFdProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetMemoryZirconHandleFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetMemoryZirconHandleFUCHSIA(VkDevice device, const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryZirconHandlePropertiesFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetMemoryZirconHandlePropertiesFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetMemoryZirconHandlePropertiesFUCHSIA(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle, VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryRemoteAddressNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetMemoryRemoteAddressNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetMemoryRemoteAddressNV(VkDevice device, const VkMemoryGetRemoteAddressInfoNV* pMemoryGetRemoteAddressInfo, VkRemoteAddressNV* pAddress) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetSemaphoreWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetSemaphoreWin32HandleKHR(VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ImportSemaphoreWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetSemaphoreFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ImportSemaphoreFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetSemaphoreZirconHandleFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportSemaphoreZirconHandleFUCHSIA@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ImportSemaphoreZirconHandleFUCHSIA=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ImportSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetFenceWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceWin32HandleKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ImportFenceWin32HandleKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ImportFenceWin32HandleKHR(VkDevice device, const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetFenceFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetFenceFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ImportFenceFdKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ImportFenceFdKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DisplayPowerControlEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DisplayPowerControlEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_DisplayPowerControlEXT(VkDevice device, VkDisplayKHR display, const VkDisplayPowerInfoEXT* pDisplayPowerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDeviceEventEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_RegisterDeviceEventEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_RegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_RegisterDisplayEventEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_RegisterDisplayEventEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_RegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display, const VkDisplayEventInfoEXT* pDisplayEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainCounterEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetSwapchainCounterEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain, VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeatures@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceGroupPeerMemoryFeatures=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPeerMemoryFeaturesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceGroupPeerMemoryFeaturesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_BindBufferMemory2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_BindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindBufferMemory2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_BindBufferMemory2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_BindBufferMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_BindImageMemory2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_BindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindImageMemory2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_BindImageMemory2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_BindImageMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMask@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDeviceMask=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDeviceMaskKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDeviceMaskKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, uint32_t deviceMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupPresentCapabilitiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceGroupPresentCapabilitiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceGroupSurfacePresentModesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface, VkDeviceGroupPresentModeFlagsKHR* pModes) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireNextImage2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AcquireNextImage2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo, uint32_t* pImageIndex) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBase@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDispatchBase=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDispatchBaseKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDispatchBaseKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDispatchBaseKHR(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateDescriptorUpdateTemplate=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateDescriptorUpdateTemplate(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDescriptorUpdateTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateDescriptorUpdateTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateDescriptorUpdateTemplateKHR(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyDescriptorUpdateTemplate=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDescriptorUpdateTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyDescriptorUpdateTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplate@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_UpdateDescriptorSetWithTemplate=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_UpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateDescriptorSetWithTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_UpdateDescriptorSetWithTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_UpdateDescriptorSetWithTemplateKHR(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPushDescriptorSetWithTemplateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdPushDescriptorSetWithTemplateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetHdrMetadataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_SetHdrMetadataEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_SetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains, const VkHdrMetadataEXT* pMetadata) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainStatusKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetSwapchainStatusKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRefreshCycleDurationGOOGLE@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetRefreshCycleDurationGOOGLE=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain, VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPastPresentationTimingGOOGLE@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPastPresentationTimingGOOGLE=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pPresentationTimingCount, VkPastPresentationTimingGOOGLE* pPresentationTimings) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWScalingNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetViewportWScalingNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportWScalingNV* pViewportWScalings) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDiscardRectangleEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDiscardRectangleEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle, uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetSampleLocationsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetSampleLocationsEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetBufferMemoryRequirements2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetBufferMemoryRequirements2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetBufferMemoryRequirements2KHR(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetImageMemoryRequirements2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetImageMemoryRequirements2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetImageMemoryRequirements2KHR(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetImageSparseMemoryRequirements2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageSparseMemoryRequirements2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetImageSparseMemoryRequirements2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetImageSparseMemoryRequirements2KHR(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceBufferMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceBufferMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceBufferMemoryRequirementsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceBufferMemoryRequirementsKHR(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceImageMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceImageMemoryRequirementsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceImageMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirements@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceImageSparseMemoryRequirements=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceImageSparseMemoryRequirementsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceImageSparseMemoryRequirementsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceImageSparseMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateSamplerYcbcrConversion=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateSamplerYcbcrConversionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateSamplerYcbcrConversionKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateSamplerYcbcrConversionKHR(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversion@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroySamplerYcbcrConversion=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroySamplerYcbcrConversionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroySamplerYcbcrConversionKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroySamplerYcbcrConversionKHR(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceQueue2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceQueue2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateValidationCacheEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateValidationCacheEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateValidationCacheEXT(VkDevice device, const VkValidationCacheCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkValidationCacheEXT* pValidationCache) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyValidationCacheEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyValidationCacheEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyValidationCacheEXT(VkDevice device, VkValidationCacheEXT validationCache, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetValidationCacheDataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetValidationCacheDataEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetValidationCacheDataEXT(VkDevice device, VkValidationCacheEXT validationCache, size_t* pDataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_MergeValidationCachesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_MergeValidationCachesEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_MergeValidationCachesEXT(VkDevice device, VkValidationCacheEXT dstCache, uint32_t srcCacheCount, const VkValidationCacheEXT* pSrcCaches) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupport@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDescriptorSetLayoutSupport=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDescriptorSetLayoutSupportKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDescriptorSetLayoutSupportKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDescriptorSetLayoutSupportKHR(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetSwapchainGrallocUsageANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetSwapchainGrallocUsageANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, int* grallocUsage) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSwapchainGrallocUsage2ANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetSwapchainGrallocUsage2ANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetSwapchainGrallocUsage2ANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage, uint64_t* grallocProducerUsage) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireImageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AcquireImageANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AcquireImageANDROID(VkDevice device, VkImage image, int nativeFenceFd, VkSemaphore semaphore, VkFence fence) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSignalReleaseImageANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_QueueSignalReleaseImageANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_QueueSignalReleaseImageANDROID(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int* pNativeFenceFd) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetShaderInfoAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetShaderInfoAMD=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetShaderInfoAMD(VkDevice device, VkPipeline pipeline, VkShaderStageFlagBits shaderStage, VkShaderInfoTypeAMD infoType, size_t* pInfoSize, void* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetLocalDimmingAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_SetLocalDimmingAMD=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_SetLocalDimmingAMD(VkDevice device, VkSwapchainKHR swapChain, VkBool32 localDimmingEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetCalibratedTimestampsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetCalibratedTimestampsEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetCalibratedTimestampsEXT(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoEXT* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectNameEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_SetDebugUtilsObjectNameEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_SetDebugUtilsObjectNameEXT(VkDevice device, const VkDebugUtilsObjectNameInfoEXT* pNameInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetDebugUtilsObjectTagEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_SetDebugUtilsObjectTagEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_SetDebugUtilsObjectTagEXT(VkDevice device, const VkDebugUtilsObjectTagInfoEXT* pTagInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueBeginDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_QueueBeginDebugUtilsLabelEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_QueueBeginDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueEndDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_QueueEndDebugUtilsLabelEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_QueueEndDebugUtilsLabelEXT(VkQueue queue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueInsertDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_QueueInsertDebugUtilsLabelEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_QueueInsertDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBeginDebugUtilsLabelEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdEndDebugUtilsLabelEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdEndDebugUtilsLabelEXT(VkCommandBuffer commandBuffer) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdInsertDebugUtilsLabelEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdInsertDebugUtilsLabelEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryHostPointerPropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetMemoryHostPointerPropertiesEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetMemoryHostPointerPropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHostPointer, VkMemoryHostPointerPropertiesEXT* pMemoryHostPointerProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarkerAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdWriteBufferMarkerAMD=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdWriteBufferMarkerAMD(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateRenderPass2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRenderPass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateRenderPass2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateRenderPass2KHR(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBeginRenderPass2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginRenderPass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBeginRenderPass2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBeginRenderPass2KHR(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdNextSubpass2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdNextSubpass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdNextSubpass2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdNextSubpass2KHR(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdEndRenderPass2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndRenderPass2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdEndRenderPass2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdEndRenderPass2KHR(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValue@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetSemaphoreCounterValue=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetSemaphoreCounterValueKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetSemaphoreCounterValueKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetSemaphoreCounterValueKHR(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphores@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_WaitSemaphores=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_WaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WaitSemaphoresKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_WaitSemaphoresKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_WaitSemaphoresKHR(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphore@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_SignalSemaphore=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_SignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SignalSemaphoreKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_SignalSemaphoreKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_SignalSemaphoreKHR(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAndroidHardwareBufferPropertiesANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetAndroidHardwareBufferPropertiesANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetAndroidHardwareBufferPropertiesANDROID(VkDevice device, const struct AHardwareBuffer* buffer, VkAndroidHardwareBufferPropertiesANDROID* pProperties) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetMemoryAndroidHardwareBufferANDROID@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetMemoryAndroidHardwareBufferANDROID=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetMemoryAndroidHardwareBufferANDROID(VkDevice device, const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo, struct AHardwareBuffer** pBuffer) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawIndirectCount=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawIndirectCountKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectCountAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawIndirectCountAMD=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawIndexedIndirectCount=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawIndexedIndirectCountKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawIndexedIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndexedIndirectCountAMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawIndexedIndirectCountAMD=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawIndexedIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCheckpointNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetCheckpointNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetCheckpointNV(VkCommandBuffer commandBuffer, const void* pCheckpointMarker) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointDataNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetQueueCheckpointDataNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetQueueCheckpointDataNV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointDataNV* pCheckpointData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindTransformFeedbackBuffersEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBindTransformFeedbackBuffersEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginTransformFeedbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBeginTransformFeedbackEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndTransformFeedbackEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdEndTransformFeedbackEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBeginQueryIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBeginQueryIndexedEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdEndQueryIndexedEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdEndQueryIndexedEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawIndirectByteCountEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawIndirectByteCountEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetExclusiveScissorNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetExclusiveScissorNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetExclusiveScissorNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkRect2D* pExclusiveScissors) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindShadingRateImageNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBindShadingRateImageNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBindShadingRateImageNV(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportShadingRatePaletteNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetViewportShadingRatePaletteNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetViewportShadingRatePaletteNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkShadingRatePaletteNV* pShadingRatePalettes) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCoarseSampleOrderNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetCoarseSampleOrderNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetCoarseSampleOrderNV(VkCommandBuffer commandBuffer, VkCoarseSampleOrderTypeNV sampleOrderType, uint32_t customSampleOrderCount, const VkCoarseSampleOrderCustomNV* pCustomSampleOrders) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawMeshTasksNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawMeshTasksNV(VkCommandBuffer commandBuffer, uint32_t taskCount, uint32_t firstTask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawMeshTasksIndirectNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawMeshTasksIndirectNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdDrawMeshTasksIndirectCountNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdDrawMeshTasksIndirectCountNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdDrawMeshTasksIndirectCountNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CompileDeferredNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CompileDeferredNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CompileDeferredNV(VkDevice device, VkPipeline pipeline, uint32_t shader) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateAccelerationStructureNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateAccelerationStructureNV(VkDevice device, const VkAccelerationStructureCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureNV* pAccelerationStructure) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindInvocationMaskHUAWEI@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBindInvocationMaskHUAWEI=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBindInvocationMaskHUAWEI(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyAccelerationStructureKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyAccelerationStructureKHR(VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyAccelerationStructureNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyAccelerationStructureNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureMemoryRequirementsNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetAccelerationStructureMemoryRequirementsNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetAccelerationStructureMemoryRequirementsNV(VkDevice device, const VkAccelerationStructureMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2KHR* pMemoryRequirements) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BindAccelerationStructureMemoryNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_BindAccelerationStructureMemoryNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_BindAccelerationStructureMemoryNV(VkDevice device, uint32_t bindInfoCount, const VkBindAccelerationStructureMemoryInfoNV* pBindInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyAccelerationStructureNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyAccelerationStructureNV(VkCommandBuffer commandBuffer, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkCopyAccelerationStructureModeKHR mode) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyAccelerationStructureKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CopyAccelerationStructureKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CopyAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyAccelerationStructureToMemoryKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyAccelerationStructureToMemoryKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyAccelerationStructureToMemoryKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyAccelerationStructureToMemoryKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CopyAccelerationStructureToMemoryKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CopyAccelerationStructureToMemoryKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyMemoryToAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyMemoryToAccelerationStructureKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyMemoryToAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CopyMemoryToAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CopyMemoryToAccelerationStructureKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CopyMemoryToAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdWriteAccelerationStructuresPropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdWriteAccelerationStructuresPropertiesKHR(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteAccelerationStructuresPropertiesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdWriteAccelerationStructuresPropertiesNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureNV* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructureNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBuildAccelerationStructureNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer, const VkAccelerationStructureInfoNV* pInfo, VkBuffer instanceData, VkDeviceSize instanceOffset, VkBool32 update, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkBuffer scratch, VkDeviceSize scratchOffset) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_WriteAccelerationStructuresPropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_WriteAccelerationStructuresPropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_WriteAccelerationStructuresPropertiesKHR(VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdTraceRaysKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdTraceRaysKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, uint32_t width, uint32_t height, uint32_t depth) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdTraceRaysNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdTraceRaysNV(VkCommandBuffer commandBuffer, VkBuffer raygenShaderBindingTableBuffer, VkDeviceSize raygenShaderBindingOffset, VkBuffer missShaderBindingTableBuffer, VkDeviceSize missShaderBindingOffset, VkDeviceSize missShaderBindingStride, VkBuffer hitShaderBindingTableBuffer, VkDeviceSize hitShaderBindingOffset, VkDeviceSize hitShaderBindingStride, VkBuffer callableShaderBindingTableBuffer, VkDeviceSize callableShaderBindingOffset, VkDeviceSize callableShaderBindingStride, uint32_t width, uint32_t height, uint32_t depth) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetRayTracingShaderGroupHandlesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetRayTracingShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupHandlesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetRayTracingShaderGroupHandlesNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetRayTracingShaderGroupHandlesNV(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetRayTracingCaptureReplayShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureHandleNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetAccelerationStructureHandleNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetAccelerationStructureHandleNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, size_t dataSize, void* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateRayTracingPipelinesNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateRayTracingPipelinesNV(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoNV* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateRayTracingPipelinesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateRayTracingPipelinesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateRayTracingPipelinesKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdTraceRaysIndirectKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdTraceRaysIndirectKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdTraceRaysIndirectKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, VkDeviceAddress indirectDeviceAddress) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceAccelerationStructureCompatibilityKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceAccelerationStructureCompatibilityKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetDeviceAccelerationStructureCompatibilityKHR(VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetRayTracingShaderGroupStackSizeKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetRayTracingShaderGroupStackSizeKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkDeviceSize VKAPI_CALL vk_common_GetRayTracingShaderGroupStackSizeKHR(VkDevice device, VkPipeline pipeline, uint32_t group, VkShaderGroupShaderKHR groupShader) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRayTracingPipelineStackSizeKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetRayTracingPipelineStackSizeKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetRayTracingPipelineStackSizeKHR(VkCommandBuffer commandBuffer, uint32_t pipelineStackSize) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewHandleNVX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetImageViewHandleNVX=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR uint32_t VKAPI_CALL vk_common_GetImageViewHandleNVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageViewAddressNVX@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetImageViewAddressNVX=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetImageViewAddressNVX(VkDevice device, VkImageView imageView, VkImageViewAddressPropertiesNVX* pProperties) __attribute__ ((weak));
#endif
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceGroupSurfacePresentModes2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceGroupSurfacePresentModes2EXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetDeviceGroupSurfacePresentModes2EXT(VkDevice device, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkDeviceGroupPresentModeFlagsKHR* pModes) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireFullScreenExclusiveModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AcquireFullScreenExclusiveModeEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AcquireFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseFullScreenExclusiveModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ReleaseFullScreenExclusiveModeEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ReleaseFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) __attribute__ ((weak));
#endif
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquireProfilingLockKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AcquireProfilingLockKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AcquireProfilingLockKHR(VkDevice device, const VkAcquireProfilingLockInfoKHR* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleaseProfilingLockKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ReleaseProfilingLockKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_ReleaseProfilingLockKHR(VkDevice device) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetImageDrmFormatModifierPropertiesEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetImageDrmFormatModifierPropertiesEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetImageDrmFormatModifierPropertiesEXT(VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddress@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetBufferOpaqueCaptureAddress=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL vk_common_GetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferOpaqueCaptureAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetBufferOpaqueCaptureAddressKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL vk_common_GetBufferOpaqueCaptureAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddress@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetBufferDeviceAddress=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL vk_common_GetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetBufferDeviceAddressKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL vk_common_GetBufferDeviceAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetBufferDeviceAddressEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetBufferDeviceAddressEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL vk_common_GetBufferDeviceAddressEXT(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_InitializePerformanceApiINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_InitializePerformanceApiINTEL=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_InitializePerformanceApiINTEL(VkDevice device, const VkInitializePerformanceApiInfoINTEL* pInitializeInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UninitializePerformanceApiINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_UninitializePerformanceApiINTEL=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_UninitializePerformanceApiINTEL(VkDevice device) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceMarkerINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetPerformanceMarkerINTEL=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CmdSetPerformanceMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceMarkerInfoINTEL* pMarkerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceStreamMarkerINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetPerformanceStreamMarkerINTEL=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CmdSetPerformanceStreamMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceStreamMarkerInfoINTEL* pMarkerInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPerformanceOverrideINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetPerformanceOverrideINTEL=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CmdSetPerformanceOverrideINTEL(VkCommandBuffer commandBuffer, const VkPerformanceOverrideInfoINTEL* pOverrideInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_AcquirePerformanceConfigurationINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_AcquirePerformanceConfigurationINTEL=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_AcquirePerformanceConfigurationINTEL(VkDevice device, const VkPerformanceConfigurationAcquireInfoINTEL* pAcquireInfo, VkPerformanceConfigurationINTEL* pConfiguration) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_ReleasePerformanceConfigurationINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_ReleasePerformanceConfigurationINTEL=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_ReleasePerformanceConfigurationINTEL(VkDevice device, VkPerformanceConfigurationINTEL configuration) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSetPerformanceConfigurationINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_QueueSetPerformanceConfigurationINTEL=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_QueueSetPerformanceConfigurationINTEL(VkQueue queue, VkPerformanceConfigurationINTEL configuration) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPerformanceParameterINTEL@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPerformanceParameterINTEL=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPerformanceParameterINTEL(VkDevice device, VkPerformanceParameterTypeINTEL parameter, VkPerformanceValueINTEL* pValue) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddress@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceMemoryOpaqueCaptureAddress=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL vk_common_GetDeviceMemoryOpaqueCaptureAddress(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR uint64_t VKAPI_CALL vk_common_GetDeviceMemoryOpaqueCaptureAddressKHR(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutablePropertiesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPipelineExecutablePropertiesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPipelineExecutablePropertiesKHR(VkDevice                        device, const VkPipelineInfoKHR*        pPipelineInfo, uint32_t* pExecutableCount, VkPipelineExecutablePropertiesKHR* pProperties) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableStatisticsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPipelineExecutableStatisticsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPipelineExecutableStatisticsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pStatisticCount, VkPipelineExecutableStatisticKHR* pStatistics) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPipelineExecutableInternalRepresentationsKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPipelineExecutableInternalRepresentationsKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetPipelineExecutableInternalRepresentationsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pInternalRepresentationCount, VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLineStippleEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetLineStippleEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetLineStippleEXT(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateAccelerationStructureKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateAccelerationStructureKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateAccelerationStructureKHR(VkDevice                                           device, const VkAccelerationStructureCreateInfoKHR*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkAccelerationStructureKHR*                        pAccelerationStructure) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBuildAccelerationStructuresKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBuildAccelerationStructuresKHR(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBuildAccelerationStructuresIndirectKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBuildAccelerationStructuresIndirectKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBuildAccelerationStructuresIndirectKHR(VkCommandBuffer                  commandBuffer, uint32_t                                           infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkDeviceAddress*             pIndirectDeviceAddresses, const uint32_t*                    pIndirectStrides, const uint32_t* const*             ppMaxPrimitiveCounts) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_BuildAccelerationStructuresKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_BuildAccelerationStructuresKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_BuildAccelerationStructuresKHR(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureDeviceAddressKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetAccelerationStructureDeviceAddressKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkDeviceAddress VKAPI_CALL vk_common_GetAccelerationStructureDeviceAddressKHR(VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateDeferredOperationKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateDeferredOperationKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateDeferredOperationKHR(VkDevice device, const VkAllocationCallbacks* pAllocator, VkDeferredOperationKHR* pDeferredOperation) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyDeferredOperationKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyDeferredOperationKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyDeferredOperationKHR(VkDevice device, VkDeferredOperationKHR operation, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationMaxConcurrencyKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeferredOperationMaxConcurrencyKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR uint32_t VKAPI_CALL vk_common_GetDeferredOperationMaxConcurrencyKHR(VkDevice device, VkDeferredOperationKHR operation) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetDeferredOperationResultKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetDeferredOperationResultKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_GetDeferredOperationResultKHR(VkDevice device, VkDeferredOperationKHR operation) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DeferredOperationJoinKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DeferredOperationJoinKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_DeferredOperationJoinKHR(VkDevice device, VkDeferredOperationKHR operation) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullMode@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetCullMode=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetCullModeEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetCullModeEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetCullModeEXT(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFace@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetFrontFace=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFrontFaceEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetFrontFaceEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetFrontFaceEXT(VkCommandBuffer commandBuffer, VkFrontFace frontFace) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopology@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetPrimitiveTopology=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveTopologyEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetPrimitiveTopologyEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetPrimitiveTopologyEXT(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetViewportWithCount=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetViewportWithCountEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetViewportWithCountEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCount@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetScissorWithCount=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetScissorWithCountEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetScissorWithCountEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBindVertexBuffers2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBindVertexBuffers2EXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBindVertexBuffers2EXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthTestEnable=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthTestEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthTestEnableEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthWriteEnable=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthWriteEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthWriteEnableEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthWriteEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthCompareOp=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthCompareOpEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthCompareOpEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthCompareOpEXT(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthBoundsTestEnable=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBoundsTestEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthBoundsTestEnableEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthBoundsTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetStencilTestEnable=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilTestEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetStencilTestEnableEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetStencilTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOp@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetStencilOp=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetStencilOpEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetStencilOpEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetStencilOpEXT(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPatchControlPointsEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetPatchControlPointsEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetPatchControlPointsEXT(VkCommandBuffer commandBuffer, uint32_t patchControlPoints) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetRasterizerDiscardEnable=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetRasterizerDiscardEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetRasterizerDiscardEnableEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetRasterizerDiscardEnableEXT(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthBiasEnable=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetDepthBiasEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetDepthBiasEnableEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetDepthBiasEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetLogicOpEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetLogicOpEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetLogicOpEXT(VkCommandBuffer commandBuffer, VkLogicOp logicOp) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnable@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetPrimitiveRestartEnable=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetPrimitiveRestartEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetPrimitiveRestartEnableEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetPrimitiveRestartEnableEXT(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlot@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreatePrivateDataSlot=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreatePrivateDataSlot(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreatePrivateDataSlotEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreatePrivateDataSlotEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreatePrivateDataSlotEXT(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlot@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyPrivateDataSlot=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyPrivateDataSlot(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyPrivateDataSlotEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyPrivateDataSlotEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyPrivateDataSlotEXT(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateData@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_SetPrivateData=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_SetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_SetPrivateDataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_SetPrivateDataEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_SetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateData@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPrivateData=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetPrivateDataEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetPrivateDataEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyBuffer2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyBuffer2(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBuffer2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyBuffer2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyImage2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyImage2(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImage2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyImage2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyImage2KHR(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBlitImage2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBlitImage2(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdBlitImage2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdBlitImage2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdBlitImage2KHR(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyBufferToImage2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyBufferToImage2(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyBufferToImage2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyBufferToImage2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyBufferToImage2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyImageToBuffer2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyImageToBuffer2(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdCopyImageToBuffer2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdCopyImageToBuffer2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdCopyImageToBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdResolveImage2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdResolveImage2(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResolveImage2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdResolveImage2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdResolveImage2KHR(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetFragmentShadingRateKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetFragmentShadingRateKHR(VkCommandBuffer           commandBuffer, const VkExtent2D*                           pFragmentSize, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetFragmentShadingRateEnumNV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetFragmentShadingRateEnumNV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetFragmentShadingRateEnumNV(VkCommandBuffer           commandBuffer, VkFragmentShadingRateNV                     shadingRate, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetAccelerationStructureBuildSizesKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetAccelerationStructureBuildSizesKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetAccelerationStructureBuildSizesKHR(VkDevice                                            device, VkAccelerationStructureBuildTypeKHR                 buildType, const VkAccelerationStructureBuildGeometryInfoKHR*  pBuildInfo, const uint32_t*  pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR*           pSizeInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetVertexInputEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetVertexInputEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetVertexInputEXT(VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetColorWriteEnableEXT@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetColorWriteEnableEXT=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetColorWriteEnableEXT(VkCommandBuffer       commandBuffer, uint32_t                                attachmentCount, const VkBool32*   pColorWriteEnables) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetEvent2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetEvent2(VkCommandBuffer                   commandBuffer, VkEvent                                             event, const VkDependencyInfo*                             pDependencyInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdSetEvent2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdSetEvent2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdSetEvent2KHR(VkCommandBuffer                   commandBuffer, VkEvent                                             event, const VkDependencyInfo*                             pDependencyInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdResetEvent2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdResetEvent2(VkCommandBuffer                   commandBuffer, VkEvent                                             event, VkPipelineStageFlags2               stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdResetEvent2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdResetEvent2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdResetEvent2KHR(VkCommandBuffer                   commandBuffer, VkEvent                                             event, VkPipelineStageFlags2               stageMask) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdWaitEvents2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdWaitEvents2(VkCommandBuffer                   commandBuffer, uint32_t                                            eventCount, const VkEvent*                     pEvents, const VkDependencyInfo*            pDependencyInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWaitEvents2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdWaitEvents2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdWaitEvents2KHR(VkCommandBuffer                   commandBuffer, uint32_t                                            eventCount, const VkEvent*                     pEvents, const VkDependencyInfo*            pDependencyInfos) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdPipelineBarrier2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdPipelineBarrier2(VkCommandBuffer                   commandBuffer, const VkDependencyInfo*                             pDependencyInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdPipelineBarrier2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdPipelineBarrier2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdPipelineBarrier2KHR(VkCommandBuffer                   commandBuffer, const VkDependencyInfo*                             pDependencyInfo) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_QueueSubmit2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_QueueSubmit2(VkQueue                           queue, uint32_t                            submitCount, const VkSubmitInfo2*              pSubmits, VkFence           fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_QueueSubmit2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_QueueSubmit2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_QueueSubmit2KHR(VkQueue                           queue, uint32_t                            submitCount, const VkSubmitInfo2*              pSubmits, VkFence           fence) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdWriteTimestamp2=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdWriteTimestamp2(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkQueryPool                                         queryPool, uint32_t                                            query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteTimestamp2KHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdWriteTimestamp2KHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdWriteTimestamp2KHR(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkQueryPool                                         queryPool, uint32_t                                            query) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CmdWriteBufferMarker2AMD@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CmdWriteBufferMarker2AMD=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_CmdWriteBufferMarker2AMD(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkBuffer                                            dstBuffer, VkDeviceSize                                        dstOffset, uint32_t                                            marker) __attribute__ ((weak));
#endif
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_GetQueueCheckpointData2NV@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_GetQueueCheckpointData2NV=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_GetQueueCheckpointData2NV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointData2NV* pCheckpointData) __attribute__ ((weak));
#endif
#ifdef VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateVideoSessionKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateVideoSessionKHR(VkDevice device, const VkVideoSessionCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionKHR* pVideoSession) __attribute__ ((weak));
#endif
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_DestroyVideoSessionKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR void VKAPI_CALL vk_common_DestroyVideoSessionKHR(VkDevice device, VkVideoSessionKHR videoSession, const VkAllocationCallbacks* pAllocator) __attribute__ ((weak));
#endif
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_CreateVideoSessionParametersKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_CreateVideoSessionParametersKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_CreateVideoSessionParametersKHR(VkDevice device, const VkVideoSessionParametersCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionParametersKHR* pVideoSessionParameters) __attribute__ ((weak));
#endif
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@16=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@20=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@24=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@28=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@32=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@36=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@40=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@44=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@48=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@60=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_UpdateVideoSessionParametersKHR@104=_vk_entrypoint_stub@0")
#else
    #pragma comment(linker, "/alternatename:vk_common_UpdateVideoSessionParametersKHR=vk_entrypoint_stub")
#endif
#else
    VKAPI_ATTR VkResult VKAPI_CALL vk_common_UpdateVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkVideoSessionParametersUpdateInfoKHR* pUpdateInfo) __attribute__ ((weak));
#endif
#endif // VK_ENABLE_BETA_EXTENSIONS
#ifdef VK_ENABLE_BETA_EXTENSIONS
#ifdef _MSC_VER
#ifdef _M_IX86
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionParametersKHR@4=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionParametersKHR@8=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk_common_DestroyVideoSessionParametersKHR@12=_vk_entrypoint_stub@0")
    #pragma comment(linker, "/alternatename:_vk