/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObjectInfoMBean;

public class DefaultPooledObjectInfo
implements DefaultPooledObjectInfoMBean {
    private static final String PATTERN = "yyyy-MM-dd HH:mm:ss Z";
    private final PooledObject<?> pooledObject;

    public DefaultPooledObjectInfo(PooledObject<?> pooledObject) {
        this.pooledObject = pooledObject;
    }

    @Override
    public long getBorrowedCount() {
        return this.pooledObject.getBorrowedCount();
    }

    @Override
    public long getCreateTime() {
        return this.pooledObject.getCreateInstant().toEpochMilli();
    }

    @Override
    public String getCreateTimeFormatted() {
        return this.getTimeMillisFormatted(this.getCreateTime());
    }

    @Override
    public long getLastBorrowTime() {
        return this.pooledObject.getLastBorrowInstant().toEpochMilli();
    }

    @Override
    public String getLastBorrowTimeFormatted() {
        return this.getTimeMillisFormatted(this.getLastBorrowTime());
    }

    @Override
    public String getLastBorrowTrace() {
        StringWriter stringWriter = new StringWriter();
        this.pooledObject.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Override
    public long getLastReturnTime() {
        return this.pooledObject.getLastReturnInstant().toEpochMilli();
    }

    @Override
    public String getLastReturnTimeFormatted() {
        return this.getTimeMillisFormatted(this.getLastReturnTime());
    }

    @Override
    public String getPooledObjectToString() {
        return this.pooledObject.getObject().toString();
    }

    @Override
    public String getPooledObjectType() {
        return this.pooledObject.getObject().getClass().getName();
    }

    private String getTimeMillisFormatted(long l) {
        return new SimpleDateFormat(PATTERN).format(l);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DefaultPooledObjectInfo [pooledObject=");
        stringBuilder.append(this.pooledObject);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

