/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.rules;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.FileType;
import org.islandoftex.arara.api.rules.Directive;
import org.islandoftex.arara.api.rules.DirectiveConditionalType;
import org.islandoftex.arara.core.files.FileHandling;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.rules.DirectiveAssembler;
import org.islandoftex.arara.core.rules.DirectiveConditional;
import org.islandoftex.arara.core.rules.DirectiveFetchingHooks;
import org.islandoftex.arara.core.rules.Directives;
import org.islandoftex.arara.core.rules.DirectivesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0015\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ2\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00060 2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J2\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010#\u001a\u00020\u00012\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010 2\u0006\u0010%\u001a\u00020\u0016H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/islandoftex/arara/core/rules/Directives;", "", "()V", "directivePattern", "Ljava/util/regex/Pattern;", "directivestart", "", "hooks", "Lorg/islandoftex/arara/core/rules/DirectiveFetchingHooks;", "getHooks$annotations", "getHooks", "()Lorg/islandoftex/arara/core/rules/DirectiveFetchingHooks;", "setHooks", "(Lorg/islandoftex/arara/core/rules/DirectiveFetchingHooks;)V", "linebreakPattern", "namePattern", "pattern", "checkLinePattern", "", "line", "extractDirectives", "", "Lorg/islandoftex/arara/api/rules/Directive;", "lines", "parseOnlyHeader", "fileType", "Lorg/islandoftex/arara/api/files/FileType;", "generateDirective", "assembler", "Lorg/islandoftex/arara/core/rules/DirectiveAssembler;", "generateDirective$core", "getPotentialDirectiveLines", "", "", "replicateDirective", "holder", "parameters", "directive", "core"})
public final class Directives {
    @NotNull
    public static final Directives INSTANCE = new Directives();
    @NotNull
    private static DirectiveFetchingHooks hooks = new DirectiveFetchingHooks(null, null, null, 7, null);
    @NotNull
    private static final String directivestart = "^\\s*(\\w+)\\s*(:\\s*(\\{.*\\})\\s*)?";
    @NotNull
    private static final String pattern = "(\\s+(if|while|until|unless)\\s+(\\S.*))?$";
    @NotNull
    private static final Pattern directivePattern;
    @NotNull
    private static final String namePattern = "arara:\\s";
    @NotNull
    private static final Pattern linebreakPattern;

    private Directives() {
    }

    @NotNull
    public static final DirectiveFetchingHooks getHooks() {
        return hooks;
    }

    public static final void setHooks(@NotNull DirectiveFetchingHooks directiveFetchingHooks) {
        Intrinsics.checkNotNullParameter(directiveFetchingHooks, "<set-?>");
        hooks = directiveFetchingHooks;
    }

    @JvmStatic
    public static /* synthetic */ void getHooks$annotations() {
    }

    private final Map<Integer, String> getPotentialDirectiveLines(List<String> lines, boolean parseOnlyHeader, String pattern) {
        String string = pattern;
        int n = 0;
        Pattern pattern2 = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue(pattern2, "compile(this, flags)");
        Pattern validLinePattern = pattern2;
        String string2 = Intrinsics.stringPlus(pattern, namePattern);
        int n2 = 0;
        Pattern pattern3 = Pattern.compile(string2, n2);
        Intrinsics.checkNotNullExpressionValue(pattern3, "compile(this, flags)");
        Pattern validLineStartPattern = pattern3;
        Map map = new LinkedHashMap();
        Iterator<String> iterator2 = lines.iterator();
        int n3 = 0;
        while (iterator2.hasNext()) {
            int i = n3++;
            String text2 = iterator2.next();
            Matcher validLineMatcher = validLineStartPattern.matcher(text2);
            if (validLineMatcher.find()) {
                String string3 = text2.substring(validLineMatcher.end());
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
                String line = string3;
                map.put(i + 1, hooks.getProcessPotentialDirective().invoke(i + 1, line));
                continue;
            }
            if (!parseOnlyHeader || this.checkLinePattern(validLinePattern, text2)) continue;
            break;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Directive> extractDirectives(@NotNull List<String> lines, boolean parseOnlyHeader, @NotNull FileType fileType) throws AraraException {
        void $this$mapTo$iv$iv;
        Map<Integer, String> map;
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        Map<Integer, String> map2 = INSTANCE.getPotentialDirectiveLines(lines, parseOnlyHeader, fileType.getPattern());
        Map<Integer, String> it = map2;
        boolean bl = false;
        Map<Integer, String> map3 = map = !it.isEmpty() ? map2 : null;
        if (map == null) {
            return CollectionsKt.emptyList();
        }
        Map<Integer, String> pairs = map;
        List assemblers = new ArrayList();
        DirectiveAssembler assembler = new DirectiveAssembler();
        for (Map.Entry entry : pairs.entrySet()) {
            int lineno = ((Number)entry.getKey()).intValue();
            String content = (String)entry.getValue();
            Matcher linebreakMatcher = linebreakPattern.matcher(content);
            if (linebreakMatcher.find()) {
                if (!assembler.isAppendAllowed()) {
                    Object[] objectArray = new Object[]{lineno};
                    String directiveAssembler = String.format(LanguageController.getMessages().getERROR_VALIDATE_ORPHAN_LINEBREAK(), Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(directiveAssembler, "format(this, *args)");
                    throw new AraraException(directiveAssembler);
                }
                assembler.addLineNumber(lineno);
                String string = linebreakMatcher.group(1);
                Intrinsics.checkNotNullExpressionValue(string, "linebreakMatcher.group(1)");
                assembler.appendLine(string);
                continue;
            }
            if (assembler.isAppendAllowed()) {
                assemblers.add(assembler);
            }
            assembler = new DirectiveAssembler();
            assembler.addLineNumber(lineno);
            assembler.appendLine(content);
        }
        if (assembler.isAppendAllowed()) {
            assemblers.add(assembler);
        }
        Iterable $this$map$iv = assemblers;
        boolean bl2 = false;
        Iterable lineno = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            DirectiveAssembler directiveAssembler = (DirectiveAssembler)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(INSTANCE.generateDirective$core((DirectiveAssembler)it2));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Directive generateDirective$core(@NotNull DirectiveAssembler assembler) throws AraraException {
        Intrinsics.checkNotNullParameter(assembler, "assembler");
        Matcher matcher = directivePattern.matcher(assembler.getText());
        if (matcher.find()) {
            Function4<String, String, org.islandoftex.arara.api.rules.DirectiveConditional, List<Integer>, Directive> function4 = hooks.getBuildDirectiveRaw();
            String string = matcher.group(1);
            Intrinsics.checkNotNull(string);
            String string2 = matcher.group(3);
            DirectiveConditionalType directiveConditionalType = DirectivesKt.access$toDirectiveConditional(matcher.group(5));
            String string3 = matcher.group(6);
            if (string3 == null) {
                string3 = "";
            }
            return function4.invoke(string, string2, new DirectiveConditional(directiveConditionalType, string3), assembler.getLineNumbers());
        }
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default(assembler.getLineNumbers(), ", ", "(", ")", 0, null, null, 56, null)};
        String string = String.format(LanguageController.getMessages().getERROR_VALIDATE_INVALID_DIRECTIVE_FORMAT(), Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
        throw new AraraException(string);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Directive> replicateDirective(@NotNull Object holder, @NotNull Map<String, ? extends Object> parameters2, @NotNull Directive directive) throws AraraException {
        List<Directive> list;
        Intrinsics.checkNotNullParameter(holder, "holder");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(directive, "directive");
        if (holder instanceof List) {
            List<Directive> list2;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)holder;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Object)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List<Directive> it = list2 = SequencesKt.toList(SequencesKt.map(SequencesKt.map(SequencesKt.map(SequencesKt.map(CollectionsKt.asSequence((List)destination$iv$iv), replicateDirective.1.INSTANCE), (Function1)new Function1<Path, Path>((Object)FileHandling.INSTANCE){

                @NotNull
                public final Path invoke(@NotNull Path p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return FileHandling.normalize(p0);
                }
            }), replicateDirective.3.INSTANCE), (Function1)new Function1<File, Directive>(directive, parameters2){
                final /* synthetic */ Directive $directive;
                final /* synthetic */ Map<String, Object> $parameters;
                {
                    this.$directive = $directive;
                    this.$parameters = $parameters;
                    super(1);
                }

                @NotNull
                public final Directive invoke(File reference) {
                    return Directives.getHooks().getBuildDirective().invoke(this.$directive.getIdentifier(), MapsKt.plus(this.$parameters, TuplesKt.to("reference", reference)), this.$directive.getConditional(), this.$directive.getLineNumbers());
                }
            }));
            boolean bl = false;
            List<Directive> list3 = list = !((Collection)it).isEmpty() && ((List)holder).size() == it.size() ? list2 : null;
            if (list == null) {
                Object[] objectArray = new Object[]{CollectionsKt.joinToString$default(directive.getLineNumbers(), ", ", "(", ")", 0, null, null, 56, null)};
                String string = String.format(LanguageController.getMessages().getERROR_VALIDATE_EMPTY_FILES_LIST(), Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
                throw new AraraException(string);
            }
        } else {
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default(directive.getLineNumbers(), ", ", "(", ")", 0, null, null, 56, null)};
            String string = String.format(LanguageController.getMessages().getERROR_VALIDATE_FILES_IS_NOT_A_LIST(), Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
            throw new AraraException(string);
        }
        return list;
    }

    private final boolean checkLinePattern(Pattern pattern, String line) {
        return StringsKt.isBlank(line) || pattern.matcher(line).find();
    }

    static {
        String string = "^\\s*(\\w+)\\s*(:\\s*(\\{.*\\})\\s*)?(\\s+(if|while|until|unless)\\s+(\\S.*))?$";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(this, flags)");
        directivePattern = pattern;
        string = "^\\s*-->\\s(.*)$";
        n = 0;
        pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(this, flags)");
        linebreakPattern = pattern;
    }
}

