# Metrics

Promscale exposes Prometheus metrics at `/metrics` endpoint by default or as configured in `-web.telemetry-path`. It is recommended
that you monitor your Promscale instances with Prometheus.

## Metrics exposed by Promscale

**Note:** You can query all Promscale metrics in PromQL by querying `{job="promscale"}`, provided
the `job_name` in Prometheus's `scrape_config` is set to `promscale`. If not, use the job name
that you provided in your `scrape_config`.

```text
# HELP go_gc_cycles_automatic_gc_cycles_total Count of completed GC cycles generated by the Go runtime.
# TYPE go_gc_cycles_automatic_gc_cycles_total counter
go_gc_cycles_automatic_gc_cycles_total 10
# HELP go_gc_cycles_forced_gc_cycles_total Count of completed GC cycles forced by the application.
# TYPE go_gc_cycles_forced_gc_cycles_total counter
go_gc_cycles_forced_gc_cycles_total 0
# HELP go_gc_cycles_total_gc_cycles_total Count of all completed GC cycles.
# TYPE go_gc_cycles_total_gc_cycles_total counter
go_gc_cycles_total_gc_cycles_total 10
# HELP go_gc_duration_seconds A summary of the pause duration of garbage collection cycles.
# TYPE go_gc_duration_seconds summary
go_gc_duration_seconds{quantile="0"} 1.4343e-05
go_gc_duration_seconds{quantile="0.25"} 3.7084e-05
go_gc_duration_seconds{quantile="0.5"} 9.8397e-05
go_gc_duration_seconds{quantile="0.75"} 0.000139321
go_gc_duration_seconds{quantile="1"} 0.000227334
go_gc_duration_seconds_sum 0.000948804
go_gc_duration_seconds_count 10
# HELP go_gc_heap_allocs_by_size_bytes_total Distribution of heap allocations by approximate size. Note that this does not include tiny objects as defined by /gc/heap/tiny/allocs:objects, only tiny blocks.
# TYPE go_gc_heap_allocs_by_size_bytes_total histogram
go_gc_heap_allocs_by_size_bytes_total_bucket{le="8.999999999999998"} 5223
go_gc_heap_allocs_by_size_bytes_total_bucket{le="24.999999999999996"} 559523
go_gc_heap_allocs_by_size_bytes_total_bucket{le="64.99999999999999"} 810469
go_gc_heap_allocs_by_size_bytes_total_bucket{le="144.99999999999997"} 909127
go_gc_heap_allocs_by_size_bytes_total_bucket{le="320.99999999999994"} 974123
go_gc_heap_allocs_by_size_bytes_total_bucket{le="704.9999999999999"} 980803
go_gc_heap_allocs_by_size_bytes_total_bucket{le="1536.9999999999998"} 982732
go_gc_heap_allocs_by_size_bytes_total_bucket{le="3200.9999999999995"} 983888
go_gc_heap_allocs_by_size_bytes_total_bucket{le="6528.999999999999"} 984630
go_gc_heap_allocs_by_size_bytes_total_bucket{le="13568.999999999998"} 985546
go_gc_heap_allocs_by_size_bytes_total_bucket{le="27264.999999999996"} 985892
go_gc_heap_allocs_by_size_bytes_total_bucket{le="+Inf"} 986229
go_gc_heap_allocs_by_size_bytes_total_sum 1.64304088e+08
go_gc_heap_allocs_by_size_bytes_total_count 986229
# HELP go_gc_heap_allocs_bytes_total Cumulative sum of memory allocated to the heap by the application.
# TYPE go_gc_heap_allocs_bytes_total counter
go_gc_heap_allocs_bytes_total 1.64304088e+08
# HELP go_gc_heap_allocs_objects_total Cumulative count of heap allocations triggered by the application. Note that this does not include tiny objects as defined by /gc/heap/tiny/allocs:objects, only tiny blocks.
# TYPE go_gc_heap_allocs_objects_total counter
go_gc_heap_allocs_objects_total 986229
# HELP go_gc_heap_frees_by_size_bytes_total Distribution of freed heap allocations by approximate size. Note that this does not include tiny objects as defined by /gc/heap/tiny/allocs:objects, only tiny blocks.
# TYPE go_gc_heap_frees_by_size_bytes_total histogram
go_gc_heap_frees_by_size_bytes_total_bucket{le="8.999999999999998"} 2473
go_gc_heap_frees_by_size_bytes_total_bucket{le="24.999999999999996"} 523646
go_gc_heap_frees_by_size_bytes_total_bucket{le="64.99999999999999"} 752480
go_gc_heap_frees_by_size_bytes_total_bucket{le="144.99999999999997"} 829794
go_gc_heap_frees_by_size_bytes_total_bucket{le="320.99999999999994"} 889676
go_gc_heap_frees_by_size_bytes_total_bucket{le="704.9999999999999"} 892612
go_gc_heap_frees_by_size_bytes_total_bucket{le="1536.9999999999998"} 893670
go_gc_heap_frees_by_size_bytes_total_bucket{le="3200.9999999999995"} 894367
go_gc_heap_frees_by_size_bytes_total_bucket{le="6528.999999999999"} 894856
go_gc_heap_frees_by_size_bytes_total_bucket{le="13568.999999999998"} 895211
go_gc_heap_frees_by_size_bytes_total_bucket{le="27264.999999999996"} 895443
go_gc_heap_frees_by_size_bytes_total_bucket{le="+Inf"} 895706
go_gc_heap_frees_by_size_bytes_total_sum 1.01737136e+08
go_gc_heap_frees_by_size_bytes_total_count 895706
# HELP go_gc_heap_frees_bytes_total Cumulative sum of heap memory freed by the garbage collector.
# TYPE go_gc_heap_frees_bytes_total counter
go_gc_heap_frees_bytes_total 1.01737136e+08
# HELP go_gc_heap_frees_objects_total Cumulative count of heap allocations whose storage was freed by the garbage collector. Note that this does not include tiny objects as defined by /gc/heap/tiny/allocs:objects, only tiny blocks.
# TYPE go_gc_heap_frees_objects_total counter
go_gc_heap_frees_objects_total 895706
# HELP go_gc_heap_goal_bytes Heap size target for the end of the GC cycle.
# TYPE go_gc_heap_goal_bytes gauge
go_gc_heap_goal_bytes 1.24400992e+08
# HELP go_gc_heap_objects_objects Number of objects, live or unswept, occupying heap memory.
# TYPE go_gc_heap_objects_objects gauge
go_gc_heap_objects_objects 90523
# HELP go_gc_heap_tiny_allocs_objects_total Count of small allocations that are packed together into blocks. These allocations are counted separately from other allocations because each individual allocation is not tracked by the runtime, only their block. Each block is already accounted for in allocs-by-size and frees-by-size.
# TYPE go_gc_heap_tiny_allocs_objects_total counter
go_gc_heap_tiny_allocs_objects_total 129169
# HELP go_gc_pauses_seconds_total Distribution individual GC-related stop-the-world pause latencies.
# TYPE go_gc_pauses_seconds_total histogram
go_gc_pauses_seconds_total_bucket{le="-5e-324"} 0
go_gc_pauses_seconds_total_bucket{le="9.999999999999999e-10"} 0
go_gc_pauses_seconds_total_bucket{le="9.999999999999999e-09"} 0
go_gc_pauses_seconds_total_bucket{le="1.2799999999999998e-07"} 0
go_gc_pauses_seconds_total_bucket{le="1.2799999999999998e-06"} 0
go_gc_pauses_seconds_total_bucket{le="1.6383999999999998e-05"} 9
go_gc_pauses_seconds_total_bucket{le="0.00016383999999999998"} 20
go_gc_pauses_seconds_total_bucket{le="0.0020971519999999997"} 20
go_gc_pauses_seconds_total_bucket{le="0.020971519999999997"} 20
go_gc_pauses_seconds_total_bucket{le="0.26843545599999996"} 20
go_gc_pauses_seconds_total_bucket{le="+Inf"} 20
go_gc_pauses_seconds_total_sum NaN
go_gc_pauses_seconds_total_count 20
# HELP go_goroutines Number of goroutines that currently exist.
# TYPE go_goroutines gauge
go_goroutines 391
# HELP go_info Information about the Go environment.
# TYPE go_info gauge
go_info{version="go1.17.1"} 1
# HELP go_memory_classes_heap_free_bytes Memory that is completely free and eligible to be returned to the underlying system, but has not been. This metric is the runtime's estimate of free address space that is backed by physical memory.
# TYPE go_memory_classes_heap_free_bytes gauge
go_memory_classes_heap_free_bytes 3.764224e+07
# HELP go_memory_classes_heap_objects_bytes Memory occupied by live objects and dead objects that have not yet been marked free by the garbage collector.
# TYPE go_memory_classes_heap_objects_bytes gauge
go_memory_classes_heap_objects_bytes 6.2566952e+07
# HELP go_memory_classes_heap_released_bytes Memory that is completely free and has been returned to the underlying system. This metric is the runtime's estimate of free address space that is still mapped into the process, but is not backed by physical memory.
# TYPE go_memory_classes_heap_released_bytes gauge
go_memory_classes_heap_released_bytes 4.554752e+06
# HELP go_memory_classes_heap_stacks_bytes Memory allocated from the heap that is reserved for stack space, whether or not it is currently in-use.
# TYPE go_memory_classes_heap_stacks_bytes gauge
go_memory_classes_heap_stacks_bytes 3.11296e+06
# HELP go_memory_classes_heap_unused_bytes Memory that is reserved for heap objects but is not currently used to hold heap objects.
# TYPE go_memory_classes_heap_unused_bytes gauge
go_memory_classes_heap_unused_bytes 9.563608e+06
# HELP go_memory_classes_metadata_mcache_free_bytes Memory that is reserved for runtime mcache structures, but not in-use.
# TYPE go_memory_classes_metadata_mcache_free_bytes gauge
go_memory_classes_metadata_mcache_free_bytes 6784
# HELP go_memory_classes_metadata_mcache_inuse_bytes Memory that is occupied by runtime mcache structures that are currently being used.
# TYPE go_memory_classes_metadata_mcache_inuse_bytes gauge
go_memory_classes_metadata_mcache_inuse_bytes 9600
# HELP go_memory_classes_metadata_mspan_free_bytes Memory that is reserved for runtime mspan structures, but not in-use.
# TYPE go_memory_classes_metadata_mspan_free_bytes gauge
go_memory_classes_metadata_mspan_free_bytes 440824
# HELP go_memory_classes_metadata_mspan_inuse_bytes Memory that is occupied by runtime mspan structures that are currently being used.
# TYPE go_memory_classes_metadata_mspan_inuse_bytes gauge
go_memory_classes_metadata_mspan_inuse_bytes 476680
# HELP go_memory_classes_metadata_other_bytes Memory that is reserved for or used to hold runtime metadata.
# TYPE go_memory_classes_metadata_other_bytes gauge
go_memory_classes_metadata_other_bytes 8.239576e+06
# HELP go_memory_classes_os_stacks_bytes Stack memory allocated by the underlying operating system.
# TYPE go_memory_classes_os_stacks_bytes gauge
go_memory_classes_os_stacks_bytes 0
# HELP go_memory_classes_other_bytes Memory used by execution trace buffers, structures for debugging the runtime, finalizer and profiler specials, and more.
# TYPE go_memory_classes_other_bytes gauge
go_memory_classes_other_bytes 1.616859e+06
# HELP go_memory_classes_profiling_buckets_bytes Memory that is used by the stack trace hash map used for profiling.
# TYPE go_memory_classes_profiling_buckets_bytes gauge
go_memory_classes_profiling_buckets_bytes 1.485413e+06
# HELP go_memory_classes_total_bytes All memory mapped by the Go runtime into the current process as read-write. Note that this does not include memory mapped by code called via cgo or via the syscall package. Sum of all metrics in /memory/classes.
# TYPE go_memory_classes_total_bytes gauge
go_memory_classes_total_bytes 1.29716248e+08
# HELP go_memstats_alloc_bytes Number of bytes allocated and still in use.
# TYPE go_memstats_alloc_bytes gauge
go_memstats_alloc_bytes 6.2566952e+07
# HELP go_memstats_alloc_bytes_total Total number of bytes allocated, even if freed.
# TYPE go_memstats_alloc_bytes_total counter
go_memstats_alloc_bytes_total 1.64304088e+08
# HELP go_memstats_buck_hash_sys_bytes Number of bytes used by the profiling bucket hash table.
# TYPE go_memstats_buck_hash_sys_bytes gauge
go_memstats_buck_hash_sys_bytes 1.485413e+06
# HELP go_memstats_frees_total Total number of frees.
# TYPE go_memstats_frees_total counter
go_memstats_frees_total 1.024875e+06
# HELP go_memstats_gc_cpu_fraction The fraction of this program's available CPU time used by the GC since the program started.
# TYPE go_memstats_gc_cpu_fraction gauge
go_memstats_gc_cpu_fraction 0
# HELP go_memstats_gc_sys_bytes Number of bytes used for garbage collection system metadata.
# TYPE go_memstats_gc_sys_bytes gauge
go_memstats_gc_sys_bytes 8.239576e+06
# HELP go_memstats_heap_alloc_bytes Number of heap bytes allocated and still in use.
# TYPE go_memstats_heap_alloc_bytes gauge
go_memstats_heap_alloc_bytes 6.2566952e+07
# HELP go_memstats_heap_idle_bytes Number of heap bytes waiting to be used.
# TYPE go_memstats_heap_idle_bytes gauge
go_memstats_heap_idle_bytes 4.2196992e+07
# HELP go_memstats_heap_inuse_bytes Number of heap bytes that are in use.
# TYPE go_memstats_heap_inuse_bytes gauge
go_memstats_heap_inuse_bytes 7.213056e+07
# HELP go_memstats_heap_objects Number of allocated objects.
# TYPE go_memstats_heap_objects gauge
go_memstats_heap_objects 90523
# HELP go_memstats_heap_released_bytes Number of heap bytes released to OS.
# TYPE go_memstats_heap_released_bytes gauge
go_memstats_heap_released_bytes 4.554752e+06
# HELP go_memstats_heap_sys_bytes Number of heap bytes obtained from system.
# TYPE go_memstats_heap_sys_bytes gauge
go_memstats_heap_sys_bytes 1.14327552e+08
# HELP go_memstats_last_gc_time_seconds Number of seconds since 1970 of last garbage collection.
# TYPE go_memstats_last_gc_time_seconds gauge
go_memstats_last_gc_time_seconds 1.6449411156530263e+09
# HELP go_memstats_lookups_total Total number of pointer lookups.
# TYPE go_memstats_lookups_total counter
go_memstats_lookups_total 0
# HELP go_memstats_mallocs_total Total number of mallocs.
# TYPE go_memstats_mallocs_total counter
go_memstats_mallocs_total 1.115398e+06
# HELP go_memstats_mcache_inuse_bytes Number of bytes in use by mcache structures.
# TYPE go_memstats_mcache_inuse_bytes gauge
go_memstats_mcache_inuse_bytes 9600
# HELP go_memstats_mcache_sys_bytes Number of bytes used for mcache structures obtained from system.
# TYPE go_memstats_mcache_sys_bytes gauge
go_memstats_mcache_sys_bytes 16384
# HELP go_memstats_mspan_inuse_bytes Number of bytes in use by mspan structures.
# TYPE go_memstats_mspan_inuse_bytes gauge
go_memstats_mspan_inuse_bytes 476680
# HELP go_memstats_mspan_sys_bytes Number of bytes used for mspan structures obtained from system.
# TYPE go_memstats_mspan_sys_bytes gauge
go_memstats_mspan_sys_bytes 917504
# HELP go_memstats_next_gc_bytes Number of heap bytes when next garbage collection will take place.
# TYPE go_memstats_next_gc_bytes gauge
go_memstats_next_gc_bytes 1.24400992e+08
# HELP go_memstats_other_sys_bytes Number of bytes used for other system allocations.
# TYPE go_memstats_other_sys_bytes gauge
go_memstats_other_sys_bytes 1.616859e+06
# HELP go_memstats_stack_inuse_bytes Number of bytes in use by the stack allocator.
# TYPE go_memstats_stack_inuse_bytes gauge
go_memstats_stack_inuse_bytes 3.11296e+06
# HELP go_memstats_stack_sys_bytes Number of bytes obtained from system for stack allocator.
# TYPE go_memstats_stack_sys_bytes gauge
go_memstats_stack_sys_bytes 3.11296e+06
# HELP go_memstats_sys_bytes Number of bytes obtained from system.
# TYPE go_memstats_sys_bytes gauge
go_memstats_sys_bytes 1.29716248e+08
# HELP go_sched_goroutines_goroutines Count of live goroutines.
# TYPE go_sched_goroutines_goroutines gauge
go_sched_goroutines_goroutines 391
# HELP go_sched_latencies_seconds Distribution of the time goroutines have spent in the scheduler in a runnable state before actually running.
# TYPE go_sched_latencies_seconds histogram
go_sched_latencies_seconds_bucket{le="-5e-324"} 0
go_sched_latencies_seconds_bucket{le="9.999999999999999e-10"} 892
go_sched_latencies_seconds_bucket{le="9.999999999999999e-09"} 892
go_sched_latencies_seconds_bucket{le="1.2799999999999998e-07"} 1069
go_sched_latencies_seconds_bucket{le="1.2799999999999998e-06"} 2683
go_sched_latencies_seconds_bucket{le="1.6383999999999998e-05"} 3085
go_sched_latencies_seconds_bucket{le="0.00016383999999999998"} 3519
go_sched_latencies_seconds_bucket{le="0.0020971519999999997"} 3589
go_sched_latencies_seconds_bucket{le="0.020971519999999997"} 3620
go_sched_latencies_seconds_bucket{le="0.26843545599999996"} 3620
go_sched_latencies_seconds_bucket{le="+Inf"} 3620
go_sched_latencies_seconds_sum NaN
go_sched_latencies_seconds_count 3620
# HELP go_threads Number of OS threads created.
# TYPE go_threads gauge
go_threads 14
# HELP grpc_server_handled_total Total number of RPCs completed on the server, regardless of success or failure.
# TYPE grpc_server_handled_total counter
grpc_server_handled_total{grpc_code="Aborted",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="AlreadyExists",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="Canceled",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="DataLoss",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="DeadlineExceeded",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="FailedPrecondition",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="Internal",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="InvalidArgument",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="NotFound",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="OK",grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary"} 1
grpc_server_handled_total{grpc_code="OK",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 35
grpc_server_handled_total{grpc_code="OK",grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream"} 1
grpc_server_handled_total{grpc_code="OK",grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 1
grpc_server_handled_total{grpc_code="OK",grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 1
grpc_server_handled_total{grpc_code="OutOfRange",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="PermissionDenied",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="ResourceExhausted",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="Unauthenticated",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="Unavailable",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="Unimplemented",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
grpc_server_handled_total{grpc_code="Unknown",grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 0
# HELP grpc_server_handling_seconds Histogram of response latency (seconds) of gRPC that had been application-level handled by the server.
# TYPE grpc_server_handling_seconds histogram
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="0.001"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="0.01"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="0.1"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="0.3"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="0.6"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="1"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="3"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="6"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="9"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="20"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="30"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="60"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="90"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="120"} 1
grpc_server_handling_seconds_bucket{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary",le="+Inf"} 1
grpc_server_handling_seconds_sum{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary"} 4.9067e-05
grpc_server_handling_seconds_count{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary"} 1
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="0.001"} 0
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="0.01"} 0
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="0.1"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="0.3"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="0.6"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="1"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="3"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="6"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="9"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="20"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="30"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="60"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="90"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="120"} 35
grpc_server_handling_seconds_bucket{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary",le="+Inf"} 35
grpc_server_handling_seconds_sum{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 1.808549949
grpc_server_handling_seconds_count{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 35
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="0.001"} 0
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="0.01"} 0
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="0.1"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="0.3"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="0.6"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="1"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="3"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="6"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="9"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="20"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="30"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="60"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="90"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="120"} 1
grpc_server_handling_seconds_bucket{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream",le="+Inf"} 1
grpc_server_handling_seconds_sum{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream"} 0.074430938
grpc_server_handling_seconds_count{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="0.001"} 0
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="0.01"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="0.1"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="0.3"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="0.6"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="1"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="3"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="6"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="9"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="20"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="30"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="60"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="90"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="120"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="+Inf"} 1
grpc_server_handling_seconds_sum{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 0.0021335
grpc_server_handling_seconds_count{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="0.001"} 0
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="0.01"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="0.1"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="0.3"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="0.6"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="1"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="3"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="6"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="9"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="20"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="30"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="60"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="90"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="120"} 1
grpc_server_handling_seconds_bucket{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary",le="+Inf"} 1
grpc_server_handling_seconds_sum{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 0.001323796
grpc_server_handling_seconds_count{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 1
# HELP grpc_server_msg_received_total Total number of RPC stream messages received on the server.
# TYPE grpc_server_msg_received_total counter
grpc_server_msg_received_total{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary"} 1
grpc_server_msg_received_total{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 35
grpc_server_msg_received_total{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream"} 1
grpc_server_msg_received_total{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 1
grpc_server_msg_received_total{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 1
# HELP grpc_server_msg_sent_total Total number of gRPC stream messages sent by the server.
# TYPE grpc_server_msg_sent_total counter
grpc_server_msg_sent_total{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary"} 1
grpc_server_msg_sent_total{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 35
grpc_server_msg_sent_total{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream"} 20
grpc_server_msg_sent_total{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 1
grpc_server_msg_sent_total{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 1
# HELP grpc_server_started_total Total number of RPCs started on the server.
# TYPE grpc_server_started_total counter
grpc_server_started_total{grpc_method="Capabilities",grpc_service="jaeger.storage.v1.PluginCapabilities",grpc_type="unary"} 1
grpc_server_started_total{grpc_method="Export",grpc_service="opentelemetry.proto.collector.trace.v1.TraceService",grpc_type="unary"} 35
grpc_server_started_total{grpc_method="FindTraces",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="server_stream"} 1
grpc_server_started_total{grpc_method="GetOperations",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 1
grpc_server_started_total{grpc_method="GetServices",grpc_service="jaeger.storage.v1.SpanReaderPlugin",grpc_type="unary"} 1
# HELP process_cpu_seconds_total Total user and system CPU time spent in seconds.
# TYPE process_cpu_seconds_total counter
process_cpu_seconds_total 1.23
# HELP process_max_fds Maximum number of open file descriptors.
# TYPE process_max_fds gauge
process_max_fds 1.048576e+06
# HELP process_open_fds Number of open file descriptors.
# TYPE process_open_fds gauge
process_open_fds 96
# HELP process_resident_memory_bytes Resident memory size in bytes.
# TYPE process_resident_memory_bytes gauge
process_resident_memory_bytes 1.19267328e+08
# HELP process_start_time_seconds Start time of the process since unix epoch in seconds.
# TYPE process_start_time_seconds gauge
process_start_time_seconds 1.64494107291e+09
# HELP process_virtual_memory_bytes Virtual memory size in bytes.
# TYPE process_virtual_memory_bytes gauge
process_virtual_memory_bytes 1.729200128e+09
# HELP process_virtual_memory_max_bytes Maximum amount of virtual memory available in bytes.
# TYPE process_virtual_memory_max_bytes gauge
process_virtual_memory_max_bytes 1.8446744073709552e+19
# HELP promhttp_metric_handler_requests_in_flight Current number of scrapes being served.
# TYPE promhttp_metric_handler_requests_in_flight gauge
promhttp_metric_handler_requests_in_flight 1
# HELP promhttp_metric_handler_requests_total Total number of scrapes by HTTP status code.
# TYPE promhttp_metric_handler_requests_total counter
promhttp_metric_handler_requests_total{code="200"} 5
promhttp_metric_handler_requests_total{code="500"} 0
promhttp_metric_handler_requests_total{code="503"} 0
# HELP promscale_api_http_request_duration_ms Duration of HTTP request in milliseconds
# TYPE promscale_api_http_request_duration_ms histogram
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="0.005"} 1
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="0.01"} 1
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="0.025"} 1
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="0.05"} 1
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="0.1"} 1
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="0.25"} 1
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="0.5"} 1
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="1"} 1
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="2.5"} 1
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="5"} 1
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="10"} 1
promscale_api_http_request_duration_ms_bucket{path="label/:name/values",le="+Inf"} 1
promscale_api_http_request_duration_ms_sum{path="label/:name/values"} 0
promscale_api_http_request_duration_ms_count{path="label/:name/values"} 1
promscale_api_http_request_duration_ms_bucket{path="labels",le="0.005"} 0
promscale_api_http_request_duration_ms_bucket{path="labels",le="0.01"} 0
promscale_api_http_request_duration_ms_bucket{path="labels",le="0.025"} 0
promscale_api_http_request_duration_ms_bucket{path="labels",le="0.05"} 0
promscale_api_http_request_duration_ms_bucket{path="labels",le="0.1"} 0
promscale_api_http_request_duration_ms_bucket{path="labels",le="0.25"} 0
promscale_api_http_request_duration_ms_bucket{path="labels",le="0.5"} 0
promscale_api_http_request_duration_ms_bucket{path="labels",le="1"} 1
promscale_api_http_request_duration_ms_bucket{path="labels",le="2.5"} 1
promscale_api_http_request_duration_ms_bucket{path="labels",le="5"} 1
promscale_api_http_request_duration_ms_bucket{path="labels",le="10"} 1
promscale_api_http_request_duration_ms_bucket{path="labels",le="+Inf"} 1
promscale_api_http_request_duration_ms_sum{path="labels"} 1
promscale_api_http_request_duration_ms_count{path="labels"} 1
promscale_api_http_request_duration_ms_bucket{path="metadata",le="0.005"} 0
promscale_api_http_request_duration_ms_bucket{path="metadata",le="0.01"} 0
promscale_api_http_request_duration_ms_bucket{path="metadata",le="0.025"} 0
promscale_api_http_request_duration_ms_bucket{path="metadata",le="0.05"} 0
promscale_api_http_request_duration_ms_bucket{path="metadata",le="0.1"} 0
promscale_api_http_request_duration_ms_bucket{path="metadata",le="0.25"} 0
promscale_api_http_request_duration_ms_bucket{path="metadata",le="0.5"} 0
promscale_api_http_request_duration_ms_bucket{path="metadata",le="1"} 0
promscale_api_http_request_duration_ms_bucket{path="metadata",le="2.5"} 1
promscale_api_http_request_duration_ms_bucket{path="metadata",le="5"} 1
promscale_api_http_request_duration_ms_bucket{path="metadata",le="10"} 1
promscale_api_http_request_duration_ms_bucket{path="metadata",le="+Inf"} 1
promscale_api_http_request_duration_ms_sum{path="metadata"} 2
promscale_api_http_request_duration_ms_count{path="metadata"} 1
promscale_api_http_request_duration_ms_bucket{path="query",le="0.005"} 0
promscale_api_http_request_duration_ms_bucket{path="query",le="0.01"} 0
promscale_api_http_request_duration_ms_bucket{path="query",le="0.025"} 0
promscale_api_http_request_duration_ms_bucket{path="query",le="0.05"} 0
promscale_api_http_request_duration_ms_bucket{path="query",le="0.1"} 0
promscale_api_http_request_duration_ms_bucket{path="query",le="0.25"} 0
promscale_api_http_request_duration_ms_bucket{path="query",le="0.5"} 0
promscale_api_http_request_duration_ms_bucket{path="query",le="1"} 0
promscale_api_http_request_duration_ms_bucket{path="query",le="2.5"} 2
promscale_api_http_request_duration_ms_bucket{path="query",le="5"} 2
promscale_api_http_request_duration_ms_bucket{path="query",le="10"} 2
promscale_api_http_request_duration_ms_bucket{path="query",le="+Inf"} 2
promscale_api_http_request_duration_ms_sum{path="query"} 4
promscale_api_http_request_duration_ms_count{path="query"} 2
promscale_api_http_request_duration_ms_bucket{path="query_range",le="0.005"} 0
promscale_api_http_request_duration_ms_bucket{path="query_range",le="0.01"} 0
promscale_api_http_request_duration_ms_bucket{path="query_range",le="0.025"} 0
promscale_api_http_request_duration_ms_bucket{path="query_range",le="0.05"} 0
promscale_api_http_request_duration_ms_bucket{path="query_range",le="0.1"} 0
promscale_api_http_request_duration_ms_bucket{path="query_range",le="0.25"} 0
promscale_api_http_request_duration_ms_bucket{path="query_range",le="0.5"} 0
promscale_api_http_request_duration_ms_bucket{path="query_range",le="1"} 0
promscale_api_http_request_duration_ms_bucket{path="query_range",le="2.5"} 0
promscale_api_http_request_duration_ms_bucket{path="query_range",le="5"} 2
promscale_api_http_request_duration_ms_bucket{path="query_range",le="10"} 2
promscale_api_http_request_duration_ms_bucket{path="query_range",le="+Inf"} 2
promscale_api_http_request_duration_ms_sum{path="query_range"} 9
promscale_api_http_request_duration_ms_count{path="query_range"} 2
promscale_api_http_request_duration_ms_bucket{path="write",le="0.005"} 0
promscale_api_http_request_duration_ms_bucket{path="write",le="0.01"} 0
promscale_api_http_request_duration_ms_bucket{path="write",le="0.025"} 0
promscale_api_http_request_duration_ms_bucket{path="write",le="0.05"} 0
promscale_api_http_request_duration_ms_bucket{path="write",le="0.1"} 0
promscale_api_http_request_duration_ms_bucket{path="write",le="0.25"} 0
promscale_api_http_request_duration_ms_bucket{path="write",le="0.5"} 0
promscale_api_http_request_duration_ms_bucket{path="write",le="1"} 0
promscale_api_http_request_duration_ms_bucket{path="write",le="2.5"} 0
promscale_api_http_request_duration_ms_bucket{path="write",le="5"} 0
promscale_api_http_request_duration_ms_bucket{path="write",le="10"} 0
promscale_api_http_request_duration_ms_bucket{path="write",le="+Inf"} 13
promscale_api_http_request_duration_ms_sum{path="write"} 1358
promscale_api_http_request_duration_ms_count{path="write"} 13
# HELP promscale_cache_bytes Cache size in bytes.
# TYPE promscale_cache_bytes gauge
promscale_cache_bytes{name="exemplar_labels",type="metric"} 1.2e+06
promscale_cache_bytes{name="instrumentation_lib",type="trace"} 1.200026e+06
promscale_cache_bytes{name="label",type="metric"} 1.200718e+06
promscale_cache_bytes{name="metric_name",type="metric"} 1.2566e+06
promscale_cache_bytes{name="operation",type="trace"} 1.200087e+06
promscale_cache_bytes{name="schema",type="trace"} 1.200048e+06
promscale_cache_bytes{name="series",type="metric"} 3.0622812e+07
promscale_cache_bytes{name="tag",type="trace"} 1.200248e+06
# HELP promscale_cache_capacity_elements Total cache capacity in terms of elements count.
# TYPE promscale_cache_capacity_elements gauge
promscale_cache_capacity_elements{name="exemplar_labels",type="metric"} 10000
promscale_cache_capacity_elements{name="instrumentation_lib",type="trace"} 10000
promscale_cache_capacity_elements{name="label",type="metric"} 10000
promscale_cache_capacity_elements{name="metric_name",type="metric"} 10000
promscale_cache_capacity_elements{name="operation",type="trace"} 10000
promscale_cache_capacity_elements{name="schema",type="trace"} 10000
promscale_cache_capacity_elements{name="series",type="metric"} 250000
promscale_cache_capacity_elements{name="tag",type="trace"} 10000
# HELP promscale_cache_elements Number of elements in cache in terms of elements count.
# TYPE promscale_cache_elements gauge
promscale_cache_elements{name="exemplar_labels",type="metric"} 0
promscale_cache_elements{name="instrumentation_lib",type="trace"} 1
promscale_cache_elements{name="label",type="metric"} 13
promscale_cache_elements{name="metric_name",type="metric"} 359
promscale_cache_elements{name="operation",type="trace"} 2
promscale_cache_elements{name="schema",type="trace"} 1
promscale_cache_elements{name="series",type="metric"} 2109
promscale_cache_elements{name="tag",type="trace"} 6
# HELP promscale_cache_elements_histogram Number of elements in cache in terms of elements count.
# TYPE promscale_cache_elements_histogram histogram
promscale_cache_elements_histogram_bucket{name="statement_cache",type="metric",le="16"} 532
promscale_cache_elements_histogram_bucket{name="statement_cache",type="metric",le="32"} 545
promscale_cache_elements_histogram_bucket{name="statement_cache",type="metric",le="64"} 545
promscale_cache_elements_histogram_bucket{name="statement_cache",type="metric",le="128"} 545
promscale_cache_elements_histogram_bucket{name="statement_cache",type="metric",le="256"} 545
promscale_cache_elements_histogram_bucket{name="statement_cache",type="metric",le="512"} 545
promscale_cache_elements_histogram_bucket{name="statement_cache",type="metric",le="1024"} 545
promscale_cache_elements_histogram_bucket{name="statement_cache",type="metric",le="2048"} 545
promscale_cache_elements_histogram_bucket{name="statement_cache",type="metric",le="4096"} 545
promscale_cache_elements_histogram_bucket{name="statement_cache",type="metric",le="8192"} 545
promscale_cache_elements_histogram_bucket{name="statement_cache",type="metric",le="+Inf"} 545
promscale_cache_elements_histogram_sum{name="statement_cache",type="metric"} 3469
promscale_cache_elements_histogram_count{name="statement_cache",type="metric"} 545
# HELP promscale_cache_enabled Cache is enabled or not.
# TYPE promscale_cache_enabled gauge
promscale_cache_enabled{name="exemplar_labels",type="metric"} 1
promscale_cache_enabled{name="instrumentation_lib",type="trace"} 1
promscale_cache_enabled{name="label",type="metric"} 1
promscale_cache_enabled{name="metric_name",type="metric"} 1
promscale_cache_enabled{name="operation",type="trace"} 1
promscale_cache_enabled{name="schema",type="trace"} 1
promscale_cache_enabled{name="series",type="metric"} 1
promscale_cache_enabled{name="statement_cache",type="metric"} 1
promscale_cache_enabled{name="tag",type="trace"} 1
# HELP promscale_cache_evictions_total Total evictions in a clockcache.
# TYPE promscale_cache_evictions_total counter
promscale_cache_evictions_total{name="exemplar_labels",type="metric"} 0
promscale_cache_evictions_total{name="instrumentation_lib",type="trace"} 0
promscale_cache_evictions_total{name="label",type="metric"} 0
promscale_cache_evictions_total{name="metric_name",type="metric"} 0
promscale_cache_evictions_total{name="operation",type="trace"} 0
promscale_cache_evictions_total{name="schema",type="trace"} 0
promscale_cache_evictions_total{name="series",type="metric"} 0
promscale_cache_evictions_total{name="tag",type="trace"} 0
# HELP promscale_cache_queries_total Total query requests to the clockcache.
# TYPE promscale_cache_queries_total counter
promscale_cache_queries_total{name="exemplar_labels",type="metric"} 0
promscale_cache_queries_total{name="instrumentation_lib",type="trace"} 35
promscale_cache_queries_total{name="label",type="metric"} 52
promscale_cache_queries_total{name="metric_name",type="metric"} 362
promscale_cache_queries_total{name="operation",type="trace"} 70
promscale_cache_queries_total{name="schema",type="trace"} 35
promscale_cache_queries_total{name="series",type="metric"} 6500
promscale_cache_queries_total{name="tag",type="trace"} 210
# HELP promscale_cache_query_hits_total Total query hits in clockcache.
# TYPE promscale_cache_query_hits_total counter
promscale_cache_query_hits_total{name="exemplar_labels",type="metric"} 0
promscale_cache_query_hits_total{name="instrumentation_lib",type="trace"} 34
promscale_cache_query_hits_total{name="label",type="metric"} 39
promscale_cache_query_hits_total{name="metric_name",type="metric"} 3
promscale_cache_query_hits_total{name="operation",type="trace"} 68
promscale_cache_query_hits_total{name="schema",type="trace"} 34
promscale_cache_query_hits_total{name="series",type="metric"} 4391
promscale_cache_query_hits_total{name="tag",type="trace"} 204
# HELP promscale_cache_query_latency_microseconds Query latency for the clockcache.
# TYPE promscale_cache_query_latency_microseconds histogram
promscale_cache_query_latency_microseconds_bucket{method="Get",name="instrumentation_lib",type="trace",le="1"} 8
promscale_cache_query_latency_microseconds_bucket{method="Get",name="instrumentation_lib",type="trace",le="501"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="instrumentation_lib",type="trace",le="1001"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="instrumentation_lib",type="trace",le="1501"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="instrumentation_lib",type="trace",le="2001"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="instrumentation_lib",type="trace",le="2501"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="instrumentation_lib",type="trace",le="3001"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="instrumentation_lib",type="trace",le="3501"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="instrumentation_lib",type="trace",le="4001"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="instrumentation_lib",type="trace",le="4501"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="instrumentation_lib",type="trace",le="+Inf"} 35
promscale_cache_query_latency_microseconds_sum{method="Get",name="instrumentation_lib",type="trace"} 98
promscale_cache_query_latency_microseconds_count{method="Get",name="instrumentation_lib",type="trace"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="metric_name",type="metric",le="1"} 233
promscale_cache_query_latency_microseconds_bucket{method="Get",name="metric_name",type="metric",le="501"} 362
promscale_cache_query_latency_microseconds_bucket{method="Get",name="metric_name",type="metric",le="1001"} 362
promscale_cache_query_latency_microseconds_bucket{method="Get",name="metric_name",type="metric",le="1501"} 362
promscale_cache_query_latency_microseconds_bucket{method="Get",name="metric_name",type="metric",le="2001"} 362
promscale_cache_query_latency_microseconds_bucket{method="Get",name="metric_name",type="metric",le="2501"} 362
promscale_cache_query_latency_microseconds_bucket{method="Get",name="metric_name",type="metric",le="3001"} 362
promscale_cache_query_latency_microseconds_bucket{method="Get",name="metric_name",type="metric",le="3501"} 362
promscale_cache_query_latency_microseconds_bucket{method="Get",name="metric_name",type="metric",le="4001"} 362
promscale_cache_query_latency_microseconds_bucket{method="Get",name="metric_name",type="metric",le="4501"} 362
promscale_cache_query_latency_microseconds_bucket{method="Get",name="metric_name",type="metric",le="+Inf"} 362
promscale_cache_query_latency_microseconds_sum{method="Get",name="metric_name",type="metric"} 444
promscale_cache_query_latency_microseconds_count{method="Get",name="metric_name",type="metric"} 362
promscale_cache_query_latency_microseconds_bucket{method="Get",name="operation",type="trace",le="1"} 50
promscale_cache_query_latency_microseconds_bucket{method="Get",name="operation",type="trace",le="501"} 70
promscale_cache_query_latency_microseconds_bucket{method="Get",name="operation",type="trace",le="1001"} 70
promscale_cache_query_latency_microseconds_bucket{method="Get",name="operation",type="trace",le="1501"} 70
promscale_cache_query_latency_microseconds_bucket{method="Get",name="operation",type="trace",le="2001"} 70
promscale_cache_query_latency_microseconds_bucket{method="Get",name="operation",type="trace",le="2501"} 70
promscale_cache_query_latency_microseconds_bucket{method="Get",name="operation",type="trace",le="3001"} 70
promscale_cache_query_latency_microseconds_bucket{method="Get",name="operation",type="trace",le="3501"} 70
promscale_cache_query_latency_microseconds_bucket{method="Get",name="operation",type="trace",le="4001"} 70
promscale_cache_query_latency_microseconds_bucket{method="Get",name="operation",type="trace",le="4501"} 70
promscale_cache_query_latency_microseconds_bucket{method="Get",name="operation",type="trace",le="+Inf"} 70
promscale_cache_query_latency_microseconds_sum{method="Get",name="operation",type="trace"} 69
promscale_cache_query_latency_microseconds_count{method="Get",name="operation",type="trace"} 70
promscale_cache_query_latency_microseconds_bucket{method="Get",name="schema",type="trace",le="1"} 7
promscale_cache_query_latency_microseconds_bucket{method="Get",name="schema",type="trace",le="501"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="schema",type="trace",le="1001"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="schema",type="trace",le="1501"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="schema",type="trace",le="2001"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="schema",type="trace",le="2501"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="schema",type="trace",le="3001"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="schema",type="trace",le="3501"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="schema",type="trace",le="4001"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="schema",type="trace",le="4501"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="schema",type="trace",le="+Inf"} 35
promscale_cache_query_latency_microseconds_sum{method="Get",name="schema",type="trace"} 114
promscale_cache_query_latency_microseconds_count{method="Get",name="schema",type="trace"} 35
promscale_cache_query_latency_microseconds_bucket{method="Get",name="series",type="metric",le="1"} 6448
promscale_cache_query_latency_microseconds_bucket{method="Get",name="series",type="metric",le="501"} 6500
promscale_cache_query_latency_microseconds_bucket{method="Get",name="series",type="metric",le="1001"} 6500
promscale_cache_query_latency_microseconds_bucket{method="Get",name="series",type="metric",le="1501"} 6500
promscale_cache_query_latency_microseconds_bucket{method="Get",name="series",type="metric",le="2001"} 6500
promscale_cache_query_latency_microseconds_bucket{method="Get",name="series",type="metric",le="2501"} 6500
promscale_cache_query_latency_microseconds_bucket{method="Get",name="series",type="metric",le="3001"} 6500
promscale_cache_query_latency_microseconds_bucket{method="Get",name="series",type="metric",le="3501"} 6500
promscale_cache_query_latency_microseconds_bucket{method="Get",name="series",type="metric",le="4001"} 6500
promscale_cache_query_latency_microseconds_bucket{method="Get",name="series",type="metric",le="4501"} 6500
promscale_cache_query_latency_microseconds_bucket{method="Get",name="series",type="metric",le="+Inf"} 6500
promscale_cache_query_latency_microseconds_sum{method="Get",name="series",type="metric"} 590
promscale_cache_query_latency_microseconds_count{method="Get",name="series",type="metric"} 6500
promscale_cache_query_latency_microseconds_bucket{method="Get",name="tag",type="trace",le="1"} 209
promscale_cache_query_latency_microseconds_bucket{method="Get",name="tag",type="trace",le="501"} 210
promscale_cache_query_latency_microseconds_bucket{method="Get",name="tag",type="trace",le="1001"} 210
promscale_cache_query_latency_microseconds_bucket{method="Get",name="tag",type="trace",le="1501"} 210
promscale_cache_query_latency_microseconds_bucket{method="Get",name="tag",type="trace",le="2001"} 210
promscale_cache_query_latency_microseconds_bucket{method="Get",name="tag",type="trace",le="2501"} 210
promscale_cache_query_latency_microseconds_bucket{method="Get",name="tag",type="trace",le="3001"} 210
promscale_cache_query_latency_microseconds_bucket{method="Get",name="tag",type="trace",le="3501"} 210
promscale_cache_query_latency_microseconds_bucket{method="Get",name="tag",type="trace",le="4001"} 210
promscale_cache_query_latency_microseconds_bucket{method="Get",name="tag",type="trace",le="4501"} 210
promscale_cache_query_latency_microseconds_bucket{method="Get",name="tag",type="trace",le="+Inf"} 210
promscale_cache_query_latency_microseconds_sum{method="Get",name="tag",type="trace"} 62
promscale_cache_query_latency_microseconds_count{method="Get",name="tag",type="trace"} 210
promscale_cache_query_latency_microseconds_bucket{method="Get_Values",name="label",type="metric",le="1"} 1
promscale_cache_query_latency_microseconds_bucket{method="Get_Values",name="label",type="metric",le="501"} 4
promscale_cache_query_latency_microseconds_bucket{method="Get_Values",name="label",type="metric",le="1001"} 4
promscale_cache_query_latency_microseconds_bucket{method="Get_Values",name="label",type="metric",le="1501"} 4
promscale_cache_query_latency_microseconds_bucket{method="Get_Values",name="label",type="metric",le="2001"} 4
promscale_cache_query_latency_microseconds_bucket{method="Get_Values",name="label",type="metric",le="2501"} 4
promscale_cache_query_latency_microseconds_bucket{method="Get_Values",name="label",type="metric",le="3001"} 4
promscale_cache_query_latency_microseconds_bucket{method="Get_Values",name="label",type="metric",le="3501"} 4
promscale_cache_query_latency_microseconds_bucket{method="Get_Values",name="label",type="metric",le="4001"} 4
promscale_cache_query_latency_microseconds_bucket{method="Get_Values",name="label",type="metric",le="4501"} 4
promscale_cache_query_latency_microseconds_bucket{method="Get_Values",name="label",type="metric",le="+Inf"} 4
promscale_cache_query_latency_microseconds_sum{method="Get_Values",name="label",type="metric"} 13
promscale_cache_query_latency_microseconds_count{method="Get_Values",name="label",type="metric"} 4
# HELP promscale_cache_statement_per_connection_capacity Maximum number of statements in connection pool's statement cache
# TYPE promscale_cache_statement_per_connection_capacity gauge
promscale_cache_statement_per_connection_capacity 512
# HELP promscale_ingest_active_write_requests Number of active ingestion occurring in Promscale at the moment.
# TYPE promscale_ingest_active_write_requests gauge
promscale_ingest_active_write_requests{kind="sample_or_metadata",type="metric"} 0
promscale_ingest_active_write_requests{kind="span",type="trace"} 0
# HELP promscale_ingest_channel_cap Capacity of the ingest channel.
# TYPE promscale_ingest_channel_cap gauge
promscale_ingest_channel_cap{kind="sample",subsystem="copier",type="metric"} 10000
promscale_ingest_channel_cap{kind="sample",subsystem="metric_batcher",type="metric"} 1000
# HELP promscale_ingest_channel_len Length of the ingestor channel.
# TYPE promscale_ingest_channel_len histogram
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="0"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="1"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="2"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="4"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="8"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="16"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="32"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="64"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="128"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="256"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="512"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="990"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="1000"} 1462
promscale_ingest_channel_len_bucket{kind="samples",subsystem="metric_batcher",type="metric",le="+Inf"} 1462
promscale_ingest_channel_len_sum{kind="samples",subsystem="metric_batcher",type="metric"} 0
promscale_ingest_channel_len_count{kind="samples",subsystem="metric_batcher",type="metric"} 1462
# HELP promscale_ingest_duplicates_total Total number of processed samples/write_requests_to_db/metrics which where duplicates.
# TYPE promscale_ingest_duplicates_total counter
promscale_ingest_duplicates_total{kind="metric",type="metric"} 0
# HELP promscale_ingest_duration_seconds Time taken (processing + db insert) for ingestion of sample/exemplar/span.
# TYPE promscale_ingest_duration_seconds histogram
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="0.005"} 0
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="0.01"} 0
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="0.025"} 0
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="0.05"} 2
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="0.1"} 9
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="0.25"} 13
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="0.5"} 13
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="1"} 13
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="2.5"} 13
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="5"} 13
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="10"} 13
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="60"} 13
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="120"} 13
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="300"} 13
promscale_ingest_duration_seconds_bucket{code="2xx",type="metric",le="+Inf"} 13
promscale_ingest_duration_seconds_sum{code="2xx",type="metric"} 1.3585141270000003
promscale_ingest_duration_seconds_count{code="2xx",type="metric"} 13
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="0.005"} 0
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="0.01"} 0
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="0.025"} 2
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="0.05"} 13
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="0.1"} 35
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="0.25"} 35
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="0.5"} 35
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="1"} 35
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="2.5"} 35
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="5"} 35
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="10"} 35
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="60"} 35
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="120"} 35
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="300"} 35
promscale_ingest_duration_seconds_bucket{code="2xx",type="trace",le="+Inf"} 35
promscale_ingest_duration_seconds_sum{code="2xx",type="trace"} 1.8076428900000006
promscale_ingest_duration_seconds_count{code="2xx",type="trace"} 35
# HELP promscale_ingest_flush_series Number of series batched by the ingestor.
# TYPE promscale_ingest_flush_series histogram
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="1"} 924
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="2"} 1157
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="4"} 1273
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="8"} 1344
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="16"} 1427
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="32"} 1446
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="64"} 1448
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="128"} 1454
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="256"} 1458
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="512"} 1462
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="1024"} 1462
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="1990"} 1462
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="2000"} 1462
promscale_ingest_flush_series_bucket{subsystem="metric_batcher",type="metric",le="+Inf"} 1462
promscale_ingest_flush_series_sum{subsystem="metric_batcher",type="metric"} 6500
promscale_ingest_flush_series_count{subsystem="metric_batcher",type="metric"} 1462
# HELP promscale_ingest_insert_duration_seconds Duration of sample/exemplar batch insert calls to the database.
# TYPE promscale_ingest_insert_duration_seconds histogram
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="0.005"} 0
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="0.01"} 2
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="0.025"} 12
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="0.05"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="0.1"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="0.25"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="0.5"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="1"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="2.5"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="5"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="10"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="60"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="120"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="300"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="sample",subsystem="copier",type="metric",le="+Inf"} 26
promscale_ingest_insert_duration_seconds_sum{kind="sample",subsystem="copier",type="metric"} 0.697236658
promscale_ingest_insert_duration_seconds_count{kind="sample",subsystem="copier",type="metric"} 26
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="0.005"} 0
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="0.01"} 0
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="0.025"} 3
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="0.05"} 23
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="0.1"} 35
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="0.25"} 35
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="0.5"} 35
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="1"} 35
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="2.5"} 35
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="5"} 35
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="10"} 35
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="60"} 35
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="120"} 35
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="300"} 35
promscale_ingest_insert_duration_seconds_bucket{kind="span",subsystem="",type="trace",le="+Inf"} 35
promscale_ingest_insert_duration_seconds_sum{kind="span",subsystem="",type="trace"} 1.5704107289999998
promscale_ingest_insert_duration_seconds_count{kind="span",subsystem="",type="trace"} 35
# HELP promscale_ingest_inserted_total Total insertables (samples/exemplars/spans) inserted into the database.
# TYPE promscale_ingest_inserted_total counter
promscale_ingest_inserted_total{kind="exemplar",type="metric"} 0
promscale_ingest_inserted_total{kind="sample",type="metric"} 6500
# HELP promscale_ingest_inserts_per_batch Number of inserts in a single transaction.
# TYPE promscale_ingest_inserts_per_batch histogram
promscale_ingest_inserts_per_batch_bucket{subsystem="copier",type="metric",le="1"} 0
promscale_ingest_inserts_per_batch_bucket{subsystem="copier",type="metric",le="2"} 0
promscale_ingest_inserts_per_batch_bucket{subsystem="copier",type="metric",le="4"} 0
promscale_ingest_inserts_per_batch_bucket{subsystem="copier",type="metric",le="8"} 0
promscale_ingest_inserts_per_batch_bucket{subsystem="copier",type="metric",le="16"} 6
promscale_ingest_inserts_per_batch_bucket{subsystem="copier",type="metric",le="32"} 9
promscale_ingest_inserts_per_batch_bucket{subsystem="copier",type="metric",le="64"} 15
promscale_ingest_inserts_per_batch_bucket{subsystem="copier",type="metric",le="90"} 19
promscale_ingest_inserts_per_batch_bucket{subsystem="copier",type="metric",le="100"} 26
promscale_ingest_inserts_per_batch_bucket{subsystem="copier",type="metric",le="+Inf"} 26
promscale_ingest_inserts_per_batch_sum{subsystem="copier",type="metric"} 1462
promscale_ingest_inserts_per_batch_count{subsystem="copier",type="metric"} 26
# HELP promscale_ingest_items_total Total number of insertables (sample/metadata) ingested.
# TYPE promscale_ingest_items_total counter
promscale_ingest_items_total{kind="metadata",type="metric"} 0
promscale_ingest_items_total{kind="sample",type="metric"} 6500
promscale_ingest_items_total{kind="span",type="trace"} 7004
# HELP promscale_ingest_max_sent_timestamp_milliseconds Maximum sample timestamp for samples that Promscale sent to the database.
# TYPE promscale_ingest_max_sent_timestamp_milliseconds gauge
promscale_ingest_max_sent_timestamp_milliseconds{type="metric"} 1.644941114338e+12
promscale_ingest_max_sent_timestamp_milliseconds{type="trace"} 1.644941115e+09
# HELP promscale_ingest_requests_total Total number of requests to ingestor.
# TYPE promscale_ingest_requests_total counter
promscale_ingest_requests_total{code="2xx",type="metric"} 13
promscale_ingest_requests_total{code="2xx",type="trace"} 35
# HELP promscale_ingest_rows_per_batch Number of rows inserted in a single transaction.
# TYPE promscale_ingest_rows_per_batch histogram
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="1"} 0
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="2"} 0
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="4"} 0
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="8"} 0
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="16"} 0
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="32"} 4
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="64"} 7
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="128"} 10
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="256"} 16
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="512"} 26
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="1024"} 26
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="2048"} 26
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="4096"} 26
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="8192"} 26
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="16384"} 26
promscale_ingest_rows_per_batch_bucket{subsystem="copier",type="metric",le="+Inf"} 26
promscale_ingest_rows_per_batch_sum{subsystem="copier",type="metric"} 6500
promscale_ingest_rows_per_batch_count{subsystem="copier",type="metric"} 26
# HELP promscale_ingest_rows_per_insert Number of rows inserted in a single insert statement.
# TYPE promscale_ingest_rows_per_insert histogram
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="1"} 924
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="2"} 1157
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="4"} 1273
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="8"} 1344
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="16"} 1427
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="32"} 1446
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="64"} 1448
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="128"} 1454
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="256"} 1458
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="512"} 1462
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="1024"} 1462
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="2048"} 1462
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="4096"} 1462
promscale_ingest_rows_per_insert_bucket{subsystem="copier",type="metric",le="+Inf"} 1462
promscale_ingest_rows_per_insert_sum{subsystem="copier",type="metric"} 6500
promscale_ingest_rows_per_insert_count{subsystem="copier",type="metric"} 1462
# HELP promscale_max_memory_target_bytes The target for the maximum amount of memory the application can use in bytes.
# TYPE promscale_max_memory_target_bytes gauge
promscale_max_memory_target_bytes 1.6657190092e+10
# HELP promscale_query_duration_seconds Time taken to respond to the query/query batch.
# TYPE promscale_query_duration_seconds histogram
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="0.05"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="0.1"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="0.25"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="0.5"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="1"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="2.5"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="5"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="10"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="30"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="50"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="100"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="250"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="500"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="1000"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="2500"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query",type="metric",le="+Inf"} 2
promscale_query_duration_seconds_sum{code="2xx",handler="/api/v1/query",type="metric"} 0.004452734
promscale_query_duration_seconds_count{code="2xx",handler="/api/v1/query",type="metric"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="0.05"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="0.1"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="0.25"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="0.5"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="1"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="2.5"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="5"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="10"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="30"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="50"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="100"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="250"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="500"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="1000"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="2500"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="/api/v1/query_range",type="metric",le="+Inf"} 2
promscale_query_duration_seconds_sum{code="2xx",handler="/api/v1/query_range",type="metric"} 0.009352445000000001
promscale_query_duration_seconds_count{code="2xx",handler="/api/v1/query_range",type="metric"} 2
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="0.05"} 0
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="0.1"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="0.25"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="0.5"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="1"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="2.5"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="5"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="10"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="30"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="50"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="100"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="250"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="500"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="1000"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="2500"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Find_Traces",type="trace",le="+Inf"} 1
promscale_query_duration_seconds_sum{code="2xx",handler="Find_Traces",type="trace"} 0.07434122
promscale_query_duration_seconds_count{code="2xx",handler="Find_Traces",type="trace"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="0.05"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="0.1"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="0.25"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="0.5"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="1"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="2.5"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="5"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="10"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="30"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="50"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="100"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="250"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="500"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="1000"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="2500"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Operations",type="trace",le="+Inf"} 1
promscale_query_duration_seconds_sum{code="2xx",handler="Get_Operations",type="trace"} 0.002118969
promscale_query_duration_seconds_count{code="2xx",handler="Get_Operations",type="trace"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="0.05"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="0.1"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="0.25"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="0.5"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="1"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="2.5"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="5"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="10"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="30"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="50"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="100"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="250"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="500"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="1000"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="2500"} 1
promscale_query_duration_seconds_bucket{code="2xx",handler="Get_Services",type="trace",le="+Inf"} 1
promscale_query_duration_seconds_sum{code="2xx",handler="Get_Services",type="trace"} 0.001304601
promscale_query_duration_seconds_count{code="2xx",handler="Get_Services",type="trace"} 1
# HELP promscale_query_remote_read_queries_total Number of remote-read queries received.
# TYPE promscale_query_remote_read_queries_total counter
promscale_query_remote_read_queries_total{handler="/read",type="metric"} 0
# HELP promscale_query_requests_total Number of query requests to Promscale.
# TYPE promscale_query_requests_total counter
promscale_query_requests_total{code="2xx",handler="/api/v1/query",type="metric"} 2
promscale_query_requests_total{code="2xx",handler="/api/v1/query_range",type="metric"} 2
promscale_query_requests_total{code="2xx",handler="Find_Traces",type="trace"} 1
promscale_query_requests_total{code="2xx",handler="Get_Operations",type="trace"} 1
promscale_query_requests_total{code="2xx",handler="Get_Services",type="trace"} 1
promscale_query_requests_total{code="422",handler="/api/v1/query",type="metric"} 0
promscale_query_requests_total{code="422",handler="/api/v1/query_range",type="metric"} 0
promscale_query_requests_total{code="500",handler="/api/v1/query",type="metric"} 0
promscale_query_requests_total{code="500",handler="/api/v1/query_range",type="metric"} 0
promscale_query_requests_total{code="503",handler="/api/v1/query",type="metric"} 0
promscale_query_requests_total{code="503",handler="/api/v1/query_range",type="metric"} 0
# HELP promscale_series_cache_max_bytes The target for the maximum amount of memory the series_cache can use in bytes.
# TYPE promscale_series_cache_max_bytes gauge
promscale_series_cache_max_bytes 8.328595046e+09
# HELP promscale_trace_dependency_requests_executed_total Total number of dependency requests successfully executed.
# TYPE promscale_trace_dependency_requests_executed_total counter
promscale_trace_dependency_requests_executed_total 0
# HELP promscale_trace_query_requests_executed_total Total number of query requests successfully executed by /getTrace and /fetchTraces API.
# TYPE promscale_trace_query_requests_executed_total counter
promscale_trace_query_requests_executed_total 1

```
