/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.oracle;

import java.sql.Connection;
import java.util.Objects;
import schemacrawler.server.oracle.OracleDatabaseConnector;
import schemacrawler.tools.catalogloader.BaseCatalogLoader;
import schemacrawler.tools.executable.CommandDescription;
import us.fatehi.utility.database.SqlScript;

public final class OracleCatalogLoader
extends BaseCatalogLoader {
    public OracleCatalogLoader() {
        super(new CommandDescription("oracleloader", "Loader for Oracle databases"), -1);
    }

    public void loadCatalog() {
        if (!this.isDatabaseSystemIdentifier(OracleDatabaseConnector.DB_SERVER_TYPE.getDatabaseSystemIdentifier())) {
            return;
        }
        Connection connection = this.getConnection();
        Objects.requireNonNull(connection, "No connection provided");
        SqlScript.executeScriptFromResource((String)"/schemacrawler-oracle.before.sql", (Connection)connection);
    }
}

