/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxASFException;
import com.informix.jdbc.IfmxStatement;
import com.informix.jdbc.IfxCancelQueryImpl;
import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxNativeSQL;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSavepoint;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.PreparedStatementCache;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxWarnMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.lang.ref.WeakReference;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class IfxStatement
implements IfmxStatement {
    private static final Object logger = Trace.getLoggerForClass(IfxStatement.class);
    private String cursorName = null;
    protected boolean cursorOpen = false;
    private int maxRows = 0;
    protected final Trace trace;
    private boolean statementProcessed = false;
    private SQLWarning statementWarnings = null;
    private boolean calledgetResultSet = false;
    private boolean calledgetUpdateCount = false;
    private boolean autoFree = false;
    protected boolean poolable = false;
    protected boolean isRsHoldable = false;
    protected final IfxConnection jconn;
    protected final IfxProtocol prot;
    public String commandString = null;
    protected IfxResultSet currentResult = null;
    boolean escapeProcessing = true;
    protected int numqmarks = 0;
    private int ResultSetType = 1003;
    private int ResultSetConcurrency = 1007;
    private int FetchSize = 0;
    private int FetchDirection = 1000;
    private int fetchBufferSize = 0;
    protected Vector<String> BatchVector = new Vector();
    protected final Vector<IfxObject> BatchParamVector = new Vector();
    protected boolean executeBatchInProgress = false;
    protected IfxResultSetMetaData outputMetaData = null;
    protected int statementType = 0;
    private int maxFieldSize;
    protected boolean Closed = false;
    private int timeoutSeconds = 0;
    protected static final short SGK_NO_KEYS = 0;
    protected static final short SGK_ALL_KEYS = 1;
    protected static final short SGK_KEYS_BY_INDEX = 2;
    protected static final short SGK_KEYS_BY_NAME = 3;
    short SGK_returnGeneratedKeys = 0;
    protected int[] SGK_indexes = null;
    protected String[] SGK_names = null;
    protected IfxResultSetMetaData SGK_metaData = null;
    protected IfxClientResultSet SGK_resultSet = null;
    protected final PreparedStatementCache pool;
    private boolean closeOnCompletion;
    private Timer statementTimer = null;

    IfxStatement(IfxConnection conn) throws SQLException {
        if (conn == null || conn.isClosed()) {
            throw IfxErrMsg.getSQLException(-79730);
        }
        this.jconn = conn;
        this.autoFree = ((IfxSqliConnect)this.jconn).getAutoFree();
        this.pool = ((IfxSqliConnect)this.jconn).implicitCache;
        this.setResultSetHoldability(((IfxSqliConnect)this.jconn).isHoldable());
        this.prot = this.jconn.createProto();
        this.trace = this.jconn.getTrace();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "Statement.executeQuery(): sql = " + sql);
        }
        this.validate(sql);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeQueryImpl(this.isRsHoldable(), false);
    }

    @Override
    public ResultSet executeQuery(String sql, boolean withHold) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "Statement.executeQuery(sql,withHold): sql = " + sql + " , withHold = " + withHold);
        }
        this.validate(sql);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeQueryImpl(withHold, false);
    }

    void validate(String sql) throws SQLException {
        if (sql == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this.jconn.isClosed()) {
            throw IfxErrMsg.getSQLException(-79730, this.jconn);
        }
        this.commandString = this.escapeProcessing ? IfxNativeSQL.parseSQLString(this.jconn, sql) : sql;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "Statement.executeUpdate(): sql = " + sql);
        }
        this.SGK_returnGeneratedKeys = 0;
        return this.executeUpdateBody(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "Statement.executeUpdate(): sql = " + sql + " autoGeneratedKeys = " + autoGeneratedKeys);
        }
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxStatement:executeUpdate(String, int)not supported with server");
            }
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.executeUpdate(String, int)", this.jconn);
        }
        if (autoGeneratedKeys == 1) {
            this.SGK_returnGeneratedKeys = 1;
        } else if (autoGeneratedKeys == 2) {
            this.SGK_returnGeneratedKeys = 0;
        } else {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxStatement:executeUpdate(String, int)invalid return generated key value");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int)", this.jconn);
        }
        return this.executeUpdateBody(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "Statement.executeUpdate(String, int[]): sql = " + sql + " autoGeneratedKeys = " + columnIndexes);
        }
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxStatement:executeUpdate(String, int[])not supported with server");
            }
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.executeUpdate(String, int[])", this.jconn);
        }
        if (columnIndexes == null || columnIndexes.length <= 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxStatement:executeUpdate(String, int[]) error in specifying auto generated key");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int[])", this.jconn);
        }
        this.SGK_indexes = (int[])columnIndexes.clone();
        this.SGK_returnGeneratedKeys = (short)2;
        return this.executeUpdateBody(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "Statement.executeUpdate(String, String[]): sql = " + sql + " autoGeneratedKeys = " + columnNames);
        }
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxStatement:executeUpdate(String, String[])not supported with server");
            }
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.executeUpdate(String, String[])", this.jconn);
        }
        if (columnNames == null || columnNames.length <= 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxStatement:executeUpdate(String, String[]) error in specifying auto generated key");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, String[])", this.jconn);
        }
        this.SGK_names = (String[])columnNames.clone();
        this.SGK_returnGeneratedKeys = (short)3;
        return this.executeUpdateBody(sql);
    }

    private int executeUpdateBody(String sql) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.validate(sql);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeUpdateImpl();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "Statement.getGeneratedKeys() called");
        }
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxStatement:getGeneratedKeys()not supported with server");
            }
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.getGeneratedKeys()", this.jconn);
        }
        IfxSqli sqliProto = (IfxSqli)this.prot;
        if (sqliProto.SGK_rowColumn == null) {
            IfxResultSetMetaData rsmd = new IfxResultSetMetaData(0, this.jconn);
            this.SGK_resultSet = new IfxClientResultSet(this.jconn, rsmd);
        } else {
            this.SGK_metaData = (IfxResultSetMetaData)sqliProto.getSGK_metaData();
            this.SGK_resultSet = new IfxClientResultSet(this.jconn, this.SGK_metaData);
            while (sqliProto.getNextSGKRow()) {
                this.SGK_resultSet.newRow(1);
                for (int i = 1; i <= this.SGK_metaData.getColumnCount(); ++i) {
                    IfxObject colObject = sqliProto.SGK_rowColumn.getColumn(i);
                    this.SGK_resultSet.updateIfxObject(i, (Object)colObject);
                }
            }
        }
        this.SGK_resultSet.beforeFirst();
        this.SGK_resultSet.setType(1003);
        this.SGK_resultSet.setFetchDirection(1000);
        this.SGK_resultSet.setConcurrency(1007);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "Statement.getGeneratedKeys() exited");
        }
        return this.SGK_resultSet;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxStatement.close() called");
        }
        this.Closed = true;
        if (this.currentResult != null) {
            this.currentResult.close();
            this.currentResult = null;
        }
        if (this.cursorOpen) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "cursor is open");
            }
            this.prot.executeClose(this);
        }
        this.prot.executeRelease(this);
        ((IfxSqliConnect)this.jconn).removeFromStmtList(this);
        this.cursorName = null;
        this.statementWarnings = null;
        this.commandString = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxStatement.close() exited");
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (max < 0) {
            throw IfxErrMsg.getSQLException(-79877, this.jconn);
        }
        this.maxFieldSize = max;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxStatement:setMaxFileldSize(): Dummy  Implementation");
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (max < 0) {
            throw IfxErrMsg.getSQLMinorException(-79731, -80007, this.jconn);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.timeoutSeconds;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (seconds >= 0) {
            this.timeoutSeconds = seconds;
            if (this.statementTimer == null) {
                this.statementTimer = this.jconn.getStatementTimer();
            }
        } else {
            throw IfxErrMsg.getSQLException(-79773, this.jconn);
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        try {
            ((IfxSqliConnect)this.jconn).asfconn.sOOBSocket();
        }
        catch (IfxASFException asf) {
            throw IfxErrMsg.getSQLException(-908, this.jconn);
        }
    }

    private void addWarning(String message, String sqlstate) {
        this.chainWarnings(IfxWarnMsg.getSQLWarning(sqlstate, message));
    }

    void chainWarnings(SQLWarning warn) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxStatement.chainWarnings() called");
        }
        if (warn != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(warn);
            } else {
                this.statementWarnings = warn;
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxStatement.chainWarnings() exited");
        }
    }

    protected void transferWarnings() throws SQLException {
        SQLWarning warn;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxStatement.transferWarnings() called");
        }
        if (this.currentResult != null && (warn = this.currentResult.getWarnings()) != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(warn);
            } else {
                this.statementWarnings = warn;
            }
            this.currentResult.clearWarnings();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "IfxStatement.transferWarnings() exited");
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.currentResult != null) {
            this.chainWarnings(this.currentResult.getWarnings());
        }
        return this.statementWarnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.clearWarnings();
        }
        this.statementWarnings = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (name.length() <= 0) {
            throw IfxErrMsg.getSQLException(-79732, this.jconn);
        }
        this.cursorName = name;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.SGK_returnGeneratedKeys = 0;
        return this.executeBody(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.execute(String, int)", this.jconn);
        }
        if (autoGeneratedKeys == 1) {
            this.SGK_returnGeneratedKeys = 1;
        } else if (autoGeneratedKeys == 2) {
            this.SGK_returnGeneratedKeys = 0;
        } else {
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int)", this.jconn);
        }
        return this.executeBody(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.execute(String, int[])", this.jconn);
        }
        if (columnIndexes == null || columnIndexes.length <= 0) {
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int[])", this.jconn);
        }
        this.SGK_indexes = (int[])columnIndexes.clone();
        this.SGK_returnGeneratedKeys = (short)2;
        return this.executeBody(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.execute(String, String[])", this.jconn);
        }
        if (columnNames == null || columnNames.length <= 0) {
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, String[])", this.jconn);
        }
        this.SGK_names = (String[])columnNames.clone();
        this.SGK_returnGeneratedKeys = (short)3;
        return this.executeBody(sql);
    }

    private boolean executeBody(String sql) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "Statement.executeBody(): sql = " + sql);
        }
        this.validate(sql);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeImpl();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865);
        }
        this.chkAndSetGetRsltCalledFlag();
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733);
        }
        if (this.currentResult.isClosed() || this.currentResult.getUpdateCount() != -1) {
            return null;
        }
        this.currentResult.getMetaData().setUppercaseMetaData(this.jconn.isUpperCaseMetaDataLabels());
        return this.currentResult;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.calledgetUpdateCount) {
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetUpdateCount = true;
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        return this.currentResult.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.clearWarnings();
            this.currentResult.close();
        }
        this.resetMethodCalledFlags();
        return false;
    }

    public String getCursorName() throws SQLException {
        if (this.cursorName == null) {
            this.cursorName = this.getConnection().getGeneratedCursor();
        }
        return this.cursorName;
    }

    int getqmarks() {
        return this.numqmarks;
    }

    void setqmarks(int count) {
        this.numqmarks = count;
    }

    @Override
    public IfxConnection getConnection() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865);
        }
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730);
        }
        return this.jconn;
    }

    protected ResultSet executeQueryImpl(boolean withHold, boolean withReOptimzation) throws SQLException {
        if (!this.jconn.isDirect() && ((IfxSqliConnect)this.jconn).doesBlobNeedPurge()) {
            ((IfxSqliConnect)this.jconn).closeFinalizedBlobsOnServer();
        }
        this.resetMethodCalledFlags();
        if (TraceFlag.isTraceEnabled() && this.commandString != null) {
            this.trace.writeTrace(logger, 3, "Statement: commandString = " + this.commandString + "\nwithHold = " + withHold);
        }
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        this.clearWarnings();
        IfxCancelQueryImpl cancelTask = new IfxCancelQueryImpl(this);
        if (this.timeoutSeconds > 0) {
            this.statementTimer.schedule((TimerTask)cancelTask, (long)this.timeoutSeconds * 1000L);
        }
        try {
            this.currentResult.executeQuery(this.outputMetaData, withHold, withReOptimzation);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -710) {
                this.poolable = false;
            }
            throw e;
        }
        finally {
            if (this.timeoutSeconds > 0 && !cancelTask.cancel()) {
                throw new SQLTimeoutException("Statement execution exceeded timeout", IfxErrMsg.getSQLSTATE(-80505), -80505);
            }
        }
        if (!this.jconn.isDirect()) {
            IfxSqli pr = (IfxSqli)this.prot;
            ((IfxSqliConnect)this.jconn).changeStmtId(this, pr.getStatementID());
        }
        this.transferWarnings();
        if (!withHold) {
            this.addResultSetToSvpt(this.currentResult);
        }
        this.currentResult.getMetaData().setUppercaseMetaData(this.jconn.isUpperCaseMetaDataLabels());
        return this.currentResult;
    }

    int executeUpdateImpl() throws SQLException {
        this.resetMethodCalledFlags();
        int returnValue = 0;
        if (!this.jconn.isDirect() && ((IfxSqliConnect)this.jconn).doesBlobNeedPurge()) {
            ((IfxSqliConnect)this.jconn).closeFinalizedBlobsOnServer();
        }
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        if (TraceFlag.isTraceEnabled() && this.commandString != null) {
            this.trace.writeTrace(logger, 3, "Statement: commandString = " + this.commandString);
        }
        this.clearWarnings();
        IfxCancelQueryImpl cancelTask = new IfxCancelQueryImpl(this);
        if (this.timeoutSeconds > 0) {
            this.statementTimer.schedule((TimerTask)cancelTask, (long)this.timeoutSeconds * 1000L);
        }
        try {
            returnValue = this.currentResult.executeUpdate();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -710) {
                this.poolable = false;
            }
            throw e;
        }
        finally {
            if (this.timeoutSeconds > 0 && !cancelTask.cancel()) {
                throw new SQLTimeoutException("Statement execution exceeded timeout", IfxErrMsg.getSQLSTATE(-80505), -80505);
            }
        }
        if (returnValue == 0 && this.commandString.toLowerCase().indexOf("isolation") != -1) {
            ((IfxSqliConnect)this.jconn).setTxnIsolationLvl(this.commandString);
        }
        this.transferWarnings();
        return returnValue;
    }

    protected boolean executeImpl() throws SQLException {
        return this.executeImpl(this.isRsHoldable(), false);
    }

    boolean executeImpl(boolean holdable, boolean reOptimized) throws SQLException {
        boolean returnValue;
        this.resetMethodCalledFlags();
        if (!this.jconn.isDirect() && ((IfxSqliConnect)this.jconn).doesBlobNeedPurge()) {
            ((IfxSqliConnect)this.jconn).closeFinalizedBlobsOnServer();
        }
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        this.clearWarnings();
        IfxCancelQueryImpl cancelTask = new IfxCancelQueryImpl(this);
        if (this.timeoutSeconds > 0) {
            this.statementTimer.schedule((TimerTask)cancelTask, (long)this.timeoutSeconds * 1000L);
        }
        try {
            returnValue = this.currentResult.executeExecute(holdable, reOptimized, this.outputMetaData);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -710) {
                this.poolable = false;
            }
            throw e;
        }
        finally {
            if (this.timeoutSeconds > 0 && !cancelTask.cancel()) {
                throw new SQLTimeoutException("Statement execution exceeded timeout", IfxErrMsg.getSQLSTATE(-80505), -80505);
            }
        }
        this.transferWarnings();
        if (this.jconn.getCatalog() == null) {
            this.jconn.getPreparedStatementCache().clear();
        }
        return returnValue;
    }

    void resultSetClosed(IfxResultSet rs) throws SQLException {
        if (rs.equals(this.currentResult) && rs.isClosed() && this.closeOnCompletion) {
            this.currentResult = null;
            this.close();
        }
        if (this.autoFree) {
            this.Closed = true;
            ((IfxSqliConnect)this.jconn).removeFromStmtList(this);
        }
    }

    @Override
    public int getSerial() throws SQLException {
        if (this.currentResult == null) {
            return 0;
        }
        return this.currentResult.getSerial();
    }

    @Override
    public long getSerial8() throws SQLException {
        if (this.currentResult == null) {
            return 0L;
        }
        return this.currentResult.getSerial8();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865);
        }
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw IfxErrMsg.getSQLException(-79764);
        }
        if (this.getResultSetType() == 1003 && direction != 1000) {
            throw IfxErrMsg.getSQLException(-79765);
        }
        this.FetchDirection = direction;
    }

    @Override
    public int getFetchDirection() {
        return this.FetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (rows < 0 || this.maxRows != 0 && rows > this.maxRows) {
            throw IfxErrMsg.getSQLException(-79766, this.jconn);
        }
        this.FetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.FetchSize;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.ResultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.ResultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.validate(sql);
        this.commandString = this.commandString.trim();
        if (!this.commandString.endsWith(";")) {
            this.commandString = this.commandString + ";";
        }
        this.BatchVector.addElement(this.commandString);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.BatchVector.clear();
        this.scrubBatch();
    }

    protected void scrubBatch() {
        this.executeBatchInProgress = false;
        if (this.currentResult != null) {
            this.prot.clearBatch();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] statusArray = null;
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.executeBatchInProgress = true;
        this.commandString = "";
        if (this.BatchVector.isEmpty()) {
            return new int[0];
        }
        for (int i = 0; i < this.BatchVector.size(); ++i) {
            this.commandString = this.commandString + this.BatchVector.elementAt(i);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxStatement:commandString is " + this.commandString);
        }
        if (((IfxSqliConnect)this.jconn).isBatchUpdatePerSpec()) {
            try {
                int retval = this.executeUpdateImpl();
                IfxSqli prot = (IfxSqli)this.prot;
                ArrayList<Integer> BatchRowStatus = prot.batchRowStatus;
                statusArray = new int[BatchRowStatus.size()];
                for (int k = 0; k < BatchRowStatus.size(); ++k) {
                    statusArray[k] = BatchRowStatus.get(k);
                }
                prot.batchRowStatus.clear();
            }
            catch (SQLException e) {
                IfxSqli prot = (IfxSqli)this.prot;
                ArrayList<Integer> BatchRowStatus = prot.batchRowStatus;
                this.executeBatchInProgress = false;
                if (BatchRowStatus != null) {
                    statusArray = new int[BatchRowStatus.size()];
                    for (int k = 0; k < BatchRowStatus.size(); ++k) {
                        statusArray[k] = BatchRowStatus.get(k);
                    }
                    prot.batchRowStatus.clear();
                    this.clearBatch();
                    throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), statusArray);
                }
                this.clearBatch();
                throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), new int[0]);
            }
        }
        try {
            statusArray = new int[this.BatchVector.size()];
            statusArray[0] = this.executeUpdateImpl();
            for (int k = 1; k < this.BatchVector.size(); ++k) {
                statusArray[k] = -2;
            }
        }
        catch (SQLException e) {
            this.clearBatch();
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), new int[0]);
        }
        this.clearBatch();
        this.executeBatchInProgress = false;
        return statusArray;
    }

    protected void setResultSetType(int resultSetType) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxStatement:setResultSetType()");
        }
        if (resultSetType != 1004 && resultSetType != 1003) {
            this.addWarning(IfxErrMsg.getSQLException(-79775, this.jconn).toString(), "01000");
        }
        this.ResultSetType = resultSetType == 1005 ? 1004 : resultSetType;
    }

    protected void setResultSetConcurrency(int resultSetConcurrencyType) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxStatement:setResultSetConcurrency()");
        }
        if (resultSetConcurrencyType != 1008 && resultSetConcurrencyType != 1007) {
            throw IfxErrMsg.getSQLException(-79773, this.jconn);
        }
        this.ResultSetConcurrency = resultSetConcurrencyType;
    }

    @Override
    public void setAutoFree(boolean flag) {
        this.autoFree = flag && this.jconn.isAutoFree() ? flag : false;
    }

    void setResultSetHoldability(boolean rsHoldability) {
        this.isRsHoldable = rsHoldability;
    }

    @Override
    public boolean getAutoFree() {
        return this.autoFree;
    }

    protected void setStatementType(int stype) {
        this.statementType = stype;
    }

    @Override
    public int getStatementType() {
        return this.statementType;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxStatement:getMoreResults(int) not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": Statement.getMoreResults(int)", this.jconn);
    }

    @Override
    public int getResultSetHoldability() {
        return this.isRsHoldable() ? 1 : 2;
    }

    boolean isRsHoldable() {
        return this.isRsHoldable;
    }

    protected void chkAndSetGetRsltCalledFlag() throws SQLException {
        if (this.calledgetResultSet) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxStatement:getResultSet():getResultSet called twice");
            }
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetResultSet = true;
    }

    protected void resetMethodCalledFlags() {
        this.calledgetResultSet = false;
        this.calledgetUpdateCount = false;
    }

    void setIsReleased(boolean val) {
        IfxSqli sqliProto = (IfxSqli)this.prot;
        sqliProto.setIsReleased(val);
    }

    @Override
    public long getBigSerial() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxStatement:getBigSerial()");
        }
        if (this.currentResult == null) {
            return 0L;
        }
        return this.currentResult.getBigSerial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResultSetToSvpt(ResultSet rs) {
        if (((IfxSqliConnect)this.jconn).svptList != null) {
            ArrayList<WeakReference<Savepoint>> arrayList = ((IfxSqliConnect)this.jconn).svptList;
            synchronized (arrayList) {
                WeakReference<Savepoint> weakSvpt = null;
                IfxSavepoint svpt = null;
                Iterator<WeakReference<Savepoint>> it = ((IfxSqliConnect)this.jconn).svptList.iterator();
                while (it.hasNext()) {
                    weakSvpt = it.next();
                    svpt = (IfxSavepoint)weakSvpt.get();
                    if (svpt == null) {
                        it.remove();
                        continue;
                    }
                    svpt.addResultSet(rs);
                }
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.Closed || this.jconn.isClosed();
    }

    @Override
    public boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.poolable = poolable;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw IfxErrMsg.getSQLException(-80053, this.jconn, this.getClass().getCanonicalName(), iface.getClass().getCanonicalName());
    }

    @Override
    public void setFetchBufferSize(int bufferSize) {
        this.fetchBufferSize = bufferSize;
    }

    @Override
    public int getFetchBufferSize() {
        return this.fetchBufferSize;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }
}

