/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.tools.commandline.command.DatabaseConnectionGroupOptions;
import schemacrawler.tools.commandline.command.UserCredentialsOptions;
import schemacrawler.tools.commandline.state.BaseStateHolder;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.utility.SchemaCrawlerOptionsConfig;
import schemacrawler.tools.commandline.utility.SchemaRetrievalOptionsConfig;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectionSource;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.UserCredentials;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.string.StringFormat;

@CommandLine.Command(name="connect", header={"** Connect to the database"}, description={"", "For database connections, please read", "https://www.schemacrawler.com/database-support.html", "first, before running SchemaCrawler", ""}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"connect"}, optionListHeading="Options:%n", footer={"", "For additional options, specific to individual database server plugins,", "run SchemaCrawler with: `-h servers`", "or from the SchemaCrawler interactive shell: `help servers`"})
public class ConnectCommand
extends BaseStateHolder
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ConnectCommand.class.getName());
    @CommandLine.ArgGroup(exclusive=true)
    private DatabaseConnectionGroupOptions databaseConnectionGroupOptions;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin
    private UserCredentialsOptions userCredentialsOptions;

    public ConnectCommand(ShellState state) {
        super(state);
    }

    public DatabaseConnectionOptions getDatabaseConnectionOptions() {
        if (this.databaseConnectionGroupOptions == null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "No database connection options provided");
        }
        DatabaseConnectionOptions databaseConnectionOptions = this.databaseConnectionGroupOptions.getDatabaseConnectionOptions();
        if (databaseConnectionOptions == null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "No database connection options provided");
        }
        return databaseConnectionOptions;
    }

    @Override
    public void run() {
        try {
            DatabaseConnectionOptions databaseConnectionOptions = this.getDatabaseConnectionOptions();
            Objects.requireNonNull(databaseConnectionOptions, "No database connection options provided");
            DatabaseConnector databaseConnector = databaseConnectionOptions.getDatabaseConnector();
            Objects.requireNonNull(databaseConnector, "No database plugin located (not even unknown)");
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Using database plugin <%s>", new Object[]{databaseConnector.getDatabaseServerType()}));
            this.loadSchemaCrawlerOptionsBuilder(databaseConnector);
            this.createDataSource(databaseConnector, databaseConnectionOptions, this.getUserCredentials());
            this.loadSchemaRetrievalOptionsBuilder(databaseConnector);
        }
        catch (SQLException e) {
            throw new DatabaseAccessException("Cannot connect to database", e);
        }
    }

    private void createDataSource(DatabaseConnector databaseConnector, DatabaseConnectionOptions connectionOptions, UserCredentials userCredentials) {
        Objects.requireNonNull(databaseConnector, "No database plugin provided");
        Objects.requireNonNull(connectionOptions, "No database connection options provided");
        Objects.requireNonNull(userCredentials, "No database connection user credentials provided");
        LOGGER.log(Level.FINE, "Creating data-source");
        DatabaseConnectionSource databaseConnectionSource = databaseConnector.newDatabaseConnectionSource(connectionOptions);
        databaseConnectionSource.setUserCredentials(userCredentials);
        this.state.setDataSource((Supplier<Connection>)databaseConnectionSource);
    }

    private UserCredentials getUserCredentials() {
        if (this.userCredentialsOptions == null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "No database connection credentials provided");
        }
        UserCredentials userCredentials = this.userCredentialsOptions.getUserCredentials();
        return userCredentials;
    }

    private void loadSchemaCrawlerOptionsBuilder(DatabaseConnector databaseConnector) {
        LOGGER.log(Level.FINE, "Creating SchemaCrawler options builder");
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        schemaCrawlerOptions = databaseConnector.setSchemaCrawlerOptionsDefaults(schemaCrawlerOptions);
        Config config = this.state.getConfig();
        schemaCrawlerOptions = SchemaCrawlerOptionsConfig.fromConfig(schemaCrawlerOptions, config);
        this.state.setSchemaCrawlerOptions(schemaCrawlerOptions);
    }

    private void loadSchemaRetrievalOptionsBuilder(DatabaseConnector databaseConnector) throws SQLException {
        Objects.requireNonNull(databaseConnector, "No database connection options provided");
        LOGGER.log(Level.FINE, "Creating SchemaCrawler retrieval options builder");
        Config config = this.state.getConfig();
        try (Connection connection = this.state.getDataSource().get();){
            SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = databaseConnector.getSchemaRetrievalOptionsBuilder(connection);
            this.state.setSchemaRetrievalOptions(SchemaRetrievalOptionsConfig.fromConfig(schemaRetrievalOptionsBuilder, config).toOptions());
        }
    }
}

