/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.AbstractMap;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Table;

public final class ProposedWeakAssociation
extends AbstractMap.SimpleImmutableEntry<Column, Column> {
    private static final long serialVersionUID = 24677218335455928L;

    ProposedWeakAssociation(Column key, Column value) {
        super(key, value);
    }

    ProposedWeakAssociation(ColumnReference columnReference) {
        super(columnReference.getPrimaryKeyColumn(), columnReference.getForeignKeyColumn());
    }

    public boolean isValid() {
        Column pkColumn = (Column)this.getKey();
        Column fkColumn = (Column)this.getValue();
        if (pkColumn == null || fkColumn == null) {
            return false;
        }
        boolean isPkColumnPartial = pkColumn instanceof PartialDatabaseObject;
        boolean isFkColumnPartial = fkColumn instanceof PartialDatabaseObject;
        if (isFkColumnPartial && isPkColumnPartial) {
            return false;
        }
        if (pkColumn.equals(fkColumn)) {
            return false;
        }
        Table pkTable = (Table)pkColumn.getParent();
        Table fkTable = (Table)fkColumn.getParent();
        if ((fkColumn.isPartOfPrimaryKey() || fkColumn.isPartOfUniqueIndex()) && pkTable.compareTo(fkTable) > 0) {
            return false;
        }
        if (!pkColumn.isColumnDataTypeKnown() || !fkColumn.isColumnDataTypeKnown()) {
            return false;
        }
        ColumnDataType fkColumnType = fkColumn.getColumnDataType();
        ColumnDataType pkColumnType = pkColumn.getColumnDataType();
        boolean isValid = fkColumnType.getJavaSqlType().getName().equals(pkColumnType.getJavaSqlType().getName());
        return isValid;
    }
}

