/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.weakassociations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Table;
import us.fatehi.utility.PrefixMatches;

final class TableMatchKeys {
    private final PrefixMatches tableKeys;

    TableMatchKeys(List<Table> tables) {
        Objects.requireNonNull(tables, "No tables provided");
        this.tableKeys = this.analyzeTables(tables);
    }

    public List<String> get(Table table) {
        if (table == null) {
            return null;
        }
        return this.tableKeys.get(table.getName());
    }

    public String toString() {
        return this.tableKeys.toString();
    }

    private PrefixMatches analyzeTables(List<Table> tables) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table table : tables) {
            tableNames.add(table.getName());
        }
        return new PrefixMatches(tableNames, "_");
    }
}

