/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class LoggingConfig {
    public LoggingConfig() {
        this(null);
    }

    public LoggingConfig(Level level) {
        this.applyApplicationLogLevel(level);
    }

    private void applyApplicationLogLevel(Level applicationLogLevel) {
        Level logLevel = applicationLogLevel == null ? Level.OFF : applicationLogLevel;
        LogManager logManager = LogManager.getLogManager();
        ArrayList<String> loggerNames = Collections.list(logManager.getLoggerNames());
        for (String loggerName : loggerNames) {
            Logger logger = logManager.getLogger(loggerName);
            if (logger == null) continue;
            logger.setLevel(null);
            for (Handler handler : logger.getHandlers()) {
                try {
                    handler.setEncoding("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                handler.setLevel(logLevel);
            }
        }
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(logLevel);
        this.applySlf4jLogLevel(logLevel);
        this.applyPicocliLogLevel(logLevel);
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
        System.setProperty("log4j2.formatMsgNoLookups", "true");
    }

    private void applyPicocliLogLevel(Level logLevel) {
        String picocliLogLevel;
        String logLevelName;
        if (logLevel == null || System.getProperty("picocli.trace") == null) {
            return;
        }
        switch (logLevelName = logLevel.getName()) {
            case "OFF": {
                picocliLogLevel = "OFF";
                break;
            }
            case "SEVERE": 
            case "WARNING": {
                picocliLogLevel = "WARN";
                break;
            }
            case "CONFIG": 
            case "INFO": {
                picocliLogLevel = "INFO";
                break;
            }
            default: {
                picocliLogLevel = "DEBUG";
            }
        }
        System.setProperty("picocli.trace", picocliLogLevel);
    }

    private void applySlf4jLogLevel(Level logLevel) {
        String slf4jLogLevel;
        switch (logLevel.getName()) {
            case "OFF": {
                slf4jLogLevel = "off";
                break;
            }
            case "SEVERE": {
                slf4jLogLevel = "error";
                break;
            }
            case "WARNING": {
                slf4jLogLevel = "warn";
                break;
            }
            case "CONFIG": {
                slf4jLogLevel = "debug";
                break;
            }
            case "INFO": {
                slf4jLogLevel = "info";
                break;
            }
            default: {
                slf4jLogLevel = "trace";
            }
        }
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", slf4jLogLevel);
    }
}

