/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableResultsColumn;
import schemacrawler.crawl.MutableResultsColumns;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.TablePartial;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.utility.JavaSqlTypes;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class ResultsRetriever {
    private static final Logger LOGGER = Logger.getLogger(ResultsRetriever.class.getName());
    private final ResultSetMetaData resultsMetaData;
    private final JavaSqlTypes javaSqlTypes;
    private final NamedObjectList<Schema> schemas;
    private final NamedObjectList<Table> tables;

    ResultsRetriever(ResultSet resultSet) throws SQLException {
        Objects.requireNonNull(resultSet, "Cannot retrieve metadata for null results");
        this.resultsMetaData = resultSet.getMetaData();
        this.javaSqlTypes = new JavaSqlTypes();
        this.schemas = new NamedObjectList();
        this.tables = new NamedObjectList();
    }

    ResultsColumns retrieveResults() throws SQLException {
        MutableResultsColumns resultColumns = new MutableResultsColumns("");
        int columnCount = this.resultsMetaData.getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            int columnIndex = i++;
            String catalogName = this.execute("catalog name", () -> this.resultsMetaData.getCatalogName(columnIndex));
            String schemaName = this.execute("schema name", () -> this.resultsMetaData.getSchemaName(columnIndex));
            Schema schema = this.schemas.lookup(new NamedObjectKey(catalogName, schemaName)).orElseGet(() -> {
                SchemaReference newSchema = new SchemaReference(catalogName, schemaName);
                this.schemas.add(newSchema);
                return newSchema;
            });
            String tableName = Utility.trimToEmpty((String)this.execute("table name", () -> this.resultsMetaData.getTableName(columnIndex)));
            Table table = this.tables.lookup(schema, tableName).orElseGet(() -> {
                TablePartial newTable = new TablePartial(schema, tableName);
                this.tables.add(newTable);
                return newTable;
            });
            String columnName = this.execute("column name", () -> this.resultsMetaData.getColumnName(columnIndex));
            String columnLabel = this.execute("column label", () -> this.resultsMetaData.getColumnLabel(columnIndex));
            MutableResultsColumn column = new MutableResultsColumn(table, columnName, columnLabel);
            this.setColumnDataType(columnIndex, column);
            this.retrieveAdditionalColumnData(columnIndex, column);
            resultColumns.addColumn(column);
        }
        return resultColumns;
    }

    private String execute(String resultsColumnField, Callable<String> getResultsColumn) {
        try {
            return getResultsColumn.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not retrieve results column field, %s", new Object[]{resultsColumnField}));
            return null;
        }
    }

    private void retrieveAdditionalColumnData(int columnIndex, MutableResultsColumn column) {
        try {
            boolean isNullable = this.resultsMetaData.isNullable(columnIndex) == 1;
            column.setOrdinalPosition(columnIndex);
            column.setDisplaySize(this.resultsMetaData.getColumnDisplaySize(columnIndex));
            column.setAutoIncrement(this.resultsMetaData.isAutoIncrement(columnIndex));
            column.setCaseSensitive(this.resultsMetaData.isCaseSensitive(columnIndex));
            column.setCurrency(this.resultsMetaData.isCurrency(columnIndex));
            column.setDefinitelyWritable(this.resultsMetaData.isDefinitelyWritable(columnIndex));
            column.setNullable(isNullable);
            column.setReadOnly(this.resultsMetaData.isReadOnly(columnIndex));
            column.setSearchable(this.resultsMetaData.isSearchable(columnIndex));
            column.setSigned(this.resultsMetaData.isSigned(columnIndex));
            column.setWritable(this.resultsMetaData.isWritable(columnIndex));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not retrieve results column additional data for %s (%s)", new Object[]{column, column.getLabel()}));
        }
    }

    private void setColumnDataType(int columnIndex, MutableResultsColumn column) {
        Schema schema = column.getSchema();
        try {
            String databaseSpecificTypeName = this.resultsMetaData.getColumnTypeName(columnIndex);
            int javaSqlType = this.resultsMetaData.getColumnType(columnIndex);
            String columnClassName = this.resultsMetaData.getColumnClassName(columnIndex);
            MutableColumnDataType columnDataType = new MutableColumnDataType(schema, databaseSpecificTypeName, DataTypeType.user_defined);
            columnDataType.setJavaSqlType(this.javaSqlTypes.valueOf(javaSqlType));
            columnDataType.setTypeMappedClass(columnClassName);
            columnDataType.setPrecision(this.resultsMetaData.getPrecision(columnIndex));
            int scale = this.resultsMetaData.getScale(columnIndex);
            columnDataType.setMaximumScale(scale);
            columnDataType.setMinimumScale(scale);
            column.setColumnDataType(columnDataType);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not retrieve results column data type for %s (%s)", new Object[]{column, column.getLabel()}));
            MutableColumnDataType unknownColumnDataType = new MutableColumnDataType(schema, "<unknown>", DataTypeType.user_defined);
            unknownColumnDataType.setJavaSqlType(JavaSqlType.UNKNOWN);
            column.setColumnDataType(unknownColumnDataType);
        }
    }
}

