/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import schemacrawler.filter.TableTypesFilter;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import us.fatehi.utility.Utility;

public class LinterNullIntendedColumns
extends BaseLinter {
    public LinterNullIntendedColumns() {
        this.setTableTypesFilter(new TableTypesFilter(new String[]{"TABLE"}));
    }

    @Override
    public String getSummary() {
        return "column where NULL may be intended";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        List<Column> nullDefaultValueMayBeIntendedColumns = this.findNullDefaultValueMayBeIntendedColumns(this.getColumns(table));
        for (Column column : nullDefaultValueMayBeIntendedColumns) {
            this.addTableLint(table, this.getSummary(), column);
        }
    }

    private List<Column> findNullDefaultValueMayBeIntendedColumns(List<Column> columns) {
        ArrayList<Column> nullDefaultValueMayBeIntendedColumns = new ArrayList<Column>();
        for (Column column : columns) {
            String columnDefaultValue = column.getDefaultValue();
            if (Utility.isBlank((CharSequence)columnDefaultValue) || !columnDefaultValue.trim().equalsIgnoreCase("NULL")) continue;
            nullDefaultValueMayBeIntendedColumns.add(column);
        }
        return nullDefaultValueMayBeIntendedColumns;
    }
}

