////////////////////////////////////////////////////////////////////////////////
//
// Copyright 2016, 2018 - 2021, Thomas Lauf, Paul Beckingham, Federico Hernandez.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// https://www.opensource.org/licenses/mit-license.php
//
////////////////////////////////////////////////////////////////////////////////

#include <Color.h>
#include <timew.h>
#include <iostream>
#include <sstream>

static bool debugMode = false;
static std::string debugIndicator = ">>";
static Color debugColor;

////////////////////////////////////////////////////////////////////////////////
void enableDebugMode (bool value)
{
  debugMode = value;
}

////////////////////////////////////////////////////////////////////////////////
void setDebugIndicator (const std::string& indicator)
{
  debugIndicator = indicator;
}

////////////////////////////////////////////////////////////////////////////////
void setDebugColor (const Color& color)
{
  debugColor = color;
}

////////////////////////////////////////////////////////////////////////////////
void debug (const std::string& msg)
{
  if (debugMode)
  {
    std::stringstream sstr (msg);
    std::string line;
    while (std::getline (sstr, line, '\n'))
    {
      std::cout << debugColor.colorize (debugIndicator + " " + line) << "\n";
    }
  }
}

////////////////////////////////////////////////////////////////////////////////
