/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagFileInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import jakarta.servlet.jsp.tagext.TagLibraryInfo;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.util.Collection;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.AttributeParser;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.ImplicitTagLibraryInfo;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagConstants;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.util.UniqueAttributesImpl;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class Parser
implements TagConstants {
    private final ParserController parserController;
    private final JspCompilationContext ctxt;
    private final JspReader reader;
    private Mark start;
    private final ErrorDispatcher err;
    private int scriptlessCount;
    private final boolean isTagFile;
    private final boolean directivesOnly;
    private final Jar jar;
    private final PageInfo pageInfo;
    private static final String JAVAX_BODY_CONTENT_PARAM = "JAVAX_BODY_CONTENT_PARAM";
    private static final String JAVAX_BODY_CONTENT_PLUGIN = "JAVAX_BODY_CONTENT_PLUGIN";
    private static final String JAVAX_BODY_CONTENT_TEMPLATE_TEXT = "JAVAX_BODY_CONTENT_TEMPLATE_TEXT";

    private Parser(ParserController parserController, JspReader jspReader, boolean bl, boolean bl2, Jar jar) {
        this.parserController = parserController;
        this.ctxt = parserController.getJspCompilationContext();
        this.pageInfo = parserController.getCompiler().getPageInfo();
        this.err = parserController.getCompiler().getErrorDispatcher();
        this.reader = jspReader;
        this.scriptlessCount = 0;
        this.isTagFile = bl;
        this.directivesOnly = bl2;
        this.jar = jar;
        this.start = jspReader.mark();
    }

    public static Node.Nodes parse(ParserController parserController, JspReader jspReader, Node node, boolean bl, boolean bl2, Jar jar, String string, String string2, boolean bl3, boolean bl4) throws JasperException {
        Parser parser = new Parser(parserController, jspReader, bl, bl2, jar);
        Node.Root root = new Node.Root(jspReader.mark(), node, false, parserController.getJspCompilationContext().getOptions().getTempVariableNamePrefix());
        root.setPageEncoding(string);
        root.setJspConfigPageEncoding(string2);
        root.setIsDefaultPageEncoding(bl3);
        root.setIsBomPresent(bl4);
        PageInfo pageInfo = parserController.getCompiler().getPageInfo();
        if (node == null && !bl) {
            parser.addInclude(root, pageInfo.getIncludePrelude());
        }
        if (bl2) {
            parser.parseFileDirectives(root);
        } else {
            while (jspReader.hasMoreInput()) {
                parser.parseElements(root);
            }
        }
        if (node == null && !bl) {
            parser.addInclude(root, pageInfo.getIncludeCoda());
        }
        Node.Nodes nodes = new Node.Nodes(root);
        return nodes;
    }

    Attributes parseAttributes() throws JasperException {
        return this.parseAttributes(false);
    }

    Attributes parseAttributes(boolean bl) throws JasperException {
        UniqueAttributesImpl uniqueAttributesImpl = new UniqueAttributesImpl(bl);
        this.reader.skipSpaces();
        int n = 1;
        try {
            while (this.parseAttribute(uniqueAttributesImpl)) {
                if (n == 0 && this.ctxt.getOptions().getStrictWhitespace()) {
                    this.err.jspError(this.reader.mark(), "jsp.error.attribute.nowhitespace", new String[0]);
                }
                n = this.reader.skipSpaces();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.err.jspError(this.reader.mark(), "jsp.error.attribute.duplicate", new String[0]);
        }
        return uniqueAttributesImpl;
    }

    public static Attributes parseAttributes(ParserController parserController, JspReader jspReader) throws JasperException {
        Parser parser = new Parser(parserController, jspReader, false, false, null);
        return parser.parseAttributes(true);
    }

    private boolean parseAttribute(AttributesImpl attributesImpl) throws JasperException {
        String string = this.parseName();
        if (string == null) {
            return false;
        }
        boolean bl = this.pageInfo.isELIgnored();
        String string2 = string;
        String string3 = "";
        int n = string.indexOf(58);
        if (n != -1) {
            String string4 = string.substring(0, n);
            string3 = this.pageInfo.getURI(string4);
            if (string3 == null) {
                this.err.jspError(this.reader.mark(), "jsp.error.attribute.invalidPrefix", string4);
            }
            string2 = string.substring(n + 1);
        }
        this.reader.skipSpaces();
        if (!this.reader.matches("=")) {
            this.err.jspError(this.reader.mark(), "jsp.error.attribute.noequal", new String[0]);
        }
        this.reader.skipSpaces();
        char c = (char)this.reader.nextChar();
        if (c != '\'' && c != '\"') {
            this.err.jspError(this.reader.mark(), "jsp.error.attribute.noquote", new String[0]);
        }
        String string5 = "";
        if (this.reader.matches("<%=")) {
            string5 = "%>";
            bl = true;
        }
        string5 = string5 + c;
        String string6 = this.parseAttributeValue(string, string5, bl);
        attributesImpl.addAttribute(string3, string2, string, "CDATA", string6);
        return true;
    }

    private String parseName() {
        char c = (char)this.reader.peekChar();
        if (Character.isLetter(c) || c == '_' || c == ':') {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(c);
            this.reader.nextChar();
            c = (char)this.reader.peekChar();
            while (Character.isLetter(c) || Character.isDigit(c) || c == '.' || c == '_' || c == '-' || c == ':') {
                stringBuilder.append(c);
                this.reader.nextChar();
                c = (char)this.reader.peekChar();
            }
            return stringBuilder.toString();
        }
        return null;
    }

    private String parseAttributeValue(String string, String string2, boolean bl) throws JasperException {
        boolean bl2 = this.ctxt.getOptions().getQuoteAttributeEL();
        Mark mark = this.reader.mark();
        Mark mark2 = this.reader.skipUntilIgnoreEsc(string2, bl || bl2);
        if (mark2 == null) {
            this.err.jspError(mark, "jsp.error.attribute.unterminated", string);
        }
        String string3 = null;
        try {
            char c = string2.charAt(string2.length() - 1);
            boolean bl3 = this.pageInfo.isELIgnored() || string2.length() > 1;
            string3 = AttributeParser.getUnquoted(this.reader.getText(mark, mark2), c, bl3, this.pageInfo.isDeferredSyntaxAllowedAsLiteral(), this.ctxt.getOptions().getStrictQuoteEscaping(), bl2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.err.jspError(mark, illegalArgumentException.getMessage(), new String[0]);
        }
        if (string2.length() == 1) {
            return string3;
        }
        return "<%=" + string3 + "%>";
    }

    private String parseScriptText(String string) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (n2 + 2 < n && c == '%' && string.charAt(n2 + 1) == '\\' && string.charAt(n2 + 2) == '>') {
                charArrayWriter.write(37);
                charArrayWriter.write(62);
                n2 += 3;
                continue;
            }
            charArrayWriter.write(c);
            ++n2;
        }
        charArrayWriter.close();
        return charArrayWriter.toString();
    }

    private void processIncludeDirective(String string, Node node) throws JasperException {
        if (string == null) {
            return;
        }
        try {
            this.parserController.parse(string, node, this.jar);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.err.jspError(this.start, "jsp.error.file.not.found", string);
        }
        catch (Exception exception) {
            this.err.jspError(this.start, exception.getMessage(), new String[0]);
        }
    }

    private void parsePageDirective(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes(true);
        Node.PageDirective pageDirective = new Node.PageDirective(attributes, this.start, node);
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!"import".equals(attributes.getQName(i))) continue;
            pageDirective.addImport(attributes.getValue(i));
        }
    }

    private void parseIncludeDirective(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        Node.IncludeDirective includeDirective = new Node.IncludeDirective(attributes, this.start, node);
        this.processIncludeDirective(attributes.getValue("file"), includeDirective);
    }

    private void addInclude(Node node, Collection<String> collection) throws JasperException {
        if (collection != null) {
            for (String string : collection) {
                AttributesImpl attributesImpl = new AttributesImpl();
                attributesImpl.addAttribute("", "file", "file", "CDATA", string);
                Node.IncludeDirective includeDirective = new Node.IncludeDirective(attributesImpl, this.reader.mark(), node);
                this.processIncludeDirective(string, includeDirective);
            }
        }
    }

    private void parseTaglibDirective(Node node) throws JasperException {
        Object object;
        Attributes attributes = this.parseAttributes();
        String string = attributes.getValue("uri");
        String string2 = attributes.getValue("prefix");
        if (string2 != null) {
            object = this.pageInfo.getNonCustomTagPrefix(string2);
            if (object != null) {
                this.err.jspError(this.reader.mark(), "jsp.error.prefix.use_before_dcl", string2, ((Mark)object).getFile(), "" + ((Mark)object).getLineNumber());
            }
            if (string != null) {
                String string3 = this.pageInfo.getURI(string2);
                if (string3 != null && !string3.equals(string)) {
                    this.err.jspError(this.reader.mark(), "jsp.error.prefix.refined", string2, string, string3);
                }
                if (this.pageInfo.getTaglib(string) == null) {
                    TagLibraryInfoImpl tagLibraryInfoImpl = null;
                    if (this.ctxt.getOptions().isCaching()) {
                        tagLibraryInfoImpl = (TagLibraryInfoImpl)this.ctxt.getOptions().getCache().get(string);
                    }
                    if (tagLibraryInfoImpl == null) {
                        TldResourcePath tldResourcePath = this.ctxt.getTldResourcePath(string);
                        tagLibraryInfoImpl = new TagLibraryInfoImpl(this.ctxt, this.parserController, this.pageInfo, string2, string, tldResourcePath, this.err);
                        if (this.ctxt.getOptions().isCaching()) {
                            this.ctxt.getOptions().getCache().put(string, tagLibraryInfoImpl);
                        }
                    }
                    this.pageInfo.addTaglib(string, tagLibraryInfoImpl);
                }
                this.pageInfo.addPrefixMapping(string2, string);
            } else {
                String string4 = attributes.getValue("tagdir");
                if (string4 != null) {
                    String string5 = "urn:jsptagdir:" + string4;
                    if (this.pageInfo.getTaglib(string5) == null) {
                        this.pageInfo.addTaglib(string5, new ImplicitTagLibraryInfo(this.ctxt, this.parserController, this.pageInfo, string2, string4, this.err));
                    }
                    this.pageInfo.addPrefixMapping(string2, string5);
                }
            }
        }
        object = new Node.TaglibDirective(attributes, this.start, node);
    }

    private void parseDirective(Node node) throws JasperException {
        this.reader.skipSpaces();
        String string = null;
        if (this.reader.matches("page")) {
            string = "&lt;%@ page";
            if (this.isTagFile) {
                this.err.jspError(this.reader.mark(), "jsp.error.directive.istagfile", string);
            }
            this.parsePageDirective(node);
        } else if (this.reader.matches("include")) {
            string = "&lt;%@ include";
            this.parseIncludeDirective(node);
        } else if (this.reader.matches("taglib")) {
            if (this.directivesOnly) {
                return;
            }
            string = "&lt;%@ taglib";
            this.parseTaglibDirective(node);
        } else if (this.reader.matches("tag")) {
            string = "&lt;%@ tag";
            if (!this.isTagFile) {
                this.err.jspError(this.reader.mark(), "jsp.error.directive.isnottagfile", string);
            }
            this.parseTagDirective(node);
        } else if (this.reader.matches("attribute")) {
            string = "&lt;%@ attribute";
            if (!this.isTagFile) {
                this.err.jspError(this.reader.mark(), "jsp.error.directive.isnottagfile", string);
            }
            this.parseAttributeDirective(node);
        } else if (this.reader.matches("variable")) {
            string = "&lt;%@ variable";
            if (!this.isTagFile) {
                this.err.jspError(this.reader.mark(), "jsp.error.directive.isnottagfile", string);
            }
            this.parseVariableDirective(node);
        } else {
            this.err.jspError(this.reader.mark(), "jsp.error.invalid.directive", new String[0]);
        }
        this.reader.skipSpaces();
        if (!this.reader.matches("%>")) {
            this.err.jspError(this.start, "jsp.error.unterminated", string);
        }
    }

    private void parseXMLDirective(Node node) throws JasperException {
        this.reader.skipSpaces();
        String string = null;
        if (this.reader.matches("page")) {
            string = "jsp:directive.page";
            if (this.isTagFile) {
                this.err.jspError(this.reader.mark(), "jsp.error.directive.istagfile", "&lt;" + string);
            }
            this.parsePageDirective(node);
        } else if (this.reader.matches("include")) {
            string = "jsp:directive.include";
            this.parseIncludeDirective(node);
        } else if (this.reader.matches("tag")) {
            string = "jsp:directive.tag";
            if (!this.isTagFile) {
                this.err.jspError(this.reader.mark(), "jsp.error.directive.isnottagfile", "&lt;" + string);
            }
            this.parseTagDirective(node);
        } else if (this.reader.matches("attribute")) {
            string = "jsp:directive.attribute";
            if (!this.isTagFile) {
                this.err.jspError(this.reader.mark(), "jsp.error.directive.isnottagfile", "&lt;" + string);
            }
            this.parseAttributeDirective(node);
        } else if (this.reader.matches("variable")) {
            string = "jsp:directive.variable";
            if (!this.isTagFile) {
                this.err.jspError(this.reader.mark(), "jsp.error.directive.isnottagfile", "&lt;" + string);
            }
            this.parseVariableDirective(node);
        } else {
            this.err.jspError(this.reader.mark(), "jsp.error.invalid.directive", new String[0]);
        }
        this.reader.skipSpaces();
        if (this.reader.matches(">")) {
            this.reader.skipSpaces();
            if (!this.reader.matchesETag(string)) {
                this.err.jspError(this.start, "jsp.error.unterminated", "&lt;" + string);
            }
        } else if (!this.reader.matches("/>")) {
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;" + string);
        }
    }

    private void parseTagDirective(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes(true);
        Node.TagDirective tagDirective = new Node.TagDirective(attributes, this.start, node);
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!"import".equals(attributes.getQName(i))) continue;
            tagDirective.addImport(attributes.getValue(i));
        }
    }

    private void parseAttributeDirective(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        Node.AttributeDirective attributeDirective = new Node.AttributeDirective(attributes, this.start, node);
    }

    private void parseVariableDirective(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        Node.VariableDirective variableDirective = new Node.VariableDirective(attributes, this.start, node);
    }

    private void parseComment(Node node) throws JasperException {
        this.start = this.reader.mark();
        Mark mark = this.reader.skipUntil("--%>");
        if (mark == null) {
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;%--");
        }
        Node.Comment comment = new Node.Comment(this.reader.getText(this.start, mark), this.start, node);
    }

    private void parseDeclaration(Node node) throws JasperException {
        this.start = this.reader.mark();
        Mark mark = this.reader.skipUntil("%>");
        if (mark == null) {
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;%!");
        }
        Node.Declaration declaration = new Node.Declaration(this.parseScriptText(this.reader.getText(this.start, mark)), this.start, node);
    }

    private void parseXMLDeclaration(Node node) throws JasperException {
        this.reader.skipSpaces();
        if (!this.reader.matches("/>")) {
            if (!this.reader.matches(">")) {
                this.err.jspError(this.start, "jsp.error.unterminated", "&lt;jsp:declaration&gt;");
            }
            while (true) {
                this.start = this.reader.mark();
                Mark mark = this.reader.skipUntil("<");
                if (mark == null) {
                    this.err.jspError(this.start, "jsp.error.unterminated", "&lt;jsp:declaration&gt;");
                }
                String string = this.parseScriptText(this.reader.getText(this.start, mark));
                Node.Declaration declaration = new Node.Declaration(string, this.start, node);
                if (!this.reader.matches("![CDATA[")) break;
                this.start = this.reader.mark();
                mark = this.reader.skipUntil("]]>");
                if (mark == null) {
                    this.err.jspError(this.start, "jsp.error.unterminated", "CDATA");
                }
                string = this.parseScriptText(this.reader.getText(this.start, mark));
                Node.Declaration declaration2 = new Node.Declaration(string, this.start, node);
            }
            if (!this.reader.matchesETagWithoutLessThan("jsp:declaration")) {
                this.err.jspError(this.start, "jsp.error.unterminated", "&lt;jsp:declaration&gt;");
            }
        }
    }

    private void parseExpression(Node node) throws JasperException {
        this.start = this.reader.mark();
        Mark mark = this.reader.skipUntil("%>");
        if (mark == null) {
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;%=");
        }
        Node.Expression expression = new Node.Expression(this.parseScriptText(this.reader.getText(this.start, mark)), this.start, node);
    }

    private void parseXMLExpression(Node node) throws JasperException {
        this.reader.skipSpaces();
        if (!this.reader.matches("/>")) {
            if (!this.reader.matches(">")) {
                this.err.jspError(this.start, "jsp.error.unterminated", "&lt;jsp:expression&gt;");
            }
            while (true) {
                this.start = this.reader.mark();
                Mark mark = this.reader.skipUntil("<");
                if (mark == null) {
                    this.err.jspError(this.start, "jsp.error.unterminated", "&lt;jsp:expression&gt;");
                }
                String string = this.parseScriptText(this.reader.getText(this.start, mark));
                Node.Expression expression = new Node.Expression(string, this.start, node);
                if (!this.reader.matches("![CDATA[")) break;
                this.start = this.reader.mark();
                mark = this.reader.skipUntil("]]>");
                if (mark == null) {
                    this.err.jspError(this.start, "jsp.error.unterminated", "CDATA");
                }
                string = this.parseScriptText(this.reader.getText(this.start, mark));
                Node.Expression expression2 = new Node.Expression(string, this.start, node);
            }
            if (!this.reader.matchesETagWithoutLessThan("jsp:expression")) {
                this.err.jspError(this.start, "jsp.error.unterminated", "&lt;jsp:expression&gt;");
            }
        }
    }

    private void parseELExpression(Node node, char c) throws JasperException {
        this.start = this.reader.mark();
        Mark mark = this.reader.skipELExpression();
        if (mark == null) {
            this.err.jspError(this.start, "jsp.error.unterminated", c + "{");
        }
        Node.ELExpression eLExpression = new Node.ELExpression(c, this.reader.getText(this.start, mark), this.start, node);
    }

    private void parseScriptlet(Node node) throws JasperException {
        this.start = this.reader.mark();
        Mark mark = this.reader.skipUntil("%>");
        if (mark == null) {
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;%");
        }
        Node.Scriptlet scriptlet = new Node.Scriptlet(this.parseScriptText(this.reader.getText(this.start, mark)), this.start, node);
    }

    private void parseXMLScriptlet(Node node) throws JasperException {
        this.reader.skipSpaces();
        if (!this.reader.matches("/>")) {
            if (!this.reader.matches(">")) {
                this.err.jspError(this.start, "jsp.error.unterminated", "&lt;jsp:scriptlet&gt;");
            }
            while (true) {
                this.start = this.reader.mark();
                Mark mark = this.reader.skipUntil("<");
                if (mark == null) {
                    this.err.jspError(this.start, "jsp.error.unterminated", "&lt;jsp:scriptlet&gt;");
                }
                String string = this.parseScriptText(this.reader.getText(this.start, mark));
                Node.Scriptlet scriptlet = new Node.Scriptlet(string, this.start, node);
                if (!this.reader.matches("![CDATA[")) break;
                this.start = this.reader.mark();
                mark = this.reader.skipUntil("]]>");
                if (mark == null) {
                    this.err.jspError(this.start, "jsp.error.unterminated", "CDATA");
                }
                string = this.parseScriptText(this.reader.getText(this.start, mark));
                Node.Scriptlet scriptlet2 = new Node.Scriptlet(string, this.start, node);
            }
            if (!this.reader.matchesETagWithoutLessThan("jsp:scriptlet")) {
                this.err.jspError(this.start, "jsp.error.unterminated", "&lt;jsp:scriptlet&gt;");
            }
        }
    }

    private void parseParam(Node node) throws JasperException {
        if (!this.reader.matches("<jsp:param")) {
            this.err.jspError(this.reader.mark(), "jsp.error.paramexpected", new String[0]);
        }
        Attributes attributes = this.parseAttributes();
        this.reader.skipSpaces();
        Node.ParamAction paramAction = new Node.ParamAction(attributes, this.start, node);
        this.parseEmptyBody(paramAction, "jsp:param");
        this.reader.skipSpaces();
    }

    private void parseInclude(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        this.reader.skipSpaces();
        Node.IncludeAction includeAction = new Node.IncludeAction(attributes, this.start, node);
        this.parseOptionalBody(includeAction, "jsp:include", JAVAX_BODY_CONTENT_PARAM);
    }

    private void parseForward(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        this.reader.skipSpaces();
        Node.ForwardAction forwardAction = new Node.ForwardAction(attributes, this.start, node);
        this.parseOptionalBody(forwardAction, "jsp:forward", JAVAX_BODY_CONTENT_PARAM);
    }

    private void parseInvoke(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        this.reader.skipSpaces();
        Node.InvokeAction invokeAction = new Node.InvokeAction(attributes, this.start, node);
        this.parseEmptyBody(invokeAction, "jsp:invoke");
    }

    private void parseDoBody(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        this.reader.skipSpaces();
        Node.DoBodyAction doBodyAction = new Node.DoBodyAction(attributes, this.start, node);
        this.parseEmptyBody(doBodyAction, "jsp:doBody");
    }

    private void parseElement(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        this.reader.skipSpaces();
        Node.JspElement jspElement = new Node.JspElement(attributes, this.start, node);
        this.parseOptionalBody(jspElement, "jsp:element", "JSP");
    }

    private void parseGetProperty(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        this.reader.skipSpaces();
        Node.GetProperty getProperty = new Node.GetProperty(attributes, this.start, node);
        this.parseOptionalBody(getProperty, "jsp:getProperty", "empty");
    }

    private void parseSetProperty(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        this.reader.skipSpaces();
        Node.SetProperty setProperty = new Node.SetProperty(attributes, this.start, node);
        this.parseOptionalBody(setProperty, "jsp:setProperty", "empty");
    }

    private void parseEmptyBody(Node node, String string) throws JasperException {
        if (!this.reader.matches("/>")) {
            if (this.reader.matches(">")) {
                if (!this.reader.matchesETag(string)) {
                    if (this.reader.matchesOptionalSpacesFollowedBy("<jsp:attribute")) {
                        this.parseNamedAttributes(node);
                        if (!this.reader.matchesETag(string)) {
                            this.err.jspError(this.reader.mark(), "jsp.error.jspbody.emptybody.only", "&lt;" + string);
                        }
                    } else {
                        this.err.jspError(this.reader.mark(), "jsp.error.jspbody.emptybody.only", "&lt;" + string);
                    }
                }
            } else {
                this.err.jspError(this.reader.mark(), "jsp.error.unterminated", "&lt;" + string);
            }
        }
    }

    private void parseUseBean(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        this.reader.skipSpaces();
        Node.UseBean useBean = new Node.UseBean(attributes, this.start, node);
        this.parseOptionalBody(useBean, "jsp:useBean", "JSP");
    }

    private void parseOptionalBody(Node node, String string, String string2) throws JasperException {
        if (this.reader.matches("/>")) {
            return;
        }
        if (!this.reader.matches(">")) {
            this.err.jspError(this.reader.mark(), "jsp.error.unterminated", "&lt;" + string);
        }
        if (this.reader.matchesETag(string)) {
            return;
        }
        if (!this.parseJspAttributeAndBody(node, string, string2)) {
            this.parseBody(node, string, string2);
        }
    }

    private boolean parseJspAttributeAndBody(Node node, String string, String string2) throws JasperException {
        boolean bl = false;
        if (this.reader.matchesOptionalSpacesFollowedBy("<jsp:attribute")) {
            this.parseNamedAttributes(node);
            bl = true;
        }
        if (this.reader.matchesOptionalSpacesFollowedBy("<jsp:body")) {
            this.parseJspBody(node, string2);
            this.reader.skipSpaces();
            if (!this.reader.matchesETag(string)) {
                this.err.jspError(this.reader.mark(), "jsp.error.unterminated", "&lt;" + string);
            }
            bl = true;
        } else if (bl && !this.reader.matchesETag(string)) {
            this.err.jspError(this.reader.mark(), "jsp.error.jspbody.required", "&lt;" + string);
        }
        return bl;
    }

    private void parseJspParams(Node node) throws JasperException {
        Node.ParamsAction paramsAction = new Node.ParamsAction(this.start, node);
        this.parseOptionalBody(paramsAction, "jsp:params", JAVAX_BODY_CONTENT_PARAM);
    }

    private void parseFallBack(Node node) throws JasperException {
        Node.FallBackAction fallBackAction = new Node.FallBackAction(this.start, node);
        this.parseOptionalBody(fallBackAction, "jsp:fallback", JAVAX_BODY_CONTENT_TEMPLATE_TEXT);
    }

    private void parsePlugin(Node node) throws JasperException {
        Attributes attributes = this.parseAttributes();
        this.reader.skipSpaces();
        Node.PlugIn plugIn = new Node.PlugIn(attributes, this.start, node);
        this.parseOptionalBody(plugIn, "jsp:plugin", JAVAX_BODY_CONTENT_PLUGIN);
    }

    private void parsePluginTags(Node node) throws JasperException {
        this.reader.skipSpaces();
        if (this.reader.matches("<jsp:params")) {
            this.parseJspParams(node);
            this.reader.skipSpaces();
        }
        if (this.reader.matches("<jsp:fallback")) {
            this.parseFallBack(node);
            this.reader.skipSpaces();
        }
    }

    private void parseStandardAction(Node node) throws JasperException {
        Mark mark = this.reader.mark();
        if (this.reader.matches("include")) {
            this.parseInclude(node);
        } else if (this.reader.matches("forward")) {
            this.parseForward(node);
        } else if (this.reader.matches("invoke")) {
            if (!this.isTagFile) {
                this.err.jspError(this.reader.mark(), "jsp.error.action.isnottagfile", "&lt;jsp:invoke");
            }
            this.parseInvoke(node);
        } else if (this.reader.matches("doBody")) {
            if (!this.isTagFile) {
                this.err.jspError(this.reader.mark(), "jsp.error.action.isnottagfile", "&lt;jsp:doBody");
            }
            this.parseDoBody(node);
        } else if (this.reader.matches("getProperty")) {
            this.parseGetProperty(node);
        } else if (this.reader.matches("setProperty")) {
            this.parseSetProperty(node);
        } else if (this.reader.matches("useBean")) {
            this.parseUseBean(node);
        } else if (this.reader.matches("plugin")) {
            this.parsePlugin(node);
        } else if (this.reader.matches("element")) {
            this.parseElement(node);
        } else if (this.reader.matches("attribute")) {
            this.err.jspError(mark, "jsp.error.namedAttribute.invalidUse", new String[0]);
        } else if (this.reader.matches("body")) {
            this.err.jspError(mark, "jsp.error.jspbody.invalidUse", new String[0]);
        } else if (this.reader.matches("fallback")) {
            this.err.jspError(mark, "jsp.error.fallback.invalidUse", new String[0]);
        } else if (this.reader.matches("params")) {
            this.err.jspError(mark, "jsp.error.params.invalidUse", new String[0]);
        } else if (this.reader.matches("param")) {
            this.err.jspError(mark, "jsp.error.param.invalidUse", new String[0]);
        } else if (this.reader.matches("output")) {
            this.err.jspError(mark, "jsp.error.jspoutput.invalidUse", new String[0]);
        } else {
            this.err.jspError(mark, "jsp.error.badStandardAction", new String[0]);
        }
    }

    private boolean parseCustomTag(Node node) throws JasperException {
        Object object;
        if (this.reader.peekChar() != 60) {
            return false;
        }
        this.reader.nextChar();
        String string = this.reader.parseToken(false);
        int n = string.indexOf(58);
        if (n == -1) {
            this.reader.reset(this.start);
            return false;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = this.pageInfo.getURI(string2);
        if (string4 == null) {
            if (this.pageInfo.isErrorOnUndeclaredNamespace()) {
                this.err.jspError(this.start, "jsp.error.undeclared_namespace", string2);
            } else {
                this.reader.reset(this.start);
                this.pageInfo.putNonCustomTagPrefix(string2, this.reader.mark());
                return false;
            }
        }
        TagLibraryInfo tagLibraryInfo = this.pageInfo.getTaglib(string4);
        TagInfo tagInfo = tagLibraryInfo.getTag(string3);
        TagFileInfo tagFileInfo = tagLibraryInfo.getTagFile(string3);
        if (tagInfo == null && tagFileInfo == null) {
            this.err.jspError(this.start, "jsp.error.bad_tag", string3, string2);
        }
        Class<?> clazz = null;
        if (tagInfo != null) {
            object = tagInfo.getTagClassName();
            try {
                clazz = this.ctxt.getClassLoader().loadClass((String)object);
            }
            catch (Exception exception) {
                this.err.jspError(this.start, "jsp.error.loadclass.taghandler", new String[]{object, string});
            }
        }
        object = this.parseAttributes();
        this.reader.skipSpaces();
        if (this.reader.matches("/>")) {
            if (tagInfo != null) {
                Node.CustomTag customTag = new Node.CustomTag(string, string2, string3, string4, (Attributes)object, this.start, node, tagInfo, clazz);
            } else {
                Node.CustomTag customTag = new Node.CustomTag(string, string2, string3, string4, (Attributes)object, this.start, node, tagFileInfo);
            }
            return true;
        }
        String string5 = tagInfo != null ? tagInfo.getBodyContent() : tagFileInfo.getTagInfo().getBodyContent();
        Node.CustomTag customTag = null;
        customTag = tagInfo != null ? new Node.CustomTag(string, string2, string3, string4, (Attributes)object, this.start, node, tagInfo, clazz) : new Node.CustomTag(string, string2, string3, string4, (Attributes)object, this.start, node, tagFileInfo);
        this.parseOptionalBody(customTag, string, string5);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseTemplateText(Node node) {
        if (!this.reader.hasMoreInput()) {
            return;
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int n = this.reader.nextChar();
        while (n != -1) {
            block13: {
                block14: {
                    if (n != 60) break block14;
                    if (this.reader.peekChar(0) == 92 && this.reader.peekChar(1) == 37) {
                        charArrayWriter.write(n);
                        this.reader.nextChar();
                        charArrayWriter.write(this.reader.nextChar());
                        break block13;
                    } else if (charArrayWriter.size() == 0) {
                        charArrayWriter.write(n);
                        break block13;
                    } else {
                        this.reader.pushChar();
                        break;
                    }
                }
                if (n == 92 && !this.pageInfo.isELIgnored()) {
                    int n2 = this.reader.peekChar(0);
                    if (n2 == 36 || n2 == 35) {
                        charArrayWriter.write(this.reader.nextChar());
                    } else {
                        charArrayWriter.write(n);
                    }
                } else if ((n == 36 || n == 35 && !this.pageInfo.isDeferredSyntaxAllowedAsLiteral()) && !this.pageInfo.isELIgnored()) {
                    if (this.reader.peekChar(0) == 123) {
                        this.reader.pushChar();
                        break;
                    }
                    charArrayWriter.write(n);
                } else {
                    charArrayWriter.write(n);
                }
            }
            n = this.reader.nextChar();
        }
        Node.TemplateText templateText = new Node.TemplateText(charArrayWriter.toString(), this.start, node);
    }

    private void parseXMLTemplateText(Node node) throws JasperException {
        this.reader.skipSpaces();
        if (!this.reader.matches("/>")) {
            Object object;
            if (!this.reader.matches(">")) {
                this.err.jspError(this.start, "jsp.error.unterminated", "&lt;jsp:text&gt;");
            }
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            int n = this.reader.nextChar();
            while (n != -1) {
                if (n == 60) {
                    if (!this.reader.matches("![CDATA[")) break;
                    this.start = this.reader.mark();
                    object = this.reader.skipUntil("]]>");
                    if (object == null) {
                        this.err.jspError(this.start, "jsp.error.unterminated", "CDATA");
                    }
                    String string = this.reader.getText(this.start, (Mark)object);
                    charArrayWriter.write(string, 0, string.length());
                } else if (n == 92) {
                    int n2 = this.reader.peekChar(0);
                    if (n2 == 36 || n2 == 35) {
                        charArrayWriter.write(this.reader.nextChar());
                    } else {
                        charArrayWriter.write(92);
                    }
                } else if (n == 36 || n == 35) {
                    if (this.reader.peekChar(0) == 123) {
                        this.reader.nextChar();
                        object = new Node.TemplateText(charArrayWriter.toString(), this.start, node);
                        this.parseELExpression(node, (char)n);
                        this.start = this.reader.mark();
                        charArrayWriter.reset();
                    } else {
                        charArrayWriter.write(n);
                    }
                } else {
                    charArrayWriter.write(n);
                }
                n = this.reader.nextChar();
            }
            object = new Node.TemplateText(charArrayWriter.toString(), this.start, node);
            if (!this.reader.hasMoreInput()) {
                this.err.jspError(this.start, "jsp.error.unterminated", "&lt;jsp:text&gt;");
            } else if (!this.reader.matchesETagWithoutLessThan("jsp:text")) {
                this.err.jspError(this.start, "jsp.error.jsptext.badcontent", new String[0]);
            }
        }
    }

    private void parseElements(Node node) throws JasperException {
        if (this.scriptlessCount > 0) {
            this.parseElementsScriptless(node);
            return;
        }
        this.start = this.reader.mark();
        if (this.reader.matches("<%--")) {
            this.parseComment(node);
        } else if (this.reader.matches("<%@")) {
            this.parseDirective(node);
        } else if (this.reader.matches("<jsp:directive.")) {
            this.parseXMLDirective(node);
        } else if (this.reader.matches("<%!")) {
            this.parseDeclaration(node);
        } else if (this.reader.matches("<jsp:declaration")) {
            this.parseXMLDeclaration(node);
        } else if (this.reader.matches("<%=")) {
            this.parseExpression(node);
        } else if (this.reader.matches("<jsp:expression")) {
            this.parseXMLExpression(node);
        } else if (this.reader.matches("<%")) {
            this.parseScriptlet(node);
        } else if (this.reader.matches("<jsp:scriptlet")) {
            this.parseXMLScriptlet(node);
        } else if (this.reader.matches("<jsp:text")) {
            this.parseXMLTemplateText(node);
        } else if (!this.pageInfo.isELIgnored() && this.reader.matches("${")) {
            this.parseELExpression(node, '$');
        } else if (!this.pageInfo.isELIgnored() && !this.pageInfo.isDeferredSyntaxAllowedAsLiteral() && this.reader.matches("#{")) {
            this.parseELExpression(node, '#');
        } else if (this.reader.matches("<jsp:")) {
            this.parseStandardAction(node);
        } else if (!this.parseCustomTag(node)) {
            this.checkUnbalancedEndTag();
            this.parseTemplateText(node);
        }
    }

    private void parseElementsScriptless(Node node) throws JasperException {
        ++this.scriptlessCount;
        this.start = this.reader.mark();
        if (this.reader.matches("<%--")) {
            this.parseComment(node);
        } else if (this.reader.matches("<%@")) {
            this.parseDirective(node);
        } else if (this.reader.matches("<jsp:directive.")) {
            this.parseXMLDirective(node);
        } else if (this.reader.matches("<%!")) {
            this.err.jspError(this.reader.mark(), "jsp.error.no.scriptlets", new String[0]);
        } else if (this.reader.matches("<jsp:declaration")) {
            this.err.jspError(this.reader.mark(), "jsp.error.no.scriptlets", new String[0]);
        } else if (this.reader.matches("<%=")) {
            this.err.jspError(this.reader.mark(), "jsp.error.no.scriptlets", new String[0]);
        } else if (this.reader.matches("<jsp:expression")) {
            this.err.jspError(this.reader.mark(), "jsp.error.no.scriptlets", new String[0]);
        } else if (this.reader.matches("<%")) {
            this.err.jspError(this.reader.mark(), "jsp.error.no.scriptlets", new String[0]);
        } else if (this.reader.matches("<jsp:scriptlet")) {
            this.err.jspError(this.reader.mark(), "jsp.error.no.scriptlets", new String[0]);
        } else if (this.reader.matches("<jsp:text")) {
            this.parseXMLTemplateText(node);
        } else if (!this.pageInfo.isELIgnored() && this.reader.matches("${")) {
            this.parseELExpression(node, '$');
        } else if (!this.pageInfo.isELIgnored() && !this.pageInfo.isDeferredSyntaxAllowedAsLiteral() && this.reader.matches("#{")) {
            this.parseELExpression(node, '#');
        } else if (this.reader.matches("<jsp:")) {
            this.parseStandardAction(node);
        } else if (!this.parseCustomTag(node)) {
            this.checkUnbalancedEndTag();
            this.parseTemplateText(node);
        }
        --this.scriptlessCount;
    }

    private void parseElementsTemplateText(Node node) throws JasperException {
        this.start = this.reader.mark();
        if (this.reader.matches("<%--")) {
            this.parseComment(node);
        } else if (this.reader.matches("<%@")) {
            this.parseDirective(node);
        } else if (this.reader.matches("<jsp:directive.")) {
            this.parseXMLDirective(node);
        } else if (this.reader.matches("<%!")) {
            this.err.jspError(this.reader.mark(), "jsp.error.not.in.template", "Declarations");
        } else if (this.reader.matches("<jsp:declaration")) {
            this.err.jspError(this.reader.mark(), "jsp.error.not.in.template", "Declarations");
        } else if (this.reader.matches("<%=")) {
            this.err.jspError(this.reader.mark(), "jsp.error.not.in.template", "Expressions");
        } else if (this.reader.matches("<jsp:expression")) {
            this.err.jspError(this.reader.mark(), "jsp.error.not.in.template", "Expressions");
        } else if (this.reader.matches("<%")) {
            this.err.jspError(this.reader.mark(), "jsp.error.not.in.template", "Scriptlets");
        } else if (this.reader.matches("<jsp:scriptlet")) {
            this.err.jspError(this.reader.mark(), "jsp.error.not.in.template", "Scriptlets");
        } else if (this.reader.matches("<jsp:text")) {
            this.err.jspError(this.reader.mark(), "jsp.error.not.in.template", "&lt;jsp:text");
        } else if (!this.pageInfo.isELIgnored() && this.reader.matches("${")) {
            this.err.jspError(this.reader.mark(), "jsp.error.not.in.template", "Expression language");
        } else if (!this.pageInfo.isELIgnored() && !this.pageInfo.isDeferredSyntaxAllowedAsLiteral() && this.reader.matches("#{")) {
            this.err.jspError(this.reader.mark(), "jsp.error.not.in.template", "Expression language");
        } else if (this.reader.matches("<jsp:")) {
            this.err.jspError(this.reader.mark(), "jsp.error.not.in.template", "Standard actions");
        } else if (this.parseCustomTag(node)) {
            this.err.jspError(this.reader.mark(), "jsp.error.not.in.template", "Custom actions");
        } else {
            this.checkUnbalancedEndTag();
            this.parseTemplateText(node);
        }
    }

    private void checkUnbalancedEndTag() throws JasperException {
        String string;
        int n;
        if (!this.reader.matches("</")) {
            return;
        }
        if (this.reader.matches("jsp:")) {
            this.err.jspError(this.start, "jsp.error.unbalanced.endtag", "jsp:");
        }
        if ((n = (string = this.reader.parseToken(false)).indexOf(58)) == -1 || this.pageInfo.getURI(string.substring(0, n)) == null) {
            this.reader.reset(this.start);
            return;
        }
        this.err.jspError(this.start, "jsp.error.unbalanced.endtag", string);
    }

    private void parseTagDependentBody(Node node, String string) throws JasperException {
        Mark mark = this.reader.mark();
        Mark mark2 = this.reader.skipUntilETag(string);
        if (mark2 == null) {
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;" + string);
        }
        Node.TemplateText templateText = new Node.TemplateText(this.reader.getText(mark, mark2), mark, node);
    }

    private void parseJspBody(Node node, String string) throws JasperException {
        Mark mark = this.reader.mark();
        Node.JspBody jspBody = new Node.JspBody(mark, node);
        this.reader.skipSpaces();
        if (!this.reader.matches("/>")) {
            if (!this.reader.matches(">")) {
                this.err.jspError(mark, "jsp.error.unterminated", "&lt;jsp:body");
            }
            this.parseBody(jspBody, "jsp:body", string);
        }
    }

    private void parseBody(Node node, String string, String string2) throws JasperException {
        if (string2.equalsIgnoreCase("tagdependent")) {
            this.parseTagDependentBody(node, string);
        } else if (string2.equalsIgnoreCase("empty")) {
            if (!this.reader.matchesETag(string)) {
                this.err.jspError(this.start, "jasper.error.emptybodycontent.nonempty", string);
            }
        } else if (string2 == JAVAX_BODY_CONTENT_PLUGIN) {
            this.parsePluginTags(node);
            if (!this.reader.matchesETag(string)) {
                this.err.jspError(this.reader.mark(), "jsp.error.unterminated", "&lt;" + string);
            }
        } else if (string2.equalsIgnoreCase("JSP") || string2.equalsIgnoreCase("scriptless") || string2 == JAVAX_BODY_CONTENT_PARAM || string2 == JAVAX_BODY_CONTENT_TEMPLATE_TEXT) {
            while (this.reader.hasMoreInput()) {
                if (this.reader.matchesETag(string)) {
                    return;
                }
                if (string.equals("jsp:body") || string.equals("jsp:attribute")) {
                    if (this.reader.matches("<jsp:attribute")) {
                        this.err.jspError(this.reader.mark(), "jsp.error.nested.jspattribute", new String[0]);
                    } else if (this.reader.matches("<jsp:body")) {
                        this.err.jspError(this.reader.mark(), "jsp.error.nested.jspbody", new String[0]);
                    }
                }
                if (string2.equalsIgnoreCase("JSP")) {
                    this.parseElements(node);
                    continue;
                }
                if (string2.equalsIgnoreCase("scriptless")) {
                    this.parseElementsScriptless(node);
                    continue;
                }
                if (string2 == JAVAX_BODY_CONTENT_PARAM) {
                    this.reader.skipSpaces();
                    this.parseParam(node);
                    continue;
                }
                if (string2 != JAVAX_BODY_CONTENT_TEMPLATE_TEXT) continue;
                this.parseElementsTemplateText(node);
            }
            this.err.jspError(this.start, "jsp.error.unterminated", "&lt;" + string);
        } else {
            this.err.jspError(this.start, "jasper.error.bad.bodycontent.type", new String[0]);
        }
    }

    private void parseNamedAttributes(Node node) throws JasperException {
        do {
            Mark mark = this.reader.mark();
            Attributes attributes = this.parseAttributes();
            Node.NamedAttribute namedAttribute = new Node.NamedAttribute(attributes, mark, node);
            this.reader.skipSpaces();
            if (!this.reader.matches("/>")) {
                Node node2;
                Node.Nodes nodes;
                if (!this.reader.matches(">")) {
                    this.err.jspError(mark, "jsp.error.unterminated", "&lt;jsp:attribute");
                }
                if (namedAttribute.isTrim()) {
                    this.reader.skipSpaces();
                }
                this.parseBody(namedAttribute, "jsp:attribute", this.getAttributeBodyType(node, attributes.getValue("name")));
                if (namedAttribute.isTrim() && (nodes = namedAttribute.getBody()) != null && (node2 = nodes.getNode(nodes.size() - 1)) instanceof Node.TemplateText) {
                    ((Node.TemplateText)node2).rtrim();
                }
            }
            this.reader.skipSpaces();
        } while (this.reader.matches("<jsp:attribute"));
    }

    private String getAttributeBodyType(Node node, String string) {
        if (node instanceof Node.CustomTag) {
            TagAttributeInfo[] tagAttributeInfoArray;
            TagInfo tagInfo = ((Node.CustomTag)node).getTagInfo();
            for (TagAttributeInfo tagAttributeInfo : tagAttributeInfoArray = tagInfo.getAttributes()) {
                if (!string.equals(tagAttributeInfo.getName())) continue;
                if (tagAttributeInfo.isFragment()) {
                    return "scriptless";
                }
                if (!tagAttributeInfo.canBeRequestTime()) continue;
                return "JSP";
            }
            if (tagInfo.hasDynamicAttributes()) {
                return "JSP";
            }
        } else if (node instanceof Node.IncludeAction ? "page".equals(string) : (node instanceof Node.ForwardAction ? "page".equals(string) : (node instanceof Node.SetProperty ? "value".equals(string) : (node instanceof Node.UseBean ? "beanName".equals(string) : (node instanceof Node.PlugIn ? "width".equals(string) || "height".equals(string) : (node instanceof Node.ParamAction ? "value".equals(string) : node instanceof Node.JspElement)))))) {
            return "JSP";
        }
        return JAVAX_BODY_CONTENT_TEMPLATE_TEXT;
    }

    private void parseFileDirectives(Node node) throws JasperException {
        this.reader.skipUntil("<");
        while (this.reader.hasMoreInput()) {
            this.start = this.reader.mark();
            if (this.reader.matches("%--")) {
                this.reader.skipUntil("--%>");
            } else if (this.reader.matches("%@")) {
                this.parseDirective(node);
            } else if (this.reader.matches("jsp:directive.")) {
                this.parseXMLDirective(node);
            } else if (this.reader.matches("%!")) {
                this.reader.skipUntil("%>");
            } else if (this.reader.matches("%=")) {
                this.reader.skipUntil("%>");
            } else if (this.reader.matches("%")) {
                this.reader.skipUntil("%>");
            }
            this.reader.skipUntil("<");
        }
    }
}

