/* tracker-bus-batch.c generated by valac 0.56.0, the Vala compiler
 * generated from tracker-bus-batch.vala, do not modify */

/*
 * Copyright (C) 2021, Red Hat Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Carlos Garnacho <carlosg@gnome.org>
 */

#include "tracker-bus.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <glib-object.h>

enum  {
	TRACKER_BUS_BATCH_0_PROPERTY,
	TRACKER_BUS_BATCH_NUM_PROPERTIES
};
static GParamSpec* tracker_bus_batch_properties[TRACKER_BUS_BATCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block8Data Block8Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _TrackerBusBatchExecuteAsyncData TrackerBusBatchExecuteAsyncData;

struct _TrackerBusBatchPrivate {
	GDBusConnection* bus;
	gchar* dbus_name;
	gchar* object_path;
	gchar** updates;
	gint updates_length1;
	gint _updates_size_;
};

struct _Block8Data {
	int _ref_count_;
	TrackerBusBatch* self;
	GMainLoop* loop;
	GAsyncResult* async_res;
};

struct _TrackerBusBatchExecuteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusBatch* self;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GDBusConnection* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GError* _inner_error0_;
};

static gint TrackerBusBatch_private_offset;
static gpointer tracker_bus_batch_parent_class = NULL;

static void tracker_bus_batch_real_add_sparql (TrackerBatch* base,
                                        const gchar* sparql);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void tracker_bus_batch_real_add_resource (TrackerBatch* base,
                                          const gchar* graph,
                                          TrackerResource* resource);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gboolean tracker_bus_batch_real_execute (TrackerBatch* base,
                                         GCancellable* cancellable,
                                         GError** error);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda12_ (Block8Data* _data8_,
                  GObject* o,
                  GAsyncResult* res);
static void ___lambda12__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void tracker_bus_batch_real_execute_async_data_free (gpointer _data);
static void tracker_bus_batch_real_execute_async (TrackerBatch* base,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean tracker_bus_batch_real_execute_async_co (TrackerBusBatchExecuteAsyncData* _data_);
static void tracker_bus_batch_execute_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void tracker_bus_batch_finalize (GObject * obj);
static GType tracker_bus_batch_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
tracker_bus_batch_get_instance_private (TrackerBusBatch* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerBusBatch_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 30 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	return self ? g_object_ref (self) : NULL;
#line 135 "tracker-bus-batch.c"
}

TrackerBusBatch*
tracker_bus_batch_construct (GType object_type,
                             GDBusConnection* bus,
                             const gchar* dbus_name,
                             const gchar* object_path)
{
	TrackerBusBatch * self = NULL;
	GDBusConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 28 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_return_val_if_fail (bus != NULL, NULL);
#line 28 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_return_val_if_fail (dbus_name != NULL, NULL);
#line 28 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_return_val_if_fail (object_path != NULL, NULL);
#line 29 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self = (TrackerBusBatch*) g_object_new (object_type, NULL);
#line 30 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp0_ = _g_object_ref0 (bus);
#line 30 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_object_unref0 (self->priv->bus);
#line 30 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self->priv->bus = _tmp0_;
#line 31 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp1_ = g_strdup (dbus_name);
#line 31 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_free0 (self->priv->dbus_name);
#line 31 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self->priv->dbus_name = _tmp1_;
#line 32 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp2_ = g_strdup (object_path);
#line 32 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_free0 (self->priv->object_path);
#line 32 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self->priv->object_path = _tmp2_;
#line 28 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	return self;
#line 176 "tracker-bus-batch.c"
}

TrackerBusBatch*
tracker_bus_batch_new (GDBusConnection* bus,
                       const gchar* dbus_name,
                       const gchar* object_path)
{
#line 28 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	return tracker_bus_batch_construct (TRACKER_BUS_TYPE_BATCH, bus, dbus_name, object_path);
#line 186 "tracker-bus-batch.c"
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	if ((*length) == (*size)) {
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 201 "tracker-bus-batch.c"
	}
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	(*array)[(*length)++] = value;
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	(*array)[*length] = NULL;
#line 207 "tracker-bus-batch.c"
}

static void
tracker_bus_batch_real_add_sparql (TrackerBatch* base,
                                   const gchar* sparql)
{
	TrackerBusBatch * self;
	gchar* _tmp0_;
#line 35 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self = (TrackerBusBatch*) base;
#line 35 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_return_if_fail (sparql != NULL);
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp0_ = g_strdup (sparql);
#line 36 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_vala_array_add1 (&self->priv->updates, &self->priv->updates_length1, &self->priv->_updates_size_, _tmp0_);
#line 224 "tracker-bus-batch.c"
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	if ((*length) == (*size)) {
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 239 "tracker-bus-batch.c"
	}
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	(*array)[(*length)++] = value;
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	(*array)[*length] = NULL;
#line 245 "tracker-bus-batch.c"
}

static void
tracker_bus_batch_real_add_resource (TrackerBatch* base,
                                     const gchar* graph,
                                     TrackerResource* resource)
{
	TrackerBusBatch * self;
	TrackerNamespaceManager* namespaces = NULL;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	TrackerNamespaceManager* _tmp2_;
	gchar* sparql = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 39 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self = (TrackerBusBatch*) base;
#line 39 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_return_if_fail (resource != NULL);
#line 40 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp0_ = tracker_batch_get_connection ((TrackerBatch*) self);
#line 40 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp1_ = _tmp0_;
#line 40 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp2_ = tracker_sparql_connection_get_namespace_manager (_tmp1_);
#line 40 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	namespaces = _tmp2_;
#line 41 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp3_ = tracker_resource_print_sparql_update (resource, namespaces, graph);
#line 41 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	sparql = _tmp3_;
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp4_ = g_strdup (sparql);
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_vala_array_add2 (&self->priv->updates, &self->priv->updates_length1, &self->priv->_updates_size_, _tmp4_);
#line 39 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_free0 (sparql);
#line 39 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_object_unref0 (namespaces);
#line 285 "tracker-bus-batch.c"
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	return _data8_;
#line 295 "tracker-bus-batch.c"
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 305 "tracker-bus-batch.c"
		TrackerBusBatch* self;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		self = _data8_->self;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		_g_object_unref0 (_data8_->async_res);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		_g_main_loop_unref0 (_data8_->loop);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		_g_object_unref0 (self);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		g_slice_free (Block8Data, _data8_);
#line 317 "tracker-bus-batch.c"
	}
}

static void
__lambda12_ (Block8Data* _data8_,
             GObject* o,
             GAsyncResult* res)
{
	TrackerBusBatch* self;
	GAsyncResult* _tmp0_;
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self = _data8_->self;
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_return_if_fail (res != NULL);
#line 52 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 52 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_object_unref0 (_data8_->async_res);
#line 52 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data8_->async_res = _tmp0_;
#line 53 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_main_loop_quit (_data8_->loop);
#line 340 "tracker-bus-batch.c"
}

static void
___lambda12__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	__lambda12_ (self, source_object, res);
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	block8_data_unref (self);
#line 352 "tracker-bus-batch.c"
}

static gboolean
tracker_bus_batch_real_execute (TrackerBatch* base,
                                GCancellable* cancellable,
                                GError** error)
{
	TrackerBusBatch * self;
	Block8Data* _data8_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self = (TrackerBusBatch*) base;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data8_->_ref_count_ = 1;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data8_->self = g_object_ref (self);
#line 47 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp0_ = g_main_context_new ();
#line 47 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	context = _tmp0_;
#line 48 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp1_ = g_main_loop_new (context, FALSE);
#line 48 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data8_->loop = _tmp1_;
#line 49 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_main_context_push_thread_default (context);
#line 50 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data8_->async_res = NULL;
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	tracker_batch_execute_async ((TrackerBatch*) self, cancellable, ___lambda12__gasync_ready_callback, block8_data_ref (_data8_));
#line 55 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_main_loop_run (_data8_->loop);
#line 56 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_main_context_pop_thread_default (context);
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp2_ = tracker_batch_execute_finish ((TrackerBatch*) self, _data8_->async_res, &_inner_error0_);
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 398 "tracker-bus-batch.c"
		gboolean _tmp3_ = FALSE;
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		g_propagate_error (error, _inner_error0_);
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		_g_main_context_unref0 (context);
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		block8_data_unref (_data8_);
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		_data8_ = NULL;
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		return _tmp3_;
#line 410 "tracker-bus-batch.c"
	}
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	result = _tmp2_;
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_main_context_unref0 (context);
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	block8_data_unref (_data8_);
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data8_ = NULL;
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	return result;
#line 422 "tracker-bus-batch.c"
}

static void
tracker_bus_batch_real_execute_async_data_free (gpointer _data)
{
	TrackerBusBatchExecuteAsyncData* _data_;
	_data_ = _data;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_object_unref0 (_data_->self);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_slice_free (TrackerBusBatchExecuteAsyncData, _data_);
#line 436 "tracker-bus-batch.c"
}

static void
tracker_bus_batch_real_execute_async (TrackerBatch* base,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	TrackerBusBatch * self;
	TrackerBusBatchExecuteAsyncData* _data_;
	TrackerBusBatch* _tmp0_;
	GCancellable* _tmp1_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self = (TrackerBusBatch*) base;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_ = g_slice_new0 (TrackerBusBatchExecuteAsyncData);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_batch_real_execute_async_data_free);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->self = _tmp0_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_object_unref0 (_data_->cancellable);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->cancellable = _tmp1_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	tracker_bus_batch_real_execute_async_co (_data_);
#line 469 "tracker-bus-batch.c"
}

static gboolean
tracker_bus_batch_execute_finish (TrackerBatch* base,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	gboolean result;
	TrackerBusBatchExecuteAsyncData* _data_;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	if (NULL == _data_) {
#line 483 "tracker-bus-batch.c"
		gboolean _tmp0_ = FALSE;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		return _tmp0_;
#line 487 "tracker-bus-batch.c"
	}
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	result = _data_->result;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	return result;
#line 493 "tracker-bus-batch.c"
}

static void
tracker_bus_batch_execute_async_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	TrackerBusBatchExecuteAsyncData* _data_;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_ = _user_data_;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->_source_object_ = source_object;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->_res_ = _res_;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	tracker_bus_batch_real_execute_async_co (_data_);
#line 510 "tracker-bus-batch.c"
}

static gboolean
tracker_bus_batch_real_execute_async_co (TrackerBusBatchExecuteAsyncData* _data_)
{
#line 60 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	switch (_data_->_state_) {
#line 60 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		case 0:
#line 520 "tracker-bus-batch.c"
		goto _state_0;
#line 60 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		case 1:
#line 524 "tracker-bus-batch.c"
		goto _state_1;
		default:
#line 60 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		g_assert_not_reached ();
#line 529 "tracker-bus-batch.c"
	}
	_state_0:
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->_tmp1_ = _data_->self->priv->bus;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->_tmp2_ = _data_->self->priv->dbus_name;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->_tmp3_ = _data_->self->priv->object_path;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->_tmp4_ = _data_->self->priv->updates;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->_tmp4__length1 = _data_->self->priv->updates_length1;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->_state_ = 1;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	tracker_bus_connection_perform_update_array (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, (gint) _data_->_tmp4__length1, _data_->cancellable, tracker_bus_batch_execute_async_ready, _data_);
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	return FALSE;
#line 548 "tracker-bus-batch.c"
	_state_1:
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->_tmp0_ = tracker_bus_connection_perform_update_array_finish (_data_->_res_, &_data_->_inner_error0_);
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		g_object_unref (_data_->_async_result);
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		return FALSE;
#line 560 "tracker-bus-batch.c"
	}
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_data_->result = _data_->_tmp0_;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	if (_data_->_state_ != 0) {
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 572 "tracker-bus-batch.c"
		}
	}
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_object_unref (_data_->_async_result);
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	return FALSE;
#line 579 "tracker-bus-batch.c"
}

static void
tracker_bus_batch_class_init (TrackerBusBatchClass * klass,
                              gpointer klass_data)
{
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	tracker_bus_batch_parent_class = g_type_class_peek_parent (klass);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	g_type_class_adjust_private_offset (klass, &TrackerBusBatch_private_offset);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	((TrackerBatchClass *) klass)->add_sparql = (void (*) (TrackerBatch*, const gchar*)) tracker_bus_batch_real_add_sparql;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	((TrackerBatchClass *) klass)->add_resource = (void (*) (TrackerBatch*, const gchar*, TrackerResource*)) tracker_bus_batch_real_add_resource;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	((TrackerBatchClass *) klass)->execute = (gboolean (*) (TrackerBatch*, GCancellable*, GError**)) tracker_bus_batch_real_execute;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	((TrackerBatchClass *) klass)->execute_async = (void (*) (TrackerBatch*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_batch_real_execute_async;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	((TrackerBatchClass *) klass)->execute_finish = (gboolean (*) (TrackerBatch*, GAsyncResult*, GError**)) tracker_bus_batch_execute_finish;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_bus_batch_finalize;
#line 602 "tracker-bus-batch.c"
}

static void
tracker_bus_batch_instance_init (TrackerBusBatch * self,
                                 gpointer klass)
{
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self->priv = tracker_bus_batch_get_instance_private (self);
#line 611 "tracker-bus-batch.c"
}

static void
tracker_bus_batch_finalize (GObject * obj)
{
	TrackerBusBatch * self;
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_BUS_TYPE_BATCH, TrackerBusBatch);
#line 23 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_object_unref0 (self->priv->bus);
#line 24 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_free0 (self->priv->dbus_name);
#line 25 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	_g_free0 (self->priv->object_path);
#line 26 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	self->priv->updates = (_vala_array_free (self->priv->updates, self->priv->updates_length1, (GDestroyNotify) g_free), NULL);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus-batch.vala"
	G_OBJECT_CLASS (tracker_bus_batch_parent_class)->finalize (obj);
#line 630 "tracker-bus-batch.c"
}

static GType
tracker_bus_batch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerBusBatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_bus_batch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerBusBatch), 0, (GInstanceInitFunc) tracker_bus_batch_instance_init, NULL };
	GType tracker_bus_batch_type_id;
	tracker_bus_batch_type_id = g_type_register_static (TRACKER_TYPE_BATCH, "TrackerBusBatch", &g_define_type_info, 0);
	TrackerBusBatch_private_offset = g_type_add_instance_private (tracker_bus_batch_type_id, sizeof (TrackerBusBatchPrivate));
	return tracker_bus_batch_type_id;
}

GType
tracker_bus_batch_get_type (void)
{
	static volatile gsize tracker_bus_batch_type_id__once = 0;
	if (g_once_init_enter (&tracker_bus_batch_type_id__once)) {
		GType tracker_bus_batch_type_id;
		tracker_bus_batch_type_id = tracker_bus_batch_get_type_once ();
		g_once_init_leave (&tracker_bus_batch_type_id__once, tracker_bus_batch_type_id);
	}
	return tracker_bus_batch_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 662 "tracker-bus-batch.c"
		gssize i;
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				destroy_func (((gpointer*) array)[i]);
#line 670 "tracker-bus-batch.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_free (array);
#line 685 "tracker-bus-batch.c"
}

