/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ManyToMany<T1, T2> {
    private final Map<T1, Set<T2>> _forward = new HashMap<T1, Set<T2>>();
    private final Map<T2, Set<T1>> _reverse = new HashMap<T2, Set<T1>>();
    private boolean _dirty = false;

    public synchronized boolean clear() {
        boolean bl = !this._forward.isEmpty() || !this._reverse.isEmpty();
        this._reverse.clear();
        this._forward.clear();
        this._dirty |= bl;
        return bl;
    }

    public synchronized void clearDirtyBit() {
        this._dirty = false;
    }

    public synchronized boolean containsKey(T1 T1) {
        return this._forward.containsKey(T1);
    }

    public synchronized boolean containsKeyValuePair(T1 T1, T2 T2) {
        Set<T2> set = this._forward.get(T1);
        if (null == set) {
            return false;
        }
        return set.contains(T2);
    }

    public synchronized boolean containsValue(T2 T2) {
        return this._reverse.containsKey(T2);
    }

    public synchronized Set<T1> getKeys(T2 T2) {
        Set<T1> set = this._reverse.get(T2);
        if (null == set) {
            return Collections.emptySet();
        }
        return new HashSet<T1>(set);
    }

    public synchronized Set<T2> getValues(T1 T1) {
        Set<T2> set = this._forward.get(T1);
        if (null == set) {
            return Collections.emptySet();
        }
        return new HashSet<T2>(set);
    }

    public synchronized Set<T1> getKeySet() {
        HashSet<T1> hashSet = new HashSet<T1>(this._forward.keySet());
        return hashSet;
    }

    public synchronized Set<T2> getValueSet() {
        HashSet<T2> hashSet = new HashSet<T2>(this._reverse.keySet());
        return hashSet;
    }

    public synchronized boolean isDirty() {
        return this._dirty;
    }

    public synchronized boolean keyHasOtherValues(T1 T1, T2 T2) {
        Set<T2> set = this._forward.get(T1);
        if (set == null) {
            return false;
        }
        int n = set.size();
        if (n == 0) {
            return false;
        }
        if (n > 1) {
            return true;
        }
        return !set.contains(T2);
    }

    public synchronized boolean put(T1 T1, T2 T2) {
        Set<T2> set = this._forward.get(T1);
        if (null == set) {
            set = new HashSet<T2>();
            this._forward.put(T1, set);
        }
        boolean bl = set.add(T2);
        this._dirty |= bl;
        Set<T1> set2 = this._reverse.get(T2);
        if (null == set2) {
            set2 = new HashSet<T1>();
            this._reverse.put(T2, set2);
        }
        set2.add(T1);
        assert (this.checkIntegrity());
        return bl;
    }

    public synchronized boolean remove(T1 T1, T2 T2) {
        Set<T2> set = this._forward.get(T1);
        if (set == null) {
            assert (this.checkIntegrity());
            return false;
        }
        boolean bl = set.remove(T2);
        if (set.isEmpty()) {
            this._forward.remove(T1);
        }
        if (bl) {
            this._dirty = true;
            Set<T1> set2 = this._reverse.get(T2);
            set2.remove(T1);
            if (set2.isEmpty()) {
                this._reverse.remove(T2);
            }
        }
        assert (this.checkIntegrity());
        return bl;
    }

    public synchronized boolean removeKey(T1 T1) {
        Set<T2> set = this._forward.get(T1);
        if (null == set) {
            assert (this.checkIntegrity());
            return false;
        }
        for (T2 T2 : set) {
            Set<T1> set2 = this._reverse.get(T2);
            if (null == set2) continue;
            set2.remove(T1);
            if (!set2.isEmpty()) continue;
            this._reverse.remove(T2);
        }
        this._forward.remove(T1);
        this._dirty = true;
        assert (this.checkIntegrity());
        return true;
    }

    public synchronized boolean removeValue(T2 T2) {
        Set<T1> set = this._reverse.get(T2);
        if (null == set) {
            assert (this.checkIntegrity());
            return false;
        }
        for (T1 T1 : set) {
            Set<T2> set2 = this._forward.get(T1);
            if (null == set2) continue;
            set2.remove(T2);
            if (!set2.isEmpty()) continue;
            this._forward.remove(T1);
        }
        this._reverse.remove(T2);
        this._dirty = true;
        assert (this.checkIntegrity());
        return true;
    }

    public synchronized boolean valueHasOtherKeys(T2 T2, T1 T1) {
        Set<T1> set = this._reverse.get(T2);
        if (set == null) {
            return false;
        }
        int n = set.size();
        if (n == 0) {
            return false;
        }
        if (n > 1) {
            return true;
        }
        return !set.contains(T1);
    }

    private boolean checkIntegrity() {
        Set<Object> set;
        Set<Object> set2;
        for (Map.Entry<T1, Set<T2>> entry : this._forward.entrySet()) {
            set2 = entry.getValue();
            if (set2.isEmpty()) {
                throw new IllegalStateException("Integrity compromised: forward map contains an empty set");
            }
            for (Object object : set2) {
                set = this._reverse.get(object);
                if (null != set && set.contains(entry.getKey())) continue;
                throw new IllegalStateException("Integrity compromised: forward map contains an entry missing from reverse map: " + object);
            }
        }
        for (Map.Entry<Object, Set<Object>> entry : this._reverse.entrySet()) {
            set2 = entry.getValue();
            if (set2.isEmpty()) {
                throw new IllegalStateException("Integrity compromised: reverse map contains an empty set");
            }
            for (Object object : set2) {
                set = this._forward.get(object);
                if (null != set && set.contains(entry.getKey())) continue;
                throw new IllegalStateException("Integrity compromised: reverse map contains an entry missing from forward map: " + object);
            }
        }
        return true;
    }
}

