// third_party/blink/public/mojom/input/synchronous_compositor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/input/synchronous_compositor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/input/synchronous_compositor.mojom-params-data.h"
#include "third_party/blink/public/mojom/input/synchronous_compositor.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/input/synchronous_compositor.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_SYNCHRONOUS_COMPOSITOR_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_SYNCHRONOUS_COMPOSITOR_MOJOM_JUMBO_H_
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
SyncCompositorDemandDrawHwParams::SyncCompositorDemandDrawHwParams()
    : viewport_size(),
      viewport_rect_for_tile_priority(),
      transform_for_tile_priority() {}

SyncCompositorDemandDrawHwParams::SyncCompositorDemandDrawHwParams(
    const ::gfx::Size& viewport_size_in,
    const ::gfx::Rect& viewport_rect_for_tile_priority_in,
    const ::gfx::Transform& transform_for_tile_priority_in)
    : viewport_size(std::move(viewport_size_in)),
      viewport_rect_for_tile_priority(std::move(viewport_rect_for_tile_priority_in)),
      transform_for_tile_priority(std::move(transform_for_tile_priority_in)) {}

SyncCompositorDemandDrawHwParams::~SyncCompositorDemandDrawHwParams() = default;

void SyncCompositorDemandDrawHwParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("viewport_size", base::trace_event::ValueToString(this->viewport_size, "<value of type const ::gfx::Size&>"));
  value->SetString("viewport_rect_for_tile_priority", base::trace_event::ValueToString(this->viewport_rect_for_tile_priority, "<value of type const ::gfx::Rect&>"));
  value->SetString("transform_for_tile_priority", base::trace_event::ValueToString(this->transform_for_tile_priority, "<value of type const ::gfx::Transform&>"));
}

bool SyncCompositorDemandDrawHwParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyncCompositorDemandDrawSwParams::SyncCompositorDemandDrawSwParams()
    : size(),
      clip(),
      transform() {}

SyncCompositorDemandDrawSwParams::SyncCompositorDemandDrawSwParams(
    const ::gfx::Size& size_in,
    const ::gfx::Rect& clip_in,
    const ::gfx::Transform& transform_in)
    : size(std::move(size_in)),
      clip(std::move(clip_in)),
      transform(std::move(transform_in)) {}

SyncCompositorDemandDrawSwParams::~SyncCompositorDemandDrawSwParams() = default;

void SyncCompositorDemandDrawSwParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("size", base::trace_event::ValueToString(this->size, "<value of type const ::gfx::Size&>"));
  value->SetString("clip", base::trace_event::ValueToString(this->clip, "<value of type const ::gfx::Rect&>"));
  value->SetString("transform", base::trace_event::ValueToString(this->transform, "<value of type const ::gfx::Transform&>"));
}

bool SyncCompositorDemandDrawSwParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SyncCompositorCommonRendererParams::SyncCompositorCommonRendererParams()
    : version(0U),
      total_scroll_offset(),
      max_scroll_offset(),
      scrollable_size(),
      page_scale_factor(0),
      min_page_scale_factor(0),
      max_page_scale_factor(0),
      need_invalidate_count(0U),
      invalidate_needs_draw(true),
      did_activate_pending_tree_count(0U) {}

SyncCompositorCommonRendererParams::SyncCompositorCommonRendererParams(
    uint32_t version_in,
    const ::gfx::ScrollOffset& total_scroll_offset_in,
    const ::gfx::ScrollOffset& max_scroll_offset_in,
    const ::gfx::SizeF& scrollable_size_in,
    float page_scale_factor_in,
    float min_page_scale_factor_in,
    float max_page_scale_factor_in,
    uint32_t need_invalidate_count_in,
    bool invalidate_needs_draw_in,
    uint32_t did_activate_pending_tree_count_in)
    : version(std::move(version_in)),
      total_scroll_offset(std::move(total_scroll_offset_in)),
      max_scroll_offset(std::move(max_scroll_offset_in)),
      scrollable_size(std::move(scrollable_size_in)),
      page_scale_factor(std::move(page_scale_factor_in)),
      min_page_scale_factor(std::move(min_page_scale_factor_in)),
      max_page_scale_factor(std::move(max_page_scale_factor_in)),
      need_invalidate_count(std::move(need_invalidate_count_in)),
      invalidate_needs_draw(std::move(invalidate_needs_draw_in)),
      did_activate_pending_tree_count(std::move(did_activate_pending_tree_count_in)) {}

SyncCompositorCommonRendererParams::~SyncCompositorCommonRendererParams() = default;

void SyncCompositorCommonRendererParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("version", base::NumberToString(this->version));
  value->SetString("total_scroll_offset", base::trace_event::ValueToString(this->total_scroll_offset, "<value of type const ::gfx::ScrollOffset&>"));
  value->SetString("max_scroll_offset", base::trace_event::ValueToString(this->max_scroll_offset, "<value of type const ::gfx::ScrollOffset&>"));
  value->SetString("scrollable_size", base::trace_event::ValueToString(this->scrollable_size, "<value of type const ::gfx::SizeF&>"));
  value->SetDouble("page_scale_factor", this->page_scale_factor);
  value->SetDouble("min_page_scale_factor", this->min_page_scale_factor);
  value->SetDouble("max_page_scale_factor", this->max_page_scale_factor);
  value->SetString("need_invalidate_count", base::NumberToString(this->need_invalidate_count));
  value->SetBoolean("invalidate_needs_draw", this->invalidate_needs_draw);
  value->SetString("did_activate_pending_tree_count", base::NumberToString(this->did_activate_pending_tree_count));
}

bool SyncCompositorCommonRendererParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SynchronousCompositor::Name_[] = "blink.mojom.SynchronousCompositor";
bool SynchronousCompositor::DemandDrawHw(SyncCompositorDemandDrawHwParamsPtr draw_params, SyncCompositorCommonRendererParamsPtr* out_result, uint32_t* out_layer_tree_frame_sink_id, uint32_t* out_metadata_version, base::Optional<::viz::CompositorFrame>* out_frame, base::Optional<::viz::HitTestRegionList>* out_hit_test_region_list) {
  NOTREACHED();
  return false;
}
bool SynchronousCompositor::SetSharedMemory(::base::WritableSharedMemoryRegion shm_region, bool* out_success, SyncCompositorCommonRendererParamsPtr* out_result) {
  NOTREACHED();
  return false;
}
bool SynchronousCompositor::DemandDrawSw(SyncCompositorDemandDrawSwParamsPtr draw_params, SyncCompositorCommonRendererParamsPtr* out_result, uint32_t* out_metadata_version, base::Optional<::viz::CompositorFrameMetadata>* out_meta_data) {
  NOTREACHED();
  return false;
}
bool SynchronousCompositor::ZoomBy(float delta, const ::gfx::Point& anchor, SyncCompositorCommonRendererParamsPtr* out_result) {
  NOTREACHED();
  return false;
}
class SynchronousCompositor_DemandDrawHw_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  SynchronousCompositor_DemandDrawHw_HandleSyncResponse(
      bool* result, SyncCompositorCommonRendererParamsPtr* out_result, uint32_t* out_layer_tree_frame_sink_id, uint32_t* out_metadata_version, base::Optional<::viz::CompositorFrame>* out_frame, base::Optional<::viz::HitTestRegionList>* out_hit_test_region_list)
      : result_(result), out_result_(out_result), out_layer_tree_frame_sink_id_(out_layer_tree_frame_sink_id), out_metadata_version_(out_metadata_version), out_frame_(out_frame), out_hit_test_region_list_(out_hit_test_region_list) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  SyncCompositorCommonRendererParamsPtr* out_result_;
  uint32_t* out_layer_tree_frame_sink_id_;
  uint32_t* out_metadata_version_;
  base::Optional<::viz::CompositorFrame>* out_frame_;
  base::Optional<::viz::HitTestRegionList>* out_hit_test_region_list_;DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_DemandDrawHw_HandleSyncResponse);
};

class SynchronousCompositor_DemandDrawHw_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SynchronousCompositor_DemandDrawHw_ForwardToCallback(
      SynchronousCompositor::DemandDrawHwCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SynchronousCompositor::DemandDrawHwCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_DemandDrawHw_ForwardToCallback);
};
class SynchronousCompositor_SetSharedMemory_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  SynchronousCompositor_SetSharedMemory_HandleSyncResponse(
      bool* result, bool* out_success, SyncCompositorCommonRendererParamsPtr* out_result)
      : result_(result), out_success_(out_success), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;
  SyncCompositorCommonRendererParamsPtr* out_result_;DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_SetSharedMemory_HandleSyncResponse);
};

class SynchronousCompositor_SetSharedMemory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SynchronousCompositor_SetSharedMemory_ForwardToCallback(
      SynchronousCompositor::SetSharedMemoryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SynchronousCompositor::SetSharedMemoryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_SetSharedMemory_ForwardToCallback);
};
class SynchronousCompositor_DemandDrawSw_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  SynchronousCompositor_DemandDrawSw_HandleSyncResponse(
      bool* result, SyncCompositorCommonRendererParamsPtr* out_result, uint32_t* out_metadata_version, base::Optional<::viz::CompositorFrameMetadata>* out_meta_data)
      : result_(result), out_result_(out_result), out_metadata_version_(out_metadata_version), out_meta_data_(out_meta_data) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  SyncCompositorCommonRendererParamsPtr* out_result_;
  uint32_t* out_metadata_version_;
  base::Optional<::viz::CompositorFrameMetadata>* out_meta_data_;DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_DemandDrawSw_HandleSyncResponse);
};

class SynchronousCompositor_DemandDrawSw_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SynchronousCompositor_DemandDrawSw_ForwardToCallback(
      SynchronousCompositor::DemandDrawSwCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SynchronousCompositor::DemandDrawSwCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_DemandDrawSw_ForwardToCallback);
};
class SynchronousCompositor_ZoomBy_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  SynchronousCompositor_ZoomBy_HandleSyncResponse(
      bool* result, SyncCompositorCommonRendererParamsPtr* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  SyncCompositorCommonRendererParamsPtr* out_result_;DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_ZoomBy_HandleSyncResponse);
};

class SynchronousCompositor_ZoomBy_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SynchronousCompositor_ZoomBy_ForwardToCallback(
      SynchronousCompositor::ZoomByCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SynchronousCompositor::ZoomByCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_ZoomBy_ForwardToCallback);
};

SynchronousCompositorProxy::SynchronousCompositorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SynchronousCompositorProxy::DemandDrawHwAsync(
    SyncCompositorDemandDrawHwParamsPtr in_draw_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositor::DemandDrawHwAsync", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_draw_params.is_null()) {
        raw_value->SetString("draw_params", "nullptr");
      } else {
        raw_value->BeginDictionary("draw_params");
        in_draw_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_DemandDrawHwAsync_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_DemandDrawHwAsync_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->draw_params)::BaseType::BufferWriter
      draw_params_writer;
  mojo::internal::Serialize<::blink::mojom::SyncCompositorDemandDrawHwParamsDataView>(
      in_draw_params, buffer, &draw_params_writer, &serialization_context);
  params->draw_params.Set(
      draw_params_writer.is_null() ? nullptr : draw_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->draw_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null draw_params in SynchronousCompositor.DemandDrawHwAsync request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("DemandDrawHwAsync");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool SynchronousCompositorProxy::DemandDrawHw(
    SyncCompositorDemandDrawHwParamsPtr param_draw_params, SyncCompositorCommonRendererParamsPtr* out_param_result, uint32_t* out_param_layer_tree_frame_sink_id, uint32_t* out_param_metadata_version, base::Optional<::viz::CompositorFrame>* out_param_frame, base::Optional<::viz::HitTestRegionList>* out_param_hit_test_region_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::SynchronousCompositor::DemandDrawHw", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (param_draw_params.is_null()) {
        raw_value->SetString("draw_params", "nullptr");
      } else {
        raw_value->BeginDictionary("draw_params");
        param_draw_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_DemandDrawHw_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_DemandDrawHw_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->draw_params)::BaseType::BufferWriter
      draw_params_writer;
  mojo::internal::Serialize<::blink::mojom::SyncCompositorDemandDrawHwParamsDataView>(
      param_draw_params, buffer, &draw_params_writer, &serialization_context);
  params->draw_params.Set(
      draw_params_writer.is_null() ? nullptr : draw_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->draw_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null draw_params in SynchronousCompositor.DemandDrawHw request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("DemandDrawHw");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SynchronousCompositor_DemandDrawHw_HandleSyncResponse(
          &result, out_param_result, out_param_layer_tree_frame_sink_id, out_param_metadata_version, out_param_frame, out_param_hit_test_region_list));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::SynchronousCompositor::DemandDrawHw", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_result) {
        if ((*out_param_result).is_null()) {
          raw_value->SetString("result", "nullptr");
        } else {
          raw_value->BeginDictionary("result");
          (*out_param_result)->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      } else {
        raw_value->SetString("result", "nullptr");
      }
      if (out_param_layer_tree_frame_sink_id) {
        raw_value->SetString("layer_tree_frame_sink_id", base::NumberToString((*out_param_layer_tree_frame_sink_id)));
      } else {
        raw_value->SetString("layer_tree_frame_sink_id", "nullptr");
      }
      if (out_param_metadata_version) {
        raw_value->SetString("metadata_version", base::NumberToString((*out_param_metadata_version)));
      } else {
        raw_value->SetString("metadata_version", "nullptr");
      }
      if (out_param_frame) {
        raw_value->SetString("frame", base::trace_event::ValueToString((*out_param_frame), "<value of type base::Optional<::viz::CompositorFrame>>"));
      } else {
        raw_value->SetString("frame", "nullptr");
      }
      if (out_param_hit_test_region_list) {
        raw_value->SetString("hit_test_region_list", base::trace_event::ValueToString((*out_param_hit_test_region_list), "<value of type base::Optional<::viz::HitTestRegionList>>"));
      } else {
        raw_value->SetString("hit_test_region_list", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void SynchronousCompositorProxy::DemandDrawHw(
    SyncCompositorDemandDrawHwParamsPtr in_draw_params, DemandDrawHwCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositor::DemandDrawHw", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_draw_params.is_null()) {
        raw_value->SetString("draw_params", "nullptr");
      } else {
        raw_value->BeginDictionary("draw_params");
        in_draw_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_DemandDrawHw_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_DemandDrawHw_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->draw_params)::BaseType::BufferWriter
      draw_params_writer;
  mojo::internal::Serialize<::blink::mojom::SyncCompositorDemandDrawHwParamsDataView>(
      in_draw_params, buffer, &draw_params_writer, &serialization_context);
  params->draw_params.Set(
      draw_params_writer.is_null() ? nullptr : draw_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->draw_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null draw_params in SynchronousCompositor.DemandDrawHw request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("DemandDrawHw");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SynchronousCompositor_DemandDrawHw_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool SynchronousCompositorProxy::SetSharedMemory(
    ::base::WritableSharedMemoryRegion param_shm_region, bool* out_param_success, SyncCompositorCommonRendererParamsPtr* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::SynchronousCompositor::SetSharedMemory", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("shm_region", base::trace_event::ValueToString(param_shm_region, "<value of type ::base::WritableSharedMemoryRegion>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_SetSharedMemory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_SetSharedMemory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->shm_region)::BaseType::BufferWriter
      shm_region_writer;
  mojo::internal::Serialize<::mojo_base::mojom::WritableSharedMemoryRegionDataView>(
      param_shm_region, buffer, &shm_region_writer, &serialization_context);
  params->shm_region.Set(
      shm_region_writer.is_null() ? nullptr : shm_region_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shm_region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shm_region in SynchronousCompositor.SetSharedMemory request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("SetSharedMemory");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SynchronousCompositor_SetSharedMemory_HandleSyncResponse(
          &result, out_param_success, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::SynchronousCompositor::SetSharedMemory", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_success) {
        raw_value->SetBoolean("success", (*out_param_success));
      } else {
        raw_value->SetString("success", "nullptr");
      }
      if (out_param_result) {
        if ((*out_param_result).is_null()) {
          raw_value->SetString("result", "nullptr");
        } else {
          raw_value->BeginDictionary("result");
          (*out_param_result)->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      } else {
        raw_value->SetString("result", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void SynchronousCompositorProxy::SetSharedMemory(
    ::base::WritableSharedMemoryRegion in_shm_region, SetSharedMemoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositor::SetSharedMemory", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("shm_region", base::trace_event::ValueToString(in_shm_region, "<value of type ::base::WritableSharedMemoryRegion>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_SetSharedMemory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_SetSharedMemory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->shm_region)::BaseType::BufferWriter
      shm_region_writer;
  mojo::internal::Serialize<::mojo_base::mojom::WritableSharedMemoryRegionDataView>(
      in_shm_region, buffer, &shm_region_writer, &serialization_context);
  params->shm_region.Set(
      shm_region_writer.is_null() ? nullptr : shm_region_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shm_region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shm_region in SynchronousCompositor.SetSharedMemory request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("SetSharedMemory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SynchronousCompositor_SetSharedMemory_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool SynchronousCompositorProxy::DemandDrawSw(
    SyncCompositorDemandDrawSwParamsPtr param_draw_params, SyncCompositorCommonRendererParamsPtr* out_param_result, uint32_t* out_param_metadata_version, base::Optional<::viz::CompositorFrameMetadata>* out_param_meta_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::SynchronousCompositor::DemandDrawSw", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (param_draw_params.is_null()) {
        raw_value->SetString("draw_params", "nullptr");
      } else {
        raw_value->BeginDictionary("draw_params");
        param_draw_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_DemandDrawSw_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_DemandDrawSw_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->draw_params)::BaseType::BufferWriter
      draw_params_writer;
  mojo::internal::Serialize<::blink::mojom::SyncCompositorDemandDrawSwParamsDataView>(
      param_draw_params, buffer, &draw_params_writer, &serialization_context);
  params->draw_params.Set(
      draw_params_writer.is_null() ? nullptr : draw_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->draw_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null draw_params in SynchronousCompositor.DemandDrawSw request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("DemandDrawSw");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SynchronousCompositor_DemandDrawSw_HandleSyncResponse(
          &result, out_param_result, out_param_metadata_version, out_param_meta_data));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::SynchronousCompositor::DemandDrawSw", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_result) {
        if ((*out_param_result).is_null()) {
          raw_value->SetString("result", "nullptr");
        } else {
          raw_value->BeginDictionary("result");
          (*out_param_result)->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      } else {
        raw_value->SetString("result", "nullptr");
      }
      if (out_param_metadata_version) {
        raw_value->SetString("metadata_version", base::NumberToString((*out_param_metadata_version)));
      } else {
        raw_value->SetString("metadata_version", "nullptr");
      }
      if (out_param_meta_data) {
        raw_value->SetString("meta_data", base::trace_event::ValueToString((*out_param_meta_data), "<value of type base::Optional<::viz::CompositorFrameMetadata>>"));
      } else {
        raw_value->SetString("meta_data", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void SynchronousCompositorProxy::DemandDrawSw(
    SyncCompositorDemandDrawSwParamsPtr in_draw_params, DemandDrawSwCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositor::DemandDrawSw", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_draw_params.is_null()) {
        raw_value->SetString("draw_params", "nullptr");
      } else {
        raw_value->BeginDictionary("draw_params");
        in_draw_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_DemandDrawSw_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_DemandDrawSw_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->draw_params)::BaseType::BufferWriter
      draw_params_writer;
  mojo::internal::Serialize<::blink::mojom::SyncCompositorDemandDrawSwParamsDataView>(
      in_draw_params, buffer, &draw_params_writer, &serialization_context);
  params->draw_params.Set(
      draw_params_writer.is_null() ? nullptr : draw_params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->draw_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null draw_params in SynchronousCompositor.DemandDrawSw request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("DemandDrawSw");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SynchronousCompositor_DemandDrawSw_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SynchronousCompositorProxy::WillSkipDraw(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SynchronousCompositor::WillSkipDraw");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_WillSkipDraw_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_WillSkipDraw_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("WillSkipDraw");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SynchronousCompositorProxy::ZeroSharedMemory(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SynchronousCompositor::ZeroSharedMemory");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_ZeroSharedMemory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_ZeroSharedMemory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("ZeroSharedMemory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool SynchronousCompositorProxy::ZoomBy(
    float param_delta, const ::gfx::Point& param_anchor, SyncCompositorCommonRendererParamsPtr* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::SynchronousCompositor::ZoomBy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetDouble("delta", param_delta);
      raw_value->SetString("anchor", base::trace_event::ValueToString(param_anchor, "<value of type const ::gfx::Point&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_ZoomBy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_ZoomBy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->delta = param_delta;
  typename decltype(params->anchor)::BaseType::BufferWriter
      anchor_writer;
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      param_anchor, buffer, &anchor_writer, &serialization_context);
  params->anchor.Set(
      anchor_writer.is_null() ? nullptr : anchor_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->anchor.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null anchor in SynchronousCompositor.ZoomBy request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("ZoomBy");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SynchronousCompositor_ZoomBy_HandleSyncResponse(
          &result, out_param_result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::SynchronousCompositor::ZoomBy", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_result) {
        if ((*out_param_result).is_null()) {
          raw_value->SetString("result", "nullptr");
        } else {
          raw_value->BeginDictionary("result");
          (*out_param_result)->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      } else {
        raw_value->SetString("result", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void SynchronousCompositorProxy::ZoomBy(
    float in_delta, const ::gfx::Point& in_anchor, ZoomByCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositor::ZoomBy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetDouble("delta", in_delta);
      raw_value->SetString("anchor", base::trace_event::ValueToString(in_anchor, "<value of type const ::gfx::Point&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_ZoomBy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_ZoomBy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->delta = in_delta;
  typename decltype(params->anchor)::BaseType::BufferWriter
      anchor_writer;
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_anchor, buffer, &anchor_writer, &serialization_context);
  params->anchor.Set(
      anchor_writer.is_null() ? nullptr : anchor_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->anchor.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null anchor in SynchronousCompositor.ZoomBy request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("ZoomBy");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SynchronousCompositor_ZoomBy_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void SynchronousCompositorProxy::SetMemoryPolicy(
    uint32_t in_bytes_limit) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositor::SetMemoryPolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("bytes_limit", base::NumberToString(in_bytes_limit));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_SetMemoryPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_SetMemoryPolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->bytes_limit = in_bytes_limit;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("SetMemoryPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SynchronousCompositorProxy::ReclaimResources(
    uint32_t in_layer_tree_frame_sink_id, const std::vector<::viz::ReturnedResource>& in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositor::ReclaimResources", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("layer_tree_frame_sink_id", base::NumberToString(in_layer_tree_frame_sink_id));
      raw_value->BeginArray("resources");
      for (const auto& item0 : in_resources) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::viz::ReturnedResource&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_ReclaimResources_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_ReclaimResources_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->layer_tree_frame_sink_id = in_layer_tree_frame_sink_id;
  typename decltype(params->resources)::BaseType::BufferWriter
      resources_writer;
  const mojo::internal::ContainerValidateParams resources_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources, buffer, &resources_writer, &resources_validate_params,
      &serialization_context);
  params->resources.Set(
      resources_writer.is_null() ? nullptr : resources_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in SynchronousCompositor.ReclaimResources request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("ReclaimResources");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SynchronousCompositorProxy::SetScroll(
    const ::gfx::ScrollOffset& in_offset) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositor::SetScroll", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("offset", base::trace_event::ValueToString(in_offset, "<value of type const ::gfx::ScrollOffset&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_SetScroll_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_SetScroll_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->offset)::BaseType::BufferWriter
      offset_writer;
  mojo::internal::Serialize<::gfx::mojom::ScrollOffsetDataView>(
      in_offset, buffer, &offset_writer, &serialization_context);
  params->offset.Set(
      offset_writer.is_null() ? nullptr : offset_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->offset.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null offset in SynchronousCompositor.SetScroll request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("SetScroll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SynchronousCompositorProxy::BeginFrame(
    const ::viz::BeginFrameArgs& in_args, const base::flat_map<uint32_t, ::viz::FrameTimingDetails>& in_timing_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositor::BeginFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("args", base::trace_event::ValueToString(in_args, "<value of type const ::viz::BeginFrameArgs&>"));
      raw_value->BeginDictionary("timing_details");
      for (const auto& item0 : in_timing_details) {
        raw_value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.first, "<value of type uint32_t>"), base::trace_event::ValueToString(item0.second, "<value of type const ::viz::FrameTimingDetails&>"));
      }
      raw_value->EndDictionary();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_BeginFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_BeginFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->args)::BaseType::BufferWriter
      args_writer;
  mojo::internal::Serialize<::viz::mojom::BeginFrameArgsDataView>(
      in_args, buffer, &args_writer, &serialization_context);
  params->args.Set(
      args_writer.is_null() ? nullptr : args_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->args.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null args in SynchronousCompositor.BeginFrame request");
  typename decltype(params->timing_details)::BaseType::BufferWriter
      timing_details_writer;
  const mojo::internal::ContainerValidateParams timing_details_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::viz::mojom::FrameTimingDetailsDataView>>(
      in_timing_details, buffer, &timing_details_writer, &timing_details_validate_params,
      &serialization_context);
  params->timing_details.Set(
      timing_details_writer.is_null() ? nullptr : timing_details_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->timing_details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timing_details in SynchronousCompositor.BeginFrame request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("BeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SynchronousCompositorProxy::SetBeginFrameSourcePaused(
    bool in_paused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositor::SetBeginFrameSourcePaused", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("paused", in_paused);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_SetBeginFrameSourcePaused_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_SetBeginFrameSourcePaused_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->paused = in_paused;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("SetBeginFrameSourcePaused");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class SynchronousCompositor_DemandDrawHw_ProxyToResponder {
 public:
  static SynchronousCompositor::DemandDrawHwCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SynchronousCompositor_DemandDrawHw_ProxyToResponder> proxy(
        new SynchronousCompositor_DemandDrawHw_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SynchronousCompositor_DemandDrawHw_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SynchronousCompositor_DemandDrawHw_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SynchronousCompositor_DemandDrawHw_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SynchronousCompositor::DemandDrawHwCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SyncCompositorCommonRendererParamsPtr in_result, uint32_t in_layer_tree_frame_sink_id, uint32_t in_metadata_version, base::Optional<::viz::CompositorFrame> in_frame, base::Optional<::viz::HitTestRegionList> in_hit_test_region_list);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_DemandDrawHw_ProxyToResponder);
};

bool SynchronousCompositor_DemandDrawHw_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::SynchronousCompositor::DemandDrawHwCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::SynchronousCompositor_DemandDrawHw_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SynchronousCompositor_DemandDrawHw_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  SyncCompositorCommonRendererParamsPtr p_result{};
  uint32_t p_layer_tree_frame_sink_id{};
  uint32_t p_metadata_version{};
  base::Optional<::viz::CompositorFrame> p_frame{};
  base::Optional<::viz::HitTestRegionList> p_hit_test_region_list{};
  SynchronousCompositor_DemandDrawHw_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_layer_tree_frame_sink_id = input_data_view.layer_tree_frame_sink_id();
  if (success)
    p_metadata_version = input_data_view.metadata_version();
  if (success && !input_data_view.ReadFrame(&p_frame))
    success = false;
  if (success && !input_data_view.ReadHitTestRegionList(&p_hit_test_region_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SynchronousCompositor::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_layer_tree_frame_sink_id), 
std::move(p_metadata_version), 
std::move(p_frame), 
std::move(p_hit_test_region_list));
  return true;
}

void SynchronousCompositor_DemandDrawHw_ProxyToResponder::Run(
    SyncCompositorCommonRendererParamsPtr in_result, uint32_t in_layer_tree_frame_sink_id, uint32_t in_metadata_version, base::Optional<::viz::CompositorFrame> in_frame, base::Optional<::viz::HitTestRegionList> in_hit_test_region_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::SynchronousCompositor::DemandDrawHwCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("layer_tree_frame_sink_id", base::NumberToString(in_layer_tree_frame_sink_id));
      raw_value->SetString("metadata_version", base::NumberToString(in_metadata_version));
      raw_value->SetString("frame", base::trace_event::ValueToString(in_frame, "<value of type base::Optional<::viz::CompositorFrame>>"));
      raw_value->SetString("hit_test_region_list", base::trace_event::ValueToString(in_hit_test_region_list, "<value of type base::Optional<::viz::HitTestRegionList>>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_DemandDrawHw_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_DemandDrawHw_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::SyncCompositorCommonRendererParamsDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  params->layer_tree_frame_sink_id = in_layer_tree_frame_sink_id;
  params->metadata_version = in_metadata_version;
  typename decltype(params->frame)::BaseType::BufferWriter
      frame_writer;
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      in_frame, buffer, &frame_writer, &serialization_context);
  params->frame.Set(
      frame_writer.is_null() ? nullptr : frame_writer.data());
  typename decltype(params->hit_test_region_list)::BaseType::BufferWriter
      hit_test_region_list_writer;
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      in_hit_test_region_list, buffer, &hit_test_region_list_writer, &serialization_context);
  params->hit_test_region_list.Set(
      hit_test_region_list_writer.is_null() ? nullptr : hit_test_region_list_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::SynchronousCompositor::DemandDrawHwCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("DemandDrawHw");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool SynchronousCompositor_DemandDrawHw_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::SynchronousCompositor_DemandDrawHw_ResponseParams_Data* params =
      reinterpret_cast<internal::SynchronousCompositor_DemandDrawHw_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  SyncCompositorCommonRendererParamsPtr p_result{};
  uint32_t p_layer_tree_frame_sink_id{};
  uint32_t p_metadata_version{};
  base::Optional<::viz::CompositorFrame> p_frame{};
  base::Optional<::viz::HitTestRegionList> p_hit_test_region_list{};
  SynchronousCompositor_DemandDrawHw_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_layer_tree_frame_sink_id = input_data_view.layer_tree_frame_sink_id();
  if (success)
    p_metadata_version = input_data_view.metadata_version();
  if (success && !input_data_view.ReadFrame(&p_frame))
    success = false;
  if (success && !input_data_view.ReadHitTestRegionList(&p_hit_test_region_list))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SynchronousCompositor::Name_, 1, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *out_layer_tree_frame_sink_id_ = std::move(p_layer_tree_frame_sink_id);
  *out_metadata_version_ = std::move(p_metadata_version);
  *out_frame_ = std::move(p_frame);
  *out_hit_test_region_list_ = std::move(p_hit_test_region_list);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class SynchronousCompositor_SetSharedMemory_ProxyToResponder {
 public:
  static SynchronousCompositor::SetSharedMemoryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SynchronousCompositor_SetSharedMemory_ProxyToResponder> proxy(
        new SynchronousCompositor_SetSharedMemory_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SynchronousCompositor_SetSharedMemory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SynchronousCompositor_SetSharedMemory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SynchronousCompositor_SetSharedMemory_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SynchronousCompositor::SetSharedMemoryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, SyncCompositorCommonRendererParamsPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_SetSharedMemory_ProxyToResponder);
};

bool SynchronousCompositor_SetSharedMemory_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::SynchronousCompositor::SetSharedMemoryCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::SynchronousCompositor_SetSharedMemory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SynchronousCompositor_SetSharedMemory_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  SyncCompositorCommonRendererParamsPtr p_result{};
  SynchronousCompositor_SetSharedMemory_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SynchronousCompositor::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_result));
  return true;
}

void SynchronousCompositor_SetSharedMemory_ProxyToResponder::Run(
    bool in_success, SyncCompositorCommonRendererParamsPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::SynchronousCompositor::SetSharedMemoryCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_SetSharedMemory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_SetSharedMemory_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::SyncCompositorCommonRendererParamsDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::SynchronousCompositor::SetSharedMemoryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("SetSharedMemory");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool SynchronousCompositor_SetSharedMemory_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::SynchronousCompositor_SetSharedMemory_ResponseParams_Data* params =
      reinterpret_cast<internal::SynchronousCompositor_SetSharedMemory_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  SyncCompositorCommonRendererParamsPtr p_result{};
  SynchronousCompositor_SetSharedMemory_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SynchronousCompositor::Name_, 2, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *out_result_ = std::move(p_result);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class SynchronousCompositor_DemandDrawSw_ProxyToResponder {
 public:
  static SynchronousCompositor::DemandDrawSwCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SynchronousCompositor_DemandDrawSw_ProxyToResponder> proxy(
        new SynchronousCompositor_DemandDrawSw_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SynchronousCompositor_DemandDrawSw_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SynchronousCompositor_DemandDrawSw_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SynchronousCompositor_DemandDrawSw_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SynchronousCompositor::DemandDrawSwCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SyncCompositorCommonRendererParamsPtr in_result, uint32_t in_metadata_version, base::Optional<::viz::CompositorFrameMetadata> in_meta_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_DemandDrawSw_ProxyToResponder);
};

bool SynchronousCompositor_DemandDrawSw_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::SynchronousCompositor::DemandDrawSwCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::SynchronousCompositor_DemandDrawSw_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SynchronousCompositor_DemandDrawSw_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  SyncCompositorCommonRendererParamsPtr p_result{};
  uint32_t p_metadata_version{};
  base::Optional<::viz::CompositorFrameMetadata> p_meta_data{};
  SynchronousCompositor_DemandDrawSw_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_metadata_version = input_data_view.metadata_version();
  if (success && !input_data_view.ReadMetaData(&p_meta_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SynchronousCompositor::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_metadata_version), 
std::move(p_meta_data));
  return true;
}

void SynchronousCompositor_DemandDrawSw_ProxyToResponder::Run(
    SyncCompositorCommonRendererParamsPtr in_result, uint32_t in_metadata_version, base::Optional<::viz::CompositorFrameMetadata> in_meta_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::SynchronousCompositor::DemandDrawSwCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("metadata_version", base::NumberToString(in_metadata_version));
      raw_value->SetString("meta_data", base::trace_event::ValueToString(in_meta_data, "<value of type base::Optional<::viz::CompositorFrameMetadata>>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_DemandDrawSw_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_DemandDrawSw_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::SyncCompositorCommonRendererParamsDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  params->metadata_version = in_metadata_version;
  typename decltype(params->meta_data)::BaseType::BufferWriter
      meta_data_writer;
  mojo::internal::Serialize<::viz::mojom::CompositorFrameMetadataDataView>(
      in_meta_data, buffer, &meta_data_writer, &serialization_context);
  params->meta_data.Set(
      meta_data_writer.is_null() ? nullptr : meta_data_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::SynchronousCompositor::DemandDrawSwCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("DemandDrawSw");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool SynchronousCompositor_DemandDrawSw_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::SynchronousCompositor_DemandDrawSw_ResponseParams_Data* params =
      reinterpret_cast<internal::SynchronousCompositor_DemandDrawSw_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  SyncCompositorCommonRendererParamsPtr p_result{};
  uint32_t p_metadata_version{};
  base::Optional<::viz::CompositorFrameMetadata> p_meta_data{};
  SynchronousCompositor_DemandDrawSw_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_metadata_version = input_data_view.metadata_version();
  if (success && !input_data_view.ReadMetaData(&p_meta_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SynchronousCompositor::Name_, 3, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *out_metadata_version_ = std::move(p_metadata_version);
  *out_meta_data_ = std::move(p_meta_data);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class SynchronousCompositor_ZoomBy_ProxyToResponder {
 public:
  static SynchronousCompositor::ZoomByCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SynchronousCompositor_ZoomBy_ProxyToResponder> proxy(
        new SynchronousCompositor_ZoomBy_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SynchronousCompositor_ZoomBy_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SynchronousCompositor_ZoomBy_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SynchronousCompositor_ZoomBy_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SynchronousCompositor::ZoomByCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SyncCompositorCommonRendererParamsPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SynchronousCompositor_ZoomBy_ProxyToResponder);
};

bool SynchronousCompositor_ZoomBy_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::SynchronousCompositor::ZoomByCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::SynchronousCompositor_ZoomBy_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SynchronousCompositor_ZoomBy_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  SyncCompositorCommonRendererParamsPtr p_result{};
  SynchronousCompositor_ZoomBy_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SynchronousCompositor::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void SynchronousCompositor_ZoomBy_ProxyToResponder::Run(
    SyncCompositorCommonRendererParamsPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::SynchronousCompositor::ZoomByCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositor_ZoomBy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositor_ZoomBy_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::SyncCompositorCommonRendererParamsDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::SynchronousCompositor::ZoomByCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositor::Name_);
  message.set_method_name("ZoomBy");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool SynchronousCompositor_ZoomBy_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::SynchronousCompositor_ZoomBy_ResponseParams_Data* params =
      reinterpret_cast<internal::SynchronousCompositor_ZoomBy_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  SyncCompositorCommonRendererParamsPtr p_result{};
  SynchronousCompositor_ZoomBy_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SynchronousCompositor::Name_, 6, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool SynchronousCompositorStubDispatch::Accept(
    SynchronousCompositor* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSynchronousCompositor_DemandDrawHwAsync_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::DemandDrawHwAsync",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::DemandDrawHwAsync");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositor_DemandDrawHwAsync_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositor_DemandDrawHwAsync_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SyncCompositorDemandDrawHwParamsPtr p_draw_params{};
      SynchronousCompositor_DemandDrawHwAsync_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDrawParams(&p_draw_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DemandDrawHwAsync(
std::move(p_draw_params));
      return true;
    }
    case internal::kSynchronousCompositor_DemandDrawHw_Name: {
      break;
    }
    case internal::kSynchronousCompositor_SetSharedMemory_Name: {
      break;
    }
    case internal::kSynchronousCompositor_DemandDrawSw_Name: {
      break;
    }
    case internal::kSynchronousCompositor_WillSkipDraw_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::WillSkipDraw",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::WillSkipDraw");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositor_WillSkipDraw_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositor_WillSkipDraw_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SynchronousCompositor_WillSkipDraw_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WillSkipDraw();
      return true;
    }
    case internal::kSynchronousCompositor_ZeroSharedMemory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::ZeroSharedMemory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::ZeroSharedMemory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositor_ZeroSharedMemory_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositor_ZeroSharedMemory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SynchronousCompositor_ZeroSharedMemory_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ZeroSharedMemory();
      return true;
    }
    case internal::kSynchronousCompositor_ZoomBy_Name: {
      break;
    }
    case internal::kSynchronousCompositor_SetMemoryPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::SetMemoryPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::SetMemoryPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositor_SetMemoryPolicy_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositor_SetMemoryPolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_bytes_limit{};
      SynchronousCompositor_SetMemoryPolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_bytes_limit = input_data_view.bytes_limit();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMemoryPolicy(
std::move(p_bytes_limit));
      return true;
    }
    case internal::kSynchronousCompositor_ReclaimResources_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::ReclaimResources",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::ReclaimResources");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositor_ReclaimResources_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositor_ReclaimResources_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_layer_tree_frame_sink_id{};
      std::vector<::viz::ReturnedResource> p_resources{};
      SynchronousCompositor_ReclaimResources_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_layer_tree_frame_sink_id = input_data_view.layer_tree_frame_sink_id();
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReclaimResources(
std::move(p_layer_tree_frame_sink_id), 
std::move(p_resources));
      return true;
    }
    case internal::kSynchronousCompositor_SetScroll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::SetScroll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::SetScroll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositor_SetScroll_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositor_SetScroll_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::ScrollOffset p_offset{};
      SynchronousCompositor_SetScroll_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOffset(&p_offset))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetScroll(
std::move(p_offset));
      return true;
    }
    case internal::kSynchronousCompositor_BeginFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::BeginFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::BeginFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositor_BeginFrame_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositor_BeginFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::BeginFrameArgs p_args{};
      base::flat_map<uint32_t, ::viz::FrameTimingDetails> p_timing_details{};
      SynchronousCompositor_BeginFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (success && !input_data_view.ReadTimingDetails(&p_timing_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginFrame(
std::move(p_args), 
std::move(p_timing_details));
      return true;
    }
    case internal::kSynchronousCompositor_SetBeginFrameSourcePaused_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::SetBeginFrameSourcePaused",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::SetBeginFrameSourcePaused");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositor_SetBeginFrameSourcePaused_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositor_SetBeginFrameSourcePaused_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_paused{};
      SynchronousCompositor_SetBeginFrameSourcePaused_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_paused = input_data_view.paused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBeginFrameSourcePaused(
std::move(p_paused));
      return true;
    }
  }
  return false;
}

// static
bool SynchronousCompositorStubDispatch::AcceptWithResponder(
    SynchronousCompositor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSynchronousCompositor_DemandDrawHwAsync_Name: {
      break;
    }
    case internal::kSynchronousCompositor_DemandDrawHw_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::DemandDrawHw",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::DemandDrawHw");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SynchronousCompositor_DemandDrawHw_Params_Data* params =
          reinterpret_cast<
              internal::SynchronousCompositor_DemandDrawHw_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SyncCompositorDemandDrawHwParamsPtr p_draw_params{};
      SynchronousCompositor_DemandDrawHw_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDrawParams(&p_draw_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 1, false);
        return false;
      }
      SynchronousCompositor::DemandDrawHwCallback callback =
          SynchronousCompositor_DemandDrawHw_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DemandDrawHw(
std::move(p_draw_params), std::move(callback));
      return true;
    }
    case internal::kSynchronousCompositor_SetSharedMemory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::SetSharedMemory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::SetSharedMemory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SynchronousCompositor_SetSharedMemory_Params_Data* params =
          reinterpret_cast<
              internal::SynchronousCompositor_SetSharedMemory_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::WritableSharedMemoryRegion p_shm_region{};
      SynchronousCompositor_SetSharedMemory_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadShmRegion(&p_shm_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 2, false);
        return false;
      }
      SynchronousCompositor::SetSharedMemoryCallback callback =
          SynchronousCompositor_SetSharedMemory_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSharedMemory(
std::move(p_shm_region), std::move(callback));
      return true;
    }
    case internal::kSynchronousCompositor_DemandDrawSw_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::DemandDrawSw",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::DemandDrawSw");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SynchronousCompositor_DemandDrawSw_Params_Data* params =
          reinterpret_cast<
              internal::SynchronousCompositor_DemandDrawSw_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      SyncCompositorDemandDrawSwParamsPtr p_draw_params{};
      SynchronousCompositor_DemandDrawSw_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDrawParams(&p_draw_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 3, false);
        return false;
      }
      SynchronousCompositor::DemandDrawSwCallback callback =
          SynchronousCompositor_DemandDrawSw_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DemandDrawSw(
std::move(p_draw_params), std::move(callback));
      return true;
    }
    case internal::kSynchronousCompositor_WillSkipDraw_Name: {
      break;
    }
    case internal::kSynchronousCompositor_ZeroSharedMemory_Name: {
      break;
    }
    case internal::kSynchronousCompositor_ZoomBy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositor::ZoomBy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositor::ZoomBy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SynchronousCompositor_ZoomBy_Params_Data* params =
          reinterpret_cast<
              internal::SynchronousCompositor_ZoomBy_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      float p_delta{};
      ::gfx::Point p_anchor{};
      SynchronousCompositor_ZoomBy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_delta = input_data_view.delta();
      if (success && !input_data_view.ReadAnchor(&p_anchor))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositor::Name_, 6, false);
        return false;
      }
      SynchronousCompositor::ZoomByCallback callback =
          SynchronousCompositor_ZoomBy_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ZoomBy(
std::move(p_delta), 
std::move(p_anchor), std::move(callback));
      return true;
    }
    case internal::kSynchronousCompositor_SetMemoryPolicy_Name: {
      break;
    }
    case internal::kSynchronousCompositor_ReclaimResources_Name: {
      break;
    }
    case internal::kSynchronousCompositor_SetScroll_Name: {
      break;
    }
    case internal::kSynchronousCompositor_BeginFrame_Name: {
      break;
    }
    case internal::kSynchronousCompositor_SetBeginFrameSourcePaused_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSynchronousCompositorValidationInfo[] = {
    {&internal::SynchronousCompositor_DemandDrawHwAsync_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SynchronousCompositor_DemandDrawHw_Params_Data::Validate,
     &internal::SynchronousCompositor_DemandDrawHw_ResponseParams_Data::Validate},
    {&internal::SynchronousCompositor_SetSharedMemory_Params_Data::Validate,
     &internal::SynchronousCompositor_SetSharedMemory_ResponseParams_Data::Validate},
    {&internal::SynchronousCompositor_DemandDrawSw_Params_Data::Validate,
     &internal::SynchronousCompositor_DemandDrawSw_ResponseParams_Data::Validate},
    {&internal::SynchronousCompositor_WillSkipDraw_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SynchronousCompositor_ZeroSharedMemory_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SynchronousCompositor_ZoomBy_Params_Data::Validate,
     &internal::SynchronousCompositor_ZoomBy_ResponseParams_Data::Validate},
    {&internal::SynchronousCompositor_SetMemoryPolicy_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SynchronousCompositor_ReclaimResources_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SynchronousCompositor_SetScroll_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SynchronousCompositor_BeginFrame_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SynchronousCompositor_SetBeginFrameSourcePaused_Params_Data::Validate,
     nullptr /* no response */},
};

bool SynchronousCompositorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SynchronousCompositor::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSynchronousCompositorValidationInfo);
}

bool SynchronousCompositorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SynchronousCompositor::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kSynchronousCompositorValidationInfo);
}
const char SynchronousCompositorHost::Name_[] = "blink.mojom.SynchronousCompositorHost";

SynchronousCompositorHostProxy::SynchronousCompositorHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SynchronousCompositorHostProxy::LayerTreeFrameSinkCreated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::SynchronousCompositorHost::LayerTreeFrameSinkCreated");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositorHost_LayerTreeFrameSinkCreated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositorHost_LayerTreeFrameSinkCreated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositorHost::Name_);
  message.set_method_name("LayerTreeFrameSinkCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SynchronousCompositorHostProxy::UpdateState(
    SyncCompositorCommonRendererParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositorHost::UpdateState", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositorHost_UpdateState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositorHost_UpdateState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::blink::mojom::SyncCompositorCommonRendererParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in SynchronousCompositorHost.UpdateState request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositorHost::Name_);
  message.set_method_name("UpdateState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SynchronousCompositorHostProxy::SetNeedsBeginFrames(
    bool in_needs_begin_frames) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositorHost::SetNeedsBeginFrames", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("needs_begin_frames", in_needs_begin_frames);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositorHost_SetNeedsBeginFrames_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositorHost_SetNeedsBeginFrames_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->needs_begin_frames = in_needs_begin_frames;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositorHost::Name_);
  message.set_method_name("SetNeedsBeginFrames");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SynchronousCompositorHostStubDispatch::Accept(
    SynchronousCompositorHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSynchronousCompositorHost_LayerTreeFrameSinkCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositorHost::LayerTreeFrameSinkCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositorHost::LayerTreeFrameSinkCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositorHost_LayerTreeFrameSinkCreated_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositorHost_LayerTreeFrameSinkCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SynchronousCompositorHost_LayerTreeFrameSinkCreated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositorHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LayerTreeFrameSinkCreated();
      return true;
    }
    case internal::kSynchronousCompositorHost_UpdateState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositorHost::UpdateState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositorHost::UpdateState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositorHost_UpdateState_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositorHost_UpdateState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SyncCompositorCommonRendererParamsPtr p_params{};
      SynchronousCompositorHost_UpdateState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositorHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateState(
std::move(p_params));
      return true;
    }
    case internal::kSynchronousCompositorHost_SetNeedsBeginFrames_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositorHost::SetNeedsBeginFrames",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositorHost::SetNeedsBeginFrames");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositorHost_SetNeedsBeginFrames_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositorHost_SetNeedsBeginFrames_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_needs_begin_frames{};
      SynchronousCompositorHost_SetNeedsBeginFrames_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_needs_begin_frames = input_data_view.needs_begin_frames();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositorHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsBeginFrames(
std::move(p_needs_begin_frames));
      return true;
    }
  }
  return false;
}

// static
bool SynchronousCompositorHostStubDispatch::AcceptWithResponder(
    SynchronousCompositorHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSynchronousCompositorHost_LayerTreeFrameSinkCreated_Name: {
      break;
    }
    case internal::kSynchronousCompositorHost_UpdateState_Name: {
      break;
    }
    case internal::kSynchronousCompositorHost_SetNeedsBeginFrames_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSynchronousCompositorHostValidationInfo[] = {
    {&internal::SynchronousCompositorHost_LayerTreeFrameSinkCreated_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SynchronousCompositorHost_UpdateState_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SynchronousCompositorHost_SetNeedsBeginFrames_Params_Data::Validate,
     nullptr /* no response */},
};

bool SynchronousCompositorHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SynchronousCompositorHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSynchronousCompositorHostValidationInfo);
}

const char SynchronousCompositorControlHost::Name_[] = "blink.mojom.SynchronousCompositorControlHost";

SynchronousCompositorControlHostProxy::SynchronousCompositorControlHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SynchronousCompositorControlHostProxy::ReturnFrame(
    uint32_t in_layer_tree_frame_sink_id, uint32_t in_metadata_version, base::Optional<::viz::CompositorFrame> in_frame, base::Optional<::viz::HitTestRegionList> in_hit_test_region_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositorControlHost::ReturnFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("layer_tree_frame_sink_id", base::NumberToString(in_layer_tree_frame_sink_id));
      raw_value->SetString("metadata_version", base::NumberToString(in_metadata_version));
      raw_value->SetString("frame", base::trace_event::ValueToString(in_frame, "<value of type base::Optional<::viz::CompositorFrame>>"));
      raw_value->SetString("hit_test_region_list", base::trace_event::ValueToString(in_hit_test_region_list, "<value of type base::Optional<::viz::HitTestRegionList>>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositorControlHost_ReturnFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositorControlHost_ReturnFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->layer_tree_frame_sink_id = in_layer_tree_frame_sink_id;
  params->metadata_version = in_metadata_version;
  typename decltype(params->frame)::BaseType::BufferWriter
      frame_writer;
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      in_frame, buffer, &frame_writer, &serialization_context);
  params->frame.Set(
      frame_writer.is_null() ? nullptr : frame_writer.data());
  typename decltype(params->hit_test_region_list)::BaseType::BufferWriter
      hit_test_region_list_writer;
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      in_hit_test_region_list, buffer, &hit_test_region_list_writer, &serialization_context);
  params->hit_test_region_list.Set(
      hit_test_region_list_writer.is_null() ? nullptr : hit_test_region_list_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositorControlHost::Name_);
  message.set_method_name("ReturnFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void SynchronousCompositorControlHostProxy::BeginFrameResponse(
    SyncCompositorCommonRendererParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::SynchronousCompositorControlHost::BeginFrameResponse", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSynchronousCompositorControlHost_BeginFrameResponse_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::SynchronousCompositorControlHost_BeginFrameResponse_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::blink::mojom::SyncCompositorCommonRendererParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in SynchronousCompositorControlHost.BeginFrameResponse request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SynchronousCompositorControlHost::Name_);
  message.set_method_name("BeginFrameResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool SynchronousCompositorControlHostStubDispatch::Accept(
    SynchronousCompositorControlHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSynchronousCompositorControlHost_ReturnFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositorControlHost::ReturnFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositorControlHost::ReturnFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositorControlHost_ReturnFrame_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositorControlHost_ReturnFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_layer_tree_frame_sink_id{};
      uint32_t p_metadata_version{};
      base::Optional<::viz::CompositorFrame> p_frame{};
      base::Optional<::viz::HitTestRegionList> p_hit_test_region_list{};
      SynchronousCompositorControlHost_ReturnFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_layer_tree_frame_sink_id = input_data_view.layer_tree_frame_sink_id();
      if (success)
        p_metadata_version = input_data_view.metadata_version();
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success && !input_data_view.ReadHitTestRegionList(&p_hit_test_region_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositorControlHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReturnFrame(
std::move(p_layer_tree_frame_sink_id), 
std::move(p_metadata_version), 
std::move(p_frame), 
std::move(p_hit_test_region_list));
      return true;
    }
    case internal::kSynchronousCompositorControlHost_BeginFrameResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::SynchronousCompositorControlHost::BeginFrameResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::SynchronousCompositorControlHost::BeginFrameResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::SynchronousCompositorControlHost_BeginFrameResponse_Params_Data* params =
          reinterpret_cast<internal::SynchronousCompositorControlHost_BeginFrameResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SyncCompositorCommonRendererParamsPtr p_params{};
      SynchronousCompositorControlHost_BeginFrameResponse_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SynchronousCompositorControlHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginFrameResponse(
std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool SynchronousCompositorControlHostStubDispatch::AcceptWithResponder(
    SynchronousCompositorControlHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSynchronousCompositorControlHost_ReturnFrame_Name: {
      break;
    }
    case internal::kSynchronousCompositorControlHost_BeginFrameResponse_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kSynchronousCompositorControlHostValidationInfo[] = {
    {&internal::SynchronousCompositorControlHost_ReturnFrame_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::SynchronousCompositorControlHost_BeginFrameResponse_Params_Data::Validate,
     nullptr /* no response */},
};

bool SynchronousCompositorControlHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::SynchronousCompositorControlHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kSynchronousCompositorControlHostValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::SyncCompositorDemandDrawHwParams::DataView, ::blink::mojom::SyncCompositorDemandDrawHwParamsPtr>::Read(
    ::blink::mojom::SyncCompositorDemandDrawHwParams::DataView input,
    ::blink::mojom::SyncCompositorDemandDrawHwParamsPtr* output) {
  bool success = true;
  ::blink::mojom::SyncCompositorDemandDrawHwParamsPtr result(::blink::mojom::SyncCompositorDemandDrawHwParams::New());
  
      if (success && !input.ReadViewportSize(&result->viewport_size))
        success = false;
      if (success && !input.ReadViewportRectForTilePriority(&result->viewport_rect_for_tile_priority))
        success = false;
      if (success && !input.ReadTransformForTilePriority(&result->transform_for_tile_priority))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SyncCompositorDemandDrawSwParams::DataView, ::blink::mojom::SyncCompositorDemandDrawSwParamsPtr>::Read(
    ::blink::mojom::SyncCompositorDemandDrawSwParams::DataView input,
    ::blink::mojom::SyncCompositorDemandDrawSwParamsPtr* output) {
  bool success = true;
  ::blink::mojom::SyncCompositorDemandDrawSwParamsPtr result(::blink::mojom::SyncCompositorDemandDrawSwParams::New());
  
      if (success && !input.ReadSize(&result->size))
        success = false;
      if (success && !input.ReadClip(&result->clip))
        success = false;
      if (success && !input.ReadTransform(&result->transform))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SyncCompositorCommonRendererParams::DataView, ::blink::mojom::SyncCompositorCommonRendererParamsPtr>::Read(
    ::blink::mojom::SyncCompositorCommonRendererParams::DataView input,
    ::blink::mojom::SyncCompositorCommonRendererParamsPtr* output) {
  bool success = true;
  ::blink::mojom::SyncCompositorCommonRendererParamsPtr result(::blink::mojom::SyncCompositorCommonRendererParams::New());
  
      if (success)
        result->version = input.version();
      if (success && !input.ReadTotalScrollOffset(&result->total_scroll_offset))
        success = false;
      if (success && !input.ReadMaxScrollOffset(&result->max_scroll_offset))
        success = false;
      if (success && !input.ReadScrollableSize(&result->scrollable_size))
        success = false;
      if (success)
        result->page_scale_factor = input.page_scale_factor();
      if (success)
        result->min_page_scale_factor = input.min_page_scale_factor();
      if (success)
        result->max_page_scale_factor = input.max_page_scale_factor();
      if (success)
        result->need_invalidate_count = input.need_invalidate_count();
      if (success)
        result->invalidate_needs_draw = input.invalidate_needs_draw();
      if (success)
        result->did_activate_pending_tree_count = input.did_activate_pending_tree_count();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif