/* tracker-bus.c generated by valac 0.56.1, the Vala compiler
 * generated from tracker-bus.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include "tracker-bus.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-sparql/tracker-connection.h"
#include <glib-object.h>
#include <glib/gstdio.h>
#include "libtracker-common/tracker-utils.h"
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>
#include <unistd.h>
#include <gio/gunixfdlist.h>

#define TRACKER_BUS_CONNECTION_DBUS_PEER_IFACE "org.freedesktop.DBus.Peer"
#define TRACKER_BUS_CONNECTION_PORTAL_NAME "org.freedesktop.portal.Tracker"
#define TRACKER_BUS_CONNECTION_PORTAL_PATH "/org/freedesktop/portal/Tracker"
#define TRACKER_BUS_CONNECTION_PORTAL_IFACE "org.freedesktop.portal.Tracker"
#define TRACKER_BUS_CONNECTION_ENDPOINT_IFACE "org.freedesktop.Tracker3.Endpoint"
#define TRACKER_BUS_CONNECTION_timeout 30000

enum  {
	TRACKER_BUS_CONNECTION_0_PROPERTY,
	TRACKER_BUS_CONNECTION_BUS_NAME_PROPERTY,
	TRACKER_BUS_CONNECTION_BUS_OBJECT_PATH_PROPERTY,
	TRACKER_BUS_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* tracker_bus_connection_properties[TRACKER_BUS_CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerBusConnectionNewData TrackerBusConnectionNewData;
typedef struct _TrackerBusConnectionInitNamespacesData TrackerBusConnectionInitNamespacesData;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TRACKER_BUS_TYPE_FD_CURSOR (tracker_bus_fd_cursor_get_type ())
#define TRACKER_BUS_FD_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursor))
#define TRACKER_BUS_FD_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursorClass))
#define TRACKER_BUS_IS_FD_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_FD_CURSOR))
#define TRACKER_BUS_IS_FD_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_FD_CURSOR))
#define TRACKER_BUS_FD_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursorClass))

typedef struct _TrackerBusFDCursor TrackerBusFDCursor;
typedef struct _TrackerBusFDCursorClass TrackerBusFDCursorClass;
typedef struct _TrackerBusConnectionPerformQueryCallData TrackerBusConnectionPerformQueryCallData;
typedef struct _Block2Data Block2Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _TrackerBusConnectionQueryAsyncData TrackerBusConnectionQueryAsyncData;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _TrackerBusConnectionUpdateAsyncData TrackerBusConnectionUpdateAsyncData;
typedef struct _Block5Data Block5Data;
typedef struct _TrackerBusConnectionPerformUpdateArrayData TrackerBusConnectionPerformUpdateArrayData;
typedef struct _TrackerBusConnectionUpdateArrayAsyncData TrackerBusConnectionUpdateArrayAsyncData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _TrackerBusConnectionUpdateBlankAsyncData TrackerBusConnectionUpdateBlankAsyncData;
typedef struct _TrackerBusConnectionUpdateResourceAsyncData TrackerBusConnectionUpdateResourceAsyncData;
typedef struct _TrackerBusConnectionCloseAsyncData TrackerBusConnectionCloseAsyncData;
typedef struct _TrackerBusConnectionPerformSerializeData TrackerBusConnectionPerformSerializeData;
typedef struct _TrackerBusConnectionSerializeAsyncData TrackerBusConnectionSerializeAsyncData;

struct _TrackerBusConnectionPrivate {
	GDBusConnection* bus;
	gchar* dbus_name;
	gchar* object_path;
	gboolean sandboxed;
	TrackerNamespaceManager* namespaces;
};

struct _TrackerBusConnectionNewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GType object_type;
	TrackerBusConnection* self;
	gchar* dbus_name;
	gchar* object_path;
	GDBusConnection* dbus_connection;
	GCancellable* cancellable;
	GDBusConnection* _tmp0_;
	GError* _tmp1_;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GDBusMessage* message;
	GDBusMessage* _tmp4_;
	GDBusMessage* reply;
	GDBusConnection* _tmp5_;
	GDBusMessage* _tmp6_;
	GDBusMessage* _tmp7_;
	GDBusMessage* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* e;
	GError* _tmp11_;
	GError* _tmp12_;
	gchar* uri;
	gchar* _tmp14_;
	GDBusMessage* _vala1_message;
	GDBusMessage* _tmp15_;
	GDBusMessage* _tmp16_;
	const gchar* _tmp17_;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GDBusMessage* _vala1_reply;
	GDBusConnection* _tmp20_;
	GDBusMessage* _tmp21_;
	GDBusMessage* _tmp22_;
	GDBusMessage* _tmp23_;
	GVariant* variant;
	GDBusMessage* _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GVariant* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GError* _inner_error0_;
};

struct _TrackerBusConnectionInitNamespacesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	TrackerNamespaceManager* _tmp0_;
	TrackerSparqlCursor* cursor;
	TrackerSparqlCursor* _tmp1_;
	gboolean _tmp2_;
	TrackerSparqlCursor* _tmp3_;
	TrackerNamespaceManager* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	const gchar* _tmp6_;
	TrackerSparqlCursor* _tmp7_;
	const gchar* _tmp8_;
	TrackerSparqlCursor* _tmp9_;
	GError* _inner_error0_;
};

struct _Block1Data {
	int _ref_count_;
	GAsyncResult* dbus_res;
	gboolean received_result;
	gpointer _async_data_;
};

struct _TrackerBusConnectionPerformQueryCallData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GDBusConnection* bus;
	gchar* dbus_name;
	gchar* object_path;
	gchar* sparql;
	GVariantBuilder* arguments;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	Block1Data* _data1_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	GUnixOutputStream* _tmp2_;
	GMemoryOutputStream* mem_stream;
	GMemoryOutputStream* _tmp3_;
	GMemoryOutputStream* _tmp4_;
	GUnixInputStream* _tmp5_;
	GError* _inner_error1_;
	GAsyncResult* _tmp6_;
	GDBusMessage* reply;
	GAsyncResult* _tmp7_;
	GDBusMessage* _tmp8_;
	GDBusMessage* _tmp9_;
	gchar** variable_names;
	GDBusMessage* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gint variable_names_length1;
	gint _variable_names_size_;
	GMemoryOutputStream* _tmp16_;
	GMemoryOutputStream* _tmp17_;
	guint8* _tmp18_;
	GMemoryOutputStream* _tmp19_;
	gulong _tmp20_;
	gulong _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	TrackerBusFDCursor* _tmp23_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GMainLoop* loop;
	GAsyncResult* async_res;
};

struct _TrackerBusConnectionQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlCursor* _tmp0_;
	GDBusConnection* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	TrackerSparqlCursor* _tmp5_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GMainLoop* loop;
	GAsyncResult* async_res;
};

struct _Block4Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GAsyncResult* dbus_res;
	gboolean sent_update;
	gpointer _async_data_;
};

struct _TrackerBusConnectionUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar* sparql;
	GCancellable* cancellable;
	Block4Data* _data4_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	GDBusConnection* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GUnixInputStream* _tmp5_;
	GDataOutputStream* data_stream;
	GUnixOutputStream* _tmp6_;
	GDataOutputStream* _tmp7_;
	GDataOutputStream* _tmp8_;
	GDataOutputStream* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GDataOutputStream* _tmp12_;
	GAsyncResult* _tmp13_;
	GDBusMessage* reply;
	GDBusConnection* _tmp14_;
	GAsyncResult* _tmp15_;
	GDBusMessage* _tmp16_;
	GDBusMessage* _tmp17_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	GAsyncResult* dbus_res;
	gboolean sent_update;
	gpointer _async_data_;
};

struct _TrackerBusConnectionPerformUpdateArrayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GDBusConnection* bus;
	gchar* dbus_name;
	gchar* object_path;
	gchar** sparql;
	gint sparql_length1;
	GCancellable* cancellable;
	gboolean result;
	Block5Data* _data5_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	GUnixInputStream* _tmp2_;
	GDataOutputStream* data_stream;
	GUnixOutputStream* _tmp3_;
	GDataOutputStream* _tmp4_;
	GDataOutputStream* _tmp5_;
	GDataOutputStream* _tmp6_;
	gint i;
	gboolean _tmp7_;
	gint _tmp8_;
	GDataOutputStream* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GDataOutputStream* _tmp13_;
	const gchar* _tmp14_;
	GAsyncResult* _tmp15_;
	GDBusMessage* reply;
	GAsyncResult* _tmp16_;
	GDBusMessage* _tmp17_;
	GDBusMessage* _tmp18_;
	GError* _inner_error0_;
};

struct _TrackerBusConnectionUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar** sparql;
	gint sparql_length1;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	GDBusConnection* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GMainLoop* loop;
	GAsyncResult* async_res;
};

struct _Block7Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GAsyncResult* dbus_res;
	gboolean sent_update;
	gpointer _async_data_;
};

struct _TrackerBusConnectionUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar* sparql;
	GCancellable* cancellable;
	GVariant* result;
	Block7Data* _data7_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	GDBusConnection* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GUnixInputStream* _tmp5_;
	GDataOutputStream* data_stream;
	GUnixOutputStream* _tmp6_;
	GDataOutputStream* _tmp7_;
	GDataOutputStream* _tmp8_;
	GDataOutputStream* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GDataOutputStream* _tmp12_;
	GAsyncResult* _tmp13_;
	GDBusMessage* reply;
	GDBusConnection* _tmp14_;
	GAsyncResult* _tmp15_;
	GDBusMessage* _tmp16_;
	GDBusMessage* _tmp17_;
	GDBusMessage* _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GError* _inner_error0_;
};

struct _TrackerBusConnectionUpdateResourceAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar* graph;
	TrackerResource* resource;
	GCancellable* cancellable;
	gboolean result;
	TrackerBatch* batch;
	TrackerBatch* _tmp0_;
	gboolean _tmp1_;
	GError* _inner_error0_;
};

struct _TrackerBusConnectionCloseAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gboolean result;
};

struct _TrackerBusConnectionPerformSerializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GDBusConnection* bus;
	gchar* dbus_name;
	gchar* object_path;
	TrackerSerializeFlags flags;
	TrackerRdfFormat format;
	gchar* sparql;
	GVariantBuilder* arguments;
	GCancellable* cancellable;
	GInputStream* result;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	GDBusMessage* message;
	GDBusMessage* _tmp2_;
	GUnixFDList* fd_list;
	GUnixFDList* _tmp3_;
	gint _tmp4_;
	GUnixFDList* _tmp5_;
	GUnixOutputStream* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GDBusMessage* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GDBusMessage* _tmp12_;
	GUnixFDList* _tmp13_;
	GDBusMessage* reply;
	GDBusMessage* _tmp14_;
	GDBusMessage* _tmp15_;
	GDBusMessage* _tmp16_;
	GError* _inner_error0_;
};

struct _TrackerBusConnectionSerializeAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	TrackerSerializeFlags flags;
	TrackerRdfFormat format;
	gchar* sparql;
	GCancellable* cancellable;
	GInputStream* result;
	GInputStream* _tmp0_;
	GDBusConnection* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GInputStream* _tmp4_;
	GInputStream* _tmp5_;
	GError* _inner_error0_;
};

static gint TrackerBusConnection_private_offset;
static gpointer tracker_bus_connection_parent_class = NULL;

static void tracker_bus_connection_construct_data_free (gpointer _data);
static gboolean tracker_bus_connection_construct_co (TrackerBusConnectionNewData* _data_);
static void tracker_bus_connection_new_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void tracker_bus_connection_init_namespaces (TrackerBusConnection* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void tracker_bus_connection_init_namespaces_finish (TrackerBusConnection* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void tracker_bus_connection_init_namespaces_data_free (gpointer _data);
static gboolean tracker_bus_connection_init_namespaces_co (TrackerBusConnectionInitNamespacesData* _data_);
static void tracker_bus_connection_init_namespaces_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void tracker_bus_connection_pipe (GUnixInputStream** input,
                                  GUnixOutputStream** output,
                                  GError** error);
static void tracker_bus_connection_handle_error_reply (GDBusMessage* message,
                                                GError** error);
static void tracker_bus_connection_send_query (GDBusConnection* bus,
                                        const gchar* dbus_name,
                                        const gchar* object_path,
                                        const gchar* sparql,
                                        GVariantBuilder* arguments,
                                        GUnixOutputStream* output,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback callback,
                                        gpointer callback_target,
                                        GError** error);
static void tracker_bus_connection_perform_query_call_data_free (gpointer _data);
static gboolean tracker_bus_connection_perform_query_call_co (TrackerBusConnectionPerformQueryCallData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void* _g_realloc_grealloc_func (void* data,
                                gsize size);
static void _g_free_gdestroy_notify (void* data);
static void tracker_bus_connection_perform_query_call_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static gchar** _variant_get1 (GVariant* value,
                       gint* result_length1);
VALA_EXTERN TrackerBusFDCursor* tracker_bus_fd_cursor_new (gchar* buffer,
                                               gulong buffer_size,
                                               gchar** variable_names,
                                               gint variable_names_length1);
VALA_EXTERN TrackerBusFDCursor* tracker_bus_fd_cursor_construct (GType object_type,
                                                     gchar* buffer,
                                                     gulong buffer_size,
                                                     gchar** variable_names,
                                                     gint variable_names_length1);
VALA_EXTERN GType tracker_bus_fd_cursor_get_type (void) G_GNUC_CONST ;
static TrackerSparqlCursor* tracker_bus_connection_real_query (TrackerSparqlConnection* base,
                                                        const gchar* sparql,
                                                        GCancellable* cancellable,
                                                        GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_real_query_async_data_free (gpointer _data);
static void tracker_bus_connection_real_query_async (TrackerSparqlConnection* base,
                                              const gchar* sparql,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean tracker_bus_connection_real_query_async_co (TrackerBusConnectionQueryAsyncData* _data_);
static void tracker_bus_connection_query_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static TrackerSparqlStatement* tracker_bus_connection_real_query_statement (TrackerSparqlConnection* base,
                                                                     const gchar* sparql,
                                                                     GCancellable* cancellable,
                                                                     GError** error);
static void tracker_bus_connection_send_update (GDBusConnection* bus,
                                         const gchar* dbus_name,
                                         const gchar* object_path,
                                         const gchar* method,
                                         GUnixInputStream* input,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback callback,
                                         gpointer callback_target,
                                         GError** error);
static void tracker_bus_connection_real_update (TrackerSparqlConnection* base,
                                         const gchar* sparql,
                                         GCancellable* cancellable,
                                         GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda8_ (Block3Data* _data3_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_real_update_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_async (TrackerSparqlConnection* base,
                                               const gchar* sparql,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_async_co (TrackerBusConnectionUpdateAsyncData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda7_ (Block4Data* _data4_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda7__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_perform_update_array_data_free (gpointer _data);
static gboolean tracker_bus_connection_perform_update_array_co (TrackerBusConnectionPerformUpdateArrayData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda9__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_real_update_array_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_array_async (TrackerSparqlConnection* base,
                                                     gchar** sparql,
                                                     gint sparql_length1,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_array_async_co (TrackerBusConnectionUpdateArrayAsyncData* _data_);
static void tracker_bus_connection_update_array_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static GVariant* tracker_bus_connection_real_update_blank (TrackerSparqlConnection* base,
                                                    const gchar* sparql,
                                                    GCancellable* cancellable,
                                                    GError** error);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda11_ (Block6Data* _data6_,
                  GObject* o,
                  GAsyncResult* res);
static void ___lambda11__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void tracker_bus_connection_real_update_blank_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_blank_async (TrackerSparqlConnection* base,
                                                     const gchar* sparql,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_blank_async_co (TrackerBusConnectionUpdateBlankAsyncData* _data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda10_ (Block7Data* _data7_,
                  GObject* o,
                  GAsyncResult* res);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean tracker_bus_connection_real_update_resource (TrackerSparqlConnection* base,
                                                      const gchar* graph,
                                                      TrackerResource* resource,
                                                      GCancellable* cancellable,
                                                      GError** error);
static void tracker_bus_connection_real_update_resource_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_resource_async (TrackerSparqlConnection* base,
                                                        const gchar* graph,
                                                        TrackerResource* resource,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_resource_async_co (TrackerBusConnectionUpdateResourceAsyncData* _data_);
static void tracker_bus_connection_update_resource_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static TrackerNotifier* tracker_bus_connection_real_create_notifier (TrackerSparqlConnection* base);
static void tracker_bus_connection_real_close (TrackerSparqlConnection* base);
static void tracker_bus_connection_real_close_async_data_free (gpointer _data);
static void tracker_bus_connection_real_close_async (TrackerSparqlConnection* base,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean tracker_bus_connection_real_close_async_co (TrackerBusConnectionCloseAsyncData* _data_);
static TrackerNamespaceManager* tracker_bus_connection_real_get_namespace_manager (TrackerSparqlConnection* base);
static TrackerBatch* tracker_bus_connection_real_create_batch (TrackerSparqlConnection* base);
static void tracker_bus_connection_perform_serialize_data_free (gpointer _data);
static gboolean tracker_bus_connection_perform_serialize_co (TrackerBusConnectionPerformSerializeData* _data_);
static void tracker_bus_connection_perform_serialize_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void tracker_bus_connection_real_serialize_async_data_free (gpointer _data);
static void tracker_bus_connection_real_serialize_async (TrackerSparqlConnection* base,
                                                  TrackerSerializeFlags flags,
                                                  TrackerRdfFormat format,
                                                  const gchar* sparql,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static gboolean tracker_bus_connection_real_serialize_async_co (TrackerBusConnectionSerializeAsyncData* _data_);
static void tracker_bus_connection_serialize_async_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void tracker_bus_connection_finalize (GObject * obj);
static GType tracker_bus_connection_get_type_once (void);
static void _vala_tracker_bus_connection_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
tracker_bus_connection_get_instance_private (TrackerBusConnection* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerBusConnection_private_offset);
}

static void
tracker_bus_connection_construct_data_free (gpointer _data)
{
	TrackerBusConnectionNewData* _data_;
	_data_ = _data;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->dbus_name);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->object_path);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->dbus_connection);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionNewData, _data_);
#line 752 "tracker-bus.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return self ? g_object_ref (self) : NULL;
#line 760 "tracker-bus.c"
}

void
tracker_bus_connection_construct (GType object_type,
                                  const gchar* dbus_name,
                                  const gchar* object_path,
                                  GDBusConnection* dbus_connection,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	TrackerBusConnectionNewData* _data_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GDBusConnection* _tmp2_;
	GCancellable* _tmp3_;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (dbus_name != NULL);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (object_path != NULL);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionNewData);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_construct_data_free);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->object_type = object_type;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = g_strdup (dbus_name);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->dbus_name);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->dbus_name = _tmp0_;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_strdup (object_path);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->object_path);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->object_path = _tmp1_;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (dbus_connection);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->dbus_connection);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->dbus_connection = _tmp2_;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->cancellable = _tmp3_;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_construct_co (_data_);
#line 815 "tracker-bus.c"
}

TrackerBusConnection*
tracker_bus_connection_construct_finish (GAsyncResult* _res_,
                                         GError** error)
{
	TrackerBusConnection* result;
	TrackerBusConnectionNewData* _data_;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return NULL;
#line 830 "tracker-bus.c"
	}
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _data_->self;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self = NULL;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 838 "tracker-bus.c"
}

static void
tracker_bus_connection_new_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	TrackerBusConnectionNewData* _data_;
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = _user_data_;
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_res_ = _res_;
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_construct_co (_data_);
#line 855 "tracker-bus.c"
}

static gpointer
_g_error_copy0 (gpointer self)
{
#line 66 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return self ? g_error_copy (self) : NULL;
#line 863 "tracker-bus.c"
}

static gpointer
_g_variant_ref0 (gpointer self)
{
#line 82 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return self ? g_variant_ref (self) : NULL;
#line 871 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_construct_co (TrackerBusConnectionNewData* _data_)
{
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 881 "tracker-bus.c"
		goto _state_0;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 1:
#line 885 "tracker-bus.c"
		goto _state_1;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 2:
#line 889 "tracker-bus.c"
		goto _state_2;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 3:
#line 893 "tracker-bus.c"
		goto _state_3;
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 4:
#line 897 "tracker-bus.c"
		goto _state_4;
		default:
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 902 "tracker-bus.c"
	}
	_state_0:
#line 46 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self = (TrackerBusConnection*) g_object_new (_data_->object_type, NULL);
#line 47 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self->priv->sandboxed = FALSE;
#line 48 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = _g_object_ref0 (_data_->dbus_connection);
#line 48 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self->priv->bus);
#line 48 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self->priv->bus = _data_->_tmp0_;
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp1_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, "");
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 51 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_error_free0 (_data_->_tmp2_);
#line 54 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp3_ = g_getenv ("TRACKER_TEST_PORTAL_FLATPAK_INFO");
#line 54 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_tmp3_ == NULL) {
#line 55 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_tmp4_ = g_dbus_message_new_method_call (_data_->dbus_name, _data_->object_path, TRACKER_BUS_CONNECTION_DBUS_PEER_IFACE, "Ping");
#line 55 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->message = _data_->_tmp4_;
#line 929 "tracker-bus.c"
		{
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->_tmp5_ = _data_->self->priv->bus;
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->_tmp6_ = _data_->message;
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->_state_ = 1;
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_dbus_connection_send_message_with_reply (_data_->_tmp5_, _data_->_tmp6_, 0, TRACKER_BUS_CONNECTION_timeout, _data_->cancellable, NULL, tracker_bus_connection_new_ready, _data_);
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			return FALSE;
#line 941 "tracker-bus.c"
			_state_1:
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->_tmp7_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->reply = _data_->_tmp7_;
#line 58 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 949 "tracker-bus.c"
				goto __catch0_g_error;
			}
#line 59 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->_tmp8_ = _data_->reply;
#line 59 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_dbus_message_to_gerror (_data_->_tmp8_, &_data_->_inner_error0_);
#line 59 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 59 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_g_object_unref0 (_data_->reply);
#line 960 "tracker-bus.c"
				goto __catch0_g_error;
			}
#line 60 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->_tmp9_ = g_strdup (_data_->dbus_name);
#line 60 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_free0 (_data_->self->priv->dbus_name);
#line 60 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->self->priv->dbus_name = _data_->_tmp9_;
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->_tmp10_ = g_strdup (_data_->object_path);
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_free0 (_data_->self->priv->object_path);
#line 61 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->self->priv->object_path = _data_->_tmp10_;
#line 62 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->_state_ = 2;
#line 62 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			tracker_bus_connection_init_namespaces (_data_->self, tracker_bus_connection_new_ready, _data_);
#line 62 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			return FALSE;
#line 981 "tracker-bus.c"
			_state_2:
#line 62 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			tracker_bus_connection_init_namespaces_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
#line 62 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 62 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_g_object_unref0 (_data_->reply);
#line 989 "tracker-bus.c"
				goto __catch0_g_error;
			}
#line 63 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_object_unref0 (_data_->reply);
#line 63 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 63 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 63 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (_data_->_state_ != 0) {
#line 63 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 63 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1004 "tracker-bus.c"
				}
			}
#line 63 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 63 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			return FALSE;
#line 1011 "tracker-bus.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->e = _data_->_inner_error0_;
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->_inner_error0_ = NULL;
#line 65 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (!g_file_test ("/.flatpak-info", G_FILE_TEST_EXISTS)) {
#line 66 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_data_->_tmp11_ = _data_->e;
#line 66 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
#line 66 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_data_->_inner_error0_ = _data_->_tmp12_;
#line 66 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_g_error_free0 (_data_->e);
#line 1030 "tracker-bus.c"
				goto __finally0;
			}
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_error_free0 (_data_->e);
#line 1035 "tracker-bus.c"
		}
		__finally0:
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 57 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			return FALSE;
#line 1048 "tracker-bus.c"
		}
#line 54 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->message);
#line 1052 "tracker-bus.c"
	}
#line 72 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (g_strcmp0 (_data_->object_path, "/org/freedesktop/Tracker3/Endpoint") == 0) {
#line 1056 "tracker-bus.c"
		gchar* _tmp13_;
#line 73 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp13_ = g_strdup (NULL);
#line 73 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_free0 (_data_->object_path);
#line 73 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->object_path = _tmp13_;
#line 1064 "tracker-bus.c"
	}
#line 75 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp14_ = tracker_util_build_dbus_uri (G_BUS_TYPE_SESSION, _data_->dbus_name, _data_->object_path);
#line 75 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->uri = _data_->_tmp14_;
#line 76 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp15_ = g_dbus_message_new_method_call (TRACKER_BUS_CONNECTION_PORTAL_NAME, TRACKER_BUS_CONNECTION_PORTAL_PATH, TRACKER_BUS_CONNECTION_PORTAL_IFACE, "CreateSession");
#line 76 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_vala1_message = _data_->_tmp15_;
#line 77 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp16_ = _data_->_vala1_message;
#line 77 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp17_ = _data_->uri;
#line 77 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp18_ = g_variant_new ("(s)", _data_->_tmp17_, NULL);
#line 77 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_variant_ref_sink (_data_->_tmp18_);
#line 77 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp19_ = _data_->_tmp18_;
#line 77 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_message_set_body (_data_->_tmp16_, _data_->_tmp19_);
#line 77 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_unref0 (_data_->_tmp19_);
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp20_ = _data_->self->priv->bus;
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp21_ = _data_->_vala1_message;
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_state_ = 3;
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (_data_->_tmp20_, _data_->_tmp21_, 0, TRACKER_BUS_CONNECTION_timeout, _data_->cancellable, NULL, tracker_bus_connection_new_ready, _data_);
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 1098 "tracker-bus.c"
	_state_3:
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp22_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error0_);
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_vala1_reply = _data_->_tmp22_;
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->_vala1_message);
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_free0 (_data_->uri);
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 79 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 1116 "tracker-bus.c"
	}
#line 80 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp23_ = _data_->_vala1_reply;
#line 80 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_message_to_gerror (_data_->_tmp23_, &_data_->_inner_error0_);
#line 80 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 80 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 80 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->_vala1_reply);
#line 80 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->_vala1_message);
#line 80 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_free0 (_data_->uri);
#line 80 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 80 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 1136 "tracker-bus.c"
	}
#line 82 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp24_ = _data_->_vala1_reply;
#line 82 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp25_ = g_dbus_message_get_body (_data_->_tmp24_);
#line 82 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp26_ = _g_variant_ref0 (_data_->_tmp25_);
#line 82 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->variant = _data_->_tmp26_;
#line 83 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp27_ = _data_->variant;
#line 83 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp28_ = NULL;
#line 83 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_variant_get_child (_data_->_tmp27_, (gsize) 0, "o", &_data_->_tmp28_, NULL);
#line 83 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->object_path = _data_->_tmp28_;
#line 85 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp29_ = g_strdup (TRACKER_BUS_CONNECTION_PORTAL_NAME);
#line 85 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->self->priv->dbus_name);
#line 85 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self->priv->dbus_name = _data_->_tmp29_;
#line 86 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp30_ = g_strdup (_data_->object_path);
#line 86 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->self->priv->object_path);
#line 86 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self->priv->object_path = _data_->_tmp30_;
#line 87 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self->priv->sandboxed = TRUE;
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_state_ = 4;
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_init_namespaces (_data_->self, tracker_bus_connection_new_ready, _data_);
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 1174 "tracker-bus.c"
	_state_4:
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_init_namespaces_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_variant_unref0 (_data_->variant);
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->_vala1_reply);
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->_vala1_message);
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_free0 (_data_->uri);
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 89 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 1194 "tracker-bus.c"
	}
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_unref0 (_data_->variant);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->_vala1_reply);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->_vala1_message);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->uri);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1212 "tracker-bus.c"
		}
	}
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 1219 "tracker-bus.c"
}

void
tracker_bus_connection_new (const gchar* dbus_name,
                            const gchar* object_path,
                            GDBusConnection* dbus_connection,
                            GCancellable* cancellable,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_construct (TRACKER_BUS_TYPE_CONNECTION, dbus_name, object_path, dbus_connection, cancellable, _callback_, _user_data_);
#line 1232 "tracker-bus.c"
}

TrackerBusConnection*
tracker_bus_connection_new_finish (GAsyncResult* _res_,
                                   GError** error)
{
#line 45 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return tracker_bus_connection_construct_finish (_res_, error);
#line 1241 "tracker-bus.c"
}

static void
tracker_bus_connection_init_namespaces_data_free (gpointer _data)
{
	TrackerBusConnectionInitNamespacesData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionInitNamespacesData, _data_);
#line 1253 "tracker-bus.c"
}

static void
tracker_bus_connection_init_namespaces (TrackerBusConnection* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	TrackerBusConnectionInitNamespacesData* _data_;
	TrackerBusConnection* _tmp0_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (self != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionInitNamespacesData);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_init_namespaces_data_free);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_init_namespaces_co (_data_);
#line 1277 "tracker-bus.c"
}

static void
tracker_bus_connection_init_namespaces_finish (TrackerBusConnection* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	TrackerBusConnectionInitNamespacesData* _data_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return;
#line 1292 "tracker-bus.c"
	}
}

static void
tracker_bus_connection_init_namespaces_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	TrackerBusConnectionInitNamespacesData* _data_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = _user_data_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_res_ = _res_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_init_namespaces_co (_data_);
#line 1310 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_init_namespaces_co (TrackerBusConnectionInitNamespacesData* _data_)
{
#line 92 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 92 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 1320 "tracker-bus.c"
		goto _state_0;
#line 92 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 1:
#line 1324 "tracker-bus.c"
		goto _state_1;
		default:
#line 92 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 1329 "tracker-bus.c"
	}
	_state_0:
#line 93 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = tracker_namespace_manager_new ();
#line 93 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self->priv->namespaces);
#line 93 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self->priv->namespaces = _data_->_tmp0_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_state_ = 1;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_sparql_connection_query_async ((TrackerSparqlConnection*) _data_->self, "SELECT ?prefix ?name { ?name nrl:prefix ?prefix }", NULL, tracker_bus_connection_init_namespaces_ready, _data_);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 1344 "tracker-bus.c"
	_state_1:
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp1_ = tracker_sparql_connection_query_finish ((TrackerSparqlConnection*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->cursor = _data_->_tmp1_;
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 94 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 1358 "tracker-bus.c"
	}
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	while (TRUE) {
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_tmp3_ = _data_->cursor;
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_tmp2_ = tracker_sparql_cursor_next (_data_->_tmp3_, NULL, &_data_->_inner_error0_);
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_object_unref0 (_data_->cursor);
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			return FALSE;
#line 1376 "tracker-bus.c"
		}
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		if (!_data_->_tmp2_) {
#line 95 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			break;
#line 1382 "tracker-bus.c"
		}
#line 96 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_tmp4_ = _data_->self->priv->namespaces;
#line 96 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_tmp5_ = _data_->cursor;
#line 96 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_tmp6_ = tracker_sparql_cursor_get_string (_data_->_tmp5_, 0, NULL);
#line 96 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_tmp7_ = _data_->cursor;
#line 96 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_tmp8_ = tracker_sparql_cursor_get_string (_data_->_tmp7_, 1, NULL);
#line 96 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		tracker_namespace_manager_add_prefix (_data_->_tmp4_, _data_->_tmp6_, _data_->_tmp8_);
#line 1396 "tracker-bus.c"
	}
#line 97 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp9_ = _data_->cursor;
#line 97 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_sparql_cursor_close (_data_->_tmp9_);
#line 92 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cursor);
#line 92 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 92 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 92 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 92 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1412 "tracker-bus.c"
		}
	}
#line 92 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 92 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 1419 "tracker-bus.c"
}

static void
tracker_bus_connection_pipe (GUnixInputStream** input,
                             GUnixOutputStream** output,
                             GError** error)
{
	GUnixInputStream* _vala_input = NULL;
	GUnixOutputStream* _vala_output = NULL;
	gint pipefd[2] = {0};
	gint _tmp1_;
	GUnixInputStream* _tmp2_;
	gint _tmp3_;
	GUnixOutputStream* _tmp4_;
	GError* _inner_error0_ = NULL;
#line 102 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (pipe (pipefd) < 0) {
#line 1437 "tracker-bus.c"
		GError* _tmp0_;
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Pipe creation failed");
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_inner_error0_ = _tmp0_;
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		if (_inner_error0_->domain == G_IO_ERROR) {
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_propagate_error (error, _inner_error0_);
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_object_unref0 (_vala_input);
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_object_unref0 (_vala_output);
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			return;
#line 1453 "tracker-bus.c"
		} else {
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_object_unref0 (_vala_input);
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_object_unref0 (_vala_output);
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_clear_error (&_inner_error0_);
#line 103 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			return;
#line 1465 "tracker-bus.c"
		}
	}
#line 105 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = pipefd[0];
#line 105 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp1_, TRUE);
#line 105 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_vala_input);
#line 105 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_vala_input = _tmp2_;
#line 106 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = pipefd[1];
#line 106 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp4_ = (GUnixOutputStream*) g_unix_output_stream_new (_tmp3_, TRUE);
#line 106 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_vala_output);
#line 106 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_vala_output = _tmp4_;
#line 100 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (input) {
#line 100 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		*input = _vala_input;
#line 1488 "tracker-bus.c"
	} else {
#line 100 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_vala_input);
#line 1492 "tracker-bus.c"
	}
#line 100 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (output) {
#line 100 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		*output = _vala_output;
#line 1498 "tracker-bus.c"
	} else {
#line 100 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_vala_output);
#line 1502 "tracker-bus.c"
	}
}

static void
tracker_bus_connection_handle_error_reply (GDBusMessage* message,
                                           GError** error)
{
	GError* _inner_error0_ = NULL;
#line 109 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (message != NULL);
#line 1513 "tracker-bus.c"
	{
#line 111 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_dbus_message_to_gerror (message, &_inner_error0_);
#line 111 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 111 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 1521 "tracker-bus.c"
				goto __catch0_g_io_error;
			}
#line 111 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (_inner_error0_->domain == G_DBUS_ERROR) {
#line 1526 "tracker-bus.c"
				goto __catch0_g_dbus_error;
			}
#line 111 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 1531 "tracker-bus.c"
				goto __catch0_tracker_sparql_error;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e_io = NULL;
		GError* _tmp0_;
		GError* _tmp1_;
		GError* _tmp2_;
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		e_io = _inner_error0_;
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_inner_error0_ = NULL;
#line 113 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp0_ = e_io;
#line 113 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_dbus_error_strip_remote_error (_tmp0_);
#line 114 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp1_ = e_io;
#line 114 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp2_ = _g_error_copy0 (_tmp1_);
#line 114 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_inner_error0_ = _tmp2_;
#line 114 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_error_free0 (e_io);
#line 1560 "tracker-bus.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e_dbus = NULL;
		GError* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		e_dbus = _inner_error0_;
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_inner_error0_ = NULL;
#line 116 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp3_ = e_dbus;
#line 116 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_dbus_error_strip_remote_error (_tmp3_);
#line 117 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp4_ = e_dbus;
#line 117 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 117 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_inner_error0_ = _tmp5_;
#line 117 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_error_free0 (e_dbus);
#line 1586 "tracker-bus.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_tracker_sparql_error:
	{
		GError* e_sparql = NULL;
		GError* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		e_sparql = _inner_error0_;
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_inner_error0_ = NULL;
#line 119 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp6_ = e_sparql;
#line 119 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_dbus_error_strip_remote_error (_tmp6_);
#line 120 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp7_ = e_sparql;
#line 120 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp8_ = _g_error_copy0 (_tmp7_);
#line 120 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_inner_error0_ = _tmp8_;
#line 120 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_error_free0 (e_sparql);
#line 1612 "tracker-bus.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		GError* _tmp12_;
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		e = _inner_error0_;
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_inner_error0_ = NULL;
#line 122 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp9_ = e;
#line 122 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_dbus_error_strip_remote_error (_tmp9_);
#line 123 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp10_ = e;
#line 123 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp11_ = _tmp10_->message;
#line 123 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp12_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp11_);
#line 123 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_inner_error0_ = _tmp12_;
#line 123 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_error_free0 (e);
#line 1641 "tracker-bus.c"
		goto __finally0;
	}
	__finally0:
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		if (((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) {
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_propagate_error (error, _inner_error0_);
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			return;
#line 1653 "tracker-bus.c"
		} else {
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_clear_error (&_inner_error0_);
#line 110 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			return;
#line 1661 "tracker-bus.c"
		}
	}
}

static void
tracker_bus_connection_send_query (GDBusConnection* bus,
                                   const gchar* dbus_name,
                                   const gchar* object_path,
                                   const gchar* sparql,
                                   GVariantBuilder* arguments,
                                   GUnixOutputStream* output,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback callback,
                                   gpointer callback_target,
                                   GError** error)
{
	GDBusMessage* message = NULL;
	GDBusMessage* _tmp0_;
	GUnixFDList* fd_list = NULL;
	GUnixFDList* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	gint _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GError* _inner_error0_ = NULL;
#line 127 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (bus != NULL);
#line 127 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (dbus_name != NULL);
#line 127 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (object_path != NULL);
#line 127 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 127 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (output != NULL);
#line 128 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = g_dbus_message_new_method_call (dbus_name, object_path, TRACKER_BUS_CONNECTION_ENDPOINT_IFACE, "Query");
#line 128 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	message = _tmp0_;
#line 129 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_unix_fd_list_new ();
#line 129 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	fd_list = _tmp1_;
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = g_unix_output_stream_get_fd (output);
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp4_ = _tmp3_;
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = g_unix_fd_list_append (fd_list, _tmp4_, &_inner_error0_);
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_propagate_error (error, _inner_error0_);
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (fd_list);
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (message);
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return;
#line 1722 "tracker-bus.c"
	}
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp5_ = g_variant_new ("(sha{sv})", sparql, _tmp2_, arguments, NULL);
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_variant_ref_sink (_tmp5_);
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp6_ = _tmp5_;
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_message_set_body (message, _tmp6_);
#line 130 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_unref0 (_tmp6_);
#line 131 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_message_set_unix_fd_list (message, fd_list);
#line 133 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (bus, message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, cancellable, callback, callback_target);
#line 127 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (fd_list);
#line 127 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (message);
#line 1742 "tracker-bus.c"
}

static void
tracker_bus_connection_perform_query_call_data_free (gpointer _data)
{
	TrackerBusConnectionPerformQueryCallData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->bus);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->dbus_name);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->object_path);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_builder_unref0 (_data_->arguments);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->result);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionPerformQueryCallData, _data_);
#line 1766 "tracker-bus.c"
}

static gpointer
_g_variant_builder_ref0 (gpointer self)
{
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return self ? g_variant_builder_ref (self) : NULL;
#line 1774 "tracker-bus.c"
}

void
tracker_bus_connection_perform_query_call (GDBusConnection* bus,
                                           const gchar* dbus_name,
                                           const gchar* object_path,
                                           const gchar* sparql,
                                           GVariantBuilder* arguments,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	TrackerBusConnectionPerformQueryCallData* _data_;
	GDBusConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GVariantBuilder* _tmp4_;
	GCancellable* _tmp5_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (bus != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (dbus_name != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (object_path != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionPerformQueryCallData);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_perform_query_call_data_free);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (bus);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->bus);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->bus = _tmp0_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_strdup (dbus_name);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->dbus_name);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->dbus_name = _tmp1_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = g_strdup (object_path);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->object_path);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->object_path = _tmp2_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = g_strdup (sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->sparql = _tmp3_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp4_ = _g_variant_builder_ref0 (arguments);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_builder_unref0 (_data_->arguments);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->arguments = _tmp4_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp5_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->cancellable = _tmp5_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_perform_query_call_co (_data_);
#line 1846 "tracker-bus.c"
}

TrackerSparqlCursor*
tracker_bus_connection_perform_query_call_finish (GAsyncResult* _res_,
                                                  GError** error)
{
	TrackerSparqlCursor* result;
	TrackerBusConnectionPerformQueryCallData* _data_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return NULL;
#line 1861 "tracker-bus.c"
	}
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = NULL;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 1869 "tracker-bus.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return _data1_;
#line 1879 "tracker-bus.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data1_->dbus_res);
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_slice_free (Block1Data, _data1_);
#line 1893 "tracker-bus.c"
	}
}

static void
__lambda4_ (Block1Data* _data1_,
            GObject* o,
            GAsyncResult* res)
{
	GAsyncResult* _tmp0_;
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 145 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 145 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data1_->dbus_res);
#line 145 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data1_->dbus_res = _tmp0_;
#line 146 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data1_->received_result) {
#line 147 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		tracker_bus_connection_perform_query_call_co (_data1_->_async_data_);
#line 1915 "tracker-bus.c"
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	__lambda4_ (self, source_object, res);
#line 1926 "tracker-bus.c"
}

static void*
_g_realloc_grealloc_func (void* data,
                          gsize size)
{
	void* result;
	result = g_realloc (data, size);
#line 154 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 1937 "tracker-bus.c"
}

static void
_g_free_gdestroy_notify (void* data)
{
#line 154 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_free (data);
#line 1945 "tracker-bus.c"
}

static void
tracker_bus_connection_perform_query_call_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	TrackerBusConnectionPerformQueryCallData* _data_;
#line 157 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = _user_data_;
#line 157 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 157 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_res_ = _res_;
#line 157 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_perform_query_call_co (_data_);
#line 1962 "tracker-bus.c"
}

static gchar**
_variant_get1 (GVariant* value,
               gint* result_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length;
	gint _tmp0__size;
	gint _tmp0__length1;
	GVariantIter _tmp1_;
	GVariant* _tmp2_;
	_tmp0_ = g_new (gchar*, 5);
	_tmp0__length = 0;
	_tmp0__size = 4;
	_tmp0__length1 = 0;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_variant_iter_init (&_tmp1_, value);
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	for (; (_tmp2_ = g_variant_iter_next_value (&_tmp1_)) != NULL; _tmp0__length1++) {
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		if (_tmp0__size == _tmp0__length) {
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_tmp0__size = 2 * _tmp0__size;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_tmp0_ = g_renew (gchar*, _tmp0_, _tmp0__size + 1);
#line 1989 "tracker-bus.c"
		}
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp0_[_tmp0__length++] = g_variant_dup_string (_tmp2_, NULL);
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_variant_unref (_tmp2_);
#line 1995 "tracker-bus.c"
	}
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	*result_length1 = _tmp0__length1;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_[_tmp0__length] = NULL;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return _tmp0_;
#line 2003 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_perform_query_call_co (TrackerBusConnectionPerformQueryCallData* _data_)
{
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 2013 "tracker-bus.c"
		goto _state_0;
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 1:
#line 2017 "tracker-bus.c"
		goto _state_1;
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 2:
#line 2021 "tracker-bus.c"
		goto _state_2;
		default:
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 2026 "tracker-bus.c"
	}
	_state_0:
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 136 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_pipe (&_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error0_);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block1_data_unref (_data_->_data1_);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data1_ = NULL;
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 139 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 2065 "tracker-bus.c"
	}
#line 142 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data1_->dbus_res = NULL;
#line 143 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data1_->received_result = FALSE;
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->output;
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_send_query (_data_->bus, _data_->dbus_name, _data_->object_path, _data_->sparql, _data_->arguments, _data_->_tmp2_, _data_->cancellable, ___lambda4__gasync_ready_callback, _data_->_data1_, &_data_->_inner_error0_);
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block1_data_unref (_data_->_data1_);
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data1_ = NULL;
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 144 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 2091 "tracker-bus.c"
	}
#line 151 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 151 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->output = NULL;
#line 154 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp3_ = (GMemoryOutputStream*) g_memory_output_stream_new (NULL, 0, _g_realloc_grealloc_func, _g_free_gdestroy_notify);
#line 154 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->mem_stream = _data_->_tmp3_;
#line 2101 "tracker-bus.c"
	{
#line 157 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_tmp4_ = _data_->mem_stream;
#line 157 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_tmp5_ = _data_->input;
#line 157 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_state_ = 1;
#line 157 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_output_stream_splice_async ((GOutputStream*) _data_->_tmp4_, (GInputStream*) _data_->_tmp5_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, _data_->cancellable, tracker_bus_connection_perform_query_call_ready, _data_);
#line 157 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 2113 "tracker-bus.c"
		_state_1:
#line 157 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_output_stream_splice_finish ((GOutputStream*) _data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
#line 157 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 2119 "tracker-bus.c"
			goto __finally0;
		}
	}
	__finally0:
	{
#line 160 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data1_->received_result = TRUE;
#line 161 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_tmp6_ = _data_->_data1_->dbus_res;
#line 161 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		if (_data_->_tmp6_ == NULL) {
#line 162 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->_state_ = 2;
#line 162 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			return FALSE;
#line 2135 "tracker-bus.c"
			_state_2:
			;
		}
	}
#line 156 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 156 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 156 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 156 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 156 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 156 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block1_data_unref (_data_->_data1_);
#line 156 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data1_ = NULL;
#line 156 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 156 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 2158 "tracker-bus.c"
	}
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp7_ = _data_->_data1_->dbus_res;
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp8_ = g_dbus_connection_send_message_with_reply_finish (_data_->bus, _data_->_tmp7_, &_data_->_inner_error0_);
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->reply = _data_->_tmp8_;
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block1_data_unref (_data_->_data1_);
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data1_ = NULL;
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 166 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 2184 "tracker-bus.c"
	}
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp9_ = _data_->reply;
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->_tmp9_, &_data_->_inner_error0_);
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block1_data_unref (_data_->_data1_);
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data1_ = NULL;
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 167 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 2210 "tracker-bus.c"
	}
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp10_ = _data_->reply;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp11_ = g_dbus_message_get_body (_data_->_tmp10_);
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp12_ = g_variant_get_child_value (_data_->_tmp11_, (gsize) 0);
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp13_ = _data_->_tmp12_;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp14_ = NULL;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp14__length1 = 0;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp14_ = _variant_get1 (_data_->_tmp13_, &_data_->_tmp14__length1);
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp15_ = _data_->_tmp14_;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp15__length1 = _data_->_tmp14__length1;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_unref0 (_data_->_tmp13_);
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->variable_names = _data_->_tmp15_;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->variable_names_length1 = _data_->_tmp15__length1;
#line 169 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_variable_names_size_ = _data_->variable_names_length1;
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp16_ = _data_->mem_stream;
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_output_stream_close ((GOutputStream*) _data_->_tmp16_, NULL, &_data_->_inner_error0_);
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->variable_names = (_vala_array_free (_data_->variable_names, _data_->variable_names_length1, (GDestroyNotify) g_free), NULL);
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block1_data_unref (_data_->_data1_);
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data1_ = NULL;
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 170 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 2264 "tracker-bus.c"
	}
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp17_ = _data_->mem_stream;
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp18_ = g_memory_output_stream_steal_data (_data_->_tmp17_);
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp19_ = _data_->mem_stream;
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp20_ = g_memory_output_stream_get_data_size (_data_->_tmp19_);
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp21_ = _data_->_tmp20_;
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp22_ = _data_->variable_names;
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp22__length1 = _data_->variable_names_length1;
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp23_ = tracker_bus_fd_cursor_new (_data_->_tmp18_, _data_->_tmp21_, _data_->_tmp22_, _data_->_tmp22__length1);
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = (TrackerSparqlCursor*) _data_->_tmp23_;
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->variable_names = (_vala_array_free (_data_->variable_names, _data_->variable_names_length1, (GDestroyNotify) g_free), NULL);
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->mem_stream);
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	block1_data_unref (_data_->_data1_);
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data1_ = NULL;
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2306 "tracker-bus.c"
		}
	}
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 171 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 2313 "tracker-bus.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return _data2_;
#line 2323 "tracker-bus.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2333 "tracker-bus.c"
		TrackerBusConnection* self;
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		self = _data2_->self;
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data2_->async_res);
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_main_loop_unref0 (_data2_->loop);
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_slice_free (Block2Data, _data2_);
#line 2345 "tracker-bus.c"
	}
}

static void
__lambda5_ (Block2Data* _data2_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 180 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = _data2_->self;
#line 180 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 181 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 181 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data2_->async_res);
#line 181 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data2_->async_res = _tmp0_;
#line 182 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_loop_quit (_data2_->loop);
#line 2368 "tracker-bus.c"
}

static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 180 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	__lambda5_ (self, source_object, res);
#line 180 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	block2_data_unref (self);
#line 2380 "tracker-bus.c"
}

static TrackerSparqlCursor*
tracker_bus_connection_real_query (TrackerSparqlConnection* base,
                                   const gchar* sparql,
                                   GCancellable* cancellable,
                                   GError** error)
{
	TrackerBusConnection * self;
	Block2Data* _data2_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	TrackerSparqlCursor* _tmp2_ = NULL;
	TrackerSparqlCursor* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlCursor* result;
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data2_->_ref_count_ = 1;
#line 174 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data2_->self = g_object_ref (self);
#line 176 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = g_main_context_new ();
#line 176 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	context = _tmp0_;
#line 177 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_main_loop_new (context, FALSE);
#line 177 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data2_->loop = _tmp1_;
#line 178 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_context_push_thread_default (context);
#line 179 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data2_->async_res = NULL;
#line 180 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_sparql_connection_query_async ((TrackerSparqlConnection*) self, sparql, cancellable, ___lambda5__gasync_ready_callback, block2_data_ref (_data2_));
#line 184 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_loop_run (_data2_->loop);
#line 185 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_context_pop_thread_default (context);
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = tracker_sparql_connection_query_finish ((TrackerSparqlConnection*) self, _data2_->async_res, &_inner_error0_);
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = _tmp3_;
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_propagate_error (error, _inner_error0_);
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_main_context_unref0 (context);
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block2_data_unref (_data2_);
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data2_ = NULL;
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return NULL;
#line 2443 "tracker-bus.c"
	}
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp4_ = _tmp2_;
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = NULL;
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _tmp4_;
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_tmp2_);
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_main_context_unref0 (context);
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	block2_data_unref (_data2_);
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data2_ = NULL;
#line 186 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 2461 "tracker-bus.c"
}

static void
tracker_bus_connection_real_query_async_data_free (gpointer _data)
{
	TrackerBusConnectionQueryAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->result);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionQueryAsyncData, _data_);
#line 2479 "tracker-bus.c"
}

static void
tracker_bus_connection_real_query_async (TrackerSparqlConnection* base,
                                         const gchar* sparql,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionQueryAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionQueryAsyncData);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_query_async_data_free);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_strdup (sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->sparql = _tmp1_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_real_query_async_co (_data_);
#line 2522 "tracker-bus.c"
}

static TrackerSparqlCursor*
tracker_bus_connection_query_finish (TrackerSparqlConnection* base,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	TrackerSparqlCursor* result;
	TrackerBusConnectionQueryAsyncData* _data_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return NULL;
#line 2538 "tracker-bus.c"
	}
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = NULL;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 2546 "tracker-bus.c"
}

static void
tracker_bus_connection_query_async_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	TrackerBusConnectionQueryAsyncData* _data_;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = _user_data_;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_res_ = _res_;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_real_query_async_co (_data_);
#line 2563 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_query_async_co (TrackerBusConnectionQueryAsyncData* _data_)
{
#line 189 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 189 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 2573 "tracker-bus.c"
		goto _state_0;
#line 189 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 1:
#line 2577 "tracker-bus.c"
		goto _state_1;
		default:
#line 189 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 2582 "tracker-bus.c"
	}
	_state_0:
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp1_ = _data_->self->priv->bus;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->self->priv->dbus_name;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp3_ = _data_->self->priv->object_path;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_state_ = 1;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_perform_query_call (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->sparql, NULL, _data_->cancellable, tracker_bus_connection_query_async_ready, _data_);
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 2597 "tracker-bus.c"
	_state_1:
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp4_ = tracker_bus_connection_perform_query_call_finish (_data_->_res_, &_data_->_inner_error0_);
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = _data_->_tmp4_;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 2611 "tracker-bus.c"
	}
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp5_ = _data_->_tmp0_;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = _data_->_tmp5_;
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2629 "tracker-bus.c"
		}
	}
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 190 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 2636 "tracker-bus.c"
}

static TrackerSparqlStatement*
tracker_bus_connection_real_query_statement (TrackerSparqlConnection* base,
                                             const gchar* sparql,
                                             GCancellable* cancellable,
                                             GError** error)
{
	TrackerBusConnection * self;
	GDBusConnection* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	TrackerBusStatement* _tmp3_;
	TrackerSparqlStatement* result;
#line 193 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 193 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 194 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = self->priv->bus;
#line 194 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = self->priv->dbus_name;
#line 194 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = self->priv->object_path;
#line 194 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = tracker_bus_statement_new (_tmp0_, _tmp1_, _tmp2_, sparql);
#line 194 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = (TrackerSparqlStatement*) _tmp3_;
#line 194 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 2667 "tracker-bus.c"
}

static void
tracker_bus_connection_send_update (GDBusConnection* bus,
                                    const gchar* dbus_name,
                                    const gchar* object_path,
                                    const gchar* method,
                                    GUnixInputStream* input,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback callback,
                                    gpointer callback_target,
                                    GError** error)
{
	GDBusMessage* message = NULL;
	GDBusMessage* _tmp0_;
	GUnixFDList* fd_list = NULL;
	GUnixFDList* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	gint _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GError* _inner_error0_ = NULL;
#line 197 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (bus != NULL);
#line 197 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (dbus_name != NULL);
#line 197 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (object_path != NULL);
#line 197 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (method != NULL);
#line 197 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (input != NULL);
#line 198 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = g_dbus_message_new_method_call (dbus_name, object_path, TRACKER_BUS_CONNECTION_ENDPOINT_IFACE, method);
#line 198 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	message = _tmp0_;
#line 199 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_unix_fd_list_new ();
#line 199 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	fd_list = _tmp1_;
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = g_unix_input_stream_get_fd (input);
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp4_ = _tmp3_;
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = g_unix_fd_list_append (fd_list, _tmp4_, &_inner_error0_);
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_propagate_error (error, _inner_error0_);
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (fd_list);
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (message);
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return;
#line 2725 "tracker-bus.c"
	}
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp5_ = g_variant_new ("(h)", _tmp2_, NULL);
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_variant_ref_sink (_tmp5_);
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp6_ = _tmp5_;
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_message_set_body (message, _tmp6_);
#line 200 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_unref0 (_tmp6_);
#line 201 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_message_set_unix_fd_list (message, fd_list);
#line 203 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (bus, message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, cancellable, callback, callback_target);
#line 197 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (fd_list);
#line 197 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (message);
#line 2745 "tracker-bus.c"
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return _data3_;
#line 2755 "tracker-bus.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2765 "tracker-bus.c"
		TrackerBusConnection* self;
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		self = _data3_->self;
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data3_->async_res);
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_main_loop_unref0 (_data3_->loop);
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_slice_free (Block3Data, _data3_);
#line 2777 "tracker-bus.c"
	}
}

static void
__lambda8_ (Block3Data* _data3_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 212 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = _data3_->self;
#line 212 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 213 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 213 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data3_->async_res);
#line 213 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data3_->async_res = _tmp0_;
#line 214 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_loop_quit (_data3_->loop);
#line 2800 "tracker-bus.c"
}

static void
___lambda8__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 212 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	__lambda8_ (self, source_object, res);
#line 212 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	block3_data_unref (self);
#line 2812 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update (TrackerSparqlConnection* base,
                                    const gchar* sparql,
                                    GCancellable* cancellable,
                                    GError** error)
{
	TrackerBusConnection * self;
	Block3Data* _data3_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data3_->_ref_count_ = 1;
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data3_->self = g_object_ref (self);
#line 208 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = g_main_context_new ();
#line 208 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	context = _tmp0_;
#line 209 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_main_loop_new (context, FALSE);
#line 209 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data3_->loop = _tmp1_;
#line 210 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_context_push_thread_default (context);
#line 211 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data3_->async_res = NULL;
#line 212 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_sparql_connection_update_async ((TrackerSparqlConnection*) self, sparql, cancellable, ___lambda8__gasync_ready_callback, block3_data_ref (_data3_));
#line 216 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_loop_run (_data3_->loop);
#line 217 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_context_pop_thread_default (context);
#line 218 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_sparql_connection_update_finish ((TrackerSparqlConnection*) self, _data3_->async_res, &_inner_error0_);
#line 218 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 218 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_propagate_error (error, _inner_error0_);
#line 218 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_main_context_unref0 (context);
#line 218 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block3_data_unref (_data3_);
#line 218 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data3_ = NULL;
#line 218 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return;
#line 2869 "tracker-bus.c"
	}
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_main_context_unref0 (context);
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	block3_data_unref (_data3_);
#line 206 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data3_ = NULL;
#line 2877 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_async_data_free (gpointer _data)
{
	TrackerBusConnectionUpdateAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionUpdateAsyncData, _data_);
#line 2893 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_async (TrackerSparqlConnection* base,
                                          const gchar* sparql,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateAsyncData);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_update_async_data_free);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_strdup (sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->sparql = _tmp1_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_real_update_async_co (_data_);
#line 2936 "tracker-bus.c"
}

static void
tracker_bus_connection_update_finish (TrackerSparqlConnection* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	TrackerBusConnectionUpdateAsyncData* _data_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return;
#line 2951 "tracker-bus.c"
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return _data4_;
#line 2962 "tracker-bus.c"
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 2972 "tracker-bus.c"
		TrackerBusConnection* self;
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		self = _data4_->self;
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data4_->dbus_res);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_slice_free (Block4Data, _data4_);
#line 2982 "tracker-bus.c"
	}
}

static void
__lambda7_ (Block4Data* _data4_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = _data4_->self;
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 230 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 230 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data4_->dbus_res);
#line 230 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data4_->dbus_res = _tmp0_;
#line 231 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data4_->sent_update) {
#line 232 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		tracker_bus_connection_real_update_async_co (_data4_->_async_data_);
#line 3007 "tracker-bus.c"
	}
}

static void
___lambda7__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	__lambda7_ (self, source_object, res);
#line 3018 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_update_async_co (TrackerBusConnectionUpdateAsyncData* _data_)
{
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 3028 "tracker-bus.c"
		goto _state_0;
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 1:
#line 3032 "tracker-bus.c"
		goto _state_1;
		default:
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 3037 "tracker-bus.c"
	}
	_state_0:
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data4_ = g_slice_new0 (Block4Data);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data4_->_ref_count_ = 1;
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data4_->self = g_object_ref (_data_->self);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data4_->_async_data_ = _data_;
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_pipe (&_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error0_);
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 224 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3078 "tracker-bus.c"
	}
#line 227 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data4_->dbus_res = NULL;
#line 228 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data4_->sent_update = FALSE;
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp3_ = _data_->self->priv->dbus_name;
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp4_ = _data_->self->priv->object_path;
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp5_ = _data_->input;
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_send_update (_data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, "Update", _data_->_tmp5_, _data_->cancellable, ___lambda7__gasync_ready_callback, _data_->_data4_, &_data_->_inner_error0_);
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 229 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3110 "tracker-bus.c"
	}
#line 237 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp6_ = _data_->output;
#line 237 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp7_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp6_);
#line 237 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->data_stream = _data_->_tmp7_;
#line 238 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp8_ = _data_->data_stream;
#line 238 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_data_output_stream_set_byte_order (_data_->_tmp8_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp9_ = _data_->data_stream;
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp10_ = strlen (_data_->sparql);
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_data_output_stream_put_int32 (_data_->_tmp9_, (gint32) _data_->_tmp11_, NULL, &_data_->_inner_error0_);
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 239 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3148 "tracker-bus.c"
	}
#line 240 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp12_ = _data_->data_stream;
#line 240 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_data_output_stream_put_string (_data_->_tmp12_, _data_->sparql, NULL, &_data_->_inner_error0_);
#line 240 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 240 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 240 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 240 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 240 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 240 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 240 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 240 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 240 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3172 "tracker-bus.c"
	}
#line 241 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 241 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->data_stream = NULL;
#line 244 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data4_->sent_update = TRUE;
#line 245 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp13_ = _data_->_data4_->dbus_res;
#line 245 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_tmp13_ == NULL) {
#line 246 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_state_ = 1;
#line 246 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3188 "tracker-bus.c"
		_state_1:
		;
	}
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp14_ = _data_->self->priv->bus;
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp15_ = _data_->_data4_->dbus_res;
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp16_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp14_, _data_->_tmp15_, &_data_->_inner_error0_);
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->reply = _data_->_tmp16_;
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 249 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3218 "tracker-bus.c"
	}
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp17_ = _data_->reply;
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->_tmp17_, &_data_->_inner_error0_);
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 250 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3244 "tracker-bus.c"
	}
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	block4_data_unref (_data_->_data4_);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data4_ = NULL;
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3266 "tracker-bus.c"
		}
	}
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 221 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 3273 "tracker-bus.c"
}

static void
tracker_bus_connection_perform_update_array_data_free (gpointer _data)
{
	TrackerBusConnectionPerformUpdateArrayData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->bus);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->dbus_name);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->object_path);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionPerformUpdateArrayData, _data_);
#line 3291 "tracker-bus.c"
}

void
tracker_bus_connection_perform_update_array (GDBusConnection* bus,
                                             const gchar* dbus_name,
                                             const gchar* object_path,
                                             gchar** sparql,
                                             gint sparql_length1,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	TrackerBusConnectionPerformUpdateArrayData* _data_;
	GDBusConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (bus != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (dbus_name != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (object_path != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionPerformUpdateArrayData);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_perform_update_array_data_free);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (bus);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->bus);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->bus = _tmp0_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_strdup (dbus_name);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->dbus_name);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->dbus_name = _tmp1_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = g_strdup (object_path);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->object_path);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->object_path = _tmp2_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->sparql = sparql;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->sparql_length1 = sparql_length1;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->cancellable = _tmp3_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_perform_update_array_co (_data_);
#line 3351 "tracker-bus.c"
}

gboolean
tracker_bus_connection_perform_update_array_finish (GAsyncResult* _res_,
                                                    GError** error)
{
	gboolean result;
	TrackerBusConnectionPerformUpdateArrayData* _data_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 3364 "tracker-bus.c"
		gboolean _tmp0_ = FALSE;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return _tmp0_;
#line 3368 "tracker-bus.c"
	}
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 3374 "tracker-bus.c"
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return _data5_;
#line 3384 "tracker-bus.c"
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data5_->dbus_res);
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_slice_free (Block5Data, _data5_);
#line 3398 "tracker-bus.c"
	}
}

static void
__lambda9_ (Block5Data* _data5_,
            GObject* o,
            GAsyncResult* res)
{
	GAsyncResult* _tmp0_;
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 265 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 265 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data5_->dbus_res);
#line 265 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data5_->dbus_res = _tmp0_;
#line 266 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data5_->sent_update) {
#line 267 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		tracker_bus_connection_perform_update_array_co (_data5_->_async_data_);
#line 3420 "tracker-bus.c"
	}
}

static void
___lambda9__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	__lambda9_ (self, source_object, res);
#line 3431 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_perform_update_array_co (TrackerBusConnectionPerformUpdateArrayData* _data_)
{
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 3441 "tracker-bus.c"
		goto _state_0;
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 1:
#line 3445 "tracker-bus.c"
		goto _state_1;
		default:
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 3450 "tracker-bus.c"
	}
	_state_0:
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data5_ = g_slice_new0 (Block5Data);
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data5_->_ref_count_ = 1;
#line 253 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data5_->_async_data_ = _data_;
#line 254 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->sparql_length1 == 0) {
#line 255 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->result = TRUE;
#line 255 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 255 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 255 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 255 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		if (_data_->_state_ != 0) {
#line 255 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			while (!g_task_get_completed (_data_->_async_result)) {
#line 255 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3475 "tracker-bus.c"
			}
		}
#line 255 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 255 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3482 "tracker-bus.c"
	}
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_pipe (&_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error0_);
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 259 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3514 "tracker-bus.c"
	}
#line 262 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data5_->dbus_res = NULL;
#line 263 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data5_->sent_update = FALSE;
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->input;
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_send_update (_data_->bus, _data_->dbus_name, _data_->object_path, "UpdateArray", _data_->_tmp2_, _data_->cancellable, ___lambda9__gasync_ready_callback, _data_->_data5_, &_data_->_inner_error0_);
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 264 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3540 "tracker-bus.c"
	}
#line 272 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp3_ = _data_->output;
#line 272 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp4_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp3_);
#line 272 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->data_stream = _data_->_tmp4_;
#line 273 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp5_ = _data_->data_stream;
#line 273 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_data_output_stream_set_byte_order (_data_->_tmp5_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
#line 274 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp6_ = _data_->data_stream;
#line 274 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_data_output_stream_put_int32 (_data_->_tmp6_, (gint32) _data_->sparql_length1, NULL, &_data_->_inner_error0_);
#line 274 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 274 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 274 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 274 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 274 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 274 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 274 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 274 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 274 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3574 "tracker-bus.c"
	}
	{
#line 275 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->i = 0;
#line 3579 "tracker-bus.c"
		{
#line 275 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_data_->_tmp7_ = TRUE;
#line 275 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			while (TRUE) {
#line 275 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				if (!_data_->_tmp7_) {
#line 275 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					_data_->_tmp8_ = _data_->i;
#line 275 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					_data_->i = _data_->_tmp8_ + 1;
#line 3591 "tracker-bus.c"
				}
#line 275 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_data_->_tmp7_ = FALSE;
#line 275 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				if (!(_data_->i < _data_->sparql_length1)) {
#line 275 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					break;
#line 3599 "tracker-bus.c"
				}
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_data_->_tmp9_ = _data_->data_stream;
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_data_->_tmp10_ = _data_->sparql[_data_->i];
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_data_->_tmp11_ = strlen (_data_->_tmp10_);
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_data_->_tmp12_ = _data_->_tmp11_;
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				g_data_output_stream_put_int32 (_data_->_tmp9_, (gint32) _data_->_tmp12_, NULL, &_data_->_inner_error0_);
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					_g_object_unref0 (_data_->data_stream);
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					_g_object_unref0 (_data_->output);
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					_g_object_unref0 (_data_->input);
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					block5_data_unref (_data_->_data5_);
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					_data_->_data5_ = NULL;
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					g_object_unref (_data_->_async_result);
#line 276 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					return FALSE;
#line 3629 "tracker-bus.c"
				}
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_data_->_tmp13_ = _data_->data_stream;
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				_data_->_tmp14_ = _data_->sparql[_data_->i];
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				g_data_output_stream_put_string (_data_->_tmp13_, _data_->_tmp14_, NULL, &_data_->_inner_error0_);
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					_g_object_unref0 (_data_->data_stream);
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					_g_object_unref0 (_data_->output);
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					_g_object_unref0 (_data_->input);
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					block5_data_unref (_data_->_data5_);
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					_data_->_data5_ = NULL;
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					g_object_unref (_data_->_async_result);
#line 277 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
					return FALSE;
#line 3655 "tracker-bus.c"
				}
			}
		}
	}
#line 279 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 279 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->data_stream = NULL;
#line 282 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data5_->sent_update = TRUE;
#line 283 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp15_ = _data_->_data5_->dbus_res;
#line 283 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_tmp15_ == NULL) {
#line 284 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_state_ = 1;
#line 284 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3674 "tracker-bus.c"
		_state_1:
		;
	}
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp16_ = _data_->_data5_->dbus_res;
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp17_ = g_dbus_connection_send_message_with_reply_finish (_data_->bus, _data_->_tmp16_, &_data_->_inner_error0_);
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->reply = _data_->_tmp17_;
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 287 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3702 "tracker-bus.c"
	}
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp18_ = _data_->reply;
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->_tmp18_, &_data_->_inner_error0_);
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 288 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3728 "tracker-bus.c"
	}
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = TRUE;
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	block5_data_unref (_data_->_data5_);
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data5_ = NULL;
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3752 "tracker-bus.c"
		}
	}
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 290 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 3759 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_array_async_data_free (gpointer _data)
{
	TrackerBusConnectionUpdateArrayAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionUpdateArrayAsyncData, _data_);
#line 3773 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_array_async (TrackerSparqlConnection* base,
                                                gchar** sparql,
                                                gint sparql_length1,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateArrayAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	GCancellable* _tmp1_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateArrayAsyncData);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_update_array_async_data_free);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->sparql = sparql;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->sparql_length1 = sparql_length1;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->cancellable = _tmp1_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_real_update_array_async_co (_data_);
#line 3812 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_update_array_finish (TrackerSparqlConnection* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	gboolean result;
	TrackerBusConnectionUpdateArrayAsyncData* _data_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 3826 "tracker-bus.c"
		gboolean _tmp0_ = FALSE;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return _tmp0_;
#line 3830 "tracker-bus.c"
	}
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 3836 "tracker-bus.c"
}

static void
tracker_bus_connection_update_array_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	TrackerBusConnectionUpdateArrayAsyncData* _data_;
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = _user_data_;
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_res_ = _res_;
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_real_update_array_async_co (_data_);
#line 3853 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_update_array_async_co (TrackerBusConnectionUpdateArrayAsyncData* _data_)
{
#line 293 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 293 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 3863 "tracker-bus.c"
		goto _state_0;
#line 293 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 1:
#line 3867 "tracker-bus.c"
		goto _state_1;
		default:
#line 293 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 3872 "tracker-bus.c"
	}
	_state_0:
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp1_ = _data_->self->priv->bus;
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->self->priv->dbus_name;
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp3_ = _data_->self->priv->object_path;
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_state_ = 1;
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_perform_update_array (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->sparql, (gint) _data_->sparql_length1, _data_->cancellable, tracker_bus_connection_update_array_async_ready, _data_);
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 3887 "tracker-bus.c"
	_state_1:
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = tracker_bus_connection_perform_update_array_finish (_data_->_res_, &_data_->_inner_error0_);
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 3899 "tracker-bus.c"
	}
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = _data_->_tmp0_;
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3911 "tracker-bus.c"
		}
	}
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 294 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 3918 "tracker-bus.c"
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return _data6_;
#line 3928 "tracker-bus.c"
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 3938 "tracker-bus.c"
		TrackerBusConnection* self;
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		self = _data6_->self;
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data6_->async_res);
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_main_loop_unref0 (_data6_->loop);
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_slice_free (Block6Data, _data6_);
#line 3950 "tracker-bus.c"
	}
}

static void
__lambda11_ (Block6Data* _data6_,
             GObject* o,
             GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 303 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = _data6_->self;
#line 303 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 304 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 304 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data6_->async_res);
#line 304 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data6_->async_res = _tmp0_;
#line 305 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_loop_quit (_data6_->loop);
#line 3973 "tracker-bus.c"
}

static void
___lambda11__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 303 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	__lambda11_ (self, source_object, res);
#line 303 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	block6_data_unref (self);
#line 3985 "tracker-bus.c"
}

static GVariant*
tracker_bus_connection_real_update_blank (TrackerSparqlConnection* base,
                                          const gchar* sparql,
                                          GCancellable* cancellable,
                                          GError** error)
{
	TrackerBusConnection * self;
	Block6Data* _data6_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GError* _inner_error0_ = NULL;
	GVariant* result;
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data6_->_ref_count_ = 1;
#line 297 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data6_->self = g_object_ref (self);
#line 299 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = g_main_context_new ();
#line 299 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	context = _tmp0_;
#line 300 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_main_loop_new (context, FALSE);
#line 300 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data6_->loop = _tmp1_;
#line 301 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_context_push_thread_default (context);
#line 302 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data6_->async_res = NULL;
#line 303 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_sparql_connection_update_blank_async ((TrackerSparqlConnection*) self, sparql, cancellable, ___lambda11__gasync_ready_callback, block6_data_ref (_data6_));
#line 307 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_loop_run (_data6_->loop);
#line 308 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_main_context_pop_thread_default (context);
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = tracker_sparql_connection_update_blank_finish ((TrackerSparqlConnection*) self, _data6_->async_res, &_inner_error0_);
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = _tmp3_;
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_propagate_error (error, _inner_error0_);
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_main_context_unref0 (context);
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block6_data_unref (_data6_);
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data6_ = NULL;
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return NULL;
#line 4048 "tracker-bus.c"
	}
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp4_ = _tmp2_;
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = NULL;
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _tmp4_;
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_unref0 (_tmp2_);
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_main_context_unref0 (context);
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	block6_data_unref (_data6_);
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data6_ = NULL;
#line 309 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 4066 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_blank_async_data_free (gpointer _data)
{
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_unref0 (_data_->result);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionUpdateBlankAsyncData, _data_);
#line 4084 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_blank_async (TrackerSparqlConnection* base,
                                                const gchar* sparql,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateBlankAsyncData);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_update_blank_async_data_free);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_strdup (sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->sparql = _tmp1_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_real_update_blank_async_co (_data_);
#line 4127 "tracker-bus.c"
}

static GVariant*
tracker_bus_connection_update_blank_finish (TrackerSparqlConnection* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GVariant* result;
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return NULL;
#line 4143 "tracker-bus.c"
	}
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = NULL;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 4151 "tracker-bus.c"
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return _data7_;
#line 4161 "tracker-bus.c"
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 4171 "tracker-bus.c"
		TrackerBusConnection* self;
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		self = _data7_->self;
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data7_->dbus_res);
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_slice_free (Block7Data, _data7_);
#line 4181 "tracker-bus.c"
	}
}

static void
__lambda10_ (Block7Data* _data7_,
             GObject* o,
             GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = _data7_->self;
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 321 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 321 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data7_->dbus_res);
#line 321 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data7_->dbus_res = _tmp0_;
#line 322 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data7_->sent_update) {
#line 323 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		tracker_bus_connection_real_update_blank_async_co (_data7_->_async_data_);
#line 4206 "tracker-bus.c"
	}
}

static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	__lambda10_ (self, source_object, res);
#line 4217 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_update_blank_async_co (TrackerBusConnectionUpdateBlankAsyncData* _data_)
{
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 4227 "tracker-bus.c"
		goto _state_0;
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 1:
#line 4231 "tracker-bus.c"
		goto _state_1;
		default:
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 4236 "tracker-bus.c"
	}
	_state_0:
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data7_ = g_slice_new0 (Block7Data);
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data7_->_ref_count_ = 1;
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data7_->self = g_object_ref (_data_->self);
#line 312 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data7_->_async_data_ = _data_;
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_pipe (&_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error0_);
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 315 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 4277 "tracker-bus.c"
	}
#line 318 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data7_->dbus_res = NULL;
#line 319 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data7_->sent_update = FALSE;
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp3_ = _data_->self->priv->dbus_name;
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp4_ = _data_->self->priv->object_path;
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp5_ = _data_->input;
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_send_update (_data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, "UpdateBlank", _data_->_tmp5_, _data_->cancellable, ___lambda10__gasync_ready_callback, _data_->_data7_, &_data_->_inner_error0_);
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 320 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 4309 "tracker-bus.c"
	}
#line 328 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp6_ = _data_->output;
#line 328 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp7_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp6_);
#line 328 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->data_stream = _data_->_tmp7_;
#line 329 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp8_ = _data_->data_stream;
#line 329 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_data_output_stream_set_byte_order (_data_->_tmp8_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp9_ = _data_->data_stream;
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp10_ = strlen (_data_->sparql);
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_data_output_stream_put_int32 (_data_->_tmp9_, (gint32) _data_->_tmp11_, NULL, &_data_->_inner_error0_);
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 330 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 4347 "tracker-bus.c"
	}
#line 331 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp12_ = _data_->data_stream;
#line 331 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_data_output_stream_put_string (_data_->_tmp12_, _data_->sparql, NULL, &_data_->_inner_error0_);
#line 331 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 331 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 331 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 331 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 331 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 331 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 331 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 331 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 331 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 4371 "tracker-bus.c"
	}
#line 332 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 332 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->data_stream = NULL;
#line 335 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data7_->sent_update = TRUE;
#line 336 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp13_ = _data_->_data7_->dbus_res;
#line 336 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_tmp13_ == NULL) {
#line 337 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_state_ = 1;
#line 337 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 4387 "tracker-bus.c"
		_state_1:
		;
	}
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp14_ = _data_->self->priv->bus;
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp15_ = _data_->_data7_->dbus_res;
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp16_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp14_, _data_->_tmp15_, &_data_->_inner_error0_);
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->reply = _data_->_tmp16_;
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 340 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 4417 "tracker-bus.c"
	}
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp17_ = _data_->reply;
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->_tmp17_, &_data_->_inner_error0_);
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 341 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 4443 "tracker-bus.c"
	}
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp18_ = _data_->reply;
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp19_ = g_dbus_message_get_body (_data_->_tmp18_);
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp20_ = g_variant_get_child_value (_data_->_tmp19_, (gsize) 0);
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = _data_->_tmp20_;
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	block7_data_unref (_data_->_data7_);
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_data7_ = NULL;
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4473 "tracker-bus.c"
		}
	}
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 342 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 4480 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_update_resource (TrackerSparqlConnection* base,
                                             const gchar* graph,
                                             TrackerResource* resource,
                                             GCancellable* cancellable,
                                             GError** error)
{
	TrackerBusConnection * self;
	TrackerBatch* batch = NULL;
	TrackerBatch* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 345 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 345 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_val_if_fail (resource != NULL, FALSE);
#line 346 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = tracker_sparql_connection_create_batch ((TrackerSparqlConnection*) self);
#line 346 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	batch = _tmp0_;
#line 347 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_batch_add_resource (batch, graph, resource);
#line 348 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = tracker_batch_execute (batch, cancellable, &_inner_error0_);
#line 348 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4510 "tracker-bus.c"
		gboolean _tmp2_ = FALSE;
#line 348 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_propagate_error (error, _inner_error0_);
#line 348 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (batch);
#line 348 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return _tmp2_;
#line 4518 "tracker-bus.c"
	}
#line 348 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _tmp1_;
#line 348 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (batch);
#line 348 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 4526 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_resource_async_data_free (gpointer _data)
{
	TrackerBusConnectionUpdateResourceAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->graph);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->resource);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionUpdateResourceAsyncData, _data_);
#line 4544 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_resource_async (TrackerSparqlConnection* base,
                                                   const gchar* graph,
                                                   TrackerResource* resource,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateResourceAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	gchar* _tmp1_;
	TrackerResource* _tmp2_;
	GCancellable* _tmp3_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (resource != NULL);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateResourceAsyncData);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_update_resource_async_data_free);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_strdup (graph);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->graph);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->graph = _tmp1_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (resource);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->resource);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->resource = _tmp2_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->cancellable = _tmp3_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_real_update_resource_async_co (_data_);
#line 4595 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_update_resource_finish (TrackerSparqlConnection* base,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	gboolean result;
	TrackerBusConnectionUpdateResourceAsyncData* _data_;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 4609 "tracker-bus.c"
		gboolean _tmp0_ = FALSE;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return _tmp0_;
#line 4613 "tracker-bus.c"
	}
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 4619 "tracker-bus.c"
}

static void
tracker_bus_connection_update_resource_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	TrackerBusConnectionUpdateResourceAsyncData* _data_;
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = _user_data_;
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_res_ = _res_;
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_real_update_resource_async_co (_data_);
#line 4636 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_update_resource_async_co (TrackerBusConnectionUpdateResourceAsyncData* _data_)
{
#line 351 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 351 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 4646 "tracker-bus.c"
		goto _state_0;
#line 351 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 1:
#line 4650 "tracker-bus.c"
		goto _state_1;
		default:
#line 351 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 4655 "tracker-bus.c"
	}
	_state_0:
#line 352 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = tracker_sparql_connection_create_batch ((TrackerSparqlConnection*) _data_->self);
#line 352 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->batch = _data_->_tmp0_;
#line 353 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_batch_add_resource (_data_->batch, _data_->graph, _data_->resource);
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_state_ = 1;
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_batch_execute_async (_data_->batch, _data_->cancellable, tracker_bus_connection_update_resource_async_ready, _data_);
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 4670 "tracker-bus.c"
	_state_1:
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp1_ = tracker_batch_execute_finish (_data_->batch, _data_->_res_, &_data_->_inner_error0_);
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->batch);
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 4684 "tracker-bus.c"
	}
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = _data_->_tmp1_;
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->batch);
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4698 "tracker-bus.c"
		}
	}
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 354 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 4705 "tracker-bus.c"
}

static TrackerNotifier*
tracker_bus_connection_real_create_notifier (TrackerSparqlConnection* base)
{
	TrackerBusConnection * self;
	TrackerNotifier* notifier = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GDBusConnection* _tmp2_;
	const gchar* _tmp3_;
	TrackerNotifier* result;
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 358 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = g_object_new (TRACKER_TYPE_NOTIFIER, "connection", self, NULL, NULL);
#line 358 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
#line 358 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	notifier = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TRACKER_TYPE_NOTIFIER, TrackerNotifier);
#line 362 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = self->priv->bus;
#line 362 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = self->priv->dbus_name;
#line 362 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_notifier_signal_subscribe (notifier, _tmp2_, _tmp3_, NULL, NULL);
#line 364 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = notifier;
#line 364 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 4736 "tracker-bus.c"
}

static void
tracker_bus_connection_real_close (TrackerSparqlConnection* base)
{
	TrackerBusConnection * self;
	GError* _inner_error0_ = NULL;
#line 367 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 368 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (self->priv->sandboxed) {
#line 4748 "tracker-bus.c"
		GDBusMessage* message = NULL;
		GDBusMessage* _tmp0_;
		GDBusMessage* _tmp1_;
		const gchar* _tmp2_;
		GVariant* _tmp3_;
		GVariant* _tmp4_;
#line 369 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp0_ = g_dbus_message_new_method_call (TRACKER_BUS_CONNECTION_PORTAL_NAME, TRACKER_BUS_CONNECTION_PORTAL_PATH, TRACKER_BUS_CONNECTION_PORTAL_IFACE, "CloseSession");
#line 369 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		message = _tmp0_;
#line 370 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp1_ = message;
#line 370 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp2_ = self->priv->object_path;
#line 370 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp3_ = g_variant_new ("(o)", _tmp2_, NULL);
#line 370 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_variant_ref_sink (_tmp3_);
#line 370 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_tmp4_ = _tmp3_;
#line 370 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_dbus_message_set_body (_tmp1_, _tmp4_);
#line 370 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_variant_unref0 (_tmp4_);
#line 4773 "tracker-bus.c"
		{
			GDBusConnection* _tmp5_;
			GDBusMessage* _tmp6_;
#line 373 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_tmp5_ = self->priv->bus;
#line 373 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_tmp6_ = message;
#line 373 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_dbus_connection_send_message (_tmp5_, _tmp6_, 0, NULL, &_inner_error0_);
#line 373 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4785 "tracker-bus.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
#line 372 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_clear_error (&_inner_error0_);
#line 4794 "tracker-bus.c"
		}
		__finally0:
#line 372 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 372 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			_g_object_unref0 (message);
#line 372 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 372 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_clear_error (&_inner_error0_);
#line 372 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			return;
#line 4807 "tracker-bus.c"
		}
#line 368 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (message);
#line 4811 "tracker-bus.c"
	}
}

static void
tracker_bus_connection_real_close_async_data_free (gpointer _data)
{
	TrackerBusConnectionCloseAsyncData* _data_;
	_data_ = _data;
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionCloseAsyncData, _data_);
#line 4824 "tracker-bus.c"
}

static void
tracker_bus_connection_real_close_async (TrackerSparqlConnection* base,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionCloseAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionCloseAsyncData);
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_close_async_data_free);
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_real_close_async_co (_data_);
#line 4849 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_close_finish (TrackerSparqlConnection* base,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	gboolean result;
	TrackerBusConnectionCloseAsyncData* _data_;
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 4863 "tracker-bus.c"
		gboolean _tmp0_ = FALSE;
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return _tmp0_;
#line 4867 "tracker-bus.c"
	}
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _data_->result;
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 4873 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_close_async_co (TrackerBusConnectionCloseAsyncData* _data_)
{
#line 379 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 379 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 4883 "tracker-bus.c"
		goto _state_0;
		default:
#line 379 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 4888 "tracker-bus.c"
	}
	_state_0:
#line 380 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_sparql_connection_close ((TrackerSparqlConnection*) _data_->self);
#line 381 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = TRUE;
#line 381 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 381 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 381 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 381 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4903 "tracker-bus.c"
		}
	}
#line 381 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 381 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 4910 "tracker-bus.c"
}

static TrackerNamespaceManager*
tracker_bus_connection_real_get_namespace_manager (TrackerSparqlConnection* base)
{
	TrackerBusConnection * self;
	TrackerNamespaceManager* _tmp0_;
	TrackerNamespaceManager* _tmp1_;
	TrackerNamespaceManager* result;
#line 384 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 385 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = self->priv->namespaces;
#line 385 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 385 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _tmp1_;
#line 385 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 4930 "tracker-bus.c"
}

static TrackerBatch*
tracker_bus_connection_real_create_batch (TrackerSparqlConnection* base)
{
	TrackerBusConnection * self;
	TrackerBatch* batch = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	TrackerBatch* result;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 389 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = g_object_new (TRACKER_BUS_TYPE_BATCH, "connection", self, NULL, NULL);
#line 389 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
#line 389 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	batch = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TRACKER_TYPE_BATCH, TrackerBatch);
#line 392 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = batch;
#line 392 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 4953 "tracker-bus.c"
}

static void
tracker_bus_connection_perform_serialize_data_free (gpointer _data)
{
	TrackerBusConnectionPerformSerializeData* _data_;
	_data_ = _data;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->bus);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->dbus_name);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->object_path);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_builder_unref0 (_data_->arguments);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->result);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionPerformSerializeData, _data_);
#line 4977 "tracker-bus.c"
}

void
tracker_bus_connection_perform_serialize (GDBusConnection* bus,
                                          const gchar* dbus_name,
                                          const gchar* object_path,
                                          TrackerSerializeFlags flags,
                                          TrackerRdfFormat format,
                                          const gchar* sparql,
                                          GVariantBuilder* arguments,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	TrackerBusConnectionPerformSerializeData* _data_;
	GDBusConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GVariantBuilder* _tmp4_;
	GCancellable* _tmp5_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (bus != NULL);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (dbus_name != NULL);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (object_path != NULL);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionPerformSerializeData);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_perform_serialize_data_free);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (bus);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->bus);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->bus = _tmp0_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_strdup (dbus_name);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->dbus_name);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->dbus_name = _tmp1_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = g_strdup (object_path);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->object_path);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->object_path = _tmp2_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->flags = flags;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->format = format;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp3_ = g_strdup (sparql);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->sparql = _tmp3_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp4_ = _g_variant_builder_ref0 (arguments);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_builder_unref0 (_data_->arguments);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->arguments = _tmp4_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp5_ = _g_object_ref0 (cancellable);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->cancellable = _tmp5_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_perform_serialize_co (_data_);
#line 5055 "tracker-bus.c"
}

GInputStream*
tracker_bus_connection_perform_serialize_finish (GAsyncResult* _res_,
                                                 GError** error)
{
	GInputStream* result;
	TrackerBusConnectionPerformSerializeData* _data_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return NULL;
#line 5070 "tracker-bus.c"
	}
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _data_->result;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = NULL;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 5078 "tracker-bus.c"
}

static void
tracker_bus_connection_perform_serialize_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	TrackerBusConnectionPerformSerializeData* _data_;
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = _user_data_;
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_res_ = _res_;
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_perform_serialize_co (_data_);
#line 5095 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_perform_serialize_co (TrackerBusConnectionPerformSerializeData* _data_)
{
#line 395 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 395 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 5105 "tracker-bus.c"
		goto _state_0;
#line 395 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 1:
#line 5109 "tracker-bus.c"
		goto _state_1;
		default:
#line 395 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 5114 "tracker-bus.c"
	}
	_state_0:
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_pipe (&_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error0_);
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 398 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 5143 "tracker-bus.c"
	}
#line 400 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp2_ = g_dbus_message_new_method_call (_data_->dbus_name, _data_->object_path, TRACKER_BUS_CONNECTION_ENDPOINT_IFACE, "Serialize");
#line 400 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->message = _data_->_tmp2_;
#line 401 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp3_ = g_unix_fd_list_new ();
#line 401 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->fd_list = _data_->_tmp3_;
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp5_ = _data_->fd_list;
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp6_ = _data_->output;
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp7_ = g_unix_output_stream_get_fd (_data_->_tmp6_);
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp4_ = g_unix_fd_list_append (_data_->_tmp5_, _data_->_tmp8_, &_data_->_inner_error0_);
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->fd_list);
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->message);
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 5179 "tracker-bus.c"
	}
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp9_ = _data_->message;
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp10_ = g_variant_new ("(shiia{sv})", _data_->sparql, _data_->_tmp4_, _data_->flags, _data_->format, _data_->arguments, NULL);
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_variant_ref_sink (_data_->_tmp10_);
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_message_set_body (_data_->_tmp9_, _data_->_tmp11_);
#line 402 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_variant_unref0 (_data_->_tmp11_);
#line 403 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp12_ = _data_->message;
#line 403 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp13_ = _data_->fd_list;
#line 403 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_message_set_unix_fd_list (_data_->_tmp12_, _data_->_tmp13_);
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp14_ = _data_->message;
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_state_ = 1;
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (_data_->bus, _data_->_tmp14_, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, _data_->cancellable, tracker_bus_connection_perform_serialize_ready, _data_);
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 5207 "tracker-bus.c"
	_state_1:
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp15_ = g_dbus_connection_send_message_with_reply_finish (_data_->bus, _data_->_res_, &_data_->_inner_error0_);
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->reply = _data_->_tmp15_;
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->fd_list);
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->message);
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 405 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 5229 "tracker-bus.c"
	}
#line 406 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp16_ = _data_->reply;
#line 406 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->_tmp16_, &_data_->_inner_error0_);
#line 406 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 406 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 406 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 406 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->fd_list);
#line 406 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->message);
#line 406 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 406 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 406 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 406 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 5253 "tracker-bus.c"
	}
#line 408 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = (GInputStream*) _data_->input;
#line 408 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 408 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->fd_list);
#line 408 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->message);
#line 408 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 408 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 408 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 408 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 408 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 5273 "tracker-bus.c"
		}
	}
#line 408 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 408 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 5280 "tracker-bus.c"
}

static void
tracker_bus_connection_real_serialize_async_data_free (gpointer _data)
{
	TrackerBusConnectionSerializeAsyncData* _data_;
	_data_ = _data;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->result);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionSerializeAsyncData, _data_);
#line 5298 "tracker-bus.c"
}

static void
tracker_bus_connection_real_serialize_async (TrackerSparqlConnection* base,
                                             TrackerSerializeFlags flags,
                                             TrackerRdfFormat format,
                                             const gchar* sparql,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionSerializeAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionSerializeAsyncData);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_serialize_async_data_free);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->flags = flags;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->format = format;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp1_ = g_strdup (sparql);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->sparql = _tmp1_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_real_serialize_async_co (_data_);
#line 5347 "tracker-bus.c"
}

static GInputStream*
tracker_bus_connection_serialize_finish (TrackerSparqlConnection* base,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GInputStream* result;
	TrackerBusConnectionSerializeAsyncData* _data_;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return NULL;
#line 5363 "tracker-bus.c"
	}
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _data_->result;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = NULL;
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 5371 "tracker-bus.c"
}

static void
tracker_bus_connection_serialize_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	TrackerBusConnectionSerializeAsyncData* _data_;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_ = _user_data_;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_res_ = _res_;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_real_serialize_async_co (_data_);
#line 5388 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_serialize_async_co (TrackerBusConnectionSerializeAsyncData* _data_)
{
#line 411 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 411 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 0:
#line 5398 "tracker-bus.c"
		goto _state_0;
#line 411 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case 1:
#line 5402 "tracker-bus.c"
		goto _state_1;
		default:
#line 411 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 5407 "tracker-bus.c"
	}
	_state_0:
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp1_ = _data_->self->priv->bus;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->self->priv->dbus_name;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp3_ = _data_->self->priv->object_path;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_state_ = 1;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_perform_serialize (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->flags, _data_->format, _data_->sparql, NULL, _data_->cancellable, tracker_bus_connection_serialize_async_ready, _data_);
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 5422 "tracker-bus.c"
	_state_1:
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp4_ = tracker_bus_connection_perform_serialize_finish (_data_->_res_, &_data_->_inner_error0_);
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = _data_->_tmp4_;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		return FALSE;
#line 5436 "tracker-bus.c"
	}
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp5_ = _data_->_tmp0_;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_data_->result = _data_->_tmp5_;
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 5454 "tracker-bus.c"
		}
	}
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 412 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return FALSE;
#line 5461 "tracker-bus.c"
}

const gchar*
tracker_bus_connection_get_bus_name (TrackerBusConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 38 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 38 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = self->priv->dbus_name;
#line 38 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _tmp0_;
#line 38 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 5477 "tracker-bus.c"
}

const gchar*
tracker_bus_connection_get_bus_object_path (TrackerBusConnection* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_tmp0_ = self->priv->object_path;
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	result = _tmp0_;
#line 42 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	return result;
#line 5493 "tracker-bus.c"
}

static void
tracker_bus_connection_class_init (TrackerBusConnectionClass * klass,
                                   gpointer klass_data)
{
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	tracker_bus_connection_parent_class = g_type_class_peek_parent (klass);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_type_class_adjust_private_offset (klass, &TrackerBusConnection_private_offset);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_bus_connection_real_query;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->query_async = (void (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_query_async;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->query_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_query_finish;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->query_statement = (TrackerSparqlStatement* (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_bus_connection_real_query_statement;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update = (void (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_bus_connection_real_update;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_async = (void (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_update_async;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_finish = (void (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_update_finish;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_async = (void (*) (TrackerSparqlConnection*, gchar**, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_update_array_async;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_finish = (gboolean (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_update_array_finish;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank = (GVariant* (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_bus_connection_real_update_blank;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_async = (void (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_update_blank_async;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_finish = (GVariant* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_update_blank_finish;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_resource = (gboolean (*) (TrackerSparqlConnection*, const gchar*, TrackerResource*, GCancellable*, GError**)) tracker_bus_connection_real_update_resource;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_resource_async = (void (*) (TrackerSparqlConnection*, const gchar*, TrackerResource*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_update_resource_async;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_resource_finish = (gboolean (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_update_resource_finish;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->create_notifier = (TrackerNotifier* (*) (TrackerSparqlConnection*)) tracker_bus_connection_real_create_notifier;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->close = (void (*) (TrackerSparqlConnection*)) tracker_bus_connection_real_close;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->close_async = (void (*) (TrackerSparqlConnection*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_close_async;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->close_finish = (gboolean (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_close_finish;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->get_namespace_manager = (TrackerNamespaceManager* (*) (TrackerSparqlConnection*)) tracker_bus_connection_real_get_namespace_manager;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->create_batch = (TrackerBatch* (*) (TrackerSparqlConnection*)) tracker_bus_connection_real_create_batch;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->serialize_async = (void (*) (TrackerSparqlConnection*, TrackerSerializeFlags, TrackerRdfFormat, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_serialize_async;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->serialize_finish = (GInputStream* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_serialize_finish;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_bus_connection_get_property;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_bus_connection_finalize;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_BUS_CONNECTION_BUS_NAME_PROPERTY, tracker_bus_connection_properties[TRACKER_BUS_CONNECTION_BUS_NAME_PROPERTY] = g_param_spec_string ("bus-name", "bus-name", "bus-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_BUS_CONNECTION_BUS_OBJECT_PATH_PROPERTY, tracker_bus_connection_properties[TRACKER_BUS_CONNECTION_BUS_OBJECT_PATH_PROPERTY] = g_param_spec_string ("bus-object-path", "bus-object-path", "bus-object-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 5558 "tracker-bus.c"
}

static void
tracker_bus_connection_instance_init (TrackerBusConnection * self,
                                      gpointer klass)
{
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self->priv = tracker_bus_connection_get_instance_private (self);
#line 5567 "tracker-bus.c"
}

static void
tracker_bus_connection_finalize (GObject * obj)
{
	TrackerBusConnection * self;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnection);
#line 21 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (self->priv->bus);
#line 22 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (self->priv->dbus_name);
#line 23 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_free0 (self->priv->object_path);
#line 25 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_g_object_unref0 (self->priv->namespaces);
#line 388 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	G_OBJECT_CLASS (tracker_bus_connection_parent_class)->finalize (obj);
#line 5586 "tracker-bus.c"
}

static GType
tracker_bus_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerBusConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_bus_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerBusConnection), 0, (GInstanceInitFunc) tracker_bus_connection_instance_init, NULL };
	GType tracker_bus_connection_type_id;
	tracker_bus_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerBusConnection", &g_define_type_info, 0);
	TrackerBusConnection_private_offset = g_type_add_instance_private (tracker_bus_connection_type_id, sizeof (TrackerBusConnectionPrivate));
	return tracker_bus_connection_type_id;
}

GType
tracker_bus_connection_get_type (void)
{
	static volatile gsize tracker_bus_connection_type_id__once = 0;
	if (g_once_init_enter (&tracker_bus_connection_type_id__once)) {
		GType tracker_bus_connection_type_id;
		tracker_bus_connection_type_id = tracker_bus_connection_get_type_once ();
		g_once_init_leave (&tracker_bus_connection_type_id__once, tracker_bus_connection_type_id);
	}
	return tracker_bus_connection_type_id__once;
}

static void
_vala_tracker_bus_connection_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	TrackerBusConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnection);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	switch (property_id) {
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case TRACKER_BUS_CONNECTION_BUS_NAME_PROPERTY:
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_value_set_string (value, tracker_bus_connection_get_bus_name (self));
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		break;
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		case TRACKER_BUS_CONNECTION_BUS_OBJECT_PATH_PROPERTY:
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		g_value_set_string (value, tracker_bus_connection_get_bus_object_path (self));
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		break;
#line 5633 "tracker-bus.c"
		default:
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		break;
#line 5639 "tracker-bus.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5650 "tracker-bus.c"
		gssize i;
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5658 "tracker-bus.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 357 "../tracker/src/libtracker-sparql/bus/tracker-bus.vala"
	g_free (array);
#line 5673 "tracker-bus.c"
}

