/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.tools.jmx;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;
import org.graalvm.visualvm.application.jvm.HeapHistogram;
import org.graalvm.visualvm.core.datasupport.AsyncPropertyChangeSupport;
import org.graalvm.visualvm.core.model.Model;

public abstract class JmxModel
extends Model {
    private static final String JAR_SUFFIX = ".jar";
    private static final Pattern MODULE_MAIN_CLASS_PATTERN = Pattern.compile("^(\\w+\\.)*\\w+/(\\w+\\.)+\\w+$");
    protected PropertyChangeSupport propertyChangeSupport = new AsyncPropertyChangeSupport((Object)this);
    public static final String CONNECTION_STATE_PROPERTY = "connectionState";

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public abstract ConnectionState getConnectionState();

    public abstract MBeanServerConnection getMBeanServerConnection();

    public abstract JMXServiceURL getJMXServiceURL();

    public abstract Properties getSystemProperties();

    public abstract boolean isTakeHeapDumpSupported();

    public abstract boolean takeHeapDump(String var1);

    public abstract boolean isTakeThreadDumpSupported();

    public abstract String takeThreadDump();

    public abstract String takeThreadDump(long[] var1);

    public abstract HeapHistogram takeHeapHistogram();

    public abstract String getFlagValue(String var1);

    public abstract void setFlagValue(String var1, String var2);

    public abstract boolean isJfrAvailable();

    public abstract List<Long> jfrCheck();

    public abstract String takeJfrDump(long var1, String var3);

    public abstract boolean startJfrRecording(String var1, String[] var2, String var3, String var4, Boolean var5, String var6, String var7, String var8, Boolean var9);

    public abstract boolean stopJfrRecording();

    public abstract String getCommandLine();

    public String getMainArgs() {
        String arg0;
        int firstSpace;
        String commandLine = this.getCommandLine();
        if (commandLine != null && (firstSpace = (arg0 = this.getFirstArgument(commandLine)).length()) < commandLine.length()) {
            return commandLine.substring(firstSpace);
        }
        return null;
    }

    public String getMainClass() {
        String commandLine = this.getCommandLine();
        if (commandLine != null) {
            String mainClassName = this.getFirstArgument(commandLine);
            if (mainClassName.endsWith(JAR_SUFFIX)) {
                int index = (mainClassName = mainClassName.replace('\\', '/')).lastIndexOf(47);
                if (index != -1) {
                    mainClassName = mainClassName.substring(index + 1);
                }
            } else if (MODULE_MAIN_CLASS_PATTERN.matcher(mainClassName).find()) {
                return mainClassName.substring(mainClassName.indexOf(47) + 1);
            }
            mainClassName = mainClassName.replace('\\', '/').replace('/', '.');
            return mainClassName;
        }
        return null;
    }

    private String getFirstArgument(String commandLine) {
        String classPath;
        String jarFile;
        String mainClassName = null;
        int jarIndex = commandLine.indexOf(JAR_SUFFIX);
        if (jarIndex != -1 && ((jarFile = commandLine.substring(0, jarIndex + JAR_SUFFIX.length())).length() == commandLine.length() || commandLine.charAt(jarFile.length()) == ' ') && (classPath = this.getClassPath()) != null && classPath.contains(jarFile)) {
            mainClassName = jarFile;
        }
        if (mainClassName == null) {
            int firstSpace = commandLine.indexOf(32);
            mainClassName = firstSpace > 0 ? commandLine.substring(0, firstSpace) : commandLine;
        }
        return mainClassName;
    }

    private String getClassPath() {
        return this.getSystemProperties().getProperty("java.class.path");
    }

    public static enum ConnectionState {
        CONNECTED,
        DISCONNECTED,
        CONNECTING;

    }
}

