/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.ftp;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import sun.net.ProgressMonitor;
import sun.net.ProgressSource;
import sun.net.ftp.FtpClient;
import sun.net.ftp.FtpLoginException;
import sun.net.ftp.FtpProtocolException;
import sun.net.util.IPAddressUtil;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.ParseUtil;
import sun.net.www.URLConnection;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetPropertyAction;

public class FtpURLConnection
extends URLConnection {
    HttpURLConnection http = null;
    private Proxy instProxy;
    InputStream is = null;
    OutputStream os = null;
    FtpClient ftp = null;
    Permission permission;
    String password;
    String user;
    String host;
    String pathname;
    String filename;
    String fullpath;
    int port;
    static final int NONE = 0;
    static final int ASCII = 1;
    static final int BIN = 2;
    static final int DIR = 3;
    int type = 0;
    private int connectTimeout = -1;
    private int readTimeout = -1;

    static URL checkURL(URL uRL) throws IllegalArgumentException {
        if (uRL != null && uRL.toExternalForm().indexOf(10) > -1) {
            MalformedURLException malformedURLException = new MalformedURLException("Illegal character in URL");
            throw new IllegalArgumentException(malformedURLException.getMessage(), malformedURLException);
        }
        String string = IPAddressUtil.checkAuthority(uRL);
        if (string != null) {
            MalformedURLException malformedURLException = new MalformedURLException(string);
            throw new IllegalArgumentException(malformedURLException.getMessage(), malformedURLException);
        }
        return uRL;
    }

    public FtpURLConnection(URL uRL) {
        this(uRL, null);
    }

    FtpURLConnection(URL uRL, Proxy proxy) {
        super(FtpURLConnection.checkURL(uRL));
        this.instProxy = proxy;
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        String string = uRL.getUserInfo();
        if (string != null) {
            int n = string.indexOf(58);
            if (n == -1) {
                this.user = ParseUtil.decode(string);
                this.password = null;
            } else {
                this.user = ParseUtil.decode(string.substring(0, n++));
                this.password = ParseUtil.decode(string.substring(n));
            }
        }
    }

    private void setTimeouts() {
        if (this.ftp != null) {
            if (this.connectTimeout >= 0) {
                this.ftp.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout >= 0) {
                this.ftp.setReadTimeout(this.readTimeout);
            }
        }
    }

    @Override
    public synchronized void connect() throws IOException {
        Object object;
        if (this.connected) {
            return;
        }
        Proxy proxy2 = null;
        if (this.instProxy == null) {
            object = AccessController.doPrivileged(new PrivilegedAction<ProxySelector>(){

                @Override
                public ProxySelector run() {
                    return ProxySelector.getDefault();
                }
            });
            if (object != null) {
                URI uRI = ParseUtil.toURI(this.url);
                for (Proxy proxy2 : ((ProxySelector)object).select(uRI)) {
                    if (proxy2 == null || proxy2 == Proxy.NO_PROXY || proxy2.type() == Proxy.Type.SOCKS) break;
                    if (proxy2.type() != Proxy.Type.HTTP || !(proxy2.address() instanceof InetSocketAddress)) {
                        ((ProxySelector)object).connectFailed(uRI, proxy2.address(), new IOException("Wrong proxy type"));
                        continue;
                    }
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy2.address();
                    try {
                        this.http = new HttpURLConnection(this.url, proxy2);
                        this.http.setDoInput(this.getDoInput());
                        this.http.setDoOutput(this.getDoOutput());
                        if (this.connectTimeout >= 0) {
                            this.http.setConnectTimeout(this.connectTimeout);
                        }
                        if (this.readTimeout >= 0) {
                            this.http.setReadTimeout(this.readTimeout);
                        }
                        this.http.connect();
                        this.connected = true;
                        return;
                    }
                    catch (IOException iOException) {
                        ((ProxySelector)object).connectFailed(uRI, inetSocketAddress, iOException);
                        this.http = null;
                    }
                }
            }
        } else {
            proxy2 = this.instProxy;
            if (proxy2.type() == Proxy.Type.HTTP) {
                this.http = new HttpURLConnection(this.url, this.instProxy);
                this.http.setDoInput(this.getDoInput());
                this.http.setDoOutput(this.getDoOutput());
                if (this.connectTimeout >= 0) {
                    this.http.setConnectTimeout(this.connectTimeout);
                }
                if (this.readTimeout >= 0) {
                    this.http.setReadTimeout(this.readTimeout);
                }
                this.http.connect();
                this.connected = true;
                return;
            }
        }
        if (this.user == null) {
            this.user = "anonymous";
            object = AccessController.doPrivileged(new GetPropertyAction("java.version"));
            this.password = AccessController.doPrivileged(new GetPropertyAction("ftp.protocol.user", "Java" + (String)object + "@"));
        }
        try {
            this.ftp = FtpClient.create();
            if (proxy2 != null) {
                this.ftp.setProxy(proxy2);
            }
            this.setTimeouts();
            if (this.port != -1) {
                this.ftp.connect(new InetSocketAddress(this.host, this.port));
            } else {
                this.ftp.connect(new InetSocketAddress(this.host, FtpClient.defaultPort()));
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw unknownHostException;
        }
        catch (FtpProtocolException ftpProtocolException) {
            if (this.ftp != null) {
                try {
                    this.ftp.close();
                }
                catch (IOException iOException) {
                    ftpProtocolException.addSuppressed(iOException);
                }
            }
            throw new IOException(ftpProtocolException);
        }
        try {
            this.ftp.login(this.user, this.password == null ? null : this.password.toCharArray());
        }
        catch (FtpProtocolException ftpProtocolException) {
            this.ftp.close();
            throw new FtpLoginException("Invalid username/password");
        }
        this.connected = true;
    }

    private void decodePath(String string) {
        int n = string.indexOf(";type=");
        if (n >= 0) {
            String string2 = string.substring(n + 6, string.length());
            if ("i".equalsIgnoreCase(string2)) {
                this.type = 2;
            }
            if ("a".equalsIgnoreCase(string2)) {
                this.type = 1;
            }
            if ("d".equalsIgnoreCase(string2)) {
                this.type = 3;
            }
            string = string.substring(0, n);
        }
        if (string != null && string.length() > 1 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (string == null || string.length() == 0) {
            string = "./";
        }
        if (!string.endsWith("/")) {
            n = string.lastIndexOf(47);
            if (n > 0) {
                this.filename = string.substring(n + 1, string.length());
                this.filename = ParseUtil.decode(this.filename);
                this.pathname = string.substring(0, n);
            } else {
                this.filename = ParseUtil.decode(string);
                this.pathname = null;
            }
        } else {
            this.pathname = string.substring(0, string.length() - 1);
            this.filename = null;
        }
        this.fullpath = this.pathname != null ? this.pathname + "/" + (this.filename != null ? this.filename : "") : this.filename;
    }

    private void cd(String string) throws FtpProtocolException, IOException {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (string.indexOf(47) == -1) {
            this.ftp.changeDirectory(ParseUtil.decode(string));
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            this.ftp.changeDirectory(ParseUtil.decode(stringTokenizer.nextToken()));
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.http != null) {
            return this.http.getInputStream();
        }
        if (this.os != null) {
            throw new IOException("Already opened for output");
        }
        if (this.is != null) {
            return this.is;
        }
        MessageHeader messageHeader = new MessageHeader();
        boolean bl = false;
        try {
            this.decodePath(this.url.getPath());
            if (this.filename == null || this.type == 3) {
                this.ftp.setAsciiType();
                this.cd(this.pathname);
                this.is = this.filename == null ? new FtpInputStream(this.ftp, this.ftp.list(null)) : new FtpInputStream(this.ftp, this.ftp.nameList(this.filename));
            } else {
                if (this.type == 1) {
                    this.ftp.setAsciiType();
                } else {
                    this.ftp.setBinaryType();
                }
                this.cd(this.pathname);
                this.is = new FtpInputStream(this.ftp, this.ftp.getFileStream(this.filename));
            }
            try {
                long l = this.ftp.getLastTransferSize();
                messageHeader.add("content-length", Long.toString(l));
                if (l > 0L) {
                    boolean bl2 = ProgressMonitor.getDefault().shouldMeterInput(this.url, "GET");
                    ProgressSource progressSource = null;
                    if (bl2) {
                        progressSource = new ProgressSource(this.url, "GET", l);
                        progressSource.beginTracking();
                    }
                    this.is = new MeteredStream(this.is, progressSource, l);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) {
                messageHeader.add("content-type", "text/plain");
                messageHeader.add("access-type", "directory");
            } else {
                messageHeader.add("access-type", "file");
                String string = FtpURLConnection.guessContentTypeFromName(this.fullpath);
                if (string == null && this.is.markSupported()) {
                    string = FtpURLConnection.guessContentTypeFromStream(this.is);
                }
                if (string != null) {
                    messageHeader.add("content-type", string);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                this.cd(this.fullpath);
                this.ftp.setAsciiType();
                this.is = new FtpInputStream(this.ftp, this.ftp.list(null));
                messageHeader.add("content-type", "text/plain");
                messageHeader.add("access-type", "directory");
            }
            catch (IOException iOException) {
                FileNotFoundException fileNotFoundException2 = new FileNotFoundException(this.fullpath);
                if (this.ftp != null) {
                    try {
                        this.ftp.close();
                    }
                    catch (IOException iOException2) {
                        fileNotFoundException2.addSuppressed(iOException2);
                    }
                }
                throw fileNotFoundException2;
            }
            catch (FtpProtocolException ftpProtocolException) {
                FileNotFoundException fileNotFoundException3 = new FileNotFoundException(this.fullpath);
                if (this.ftp != null) {
                    try {
                        this.ftp.close();
                    }
                    catch (IOException iOException) {
                        fileNotFoundException3.addSuppressed(iOException);
                    }
                }
                throw fileNotFoundException3;
            }
        }
        catch (FtpProtocolException ftpProtocolException) {
            if (this.ftp != null) {
                try {
                    this.ftp.close();
                }
                catch (IOException iOException) {
                    ftpProtocolException.addSuppressed(iOException);
                }
            }
            throw new IOException(ftpProtocolException);
        }
        this.setProperties(messageHeader);
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.http != null) {
            OutputStream outputStream = this.http.getOutputStream();
            this.http.getInputStream();
            return outputStream;
        }
        if (this.is != null) {
            throw new IOException("Already opened for input");
        }
        if (this.os != null) {
            return this.os;
        }
        this.decodePath(this.url.getPath());
        if (this.filename == null || this.filename.length() == 0) {
            throw new IOException("illegal filename for a PUT");
        }
        try {
            if (this.pathname != null) {
                this.cd(this.pathname);
            }
            if (this.type == 1) {
                this.ftp.setAsciiType();
            } else {
                this.ftp.setBinaryType();
            }
            this.os = new FtpOutputStream(this.ftp, this.ftp.putFileStream(this.filename, false));
        }
        catch (FtpProtocolException ftpProtocolException) {
            throw new IOException(ftpProtocolException);
        }
        return this.os;
    }

    String guessContentTypeFromFilename(String string) {
        return FtpURLConnection.guessContentTypeFromName(string);
    }

    @Override
    public Permission getPermission() {
        if (this.permission == null) {
            int n = this.url.getPort();
            n = n < 0 ? FtpClient.defaultPort() : n;
            String string = this.host + ":" + n;
            this.permission = new SocketPermission(string, "connect");
        }
        return this.permission;
    }

    @Override
    public void setRequestProperty(String string, String string2) {
        super.setRequestProperty(string, string2);
        if ("type".equals(string)) {
            if ("i".equalsIgnoreCase(string2)) {
                this.type = 2;
            } else if ("a".equalsIgnoreCase(string2)) {
                this.type = 1;
            } else if ("d".equalsIgnoreCase(string2)) {
                this.type = 3;
            } else {
                throw new IllegalArgumentException("Value of '" + string + "' request property was '" + string2 + "' when it must be either 'i', 'a' or 'd'");
            }
        }
    }

    @Override
    public String getRequestProperty(String string) {
        String string2 = super.getRequestProperty(string);
        if (string2 == null && "type".equals(string)) {
            string2 = this.type == 1 ? "a" : (this.type == 3 ? "d" : "i");
        }
        return string2;
    }

    @Override
    public void setConnectTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.connectTimeout = n;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout < 0 ? 0 : this.connectTimeout;
    }

    @Override
    public void setReadTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("timeouts can't be negative");
        }
        this.readTimeout = n;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout < 0 ? 0 : this.readTimeout;
    }

    protected class FtpOutputStream
    extends FilterOutputStream {
        FtpClient ftp;

        FtpOutputStream(FtpClient ftpClient, OutputStream outputStream) {
            super(outputStream);
            this.ftp = ftpClient;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.ftp != null) {
                this.ftp.close();
            }
        }
    }

    protected class FtpInputStream
    extends FilterInputStream {
        FtpClient ftp;

        FtpInputStream(FtpClient ftpClient, InputStream inputStream) {
            super(new BufferedInputStream(inputStream));
            this.ftp = ftpClient;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.ftp != null) {
                this.ftp.close();
            }
        }
    }
}

