/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class Boolean
implements Serializable,
Comparable<Boolean> {
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    public static final Class<Boolean> TYPE = Class.getPrimitiveClass("boolean");
    private final boolean value;
    private static final long serialVersionUID = -3665804199014368530L;

    public Boolean(boolean bl) {
        this.value = bl;
    }

    public Boolean(String string) {
        this(Boolean.parseBoolean(string));
    }

    public static boolean parseBoolean(String string) {
        return string != null && string.equalsIgnoreCase("true");
    }

    public boolean booleanValue() {
        return this.value;
    }

    public static Boolean valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static Boolean valueOf(String string) {
        return Boolean.parseBoolean(string) ? TRUE : FALSE;
    }

    public static String toString(boolean bl) {
        return bl ? "true" : "false";
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    public static int hashCode(boolean bl) {
        return bl ? 1231 : 1237;
    }

    public boolean equals(Object object) {
        if (object instanceof Boolean) {
            return this.value == (Boolean)object;
        }
        return false;
    }

    public static boolean getBoolean(String string) {
        boolean bl = false;
        try {
            bl = Boolean.parseBoolean(System.getProperty(string));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public int compareTo(Boolean bl) {
        return Boolean.compare(this.value, bl.value);
    }

    public static int compare(boolean bl, boolean bl2) {
        return bl == bl2 ? 0 : (bl ? 1 : -1);
    }

    public static boolean logicalAnd(boolean bl, boolean bl2) {
        return bl && bl2;
    }

    public static boolean logicalOr(boolean bl, boolean bl2) {
        return bl || bl2;
    }

    public static boolean logicalXor(boolean bl, boolean bl2) {
        return bl ^ bl2;
    }
}

