#############################################################################
##
##  attributes/attr.gd
##  Copyright (C) 2013-2022                              James D. Mitchell
##
##  Licensing information can be found in the README file of this package.
##
#############################################################################
##

# This file contains declarations for attributes of semigroups.

DeclareOperation("IrredundantGeneratingSubset",
                 [IsMultiplicativeElementCollection]);

DeclareAttribute("GroupOfUnits", IsSemigroup);
DeclareAttribute("IdempotentGeneratedSubsemigroup", IsSemigroup);
DeclareAttribute("InjectionPrincipalFactor", IsGreensDClass);
DeclareAttribute("InjectionNormalizedPrincipalFactor", IsGreensDClass);
DeclareAttribute("RepresentativeOfMinimalIdeal", IsSemigroup);
DeclareOperation("RepresentativeOfMinimalIdealNC", [IsSemigroup]);
DeclareSynonymAttr("RepresentativeOfMinimalDClass",
                   RepresentativeOfMinimalIdeal);
DeclareAttribute("MinimalIdeal", IsSemigroup);
DeclareAttribute("PrincipalFactor", IsGreensDClass);
DeclareAttribute("NormalizedPrincipalFactor", IsGreensDClass);
DeclareAttribute("MultiplicativeZero", IsSemigroup);
DeclareAttribute("LengthOfLongestDClassChain", IsSemigroup);

DeclareAttribute("SmallSemigroupGeneratingSet",
                 IsMultiplicativeElementCollection);
DeclareAttribute("SmallMonoidGeneratingSet",
                 IsMultiplicativeElementWithOneCollection);
DeclareAttribute("SmallInverseSemigroupGeneratingSet",
                 IsMultiplicativeElementCollection);
DeclareAttribute("SmallInverseMonoidGeneratingSet",
                 IsMultiplicativeElementWithOneCollection);
# SmallGeneratingSet was only declared for IsGroup before GAP 4.12, so the
# next 3 lines can be removed when Semigroups requires at least GAP 4.12.
if not [FLAGS_FILTER(IsSemigroup)] in GET_OPER_FLAGS(SmallGeneratingSet) then
  DeclareAttribute("SmallGeneratingSet", IsSemigroup);
fi;

DeclareAttribute("MinimalSemigroupGeneratingSet",
                 IsSemigroup);
DeclareAttribute("MinimalMonoidGeneratingSet",
                 IsMonoid);
DeclareAttribute("MinimalInverseSemigroupGeneratingSet",
                 IsSemigroup);
DeclareAttribute("MinimalInverseMonoidGeneratingSet",
                 IsMonoid);

DeclareAttribute("SmallestElementSemigroup", IsSemigroup);
DeclareAttribute("LargestElementSemigroup", IsSemigroup);

DeclareAttribute("StructureDescription", IsBrandtSemigroup);
DeclareAttribute("StructureDescription", IsGroupAsSemigroup);
DeclareAttribute("StructureDescriptionMaximalSubgroups",
                 IsSemigroup);
DeclareAttribute("MaximalDClasses", IsSemigroup);
DeclareAttribute("MinimalDClass", IsSemigroup);
DeclareAttribute("IsGreensDGreaterThanFunc", IsSemigroup);

DeclareAttribute("UnderlyingSemigroupOfSemigroupWithAdjoinedZero",
                 IsSemigroup);

DeclareOperation("InversesOfSemigroupElementNC",
                 [IsSemigroup, IsMultiplicativeElement]);

DeclareAttribute("IndecomposableElements", IsSemigroup);
DeclareAttribute("NambooripadLeqRegularSemigroup", IsSemigroup);
DeclareAttribute("NambooripadPartialOrder", IsSemigroup);

DeclareOperation("LeftIdentity", [IsSemigroup, IsMultiplicativeElement]);
DeclareOperation("RightIdentity", [IsSemigroup, IsMultiplicativeElement]);
