/* potential-match.c generated by valac 0.56.0, the Vala compiler
 * generated from potential-match.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "folks/small-set.h"
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>

#define FOLKS_POTENTIAL_MATCH__SEPARATORS "._-+"

enum  {
	FOLKS_POTENTIAL_MATCH_0_PROPERTY,
	FOLKS_POTENTIAL_MATCH_NUM_PROPERTIES
};
static GParamSpec* folks_potential_match_properties[FOLKS_POTENTIAL_MATCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FolksPotentialMatchPrivate {
	FolksIndividual* _individual_a;
	FolksIndividual* _individual_b;
};

static gint FolksPotentialMatch_private_offset;
static gpointer folks_potential_match_parent_class = NULL;
GeeSet* folks_potential_match_known_email_aliases = NULL;
static gdouble folks_potential_match__DIST_THRESHOLD;
static gdouble folks_potential_match__DIST_THRESHOLD = 0.70;

static FolksMatchResult _folks_potential_match_inspect_im_addresses (FolksPotentialMatch* self,
                                                              FolksMatchResult old_result);
static FolksMatchResult _folks_potential_match_inspect_emails (FolksPotentialMatch* self,
                                                        FolksMatchResult old_result);
static FolksMatchResult _folks_potential_match_inspect_phone_numbers (FolksPotentialMatch* self,
                                                               FolksMatchResult old_result);
static FolksMatchResult _folks_potential_match_name_similarity (FolksPotentialMatch* self,
                                                         FolksMatchResult old_result);
static gboolean _folks_potential_match_look_alike (FolksPotentialMatch* self,
                                            const gchar* a,
                                            const gchar* b);
static gboolean _folks_potential_match_look_alike_or_identical (FolksPotentialMatch* self,
                                                         const gchar* a,
                                                         const gchar* b,
                                                         gboolean* exact);
VALA_EXTERN gboolean _folks_utils_str_equal_safe (const gchar* a,
                                      const gchar* b);
static FolksMatchResult _folks_potential_match_inc_match_level (FolksPotentialMatch* self,
                                                         FolksMatchResult current_level,
                                                         gint times);
static gboolean _folks_potential_match_check_initials_expansion (FolksPotentialMatch* self,
                                                          gchar** tokens_a,
                                                          gint tokens_a_length1,
                                                          gchar** tokens_b,
                                                          gint tokens_b_length1);
static gboolean _folks_potential_match_match_tokens (FolksPotentialMatch* self,
                                              gchar** tokens_a,
                                              gint tokens_a_length1,
                                              gchar** tokens_b,
                                              gint tokens_b_length1);
static gboolean _folks_potential_match_do_check_initials_expansion (FolksPotentialMatch* self,
                                                             gchar** expanded_name,
                                                             gint expanded_name_length1,
                                                             const gchar* initials);
static gboolean _folks_potential_match_do_match_tokens (FolksPotentialMatch* self,
                                                 gchar** bigger_set,
                                                 gint bigger_set_length1,
                                                 gchar** smaller_set,
                                                 gint smaller_set_length1);
static gunichar* _folks_potential_match_strip_string (FolksPotentialMatch* self,
                                               const gchar* s,
                                               gint* result_length1);
static gdouble _folks_potential_match_jaro_dist (FolksPotentialMatch* self,
                                          gunichar* s1,
                                          gint s1_length1,
                                          gunichar* s2,
                                          gint s2_length1);
static gint _folks_potential_match_matches (FolksPotentialMatch* self,
                                     gunichar* s1,
                                     gint s1_length1,
                                     gunichar* s2,
                                     gint s2_length1,
                                     gint max_dist,
                                     gdouble* t);
static gunichar _folks_potential_match_stripped_char (FolksPotentialMatch* self,
                                               gunichar ch);
static gint _folks_potential_match_contains (FolksPotentialMatch* self,
                                      gunichar* haystack,
                                      gint haystack_length1,
                                      gunichar c,
                                      guint pos,
                                      guint max_dist);
static void folks_potential_match_finalize (GObject * obj);
static GType folks_potential_match_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
 * Likely-ness of a potential match.
 *
 * Note that the order should be maintained.
 *
 * @since 0.5.0
 */
static GType
folks_match_result_get_type_once (void)
{
	static const GEnumValue values[] = {{FOLKS_MATCH_RESULT_NONE, "FOLKS_MATCH_RESULT_NONE", "none"}, {FOLKS_MATCH_RESULT_VERY_LOW, "FOLKS_MATCH_RESULT_VERY_LOW", "very-low"}, {FOLKS_MATCH_RESULT_LOW, "FOLKS_MATCH_RESULT_LOW", "low"}, {FOLKS_MATCH_RESULT_MEDIUM, "FOLKS_MATCH_RESULT_MEDIUM", "medium"}, {FOLKS_MATCH_RESULT_HIGH, "FOLKS_MATCH_RESULT_HIGH", "high"}, {FOLKS_MATCH_RESULT_VERY_HIGH, "FOLKS_MATCH_RESULT_VERY_HIGH", "very-high"}, {FOLKS_MATCH_RESULT_MIN, "FOLKS_MATCH_RESULT_MIN", "min"}, {FOLKS_MATCH_RESULT_MAX, "FOLKS_MATCH_RESULT_MAX", "max"}, {0, NULL, NULL}};
	GType folks_match_result_type_id;
	folks_match_result_type_id = g_enum_register_static ("FolksMatchResult", values);
	return folks_match_result_type_id;
}

GType
folks_match_result_get_type (void)
{
	static volatile gsize folks_match_result_type_id__once = 0;
	if (g_once_init_enter (&folks_match_result_type_id__once)) {
		GType folks_match_result_type_id;
		folks_match_result_type_id = folks_match_result_get_type_once ();
		g_once_init_leave (&folks_match_result_type_id__once, folks_match_result_type_id);
	}
	return folks_match_result_type_id__once;
}

static inline gpointer
folks_potential_match_get_instance_private (FolksPotentialMatch* self)
{
	return G_STRUCT_MEMBER_P (self, FolksPotentialMatch_private_offset);
}

/**
   * Create a new PotentialMatch.
   *
   * @return a new PotentialMatch
   *
   * @since 0.5.0
   */
FolksPotentialMatch*
folks_potential_match_construct (GType object_type)
{
	FolksPotentialMatch * self = NULL;
	self = (FolksPotentialMatch*) g_object_new (object_type, NULL);
	return self;
}

FolksPotentialMatch*
folks_potential_match_new (void)
{
	return folks_potential_match_construct (FOLKS_TYPE_POTENTIAL_MATCH);
}

/**
   * Whether two individuals are likely to be the same person.
   *
   * @param a an individual to compare
   * @param b another individual to compare
   *
   * @since 0.5.0
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FolksMatchResult
folks_potential_match_potential_match (FolksPotentialMatch* self,
                                       FolksIndividual* a,
                                       FolksIndividual* b)
{
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksMatchResult _result_ = 0;
	gboolean _tmp2_ = FALSE;
	FolksTrustLevel _tmp3_;
	FolksTrustLevel _tmp4_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	FolksIndividual* _tmp9_;
	FolksGender _tmp10_;
	FolksGender _tmp11_;
	FolksMatchResult result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (a);
	_g_object_unref0 (self->priv->_individual_a);
	self->priv->_individual_a = _tmp0_;
	_tmp1_ = _g_object_ref0 (b);
	_g_object_unref0 (self->priv->_individual_b);
	self->priv->_individual_b = _tmp1_;
	_result_ = FOLKS_MATCH_RESULT_MIN;
	_tmp3_ = folks_individual_get_trust_level (a);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == FOLKS_TRUST_LEVEL_NONE) {
		_tmp2_ = TRUE;
	} else {
		FolksTrustLevel _tmp5_;
		FolksTrustLevel _tmp6_;
		_tmp5_ = folks_individual_get_trust_level (b);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == FOLKS_TRUST_LEVEL_NONE;
	}
	if (_tmp2_) {
		result = _result_;
		return result;
	}
	if (folks_individual_has_anti_link_with_individual (a, b)) {
		result = _result_;
		return result;
	}
	_result_ = FOLKS_MATCH_RESULT_VERY_LOW;
	_tmp9_ = self->priv->_individual_a;
	_tmp10_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != FOLKS_GENDER_UNSPECIFIED) {
		FolksIndividual* _tmp12_;
		FolksGender _tmp13_;
		FolksGender _tmp14_;
		_tmp12_ = self->priv->_individual_b;
		_tmp13_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp8_ = _tmp14_ != FOLKS_GENDER_UNSPECIFIED;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		FolksIndividual* _tmp15_;
		FolksGender _tmp16_;
		FolksGender _tmp17_;
		FolksIndividual* _tmp18_;
		FolksGender _tmp19_;
		FolksGender _tmp20_;
		_tmp15_ = self->priv->_individual_a;
		_tmp16_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->_individual_b;
		_tmp19_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp7_ = _tmp17_ != _tmp20_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		result = _result_;
		return result;
	}
	_result_ = _folks_potential_match_inspect_im_addresses (self, _result_);
	if (_result_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	_result_ = _folks_potential_match_inspect_emails (self, _result_);
	if (_result_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	_result_ = _folks_potential_match_inspect_phone_numbers (self, _result_);
	if (_result_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	_result_ = _folks_potential_match_name_similarity (self, _result_);
	if (_result_ == FOLKS_MATCH_RESULT_MAX) {
		result = _result_;
		return result;
	}
	result = _result_;
	return result;
}

static FolksMatchResult
_folks_potential_match_inspect_phone_numbers (FolksPotentialMatch* self,
                                              FolksMatchResult old_result)
{
	GeeSet* set_a = NULL;
	FolksIndividual* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* set_b = NULL;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	FolksMatchResult result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	set_a = _tmp3_;
	_tmp4_ = self->priv->_individual_b;
	_tmp5_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	set_b = _tmp7_;
	{
		GeeIterator* _phone_fd_a_it = NULL;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp8_ = set_a;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_phone_fd_a_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			FolksPhoneFieldDetails* phone_fd_a = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			_tmp10_ = _phone_fd_a_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _phone_fd_a_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			phone_fd_a = (FolksPhoneFieldDetails*) _tmp12_;
			{
				GeeIterator* _phone_fd_b_it = NULL;
				GeeSet* _tmp13_;
				GeeIterator* _tmp14_;
				_tmp13_ = set_b;
				_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
				_phone_fd_b_it = _tmp14_;
				while (TRUE) {
					GeeIterator* _tmp15_;
					FolksPhoneFieldDetails* phone_fd_b = NULL;
					GeeIterator* _tmp16_;
					gpointer _tmp17_;
					FolksPhoneFieldDetails* _tmp18_;
					FolksPhoneFieldDetails* _tmp19_;
					_tmp15_ = _phone_fd_b_it;
					if (!gee_iterator_next (_tmp15_)) {
						break;
					}
					_tmp16_ = _phone_fd_b_it;
					_tmp17_ = gee_iterator_get (_tmp16_);
					phone_fd_b = (FolksPhoneFieldDetails*) _tmp17_;
					_tmp18_ = phone_fd_a;
					_tmp19_ = phone_fd_b;
					if (folks_abstract_field_details_values_equal ((FolksAbstractFieldDetails*) _tmp18_, (FolksAbstractFieldDetails*) _tmp19_)) {
						result = FOLKS_MATCH_RESULT_HIGH;
						_g_object_unref0 (phone_fd_b);
						_g_object_unref0 (_phone_fd_b_it);
						_g_object_unref0 (phone_fd_a);
						_g_object_unref0 (_phone_fd_a_it);
						_g_object_unref0 (set_b);
						_g_object_unref0 (set_a);
						return result;
					}
					_g_object_unref0 (phone_fd_b);
				}
				_g_object_unref0 (_phone_fd_b_it);
			}
			_g_object_unref0 (phone_fd_a);
		}
		_g_object_unref0 (_phone_fd_a_it);
	}
	result = old_result;
	_g_object_unref0 (set_b);
	_g_object_unref0 (set_a);
	return result;
}

static FolksMatchResult
_folks_potential_match_name_similarity (FolksPotentialMatch* self,
                                        FolksMatchResult old_result)
{
	gdouble similarity = 0.0;
	gboolean exact_match = FALSE;
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksIndividual* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	FolksIndividual* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	FolksIndividual* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_;
	FolksStructuredName* _a = NULL;
	FolksIndividual* _tmp41_;
	FolksStructuredName* _tmp42_;
	FolksStructuredName* _tmp43_;
	FolksStructuredName* _tmp44_;
	FolksStructuredName* _b = NULL;
	FolksIndividual* _tmp45_;
	FolksStructuredName* _tmp46_;
	FolksStructuredName* _tmp47_;
	FolksStructuredName* _tmp48_;
	gboolean _tmp49_ = FALSE;
	FolksStructuredName* _tmp50_;
	FolksMatchResult result;
	g_return_val_if_fail (self != NULL, 0);
	similarity = 0.0;
	exact_match = FALSE;
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_individual_b;
	_tmp4_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_folks_potential_match_look_alike (self, _tmp2_, _tmp5_)) {
		similarity += 0.20;
	}
	_tmp9_ = self->priv->_individual_a;
	_tmp10_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_individual_b;
	_tmp13_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp16_ = _folks_potential_match_look_alike_or_identical (self, _tmp11_, _tmp14_, &_tmp15_);
	exact_match = _tmp15_;
	if (_tmp16_) {
		_tmp8_ = TRUE;
	} else {
		FolksIndividual* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		FolksIndividual* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_;
		_tmp17_ = self->priv->_individual_a;
		_tmp18_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->_individual_b;
		_tmp21_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp24_ = _folks_potential_match_look_alike_or_identical (self, _tmp19_, _tmp22_, &_tmp23_);
		exact_match = _tmp23_;
		_tmp8_ = _tmp24_;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		FolksIndividual* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		FolksIndividual* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_;
		_tmp25_ = self->priv->_individual_a;
		_tmp26_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->_individual_b;
		_tmp29_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp32_ = _folks_potential_match_look_alike_or_identical (self, _tmp27_, _tmp30_, &_tmp31_);
		exact_match = _tmp31_;
		_tmp7_ = _tmp32_;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		FolksIndividual* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		FolksIndividual* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_;
		_tmp33_ = self->priv->_individual_a;
		_tmp34_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = self->priv->_individual_b;
		_tmp37_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp40_ = _folks_potential_match_look_alike_or_identical (self, _tmp35_, _tmp38_, &_tmp39_);
		exact_match = _tmp39_;
		_tmp6_ = _tmp40_;
	}
	if (_tmp6_) {
		similarity += 0.70;
	}
	_tmp41_ = self->priv->_individual_a;
	_tmp42_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = _g_object_ref0 (_tmp43_);
	_a = _tmp44_;
	_tmp45_ = self->priv->_individual_b;
	_tmp46_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = _g_object_ref0 (_tmp47_);
	_b = _tmp48_;
	_tmp50_ = _a;
	if (_tmp50_ != NULL) {
		FolksStructuredName* _tmp51_;
		_tmp51_ = _b;
		_tmp49_ = _tmp51_ != NULL;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		FolksStructuredName* a = NULL;
		FolksStructuredName* _tmp52_;
		FolksStructuredName* _tmp53_;
		FolksStructuredName* b = NULL;
		FolksStructuredName* _tmp54_;
		FolksStructuredName* _tmp55_;
		gboolean _tmp56_ = FALSE;
		FolksStructuredName* _tmp57_;
		FolksStructuredName* _tmp60_;
		const gchar* _tmp61_;
		const gchar* _tmp62_;
		FolksStructuredName* _tmp63_;
		const gchar* _tmp64_;
		const gchar* _tmp65_;
		gboolean _tmp66_ = FALSE;
		FolksStructuredName* _tmp67_;
		const gchar* _tmp68_;
		const gchar* _tmp69_;
		FolksStructuredName* _tmp70_;
		const gchar* _tmp71_;
		const gchar* _tmp72_;
		FolksStructuredName* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		FolksStructuredName* _tmp82_;
		const gchar* _tmp83_;
		const gchar* _tmp84_;
		FolksStructuredName* _tmp85_;
		const gchar* _tmp86_;
		const gchar* _tmp87_;
		FolksStructuredName* _tmp88_;
		const gchar* _tmp89_;
		const gchar* _tmp90_;
		FolksStructuredName* _tmp91_;
		const gchar* _tmp92_;
		const gchar* _tmp93_;
		FolksStructuredName* _tmp94_;
		const gchar* _tmp95_;
		const gchar* _tmp96_;
		_tmp52_ = _a;
		_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName));
		a = _tmp53_;
		_tmp54_ = _b;
		_tmp55_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName));
		b = _tmp55_;
		_tmp57_ = a;
		if (folks_structured_name_is_empty (_tmp57_) == FALSE) {
			FolksStructuredName* _tmp58_;
			FolksStructuredName* _tmp59_;
			_tmp58_ = a;
			_tmp59_ = b;
			_tmp56_ = folks_structured_name_equal (_tmp58_, _tmp59_);
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			result = FOLKS_MATCH_RESULT_HIGH;
			_g_object_unref0 (b);
			_g_object_unref0 (a);
			_g_object_unref0 (_b);
			_g_object_unref0 (_a);
			return result;
		}
		_tmp60_ = a;
		_tmp61_ = folks_structured_name_get_given_name (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = b;
		_tmp64_ = folks_structured_name_get_given_name (_tmp63_);
		_tmp65_ = _tmp64_;
		if (_folks_utils_str_equal_safe (_tmp62_, _tmp65_)) {
			similarity += 0.20;
		}
		_tmp67_ = a;
		_tmp68_ = folks_structured_name_get_family_name (_tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = b;
		_tmp71_ = folks_structured_name_get_family_name (_tmp70_);
		_tmp72_ = _tmp71_;
		if (_folks_potential_match_look_alike (self, _tmp69_, _tmp72_)) {
			FolksStructuredName* _tmp73_;
			const gchar* _tmp74_;
			const gchar* _tmp75_;
			FolksStructuredName* _tmp76_;
			const gchar* _tmp77_;
			const gchar* _tmp78_;
			_tmp73_ = a;
			_tmp74_ = folks_structured_name_get_given_name (_tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = b;
			_tmp77_ = folks_structured_name_get_given_name (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp66_ = _folks_potential_match_look_alike (self, _tmp75_, _tmp78_);
		} else {
			_tmp66_ = FALSE;
		}
		if (_tmp66_) {
			similarity += 0.40;
		}
		_tmp79_ = a;
		_tmp80_ = folks_structured_name_get_additional_names (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = b;
		_tmp83_ = folks_structured_name_get_additional_names (_tmp82_);
		_tmp84_ = _tmp83_;
		if (_folks_utils_str_equal_safe (_tmp81_, _tmp84_)) {
			similarity += 0.5;
		}
		_tmp85_ = a;
		_tmp86_ = folks_structured_name_get_prefixes (_tmp85_);
		_tmp87_ = _tmp86_;
		_tmp88_ = b;
		_tmp89_ = folks_structured_name_get_prefixes (_tmp88_);
		_tmp90_ = _tmp89_;
		if (_folks_utils_str_equal_safe (_tmp87_, _tmp90_)) {
			similarity += 0.5;
		}
		_tmp91_ = a;
		_tmp92_ = folks_structured_name_get_suffixes (_tmp91_);
		_tmp93_ = _tmp92_;
		_tmp94_ = b;
		_tmp95_ = folks_structured_name_get_suffixes (_tmp94_);
		_tmp96_ = _tmp95_;
		if (_folks_utils_str_equal_safe (_tmp93_, _tmp96_)) {
			similarity += 0.5;
		}
		_g_object_unref0 (b);
		_g_object_unref0 (a);
	}
	g_debug ("potential-match.vala:275: [name_similarity] Got %f\n", similarity);
	if (similarity >= folks_potential_match__DIST_THRESHOLD) {
		gint inc = 0;
		inc = 2;
		if (exact_match) {
			inc += 1;
		}
		result = _folks_potential_match_inc_match_level (self, old_result, inc);
		_g_object_unref0 (_b);
		_g_object_unref0 (_a);
		return result;
	}
	result = old_result;
	_g_object_unref0 (_b);
	_g_object_unref0 (_a);
	return result;
}

/**
   * Number of equal IM addresses between two individuals.
   *
   * This compares the addresses without comparing their associated protocols.
   *
   * @since 0.5.0
   */
static FolksMatchResult
_folks_potential_match_inspect_im_addresses (FolksPotentialMatch* self,
                                             FolksMatchResult old_result)
{
	GeeHashSet* addrs = NULL;
	GeeHashSet* _tmp0_;
	FolksMatchResult result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	addrs = _tmp0_;
	{
		GeeIterator* _im_a_it = NULL;
		FolksIndividual* _tmp1_;
		GeeMultiMap* _tmp2_;
		GeeMultiMap* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp1_ = self->priv->_individual_a;
		_tmp2_ = folks_im_details_get_im_addresses ((FolksImDetails*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_multi_map_get_values (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_im_a_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			FolksImFieldDetails* im_a = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			GeeHashSet* _tmp11_;
			FolksImFieldDetails* _tmp12_;
			gconstpointer _tmp13_;
			gconstpointer _tmp14_;
			_tmp8_ = _im_a_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _im_a_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			im_a = (FolksImFieldDetails*) _tmp10_;
			_tmp11_ = addrs;
			_tmp12_ = im_a;
			_tmp13_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp12_);
			_tmp14_ = _tmp13_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, (const gchar*) _tmp14_);
			_g_object_unref0 (im_a);
		}
		_g_object_unref0 (_im_a_it);
	}
	{
		GeeIterator* _im_b_it = NULL;
		FolksIndividual* _tmp15_;
		GeeMultiMap* _tmp16_;
		GeeMultiMap* _tmp17_;
		GeeCollection* _tmp18_;
		GeeCollection* _tmp19_;
		GeeIterator* _tmp20_;
		GeeIterator* _tmp21_;
		_tmp15_ = self->priv->_individual_b;
		_tmp16_ = folks_im_details_get_im_addresses ((FolksImDetails*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_multi_map_get_values (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = gee_iterable_iterator ((GeeIterable*) _tmp19_);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp19_);
		_im_b_it = _tmp21_;
		while (TRUE) {
			GeeIterator* _tmp22_;
			FolksImFieldDetails* im_b = NULL;
			GeeIterator* _tmp23_;
			gpointer _tmp24_;
			GeeHashSet* _tmp25_;
			FolksImFieldDetails* _tmp26_;
			gconstpointer _tmp27_;
			gconstpointer _tmp28_;
			_tmp22_ = _im_b_it;
			if (!gee_iterator_next (_tmp22_)) {
				break;
			}
			_tmp23_ = _im_b_it;
			_tmp24_ = gee_iterator_get (_tmp23_);
			im_b = (FolksImFieldDetails*) _tmp24_;
			_tmp25_ = addrs;
			_tmp26_ = im_b;
			_tmp27_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp26_);
			_tmp28_ = _tmp27_;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp25_, (const gchar*) _tmp28_) == TRUE) {
				result = FOLKS_MATCH_RESULT_HIGH;
				_g_object_unref0 (im_b);
				_g_object_unref0 (_im_b_it);
				_g_object_unref0 (addrs);
				return result;
			}
			_g_object_unref0 (im_b);
		}
		_g_object_unref0 (_im_b_it);
	}
	result = old_result;
	_g_object_unref0 (addrs);
	return result;
}

/**
   * Inspect email addresses.
   *
   * @since 0.5.0
   */
static FolksMatchResult
_folks_potential_match_inspect_emails (FolksPotentialMatch* self,
                                       FolksMatchResult old_result)
{
	GeeSet* set_a = NULL;
	FolksIndividual* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* set_b = NULL;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	FolksMatchResult _result_ = 0;
	FolksMatchResult result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	set_a = _tmp3_;
	_tmp4_ = self->priv->_individual_b;
	_tmp5_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	set_b = _tmp7_;
	_result_ = old_result;
	{
		GeeIterator* _fd_a_it = NULL;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp8_ = set_a;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_fd_a_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			FolksEmailFieldDetails* fd_a = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			gchar** email_split_a = NULL;
			FolksEmailFieldDetails* _tmp13_;
			gconstpointer _tmp14_;
			gconstpointer _tmp15_;
			gchar** _tmp16_;
			gchar** _tmp17_;
			gint email_split_a_length1;
			gint _email_split_a_size_;
			gchar** _tmp18_;
			gint _tmp18__length1;
			gchar** tokens_a = NULL;
			gchar** _tmp22_;
			gint _tmp22__length1;
			const gchar* _tmp23_;
			gchar** _tmp24_;
			gchar** _tmp25_;
			gint tokens_a_length1;
			gint _tokens_a_size_;
			_tmp10_ = _fd_a_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _fd_a_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			fd_a = (FolksEmailFieldDetails*) _tmp12_;
			_tmp13_ = fd_a;
			_tmp14_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp17_ = _tmp16_ = g_strsplit ((const gchar*) _tmp15_, "@", 0);
			email_split_a = _tmp17_;
			email_split_a_length1 = _vala_array_length (_tmp16_);
			_email_split_a_size_ = email_split_a_length1;
			_tmp18_ = email_split_a;
			_tmp18__length1 = email_split_a_length1;
			if (_tmp18__length1 < 2) {
				FolksEmailFieldDetails* _tmp19_;
				gconstpointer _tmp20_;
				gconstpointer _tmp21_;
				_tmp19_ = fd_a;
				_tmp20_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp19_);
				_tmp21_ = _tmp20_;
				g_warning ("Invalid e-mail address when looking for potential " "match: %s", (const gchar*) _tmp21_);
				email_split_a = (_vala_array_free (email_split_a, email_split_a_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (fd_a);
				continue;
			}
			_tmp22_ = email_split_a;
			_tmp22__length1 = email_split_a_length1;
			_tmp23_ = _tmp22_[0];
			_tmp25_ = _tmp24_ = g_strsplit_set (_tmp23_, FOLKS_POTENTIAL_MATCH__SEPARATORS, 0);
			tokens_a = _tmp25_;
			tokens_a_length1 = _vala_array_length (_tmp24_);
			_tokens_a_size_ = tokens_a_length1;
			{
				GeeIterator* _fd_b_it = NULL;
				GeeSet* _tmp26_;
				GeeIterator* _tmp27_;
				_tmp26_ = set_b;
				_tmp27_ = gee_iterable_iterator ((GeeIterable*) _tmp26_);
				_fd_b_it = _tmp27_;
				while (TRUE) {
					GeeIterator* _tmp28_;
					FolksEmailFieldDetails* fd_b = NULL;
					GeeIterator* _tmp29_;
					gpointer _tmp30_;
					gchar** email_split_b = NULL;
					FolksEmailFieldDetails* _tmp31_;
					gconstpointer _tmp32_;
					gconstpointer _tmp33_;
					gchar** _tmp34_;
					gchar** _tmp35_;
					gint email_split_b_length1;
					gint _email_split_b_size_;
					gchar** _tmp36_;
					gint _tmp36__length1;
					FolksEmailFieldDetails* _tmp40_;
					gconstpointer _tmp41_;
					gconstpointer _tmp42_;
					FolksEmailFieldDetails* _tmp43_;
					gconstpointer _tmp44_;
					gconstpointer _tmp45_;
					_tmp28_ = _fd_b_it;
					if (!gee_iterator_next (_tmp28_)) {
						break;
					}
					_tmp29_ = _fd_b_it;
					_tmp30_ = gee_iterator_get (_tmp29_);
					fd_b = (FolksEmailFieldDetails*) _tmp30_;
					_tmp31_ = fd_b;
					_tmp32_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp35_ = _tmp34_ = g_strsplit ((const gchar*) _tmp33_, "@", 0);
					email_split_b = _tmp35_;
					email_split_b_length1 = _vala_array_length (_tmp34_);
					_email_split_b_size_ = email_split_b_length1;
					_tmp36_ = email_split_b;
					_tmp36__length1 = email_split_b_length1;
					if (_tmp36__length1 < 2) {
						FolksEmailFieldDetails* _tmp37_;
						gconstpointer _tmp38_;
						gconstpointer _tmp39_;
						_tmp37_ = fd_b;
						_tmp38_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp37_);
						_tmp39_ = _tmp38_;
						g_warning ("Invalid e-mail address when looking for " "potential match: %s", (const gchar*) _tmp39_);
						email_split_b = (_vala_array_free (email_split_b, email_split_b_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (fd_b);
						continue;
					}
					_tmp40_ = fd_a;
					_tmp41_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = fd_b;
					_tmp44_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp43_);
					_tmp45_ = _tmp44_;
					if (g_strcmp0 ((const gchar*) _tmp42_, (const gchar*) _tmp45_) == 0) {
						GeeSet* _tmp46_;
						gchar** _tmp47_;
						gint _tmp47__length1;
						const gchar* _tmp48_;
						_tmp46_ = folks_potential_match_known_email_aliases;
						_tmp47_ = email_split_a;
						_tmp47__length1 = email_split_a_length1;
						_tmp48_ = _tmp47_[0];
						if (gee_collection_contains ((GeeCollection*) _tmp46_, _tmp48_) == TRUE) {
							if (_result_ < FOLKS_MATCH_RESULT_HIGH) {
								_result_ = FOLKS_MATCH_RESULT_LOW;
							}
						} else {
							result = FOLKS_MATCH_RESULT_HIGH;
							email_split_b = (_vala_array_free (email_split_b, email_split_b_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (fd_b);
							_g_object_unref0 (_fd_b_it);
							tokens_a = (_vala_array_free (tokens_a, tokens_a_length1, (GDestroyNotify) g_free), NULL);
							email_split_a = (_vala_array_free (email_split_a, email_split_a_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (fd_a);
							_g_object_unref0 (_fd_a_it);
							_g_object_unref0 (set_b);
							_g_object_unref0 (set_a);
							return result;
						}
					} else {
						gchar** tokens_b = NULL;
						gchar** _tmp49_;
						gint _tmp49__length1;
						const gchar* _tmp50_;
						gchar** _tmp51_;
						gchar** _tmp52_;
						gint tokens_b_length1;
						gint _tokens_b_size_;
						gchar** _tmp53_;
						gint _tmp53__length1;
						gchar** _tmp54_;
						gint _tmp54__length1;
						_tmp49_ = email_split_b;
						_tmp49__length1 = email_split_b_length1;
						_tmp50_ = _tmp49_[0];
						_tmp52_ = _tmp51_ = g_strsplit_set (_tmp50_, FOLKS_POTENTIAL_MATCH__SEPARATORS, 0);
						tokens_b = _tmp52_;
						tokens_b_length1 = _vala_array_length (_tmp51_);
						_tokens_b_size_ = tokens_b_length1;
						_tmp53_ = tokens_a;
						_tmp53__length1 = tokens_a_length1;
						_tmp54_ = tokens_b;
						_tmp54__length1 = tokens_b_length1;
						if (_folks_potential_match_check_initials_expansion (self, _tmp53_, (gint) _tmp53__length1, _tmp54_, (gint) _tmp54__length1)) {
							_result_ = FOLKS_MATCH_RESULT_MEDIUM;
						} else {
							gchar** _tmp55_;
							gint _tmp55__length1;
							gchar** _tmp56_;
							gint _tmp56__length1;
							_tmp55_ = tokens_a;
							_tmp55__length1 = tokens_a_length1;
							_tmp56_ = tokens_b;
							_tmp56__length1 = tokens_b_length1;
							if (_folks_potential_match_match_tokens (self, _tmp55_, (gint) _tmp55__length1, _tmp56_, (gint) _tmp56__length1)) {
								_result_ = FOLKS_MATCH_RESULT_MEDIUM;
							}
						}
						tokens_b = (_vala_array_free (tokens_b, tokens_b_length1, (GDestroyNotify) g_free), NULL);
					}
					email_split_b = (_vala_array_free (email_split_b, email_split_b_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (fd_b);
				}
				_g_object_unref0 (_fd_b_it);
			}
			tokens_a = (_vala_array_free (tokens_a, tokens_a_length1, (GDestroyNotify) g_free), NULL);
			email_split_a = (_vala_array_free (email_split_a, email_split_a_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (fd_a);
		}
		_g_object_unref0 (_fd_a_it);
	}
	result = _result_;
	_g_object_unref0 (set_b);
	_g_object_unref0 (set_a);
	return result;
}

static gboolean
_folks_potential_match_check_initials_expansion (FolksPotentialMatch* self,
                                                 gchar** tokens_a,
                                                 gint tokens_a_length1,
                                                 gchar** tokens_b,
                                                 gint tokens_b_length1)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (tokens_a_length1 > tokens_b_length1) {
		_tmp0_ = tokens_b_length1 == 1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_;
		_tmp1_ = tokens_b[0];
		result = _folks_potential_match_do_check_initials_expansion (self, tokens_a, (gint) tokens_a_length1, _tmp1_);
		return result;
	} else {
		gboolean _tmp2_ = FALSE;
		if (tokens_b_length1 > tokens_a_length1) {
			_tmp2_ = tokens_a_length1 == 1;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			const gchar* _tmp3_;
			_tmp3_ = tokens_a[0];
			result = _folks_potential_match_do_check_initials_expansion (self, tokens_b, (gint) tokens_b_length1, _tmp3_);
			return result;
		}
	}
	result = FALSE;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
_folks_potential_match_do_check_initials_expansion (FolksPotentialMatch* self,
                                                    gchar** expanded_name,
                                                    gint expanded_name_length1,
                                                    const gchar* initials)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (initials != NULL, FALSE);
	_tmp0_ = strlen (initials);
	_tmp1_ = _tmp0_;
	if (expanded_name_length1 != _tmp1_) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				const gchar* _tmp4_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < expanded_name_length1)) {
					break;
				}
				_tmp4_ = expanded_name[i];
				if (string_get (_tmp4_, (glong) 0) != string_get (initials, (glong) i)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
_folks_potential_match_match_tokens (FolksPotentialMatch* self,
                                     gchar** tokens_a,
                                     gint tokens_a_length1,
                                     gchar** tokens_b,
                                     gint tokens_b_length1)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (tokens_a_length1 > tokens_b_length1) {
		result = _folks_potential_match_do_match_tokens (self, tokens_a, (gint) tokens_a_length1, tokens_b, (gint) tokens_b_length1);
		return result;
	} else {
		result = _folks_potential_match_do_match_tokens (self, tokens_b, (gint) tokens_b_length1, tokens_a, (gint) tokens_a_length1);
		return result;
	}
}

static gboolean
_folks_potential_match_do_match_tokens (FolksPotentialMatch* self,
                                        gchar** bigger_set,
                                        gint bigger_set_length1,
                                        gchar** smaller_set,
                                        gint smaller_set_length1)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < smaller_set_length1)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							const gchar* _tmp4_;
							const gchar* _tmp5_;
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = j;
								j = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(j < bigger_set_length1)) {
								break;
							}
							_tmp4_ = smaller_set[i];
							_tmp5_ = bigger_set[j];
							if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static FolksMatchResult
_folks_potential_match_inc_match_level (FolksPotentialMatch* self,
                                        FolksMatchResult current_level,
                                        gint times)
{
	FolksMatchResult ret = 0;
	FolksMatchResult result;
	g_return_val_if_fail (self != NULL, 0);
	ret = current_level + times;
	if (ret > FOLKS_MATCH_RESULT_MAX) {
		ret = FOLKS_MATCH_RESULT_MAX;
	}
	result = ret;
	return result;
}

static gboolean
_folks_potential_match_look_alike_or_identical (FolksPotentialMatch* self,
                                                const gchar* a,
                                                const gchar* b,
                                                gboolean* exact)
{
	gboolean _vala_exact = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gunichar* a_stripped = NULL;
	gint _tmp3_ = 0;
	gunichar* _tmp4_;
	gint a_stripped_length1;
	gint _a_stripped_size_;
	gunichar* b_stripped = NULL;
	gint _tmp5_ = 0;
	gunichar* _tmp6_;
	gint b_stripped_length1;
	gint _b_stripped_size_;
	gdouble jaro_dist = 0.0;
	gunichar* _tmp7_;
	gint _tmp7__length1;
	gunichar* _tmp8_;
	gint _tmp8__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_exact = FALSE;
	if (a == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (a, "") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = b == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (b, "") == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		if (exact) {
			*exact = _vala_exact;
		}
		return result;
	}
	g_return_val_if_fail (g_utf8_validate (a, (gssize) -1, NULL), FALSE);
	g_return_val_if_fail (g_utf8_validate (b, (gssize) -1, NULL), FALSE);
	_tmp4_ = _folks_potential_match_strip_string (self, (const gchar*) a, &_tmp3_);
	a_stripped = _tmp4_;
	a_stripped_length1 = _tmp3_;
	_a_stripped_size_ = a_stripped_length1;
	_tmp6_ = _folks_potential_match_strip_string (self, (const gchar*) b, &_tmp5_);
	b_stripped = _tmp6_;
	b_stripped_length1 = _tmp5_;
	_b_stripped_size_ = b_stripped_length1;
	_tmp7_ = a_stripped;
	_tmp7__length1 = a_stripped_length1;
	_tmp8_ = b_stripped;
	_tmp8__length1 = b_stripped_length1;
	jaro_dist = _folks_potential_match_jaro_dist (self, _tmp7_, (gint) _tmp7__length1, _tmp8_, (gint) _tmp8__length1);
	if (jaro_dist == 1.0) {
		_vala_exact = TRUE;
		result = TRUE;
		b_stripped = (g_free (b_stripped), NULL);
		a_stripped = (g_free (a_stripped), NULL);
		if (exact) {
			*exact = _vala_exact;
		}
		return result;
	}
	result = jaro_dist >= folks_potential_match__DIST_THRESHOLD;
	b_stripped = (g_free (b_stripped), NULL);
	a_stripped = (g_free (a_stripped), NULL);
	if (exact) {
		*exact = _vala_exact;
	}
	return result;
}

static gboolean
_folks_potential_match_look_alike (FolksPotentialMatch* self,
                                   const gchar* a,
                                   const gchar* b)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gunichar* a_stripped = NULL;
	gint _tmp3_ = 0;
	gunichar* _tmp4_;
	gint a_stripped_length1;
	gint _a_stripped_size_;
	gunichar* b_stripped = NULL;
	gint _tmp5_ = 0;
	gunichar* _tmp6_;
	gint b_stripped_length1;
	gint _b_stripped_size_;
	gunichar* _tmp7_;
	gint _tmp7__length1;
	gunichar* _tmp8_;
	gint _tmp8__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (a == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (a, "") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = b == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (b, "") == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	g_return_val_if_fail (g_utf8_validate (a, (gssize) -1, NULL), FALSE);
	g_return_val_if_fail (g_utf8_validate (b, (gssize) -1, NULL), FALSE);
	_tmp4_ = _folks_potential_match_strip_string (self, (const gchar*) a, &_tmp3_);
	a_stripped = _tmp4_;
	a_stripped_length1 = _tmp3_;
	_a_stripped_size_ = a_stripped_length1;
	_tmp6_ = _folks_potential_match_strip_string (self, (const gchar*) b, &_tmp5_);
	b_stripped = _tmp6_;
	b_stripped_length1 = _tmp5_;
	_b_stripped_size_ = b_stripped_length1;
	_tmp7_ = a_stripped;
	_tmp7__length1 = a_stripped_length1;
	_tmp8_ = b_stripped;
	_tmp8__length1 = b_stripped_length1;
	result = _folks_potential_match_jaro_dist (self, _tmp7_, (gint) _tmp7__length1, _tmp8_, (gint) _tmp8__length1) >= folks_potential_match__DIST_THRESHOLD;
	b_stripped = (g_free (b_stripped), NULL);
	a_stripped = (g_free (a_stripped), NULL);
	return result;
}

static gdouble
_folks_potential_match_jaro_dist (FolksPotentialMatch* self,
                                  gunichar* s1,
                                  gint s1_length1,
                                  gunichar* s2,
                                  gint s2_length1)
{
	gdouble distance = 0.0;
	gint _tmp0_ = 0;
	gint max = 0;
	gint max_dist = 0;
	gdouble t = 0.0;
	gdouble m = 0.0;
	gdouble _tmp1_ = 0.0;
	gint _tmp2_;
	gdouble len_s1 = 0.0;
	gdouble len_s2 = 0.0;
	gdouble a = 0.0;
	gdouble b = 0.0;
	gdouble c = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (s1_length1 > s2_length1) {
		_tmp0_ = s1_length1;
	} else {
		_tmp0_ = s2_length1;
	}
	max = _tmp0_;
	max_dist = (max / 2) - 1;
	_tmp2_ = _folks_potential_match_matches (self, s1, (gint) s1_length1, s2, (gint) s2_length1, max_dist, &_tmp1_);
	t = _tmp1_;
	m = (gdouble) _tmp2_;
	len_s1 = (gdouble) s1_length1;
	len_s2 = (gdouble) s2_length1;
	a = m / len_s1;
	b = m / len_s2;
	c = (gdouble) 0;
	if (((gint) m) > 0) {
		c = (m - t) / m;
	}
	distance = (1.0 / 3.0) * ((a + b) + c);
	g_debug ("potential-match.vala:539: Jaro distance: %f (a = %f, b = %f, c = %f)", distance, a, b, c);
	result = distance;
	return result;
}

/**
   * stripped_char:
   *
   * Returns a stripped version of @ch, removing any case, accentuation
   * mark, or any special mark on it.
   *
   * Copied from Empathy's libempathy-gtk/empathy-live-search.c.
   *
   * Copyright (C) 2010 Collabora Ltd.
   * Copyright (C) 2007-2010 Nokia Corporation.
   *
   * Authors: Felix Kaser <felix.kaser@collabora.co.uk>
   *          Xavier Claessens <xavier.claessens@collabora.co.uk>
   *          Claudio Saavedra <csaavedra@igalia.com>
   */
static gunichar
_folks_potential_match_stripped_char (FolksPotentialMatch* self,
                                      gunichar ch)
{
	gunichar retval[1] = {0};
	gunichar _tmp0_[1] = {0};
	GUnicodeType utype = 0;
	gunichar _tmp1_;
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_[0] = (gunichar) 0;
	memcpy (retval, _tmp0_, 1 * sizeof (gunichar));
	utype = g_unichar_type (ch);
	switch (utype) {
		case G_UNICODE_CONTROL:
		case G_UNICODE_FORMAT:
		case G_UNICODE_UNASSIGNED:
		case G_UNICODE_NON_SPACING_MARK:
		case G_UNICODE_COMBINING_MARK:
		case G_UNICODE_ENCLOSING_MARK:
		{
			break;
		}
		case G_UNICODE_DECIMAL_NUMBER:
		case G_UNICODE_LETTER_NUMBER:
		case G_UNICODE_OTHER_NUMBER:
		case G_UNICODE_CONNECT_PUNCTUATION:
		case G_UNICODE_DASH_PUNCTUATION:
		case G_UNICODE_CLOSE_PUNCTUATION:
		case G_UNICODE_FINAL_PUNCTUATION:
		case G_UNICODE_INITIAL_PUNCTUATION:
		case G_UNICODE_OTHER_PUNCTUATION:
		case G_UNICODE_OPEN_PUNCTUATION:
		case G_UNICODE_CURRENCY_SYMBOL:
		case G_UNICODE_MODIFIER_SYMBOL:
		case G_UNICODE_MATH_SYMBOL:
		case G_UNICODE_OTHER_SYMBOL:
		case G_UNICODE_LINE_SEPARATOR:
		case G_UNICODE_PARAGRAPH_SEPARATOR:
		case G_UNICODE_SPACE_SEPARATOR:
		{
			retval[0] = (gunichar) ' ';
			break;
		}
		default:
		case G_UNICODE_PRIVATE_USE:
		case G_UNICODE_SURROGATE:
		case G_UNICODE_LOWERCASE_LETTER:
		case G_UNICODE_MODIFIER_LETTER:
		case G_UNICODE_OTHER_LETTER:
		case G_UNICODE_TITLECASE_LETTER:
		case G_UNICODE_UPPERCASE_LETTER:
		{
			ch = g_unichar_tolower (ch);
			g_unichar_fully_decompose (ch, FALSE, retval, (gint) 1);
			break;
		}
	}
	_tmp1_ = retval[0];
	result = _tmp1_;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gunichar*
_folks_potential_match_strip_string (FolksPotentialMatch* self,
                                     const gchar* s,
                                     gint* result_length1)
{
	gint next_idx = 0;
	guint write_idx = 0U;
	gunichar ch = 0U;
	gunichar* output = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gunichar* _tmp2_;
	gint output_length1;
	gint _output_size_;
	gunichar* _tmp8_;
	gint _tmp8__length1;
	gunichar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	next_idx = 0;
	write_idx = (guint) 0;
	ch = (gunichar) 0;
	_tmp0_ = strlen (s);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gunichar, _tmp1_);
	output = _tmp2_;
	output_length1 = _tmp1_;
	_output_size_ = output_length1;
	while (TRUE) {
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_;
		_tmp4_ = string_get_next_char (s, &next_idx, &_tmp3_);
		ch = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		ch = _folks_potential_match_stripped_char (self, ch);
		if (ch != ((gunichar) 0)) {
			gunichar* _tmp5_;
			gint _tmp5__length1;
			guint _tmp6_;
			gunichar _tmp7_;
			_tmp5_ = output;
			_tmp5__length1 = output_length1;
			_tmp6_ = write_idx;
			write_idx = _tmp6_ + 1;
			_tmp7_ = ch;
			_tmp5_[_tmp6_] = _tmp7_;
		}
	}
	output_length1 = (gint) write_idx;
	_tmp8_ = output;
	_tmp8__length1 = output_length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

static gint
_folks_potential_match_matches (FolksPotentialMatch* self,
                                gunichar* s1,
                                gint s1_length1,
                                gunichar* s2,
                                gint s2_length1,
                                gint max_dist,
                                gdouble* t)
{
	gdouble _vala_t = 0.0;
	gint matches = 0;
	gint len_s1 = 0;
	gunichar look_for = 0U;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	matches = 0;
	_vala_t = 0.0;
	len_s1 = s1_length1;
	look_for = (gunichar) 0;
	{
		guint idx = 0U;
		idx = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				gint contains = 0;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = idx;
					idx = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (idx < ((guint) len_s1)) {
					gunichar _tmp3_;
					_tmp3_ = s1[idx];
					look_for = _tmp3_;
					_tmp2_ = look_for != ((gunichar) 0);
				} else {
					_tmp2_ = FALSE;
				}
				if (!_tmp2_) {
					break;
				}
				contains = _folks_potential_match_contains (self, s2, (gint) s2_length1, look_for, idx, (guint) max_dist);
				if (contains >= 0) {
					gint _tmp4_;
					_tmp4_ = matches;
					matches = _tmp4_ + 1;
					if (contains > 0) {
						_vala_t = _vala_t + 1.0;
					}
				}
			}
		}
	}
	g_debug ("potential-match.vala:651: %d matches and %f / 2 transpositions", matches, _vala_t);
	_vala_t = _vala_t / 2.0;
	result = matches;
	if (t) {
		*t = _vala_t;
	}
	return result;
}

static gint
_folks_potential_match_contains (FolksPotentialMatch* self,
                                 gunichar* haystack,
                                 gint haystack_length1,
                                 gunichar c,
                                 guint pos,
                                 guint max_dist)
{
	gint haystack_len = 0;
	gboolean _tmp0_ = FALSE;
	guint idx = 0U;
	gunichar ch = 0U;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	haystack_len = haystack_length1;
	if (pos < ((guint) haystack_len)) {
		gunichar _tmp1_;
		_tmp1_ = haystack[pos];
		_tmp0_ = _tmp1_ == c;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	idx = (guint) CLAMP (((gint) pos) - ((gint) max_dist), 0, haystack_len - 1);
	ch = (gunichar) 0;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		guint _tmp5_;
		if (idx < (pos + max_dist)) {
			_tmp3_ = idx < ((guint) haystack_len);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gunichar _tmp4_;
			_tmp4_ = haystack[idx];
			ch = _tmp4_;
			_tmp2_ = ch != ((gunichar) 0);
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		if (ch == c) {
			result = abs (((gint) pos) - ((gint) idx));
			return result;
		}
		_tmp5_ = idx;
		idx = _tmp5_ + 1;
	}
	result = -1;
	return result;
}

static void
folks_potential_match_class_init (FolksPotentialMatchClass * klass,
                                  gpointer klass_data)
{
	FolksSmallSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	folks_potential_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksPotentialMatch_private_offset);
	G_OBJECT_CLASS (klass)->finalize = folks_potential_match_finalize;
	_tmp0_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	folks_potential_match_known_email_aliases = (GeeSet*) _tmp0_;
	_tmp1_ = folks_potential_match_known_email_aliases;
	gee_collection_add ((GeeCollection*) _tmp1_, "admin");
	_tmp2_ = folks_potential_match_known_email_aliases;
	gee_collection_add ((GeeCollection*) _tmp2_, "abuse");
	_tmp3_ = folks_potential_match_known_email_aliases;
	gee_collection_add ((GeeCollection*) _tmp3_, "webmaster");
}

static void
folks_potential_match_instance_init (FolksPotentialMatch * self,
                                     gpointer klass)
{
	self->priv = folks_potential_match_get_instance_private (self);
}

static void
folks_potential_match_finalize (GObject * obj)
{
	FolksPotentialMatch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatch);
	_g_object_unref0 (self->priv->_individual_a);
	_g_object_unref0 (self->priv->_individual_b);
	G_OBJECT_CLASS (folks_potential_match_parent_class)->finalize (obj);
}

/**
 * Match calculator for pairs of individuals.
 *
 * This provides functionality to explore the degree of a potential match
 * between two individuals. It compares the similarity of the individuals'
 * properties to determine how likely it is that the individuals represent the
 * same physical person.
 *
 * This can be used by folks clients to, for example, present suggestions of
 * pairs of individuals which should be linked by the user.
 *
 * @since 0.5.0
 */
static GType
folks_potential_match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksPotentialMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_potential_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPotentialMatch), 0, (GInstanceInitFunc) folks_potential_match_instance_init, NULL };
	GType folks_potential_match_type_id;
	folks_potential_match_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPotentialMatch", &g_define_type_info, 0);
	FolksPotentialMatch_private_offset = g_type_add_instance_private (folks_potential_match_type_id, sizeof (FolksPotentialMatchPrivate));
	return folks_potential_match_type_id;
}

GType
folks_potential_match_get_type (void)
{
	static volatile gsize folks_potential_match_type_id__once = 0;
	if (g_once_init_enter (&folks_potential_match_type_id__once)) {
		GType folks_potential_match_type_id;
		folks_potential_match_type_id = folks_potential_match_get_type_once ();
		g_once_init_leave (&folks_potential_match_type_id__once, folks_potential_match_type_id);
	}
	return folks_potential_match_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

