/* rygel-media-export-harvester.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-media-export-harvester.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include "rygel-media-export.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "rygel-server.h"
#include "rygel-core.h"
#include <glib/gi18n-lib.h>
#include "rygel-db.h"

#define RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD ((guint) 5)

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
typedef struct _RygelMediaExportHarvesterPrivate RygelMediaExportHarvesterPrivate;
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTER_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_harvester_properties[RYGEL_MEDIA_EXPORT_HARVESTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER (rygel_media_export_writable_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainer))
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_WRITABLE_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_WRITABLE_DB_CONTAINER, RygelMediaExportWritableDbContainerClass))

typedef struct _RygelMediaExportWritableDbContainer RygelMediaExportWritableDbContainer;
typedef struct _RygelMediaExportWritableDbContainerClass RygelMediaExportWritableDbContainerClass;
typedef struct _Block5Data Block5Data;
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTER_DONE_SIGNAL,
	RYGEL_MEDIA_EXPORT_HARVESTER_NUM_SIGNALS
};
static guint rygel_media_export_harvester_signals[RYGEL_MEDIA_EXPORT_HARVESTER_NUM_SIGNALS] = {0};

struct _RygelMediaExportHarvester {
	GObject parent_instance;
	RygelMediaExportHarvesterPrivate * priv;
};

struct _RygelMediaExportHarvesterClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvesterPrivate {
	GeeHashMap* tasks;
	GeeHashMap* extraction_grace_timers;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GCancellable* cancellable;
	GeeArrayList* _locations;
};

struct _Block5Data {
	int _ref_count_;
	RygelMediaExportHarvester* self;
	GFile* file;
};

static gint RygelMediaExportHarvester_private_offset;
static gpointer rygel_media_export_harvester_parent_class = NULL;

VALA_EXTERN GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable,
                                                             GeeArrayList* locations);
VALA_EXTERN RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type,
                                                                   GCancellable* cancellable,
                                                                   GeeArrayList* locations);
static void rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self,
                                                 GeeArrayList* value);
VALA_EXTERN GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self);
static void rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self,
                                                   GFile* file,
                                                   GFile* other,
                                                   GFileMonitorEvent event);
static void _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender,
                                                                                                      GFile* file,
                                                                                                      GFile* other_file,
                                                                                                      GFileMonitorEvent event_type,
                                                                                                      gpointer self);
VALA_EXTERN gboolean rygel_media_export_harvester_is_eligible (GFile* file,
                                                   GFileInfo* info);
VALA_EXTERN void rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self,
                                                      RygelMediaContainer* parent);
VALA_EXTERN void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self,
                                            GFile* file,
                                            RygelMediaContainer* parent);
VALA_EXTERN void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self,
                                          GFile* file);
static void rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self,
                                                     RygelStateMachine* state_machine);
static void _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender,
                                                                                    gpointer self);
static void rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self,
                                                   GFile* file,
                                                   GError** error);
static void rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self,
                                                   GFile* file);
static void rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self,
                                                 GFile* file);
VALA_EXTERN GType rygel_media_export_writable_db_container_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void rygel_media_export_writable_db_container_remove_tracked (RygelMediaExportWritableDbContainer* self,
                                                              RygelMediaObject* object,
                                                              GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda7_ (Block5Data* _data5_);
static gboolean ___lambda7__gsource_func (gpointer self);
static void rygel_media_export_harvester_finalize (GObject * obj);
static GType rygel_media_export_harvester_get_type_once (void);
static void _vala_rygel_media_export_harvester_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_rygel_media_export_harvester_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
rygel_media_export_harvester_get_instance_private (RygelMediaExportHarvester* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportHarvester_private_offset);
}

/**
     * Create a new instance of the meta-data extraction manager.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed (RygelMediaExportRecursiveFileMonitor* _sender,
                                                                                                 GFile* file,
                                                                                                 GFile* other_file,
                                                                                                 GFileMonitorEvent event_type,
                                                                                                 gpointer self)
{
	rygel_media_export_harvester_on_file_changed ((RygelMediaExportHarvester*) self, file, other_file, event_type);
}

RygelMediaExportHarvester*
rygel_media_export_harvester_construct (GType object_type,
                                        GCancellable* cancellable,
                                        GeeArrayList* locations)
{
	RygelMediaExportHarvester * self = NULL;
	GCancellable* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	RygelMediaExportRecursiveFileMonitor* _tmp13_;
	RygelMediaExportRecursiveFileMonitor* _tmp14_;
	GeeHashMap* _tmp15_;
	GeeHashMap* _tmp16_;
	g_return_val_if_fail (cancellable != NULL, NULL);
	g_return_val_if_fail (locations != NULL, NULL);
	self = (RygelMediaExportHarvester*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	_tmp1_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) g_file_equal, NULL, NULL);
	_tmp2_ = _tmp1_;
	rygel_media_export_harvester_set_locations (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	{
		GeeArrayList* _file_list = NULL;
		gint _file_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _file_index = 0;
		_file_list = locations;
		_tmp3_ = _file_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_file_size = _tmp5_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			GFile* file = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			GFile* _tmp10_;
			_file_index = _file_index + 1;
			_tmp6_ = _file_index;
			_tmp7_ = _file_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _file_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _file_index);
			file = (GFile*) _tmp9_;
			_tmp10_ = file;
			if (g_file_query_exists (_tmp10_, NULL)) {
				GeeArrayList* _tmp11_;
				GFile* _tmp12_;
				_tmp11_ = self->priv->_locations;
				_tmp12_ = file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
			}
			_g_object_unref0 (file);
		}
	}
	_tmp13_ = rygel_media_export_recursive_file_monitor_new (cancellable);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp13_;
	_tmp14_ = self->priv->monitor;
	g_signal_connect_object (_tmp14_, "changed", (GCallback) _rygel_media_export_harvester_on_file_changed_rygel_media_export_recursive_file_monitor_changed, self, 0);
	_tmp15_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tasks);
	self->priv->tasks = _tmp15_;
	_tmp16_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_UINT, NULL, NULL, (GeeHashDataFunc) g_file_hash, NULL, NULL, (GeeEqualDataFunc) g_file_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->extraction_grace_timers);
	self->priv->extraction_grace_timers = _tmp16_;
	return self;
}

RygelMediaExportHarvester*
rygel_media_export_harvester_new (GCancellable* cancellable,
                                  GeeArrayList* locations)
{
	return rygel_media_export_harvester_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, cancellable, locations);
}

/**
     * Check if a FileInfo is considered for extraction
     *
     * @param info a FileInfo
     * @return true if file should be extracted, false otherwise
     */
gboolean
rygel_media_export_harvester_is_eligible (GFile* file,
                                          GFileInfo* info)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean is_supported_content_type = FALSE;
	RygelMediaExportMediaCache* cache = NULL;
	RygelMediaExportMediaCache* _tmp15_;
	gboolean is_ignored = FALSE;
	RygelMediaExportMediaCache* _tmp16_;
	gboolean _tmp19_ = FALSE;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp7_ = g_file_info_get_content_type (info);
	if (g_str_has_prefix (_tmp7_, "image/")) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = g_file_info_get_content_type (info);
		_tmp6_ = g_str_has_prefix (_tmp8_, "video/");
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = g_file_info_get_content_type (info);
		_tmp5_ = g_str_has_prefix (_tmp9_, "audio/");
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = g_file_info_get_content_type (info);
		_tmp4_ = g_strcmp0 (_tmp10_, "application/ogg") == 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = g_file_info_get_content_type (info);
		_tmp3_ = g_strcmp0 (_tmp11_, "application/xml") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = g_file_info_get_content_type (info);
		_tmp2_ = g_strcmp0 (_tmp12_, "text/xml") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = g_file_info_get_content_type (info);
		_tmp1_ = g_strcmp0 (_tmp13_, "text/plain") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp14_;
		_tmp14_ = g_file_info_get_content_type (info);
		_tmp0_ = g_strcmp0 (_tmp14_, "application/x-cd-image") == 0;
	}
	is_supported_content_type = _tmp0_;
	_tmp15_ = rygel_media_export_media_cache_get_default ();
	cache = _tmp15_;
	_tmp16_ = cache;
	is_ignored = rygel_media_export_media_cache_is_ignored (_tmp16_, file);
	if (is_ignored) {
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = g_file_get_uri (file);
		_tmp18_ = _tmp17_;
		g_debug ("rygel-media-export-harvester.vala:83: URI %s is not eligible due, it i" \
"s ignored", _tmp18_);
		_g_free0 (_tmp18_);
	}
	if (is_supported_content_type) {
		_tmp19_ = !is_ignored;
	} else {
		_tmp19_ = FALSE;
	}
	result = _tmp19_;
	_g_object_unref0 (cache);
	return result;
}

/**
     * Schedule rescan of all top-level locations known to the harvester.
     *
     * @param parent top-level container of the files
     */
void
rygel_media_export_harvester_schedule_locations (RygelMediaExportHarvester* self,
                                                 RygelMediaContainer* parent)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	{
		GeeArrayList* _file_list = NULL;
		GeeArrayList* _tmp0_;
		gint _file_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _file_index = 0;
		_tmp0_ = self->priv->_locations;
		_file_list = _tmp0_;
		_tmp1_ = _file_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_file_size = _tmp3_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GFile* file = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GFile* _tmp8_;
			_file_index = _file_index + 1;
			_tmp4_ = _file_index;
			_tmp5_ = _file_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _file_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _file_index);
			file = (GFile*) _tmp7_;
			_tmp8_ = file;
			rygel_media_export_harvester_schedule (self, _tmp8_, parent);
			_g_object_unref0 (file);
		}
	}
}

/**
     * Put a file on queue for meta-data extraction
     *
     * @param file the file to investigate
     * @param parent container of the filer to be harvested
     */
static void
_rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed (RygelStateMachine* _sender,
                                                                               gpointer self)
{
	rygel_media_export_harvester_on_file_harvested ((RygelMediaExportHarvester*) self, _sender);
}

void
rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self,
                                       GFile* file,
                                       RygelMediaContainer* parent)
{
	GeeHashMap* _tmp0_;
	RygelMediaExportHarvestingTask* task = NULL;
	RygelMediaExportRecursiveFileMonitor* _tmp1_;
	RygelMediaExportHarvestingTask* _tmp2_;
	GCancellable* _tmp3_;
	GeeHashMap* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = self->priv->extraction_grace_timers;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, file, NULL);
	rygel_media_export_harvester_cancel (self, file);
	_tmp1_ = self->priv->monitor;
	_tmp2_ = rygel_media_export_harvesting_task_new (_tmp1_, file, parent);
	task = _tmp2_;
	_tmp3_ = self->priv->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) task, _tmp3_);
	g_signal_connect_object ((RygelStateMachine*) task, "completed", (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self, 0);
	_tmp4_ = self->priv->tasks;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, file, task);
	rygel_state_machine_run ((RygelStateMachine*) task, NULL, NULL);
	_g_object_unref0 (task);
}

/**
     * Cancel a running meta-data extraction run
     *
     * @param file file cancel the current run for
     */
void
rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self,
                                     GFile* file)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->tasks;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, file)) {
		RygelMediaExportHarvestingTask* task = NULL;
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		RygelMediaExportHarvestingTask* _tmp3_;
		guint _tmp4_;
		GeeHashMap* _tmp5_;
		RygelMediaExportHarvestingTask* _tmp6_;
		_tmp1_ = self->priv->tasks;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, file);
		task = (RygelMediaExportHarvestingTask*) _tmp2_;
		_tmp3_ = task;
		g_signal_parse_name ("completed", RYGEL_TYPE_STATE_MACHINE, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((RygelStateMachine*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _rygel_media_export_harvester_on_file_harvested_rygel_state_machine_completed, self);
		_tmp5_ = self->priv->tasks;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, file, NULL);
		_tmp6_ = task;
		rygel_media_export_harvesting_task_cancel (_tmp6_);
		_g_object_unref0 (task);
	}
}

/**
     * Callback for finished harvester.
     *
     * Updates book-keeping hash.
     * @param state_machine HarvestingTask sending the event
     */
static void
rygel_media_export_harvester_on_file_harvested (RygelMediaExportHarvester* self,
                                                RygelStateMachine* state_machine)
{
	RygelMediaExportHarvestingTask* task = NULL;
	RygelMediaExportHarvestingTask* _tmp0_;
	GFile* file = NULL;
	RygelMediaExportHarvestingTask* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GeeHashMap* _tmp7_;
	GFile* _tmp8_;
	GeeHashMap* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state_machine != NULL);
	_tmp0_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK (state_machine) ? ((RygelMediaExportHarvestingTask*) state_machine) : NULL);
	task = _tmp0_;
	_tmp1_ = task;
	_tmp2_ = _tmp1_->origin;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	file = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = g_file_get_uri (_tmp4_);
	_tmp6_ = _tmp5_;
	g_message (_ ("“%s” harvested"), _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->tasks;
	_tmp8_ = file;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, _tmp8_, NULL);
	_tmp9_ = self->priv->tasks;
	_tmp10_ = gee_map_get_is_empty ((GeeMap*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		g_signal_emit (self, rygel_media_export_harvester_signals[RYGEL_MEDIA_EXPORT_HARVESTER_DONE_SIGNAL], 0);
	}
	_g_object_unref0 (file);
	_g_object_unref0 (task);
}

static void
rygel_media_export_harvester_on_file_changed (RygelMediaExportHarvester* self,
                                              GFile* file,
                                              GFile* other,
                                              GFileMonitorEvent event)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	{
		switch (event) {
			case G_FILE_MONITOR_EVENT_CREATED:
			{
				{
					GFileInfo* info = NULL;
					GCancellable* _tmp0_;
					GFileInfo* _tmp1_;
					GFileInfo* _tmp2_;
					_tmp0_ = self->priv->cancellable;
					_tmp1_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, _tmp0_, &_inner_error0_);
					info = _tmp1_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp2_ = info;
					if (g_file_info_get_file_type (_tmp2_) == G_FILE_TYPE_DIRECTORY) {
						rygel_media_export_harvester_on_changes_done (self, file, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (info);
							goto __catch0_g_error;
						}
					}
					_g_object_unref0 (info);
					break;
				}
			}
			case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
			{
				rygel_media_export_harvester_on_changes_done (self, file, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case G_FILE_MONITOR_EVENT_DELETED:
			{
				rygel_media_export_harvester_on_file_removed (self, file);
				break;
			}
			default:
			{
				break;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = g_file_get_uri (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_debug ("rygel-media-export-harvester.vala:179: Failed to query information for" \
" %s: %s", _tmp4_, _tmp6_);
		_g_free0 (_tmp4_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
rygel_media_export_harvester_on_file_added (RygelMediaExportHarvester* self,
                                            GFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	g_debug ("rygel-media-export-harvester.vala:186: Filesystem events settled for %" \
"s, scheduling extraction…", _tmp1_);
	_g_free0 (_tmp1_);
	{
		RygelMediaExportMediaCache* cache = NULL;
		RygelMediaExportMediaCache* _tmp2_;
		GFileInfo* info = NULL;
		GCancellable* _tmp3_;
		GFileInfo* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp2_ = rygel_media_export_media_cache_get_default ();
		cache = _tmp2_;
		_tmp3_ = self->priv->cancellable;
		_tmp4_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, _tmp3_, &_inner_error0_);
		info = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (cache);
			goto __catch0_g_error;
		}
		if (g_file_info_get_file_type (info) == G_FILE_TYPE_DIRECTORY) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = rygel_media_export_harvester_is_eligible (file, info);
		}
		if (_tmp5_) {
			gchar* id = NULL;
			GFile* _tmp6_;
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp6_ = g_file_get_parent (file);
			_tmp7_ = _tmp6_;
			_tmp8_ = rygel_media_export_media_cache_get_id (_tmp7_);
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp7_);
			id = _tmp9_;
			{
				RygelMediaObject* _tmp10_ = NULL;
				const gchar* _tmp11_;
				RygelMediaObject* _tmp12_;
				RygelMediaContainer* parent_container = NULL;
				RygelMediaContainer* _tmp13_;
				RygelMediaContainer* _tmp14_;
				_tmp11_ = id;
				_tmp12_ = rygel_media_export_media_cache_get_object (cache, _tmp11_, &_inner_error0_);
				_tmp10_ = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch1_rygel_database_database_error;
					}
					_g_free0 (id);
					_g_object_unref0 (info);
					_g_object_unref0 (cache);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp10_) : NULL);
				parent_container = _tmp13_;
				_tmp14_ = parent_container;
				rygel_media_export_harvester_schedule (self, file, _tmp14_);
				_g_object_unref0 (parent_container);
				_g_object_unref0 (_tmp10_);
			}
			goto __finally1;
			__catch1_rygel_database_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp15_;
				GError* _tmp16_;
				const gchar* _tmp17_;
				_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp15_ = id;
				_tmp16_ = _error_;
				_tmp17_ = _tmp16_->message;
				g_warning (_ ("Error fetching object “%s” from database: %s"), _tmp15_, _tmp17_);
				_g_error_free0 (_error_);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (id);
				_g_object_unref0 (info);
				_g_object_unref0 (cache);
				goto __catch0_g_error;
			}
			_g_free0 (id);
		} else {
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = g_file_get_uri (file);
			_tmp19_ = _tmp18_;
			g_debug ("rygel-media-export-harvester.vala:207: %s is not eligible for extracti" \
"on", _tmp19_);
			_g_free0 (_tmp19_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (cache);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GError* _tmp22_;
		const gchar* _tmp23_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = g_file_get_uri (file);
		_tmp21_ = _tmp20_;
		_tmp22_ = _error_;
		_tmp23_ = _tmp22_->message;
		g_warning (_ ("Failed to query info of a file %s: %s"), _tmp21_, _tmp23_);
		_g_free0 (_tmp21_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
rygel_media_export_harvester_on_file_removed (RygelMediaExportHarvester* self,
                                              GFile* file)
{
	RygelMediaExportMediaCache* cache = NULL;
	RygelMediaExportMediaCache* _tmp0_;
	GeeHashMap* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = rygel_media_export_media_cache_get_default ();
	cache = _tmp0_;
	_tmp1_ = self->priv->extraction_grace_timers;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, file)) {
		GeeHashMap* _tmp2_;
		gpointer _tmp3_;
		GeeHashMap* _tmp4_;
		_tmp2_ = self->priv->extraction_grace_timers;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, file);
		g_source_remove ((guint) ((guintptr) _tmp3_));
		_tmp4_ = self->priv->extraction_grace_timers;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp4_, file, NULL);
	}
	rygel_media_export_harvester_cancel (self, file);
	{
		gchar* id = NULL;
		gchar* _tmp5_;
		RygelMediaObject* object = NULL;
		RygelMediaExportMediaCache* _tmp6_;
		const gchar* _tmp7_;
		RygelMediaObject* _tmp8_;
		gboolean _tmp9_ = FALSE;
		RygelMediaObject* _tmp10_;
		_tmp5_ = rygel_media_export_media_cache_get_id (file);
		id = _tmp5_;
		_tmp6_ = cache;
		_tmp7_ = id;
		_tmp8_ = rygel_media_export_media_cache_get_object (_tmp6_, _tmp7_, &_inner_error0_);
		object = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (id);
			goto __catch0_g_error;
		}
		_tmp10_ = object;
		if (_tmp10_ != NULL) {
			RygelMediaObject* _tmp11_;
			RygelMediaContainer* _tmp12_;
			RygelMediaContainer* _tmp13_;
			_tmp11_ = object;
			_tmp12_ = rygel_media_object_get_parent (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp9_ = _tmp13_ != NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			RygelMediaContainer* parent = NULL;
			RygelMediaObject* _tmp14_;
			RygelMediaContainer* _tmp15_;
			RygelMediaContainer* _tmp16_;
			RygelMediaContainer* _tmp17_;
			RygelMediaContainer* _tmp18_;
			_tmp14_ = object;
			_tmp15_ = rygel_media_object_get_parent (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _g_object_ref0 (_tmp16_);
			parent = _tmp17_;
			_tmp18_ = parent;
			if (RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER (_tmp18_)) {
				RygelMediaExportWritableDbContainer* container = NULL;
				RygelMediaContainer* _tmp19_;
				RygelMediaExportWritableDbContainer* _tmp20_;
				RygelMediaExportWritableDbContainer* _tmp21_;
				RygelMediaObject* _tmp22_;
				_tmp19_ = parent;
				_tmp20_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_WRITABLE_DB_CONTAINER (_tmp19_) ? ((RygelMediaExportWritableDbContainer*) _tmp19_) : NULL);
				container = _tmp20_;
				_tmp21_ = container;
				_tmp22_ = object;
				rygel_media_export_writable_db_container_remove_tracked (_tmp21_, _tmp22_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (container);
					_g_object_unref0 (parent);
					_g_object_unref0 (object);
					_g_free0 (id);
					goto __catch0_g_error;
				}
				_g_object_unref0 (container);
			} else {
				RygelMediaContainer* _tmp23_;
				_tmp23_ = parent;
				if (RYGEL_MEDIA_EXPORT_IS_TRACKABLE_DB_CONTAINER (_tmp23_)) {
					RygelTrackableContainer* container = NULL;
					RygelMediaContainer* _tmp24_;
					RygelTrackableContainer* _tmp25_;
					RygelTrackableContainer* _tmp26_;
					RygelMediaObject* _tmp27_;
					_tmp24_ = parent;
					_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, RYGEL_TYPE_TRACKABLE_CONTAINER) ? ((RygelTrackableContainer*) _tmp24_) : NULL);
					container = _tmp25_;
					_tmp26_ = container;
					_tmp27_ = object;
					rygel_trackable_container_remove_child_tracked (_tmp26_, _tmp27_, NULL, NULL);
					_g_object_unref0 (container);
				}
			}
			_g_object_unref0 (parent);
		} else {
			const gchar* _tmp28_;
			_tmp28_ = id;
			g_warning (_ ("Could not find object %s or its parent. Database is inconsistent"), _tmp28_);
		}
		_g_object_unref0 (object);
		_g_free0 (id);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = _error_;
		_tmp30_ = _tmp29_->message;
		g_warning (_ ("Error removing object from database: %s"), _tmp30_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (cache);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (cache);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		RygelMediaExportHarvester* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->file);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda7_ (Block5Data* _data5_)
{
	RygelMediaExportHarvester* self;
	gboolean result;
	self = _data5_->self;
	rygel_media_export_harvester_on_file_added (self, _data5_->file);
	result = FALSE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ (self);
	return result;
}

static void
rygel_media_export_harvester_on_changes_done (RygelMediaExportHarvester* self,
                                              GFile* file,
                                              GError** error)
{
	Block5Data* _data5_;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	guint period = 0U;
	GeeHashMap* _tmp7_;
	GSourceFunc callback = NULL;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data5_->file);
	_data5_->file = _tmp0_;
	_tmp1_ = g_file_get_basename (_data5_->file);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_str_has_prefix (_tmp2_, ".");
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	period = RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp4_;
		gint _tmp5_ = 0;
		RygelMetaConfig* _tmp6_;
		_tmp4_ = rygel_meta_config_get_default ();
		config = _tmp4_;
		_tmp6_ = config;
		_tmp5_ = rygel_configuration_get_int ((RygelConfiguration*) _tmp6_, "MediaExport", "monitor-grace-timeout", 0, 500, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		period = (guint) _tmp5_;
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp7_ = self->priv->extraction_grace_timers;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, _data5_->file)) {
		GeeHashMap* _tmp8_;
		gpointer _tmp9_;
		_tmp8_ = self->priv->extraction_grace_timers;
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, _data5_->file);
		g_source_remove ((guint) ((guintptr) _tmp9_));
	} else {
		if (period > ((guint) 0)) {
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = g_file_get_uri (_data5_->file);
			_tmp11_ = _tmp10_;
			g_debug ("rygel-media-export-harvester.vala:272: Starting grace timer for harves" \
"ting %s…", _tmp11_);
			_g_free0 (_tmp11_);
		}
	}
	callback = ___lambda7__gsource_func;
	callback_target = block5_data_ref (_data5_);
	callback_target_destroy_notify = block5_data_unref;
	if (period > ((guint) 0)) {
		guint timeout = 0U;
		GSourceFunc _tmp12_;
		gpointer _tmp12__target;
		GDestroyNotify _tmp12__target_destroy_notify;
		GeeHashMap* _tmp13_;
		_tmp12_ = callback;
		_tmp12__target = callback_target;
		_tmp12__target_destroy_notify = callback_target_destroy_notify;
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, RYGEL_MEDIA_EXPORT_HARVESTER_FILE_CHANGE_DEFAULT_GRACE_PERIOD, _tmp12_, _tmp12__target, _tmp12__target_destroy_notify);
		_tmp13_ = self->priv->extraction_grace_timers;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _data5_->file, (gpointer) ((guintptr) timeout));
	} else {
		GSourceFunc _tmp14_;
		gpointer _tmp14__target;
		GDestroyNotify _tmp14__target_destroy_notify;
		_tmp14_ = callback;
		_tmp14__target = callback_target;
		_tmp14__target_destroy_notify = callback_target_destroy_notify;
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp14_, _tmp14__target, _tmp14__target_destroy_notify);
	}
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

GeeArrayList*
rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_locations;
	result = _tmp0_;
	return result;
}

static void
rygel_media_export_harvester_set_locations (RygelMediaExportHarvester* self,
                                            GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_media_export_harvester_get_locations (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_locations);
		self->priv->_locations = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_media_export_harvester_properties[RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS_PROPERTY]);
	}
}

static void
rygel_media_export_harvester_class_init (RygelMediaExportHarvesterClass * klass,
                                         gpointer klass_data)
{
	rygel_media_export_harvester_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaExportHarvester_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvester_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvester_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvester_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS_PROPERTY, rygel_media_export_harvester_properties[RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS_PROPERTY] = g_param_spec_object ("locations", "locations", "locations", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	rygel_media_export_harvester_signals[RYGEL_MEDIA_EXPORT_HARVESTER_DONE_SIGNAL] = g_signal_new ("done", RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
rygel_media_export_harvester_instance_init (RygelMediaExportHarvester * self,
                                            gpointer klass)
{
	self->priv = rygel_media_export_harvester_get_instance_private (self);
}

static void
rygel_media_export_harvester_finalize (GObject * obj)
{
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	_g_object_unref0 (self->priv->tasks);
	_g_object_unref0 (self->priv->extraction_grace_timers);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->_locations);
	G_OBJECT_CLASS (rygel_media_export_harvester_parent_class)->finalize (obj);
}

/**
 * This class takes care of the book-keeping of running and finished
 * extraction tasks running within the media-export plugin
 */
static GType
rygel_media_export_harvester_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvester), 0, (GInstanceInitFunc) rygel_media_export_harvester_instance_init, NULL };
	GType rygel_media_export_harvester_type_id;
	rygel_media_export_harvester_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvester", &g_define_type_info, 0);
	RygelMediaExportHarvester_private_offset = g_type_add_instance_private (rygel_media_export_harvester_type_id, sizeof (RygelMediaExportHarvesterPrivate));
	return rygel_media_export_harvester_type_id;
}

GType
rygel_media_export_harvester_get_type (void)
{
	static volatile gsize rygel_media_export_harvester_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_export_harvester_type_id__once)) {
		GType rygel_media_export_harvester_type_id;
		rygel_media_export_harvester_type_id = rygel_media_export_harvester_get_type_once ();
		g_once_init_leave (&rygel_media_export_harvester_type_id__once, rygel_media_export_harvester_type_id);
	}
	return rygel_media_export_harvester_type_id__once;
}

static void
_vala_rygel_media_export_harvester_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS_PROPERTY:
		g_value_set_object (value, rygel_media_export_harvester_get_locations (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_media_export_harvester_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	RygelMediaExportHarvester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester);
	switch (property_id) {
		case RYGEL_MEDIA_EXPORT_HARVESTER_LOCATIONS_PROPERTY:
		rygel_media_export_harvester_set_locations (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

