
// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyfalkon_python.h"

// main header
#include "mainapplication_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void MainApplicationWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::MainApplication::AfterLaunch >("MainApplication::AfterLaunch");
}

void MainApplicationWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

void MainApplicationWrapper::childEvent(QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void MainApplicationWrapper::connectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void MainApplicationWrapper::customEvent(QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void MainApplicationWrapper::disconnectNotify(const QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool MainApplicationWrapper::event(QEvent * arg__1)
{
    if (m_PyMethodCache[4])
        return this->::QApplication::event(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QApplication::event(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "MainApplication.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool MainApplicationWrapper::eventFilter(QObject * watched, QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "MainApplication.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool MainApplicationWrapper::notify(QObject * arg__1, QEvent * arg__2)
{
    if (m_PyMethodCache[7])
        return this->::QApplication::notify(arg__1, arg__2);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "notify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QApplication::notify(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "MainApplication.notify", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void MainApplicationWrapper::timerEvent(QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *MainApplicationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return MainApplication::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int MainApplicationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = MainApplication::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *MainApplicationWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< MainApplicationWrapper *>(this));
        return MainApplication::qt_metacast(_clname);
}

MainApplicationWrapper::~MainApplicationWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_MainApplicationFunc_addNewTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.addNewTab";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_MainApplicationFunc_addNewTab_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:addNewTab", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: MainApplication::addNewTab(QUrl)
    if (numArgs == 0) {
        overloadId = 0; // addNewTab(QUrl)
    } else if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        overloadId = 0; // addNewTab(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_MainApplicationFunc_addNewTab_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_url = Shiboken::String::createStaticString("url");
            if (PyDict_Contains(kwds, key_url)) {
                value = PyDict_GetItem(kwds, key_url);
                if (value && pyArgs[0]) {
                    errInfo = key_url;
                    Py_INCREF(errInfo);
                    goto Sbk_MainApplicationFunc_addNewTab_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0]))))
                        goto Sbk_MainApplicationFunc_addNewTab_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_url);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_MainApplicationFunc_addNewTab_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local = QUrl();
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // addNewTab(QUrl)
            cppSelf->addNewTab(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_MainApplicationFunc_addNewTab_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_MainApplicationFunc_afterLaunch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.afterLaunch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // afterLaunch()const
            MainApplication::AfterLaunch cppResult = MainApplication::AfterLaunch(const_cast<const ::MainApplicationWrapper *>(cppSelf)->afterLaunch());
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_autoFill(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.autoFill";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoFill()
            AutoFill * cppResult = cppSelf->autoFill();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_AUTOFILL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_bookmarks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.bookmarks";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bookmarks()
            Bookmarks * cppResult = cppSelf->bookmarks();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BOOKMARKS_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_changeOccurred(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.changeOccurred";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // changeOccurred()
            cppSelf->changeOccurred();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_MainApplicationFunc_cookieJar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.cookieJar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cookieJar()
            CookieJar * cppResult = cppSelf->cookieJar();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_COOKIEJAR_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_createWindow(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.createWindow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_MainApplicationFunc_createWindow_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_MainApplicationFunc_createWindow_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:createWindow", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: MainApplication::createWindow(Qz::BrowserWindowType,QUrl)
    if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPyFalkonTypes[SBK_QZ_BROWSERWINDOWTYPE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // createWindow(Qz::BrowserWindowType,QUrl)
        } else if ((pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            overloadId = 0; // createWindow(Qz::BrowserWindowType,QUrl)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_MainApplicationFunc_createWindow_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_startUrl = Shiboken::String::createStaticString("startUrl");
            if (PyDict_Contains(kwds, key_startUrl)) {
                value = PyDict_GetItem(kwds, key_startUrl);
                if (value && pyArgs[1]) {
                    errInfo = key_startUrl;
                    Py_INCREF(errInfo);
                    goto Sbk_MainApplicationFunc_createWindow_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1]))))
                        goto Sbk_MainApplicationFunc_createWindow_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_startUrl);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_MainApplicationFunc_createWindow_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        ::Qz::BrowserWindowType cppArg0{Qz::BW_FirstAppWindow};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local = QUrl();
        ::QUrl *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // createWindow(Qz::BrowserWindowType,QUrl)
            BrowserWindow * cppResult = cppSelf->createWindow(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BROWSERWINDOW_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_MainApplicationFunc_createWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_MainApplicationFunc_desktopNotifications(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.desktopNotifications";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // desktopNotifications()
            DesktopNotificationsFactory * cppResult = cppSelf->desktopNotifications();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_DESKTOPNOTIFICATIONSFACTORY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_destroyRestoreManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.destroyRestoreManager";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destroyRestoreManager()
            cppSelf->destroyRestoreManager();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_MainApplicationFunc_downloadManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.downloadManager";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // downloadManager()
            DownloadManager * cppResult = cppSelf->downloadManager();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_DOWNLOADMANAGER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_getWindow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.getWindow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getWindow()const
            BrowserWindow * cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->getWindow();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_BROWSERWINDOW_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_history(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.history";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // history()
            History * cppResult = cppSelf->history();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_HISTORY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_instance(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.instance";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // instance()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-instance)]
            PyObject *pyApp = Py_None;
            if (qApp) {
                pyApp = reinterpret_cast<PyObject *>(
                    Shiboken::BindingManager::instance().retrieveWrapper(qApp));
                if (!pyApp)
                    pyApp = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCOREAPPLICATION_IDX]), qApp);
                    // this will keep app live after python exit (extra ref)
            }
            // PYSIDE-571: make sure that we return the singleton "None"
            if (Py_TYPE(pyApp) == Py_TYPE(Py_None))
                Py_DECREF(MakeQAppWrapper(nullptr));
            pyResult = pyApp;
            Py_XINCREF(pyResult);
            // END of custom code block [file: ../glue/qtcore.cpp (qcoreapplication-instance)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_isClosing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.isClosing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isClosing()const
            bool cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->isClosing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_isPortable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.isPortable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPortable()const
            bool cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->isPortable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_isPrivate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.isPrivate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isPrivate()const
            bool cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->isPrivate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_isStartingAfterCrash(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.isStartingAfterCrash";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isStartingAfterCrash()const
            bool cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->isStartingAfterCrash();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_isTestModeEnabled(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.isTestModeEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTestModeEnabled()
            bool cppResult = ::MainApplication::isTestModeEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_messageReceived(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.messageReceived";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QtSingleApplication::messageReceived(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // messageReceived(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_MainApplicationFunc_messageReceived_TypeError;

    // Call function/method
    {
        PyErr_Format(PyExc_TypeError, "%s is a private method.", "messageReceived(const QString & message)");
        return {};
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_MainApplicationFunc_messageReceived_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_MainApplicationFunc_networkManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.networkManager";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // networkManager()
            NetworkManager * cppResult = cppSelf->networkManager();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_NETWORKMANAGER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_plugins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.plugins";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // plugins()
            PluginProxy * cppResult = cppSelf->plugins();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_PLUGINPROXY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_quitApplication(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.quitApplication";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // quitApplication()
            cppSelf->quitApplication();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_MainApplicationFunc_reloadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.reloadSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reloadSettings()
            cppSelf->reloadSettings();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_MainApplicationFunc_reloadUserStyleSheet(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.reloadUserStyleSheet";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reloadUserStyleSheet()
            cppSelf->reloadUserStyleSheet();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_MainApplicationFunc_restoreOverrideCursor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.restoreOverrideCursor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // restoreOverrideCursor()
            cppSelf->restoreOverrideCursor();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_MainApplicationFunc_saveState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.saveState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // saveState()const
            QByteArray cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->saveState();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_searchEnginesManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.searchEnginesManager";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // searchEnginesManager()
            SearchEnginesManager * cppResult = cppSelf->searchEnginesManager();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_SEARCHENGINESMANAGER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_setTestModeEnabled(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.setTestModeEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static MainApplication::setTestModeEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setTestModeEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_MainApplicationFunc_setTestModeEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTestModeEnabled(bool)
            ::MainApplication::setTestModeEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_MainApplicationFunc_setTestModeEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_MainApplicationFunc_startPrivateBrowsing(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.startPrivateBrowsing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_MainApplicationFunc_startPrivateBrowsing_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:startPrivateBrowsing", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: MainApplication::startPrivateBrowsing(QUrl)
    if (numArgs == 0) {
        overloadId = 0; // startPrivateBrowsing(QUrl)
    } else if ((pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        overloadId = 0; // startPrivateBrowsing(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_MainApplicationFunc_startPrivateBrowsing_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            PyObject *kwds_dup = PyDict_Copy(kwds);
            static PyObject *const key_startUrl = Shiboken::String::createStaticString("startUrl");
            if (PyDict_Contains(kwds, key_startUrl)) {
                value = PyDict_GetItem(kwds, key_startUrl);
                if (value && pyArgs[0]) {
                    errInfo = key_startUrl;
                    Py_INCREF(errInfo);
                    goto Sbk_MainApplicationFunc_startPrivateBrowsing_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0]))))
                        goto Sbk_MainApplicationFunc_startPrivateBrowsing_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_startUrl);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup;
                goto Sbk_MainApplicationFunc_startPrivateBrowsing_TypeError;
            } else {
                Py_DECREF(kwds_dup);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local = QUrl();
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // startPrivateBrowsing(QUrl)
            cppSelf->startPrivateBrowsing(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_MainApplicationFunc_startPrivateBrowsing_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_MainApplicationFunc_styleName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.styleName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // styleName()const
            QString cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->styleName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_webProfile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.webProfile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // webProfile()const
            QWebEngineProfile * cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->webProfile();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_webSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.webSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // webSettings()const
            QWebEngineSettings * cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->webSettings();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_windowCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.windowCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // windowCount()const
            int cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->windowCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_windows(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.windows";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // windows()const
            QList<BrowserWindow* > cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->windows();
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PYFALKON_QLIST_BROWSERWINDOWPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_MainApplicationFunc_wmClass(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = static_cast<MainApplicationWrapper *>(reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PyFalkon.MainApplication.wmClass";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wmClass()const
            QByteArray cppResult = const_cast<const ::MainApplicationWrapper *>(cppSelf)->wmClass();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_MainApplication_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_MainApplication_methods[] = {
    {"addNewTab", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_addNewTab), METH_VARARGS|METH_KEYWORDS},
    {"afterLaunch", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_afterLaunch), METH_NOARGS},
    {"autoFill", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_autoFill), METH_NOARGS},
    {"bookmarks", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_bookmarks), METH_NOARGS},
    {"changeOccurred", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_changeOccurred), METH_NOARGS},
    {"cookieJar", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_cookieJar), METH_NOARGS},
    {"createWindow", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_createWindow), METH_VARARGS|METH_KEYWORDS},
    {"desktopNotifications", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_desktopNotifications), METH_NOARGS},
    {"destroyRestoreManager", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_destroyRestoreManager), METH_NOARGS},
    {"downloadManager", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_downloadManager), METH_NOARGS},
    {"getWindow", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_getWindow), METH_NOARGS},
    {"history", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_history), METH_NOARGS},
    {"instance", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_instance), METH_NOARGS|METH_STATIC},
    {"isClosing", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_isClosing), METH_NOARGS},
    {"isPortable", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_isPortable), METH_NOARGS},
    {"isPrivate", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_isPrivate), METH_NOARGS},
    {"isStartingAfterCrash", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_isStartingAfterCrash), METH_NOARGS},
    {"isTestModeEnabled", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_isTestModeEnabled), METH_NOARGS|METH_STATIC},
    {"messageReceived", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_messageReceived), METH_O},
    {"networkManager", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_networkManager), METH_NOARGS},
    {"plugins", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_plugins), METH_NOARGS},
    {"quitApplication", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_quitApplication), METH_NOARGS},
    {"reloadSettings", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_reloadSettings), METH_NOARGS},
    {"reloadUserStyleSheet", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_reloadUserStyleSheet), METH_NOARGS},
    {"restoreOverrideCursor", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_restoreOverrideCursor), METH_NOARGS},
    {"saveState", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_saveState), METH_NOARGS},
    {"searchEnginesManager", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_searchEnginesManager), METH_NOARGS},
    {"setTestModeEnabled", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_setTestModeEnabled), METH_O|METH_STATIC},
    {"startPrivateBrowsing", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_startPrivateBrowsing), METH_VARARGS|METH_KEYWORDS},
    {"styleName", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_styleName), METH_NOARGS},
    {"webProfile", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_webProfile), METH_NOARGS},
    {"webSettings", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_webSettings), METH_NOARGS},
    {"windowCount", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_windowCount), METH_NOARGS},
    {"windows", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_windows), METH_NOARGS},
    {"wmClass", reinterpret_cast<PyCFunction>(Sbk_MainApplicationFunc_wmClass), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_MainApplication_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::MainApplication *>(Shiboken::Conversions::cppPointer(SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<MainApplicationWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_MainApplication_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_MainApplication_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_MainApplication_Type = nullptr;
static SbkObjectType *Sbk_MainApplication_TypeF(void)
{
    return _Sbk_MainApplication_Type;
}

static PyType_Slot Sbk_MainApplication_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocQAppWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_MainApplication_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_MainApplication_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_MainApplication_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_MainApplication_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkQAppTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_MainApplication_spec = {
    "1:PyFalkon.MainApplication",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_MainApplication_slots
};

} //extern "C"

static void *Sbk_MainApplication_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::MainApplication *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void MainApplication_AfterLaunch_PythonToCpp_MainApplication_AfterLaunch(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::MainApplication::AfterLaunch *>(cppOut) =
        static_cast<::MainApplication::AfterLaunch>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_MainApplication_AfterLaunch_PythonToCpp_MainApplication_AfterLaunch_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX]))
        return MainApplication_AfterLaunch_PythonToCpp_MainApplication_AfterLaunch;
    return {};
}
static PyObject *MainApplication_AfterLaunch_CppToPython_MainApplication_AfterLaunch(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::MainApplication::AfterLaunch *>(cppIn));
    return Shiboken::Enum::newItem(SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void MainApplication_PythonToCpp_MainApplication_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_MainApplication_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_MainApplication_PythonToCpp_MainApplication_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_MainApplication_TypeF())))
        return MainApplication_PythonToCpp_MainApplication_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *MainApplication_PTR_CppToPython_MainApplication(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::MainApplication *>(const_cast<void *>(cppIn)), Sbk_MainApplication_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *MainApplication_SignatureStrings[] = {
    "PyFalkon.MainApplication.addNewTab(self,url:PySide2.QtCore.QUrl=QUrl())",
    "PyFalkon.MainApplication.afterLaunch(self)->PyFalkon.MainApplication.AfterLaunch",
    "PyFalkon.MainApplication.autoFill(self)->PyFalkon.AutoFill",
    "PyFalkon.MainApplication.bookmarks(self)->PyFalkon.Bookmarks",
    "PyFalkon.MainApplication.changeOccurred(self)",
    "PyFalkon.MainApplication.cookieJar(self)->PyFalkon.CookieJar",
    "PyFalkon.MainApplication.createWindow(self,type:PyFalkon.Qz.BrowserWindowType,startUrl:PySide2.QtCore.QUrl=QUrl())->PyFalkon.BrowserWindow",
    "PyFalkon.MainApplication.desktopNotifications(self)->PyFalkon.DesktopNotificationsFactory",
    "PyFalkon.MainApplication.destroyRestoreManager(self)",
    "PyFalkon.MainApplication.downloadManager(self)->PyFalkon.DownloadManager",
    "PyFalkon.MainApplication.getWindow(self)->PyFalkon.BrowserWindow",
    "PyFalkon.MainApplication.history(self)->PyFalkon.History",
    "PyFalkon.MainApplication.instance()->PyFalkon.MainApplication",
    "PyFalkon.MainApplication.isClosing(self)->bool",
    "PyFalkon.MainApplication.isPortable(self)->bool",
    "PyFalkon.MainApplication.isPrivate(self)->bool",
    "PyFalkon.MainApplication.isStartingAfterCrash(self)->bool",
    "PyFalkon.MainApplication.isTestModeEnabled()->bool",
    "PyFalkon.MainApplication.messageReceived(self,message:QString)",
    "PyFalkon.MainApplication.networkManager(self)->PyFalkon.NetworkManager",
    "PyFalkon.MainApplication.plugins(self)->PyFalkon.PluginProxy",
    "PyFalkon.MainApplication.quitApplication(self)",
    "PyFalkon.MainApplication.reloadSettings(self)",
    "PyFalkon.MainApplication.reloadUserStyleSheet(self)",
    "PyFalkon.MainApplication.restoreOverrideCursor(self)",
    "PyFalkon.MainApplication.saveState(self)->PySide2.QtCore.QByteArray",
    "PyFalkon.MainApplication.searchEnginesManager(self)->PyFalkon.SearchEnginesManager",
    "PyFalkon.MainApplication.setTestModeEnabled(enabled:bool)",
    "PyFalkon.MainApplication.startPrivateBrowsing(self,startUrl:PySide2.QtCore.QUrl=QUrl())",
    "PyFalkon.MainApplication.styleName(self)->QString",
    "PyFalkon.MainApplication.webProfile(self)->PySide2.QtWebEngineWidgets.QWebEngineProfile",
    "PyFalkon.MainApplication.webSettings(self)->PySide2.QtWebEngineWidgets.QWebEngineSettings",
    "PyFalkon.MainApplication.windowCount(self)->int",
    "PyFalkon.MainApplication.windows(self)->QList[PyFalkon.BrowserWindow]",
    "PyFalkon.MainApplication.wmClass(self)->PySide2.QtCore.QByteArray",
    nullptr}; // Sentinel

void init_MainApplication(PyObject *module)
{
    _Sbk_MainApplication_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "MainApplication",
        "MainApplication*",
        &Sbk_MainApplication_spec,
        &Shiboken::callCppDestructor< ::MainApplication >,
        reinterpret_cast<SbkObjectType *>(SbkPyFalkonTypes[SBK_QTSINGLEAPPLICATION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_MainApplication_Type);
    InitSignatureStrings(pyType, MainApplication_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_MainApplication_Type), Sbk_MainApplication_PropertyStrings);
    SbkPyFalkonTypes[SBK_MAINAPPLICATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_MainApplication_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_MainApplication_TypeF(),
        MainApplication_PythonToCpp_MainApplication_PTR,
        is_MainApplication_PythonToCpp_MainApplication_PTR_Convertible,
        MainApplication_PTR_CppToPython_MainApplication);

    Shiboken::Conversions::registerConverterName(converter, "MainApplication");
    Shiboken::Conversions::registerConverterName(converter, "MainApplication*");
    Shiboken::Conversions::registerConverterName(converter, "MainApplication&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::MainApplication).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::MainApplicationWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_MainApplication_TypeF(), &Sbk_MainApplication_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'AfterLaunch'.
    SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX] = Shiboken::Enum::createScopedEnum(Sbk_MainApplication_TypeF(),
        "AfterLaunch",
        "1:PyFalkon.MainApplication.AfterLaunch",
        "MainApplication::AfterLaunch");
    if (!SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX],
        Sbk_MainApplication_TypeF(), "OpenBlankPage", (long) MainApplication::AfterLaunch::OpenBlankPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX],
        Sbk_MainApplication_TypeF(), "OpenHomePage", (long) MainApplication::AfterLaunch::OpenHomePage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX],
        Sbk_MainApplication_TypeF(), "OpenSpeedDial", (long) MainApplication::AfterLaunch::OpenSpeedDial))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX],
        Sbk_MainApplication_TypeF(), "RestoreSession", (long) MainApplication::AfterLaunch::RestoreSession))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX],
        Sbk_MainApplication_TypeF(), "SelectSession", (long) MainApplication::AfterLaunch::SelectSession))
        return;
    // Register converter for enum 'MainApplication::AfterLaunch'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX],
            MainApplication_AfterLaunch_CppToPython_MainApplication_AfterLaunch);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            MainApplication_AfterLaunch_PythonToCpp_MainApplication_AfterLaunch,
            is_MainApplication_AfterLaunch_PythonToCpp_MainApplication_AfterLaunch_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPyFalkonTypes[SBK_MAINAPPLICATION_AFTERLAUNCH_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "MainApplication::AfterLaunch");
        Shiboken::Conversions::registerConverterName(converter, "AfterLaunch");
    }
    // End of 'AfterLaunch' enum.

    PySide::Signal::registerSignals(Sbk_MainApplication_TypeF(), &::MainApplication::staticMetaObject);

    MainApplicationWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_MainApplication_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_MainApplication_TypeF(), &::MainApplication::staticMetaObject, sizeof(MainApplicationWrapper));
}
