/* window.c generated by valac 0.56.0, the Vala compiler
 * generated from window.vala, do not modify */

/*
   This file is part of Swell-Foop.

   Copyright (C) 2020 Arnaud Bonatti <arnaud.bonatti@gmail.com>

   Swell-Foop is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   Swell-Foop is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Swell-Foop.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <clutter-gtk/clutter-gtk.h>
#include <glib.h>
#include <libgnome-games-support.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <errno.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SWELL_FOOP_WINDOW (swell_foop_window_get_type ())
#define SWELL_FOOP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWELL_FOOP_WINDOW, SwellFoopWindow))
#define SWELL_FOOP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWELL_FOOP_WINDOW, SwellFoopWindowClass))
#define IS_SWELL_FOOP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWELL_FOOP_WINDOW))
#define IS_SWELL_FOOP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWELL_FOOP_WINDOW))
#define SWELL_FOOP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWELL_FOOP_WINDOW, SwellFoopWindowClass))

typedef struct _SwellFoopWindow SwellFoopWindow;
typedef struct _SwellFoopWindowClass SwellFoopWindowClass;
typedef struct _SwellFoopWindowPrivate SwellFoopWindowPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
enum  {
	SWELL_FOOP_WINDOW_0_PROPERTY,
	SWELL_FOOP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* swell_foop_window_properties[SWELL_FOOP_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SWELL_FOOP_WINDOW_TYPE_SIZE (swell_foop_window_size_get_type ())
typedef struct _SwellFoopWindowSize SwellFoopWindowSize;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SwellFoopWindow {
	GtkApplicationWindow parent_instance;
	SwellFoopWindowPrivate * priv;
};

struct _SwellFoopWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _SwellFoopWindowPrivate {
	GtkHeaderBar* headerbar;
	GtkBox* main_box;
	GtkMenuButton* hamburger_button;
	GSettings* settings;
	Game* game;
	GameView* view;
	gboolean game_in_progress;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GtkEventControllerKey* key_controller;
	GamesScoresContext* scores_context;
	GtkEventControllerMotion* motion_controller;
};

struct _SwellFoopWindowSize {
	gchar* id;
	gchar* name;
	guint8 columns;
	guint8 rows;
};

struct _Block2Data {
	int _ref_count_;
	SwellFoopWindow* self;
	GtkStack* stack;
};

static gint SwellFoopWindow_private_offset;
static gpointer swell_foop_window_parent_class = NULL;
static SwellFoopWindowSize* swell_foop_window_sizes;
static gint swell_foop_window_sizes_length1;
static SwellFoopWindowSize* swell_foop_window_sizes = NULL;
static gint swell_foop_window_sizes_length1 = 0;
static gint _swell_foop_window_sizes_size_ = 0;
static GHashTable* swell_foop_window_score_categories;
static GHashTable* swell_foop_window_score_categories = NULL;

VALA_EXTERN GType swell_foop_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwellFoopWindow, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
static inline void swell_foop_window_change_theme_cb (SwellFoopWindow* self,
                                        GSimpleAction* action,
                                        GVariant* variant);
static void _swell_foop_window_change_theme_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                              GVariant* value,
                                                                              gpointer self);
static inline void swell_foop_window_change_colors_cb (SwellFoopWindow* self,
                                         GSimpleAction* action,
                                         GVariant* variant);
static void _swell_foop_window_change_colors_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                               GVariant* value,
                                                                               gpointer self);
static inline void swell_foop_window_new_game_cb (SwellFoopWindow* self);
static void _swell_foop_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static inline void swell_foop_window_scores_cb (SwellFoopWindow* self);
static void _swell_foop_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static inline void swell_foop_window_toggle_hamburger (SwellFoopWindow* self);
static void _swell_foop_window_toggle_hamburger_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static inline void swell_foop_window_undo (SwellFoopWindow* self);
static void _swell_foop_window_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static inline void swell_foop_window_redo (SwellFoopWindow* self);
static void _swell_foop_window_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static GType swell_foop_window_size_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SwellFoopWindowSize* swell_foop_window_size_dup (const SwellFoopWindowSize* self);
static void swell_foop_window_size_free (SwellFoopWindowSize* self);
static void swell_foop_window_size_copy (const SwellFoopWindowSize* self,
                                  SwellFoopWindowSize* dest);
static void swell_foop_window_size_destroy (SwellFoopWindowSize* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SwellFoopWindowSize, swell_foop_window_size_destroy)
static inline void swell_foop_window_class_init_sizes (void);
static void _vala_SwellFoopWindowSize_array_free (SwellFoopWindowSize * array,
                                           gssize array_length);
VALA_EXTERN SwellFoopWindow* swell_foop_window_new (GtkApplication* application);
VALA_EXTERN SwellFoopWindow* swell_foop_window_construct (GType object_type,
                                              GtkApplication* application);
static void swell_foop_window_new_game (SwellFoopWindow* self,
                                 GVariant* saved_game);
static inline void swell_foop_window_init_motion (SwellFoopWindow* self);
static inline GtkStack* swell_foop_window_build_first_run_stack (SwellFoopWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda9_ (Block2Data* _data2_);
static inline void swell_foop_window_init_keyboard (SwellFoopWindow* self);
static void ___lambda9__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void swell_foop_window_update_score_cb (SwellFoopWindow* self);
VALA_EXTERN guint game_get_score (Game* self);
static void swell_foop_window_complete_cb (SwellFoopWindow* self);
static gboolean __lambda7_ (SwellFoopWindow* self);
static inline void swell_foop_window_add_score (SwellFoopWindow* self);
static gboolean ___lambda7__gsource_func (gpointer self);
static inline void swell_foop_window_started_cb (SwellFoopWindow* self);
static void swell_foop_window_get_board_size (SwellFoopWindow* self,
                                       SwellFoopWindowSize* result);
VALA_EXTERN Game* game_new (guint8 rows,
                guint8 columns,
                guint8 color_num,
                GVariant* saved_game);
VALA_EXTERN Game* game_construct (GType object_type,
                      guint8 rows,
                      guint8 columns,
                      guint8 color_num,
                      GVariant* saved_game);
static void _swell_foop_window_update_score_cb_game_update_score (Game* _sender,
                                                           guint points_awarded,
                                                           gpointer self);
static void _swell_foop_window_complete_cb_game_complete (Game* _sender,
                                                   gpointer self);
static void _swell_foop_window_started_cb_game_started (Game* _sender,
                                                 gpointer self);
VALA_EXTERN void game_view_set_theme_name (GameView* self,
                               const gchar* theme_name);
VALA_EXTERN void game_view_set_is_zealous (GameView* self,
                               gboolean is_zealous);
VALA_EXTERN void game_view_set_game (GameView* self,
                         Game* game);
static void swell_foop_window_real_destroy (GtkWidget* base);
VALA_EXTERN GVariant* game_get_saved_game (Game* self);
VALA_EXTERN guint8 game_get_color_num (Game* self);
VALA_EXTERN guint8 game_get_rows (Game* self);
VALA_EXTERN guint8 game_get_columns (Game* self);
static inline void swell_foop_window_show_new_game_confirmation_dialog (SwellFoopWindow* self);
VALA_EXTERN void game_undo (Game* self);
VALA_EXTERN void game_redo (Game* self);
static inline gboolean swell_foop_window_on_key_pressed (SwellFoopWindow* self,
                                           GtkEventControllerKey* _key_controller,
                                           guint keyval,
                                           guint keycode,
                                           GdkModifierType state);
static gboolean _swell_foop_window_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                 guint keyval,
                                                                                 guint keycode,
                                                                                 GdkModifierType state,
                                                                                 gpointer self);
VALA_EXTERN void game_view_cursor_move (GameView* self,
                            gint x,
                            gint y);
VALA_EXTERN void game_view_cursor_click (GameView* self);
static inline void swell_foop_window_class_init_scores (void);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static inline void swell_foop_window_init_scores (SwellFoopWindow* self);
static inline GamesScoresCategory* swell_foop_window_category_request (SwellFoopWindow* self,
                                                         const gchar* key);
static GamesScoresCategory* _swell_foop_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                                     gpointer self);
static inline void swell_foop_window_parse_old_score (SwellFoopWindow* self,
                                        const gchar* line,
                                        GamesScoresScore** score,
                                        GamesScoresCategory** category);
static void _swell_foop_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                                                 GamesScoresScore** score,
                                                                                                 GamesScoresCategory** category,
                                                                                                 gpointer self);
static void __lambda8_ (SwellFoopWindow* self,
                 GObject* object,
                 GAsyncResult* _result_);
static void ___lambda8__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
VALA_EXTERN void game_view_board_left_cb (GameView* self);
static void _game_view_board_left_cb_gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                 gpointer self);
static GObject * swell_foop_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _swell_foop_window___lambda10_ (SwellFoopWindow* self,
                                     GSettings* _settings,
                                     const gchar* _key_name);
static void __swell_foop_window___lambda10__g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self);
VALA_EXTERN GameView* game_view_new (void);
VALA_EXTERN GameView* game_view_construct (GType object_type);
static void swell_foop_window_finalize (GObject * obj);
static GType swell_foop_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GActionEntry SWELL_FOOP_WINDOW_win_actions[7] = {{"change-theme", NULL, "s", "'shapesandcolors'", _swell_foop_window_change_theme_cb_gsimple_action_change_state_callback}, {"change-colors", NULL, "s", "'3'", _swell_foop_window_change_colors_cb_gsimple_action_change_state_callback}, {"new-game", _swell_foop_window_new_game_cb_gsimple_action_activate_callback}, {"scores", _swell_foop_window_scores_cb_gsimple_action_activate_callback}, {"toggle-hamburger", _swell_foop_window_toggle_hamburger_gsimple_action_activate_callback}, {"undo", _swell_foop_window_undo_gsimple_action_activate_callback}, {"redo", _swell_foop_window_redo_gsimple_action_activate_callback}};

static inline gpointer
swell_foop_window_get_instance_private (SwellFoopWindow* self)
{
	return G_STRUCT_MEMBER_P (self, SwellFoopWindow_private_offset);
}

static void
_swell_foop_window_change_theme_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                         GVariant* value,
                                                                         gpointer self)
{
	swell_foop_window_change_theme_cb ((SwellFoopWindow*) self, action, value);
}

static void
_swell_foop_window_change_colors_cb_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                          GVariant* value,
                                                                          gpointer self)
{
	swell_foop_window_change_colors_cb ((SwellFoopWindow*) self, action, value);
}

static void
_swell_foop_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	swell_foop_window_new_game_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	swell_foop_window_scores_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_toggle_hamburger_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	swell_foop_window_toggle_hamburger ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	swell_foop_window_undo ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	swell_foop_window_redo ((SwellFoopWindow*) self);
}

static void
_vala_SwellFoopWindowSize_array_free (SwellFoopWindowSize * array,
                                      gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			swell_foop_window_size_destroy (&array[i]);
		}
	}
	g_free (array);
}

static inline void
swell_foop_window_class_init_sizes (void)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	SwellFoopWindowSize _tmp2_ = {0};
	gchar* _tmp3_;
	gchar* _tmp4_;
	SwellFoopWindowSize _tmp5_ = {0};
	gchar* _tmp6_;
	gchar* _tmp7_;
	SwellFoopWindowSize _tmp8_ = {0};
	SwellFoopWindowSize* _tmp9_;
	_tmp0_ = g_strdup ("small");
	_tmp1_ = g_strdup (_ ("Small"));
	memset (&_tmp2_, 0, sizeof (SwellFoopWindowSize));
	_g_free0 (_tmp2_.id);
	_tmp2_.id = _tmp0_;
	_g_free0 (_tmp2_.name);
	_tmp2_.name = _tmp1_;
	_tmp2_.columns = (guint8) 6;
	_tmp2_.rows = (guint8) 5;
	_tmp3_ = g_strdup ("normal");
	_tmp4_ = g_strdup (_ ("Normal"));
	memset (&_tmp5_, 0, sizeof (SwellFoopWindowSize));
	_g_free0 (_tmp5_.id);
	_tmp5_.id = _tmp3_;
	_g_free0 (_tmp5_.name);
	_tmp5_.name = _tmp4_;
	_tmp5_.columns = (guint8) 15;
	_tmp5_.rows = (guint8) 10;
	_tmp6_ = g_strdup ("large");
	_tmp7_ = g_strdup (_ ("Large"));
	memset (&_tmp8_, 0, sizeof (SwellFoopWindowSize));
	_g_free0 (_tmp8_.id);
	_tmp8_.id = _tmp6_;
	_g_free0 (_tmp8_.name);
	_tmp8_.name = _tmp7_;
	_tmp8_.columns = (guint8) 20;
	_tmp8_.rows = (guint8) 15;
	_tmp9_ = g_new0 (SwellFoopWindowSize, 3);
	_tmp9_[0] = _tmp2_;
	_tmp9_[1] = _tmp5_;
	_tmp9_[2] = _tmp8_;
	swell_foop_window_sizes = (_vala_SwellFoopWindowSize_array_free (swell_foop_window_sizes, swell_foop_window_sizes_length1), NULL);
	swell_foop_window_sizes = _tmp9_;
	swell_foop_window_sizes_length1 = 3;
	_swell_foop_window_sizes_size_ = swell_foop_window_sizes_length1;
}

SwellFoopWindow*
swell_foop_window_construct (GType object_type,
                             GtkApplication* application)
{
	SwellFoopWindow * self = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_val_if_fail (application != NULL, NULL);
	self = (SwellFoopWindow*) g_object_new (object_type, "application", application, NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "saved-game");
	_tmp2_ = _tmp1_;
	swell_foop_window_new_game (self, _tmp2_);
	_g_variant_unref0 (_tmp2_);
	swell_foop_window_init_motion (self);
	return self;
}

SwellFoopWindow*
swell_foop_window_new (GtkApplication* application)
{
	return swell_foop_window_construct (TYPE_SWELL_FOOP_WINDOW, application);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SwellFoopWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->stack);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda9_ (Block2Data* _data2_)
{
	SwellFoopWindow* self;
	GSettings* _tmp0_;
	self = _data2_->self;
	gtk_stack_set_transition_type (_data2_->stack, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
	gtk_stack_set_transition_duration (_data2_->stack, (guint) 500);
	gtk_stack_set_visible_child_name (_data2_->stack, "game");
	swell_foop_window_init_keyboard (self);
	_tmp0_ = self->priv->settings;
	g_settings_set_boolean (_tmp0_, "first-run", FALSE);
}

static void
___lambda9__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda9_ (self);
}

static inline GtkStack*
swell_foop_window_build_first_run_stack (SwellFoopWindow* self)
{
	Block2Data* _data2_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GdkScreen* gdk_screen = NULL;
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	GdkScreen* _tmp4_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp7_;
	GObject* _tmp8_;
	GtkStack* _tmp9_;
	GtkLabel* tip_label = NULL;
	GObject* _tmp10_;
	GtkLabel* _tmp11_;
	GtkButton* play_button = NULL;
	GObject* _tmp12_;
	GtkButton* _tmp13_;
	GtkStack* _tmp14_;
	GtkStack* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = gtk_css_provider_new ();
	css_provider = _tmp0_;
	_tmp1_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/org/gnome/SwellFoop/ui/swell-foop.css");
	_tmp2_ = gdk_screen_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	gdk_screen = _tmp3_;
	_tmp4_ = gdk_screen;
	if (_tmp4_ != NULL) {
		GdkScreen* _tmp5_;
		GtkCssProvider* _tmp6_;
		_tmp5_ = gdk_screen;
		_tmp6_ = css_provider;
		gtk_style_context_add_provider_for_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gdk_screen_get_type (), GdkScreen), (GtkStyleProvider*) _tmp6_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	_tmp7_ = gtk_builder_new_from_resource ("/org/gnome/SwellFoop/ui/first-run-stack.ui");
	builder = _tmp7_;
	_tmp8_ = gtk_builder_get_object (builder, "first_run_stack");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_stack_get_type (), GtkStack));
	_data2_->stack = _tmp9_;
	_tmp10_ = gtk_builder_get_object (builder, "tip_label");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_label_get_type (), GtkLabel));
	tip_label = _tmp11_;
	gtk_label_set_label (tip_label, _ ("Clear as many blocks as you can.\nFewer clicks means more points."));
	_tmp12_ = gtk_builder_get_object (builder, "play_button");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_button_get_type (), GtkButton));
	play_button = _tmp13_;
	g_signal_connect_data (play_button, "clicked", (GCallback) ___lambda9__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp14_ = _g_object_ref0 (_data2_->stack);
	result = _tmp14_;
	_g_object_unref0 (play_button);
	_g_object_unref0 (tip_label);
	_g_object_unref0 (builder);
	_g_object_unref0 (gdk_screen);
	_g_object_unref0 (css_provider);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static void
swell_foop_window_update_score_cb (SwellFoopWindow* self)
{
	guint score = 0U;
	Game* _tmp0_;
	GtkHeaderBar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	score = (guint) 0;
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		guint _tmp2_;
		guint _tmp3_;
		_tmp1_ = self->priv->game;
		_tmp2_ = game_get_score (_tmp1_);
		_tmp3_ = _tmp2_;
		score = _tmp3_;
	}
	_tmp4_ = self->priv->headerbar;
	_tmp5_ = g_strdup_printf (_ ("Score: %u"), score);
	_tmp6_ = _tmp5_;
	gtk_header_bar_set_subtitle (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
}

static gboolean
__lambda7_ (SwellFoopWindow* self)
{
	gboolean result;
	swell_foop_window_add_score (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ ((SwellFoopWindow*) self);
	return result;
}

static void
swell_foop_window_complete_cb (SwellFoopWindow* self)
{
	GSimpleAction* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->game_in_progress = FALSE;
}

static inline void
swell_foop_window_started_cb (SwellFoopWindow* self)
{
	g_return_if_fail (self != NULL);
	self->priv->game_in_progress = TRUE;
}

static void
swell_foop_window_get_board_size (SwellFoopWindow* self,
                                  SwellFoopWindowSize* result)
{
	gchar* current_size = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	SwellFoopWindowSize* _tmp13_;
	gint _tmp13__length1;
	SwellFoopWindowSize _tmp14_;
	SwellFoopWindowSize _tmp15_;
	SwellFoopWindowSize _tmp16_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "size");
	current_size = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				SwellFoopWindowSize* _tmp4_;
				gint _tmp4__length1;
				SwellFoopWindowSize* _tmp5_;
				gint _tmp5__length1;
				SwellFoopWindowSize _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = swell_foop_window_sizes;
				_tmp4__length1 = swell_foop_window_sizes_length1;
				if (!(i < _tmp4__length1)) {
					break;
				}
				_tmp5_ = swell_foop_window_sizes;
				_tmp5__length1 = swell_foop_window_sizes_length1;
				_tmp6_ = _tmp5_[i];
				_tmp7_ = _tmp6_.id;
				_tmp8_ = current_size;
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
					SwellFoopWindowSize* _tmp9_;
					gint _tmp9__length1;
					SwellFoopWindowSize _tmp10_;
					SwellFoopWindowSize _tmp11_;
					SwellFoopWindowSize _tmp12_ = {0};
					_tmp9_ = swell_foop_window_sizes;
					_tmp9__length1 = swell_foop_window_sizes_length1;
					_tmp10_ = _tmp9_[i];
					_tmp11_ = _tmp10_;
					swell_foop_window_size_copy (&_tmp11_, &_tmp12_);
					*result = _tmp12_;
					_g_free0 (current_size);
					return;
				}
			}
		}
	}
	_tmp13_ = swell_foop_window_sizes;
	_tmp13__length1 = swell_foop_window_sizes_length1;
	_tmp14_ = _tmp13_[0];
	_tmp15_ = _tmp14_;
	swell_foop_window_size_copy (&_tmp15_, &_tmp16_);
	*result = _tmp16_;
	_g_free0 (current_size);
	return;
}

static void
_swell_foop_window_update_score_cb_game_update_score (Game* _sender,
                                                      guint points_awarded,
                                                      gpointer self)
{
	swell_foop_window_update_score_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_complete_cb_game_complete (Game* _sender,
                                              gpointer self)
{
	swell_foop_window_complete_cb ((SwellFoopWindow*) self);
}

static void
_swell_foop_window_started_cb_game_started (Game* _sender,
                                            gpointer self)
{
	swell_foop_window_started_cb ((SwellFoopWindow*) self);
}

static void
swell_foop_window_new_game (SwellFoopWindow* self,
                            GVariant* saved_game)
{
	SwellFoopWindowSize size = {0};
	SwellFoopWindowSize _tmp0_ = {0};
	SwellFoopWindowSize _tmp1_;
	SwellFoopWindowSize _tmp2_;
	GSettings* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	Game* _tmp8_;
	Game* _tmp9_;
	Game* _tmp10_;
	GameView* _tmp11_;
	GSettings* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GameView* _tmp15_;
	GSettings* _tmp16_;
	GameView* _tmp17_;
	Game* _tmp18_;
	GAction* _tmp19_;
	GSimpleAction* _tmp20_;
	Game* _tmp21_;
	GSimpleAction* _tmp22_;
	GAction* _tmp23_;
	GSimpleAction* _tmp24_;
	Game* _tmp25_;
	GSimpleAction* _tmp26_;
	g_return_if_fail (self != NULL);
	swell_foop_window_get_board_size (self, &_tmp0_);
	size = _tmp0_;
	_tmp1_ = size;
	_tmp2_ = size;
	_tmp3_ = self->priv->settings;
	_tmp4_ = game_new (_tmp1_.rows, _tmp2_.columns, (guint8) g_settings_get_int (_tmp3_, "colors"), saved_game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp4_;
	_tmp5_ = self->priv->game;
	_tmp6_ = game_get_score (_tmp5_);
	_tmp7_ = _tmp6_;
	self->priv->game_in_progress = _tmp7_ != ((guint) 0);
	swell_foop_window_update_score_cb (self);
	_tmp8_ = self->priv->game;
	g_signal_connect_object (_tmp8_, "update-score", (GCallback) _swell_foop_window_update_score_cb_game_update_score, self, 0);
	_tmp9_ = self->priv->game;
	g_signal_connect_object (_tmp9_, "complete", (GCallback) _swell_foop_window_complete_cb_game_complete, self, 0);
	_tmp10_ = self->priv->game;
	g_signal_connect_object (_tmp10_, "started", (GCallback) _swell_foop_window_started_cb_game_started, self, 0);
	_tmp11_ = self->priv->view;
	_tmp12_ = self->priv->settings;
	_tmp13_ = g_settings_get_string (_tmp12_, "theme");
	_tmp14_ = _tmp13_;
	game_view_set_theme_name (_tmp11_, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = self->priv->view;
	_tmp16_ = self->priv->settings;
	game_view_set_is_zealous (_tmp15_, g_settings_get_boolean (_tmp16_, "zealous"));
	_tmp17_ = self->priv->view;
	_tmp18_ = self->priv->game;
	game_view_set_game (_tmp17_, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_GAME, Game));
	_tmp19_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp20_;
	_tmp21_ = self->priv->game;
	_tmp22_ = self->priv->undo_action;
	g_object_bind_property_with_closures ((GObject*) _tmp21_, "can-undo", (GObject*) _tmp22_, "enabled", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp23_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->redo_action);
	self->priv->redo_action = _tmp24_;
	_tmp25_ = self->priv->game;
	_tmp26_ = self->priv->redo_action;
	g_object_bind_property_with_closures ((GObject*) _tmp25_, "can-redo", (GObject*) _tmp26_, "enabled", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	swell_foop_window_size_destroy (&size);
}

static void
swell_foop_window_real_destroy (GtkWidget* base)
{
	SwellFoopWindow * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	Game* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GSettings* _tmp5_;
	Game* _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	GSettings* _tmp27_;
	self = (SwellFoopWindow*) base;
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	_tmp1_ = self->priv->settings;
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_saved_game (_tmp2_);
	_tmp4_ = _tmp3_;
	g_settings_set_value (_tmp1_, "saved-game", _tmp4_);
	_g_variant_unref0 (_tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->game;
	_tmp7_ = game_get_color_num (_tmp6_);
	_tmp8_ = _tmp7_;
	g_settings_set_int (_tmp5_, "colors", (gint) _tmp8_);
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				SwellFoopWindowSize* _tmp11_;
				gint _tmp11__length1;
				gboolean _tmp12_ = FALSE;
				Game* _tmp13_;
				guint8 _tmp14_;
				guint8 _tmp15_;
				SwellFoopWindowSize* _tmp16_;
				gint _tmp16__length1;
				SwellFoopWindowSize _tmp17_;
				if (!_tmp9_) {
					guint8 _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = swell_foop_window_sizes;
				_tmp11__length1 = swell_foop_window_sizes_length1;
				if (!(((gint) i) < _tmp11__length1)) {
					break;
				}
				_tmp13_ = self->priv->game;
				_tmp14_ = game_get_rows (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = swell_foop_window_sizes;
				_tmp16__length1 = swell_foop_window_sizes_length1;
				_tmp17_ = _tmp16_[i];
				if (_tmp15_ == _tmp17_.rows) {
					Game* _tmp18_;
					guint8 _tmp19_;
					guint8 _tmp20_;
					SwellFoopWindowSize* _tmp21_;
					gint _tmp21__length1;
					SwellFoopWindowSize _tmp22_;
					_tmp18_ = self->priv->game;
					_tmp19_ = game_get_columns (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = swell_foop_window_sizes;
					_tmp21__length1 = swell_foop_window_sizes_length1;
					_tmp22_ = _tmp21_[i];
					_tmp12_ = _tmp20_ == _tmp22_.columns;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					GSettings* _tmp23_;
					SwellFoopWindowSize* _tmp24_;
					gint _tmp24__length1;
					SwellFoopWindowSize _tmp25_;
					const gchar* _tmp26_;
					_tmp23_ = self->priv->settings;
					_tmp24_ = swell_foop_window_sizes;
					_tmp24__length1 = swell_foop_window_sizes_length1;
					_tmp25_ = _tmp24_[i];
					_tmp26_ = _tmp25_.id;
					g_settings_set_string (_tmp23_, "size", _tmp26_);
					break;
				}
			}
		}
	}
	_tmp27_ = self->priv->settings;
	g_settings_apply (_tmp27_);
	GTK_WIDGET_CLASS (swell_foop_window_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow));
}

static inline void
swell_foop_window_change_theme_cb (SwellFoopWindow* self,
                                   GSimpleAction* action,
                                   GVariant* variant)
{
	gchar* new_theme = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GameView* _tmp2_;
	const gchar* _tmp3_;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	_tmp0_ = g_variant_get_string ((GVariant*) variant, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	new_theme = _tmp1_;
	g_simple_action_set_state (action, (GVariant*) variant);
	_tmp2_ = self->priv->view;
	_tmp3_ = new_theme;
	game_view_set_theme_name (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_string (_tmp4_, "theme");
	_tmp6_ = _tmp5_;
	_tmp7_ = new_theme;
	_tmp8_ = g_strcmp0 (_tmp6_, _tmp7_) != 0;
	_g_free0 (_tmp6_);
	if (_tmp8_) {
		GSettings* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = self->priv->settings;
		_tmp10_ = new_theme;
		g_settings_set_string (_tmp9_, "theme", _tmp10_);
	}
	_g_free0 (new_theme);
}

static inline void
swell_foop_window_change_colors_cb (SwellFoopWindow* self,
                                    GSimpleAction* action,
                                    GVariant* variant)
{
	gint32 new_colors = 0;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	_tmp0_ = g_variant_get_string ((GVariant*) variant, NULL);
	new_colors = (gint32) atoi (_tmp0_);
	g_simple_action_set_state (action, (GVariant*) variant);
	_tmp1_ = self->priv->settings;
	if (g_settings_get_int (_tmp1_, "colors") != ((gint) new_colors)) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		g_settings_set_int (_tmp2_, "colors", (gint) new_colors);
	}
}

static inline void
swell_foop_window_scores_cb (SwellFoopWindow* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scores_context;
	games_scores_context_run_dialog (_tmp0_);
}

static inline void
swell_foop_window_new_game_cb (SwellFoopWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->game_in_progress) {
		swell_foop_window_show_new_game_confirmation_dialog (self);
	} else {
		swell_foop_window_new_game (self, NULL);
	}
}

static inline void
swell_foop_window_show_new_game_confirmation_dialog (SwellFoopWindow* self)
{
	GtkMessageDialog* dialog = NULL;
	GtkMessageDialog* _tmp0_;
	GtkMessageDialog* _tmp1_;
	GtkMessageDialog* _tmp2_;
	gint _result_ = 0;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "<span weight=\"bold\" size=\"larger\">%s</span>", _ ("Abandon this game to start a new one?"));
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	_tmp1_ = dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp1_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp2_, _ ("_New Game"), (gint) GTK_RESPONSE_YES);
	_tmp3_ = dialog;
	_result_ = gtk_dialog_run ((GtkDialog*) _tmp3_);
	_tmp4_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	if (_result_ == ((gint) GTK_RESPONSE_YES)) {
		swell_foop_window_new_game (self, NULL);
	}
	_g_object_unref0 (dialog);
}

static inline void
swell_foop_window_toggle_hamburger (SwellFoopWindow* self)
{
	GtkMenuButton* _tmp0_;
	GtkMenuButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hamburger_button;
	_tmp1_ = self->priv->hamburger_button;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, !_tmp3_);
}

static inline void
swell_foop_window_undo (SwellFoopWindow* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_undo (_tmp0_);
}

static inline void
swell_foop_window_redo (SwellFoopWindow* self)
{
	Game* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	game_redo (_tmp0_);
}

static gboolean
_swell_foop_window_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                        guint keyval,
                                                                        guint keycode,
                                                                        GdkModifierType state,
                                                                        gpointer self)
{
	gboolean result;
	result = swell_foop_window_on_key_pressed ((SwellFoopWindow*) self, _sender, keyval, keycode, state);
	return result;
}

static inline void
swell_foop_window_init_keyboard (SwellFoopWindow* self)
{
	GtkEventControllerKey* _tmp0_;
	GtkEventControllerKey* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp0_;
	_tmp1_ = self->priv->key_controller;
	g_signal_connect_object (_tmp1_, "key-pressed", (GCallback) _swell_foop_window_on_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
}

static inline gboolean
swell_foop_window_on_key_pressed (SwellFoopWindow* self,
                                  GtkEventControllerKey* _key_controller,
                                  guint keyval,
                                  guint keycode,
                                  GdkModifierType state)
{
	GtkMenuButton* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_key_controller != NULL, FALSE);
	_tmp0_ = self->priv->hamburger_button;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_)) {
		result = FALSE;
		return result;
	}
	switch (keyval) {
		case GDK_KEY_F2:
		{
			swell_foop_window_new_game (self, NULL);
			break;
		}
		case GDK_KEY_Up:
		{
			GameView* _tmp1_;
			_tmp1_ = self->priv->view;
			game_view_cursor_move (_tmp1_, 0, 1);
			break;
		}
		case GDK_KEY_Down:
		{
			GameView* _tmp2_;
			_tmp2_ = self->priv->view;
			game_view_cursor_move (_tmp2_, 0, -1);
			break;
		}
		case GDK_KEY_Left:
		{
			GameView* _tmp3_;
			_tmp3_ = self->priv->view;
			game_view_cursor_move (_tmp3_, -1, 0);
			break;
		}
		case GDK_KEY_Right:
		{
			GameView* _tmp4_;
			_tmp4_ = self->priv->view;
			game_view_cursor_move (_tmp4_, 1, 0);
			break;
		}
		case GDK_KEY_space:
		case GDK_KEY_Return:
		{
			GameView* _tmp5_;
			_tmp5_ = self->priv->view;
			game_view_cursor_click (_tmp5_);
			result = TRUE;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = FALSE;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static inline void
swell_foop_window_class_init_scores (void)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (swell_foop_window_score_categories);
	swell_foop_window_score_categories = _tmp2_;
	{
		guint8 i = 0U;
		i = (guint8) 2;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				SwellFoopWindowSize* _tmp5_;
				gint _tmp5__length1;
				if (!_tmp3_) {
					guint8 _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(((gint) i) <= 4)) {
					break;
				}
				_tmp5_ = swell_foop_window_sizes;
				_tmp5__length1 = swell_foop_window_sizes_length1;
				{
					SwellFoopWindowSize* size_collection = NULL;
					gint size_collection_length1 = 0;
					gint _size_collection_size_ = 0;
					gint size_it = 0;
					size_collection = _tmp5_;
					size_collection_length1 = _tmp5__length1;
					for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
						SwellFoopWindowSize size = {0};
						size = size_collection[size_it];
						{
							gchar* id = NULL;
							SwellFoopWindowSize _tmp6_;
							const gchar* _tmp7_;
							const gchar* _tmp8_;
							gchar* _tmp9_;
							gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* name = NULL;
							SwellFoopWindowSize _tmp13_;
							const gchar* _tmp14_;
							gchar* _tmp15_;
							GamesScoresCategory* category = NULL;
							const gchar* _tmp16_;
							const gchar* _tmp17_;
							GamesScoresCategory* _tmp18_;
							GHashTable* _tmp19_;
							const gchar* _tmp20_;
							gchar* _tmp21_;
							GamesScoresCategory* _tmp22_;
							_tmp6_ = size;
							_tmp7_ = _tmp6_.id;
							_tmp8_ = string_to_string (_tmp7_);
							_tmp9_ = g_strdup_printf ("%hhu", i);
							_tmp10_ = _tmp9_;
							_tmp11_ = g_strconcat (_tmp8_, "-", _tmp10_, NULL);
							_tmp12_ = _tmp11_;
							_g_free0 (_tmp10_);
							id = _tmp12_;
							_tmp13_ = size;
							_tmp14_ = _tmp13_.name;
							_tmp15_ = g_strdup_printf (ngettext ("%s, %d color", "%s, %d colors", (gulong) i), _tmp14_, (gint) i);
							name = _tmp15_;
							_tmp16_ = id;
							_tmp17_ = name;
							_tmp18_ = games_scores_category_new (_tmp16_, _tmp17_);
							category = _tmp18_;
							_tmp19_ = swell_foop_window_score_categories;
							_tmp20_ = id;
							_tmp21_ = g_strdup (_tmp20_);
							_tmp22_ = category;
							category = NULL;
							g_hash_table_insert (_tmp19_, _tmp21_, _tmp22_);
							_g_object_unref0 (category);
							_g_free0 (name);
							_g_free0 (id);
						}
					}
				}
			}
		}
	}
}

static GamesScoresCategory*
_swell_foop_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                gpointer self)
{
	GamesScoresCategory* result;
	result = swell_foop_window_category_request ((SwellFoopWindow*) self, category_key);
	return result;
}

static void
_swell_foop_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                                            GamesScoresScore** score,
                                                                                            GamesScoresCategory** category,
                                                                                            gpointer self)
{
	swell_foop_window_parse_old_score ((SwellFoopWindow*) self, line, score, category);
}

static inline void
swell_foop_window_init_scores (SwellFoopWindow* self)
{
	GamesScoresHistoryFileImporter* _tmp0_;
	GamesScoresHistoryFileImporter* _tmp1_;
	GamesScoresContext* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_scores_history_file_importer_new (_swell_foop_window_parse_old_score_games_scores_history_file_importer_history_convert_func, self);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_scores_context_new_with_importer_and_icon_name ("swell-foop", _ ("Type"), (GtkWindow*) self, _swell_foop_window_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp1_, "org.gnome.SwellFoop");
	_g_object_unref0 (self->priv->scores_context);
	self->priv->scores_context = _tmp2_;
	_g_object_unref0 (_tmp1_);
}

static inline GamesScoresCategory*
swell_foop_window_category_request (SwellFoopWindow* self,
                                    const gchar* key)
{
	GamesScoresCategory* category = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GamesScoresCategory* _tmp2_;
	GamesScoresCategory* _tmp3_;
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = swell_foop_window_score_categories;
	_tmp1_ = g_hash_table_lookup (_tmp0_, key);
	_tmp2_ = _g_object_ref0 ((GamesScoresCategory*) _tmp1_);
	category = _tmp2_;
	if (category == NULL) {
		g_assert_not_reached ();
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (category, GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory));
	result = _tmp3_;
	_g_object_unref0 (category);
	return result;
}

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static inline void
swell_foop_window_parse_old_score (SwellFoopWindow* self,
                                   const gchar* line,
                                   GamesScoresScore** score,
                                   GamesScoresCategory** category)
{
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_category = NULL;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint64 date = 0LL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	guint64 number_64 = 0ULL;
	guint8 cols = 0U;
	guint8 rows = 0U;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	guint64 _tmp7_ = 0ULL;
	gboolean _tmp8_;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	guint64 _tmp12_ = 0ULL;
	gboolean _tmp13_;
	gboolean _tmp14_ = FALSE;
	gchar* id = NULL;
	gchar* _tmp15_;
	SwellFoopWindowSize* _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp23_;
	guint8 colors = 0U;
	glong score_value = 0L;
	gchar** _tmp24_;
	gint _tmp24__length1;
	const gchar* _tmp25_;
	guint64 _tmp26_ = 0ULL;
	gboolean _tmp27_;
	gboolean _tmp28_ = FALSE;
	gchar** _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	guint64 _tmp31_ = 0ULL;
	gboolean _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GamesScoresCategory* _tmp39_;
	GamesScoresScore* _tmp40_;
	GamesScoresScore* _tmp41_;
	const gchar* _tmp42_;
	GamesScoresScore* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = NULL;
	_g_object_unref0 (_vala_category);
	_vala_category = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (line, " ", 0);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp2_ = tokens;
	_tmp2__length1 = tokens_length1;
	if (_tmp2__length1 != 5) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp3_ = tokens;
	_tmp3__length1 = tokens_length1;
	_tmp4_ = _tmp3_[0];
	date = games_scores_history_file_importer_parse_date (_tmp4_);
	if (date == ((gint64) 0)) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp5_ = tokens;
	_tmp5__length1 = tokens_length1;
	_tmp6_ = _tmp5_[1];
	_tmp8_ = uint64_try_parse (_tmp6_, &_tmp7_, NULL, (guint) 0);
	number_64 = _tmp7_;
	if (!_tmp8_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	if (number_64 == ((guint64) 0)) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = number_64 > ((guint64) 255);
	}
	if (_tmp9_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	cols = (guint8) number_64;
	_tmp10_ = tokens;
	_tmp10__length1 = tokens_length1;
	_tmp11_ = _tmp10_[2];
	_tmp13_ = uint64_try_parse (_tmp11_, &_tmp12_, NULL, (guint) 0);
	number_64 = _tmp12_;
	if (!_tmp13_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	if (number_64 == ((guint64) 0)) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = number_64 > ((guint64) 255);
	}
	if (_tmp14_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	rows = (guint8) number_64;
	_tmp15_ = g_strdup ("");
	id = _tmp15_;
	_tmp16_ = swell_foop_window_sizes;
	_tmp16__length1 = swell_foop_window_sizes_length1;
	{
		SwellFoopWindowSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp16_;
		size_collection_length1 = _tmp16__length1;
		for (size_it = 0; size_it < size_collection_length1; size_it = size_it + 1) {
			SwellFoopWindowSize size = {0};
			size = size_collection[size_it];
			{
				gboolean _tmp17_ = FALSE;
				SwellFoopWindowSize _tmp18_;
				_tmp18_ = size;
				if (_tmp18_.rows == rows) {
					SwellFoopWindowSize _tmp19_;
					_tmp19_ = size;
					_tmp17_ = _tmp19_.columns == cols;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					SwellFoopWindowSize _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp20_ = size;
					_tmp21_ = _tmp20_.id;
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (id);
					id = _tmp22_;
					break;
				}
			}
		}
	}
	_tmp23_ = id;
	if (g_strcmp0 (_tmp23_, "") == 0) {
		_g_free0 (id);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp24_ = tokens;
	_tmp24__length1 = tokens_length1;
	_tmp25_ = _tmp24_[3];
	_tmp27_ = uint64_try_parse (_tmp25_, &_tmp26_, NULL, (guint) 0);
	number_64 = _tmp26_;
	if (!_tmp27_) {
		_g_free0 (id);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	if (number_64 < ((guint64) 2)) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = number_64 > ((guint64) 4);
	}
	if (_tmp28_) {
		_g_free0 (id);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	colors = (guint8) number_64;
	_tmp29_ = tokens;
	_tmp29__length1 = tokens_length1;
	_tmp30_ = _tmp29_[4];
	_tmp32_ = uint64_try_parse (_tmp30_, &_tmp31_, NULL, (guint) 0);
	number_64 = _tmp31_;
	if (!_tmp32_) {
		_g_free0 (id);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	if (number_64 > ((guint64) G_MAXLONG)) {
		_g_free0 (id);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	score_value = (glong) number_64;
	_tmp33_ = id;
	_tmp34_ = string_to_string (_tmp33_);
	_tmp35_ = g_strdup_printf ("%hhu", colors);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat (_tmp34_, "-", _tmp36_, NULL);
	_tmp38_ = _tmp37_;
	_tmp39_ = swell_foop_window_category_request (self, _tmp38_);
	_g_object_unref0 (_vala_category);
	_vala_category = _tmp39_;
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	_tmp40_ = games_scores_score_new (score_value, date, NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = _tmp40_;
	_tmp41_ = _vala_score;
	_tmp42_ = g_get_real_name ();
	games_scores_score_set_user (_tmp41_, _tmp42_);
	_tmp43_ = _vala_score;
	_tmp44_ = games_scores_score_get_user (_tmp43_);
	_tmp45_ = _tmp44_;
	if (g_strcmp0 (_tmp45_, "Unknown") == 0) {
		GamesScoresScore* _tmp46_;
		const gchar* _tmp47_;
		_tmp46_ = _vala_score;
		_tmp47_ = g_get_user_name ();
		games_scores_score_set_user (_tmp46_, _tmp47_);
	}
	_g_free0 (id);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	if (score) {
		*score = _vala_score;
	} else {
		_g_object_unref0 (_vala_score);
	}
	if (category) {
		*category = _vala_category;
	} else {
		_g_object_unref0 (_vala_category);
	}
}

static void
__lambda8_ (SwellFoopWindow* self,
            GObject* object,
            GAsyncResult* _result_)
{
	GamesScoresContext* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->scores_context;
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("window.vala:496: Failed to add score: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->scores_context;
	games_scores_context_run_dialog (_tmp3_);
}

static void
___lambda8__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda8_ ((SwellFoopWindow*) self, source_object, res);
	g_object_unref (self);
}

static inline void
swell_foop_window_add_score (SwellFoopWindow* self)
{
	gchar* id = NULL;
	SwellFoopWindowSize _tmp0_ = {0};
	SwellFoopWindowSize _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	Game* _tmp4_;
	guint8 _tmp5_;
	guint8 _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GamesScoresCategory* category = NULL;
	GHashTable* _tmp11_;
	gconstpointer _tmp12_;
	GamesScoresCategory* _tmp13_;
	GamesScoresContext* _tmp14_;
	Game* _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	g_return_if_fail (self != NULL);
	swell_foop_window_get_board_size (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_.id;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = self->priv->game;
	_tmp5_ = game_get_color_num (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%hhu", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp3_, "-", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	swell_foop_window_size_destroy (&_tmp1_);
	id = _tmp10_;
	_tmp11_ = swell_foop_window_score_categories;
	_tmp12_ = g_hash_table_lookup (_tmp11_, id);
	_tmp13_ = _g_object_ref0 ((GamesScoresCategory*) _tmp12_);
	category = _tmp13_;
	if (category == NULL) {
		g_assert_not_reached ();
	}
	_tmp14_ = self->priv->scores_context;
	_tmp15_ = self->priv->game;
	_tmp16_ = game_get_score (_tmp15_);
	_tmp17_ = _tmp16_;
	games_scores_context_add_score (_tmp14_, (glong) _tmp17_, G_TYPE_CHECK_INSTANCE_CAST (category, GAMES_SCORES_TYPE_CATEGORY, GamesScoresCategory), NULL, ___lambda8__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (category);
	_g_free0 (id);
}

static void
_game_view_board_left_cb_gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                            gpointer self)
{
	game_view_board_left_cb ((GameView*) self);
}

static inline void
swell_foop_window_init_motion (SwellFoopWindow* self)
{
	GameView* _tmp0_;
	GtkEventControllerMotion* _tmp1_;
	GtkEventControllerMotion* _tmp2_;
	GtkEventControllerMotion* _tmp3_;
	GameView* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ((GtkWidget*) _tmp0_);
	_g_object_unref0 (self->priv->motion_controller);
	self->priv->motion_controller = _tmp1_;
	_tmp2_ = self->priv->motion_controller;
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp2_, GTK_PHASE_CAPTURE);
	_tmp3_ = self->priv->motion_controller;
	_tmp4_ = self->priv->view;
	g_signal_connect_object (_tmp3_, "leave", (GCallback) _game_view_board_left_cb_gtk_event_controller_motion_leave, _tmp4_, 0);
}

static void
swell_foop_window_size_copy (const SwellFoopWindowSize* self,
                             SwellFoopWindowSize* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).id);
	(*dest).id = _tmp1_;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
	(*dest).columns = (*self).columns;
	(*dest).rows = (*self).rows;
}

static void
swell_foop_window_size_destroy (SwellFoopWindowSize* self)
{
	_g_free0 ((*self).id);
	_g_free0 ((*self).name);
}

static SwellFoopWindowSize*
swell_foop_window_size_dup (const SwellFoopWindowSize* self)
{
	SwellFoopWindowSize* dup;
	dup = g_new0 (SwellFoopWindowSize, 1);
	swell_foop_window_size_copy (self, dup);
	return dup;
}

static void
swell_foop_window_size_free (SwellFoopWindowSize* self)
{
	swell_foop_window_size_destroy (self);
	g_free (self);
}

static GType
swell_foop_window_size_get_type_once (void)
{
	GType swell_foop_window_size_type_id;
	swell_foop_window_size_type_id = g_boxed_type_register_static ("SwellFoopWindowSize", (GBoxedCopyFunc) swell_foop_window_size_dup, (GBoxedFreeFunc) swell_foop_window_size_free);
	return swell_foop_window_size_type_id;
}

static GType
swell_foop_window_size_get_type (void)
{
	static volatile gsize swell_foop_window_size_type_id__once = 0;
	if (g_once_init_enter (&swell_foop_window_size_type_id__once)) {
		GType swell_foop_window_size_type_id;
		swell_foop_window_size_type_id = swell_foop_window_size_get_type_once ();
		g_once_init_leave (&swell_foop_window_size_type_id__once, swell_foop_window_size_type_id);
	}
	return swell_foop_window_size_type_id__once;
}

static void
_swell_foop_window___lambda10_ (SwellFoopWindow* self,
                                GSettings* _settings,
                                const gchar* _key_name)
{
	GameView* _tmp0_;
	g_return_if_fail (_settings != NULL);
	g_return_if_fail (_key_name != NULL);
	_tmp0_ = self->priv->view;
	game_view_set_is_zealous (_tmp0_, g_settings_get_boolean (_settings, _key_name));
}

static void
__swell_foop_window___lambda10__g_settings_changed (GSettings* _sender,
                                                    const gchar* key,
                                                    gpointer self)
{
	_swell_foop_window___lambda10_ ((SwellFoopWindow*) self, _sender, key);
}

static GObject *
swell_foop_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwellFoopWindow * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GAction* _tmp2_;
	GAction* _tmp3_;
	GSettings* _tmp4_;
	GAction* _tmp5_;
	GAction* _tmp6_;
	GSettings* _tmp7_;
	gchar* theme = NULL;
	GSettings* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	GSimpleAction* theme_action = NULL;
	GAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GSimpleAction* _tmp18_;
	const gchar* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	gint32 colors = 0;
	GSettings* _tmp22_;
	GSimpleAction* colors_action = NULL;
	GAction* _tmp23_;
	GSimpleAction* _tmp24_;
	GSimpleAction* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GVariant* _tmp28_;
	GVariant* _tmp29_;
	GameView* _tmp30_;
	GameView* _tmp31_;
	gboolean first_run = FALSE;
	GSettings* _tmp32_;
	parent_class = G_OBJECT_CLASS (swell_foop_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SWELL_FOOP_WINDOW, SwellFoopWindow);
	_tmp0_ = g_settings_new ("org.gnome.SwellFoop");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) self, SWELL_FOOP_WINDOW_win_actions, (gint) G_N_ELEMENTS (SWELL_FOOP_WINDOW_win_actions), self);
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_create_action (_tmp1_, "size");
	_tmp3_ = _tmp2_;
	g_action_map_add_action ((GActionMap*) self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_create_action (_tmp4_, "zealous");
	_tmp6_ = _tmp5_;
	g_action_map_add_action ((GActionMap*) self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->settings;
	g_signal_connect_object (_tmp7_, "changed::zealous", (GCallback) __swell_foop_window___lambda10__g_settings_changed, self, 0);
	_tmp8_ = self->priv->settings;
	_tmp9_ = g_settings_get_string (_tmp8_, "theme");
	theme = _tmp9_;
	_tmp12_ = theme;
	if (g_strcmp0 (_tmp12_, "colors") != 0) {
		const gchar* _tmp13_;
		_tmp13_ = theme;
		_tmp11_ = g_strcmp0 (_tmp13_, "shapesandcolors") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		const gchar* _tmp14_;
		_tmp14_ = theme;
		_tmp10_ = g_strcmp0 (_tmp14_, "boringshapes") != 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("shapesandcolors");
		_g_free0 (theme);
		theme = _tmp15_;
	}
	_tmp16_ = g_action_map_lookup_action ((GActionMap*) self, "change-theme");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_simple_action_get_type (), GSimpleAction));
	theme_action = _tmp17_;
	_tmp18_ = theme_action;
	_tmp19_ = theme;
	_tmp20_ = g_variant_new_string (_tmp19_);
	g_variant_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	g_simple_action_set_state (_tmp18_, _tmp21_);
	_g_variant_unref0 (_tmp21_);
	_tmp22_ = self->priv->settings;
	colors = (gint32) g_settings_get_int (_tmp22_, "colors");
	_tmp23_ = g_action_map_lookup_action ((GActionMap*) self, "change-colors");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, g_simple_action_get_type (), GSimpleAction));
	colors_action = _tmp24_;
	_tmp25_ = colors_action;
	_tmp26_ = g_strdup_printf ("%i", colors);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_variant_new_string (_tmp27_);
	g_variant_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	g_simple_action_set_state (_tmp25_, _tmp29_);
	_g_variant_unref0 (_tmp29_);
	_g_free0 (_tmp27_);
	gtk_widget_add_events ((GtkWidget*) self, (gint) (GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK));
	swell_foop_window_init_scores (self);
	swell_foop_window_update_score_cb (self);
	_tmp30_ = game_view_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp30_;
	_tmp31_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp31_);
	_tmp32_ = self->priv->settings;
	first_run = g_settings_get_boolean (_tmp32_, "first-run");
	if (first_run) {
		GtkStack* stack = NULL;
		GtkStack* _tmp33_;
		GtkStack* _tmp34_;
		GameView* _tmp35_;
		GtkBox* _tmp36_;
		GtkStack* _tmp37_;
		_tmp33_ = swell_foop_window_build_first_run_stack (self);
		stack = _tmp33_;
		_tmp34_ = stack;
		_tmp35_ = self->priv->view;
		gtk_stack_add_named (_tmp34_, (GtkWidget*) _tmp35_, "game");
		_tmp36_ = self->priv->main_box;
		_tmp37_ = stack;
		gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, TRUE, TRUE, (guint) 0);
		_g_object_unref0 (stack);
	} else {
		GtkBox* _tmp38_;
		GameView* _tmp39_;
		_tmp38_ = self->priv->main_box;
		_tmp39_ = self->priv->view;
		gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp39_, TRUE, TRUE, (guint) 0);
		swell_foop_window_init_keyboard (self);
	}
	_g_object_unref0 (colors_action);
	_g_object_unref0 (theme_action);
	_g_free0 (theme);
	return obj;
}

static void
swell_foop_window_base_init (SwellFoopWindowClass * klass)
{
	swell_foop_window_class_init_sizes ();
	swell_foop_window_class_init_scores ();
}

static void
swell_foop_window_class_init (SwellFoopWindowClass * klass,
                              gpointer klass_data)
{
	swell_foop_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwellFoopWindow_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) swell_foop_window_real_destroy;
	G_OBJECT_CLASS (klass)->constructor = swell_foop_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = swell_foop_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/SwellFoop/ui/swell-foop.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, SwellFoopWindow_private_offset + G_STRUCT_OFFSET (SwellFoopWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_box", FALSE, SwellFoopWindow_private_offset + G_STRUCT_OFFSET (SwellFoopWindowPrivate, main_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hamburger_button", FALSE, SwellFoopWindow_private_offset + G_STRUCT_OFFSET (SwellFoopWindowPrivate, hamburger_button));
}

static void
swell_foop_window_instance_init (SwellFoopWindow * self,
                                 gpointer klass)
{
	self->priv = swell_foop_window_get_instance_private (self);
	self->priv->game = NULL;
	self->priv->game_in_progress = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
swell_foop_window_finalize (GObject * obj)
{
	SwellFoopWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SWELL_FOOP_WINDOW, SwellFoopWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->redo_action);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->scores_context);
	_g_object_unref0 (self->priv->motion_controller);
	G_OBJECT_CLASS (swell_foop_window_parent_class)->finalize (obj);
}

static GType
swell_foop_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwellFoopWindowClass), (GBaseInitFunc) swell_foop_window_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) swell_foop_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwellFoopWindow), 0, (GInstanceInitFunc) swell_foop_window_instance_init, NULL };
	GType swell_foop_window_type_id;
	swell_foop_window_type_id = g_type_register_static (gtk_application_window_get_type (), "SwellFoopWindow", &g_define_type_info, 0);
	SwellFoopWindow_private_offset = g_type_add_instance_private (swell_foop_window_type_id, sizeof (SwellFoopWindowPrivate));
	return swell_foop_window_type_id;
}

GType
swell_foop_window_get_type (void)
{
	static volatile gsize swell_foop_window_type_id__once = 0;
	if (g_once_init_enter (&swell_foop_window_type_id__once)) {
		GType swell_foop_window_type_id;
		swell_foop_window_type_id = swell_foop_window_get_type_once ();
		g_once_init_leave (&swell_foop_window_type_id__once, swell_foop_window_type_id);
	}
	return swell_foop_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

