# This file has been autogenerated by the pywayland scanner

# Copyright © 2014      Jonas Ådahl
# Copyright © 2015      Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations


from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from ..wayland import WlPointer
from .zwp_relative_pointer_v1 import ZwpRelativePointerV1


class ZwpRelativePointerManagerV1(Interface):
    """Get relative pointer objects

    A global interface used for getting the relative pointer object for a given
    pointer.
    """

    name = "zwp_relative_pointer_manager_v1"
    version = 1


class ZwpRelativePointerManagerV1Proxy(Proxy[ZwpRelativePointerManagerV1]):
    interface = ZwpRelativePointerManagerV1

    @ZwpRelativePointerManagerV1.request()
    def destroy(self) -> None:
        """Destroy the relative pointer manager object

        Used by the client to notify the server that it will no longer use this
        relative pointer manager object.
        """
        self._marshal(0)
        self._destroy()

    @ZwpRelativePointerManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZwpRelativePointerV1),
        Argument(ArgumentType.Object, interface=WlPointer),
    )
    def get_relative_pointer(self, pointer: WlPointer) -> Proxy[ZwpRelativePointerV1]:
        """Get a relative pointer object

        Create a relative pointer interface given a
        :class:`~pywayland.protocol.wayland.WlPointer` object. See the
        wp_relative_pointer interface for more details.

        :param pointer:
        :type pointer:
            :class:`~pywayland.protocol.wayland.WlPointer`
        :returns:
            :class:`~pywayland.protocol.relative_pointer_unstable_v1.ZwpRelativePointerV1`
        """
        id = self._marshal_constructor(1, ZwpRelativePointerV1, pointer)
        return id


class ZwpRelativePointerManagerV1Resource(Resource):
    interface = ZwpRelativePointerManagerV1


class ZwpRelativePointerManagerV1Global(Global):
    interface = ZwpRelativePointerManagerV1


ZwpRelativePointerManagerV1._gen_c()
ZwpRelativePointerManagerV1.proxy_class = ZwpRelativePointerManagerV1Proxy
ZwpRelativePointerManagerV1.resource_class = ZwpRelativePointerManagerV1Resource
ZwpRelativePointerManagerV1.global_class = ZwpRelativePointerManagerV1Global
