// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from rp2040.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/RaspberryPi

//go:build rp && rp2040
// +build rp,rp2040

//
//
//     Copyright (c) 2020 Raspberry Pi (Trading) Ltd.
//
//     SPDX-License-Identifier: BSD-3-Clause
package rp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "RP2040"
	CPU          = "CM0PLUS"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// Controls time and alarms
	// time is a 64 bit value indicating the time in usec since power-on
	// timeh is the top 32 bits of time & timel is the bottom 32 bits
	// to change time write to timelw before timehw
	// to read time read from timelr before timehr
	// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
	// When an alarm is pending, the corresponding alarm_running signal will be high
	// An alarm can be cancelled before it has finished by clearing the alarm_enable
	// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
	// To clear the interrupt write a 1 to the corresponding alarm_irq
	IRQ_TIMER_IRQ_0 = 0

	// Controls time and alarms
	// time is a 64 bit value indicating the time in usec since power-on
	// timeh is the top 32 bits of time & timel is the bottom 32 bits
	// to change time write to timelw before timehw
	// to read time read from timelr before timehr
	// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
	// When an alarm is pending, the corresponding alarm_running signal will be high
	// An alarm can be cancelled before it has finished by clearing the alarm_enable
	// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
	// To clear the interrupt write a 1 to the corresponding alarm_irq
	IRQ_TIMER_IRQ_1 = 1

	// Controls time and alarms
	// time is a 64 bit value indicating the time in usec since power-on
	// timeh is the top 32 bits of time & timel is the bottom 32 bits
	// to change time write to timelw before timehw
	// to read time read from timelr before timehr
	// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
	// When an alarm is pending, the corresponding alarm_running signal will be high
	// An alarm can be cancelled before it has finished by clearing the alarm_enable
	// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
	// To clear the interrupt write a 1 to the corresponding alarm_irq
	IRQ_TIMER_IRQ_2 = 2

	// Controls time and alarms
	// time is a 64 bit value indicating the time in usec since power-on
	// timeh is the top 32 bits of time & timel is the bottom 32 bits
	// to change time write to timelw before timehw
	// to read time read from timelr before timehr
	// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
	// When an alarm is pending, the corresponding alarm_running signal will be high
	// An alarm can be cancelled before it has finished by clearing the alarm_enable
	// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
	// To clear the interrupt write a 1 to the corresponding alarm_irq
	IRQ_TIMER_IRQ_3 = 3

	// Simple PWM
	IRQ_PWM_IRQ_WRAP = 4

	// USB FS/LS controller device registers
	IRQ_USBCTRL_IRQ = 5

	// QSPI flash execute-in-place block
	IRQ_XIP_IRQ = 6

	// Programmable IO block
	IRQ_PIO0_IRQ_0 = 7

	// Programmable IO block
	IRQ_PIO0_IRQ_1 = 8

	IRQ_PIO1_IRQ_0 = 9

	IRQ_PIO1_IRQ_1 = 10

	// DMA with separate read and write masters
	IRQ_DMA_IRQ_0 = 11

	// DMA with separate read and write masters
	IRQ_DMA_IRQ_1 = 12

	IRQ_IO_IRQ_BANK0 = 13

	IRQ_IO_IRQ_QSPI = 14

	// Single-cycle IO block
	// Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	IRQ_SIO_IRQ_PROC0 = 15

	// Single-cycle IO block
	// Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	IRQ_SIO_IRQ_PROC1 = 16

	IRQ_CLOCKS_IRQ = 17

	IRQ_SPI0_IRQ = 18

	IRQ_SPI1_IRQ = 19

	IRQ_UART0_IRQ = 20

	IRQ_UART1_IRQ = 21

	// Control and data interface to SAR ADC
	IRQ_ADC_IRQ_FIFO = 22

	// DW_apb_i2c address block
	IRQ_I2C0_IRQ = 23

	IRQ_I2C1_IRQ = 24

	// Register block to control RTC
	IRQ_RTC_IRQ = 25

	// Highest interrupt number on this device.
	IRQ_max = 25
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export TIMER_IRQ_0_IRQHandler
func interruptTIMER_IRQ_0() {
	callHandlers(IRQ_TIMER_IRQ_0)
}

//export TIMER_IRQ_1_IRQHandler
func interruptTIMER_IRQ_1() {
	callHandlers(IRQ_TIMER_IRQ_1)
}

//export TIMER_IRQ_2_IRQHandler
func interruptTIMER_IRQ_2() {
	callHandlers(IRQ_TIMER_IRQ_2)
}

//export TIMER_IRQ_3_IRQHandler
func interruptTIMER_IRQ_3() {
	callHandlers(IRQ_TIMER_IRQ_3)
}

//export PWM_IRQ_WRAP_IRQHandler
func interruptPWM_IRQ_WRAP() {
	callHandlers(IRQ_PWM_IRQ_WRAP)
}

//export USBCTRL_IRQ_IRQHandler
func interruptUSBCTRL_IRQ() {
	callHandlers(IRQ_USBCTRL_IRQ)
}

//export XIP_IRQ_IRQHandler
func interruptXIP_IRQ() {
	callHandlers(IRQ_XIP_IRQ)
}

//export PIO0_IRQ_0_IRQHandler
func interruptPIO0_IRQ_0() {
	callHandlers(IRQ_PIO0_IRQ_0)
}

//export PIO0_IRQ_1_IRQHandler
func interruptPIO0_IRQ_1() {
	callHandlers(IRQ_PIO0_IRQ_1)
}

//export PIO1_IRQ_0_IRQHandler
func interruptPIO1_IRQ_0() {
	callHandlers(IRQ_PIO1_IRQ_0)
}

//export PIO1_IRQ_1_IRQHandler
func interruptPIO1_IRQ_1() {
	callHandlers(IRQ_PIO1_IRQ_1)
}

//export DMA_IRQ_0_IRQHandler
func interruptDMA_IRQ_0() {
	callHandlers(IRQ_DMA_IRQ_0)
}

//export DMA_IRQ_1_IRQHandler
func interruptDMA_IRQ_1() {
	callHandlers(IRQ_DMA_IRQ_1)
}

//export IO_IRQ_BANK0_IRQHandler
func interruptIO_IRQ_BANK0() {
	callHandlers(IRQ_IO_IRQ_BANK0)
}

//export IO_IRQ_QSPI_IRQHandler
func interruptIO_IRQ_QSPI() {
	callHandlers(IRQ_IO_IRQ_QSPI)
}

//export SIO_IRQ_PROC0_IRQHandler
func interruptSIO_IRQ_PROC0() {
	callHandlers(IRQ_SIO_IRQ_PROC0)
}

//export SIO_IRQ_PROC1_IRQHandler
func interruptSIO_IRQ_PROC1() {
	callHandlers(IRQ_SIO_IRQ_PROC1)
}

//export CLOCKS_IRQ_IRQHandler
func interruptCLOCKS_IRQ() {
	callHandlers(IRQ_CLOCKS_IRQ)
}

//export SPI0_IRQ_IRQHandler
func interruptSPI0_IRQ() {
	callHandlers(IRQ_SPI0_IRQ)
}

//export SPI1_IRQ_IRQHandler
func interruptSPI1_IRQ() {
	callHandlers(IRQ_SPI1_IRQ)
}

//export UART0_IRQ_IRQHandler
func interruptUART0_IRQ() {
	callHandlers(IRQ_UART0_IRQ)
}

//export UART1_IRQ_IRQHandler
func interruptUART1_IRQ() {
	callHandlers(IRQ_UART1_IRQ)
}

//export ADC_IRQ_FIFO_IRQHandler
func interruptADC_IRQ_FIFO() {
	callHandlers(IRQ_ADC_IRQ_FIFO)
}

//export I2C0_IRQ_IRQHandler
func interruptI2C0_IRQ() {
	callHandlers(IRQ_I2C0_IRQ)
}

//export I2C1_IRQ_IRQHandler
func interruptI2C1_IRQ() {
	callHandlers(IRQ_I2C1_IRQ)
}

//export RTC_IRQ_IRQHandler
func interruptRTC_IRQ() {
	callHandlers(IRQ_RTC_IRQ)
}

// Peripherals.
var (
	// QSPI flash execute-in-place block
	XIP_CTRL = (*XIP_CTRL_Type)(unsafe.Pointer(uintptr(0x14000000)))

	// DW_apb_ssi has the following features:
	// * APB interface – Allows for easy integration into a DesignWare Synthesizable Components for AMBA 2 implementation.
	// * APB3 and APB4 protocol support.
	// * Scalable APB data bus width – Supports APB data bus widths of 8, 16, and 32 bits.
	// * Serial-master or serial-slave operation – Enables serial communication with serial-master or serial-slave peripheral devices.
	// * Programmable Dual/Quad/Octal SPI support in Master Mode.
	// * Dual Data Rate (DDR) and Read Data Strobe (RDS) Support - Enables the DW_apb_ssi master to perform operations with the device in DDR and RDS modes when working in Dual/Quad/Octal mode of operation.
	// * Data Mask Support - Enables the DW_apb_ssi to selectively update the bytes in the device. This feature is applicable only in enhanced SPI modes.
	// * eXecute-In-Place (XIP) support - Enables the DW_apb_ssi master to behave as a memory mapped I/O and fetches the data from the device based on the APB read request. This feature is applicable only in enhanced SPI modes.
	// * DMA Controller Interface – Enables the DW_apb_ssi to interface to a DMA controller over the bus using a handshaking interface for transfer requests.
	// * Independent masking of interrupts – Master collision, transmit FIFO overflow, transmit FIFO empty, receive FIFO full, receive FIFO underflow, and receive FIFO overflow interrupts can all be masked independently.
	// * Multi-master contention detection – Informs the processor of multiple serial-master accesses on the serial bus.
	// * Bypass of meta-stability flip-flops for synchronous clocks – When the APB clock (pclk) and the DW_apb_ssi serial clock (ssi_clk) are synchronous, meta-stable flip-flops are not used when transferring control signals across these clock domains.
	// * Programmable delay on the sample time of the received serial data bit (rxd); enables programmable control of routing delays resulting in higher serial data-bit rates.
	// * Programmable features:
	// - Serial interface operation – Choice of Motorola SPI, Texas Instruments Synchronous Serial Protocol or National Semiconductor Microwire.
	// - Clock bit-rate – Dynamic control of the serial bit rate of the data transfer; used in only serial-master mode of operation.
	// - Data Item size (4 to 32 bits) – Item size of each data transfer under the control of the programmer.
	// * Configured features:
	// - FIFO depth – 16 words deep. The FIFO width is fixed at 32 bits.
	// - 1 slave select output.
	// - Hardware slave-select – Dedicated hardware slave-select line.
	// - Combined interrupt line - one combined interrupt line from the DW_apb_ssi to the interrupt controller.
	// - Interrupt polarity – active high interrupt lines.
	// - Serial clock polarity – low serial-clock polarity directly after reset.
	// - Serial clock phase – capture on first edge of serial-clock directly after reset.
	XIP_SSI = (*XIP_SSI_Type)(unsafe.Pointer(uintptr(0x18000000)))

	SYSINFO = (*SYSINFO_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Register block for various chip control signals
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40004000)))

	CLOCKS = (*CLOCKS_Type)(unsafe.Pointer(uintptr(0x40008000)))

	RESETS = (*RESETS_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	PSM = (*PSM_Type)(unsafe.Pointer(uintptr(0x40010000)))

	IO_BANK0 = (*IO_BANK0_Type)(unsafe.Pointer(uintptr(0x40014000)))

	IO_QSPI = (*IO_QSPI_Type)(unsafe.Pointer(uintptr(0x40018000)))

	PADS_BANK0 = (*PADS_BANK0_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	PADS_QSPI = (*PADS_QSPI_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Controls the crystal oscillator
	XOSC = (*XOSC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	PLL_SYS = (*PLL_SYS_Type)(unsafe.Pointer(uintptr(0x40028000)))

	PLL_USB = (*PLL_SYS_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// Register block for busfabric control signals and performance counters
	BUSCTRL = (*BUSCTRL_Type)(unsafe.Pointer(uintptr(0x40030000)))

	UART0 = (*UART0_Type)(unsafe.Pointer(uintptr(0x40034000)))

	UART1 = (*UART0_Type)(unsafe.Pointer(uintptr(0x40038000)))

	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	SPI1 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// DW_apb_i2c address block
	I2C0 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// DW_apb_i2c address block
	I2C1 = (*I2C0_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// Control and data interface to SAR ADC
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x4004c000)))

	// Simple PWM
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0x40050000)))

	// Controls time and alarms
	// time is a 64 bit value indicating the time in usec since power-on
	// timeh is the top 32 bits of time & timel is the bottom 32 bits
	// to change time write to timelw before timehw
	// to read time read from timelr before timehr
	// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
	// When an alarm is pending, the corresponding alarm_running signal will be high
	// An alarm can be cancelled before it has finished by clearing the alarm_enable
	// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
	// To clear the interrupt write a 1 to the corresponding alarm_irq
	TIMER = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40054000)))

	WATCHDOG = (*WATCHDOG_Type)(unsafe.Pointer(uintptr(0x40058000)))

	// Register block to control RTC
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	ROSC = (*ROSC_Type)(unsafe.Pointer(uintptr(0x40060000)))

	// control and status for on-chip voltage regulator and chip level reset subsystem
	VREG_AND_CHIP_RESET = (*VREG_AND_CHIP_RESET_Type)(unsafe.Pointer(uintptr(0x40064000)))

	// Testbench manager. Allows the programmer to know what platform their software is running on.
	TBMAN = (*TBMAN_Type)(unsafe.Pointer(uintptr(0x4006c000)))

	// DMA with separate read and write masters
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// USB FS/LS controller device registers
	USBCTRL_REGS = (*USBCTRL_REGS_Type)(unsafe.Pointer(uintptr(0x50110000)))

	// Programmable IO block
	PIO0 = (*PIO0_Type)(unsafe.Pointer(uintptr(0x50200000)))

	// Programmable IO block
	PIO1 = (*PIO0_Type)(unsafe.Pointer(uintptr(0x50300000)))

	// Single-cycle IO block
	// Provides core-local and inter-core hardware for the two processors, with single-cycle access.
	SIO = (*SIO_Type)(unsafe.Pointer(uintptr(0xd0000000)))

	PPB = (*PPB_Type)(unsafe.Pointer(uintptr(0xe0000000)))
)

// QSPI flash execute-in-place block
type XIP_CTRL_Type struct {
	CTRL        volatile.Register32 // 0x0
	FLUSH       volatile.Register32 // 0x4
	STAT        volatile.Register32 // 0x8
	CTR_HIT     volatile.Register32 // 0xC
	CTR_ACC     volatile.Register32 // 0x10
	STREAM_ADDR volatile.Register32 // 0x14
	STREAM_CTR  volatile.Register32 // 0x18
	STREAM_FIFO volatile.Register32 // 0x1C
}

// XIP_CTRL.CTRL: Cache control
func (o *XIP_CTRL_Type) SetCTRL_POWER_DOWN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *XIP_CTRL_Type) GetCTRL_POWER_DOWN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *XIP_CTRL_Type) SetCTRL_ERR_BADWRITE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *XIP_CTRL_Type) GetCTRL_ERR_BADWRITE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *XIP_CTRL_Type) SetCTRL_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *XIP_CTRL_Type) GetCTRL_EN() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}

// XIP_CTRL.FLUSH: Cache Flush control
func (o *XIP_CTRL_Type) SetFLUSH(value uint32) {
	volatile.StoreUint32(&o.FLUSH.Reg, volatile.LoadUint32(&o.FLUSH.Reg)&^(0x1)|value)
}
func (o *XIP_CTRL_Type) GetFLUSH() uint32 {
	return volatile.LoadUint32(&o.FLUSH.Reg) & 0x1
}

// XIP_CTRL.STAT: Cache Status
func (o *XIP_CTRL_Type) SetSTAT_FIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4)|value<<2)
}
func (o *XIP_CTRL_Type) GetSTAT_FIFO_FULL() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4) >> 2
}
func (o *XIP_CTRL_Type) SetSTAT_FIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2)|value<<1)
}
func (o *XIP_CTRL_Type) GetSTAT_FIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2) >> 1
}
func (o *XIP_CTRL_Type) SetSTAT_FLUSH_READY(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *XIP_CTRL_Type) GetSTAT_FLUSH_READY() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}

// XIP_CTRL.STREAM_ADDR: FIFO stream address
func (o *XIP_CTRL_Type) SetSTREAM_ADDR(value uint32) {
	volatile.StoreUint32(&o.STREAM_ADDR.Reg, volatile.LoadUint32(&o.STREAM_ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *XIP_CTRL_Type) GetSTREAM_ADDR() uint32 {
	return (volatile.LoadUint32(&o.STREAM_ADDR.Reg) & 0xfffffffc) >> 2
}

// XIP_CTRL.STREAM_CTR: FIFO stream control
func (o *XIP_CTRL_Type) SetSTREAM_CTR(value uint32) {
	volatile.StoreUint32(&o.STREAM_CTR.Reg, volatile.LoadUint32(&o.STREAM_CTR.Reg)&^(0x3fffff)|value)
}
func (o *XIP_CTRL_Type) GetSTREAM_CTR() uint32 {
	return volatile.LoadUint32(&o.STREAM_CTR.Reg) & 0x3fffff
}

// DW_apb_ssi has the following features:
// * APB interface – Allows for easy integration into a DesignWare Synthesizable Components for AMBA 2 implementation.
// * APB3 and APB4 protocol support.
// * Scalable APB data bus width – Supports APB data bus widths of 8, 16, and 32 bits.
// * Serial-master or serial-slave operation – Enables serial communication with serial-master or serial-slave peripheral devices.
// * Programmable Dual/Quad/Octal SPI support in Master Mode.
// * Dual Data Rate (DDR) and Read Data Strobe (RDS) Support - Enables the DW_apb_ssi master to perform operations with the device in DDR and RDS modes when working in Dual/Quad/Octal mode of operation.
// * Data Mask Support - Enables the DW_apb_ssi to selectively update the bytes in the device. This feature is applicable only in enhanced SPI modes.
// * eXecute-In-Place (XIP) support - Enables the DW_apb_ssi master to behave as a memory mapped I/O and fetches the data from the device based on the APB read request. This feature is applicable only in enhanced SPI modes.
// * DMA Controller Interface – Enables the DW_apb_ssi to interface to a DMA controller over the bus using a handshaking interface for transfer requests.
// * Independent masking of interrupts – Master collision, transmit FIFO overflow, transmit FIFO empty, receive FIFO full, receive FIFO underflow, and receive FIFO overflow interrupts can all be masked independently.
// * Multi-master contention detection – Informs the processor of multiple serial-master accesses on the serial bus.
// * Bypass of meta-stability flip-flops for synchronous clocks – When the APB clock (pclk) and the DW_apb_ssi serial clock (ssi_clk) are synchronous, meta-stable flip-flops are not used when transferring control signals across these clock domains.
// * Programmable delay on the sample time of the received serial data bit (rxd); enables programmable control of routing delays resulting in higher serial data-bit rates.
// * Programmable features:
// - Serial interface operation – Choice of Motorola SPI, Texas Instruments Synchronous Serial Protocol or National Semiconductor Microwire.
// - Clock bit-rate – Dynamic control of the serial bit rate of the data transfer; used in only serial-master mode of operation.
// - Data Item size (4 to 32 bits) – Item size of each data transfer under the control of the programmer.
// * Configured features:
// - FIFO depth – 16 words deep. The FIFO width is fixed at 32 bits.
// - 1 slave select output.
// - Hardware slave-select – Dedicated hardware slave-select line.
// - Combined interrupt line - one combined interrupt line from the DW_apb_ssi to the interrupt controller.
// - Interrupt polarity – active high interrupt lines.
// - Serial clock polarity – low serial-clock polarity directly after reset.
// - Serial clock phase – capture on first edge of serial-clock directly after reset.
type XIP_SSI_Type struct {
	CTRLR0         volatile.Register32 // 0x0
	CTRLR1         volatile.Register32 // 0x4
	SSIENR         volatile.Register32 // 0x8
	MWCR           volatile.Register32 // 0xC
	SER            volatile.Register32 // 0x10
	BAUDR          volatile.Register32 // 0x14
	TXFTLR         volatile.Register32 // 0x18
	RXFTLR         volatile.Register32 // 0x1C
	TXFLR          volatile.Register32 // 0x20
	RXFLR          volatile.Register32 // 0x24
	SR             volatile.Register32 // 0x28
	IMR            volatile.Register32 // 0x2C
	ISR            volatile.Register32 // 0x30
	RISR           volatile.Register32 // 0x34
	TXOICR         volatile.Register32 // 0x38
	RXOICR         volatile.Register32 // 0x3C
	RXUICR         volatile.Register32 // 0x40
	MSTICR         volatile.Register32 // 0x44
	ICR            volatile.Register32 // 0x48
	DMACR          volatile.Register32 // 0x4C
	DMATDLR        volatile.Register32 // 0x50
	DMARDLR        volatile.Register32 // 0x54
	IDR            volatile.Register32 // 0x58
	SSI_VERSION_ID volatile.Register32 // 0x5C
	DR0            volatile.Register32 // 0x60
	_              [140]byte
	RX_SAMPLE_DLY  volatile.Register32 // 0xF0
	SPI_CTRLR0     volatile.Register32 // 0xF4
	TXD_DRIVE_EDGE volatile.Register32 // 0xF8
}

// XIP_SSI.CTRLR0: Control register 0
func (o *XIP_SSI_Type) SetCTRLR0_SSTE(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x1000000)|value<<24)
}
func (o *XIP_SSI_Type) GetCTRLR0_SSTE() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x1000000) >> 24
}
func (o *XIP_SSI_Type) SetCTRLR0_SPI_FRF(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x600000)|value<<21)
}
func (o *XIP_SSI_Type) GetCTRLR0_SPI_FRF() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x600000) >> 21
}
func (o *XIP_SSI_Type) SetCTRLR0_DFS_32(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x1f0000)|value<<16)
}
func (o *XIP_SSI_Type) GetCTRLR0_DFS_32() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x1f0000) >> 16
}
func (o *XIP_SSI_Type) SetCTRLR0_CFS(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0xf000)|value<<12)
}
func (o *XIP_SSI_Type) GetCTRLR0_CFS() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0xf000) >> 12
}
func (o *XIP_SSI_Type) SetCTRLR0_SRL(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x800)|value<<11)
}
func (o *XIP_SSI_Type) GetCTRLR0_SRL() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x800) >> 11
}
func (o *XIP_SSI_Type) SetCTRLR0_SLV_OE(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x400)|value<<10)
}
func (o *XIP_SSI_Type) GetCTRLR0_SLV_OE() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x400) >> 10
}
func (o *XIP_SSI_Type) SetCTRLR0_TMOD(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x300)|value<<8)
}
func (o *XIP_SSI_Type) GetCTRLR0_TMOD() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x300) >> 8
}
func (o *XIP_SSI_Type) SetCTRLR0_SCPOL(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x80)|value<<7)
}
func (o *XIP_SSI_Type) GetCTRLR0_SCPOL() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x80) >> 7
}
func (o *XIP_SSI_Type) SetCTRLR0_SCPH(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x40)|value<<6)
}
func (o *XIP_SSI_Type) GetCTRLR0_SCPH() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x40) >> 6
}
func (o *XIP_SSI_Type) SetCTRLR0_FRF(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0x30)|value<<4)
}
func (o *XIP_SSI_Type) GetCTRLR0_FRF() uint32 {
	return (volatile.LoadUint32(&o.CTRLR0.Reg) & 0x30) >> 4
}
func (o *XIP_SSI_Type) SetCTRLR0_DFS(value uint32) {
	volatile.StoreUint32(&o.CTRLR0.Reg, volatile.LoadUint32(&o.CTRLR0.Reg)&^(0xf)|value)
}
func (o *XIP_SSI_Type) GetCTRLR0_DFS() uint32 {
	return volatile.LoadUint32(&o.CTRLR0.Reg) & 0xf
}

// XIP_SSI.CTRLR1: Master Control register 1
func (o *XIP_SSI_Type) SetCTRLR1_NDF(value uint32) {
	volatile.StoreUint32(&o.CTRLR1.Reg, volatile.LoadUint32(&o.CTRLR1.Reg)&^(0xffff)|value)
}
func (o *XIP_SSI_Type) GetCTRLR1_NDF() uint32 {
	return volatile.LoadUint32(&o.CTRLR1.Reg) & 0xffff
}

// XIP_SSI.SSIENR: SSI Enable
func (o *XIP_SSI_Type) SetSSIENR_SSI_EN(value uint32) {
	volatile.StoreUint32(&o.SSIENR.Reg, volatile.LoadUint32(&o.SSIENR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetSSIENR_SSI_EN() uint32 {
	return volatile.LoadUint32(&o.SSIENR.Reg) & 0x1
}

// XIP_SSI.MWCR: Microwire Control
func (o *XIP_SSI_Type) SetMWCR_MHS(value uint32) {
	volatile.StoreUint32(&o.MWCR.Reg, volatile.LoadUint32(&o.MWCR.Reg)&^(0x4)|value<<2)
}
func (o *XIP_SSI_Type) GetMWCR_MHS() uint32 {
	return (volatile.LoadUint32(&o.MWCR.Reg) & 0x4) >> 2
}
func (o *XIP_SSI_Type) SetMWCR_MDD(value uint32) {
	volatile.StoreUint32(&o.MWCR.Reg, volatile.LoadUint32(&o.MWCR.Reg)&^(0x2)|value<<1)
}
func (o *XIP_SSI_Type) GetMWCR_MDD() uint32 {
	return (volatile.LoadUint32(&o.MWCR.Reg) & 0x2) >> 1
}
func (o *XIP_SSI_Type) SetMWCR_MWMOD(value uint32) {
	volatile.StoreUint32(&o.MWCR.Reg, volatile.LoadUint32(&o.MWCR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetMWCR_MWMOD() uint32 {
	return volatile.LoadUint32(&o.MWCR.Reg) & 0x1
}

// XIP_SSI.SER: Slave enable
func (o *XIP_SSI_Type) SetSER(value uint32) {
	volatile.StoreUint32(&o.SER.Reg, volatile.LoadUint32(&o.SER.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetSER() uint32 {
	return volatile.LoadUint32(&o.SER.Reg) & 0x1
}

// XIP_SSI.BAUDR: Baud rate
func (o *XIP_SSI_Type) SetBAUDR_SCKDV(value uint32) {
	volatile.StoreUint32(&o.BAUDR.Reg, volatile.LoadUint32(&o.BAUDR.Reg)&^(0xffff)|value)
}
func (o *XIP_SSI_Type) GetBAUDR_SCKDV() uint32 {
	return volatile.LoadUint32(&o.BAUDR.Reg) & 0xffff
}

// XIP_SSI.TXFTLR: TX FIFO threshold level
func (o *XIP_SSI_Type) SetTXFTLR_TFT(value uint32) {
	volatile.StoreUint32(&o.TXFTLR.Reg, volatile.LoadUint32(&o.TXFTLR.Reg)&^(0xff)|value)
}
func (o *XIP_SSI_Type) GetTXFTLR_TFT() uint32 {
	return volatile.LoadUint32(&o.TXFTLR.Reg) & 0xff
}

// XIP_SSI.RXFTLR: RX FIFO threshold level
func (o *XIP_SSI_Type) SetRXFTLR_RFT(value uint32) {
	volatile.StoreUint32(&o.RXFTLR.Reg, volatile.LoadUint32(&o.RXFTLR.Reg)&^(0xff)|value)
}
func (o *XIP_SSI_Type) GetRXFTLR_RFT() uint32 {
	return volatile.LoadUint32(&o.RXFTLR.Reg) & 0xff
}

// XIP_SSI.TXFLR: TX FIFO level
func (o *XIP_SSI_Type) SetTXFLR_TFTFL(value uint32) {
	volatile.StoreUint32(&o.TXFLR.Reg, volatile.LoadUint32(&o.TXFLR.Reg)&^(0xff)|value)
}
func (o *XIP_SSI_Type) GetTXFLR_TFTFL() uint32 {
	return volatile.LoadUint32(&o.TXFLR.Reg) & 0xff
}

// XIP_SSI.RXFLR: RX FIFO level
func (o *XIP_SSI_Type) SetRXFLR_RXTFL(value uint32) {
	volatile.StoreUint32(&o.RXFLR.Reg, volatile.LoadUint32(&o.RXFLR.Reg)&^(0xff)|value)
}
func (o *XIP_SSI_Type) GetRXFLR_RXTFL() uint32 {
	return volatile.LoadUint32(&o.RXFLR.Reg) & 0xff
}

// XIP_SSI.SR: Status register
func (o *XIP_SSI_Type) SetSR_DCOL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *XIP_SSI_Type) GetSR_DCOL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *XIP_SSI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *XIP_SSI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *XIP_SSI_Type) SetSR_RFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *XIP_SSI_Type) GetSR_RFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *XIP_SSI_Type) SetSR_RFNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *XIP_SSI_Type) GetSR_RFNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *XIP_SSI_Type) SetSR_TFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *XIP_SSI_Type) GetSR_TFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *XIP_SSI_Type) SetSR_TFNF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *XIP_SSI_Type) GetSR_TFNF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *XIP_SSI_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetSR_BUSY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// XIP_SSI.IMR: Interrupt mask
func (o *XIP_SSI_Type) SetIMR_MSTIM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *XIP_SSI_Type) GetIMR_MSTIM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *XIP_SSI_Type) SetIMR_RXFIM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *XIP_SSI_Type) GetIMR_RXFIM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *XIP_SSI_Type) SetIMR_RXOIM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *XIP_SSI_Type) GetIMR_RXOIM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *XIP_SSI_Type) SetIMR_RXUIM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *XIP_SSI_Type) GetIMR_RXUIM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *XIP_SSI_Type) SetIMR_TXOIM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *XIP_SSI_Type) GetIMR_TXOIM() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *XIP_SSI_Type) SetIMR_TXEIM(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetIMR_TXEIM() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// XIP_SSI.ISR: Interrupt status
func (o *XIP_SSI_Type) SetISR_MSTIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *XIP_SSI_Type) GetISR_MSTIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *XIP_SSI_Type) SetISR_RXFIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *XIP_SSI_Type) GetISR_RXFIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *XIP_SSI_Type) SetISR_RXOIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *XIP_SSI_Type) GetISR_RXOIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *XIP_SSI_Type) SetISR_RXUIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *XIP_SSI_Type) GetISR_RXUIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *XIP_SSI_Type) SetISR_TXOIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *XIP_SSI_Type) GetISR_TXOIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *XIP_SSI_Type) SetISR_TXEIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetISR_TXEIS() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// XIP_SSI.RISR: Raw interrupt status
func (o *XIP_SSI_Type) SetRISR_MSTIR(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x20)|value<<5)
}
func (o *XIP_SSI_Type) GetRISR_MSTIR() uint32 {
	return (volatile.LoadUint32(&o.RISR.Reg) & 0x20) >> 5
}
func (o *XIP_SSI_Type) SetRISR_RXFIR(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x10)|value<<4)
}
func (o *XIP_SSI_Type) GetRISR_RXFIR() uint32 {
	return (volatile.LoadUint32(&o.RISR.Reg) & 0x10) >> 4
}
func (o *XIP_SSI_Type) SetRISR_RXOIR(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x8)|value<<3)
}
func (o *XIP_SSI_Type) GetRISR_RXOIR() uint32 {
	return (volatile.LoadUint32(&o.RISR.Reg) & 0x8) >> 3
}
func (o *XIP_SSI_Type) SetRISR_RXUIR(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x4)|value<<2)
}
func (o *XIP_SSI_Type) GetRISR_RXUIR() uint32 {
	return (volatile.LoadUint32(&o.RISR.Reg) & 0x4) >> 2
}
func (o *XIP_SSI_Type) SetRISR_TXOIR(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x2)|value<<1)
}
func (o *XIP_SSI_Type) GetRISR_TXOIR() uint32 {
	return (volatile.LoadUint32(&o.RISR.Reg) & 0x2) >> 1
}
func (o *XIP_SSI_Type) SetRISR_TXEIR(value uint32) {
	volatile.StoreUint32(&o.RISR.Reg, volatile.LoadUint32(&o.RISR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetRISR_TXEIR() uint32 {
	return volatile.LoadUint32(&o.RISR.Reg) & 0x1
}

// XIP_SSI.TXOICR: TX FIFO overflow interrupt clear
func (o *XIP_SSI_Type) SetTXOICR(value uint32) {
	volatile.StoreUint32(&o.TXOICR.Reg, volatile.LoadUint32(&o.TXOICR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetTXOICR() uint32 {
	return volatile.LoadUint32(&o.TXOICR.Reg) & 0x1
}

// XIP_SSI.RXOICR: RX FIFO overflow interrupt clear
func (o *XIP_SSI_Type) SetRXOICR(value uint32) {
	volatile.StoreUint32(&o.RXOICR.Reg, volatile.LoadUint32(&o.RXOICR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetRXOICR() uint32 {
	return volatile.LoadUint32(&o.RXOICR.Reg) & 0x1
}

// XIP_SSI.RXUICR: RX FIFO underflow interrupt clear
func (o *XIP_SSI_Type) SetRXUICR(value uint32) {
	volatile.StoreUint32(&o.RXUICR.Reg, volatile.LoadUint32(&o.RXUICR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetRXUICR() uint32 {
	return volatile.LoadUint32(&o.RXUICR.Reg) & 0x1
}

// XIP_SSI.MSTICR: Multi-master interrupt clear
func (o *XIP_SSI_Type) SetMSTICR(value uint32) {
	volatile.StoreUint32(&o.MSTICR.Reg, volatile.LoadUint32(&o.MSTICR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetMSTICR() uint32 {
	return volatile.LoadUint32(&o.MSTICR.Reg) & 0x1
}

// XIP_SSI.ICR: Interrupt clear
func (o *XIP_SSI_Type) SetICR(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetICR() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// XIP_SSI.DMACR: DMA control
func (o *XIP_SSI_Type) SetDMACR_TDMAE(value uint32) {
	volatile.StoreUint32(&o.DMACR.Reg, volatile.LoadUint32(&o.DMACR.Reg)&^(0x2)|value<<1)
}
func (o *XIP_SSI_Type) GetDMACR_TDMAE() uint32 {
	return (volatile.LoadUint32(&o.DMACR.Reg) & 0x2) >> 1
}
func (o *XIP_SSI_Type) SetDMACR_RDMAE(value uint32) {
	volatile.StoreUint32(&o.DMACR.Reg, volatile.LoadUint32(&o.DMACR.Reg)&^(0x1)|value)
}
func (o *XIP_SSI_Type) GetDMACR_RDMAE() uint32 {
	return volatile.LoadUint32(&o.DMACR.Reg) & 0x1
}

// XIP_SSI.DMATDLR: DMA TX data level
func (o *XIP_SSI_Type) SetDMATDLR_DMATDL(value uint32) {
	volatile.StoreUint32(&o.DMATDLR.Reg, volatile.LoadUint32(&o.DMATDLR.Reg)&^(0xff)|value)
}
func (o *XIP_SSI_Type) GetDMATDLR_DMATDL() uint32 {
	return volatile.LoadUint32(&o.DMATDLR.Reg) & 0xff
}

// XIP_SSI.DMARDLR: DMA RX data level
func (o *XIP_SSI_Type) SetDMARDLR_DMARDL(value uint32) {
	volatile.StoreUint32(&o.DMARDLR.Reg, volatile.LoadUint32(&o.DMARDLR.Reg)&^(0xff)|value)
}
func (o *XIP_SSI_Type) GetDMARDLR_DMARDL() uint32 {
	return volatile.LoadUint32(&o.DMARDLR.Reg) & 0xff
}

// XIP_SSI.IDR: Identification register
func (o *XIP_SSI_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, value)
}
func (o *XIP_SSI_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg)
}

// XIP_SSI.SSI_VERSION_ID: Version ID
func (o *XIP_SSI_Type) SetSSI_VERSION_ID(value uint32) {
	volatile.StoreUint32(&o.SSI_VERSION_ID.Reg, value)
}
func (o *XIP_SSI_Type) GetSSI_VERSION_ID() uint32 {
	return volatile.LoadUint32(&o.SSI_VERSION_ID.Reg)
}

// XIP_SSI.DR0: Data Register 0 (of 36)
func (o *XIP_SSI_Type) SetDR0(value uint32) {
	volatile.StoreUint32(&o.DR0.Reg, value)
}
func (o *XIP_SSI_Type) GetDR0() uint32 {
	return volatile.LoadUint32(&o.DR0.Reg)
}

// XIP_SSI.RX_SAMPLE_DLY: RX sample delay
func (o *XIP_SSI_Type) SetRX_SAMPLE_DLY_RSD(value uint32) {
	volatile.StoreUint32(&o.RX_SAMPLE_DLY.Reg, volatile.LoadUint32(&o.RX_SAMPLE_DLY.Reg)&^(0xff)|value)
}
func (o *XIP_SSI_Type) GetRX_SAMPLE_DLY_RSD() uint32 {
	return volatile.LoadUint32(&o.RX_SAMPLE_DLY.Reg) & 0xff
}

// XIP_SSI.SPI_CTRLR0: SPI control
func (o *XIP_SSI_Type) SetSPI_CTRLR0_XIP_CMD(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0xff000000)|value<<24)
}
func (o *XIP_SSI_Type) GetSPI_CTRLR0_XIP_CMD() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0xff000000) >> 24
}
func (o *XIP_SSI_Type) SetSPI_CTRLR0_SPI_RXDS_EN(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x40000)|value<<18)
}
func (o *XIP_SSI_Type) GetSPI_CTRLR0_SPI_RXDS_EN() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x40000) >> 18
}
func (o *XIP_SSI_Type) SetSPI_CTRLR0_INST_DDR_EN(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x20000)|value<<17)
}
func (o *XIP_SSI_Type) GetSPI_CTRLR0_INST_DDR_EN() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x20000) >> 17
}
func (o *XIP_SSI_Type) SetSPI_CTRLR0_SPI_DDR_EN(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x10000)|value<<16)
}
func (o *XIP_SSI_Type) GetSPI_CTRLR0_SPI_DDR_EN() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x10000) >> 16
}
func (o *XIP_SSI_Type) SetSPI_CTRLR0_WAIT_CYCLES(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0xf800)|value<<11)
}
func (o *XIP_SSI_Type) GetSPI_CTRLR0_WAIT_CYCLES() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0xf800) >> 11
}
func (o *XIP_SSI_Type) SetSPI_CTRLR0_INST_L(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x300)|value<<8)
}
func (o *XIP_SSI_Type) GetSPI_CTRLR0_INST_L() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x300) >> 8
}
func (o *XIP_SSI_Type) SetSPI_CTRLR0_ADDR_L(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x3c)|value<<2)
}
func (o *XIP_SSI_Type) GetSPI_CTRLR0_ADDR_L() uint32 {
	return (volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x3c) >> 2
}
func (o *XIP_SSI_Type) SetSPI_CTRLR0_TRANS_TYPE(value uint32) {
	volatile.StoreUint32(&o.SPI_CTRLR0.Reg, volatile.LoadUint32(&o.SPI_CTRLR0.Reg)&^(0x3)|value)
}
func (o *XIP_SSI_Type) GetSPI_CTRLR0_TRANS_TYPE() uint32 {
	return volatile.LoadUint32(&o.SPI_CTRLR0.Reg) & 0x3
}

// XIP_SSI.TXD_DRIVE_EDGE: TX drive edge
func (o *XIP_SSI_Type) SetTXD_DRIVE_EDGE_TDE(value uint32) {
	volatile.StoreUint32(&o.TXD_DRIVE_EDGE.Reg, volatile.LoadUint32(&o.TXD_DRIVE_EDGE.Reg)&^(0xff)|value)
}
func (o *XIP_SSI_Type) GetTXD_DRIVE_EDGE_TDE() uint32 {
	return volatile.LoadUint32(&o.TXD_DRIVE_EDGE.Reg) & 0xff
}

type SYSINFO_Type struct {
	CHIP_ID       volatile.Register32 // 0x0
	PLATFORM      volatile.Register32 // 0x4
	_             [56]byte
	GITREF_RP2040 volatile.Register32 // 0x40
}

// SYSINFO.CHIP_ID: JEDEC JEP-106 compliant chip identifier.
func (o *SYSINFO_Type) SetCHIP_ID_REVISION(value uint32) {
	volatile.StoreUint32(&o.CHIP_ID.Reg, volatile.LoadUint32(&o.CHIP_ID.Reg)&^(0xf0000000)|value<<28)
}
func (o *SYSINFO_Type) GetCHIP_ID_REVISION() uint32 {
	return (volatile.LoadUint32(&o.CHIP_ID.Reg) & 0xf0000000) >> 28
}
func (o *SYSINFO_Type) SetCHIP_ID_PART(value uint32) {
	volatile.StoreUint32(&o.CHIP_ID.Reg, volatile.LoadUint32(&o.CHIP_ID.Reg)&^(0xffff000)|value<<12)
}
func (o *SYSINFO_Type) GetCHIP_ID_PART() uint32 {
	return (volatile.LoadUint32(&o.CHIP_ID.Reg) & 0xffff000) >> 12
}
func (o *SYSINFO_Type) SetCHIP_ID_MANUFACTURER(value uint32) {
	volatile.StoreUint32(&o.CHIP_ID.Reg, volatile.LoadUint32(&o.CHIP_ID.Reg)&^(0xfff)|value)
}
func (o *SYSINFO_Type) GetCHIP_ID_MANUFACTURER() uint32 {
	return volatile.LoadUint32(&o.CHIP_ID.Reg) & 0xfff
}

// SYSINFO.PLATFORM: Platform register. Allows software to know what environment it is running in.
func (o *SYSINFO_Type) SetPLATFORM_ASIC(value uint32) {
	volatile.StoreUint32(&o.PLATFORM.Reg, volatile.LoadUint32(&o.PLATFORM.Reg)&^(0x2)|value<<1)
}
func (o *SYSINFO_Type) GetPLATFORM_ASIC() uint32 {
	return (volatile.LoadUint32(&o.PLATFORM.Reg) & 0x2) >> 1
}
func (o *SYSINFO_Type) SetPLATFORM_FPGA(value uint32) {
	volatile.StoreUint32(&o.PLATFORM.Reg, volatile.LoadUint32(&o.PLATFORM.Reg)&^(0x1)|value)
}
func (o *SYSINFO_Type) GetPLATFORM_FPGA() uint32 {
	return volatile.LoadUint32(&o.PLATFORM.Reg) & 0x1
}

// Register block for various chip control signals
type SYSCFG_Type struct {
	PROC0_NMI_MASK         volatile.Register32 // 0x0
	PROC1_NMI_MASK         volatile.Register32 // 0x4
	PROC_CONFIG            volatile.Register32 // 0x8
	PROC_IN_SYNC_BYPASS    volatile.Register32 // 0xC
	PROC_IN_SYNC_BYPASS_HI volatile.Register32 // 0x10
	DBGFORCE               volatile.Register32 // 0x14
	MEMPOWERDOWN           volatile.Register32 // 0x18
}

// SYSCFG.PROC_CONFIG: Configuration for processors
func (o *SYSCFG_Type) SetPROC_CONFIG_PROC1_DAP_INSTID(value uint32) {
	volatile.StoreUint32(&o.PROC_CONFIG.Reg, volatile.LoadUint32(&o.PROC_CONFIG.Reg)&^(0xf0000000)|value<<28)
}
func (o *SYSCFG_Type) GetPROC_CONFIG_PROC1_DAP_INSTID() uint32 {
	return (volatile.LoadUint32(&o.PROC_CONFIG.Reg) & 0xf0000000) >> 28
}
func (o *SYSCFG_Type) SetPROC_CONFIG_PROC0_DAP_INSTID(value uint32) {
	volatile.StoreUint32(&o.PROC_CONFIG.Reg, volatile.LoadUint32(&o.PROC_CONFIG.Reg)&^(0xf000000)|value<<24)
}
func (o *SYSCFG_Type) GetPROC_CONFIG_PROC0_DAP_INSTID() uint32 {
	return (volatile.LoadUint32(&o.PROC_CONFIG.Reg) & 0xf000000) >> 24
}
func (o *SYSCFG_Type) SetPROC_CONFIG_PROC1_HALTED(value uint32) {
	volatile.StoreUint32(&o.PROC_CONFIG.Reg, volatile.LoadUint32(&o.PROC_CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetPROC_CONFIG_PROC1_HALTED() uint32 {
	return (volatile.LoadUint32(&o.PROC_CONFIG.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetPROC_CONFIG_PROC0_HALTED(value uint32) {
	volatile.StoreUint32(&o.PROC_CONFIG.Reg, volatile.LoadUint32(&o.PROC_CONFIG.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetPROC_CONFIG_PROC0_HALTED() uint32 {
	return volatile.LoadUint32(&o.PROC_CONFIG.Reg) & 0x1
}

// SYSCFG.PROC_IN_SYNC_BYPASS
// For each bit, if 1, bypass the input synchronizer between that GPIO
// and the GPIO input register in the SIO. The input synchronizers should
// generally be unbypassed, to avoid injecting metastabilities into processors.
// If you're feeling brave, you can bypass to save two cycles of input
// latency. This register applies to GPIO 0...29.
func (o *SYSCFG_Type) SetPROC_IN_SYNC_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PROC_IN_SYNC_BYPASS.Reg, volatile.LoadUint32(&o.PROC_IN_SYNC_BYPASS.Reg)&^(0x3fffffff)|value)
}
func (o *SYSCFG_Type) GetPROC_IN_SYNC_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PROC_IN_SYNC_BYPASS.Reg) & 0x3fffffff
}

// SYSCFG.PROC_IN_SYNC_BYPASS_HI
// For each bit, if 1, bypass the input synchronizer between that GPIO
// and the GPIO input register in the SIO. The input synchronizers should
// generally be unbypassed, to avoid injecting metastabilities into processors.
// If you're feeling brave, you can bypass to save two cycles of input
// latency. This register applies to GPIO 30...35 (the QSPI IOs).
func (o *SYSCFG_Type) SetPROC_IN_SYNC_BYPASS_HI(value uint32) {
	volatile.StoreUint32(&o.PROC_IN_SYNC_BYPASS_HI.Reg, volatile.LoadUint32(&o.PROC_IN_SYNC_BYPASS_HI.Reg)&^(0x3f)|value)
}
func (o *SYSCFG_Type) GetPROC_IN_SYNC_BYPASS_HI() uint32 {
	return volatile.LoadUint32(&o.PROC_IN_SYNC_BYPASS_HI.Reg) & 0x3f
}

// SYSCFG.DBGFORCE: Directly control the SWD debug port of either processor
func (o *SYSCFG_Type) SetDBGFORCE_PROC1_ATTACH(value uint32) {
	volatile.StoreUint32(&o.DBGFORCE.Reg, volatile.LoadUint32(&o.DBGFORCE.Reg)&^(0x80)|value<<7)
}
func (o *SYSCFG_Type) GetDBGFORCE_PROC1_ATTACH() uint32 {
	return (volatile.LoadUint32(&o.DBGFORCE.Reg) & 0x80) >> 7
}
func (o *SYSCFG_Type) SetDBGFORCE_PROC1_SWCLK(value uint32) {
	volatile.StoreUint32(&o.DBGFORCE.Reg, volatile.LoadUint32(&o.DBGFORCE.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetDBGFORCE_PROC1_SWCLK() uint32 {
	return (volatile.LoadUint32(&o.DBGFORCE.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetDBGFORCE_PROC1_SWDI(value uint32) {
	volatile.StoreUint32(&o.DBGFORCE.Reg, volatile.LoadUint32(&o.DBGFORCE.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetDBGFORCE_PROC1_SWDI() uint32 {
	return (volatile.LoadUint32(&o.DBGFORCE.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetDBGFORCE_PROC1_SWDO(value uint32) {
	volatile.StoreUint32(&o.DBGFORCE.Reg, volatile.LoadUint32(&o.DBGFORCE.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetDBGFORCE_PROC1_SWDO() uint32 {
	return (volatile.LoadUint32(&o.DBGFORCE.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetDBGFORCE_PROC0_ATTACH(value uint32) {
	volatile.StoreUint32(&o.DBGFORCE.Reg, volatile.LoadUint32(&o.DBGFORCE.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetDBGFORCE_PROC0_ATTACH() uint32 {
	return (volatile.LoadUint32(&o.DBGFORCE.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetDBGFORCE_PROC0_SWCLK(value uint32) {
	volatile.StoreUint32(&o.DBGFORCE.Reg, volatile.LoadUint32(&o.DBGFORCE.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetDBGFORCE_PROC0_SWCLK() uint32 {
	return (volatile.LoadUint32(&o.DBGFORCE.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetDBGFORCE_PROC0_SWDI(value uint32) {
	volatile.StoreUint32(&o.DBGFORCE.Reg, volatile.LoadUint32(&o.DBGFORCE.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetDBGFORCE_PROC0_SWDI() uint32 {
	return (volatile.LoadUint32(&o.DBGFORCE.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetDBGFORCE_PROC0_SWDO(value uint32) {
	volatile.StoreUint32(&o.DBGFORCE.Reg, volatile.LoadUint32(&o.DBGFORCE.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetDBGFORCE_PROC0_SWDO() uint32 {
	return volatile.LoadUint32(&o.DBGFORCE.Reg) & 0x1
}

// SYSCFG.MEMPOWERDOWN
// Control power downs to memories. Set high to power down memories.
// Use with extreme caution
func (o *SYSCFG_Type) SetMEMPOWERDOWN_ROM(value uint32) {
	volatile.StoreUint32(&o.MEMPOWERDOWN.Reg, volatile.LoadUint32(&o.MEMPOWERDOWN.Reg)&^(0x80)|value<<7)
}
func (o *SYSCFG_Type) GetMEMPOWERDOWN_ROM() uint32 {
	return (volatile.LoadUint32(&o.MEMPOWERDOWN.Reg) & 0x80) >> 7
}
func (o *SYSCFG_Type) SetMEMPOWERDOWN_USB(value uint32) {
	volatile.StoreUint32(&o.MEMPOWERDOWN.Reg, volatile.LoadUint32(&o.MEMPOWERDOWN.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetMEMPOWERDOWN_USB() uint32 {
	return (volatile.LoadUint32(&o.MEMPOWERDOWN.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetMEMPOWERDOWN_SRAM5(value uint32) {
	volatile.StoreUint32(&o.MEMPOWERDOWN.Reg, volatile.LoadUint32(&o.MEMPOWERDOWN.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetMEMPOWERDOWN_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.MEMPOWERDOWN.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetMEMPOWERDOWN_SRAM4(value uint32) {
	volatile.StoreUint32(&o.MEMPOWERDOWN.Reg, volatile.LoadUint32(&o.MEMPOWERDOWN.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetMEMPOWERDOWN_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.MEMPOWERDOWN.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetMEMPOWERDOWN_SRAM3(value uint32) {
	volatile.StoreUint32(&o.MEMPOWERDOWN.Reg, volatile.LoadUint32(&o.MEMPOWERDOWN.Reg)&^(0x8)|value<<3)
}
func (o *SYSCFG_Type) GetMEMPOWERDOWN_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.MEMPOWERDOWN.Reg) & 0x8) >> 3
}
func (o *SYSCFG_Type) SetMEMPOWERDOWN_SRAM2(value uint32) {
	volatile.StoreUint32(&o.MEMPOWERDOWN.Reg, volatile.LoadUint32(&o.MEMPOWERDOWN.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetMEMPOWERDOWN_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.MEMPOWERDOWN.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetMEMPOWERDOWN_SRAM1(value uint32) {
	volatile.StoreUint32(&o.MEMPOWERDOWN.Reg, volatile.LoadUint32(&o.MEMPOWERDOWN.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetMEMPOWERDOWN_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.MEMPOWERDOWN.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetMEMPOWERDOWN_SRAM0(value uint32) {
	volatile.StoreUint32(&o.MEMPOWERDOWN.Reg, volatile.LoadUint32(&o.MEMPOWERDOWN.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetMEMPOWERDOWN_SRAM0() uint32 {
	return volatile.LoadUint32(&o.MEMPOWERDOWN.Reg) & 0x1
}

type CLOCKS_Type struct {
	CLK_GPOUT0_CTRL      volatile.Register32 // 0x0
	CLK_GPOUT0_DIV       volatile.Register32 // 0x4
	CLK_GPOUT0_SELECTED  volatile.Register32 // 0x8
	CLK_GPOUT1_CTRL      volatile.Register32 // 0xC
	CLK_GPOUT1_DIV       volatile.Register32 // 0x10
	CLK_GPOUT1_SELECTED  volatile.Register32 // 0x14
	CLK_GPOUT2_CTRL      volatile.Register32 // 0x18
	CLK_GPOUT2_DIV       volatile.Register32 // 0x1C
	CLK_GPOUT2_SELECTED  volatile.Register32 // 0x20
	CLK_GPOUT3_CTRL      volatile.Register32 // 0x24
	CLK_GPOUT3_DIV       volatile.Register32 // 0x28
	CLK_GPOUT3_SELECTED  volatile.Register32 // 0x2C
	CLK_REF_CTRL         volatile.Register32 // 0x30
	CLK_REF_DIV          volatile.Register32 // 0x34
	CLK_REF_SELECTED     volatile.Register32 // 0x38
	CLK_SYS_CTRL         volatile.Register32 // 0x3C
	CLK_SYS_DIV          volatile.Register32 // 0x40
	CLK_SYS_SELECTED     volatile.Register32 // 0x44
	CLK_PERI_CTRL        volatile.Register32 // 0x48
	_                    [4]byte
	CLK_PERI_SELECTED    volatile.Register32 // 0x50
	CLK_USB_CTRL         volatile.Register32 // 0x54
	CLK_USB_DIV          volatile.Register32 // 0x58
	CLK_USB_SELECTED     volatile.Register32 // 0x5C
	CLK_ADC_CTRL         volatile.Register32 // 0x60
	CLK_ADC_DIV          volatile.Register32 // 0x64
	CLK_ADC_SELECTED     volatile.Register32 // 0x68
	CLK_RTC_CTRL         volatile.Register32 // 0x6C
	CLK_RTC_DIV          volatile.Register32 // 0x70
	CLK_RTC_SELECTED     volatile.Register32 // 0x74
	CLK_SYS_RESUS_CTRL   volatile.Register32 // 0x78
	CLK_SYS_RESUS_STATUS volatile.Register32 // 0x7C
	FC0_REF_KHZ          volatile.Register32 // 0x80
	FC0_MIN_KHZ          volatile.Register32 // 0x84
	FC0_MAX_KHZ          volatile.Register32 // 0x88
	FC0_DELAY            volatile.Register32 // 0x8C
	FC0_INTERVAL         volatile.Register32 // 0x90
	FC0_SRC              volatile.Register32 // 0x94
	FC0_STATUS           volatile.Register32 // 0x98
	FC0_RESULT           volatile.Register32 // 0x9C
	WAKE_EN0             volatile.Register32 // 0xA0
	WAKE_EN1             volatile.Register32 // 0xA4
	SLEEP_EN0            volatile.Register32 // 0xA8
	SLEEP_EN1            volatile.Register32 // 0xAC
	ENABLED0             volatile.Register32 // 0xB0
	ENABLED1             volatile.Register32 // 0xB4
	INTR                 volatile.Register32 // 0xB8
	INTE                 volatile.Register32 // 0xBC
	INTF                 volatile.Register32 // 0xC0
	INTS                 volatile.Register32 // 0xC4
}

// CLOCKS.CLK_GPOUT0_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_DC50(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_DC50() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_CTRL.Reg) & 0x1e0) >> 5
}

// CLOCKS.CLK_GPOUT0_DIV: Clock divisor, can be changed on-the-fly
func (o *CLOCKS_Type) SetCLK_GPOUT0_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_DIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT0_DIV.Reg) & 0xffffff00) >> 8
}
func (o *CLOCKS_Type) SetCLK_GPOUT0_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT0_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT0_DIV.Reg)&^(0xff)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT0_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT0_DIV.Reg) & 0xff
}

// CLOCKS.CLK_GPOUT1_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_DC50(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_DC50() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_CTRL.Reg) & 0x1e0) >> 5
}

// CLOCKS.CLK_GPOUT1_DIV: Clock divisor, can be changed on-the-fly
func (o *CLOCKS_Type) SetCLK_GPOUT1_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_DIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT1_DIV.Reg) & 0xffffff00) >> 8
}
func (o *CLOCKS_Type) SetCLK_GPOUT1_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT1_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT1_DIV.Reg)&^(0xff)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT1_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT1_DIV.Reg) & 0xff
}

// CLOCKS.CLK_GPOUT2_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_DC50(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_DC50() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_CTRL.Reg) & 0x1e0) >> 5
}

// CLOCKS.CLK_GPOUT2_DIV: Clock divisor, can be changed on-the-fly
func (o *CLOCKS_Type) SetCLK_GPOUT2_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_DIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT2_DIV.Reg) & 0xffffff00) >> 8
}
func (o *CLOCKS_Type) SetCLK_GPOUT2_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT2_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT2_DIV.Reg)&^(0xff)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT2_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT2_DIV.Reg) & 0xff
}

// CLOCKS.CLK_GPOUT3_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_DC50(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_DC50() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_CTRL.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_CTRL.Reg) & 0x1e0) >> 5
}

// CLOCKS.CLK_GPOUT3_DIV: Clock divisor, can be changed on-the-fly
func (o *CLOCKS_Type) SetCLK_GPOUT3_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_DIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_GPOUT3_DIV.Reg) & 0xffffff00) >> 8
}
func (o *CLOCKS_Type) SetCLK_GPOUT3_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CLK_GPOUT3_DIV.Reg, volatile.LoadUint32(&o.CLK_GPOUT3_DIV.Reg)&^(0xff)|value)
}
func (o *CLOCKS_Type) GetCLK_GPOUT3_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CLK_GPOUT3_DIV.Reg) & 0xff
}

// CLOCKS.CLK_REF_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_REF_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_REF_CTRL.Reg, volatile.LoadUint32(&o.CLK_REF_CTRL.Reg)&^(0x60)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_REF_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_REF_CTRL.Reg) & 0x60) >> 5
}
func (o *CLOCKS_Type) SetCLK_REF_CTRL_SRC(value uint32) {
	volatile.StoreUint32(&o.CLK_REF_CTRL.Reg, volatile.LoadUint32(&o.CLK_REF_CTRL.Reg)&^(0x3)|value)
}
func (o *CLOCKS_Type) GetCLK_REF_CTRL_SRC() uint32 {
	return volatile.LoadUint32(&o.CLK_REF_CTRL.Reg) & 0x3
}

// CLOCKS.CLK_REF_DIV: Clock divisor, can be changed on-the-fly
func (o *CLOCKS_Type) SetCLK_REF_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_REF_DIV.Reg, volatile.LoadUint32(&o.CLK_REF_DIV.Reg)&^(0x300)|value<<8)
}
func (o *CLOCKS_Type) GetCLK_REF_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_REF_DIV.Reg) & 0x300) >> 8
}

// CLOCKS.CLK_SYS_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_SYS_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_CTRL.Reg)&^(0xe0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_SYS_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_SYS_CTRL.Reg) & 0xe0) >> 5
}
func (o *CLOCKS_Type) SetCLK_SYS_CTRL_SRC(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_CTRL.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_SYS_CTRL_SRC() uint32 {
	return volatile.LoadUint32(&o.CLK_SYS_CTRL.Reg) & 0x1
}

// CLOCKS.CLK_SYS_DIV: Clock divisor, can be changed on-the-fly
func (o *CLOCKS_Type) SetCLK_SYS_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_DIV.Reg, volatile.LoadUint32(&o.CLK_SYS_DIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *CLOCKS_Type) GetCLK_SYS_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_SYS_DIV.Reg) & 0xffffff00) >> 8
}
func (o *CLOCKS_Type) SetCLK_SYS_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_DIV.Reg, volatile.LoadUint32(&o.CLK_SYS_DIV.Reg)&^(0xff)|value)
}
func (o *CLOCKS_Type) GetCLK_SYS_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CLK_SYS_DIV.Reg) & 0xff
}

// CLOCKS.CLK_PERI_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_PERI_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_PERI_CTRL.Reg, volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_PERI_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_PERI_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_PERI_CTRL.Reg, volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_PERI_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_PERI_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_PERI_CTRL.Reg, volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg)&^(0xe0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_PERI_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_PERI_CTRL.Reg) & 0xe0) >> 5
}

// CLOCKS.CLK_USB_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_USB_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_CTRL.Reg, volatile.LoadUint32(&o.CLK_USB_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_USB_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_USB_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_CTRL.Reg, volatile.LoadUint32(&o.CLK_USB_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_USB_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_USB_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_CTRL.Reg, volatile.LoadUint32(&o.CLK_USB_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_USB_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_USB_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_CTRL.Reg, volatile.LoadUint32(&o.CLK_USB_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_USB_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_USB_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_CTRL.Reg, volatile.LoadUint32(&o.CLK_USB_CTRL.Reg)&^(0xe0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_USB_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_CTRL.Reg) & 0xe0) >> 5
}

// CLOCKS.CLK_USB_DIV: Clock divisor, can be changed on-the-fly
func (o *CLOCKS_Type) SetCLK_USB_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_USB_DIV.Reg, volatile.LoadUint32(&o.CLK_USB_DIV.Reg)&^(0x300)|value<<8)
}
func (o *CLOCKS_Type) GetCLK_USB_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_USB_DIV.Reg) & 0x300) >> 8
}

// CLOCKS.CLK_ADC_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_ADC_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_CTRL.Reg, volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_ADC_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_ADC_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_CTRL.Reg, volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_ADC_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_ADC_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_CTRL.Reg, volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_ADC_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_ADC_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_CTRL.Reg, volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_ADC_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_ADC_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_CTRL.Reg, volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg)&^(0xe0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_ADC_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_CTRL.Reg) & 0xe0) >> 5
}

// CLOCKS.CLK_ADC_DIV: Clock divisor, can be changed on-the-fly
func (o *CLOCKS_Type) SetCLK_ADC_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_ADC_DIV.Reg, volatile.LoadUint32(&o.CLK_ADC_DIV.Reg)&^(0x300)|value<<8)
}
func (o *CLOCKS_Type) GetCLK_ADC_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_ADC_DIV.Reg) & 0x300) >> 8
}

// CLOCKS.CLK_RTC_CTRL: Clock control, can be changed on-the-fly (except for auxsrc)
func (o *CLOCKS_Type) SetCLK_RTC_CTRL_NUDGE(value uint32) {
	volatile.StoreUint32(&o.CLK_RTC_CTRL.Reg, volatile.LoadUint32(&o.CLK_RTC_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetCLK_RTC_CTRL_NUDGE() uint32 {
	return (volatile.LoadUint32(&o.CLK_RTC_CTRL.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetCLK_RTC_CTRL_PHASE(value uint32) {
	volatile.StoreUint32(&o.CLK_RTC_CTRL.Reg, volatile.LoadUint32(&o.CLK_RTC_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_RTC_CTRL_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CLK_RTC_CTRL.Reg) & 0x30000) >> 16
}
func (o *CLOCKS_Type) SetCLK_RTC_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_RTC_CTRL.Reg, volatile.LoadUint32(&o.CLK_RTC_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetCLK_RTC_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_RTC_CTRL.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetCLK_RTC_CTRL_KILL(value uint32) {
	volatile.StoreUint32(&o.CLK_RTC_CTRL.Reg, volatile.LoadUint32(&o.CLK_RTC_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetCLK_RTC_CTRL_KILL() uint32 {
	return (volatile.LoadUint32(&o.CLK_RTC_CTRL.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetCLK_RTC_CTRL_AUXSRC(value uint32) {
	volatile.StoreUint32(&o.CLK_RTC_CTRL.Reg, volatile.LoadUint32(&o.CLK_RTC_CTRL.Reg)&^(0xe0)|value<<5)
}
func (o *CLOCKS_Type) GetCLK_RTC_CTRL_AUXSRC() uint32 {
	return (volatile.LoadUint32(&o.CLK_RTC_CTRL.Reg) & 0xe0) >> 5
}

// CLOCKS.CLK_RTC_DIV: Clock divisor, can be changed on-the-fly
func (o *CLOCKS_Type) SetCLK_RTC_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CLK_RTC_DIV.Reg, volatile.LoadUint32(&o.CLK_RTC_DIV.Reg)&^(0xffffff00)|value<<8)
}
func (o *CLOCKS_Type) GetCLK_RTC_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLK_RTC_DIV.Reg) & 0xffffff00) >> 8
}
func (o *CLOCKS_Type) SetCLK_RTC_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CLK_RTC_DIV.Reg, volatile.LoadUint32(&o.CLK_RTC_DIV.Reg)&^(0xff)|value)
}
func (o *CLOCKS_Type) GetCLK_RTC_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CLK_RTC_DIV.Reg) & 0xff
}

// CLOCKS.CLK_SYS_RESUS_CTRL
func (o *CLOCKS_Type) SetCLK_SYS_RESUS_CTRL_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_RESUS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetCLK_SYS_RESUS_CTRL_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetCLK_SYS_RESUS_CTRL_FRCE(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_RESUS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetCLK_SYS_RESUS_CTRL_FRCE() uint32 {
	return (volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetCLK_SYS_RESUS_CTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_RESUS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetCLK_SYS_RESUS_CTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetCLK_SYS_RESUS_CTRL_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_RESUS_CTRL.Reg, volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg)&^(0xff)|value)
}
func (o *CLOCKS_Type) GetCLK_SYS_RESUS_CTRL_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.CLK_SYS_RESUS_CTRL.Reg) & 0xff
}

// CLOCKS.CLK_SYS_RESUS_STATUS
func (o *CLOCKS_Type) SetCLK_SYS_RESUS_STATUS_RESUSSED(value uint32) {
	volatile.StoreUint32(&o.CLK_SYS_RESUS_STATUS.Reg, volatile.LoadUint32(&o.CLK_SYS_RESUS_STATUS.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetCLK_SYS_RESUS_STATUS_RESUSSED() uint32 {
	return volatile.LoadUint32(&o.CLK_SYS_RESUS_STATUS.Reg) & 0x1
}

// CLOCKS.FC0_REF_KHZ: Reference clock frequency in kHz
func (o *CLOCKS_Type) SetFC0_REF_KHZ(value uint32) {
	volatile.StoreUint32(&o.FC0_REF_KHZ.Reg, volatile.LoadUint32(&o.FC0_REF_KHZ.Reg)&^(0xfffff)|value)
}
func (o *CLOCKS_Type) GetFC0_REF_KHZ() uint32 {
	return volatile.LoadUint32(&o.FC0_REF_KHZ.Reg) & 0xfffff
}

// CLOCKS.FC0_MIN_KHZ: Minimum pass frequency in kHz. This is optional. Set to 0 if you are not using the pass/fail flags
func (o *CLOCKS_Type) SetFC0_MIN_KHZ(value uint32) {
	volatile.StoreUint32(&o.FC0_MIN_KHZ.Reg, volatile.LoadUint32(&o.FC0_MIN_KHZ.Reg)&^(0x1ffffff)|value)
}
func (o *CLOCKS_Type) GetFC0_MIN_KHZ() uint32 {
	return volatile.LoadUint32(&o.FC0_MIN_KHZ.Reg) & 0x1ffffff
}

// CLOCKS.FC0_MAX_KHZ: Maximum pass frequency in kHz. This is optional. Set to 0x1ffffff if you are not using the pass/fail flags
func (o *CLOCKS_Type) SetFC0_MAX_KHZ(value uint32) {
	volatile.StoreUint32(&o.FC0_MAX_KHZ.Reg, volatile.LoadUint32(&o.FC0_MAX_KHZ.Reg)&^(0x1ffffff)|value)
}
func (o *CLOCKS_Type) GetFC0_MAX_KHZ() uint32 {
	return volatile.LoadUint32(&o.FC0_MAX_KHZ.Reg) & 0x1ffffff
}

// CLOCKS.FC0_DELAY
// Delays the start of frequency counting to allow the mux to settle
// Delay is measured in multiples of the reference clock period
func (o *CLOCKS_Type) SetFC0_DELAY(value uint32) {
	volatile.StoreUint32(&o.FC0_DELAY.Reg, volatile.LoadUint32(&o.FC0_DELAY.Reg)&^(0x7)|value)
}
func (o *CLOCKS_Type) GetFC0_DELAY() uint32 {
	return volatile.LoadUint32(&o.FC0_DELAY.Reg) & 0x7
}

// CLOCKS.FC0_INTERVAL
// The test interval is 0.98us * 2**interval, but let's call it 1us * 2**interval
// The default gives a test interval of 250us
func (o *CLOCKS_Type) SetFC0_INTERVAL(value uint32) {
	volatile.StoreUint32(&o.FC0_INTERVAL.Reg, volatile.LoadUint32(&o.FC0_INTERVAL.Reg)&^(0xf)|value)
}
func (o *CLOCKS_Type) GetFC0_INTERVAL() uint32 {
	return volatile.LoadUint32(&o.FC0_INTERVAL.Reg) & 0xf
}

// CLOCKS.FC0_SRC
// Clock sent to frequency counter, set to 0 when not required
// Writing to this register initiates the frequency count
func (o *CLOCKS_Type) SetFC0_SRC(value uint32) {
	volatile.StoreUint32(&o.FC0_SRC.Reg, volatile.LoadUint32(&o.FC0_SRC.Reg)&^(0xff)|value)
}
func (o *CLOCKS_Type) GetFC0_SRC() uint32 {
	return volatile.LoadUint32(&o.FC0_SRC.Reg) & 0xff
}

// CLOCKS.FC0_STATUS: Frequency counter status
func (o *CLOCKS_Type) SetFC0_STATUS_DIED(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetFC0_STATUS_DIED() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetFC0_STATUS_FAST(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *CLOCKS_Type) GetFC0_STATUS_FAST() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x1000000) >> 24
}
func (o *CLOCKS_Type) SetFC0_STATUS_SLOW(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetFC0_STATUS_SLOW() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetFC0_STATUS_FAIL(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetFC0_STATUS_FAIL() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetFC0_STATUS_WAITING(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetFC0_STATUS_WAITING() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetFC0_STATUS_RUNNING(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetFC0_STATUS_RUNNING() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetFC0_STATUS_DONE(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetFC0_STATUS_DONE() uint32 {
	return (volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetFC0_STATUS_PASS(value uint32) {
	volatile.StoreUint32(&o.FC0_STATUS.Reg, volatile.LoadUint32(&o.FC0_STATUS.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetFC0_STATUS_PASS() uint32 {
	return volatile.LoadUint32(&o.FC0_STATUS.Reg) & 0x1
}

// CLOCKS.FC0_RESULT: Result of frequency measurement, only valid when status_done=1
func (o *CLOCKS_Type) SetFC0_RESULT_KHZ(value uint32) {
	volatile.StoreUint32(&o.FC0_RESULT.Reg, volatile.LoadUint32(&o.FC0_RESULT.Reg)&^(0x3fffffe0)|value<<5)
}
func (o *CLOCKS_Type) GetFC0_RESULT_KHZ() uint32 {
	return (volatile.LoadUint32(&o.FC0_RESULT.Reg) & 0x3fffffe0) >> 5
}
func (o *CLOCKS_Type) SetFC0_RESULT_FRAC(value uint32) {
	volatile.StoreUint32(&o.FC0_RESULT.Reg, volatile.LoadUint32(&o.FC0_RESULT.Reg)&^(0x1f)|value)
}
func (o *CLOCKS_Type) GetFC0_RESULT_FRAC() uint32 {
	return volatile.LoadUint32(&o.FC0_RESULT.Reg) & 0x1f
}

// CLOCKS.WAKE_EN0: enable clock in wake mode
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_SRAM3(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x80000000) >> 31
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_SRAM2(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x40000000)|value<<30)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x40000000) >> 30
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_SRAM1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x20000000)|value<<29)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x20000000) >> 29
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_SRAM0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_SPI1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x8000000)|value<<27)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_SPI1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x8000000) >> 27
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_PERI_SPI1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x4000000)|value<<26)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_PERI_SPI1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x4000000) >> 26
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_SPI0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x2000000)|value<<25)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_SPI0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x2000000) >> 25
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_PERI_SPI0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x1000000)|value<<24)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_PERI_SPI0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x1000000) >> 24
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_SIO(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x800000)|value<<23)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_SIO() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x800000) >> 23
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_RTC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x400000)|value<<22)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_RTC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x400000) >> 22
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_RTC_RTC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x200000)|value<<21)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_RTC_RTC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x200000) >> 21
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_ROSC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_ROSC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_ROM(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x80000)|value<<19)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_ROM() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x80000) >> 19
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_RESETS(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x40000)|value<<18)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_RESETS() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x40000) >> 18
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PWM(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x20000)|value<<17)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PWM() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x20000) >> 17
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PSM(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PSM() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x8000)|value<<15)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x8000) >> 15
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PIO1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PIO1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PIO0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PIO0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_PADS(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_PADS() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_VREG_AND_CHIP_RESET(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_VREG_AND_CHIP_RESET() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_JTAG(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_JTAG() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_IO(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_IO() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_I2C1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_I2C1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_I2C0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_I2C0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_DMA(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_DMA() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_ADC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_ADC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_ADC_ADC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_ADC_ADC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetWAKE_EN0_CLK_SYS_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN0.Reg, volatile.LoadUint32(&o.WAKE_EN0.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetWAKE_EN0_CLK_SYS_CLOCKS() uint32 {
	return volatile.LoadUint32(&o.WAKE_EN0.Reg) & 0x1
}

// CLOCKS.WAKE_EN1: enable clock in wake mode
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_XOSC(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_XOSC() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_XIP(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_XIP() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_WATCHDOG(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_WATCHDOG() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_USB_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_USB_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_UART1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_UART1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_PERI_UART1(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_PERI_UART1() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_UART0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_UART0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_PERI_UART0(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_PERI_UART0() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_TIMER(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_TIMER() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_TBMAN(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM5(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetWAKE_EN1_CLK_SYS_SRAM4(value uint32) {
	volatile.StoreUint32(&o.WAKE_EN1.Reg, volatile.LoadUint32(&o.WAKE_EN1.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetWAKE_EN1_CLK_SYS_SRAM4() uint32 {
	return volatile.LoadUint32(&o.WAKE_EN1.Reg) & 0x1
}

// CLOCKS.SLEEP_EN0: enable clock in sleep mode
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_SRAM3(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x80000000) >> 31
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_SRAM2(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x40000000)|value<<30)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x40000000) >> 30
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_SRAM1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x20000000)|value<<29)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x20000000) >> 29
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_SRAM0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_SPI1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x8000000)|value<<27)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_SPI1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x8000000) >> 27
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_PERI_SPI1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x4000000)|value<<26)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_PERI_SPI1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x4000000) >> 26
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_SPI0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x2000000)|value<<25)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_SPI0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x2000000) >> 25
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_PERI_SPI0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x1000000)|value<<24)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_PERI_SPI0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x1000000) >> 24
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_SIO(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x800000)|value<<23)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_SIO() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x800000) >> 23
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_RTC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x400000)|value<<22)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_RTC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x400000) >> 22
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_RTC_RTC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x200000)|value<<21)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_RTC_RTC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x200000) >> 21
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_ROSC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_ROSC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_ROM(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x80000)|value<<19)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_ROM() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x80000) >> 19
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_RESETS(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x40000)|value<<18)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_RESETS() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x40000) >> 18
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PWM(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x20000)|value<<17)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PWM() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x20000) >> 17
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PSM(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PSM() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x8000)|value<<15)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x8000) >> 15
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PIO1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PIO1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PIO0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PIO0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_PADS(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_PADS() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_VREG_AND_CHIP_RESET(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_VREG_AND_CHIP_RESET() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_JTAG(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_JTAG() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_IO(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_IO() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_I2C1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_I2C1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_I2C0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_I2C0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_DMA(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_DMA() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_ADC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_ADC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_ADC_ADC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_ADC_ADC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetSLEEP_EN0_CLK_SYS_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN0.Reg, volatile.LoadUint32(&o.SLEEP_EN0.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetSLEEP_EN0_CLK_SYS_CLOCKS() uint32 {
	return volatile.LoadUint32(&o.SLEEP_EN0.Reg) & 0x1
}

// CLOCKS.SLEEP_EN1: enable clock in sleep mode
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_XOSC(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_XOSC() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_XIP(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_XIP() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_WATCHDOG(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_WATCHDOG() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_USB_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_USB_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_UART1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_UART1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_PERI_UART1(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_PERI_UART1() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_UART0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_UART0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_PERI_UART0(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_PERI_UART0() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_TIMER(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_TIMER() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_TBMAN(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM5(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetSLEEP_EN1_CLK_SYS_SRAM4(value uint32) {
	volatile.StoreUint32(&o.SLEEP_EN1.Reg, volatile.LoadUint32(&o.SLEEP_EN1.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetSLEEP_EN1_CLK_SYS_SRAM4() uint32 {
	return volatile.LoadUint32(&o.SLEEP_EN1.Reg) & 0x1
}

// CLOCKS.ENABLED0: indicates the state of the clock enable
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_SRAM3(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x80000000)|value<<31)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x80000000) >> 31
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_SRAM2(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x40000000)|value<<30)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x40000000) >> 30
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_SRAM1(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x20000000)|value<<29)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x20000000) >> 29
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_SRAM0(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x10000000)|value<<28)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x10000000) >> 28
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_SPI1(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x8000000)|value<<27)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_SPI1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x8000000) >> 27
}
func (o *CLOCKS_Type) SetENABLED0_CLK_PERI_SPI1(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x4000000)|value<<26)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_PERI_SPI1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x4000000) >> 26
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_SPI0(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x2000000)|value<<25)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_SPI0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x2000000) >> 25
}
func (o *CLOCKS_Type) SetENABLED0_CLK_PERI_SPI0(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x1000000)|value<<24)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_PERI_SPI0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x1000000) >> 24
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_SIO(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x800000)|value<<23)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_SIO() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x800000) >> 23
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_RTC(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x400000)|value<<22)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_RTC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x400000) >> 22
}
func (o *CLOCKS_Type) SetENABLED0_CLK_RTC_RTC(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x200000)|value<<21)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_RTC_RTC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x200000) >> 21
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_ROSC(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x100000)|value<<20)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_ROSC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x100000) >> 20
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_ROM(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x80000)|value<<19)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_ROM() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x80000) >> 19
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_RESETS(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x40000)|value<<18)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_RESETS() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x40000) >> 18
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PWM(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x20000)|value<<17)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PWM() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x20000) >> 17
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PSM(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PSM() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x10000) >> 16
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x8000)|value<<15)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x8000) >> 15
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PIO1(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PIO1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PIO0(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PIO0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_PADS(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_PADS() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_VREG_AND_CHIP_RESET(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_VREG_AND_CHIP_RESET() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_JTAG(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_JTAG() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_IO(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_IO() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_I2C1(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_I2C1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_I2C0(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_I2C0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_DMA(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_DMA() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_ADC(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_ADC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetENABLED0_CLK_ADC_ADC(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_ADC_ADC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED0.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetENABLED0_CLK_SYS_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.ENABLED0.Reg, volatile.LoadUint32(&o.ENABLED0.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetENABLED0_CLK_SYS_CLOCKS() uint32 {
	return volatile.LoadUint32(&o.ENABLED0.Reg) & 0x1
}

// CLOCKS.ENABLED1: indicates the state of the clock enable
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_XOSC(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x4000)|value<<14)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_XOSC() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x4000) >> 14
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_XIP(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x2000)|value<<13)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_XIP() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x2000) >> 13
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_WATCHDOG(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x1000)|value<<12)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_WATCHDOG() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x1000) >> 12
}
func (o *CLOCKS_Type) SetENABLED1_CLK_USB_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x800)|value<<11)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_USB_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x800) >> 11
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x400)|value<<10)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x400) >> 10
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_UART1(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x200)|value<<9)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_UART1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x200) >> 9
}
func (o *CLOCKS_Type) SetENABLED1_CLK_PERI_UART1(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x100)|value<<8)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_PERI_UART1() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x100) >> 8
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_UART0(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x80)|value<<7)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_UART0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x80) >> 7
}
func (o *CLOCKS_Type) SetENABLED1_CLK_PERI_UART0(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x40)|value<<6)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_PERI_UART0() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x40) >> 6
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_TIMER(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x20)|value<<5)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_TIMER() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x20) >> 5
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_TBMAN(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x10)|value<<4)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x10) >> 4
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x8)|value<<3)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x8) >> 3
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x4)|value<<2)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x4) >> 2
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM5(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x2)|value<<1)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.ENABLED1.Reg) & 0x2) >> 1
}
func (o *CLOCKS_Type) SetENABLED1_CLK_SYS_SRAM4(value uint32) {
	volatile.StoreUint32(&o.ENABLED1.Reg, volatile.LoadUint32(&o.ENABLED1.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetENABLED1_CLK_SYS_SRAM4() uint32 {
	return volatile.LoadUint32(&o.ENABLED1.Reg) & 0x1
}

// CLOCKS.INTR: Raw Interrupts
func (o *CLOCKS_Type) SetINTR_CLK_SYS_RESUS(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetINTR_CLK_SYS_RESUS() uint32 {
	return volatile.LoadUint32(&o.INTR.Reg) & 0x1
}

// CLOCKS.INTE: Interrupt Enable
func (o *CLOCKS_Type) SetINTE_CLK_SYS_RESUS(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetINTE_CLK_SYS_RESUS() uint32 {
	return volatile.LoadUint32(&o.INTE.Reg) & 0x1
}

// CLOCKS.INTF: Interrupt Force
func (o *CLOCKS_Type) SetINTF_CLK_SYS_RESUS(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetINTF_CLK_SYS_RESUS() uint32 {
	return volatile.LoadUint32(&o.INTF.Reg) & 0x1
}

// CLOCKS.INTS: Interrupt status after masking & forcing
func (o *CLOCKS_Type) SetINTS_CLK_SYS_RESUS(value uint32) {
	volatile.StoreUint32(&o.INTS.Reg, volatile.LoadUint32(&o.INTS.Reg)&^(0x1)|value)
}
func (o *CLOCKS_Type) GetINTS_CLK_SYS_RESUS() uint32 {
	return volatile.LoadUint32(&o.INTS.Reg) & 0x1
}

type RESETS_Type struct {
	RESET      volatile.Register32 // 0x0
	WDSEL      volatile.Register32 // 0x4
	RESET_DONE volatile.Register32 // 0x8
}

// RESETS.RESET: Reset control. If a bit is set it means the peripheral is in reset. 0 means the peripheral's reset is deasserted.
func (o *RESETS_Type) SetRESET_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x1000000)|value<<24)
}
func (o *RESETS_Type) GetRESET_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x1000000) >> 24
}
func (o *RESETS_Type) SetRESET_UART1(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x800000)|value<<23)
}
func (o *RESETS_Type) GetRESET_UART1() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x800000) >> 23
}
func (o *RESETS_Type) SetRESET_UART0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x400000)|value<<22)
}
func (o *RESETS_Type) GetRESET_UART0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x400000) >> 22
}
func (o *RESETS_Type) SetRESET_TIMER(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x200000)|value<<21)
}
func (o *RESETS_Type) GetRESET_TIMER() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x200000) >> 21
}
func (o *RESETS_Type) SetRESET_TBMAN(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x100000)|value<<20)
}
func (o *RESETS_Type) GetRESET_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x100000) >> 20
}
func (o *RESETS_Type) SetRESET_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x80000)|value<<19)
}
func (o *RESETS_Type) GetRESET_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x80000) >> 19
}
func (o *RESETS_Type) SetRESET_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x40000)|value<<18)
}
func (o *RESETS_Type) GetRESET_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x40000) >> 18
}
func (o *RESETS_Type) SetRESET_SPI1(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x20000)|value<<17)
}
func (o *RESETS_Type) GetRESET_SPI1() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x20000) >> 17
}
func (o *RESETS_Type) SetRESET_SPI0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x10000)|value<<16)
}
func (o *RESETS_Type) GetRESET_SPI0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x10000) >> 16
}
func (o *RESETS_Type) SetRESET_RTC(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x8000)|value<<15)
}
func (o *RESETS_Type) GetRESET_RTC() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x8000) >> 15
}
func (o *RESETS_Type) SetRESET_PWM(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x4000)|value<<14)
}
func (o *RESETS_Type) GetRESET_PWM() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x4000) >> 14
}
func (o *RESETS_Type) SetRESET_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x2000)|value<<13)
}
func (o *RESETS_Type) GetRESET_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x2000) >> 13
}
func (o *RESETS_Type) SetRESET_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x1000)|value<<12)
}
func (o *RESETS_Type) GetRESET_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x1000) >> 12
}
func (o *RESETS_Type) SetRESET_PIO1(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x800)|value<<11)
}
func (o *RESETS_Type) GetRESET_PIO1() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x800) >> 11
}
func (o *RESETS_Type) SetRESET_PIO0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x400)|value<<10)
}
func (o *RESETS_Type) GetRESET_PIO0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x400) >> 10
}
func (o *RESETS_Type) SetRESET_PADS_QSPI(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x200)|value<<9)
}
func (o *RESETS_Type) GetRESET_PADS_QSPI() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x200) >> 9
}
func (o *RESETS_Type) SetRESET_PADS_BANK0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x100)|value<<8)
}
func (o *RESETS_Type) GetRESET_PADS_BANK0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x100) >> 8
}
func (o *RESETS_Type) SetRESET_JTAG(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x80)|value<<7)
}
func (o *RESETS_Type) GetRESET_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x80) >> 7
}
func (o *RESETS_Type) SetRESET_IO_QSPI(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x40)|value<<6)
}
func (o *RESETS_Type) GetRESET_IO_QSPI() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x40) >> 6
}
func (o *RESETS_Type) SetRESET_IO_BANK0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x20)|value<<5)
}
func (o *RESETS_Type) GetRESET_IO_BANK0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x20) >> 5
}
func (o *RESETS_Type) SetRESET_I2C1(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x10)|value<<4)
}
func (o *RESETS_Type) GetRESET_I2C1() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x10) >> 4
}
func (o *RESETS_Type) SetRESET_I2C0(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x8)|value<<3)
}
func (o *RESETS_Type) GetRESET_I2C0() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x8) >> 3
}
func (o *RESETS_Type) SetRESET_DMA(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x4)|value<<2)
}
func (o *RESETS_Type) GetRESET_DMA() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x4) >> 2
}
func (o *RESETS_Type) SetRESET_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x2)|value<<1)
}
func (o *RESETS_Type) GetRESET_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.RESET.Reg) & 0x2) >> 1
}
func (o *RESETS_Type) SetRESET_ADC(value uint32) {
	volatile.StoreUint32(&o.RESET.Reg, volatile.LoadUint32(&o.RESET.Reg)&^(0x1)|value)
}
func (o *RESETS_Type) GetRESET_ADC() uint32 {
	return volatile.LoadUint32(&o.RESET.Reg) & 0x1
}

// RESETS.WDSEL: Watchdog select. If a bit is set then the watchdog will reset this peripheral when the watchdog fires.
func (o *RESETS_Type) SetWDSEL_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x1000000)|value<<24)
}
func (o *RESETS_Type) GetWDSEL_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x1000000) >> 24
}
func (o *RESETS_Type) SetWDSEL_UART1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x800000)|value<<23)
}
func (o *RESETS_Type) GetWDSEL_UART1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x800000) >> 23
}
func (o *RESETS_Type) SetWDSEL_UART0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x400000)|value<<22)
}
func (o *RESETS_Type) GetWDSEL_UART0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x400000) >> 22
}
func (o *RESETS_Type) SetWDSEL_TIMER(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x200000)|value<<21)
}
func (o *RESETS_Type) GetWDSEL_TIMER() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x200000) >> 21
}
func (o *RESETS_Type) SetWDSEL_TBMAN(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x100000)|value<<20)
}
func (o *RESETS_Type) GetWDSEL_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x100000) >> 20
}
func (o *RESETS_Type) SetWDSEL_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x80000)|value<<19)
}
func (o *RESETS_Type) GetWDSEL_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x80000) >> 19
}
func (o *RESETS_Type) SetWDSEL_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x40000)|value<<18)
}
func (o *RESETS_Type) GetWDSEL_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x40000) >> 18
}
func (o *RESETS_Type) SetWDSEL_SPI1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x20000)|value<<17)
}
func (o *RESETS_Type) GetWDSEL_SPI1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x20000) >> 17
}
func (o *RESETS_Type) SetWDSEL_SPI0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x10000)|value<<16)
}
func (o *RESETS_Type) GetWDSEL_SPI0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x10000) >> 16
}
func (o *RESETS_Type) SetWDSEL_RTC(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x8000)|value<<15)
}
func (o *RESETS_Type) GetWDSEL_RTC() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x8000) >> 15
}
func (o *RESETS_Type) SetWDSEL_PWM(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x4000)|value<<14)
}
func (o *RESETS_Type) GetWDSEL_PWM() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x4000) >> 14
}
func (o *RESETS_Type) SetWDSEL_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x2000)|value<<13)
}
func (o *RESETS_Type) GetWDSEL_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x2000) >> 13
}
func (o *RESETS_Type) SetWDSEL_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x1000)|value<<12)
}
func (o *RESETS_Type) GetWDSEL_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x1000) >> 12
}
func (o *RESETS_Type) SetWDSEL_PIO1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x800)|value<<11)
}
func (o *RESETS_Type) GetWDSEL_PIO1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x800) >> 11
}
func (o *RESETS_Type) SetWDSEL_PIO0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x400)|value<<10)
}
func (o *RESETS_Type) GetWDSEL_PIO0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x400) >> 10
}
func (o *RESETS_Type) SetWDSEL_PADS_QSPI(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x200)|value<<9)
}
func (o *RESETS_Type) GetWDSEL_PADS_QSPI() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x200) >> 9
}
func (o *RESETS_Type) SetWDSEL_PADS_BANK0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x100)|value<<8)
}
func (o *RESETS_Type) GetWDSEL_PADS_BANK0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x100) >> 8
}
func (o *RESETS_Type) SetWDSEL_JTAG(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x80)|value<<7)
}
func (o *RESETS_Type) GetWDSEL_JTAG() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x80) >> 7
}
func (o *RESETS_Type) SetWDSEL_IO_QSPI(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x40)|value<<6)
}
func (o *RESETS_Type) GetWDSEL_IO_QSPI() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x40) >> 6
}
func (o *RESETS_Type) SetWDSEL_IO_BANK0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x20)|value<<5)
}
func (o *RESETS_Type) GetWDSEL_IO_BANK0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x20) >> 5
}
func (o *RESETS_Type) SetWDSEL_I2C1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x10)|value<<4)
}
func (o *RESETS_Type) GetWDSEL_I2C1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x10) >> 4
}
func (o *RESETS_Type) SetWDSEL_I2C0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x8)|value<<3)
}
func (o *RESETS_Type) GetWDSEL_I2C0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x8) >> 3
}
func (o *RESETS_Type) SetWDSEL_DMA(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x4)|value<<2)
}
func (o *RESETS_Type) GetWDSEL_DMA() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x4) >> 2
}
func (o *RESETS_Type) SetWDSEL_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x2)|value<<1)
}
func (o *RESETS_Type) GetWDSEL_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x2) >> 1
}
func (o *RESETS_Type) SetWDSEL_ADC(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x1)|value)
}
func (o *RESETS_Type) GetWDSEL_ADC() uint32 {
	return volatile.LoadUint32(&o.WDSEL.Reg) & 0x1
}

// RESETS.RESET_DONE: Reset done. If a bit is set then a reset done signal has been returned by the peripheral. This indicates that the peripheral's registers are ready to be accessed.
func (o *RESETS_Type) SetRESET_DONE_USBCTRL(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x1000000)|value<<24)
}
func (o *RESETS_Type) GetRESET_DONE_USBCTRL() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x1000000) >> 24
}
func (o *RESETS_Type) SetRESET_DONE_UART1(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x800000)|value<<23)
}
func (o *RESETS_Type) GetRESET_DONE_UART1() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x800000) >> 23
}
func (o *RESETS_Type) SetRESET_DONE_UART0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x400000)|value<<22)
}
func (o *RESETS_Type) GetRESET_DONE_UART0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x400000) >> 22
}
func (o *RESETS_Type) SetRESET_DONE_TIMER(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x200000)|value<<21)
}
func (o *RESETS_Type) GetRESET_DONE_TIMER() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x200000) >> 21
}
func (o *RESETS_Type) SetRESET_DONE_TBMAN(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x100000)|value<<20)
}
func (o *RESETS_Type) GetRESET_DONE_TBMAN() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x100000) >> 20
}
func (o *RESETS_Type) SetRESET_DONE_SYSINFO(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x80000)|value<<19)
}
func (o *RESETS_Type) GetRESET_DONE_SYSINFO() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x80000) >> 19
}
func (o *RESETS_Type) SetRESET_DONE_SYSCFG(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x40000)|value<<18)
}
func (o *RESETS_Type) GetRESET_DONE_SYSCFG() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x40000) >> 18
}
func (o *RESETS_Type) SetRESET_DONE_SPI1(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x20000)|value<<17)
}
func (o *RESETS_Type) GetRESET_DONE_SPI1() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x20000) >> 17
}
func (o *RESETS_Type) SetRESET_DONE_SPI0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x10000)|value<<16)
}
func (o *RESETS_Type) GetRESET_DONE_SPI0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x10000) >> 16
}
func (o *RESETS_Type) SetRESET_DONE_RTC(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x8000)|value<<15)
}
func (o *RESETS_Type) GetRESET_DONE_RTC() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x8000) >> 15
}
func (o *RESETS_Type) SetRESET_DONE_PWM(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x4000)|value<<14)
}
func (o *RESETS_Type) GetRESET_DONE_PWM() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x4000) >> 14
}
func (o *RESETS_Type) SetRESET_DONE_PLL_USB(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x2000)|value<<13)
}
func (o *RESETS_Type) GetRESET_DONE_PLL_USB() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x2000) >> 13
}
func (o *RESETS_Type) SetRESET_DONE_PLL_SYS(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x1000)|value<<12)
}
func (o *RESETS_Type) GetRESET_DONE_PLL_SYS() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x1000) >> 12
}
func (o *RESETS_Type) SetRESET_DONE_PIO1(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x800)|value<<11)
}
func (o *RESETS_Type) GetRESET_DONE_PIO1() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x800) >> 11
}
func (o *RESETS_Type) SetRESET_DONE_PIO0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x400)|value<<10)
}
func (o *RESETS_Type) GetRESET_DONE_PIO0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x400) >> 10
}
func (o *RESETS_Type) SetRESET_DONE_PADS_QSPI(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x200)|value<<9)
}
func (o *RESETS_Type) GetRESET_DONE_PADS_QSPI() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x200) >> 9
}
func (o *RESETS_Type) SetRESET_DONE_PADS_BANK0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x100)|value<<8)
}
func (o *RESETS_Type) GetRESET_DONE_PADS_BANK0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x100) >> 8
}
func (o *RESETS_Type) SetRESET_DONE_JTAG(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x80)|value<<7)
}
func (o *RESETS_Type) GetRESET_DONE_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x80) >> 7
}
func (o *RESETS_Type) SetRESET_DONE_IO_QSPI(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x40)|value<<6)
}
func (o *RESETS_Type) GetRESET_DONE_IO_QSPI() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x40) >> 6
}
func (o *RESETS_Type) SetRESET_DONE_IO_BANK0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x20)|value<<5)
}
func (o *RESETS_Type) GetRESET_DONE_IO_BANK0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x20) >> 5
}
func (o *RESETS_Type) SetRESET_DONE_I2C1(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x10)|value<<4)
}
func (o *RESETS_Type) GetRESET_DONE_I2C1() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x10) >> 4
}
func (o *RESETS_Type) SetRESET_DONE_I2C0(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x8)|value<<3)
}
func (o *RESETS_Type) GetRESET_DONE_I2C0() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x8) >> 3
}
func (o *RESETS_Type) SetRESET_DONE_DMA(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x4)|value<<2)
}
func (o *RESETS_Type) GetRESET_DONE_DMA() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x4) >> 2
}
func (o *RESETS_Type) SetRESET_DONE_BUSCTRL(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x2)|value<<1)
}
func (o *RESETS_Type) GetRESET_DONE_BUSCTRL() uint32 {
	return (volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x2) >> 1
}
func (o *RESETS_Type) SetRESET_DONE_ADC(value uint32) {
	volatile.StoreUint32(&o.RESET_DONE.Reg, volatile.LoadUint32(&o.RESET_DONE.Reg)&^(0x1)|value)
}
func (o *RESETS_Type) GetRESET_DONE_ADC() uint32 {
	return volatile.LoadUint32(&o.RESET_DONE.Reg) & 0x1
}

type PSM_Type struct {
	FRCE_ON  volatile.Register32 // 0x0
	FRCE_OFF volatile.Register32 // 0x4
	WDSEL    volatile.Register32 // 0x8
	DONE     volatile.Register32 // 0xC
}

// PSM.FRCE_ON: Force block out of reset (i.e. power it on)
func (o *PSM_Type) SetFRCE_ON_PROC1(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x10000)|value<<16)
}
func (o *PSM_Type) GetFRCE_ON_PROC1() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x10000) >> 16
}
func (o *PSM_Type) SetFRCE_ON_PROC0(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x8000)|value<<15)
}
func (o *PSM_Type) GetFRCE_ON_PROC0() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x8000) >> 15
}
func (o *PSM_Type) SetFRCE_ON_SIO(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x4000)|value<<14)
}
func (o *PSM_Type) GetFRCE_ON_SIO() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x4000) >> 14
}
func (o *PSM_Type) SetFRCE_ON_VREG_AND_CHIP_RESET(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x2000)|value<<13)
}
func (o *PSM_Type) GetFRCE_ON_VREG_AND_CHIP_RESET() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x2000) >> 13
}
func (o *PSM_Type) SetFRCE_ON_XIP(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x1000)|value<<12)
}
func (o *PSM_Type) GetFRCE_ON_XIP() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x1000) >> 12
}
func (o *PSM_Type) SetFRCE_ON_SRAM5(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x800)|value<<11)
}
func (o *PSM_Type) GetFRCE_ON_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x800) >> 11
}
func (o *PSM_Type) SetFRCE_ON_SRAM4(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x400)|value<<10)
}
func (o *PSM_Type) GetFRCE_ON_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x400) >> 10
}
func (o *PSM_Type) SetFRCE_ON_SRAM3(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x200)|value<<9)
}
func (o *PSM_Type) GetFRCE_ON_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x200) >> 9
}
func (o *PSM_Type) SetFRCE_ON_SRAM2(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x100)|value<<8)
}
func (o *PSM_Type) GetFRCE_ON_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x100) >> 8
}
func (o *PSM_Type) SetFRCE_ON_SRAM1(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x80)|value<<7)
}
func (o *PSM_Type) GetFRCE_ON_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x80) >> 7
}
func (o *PSM_Type) SetFRCE_ON_SRAM0(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x40)|value<<6)
}
func (o *PSM_Type) GetFRCE_ON_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x40) >> 6
}
func (o *PSM_Type) SetFRCE_ON_ROM(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x20)|value<<5)
}
func (o *PSM_Type) GetFRCE_ON_ROM() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x20) >> 5
}
func (o *PSM_Type) SetFRCE_ON_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x10)|value<<4)
}
func (o *PSM_Type) GetFRCE_ON_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x10) >> 4
}
func (o *PSM_Type) SetFRCE_ON_RESETS(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x8)|value<<3)
}
func (o *PSM_Type) GetFRCE_ON_RESETS() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x8) >> 3
}
func (o *PSM_Type) SetFRCE_ON_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x4)|value<<2)
}
func (o *PSM_Type) GetFRCE_ON_CLOCKS() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x4) >> 2
}
func (o *PSM_Type) SetFRCE_ON_XOSC(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x2)|value<<1)
}
func (o *PSM_Type) GetFRCE_ON_XOSC() uint32 {
	return (volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x2) >> 1
}
func (o *PSM_Type) SetFRCE_ON_ROSC(value uint32) {
	volatile.StoreUint32(&o.FRCE_ON.Reg, volatile.LoadUint32(&o.FRCE_ON.Reg)&^(0x1)|value)
}
func (o *PSM_Type) GetFRCE_ON_ROSC() uint32 {
	return volatile.LoadUint32(&o.FRCE_ON.Reg) & 0x1
}

// PSM.FRCE_OFF: Force into reset (i.e. power it off)
func (o *PSM_Type) SetFRCE_OFF_PROC1(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x10000)|value<<16)
}
func (o *PSM_Type) GetFRCE_OFF_PROC1() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x10000) >> 16
}
func (o *PSM_Type) SetFRCE_OFF_PROC0(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x8000)|value<<15)
}
func (o *PSM_Type) GetFRCE_OFF_PROC0() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x8000) >> 15
}
func (o *PSM_Type) SetFRCE_OFF_SIO(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x4000)|value<<14)
}
func (o *PSM_Type) GetFRCE_OFF_SIO() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x4000) >> 14
}
func (o *PSM_Type) SetFRCE_OFF_VREG_AND_CHIP_RESET(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x2000)|value<<13)
}
func (o *PSM_Type) GetFRCE_OFF_VREG_AND_CHIP_RESET() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x2000) >> 13
}
func (o *PSM_Type) SetFRCE_OFF_XIP(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x1000)|value<<12)
}
func (o *PSM_Type) GetFRCE_OFF_XIP() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x1000) >> 12
}
func (o *PSM_Type) SetFRCE_OFF_SRAM5(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x800)|value<<11)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x800) >> 11
}
func (o *PSM_Type) SetFRCE_OFF_SRAM4(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x400)|value<<10)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x400) >> 10
}
func (o *PSM_Type) SetFRCE_OFF_SRAM3(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x200)|value<<9)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x200) >> 9
}
func (o *PSM_Type) SetFRCE_OFF_SRAM2(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x100)|value<<8)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x100) >> 8
}
func (o *PSM_Type) SetFRCE_OFF_SRAM1(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x80)|value<<7)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x80) >> 7
}
func (o *PSM_Type) SetFRCE_OFF_SRAM0(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x40)|value<<6)
}
func (o *PSM_Type) GetFRCE_OFF_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x40) >> 6
}
func (o *PSM_Type) SetFRCE_OFF_ROM(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x20)|value<<5)
}
func (o *PSM_Type) GetFRCE_OFF_ROM() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x20) >> 5
}
func (o *PSM_Type) SetFRCE_OFF_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x10)|value<<4)
}
func (o *PSM_Type) GetFRCE_OFF_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x10) >> 4
}
func (o *PSM_Type) SetFRCE_OFF_RESETS(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x8)|value<<3)
}
func (o *PSM_Type) GetFRCE_OFF_RESETS() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x8) >> 3
}
func (o *PSM_Type) SetFRCE_OFF_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x4)|value<<2)
}
func (o *PSM_Type) GetFRCE_OFF_CLOCKS() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x4) >> 2
}
func (o *PSM_Type) SetFRCE_OFF_XOSC(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x2)|value<<1)
}
func (o *PSM_Type) GetFRCE_OFF_XOSC() uint32 {
	return (volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x2) >> 1
}
func (o *PSM_Type) SetFRCE_OFF_ROSC(value uint32) {
	volatile.StoreUint32(&o.FRCE_OFF.Reg, volatile.LoadUint32(&o.FRCE_OFF.Reg)&^(0x1)|value)
}
func (o *PSM_Type) GetFRCE_OFF_ROSC() uint32 {
	return volatile.LoadUint32(&o.FRCE_OFF.Reg) & 0x1
}

// PSM.WDSEL: Set to 1 if this peripheral should be reset when the watchdog fires.
func (o *PSM_Type) SetWDSEL_PROC1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x10000)|value<<16)
}
func (o *PSM_Type) GetWDSEL_PROC1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x10000) >> 16
}
func (o *PSM_Type) SetWDSEL_PROC0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x8000)|value<<15)
}
func (o *PSM_Type) GetWDSEL_PROC0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x8000) >> 15
}
func (o *PSM_Type) SetWDSEL_SIO(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x4000)|value<<14)
}
func (o *PSM_Type) GetWDSEL_SIO() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x4000) >> 14
}
func (o *PSM_Type) SetWDSEL_VREG_AND_CHIP_RESET(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x2000)|value<<13)
}
func (o *PSM_Type) GetWDSEL_VREG_AND_CHIP_RESET() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x2000) >> 13
}
func (o *PSM_Type) SetWDSEL_XIP(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x1000)|value<<12)
}
func (o *PSM_Type) GetWDSEL_XIP() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x1000) >> 12
}
func (o *PSM_Type) SetWDSEL_SRAM5(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x800)|value<<11)
}
func (o *PSM_Type) GetWDSEL_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x800) >> 11
}
func (o *PSM_Type) SetWDSEL_SRAM4(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x400)|value<<10)
}
func (o *PSM_Type) GetWDSEL_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x400) >> 10
}
func (o *PSM_Type) SetWDSEL_SRAM3(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x200)|value<<9)
}
func (o *PSM_Type) GetWDSEL_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x200) >> 9
}
func (o *PSM_Type) SetWDSEL_SRAM2(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x100)|value<<8)
}
func (o *PSM_Type) GetWDSEL_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x100) >> 8
}
func (o *PSM_Type) SetWDSEL_SRAM1(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x80)|value<<7)
}
func (o *PSM_Type) GetWDSEL_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x80) >> 7
}
func (o *PSM_Type) SetWDSEL_SRAM0(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x40)|value<<6)
}
func (o *PSM_Type) GetWDSEL_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x40) >> 6
}
func (o *PSM_Type) SetWDSEL_ROM(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x20)|value<<5)
}
func (o *PSM_Type) GetWDSEL_ROM() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x20) >> 5
}
func (o *PSM_Type) SetWDSEL_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x10)|value<<4)
}
func (o *PSM_Type) GetWDSEL_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x10) >> 4
}
func (o *PSM_Type) SetWDSEL_RESETS(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x8)|value<<3)
}
func (o *PSM_Type) GetWDSEL_RESETS() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x8) >> 3
}
func (o *PSM_Type) SetWDSEL_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x4)|value<<2)
}
func (o *PSM_Type) GetWDSEL_CLOCKS() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x4) >> 2
}
func (o *PSM_Type) SetWDSEL_XOSC(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x2)|value<<1)
}
func (o *PSM_Type) GetWDSEL_XOSC() uint32 {
	return (volatile.LoadUint32(&o.WDSEL.Reg) & 0x2) >> 1
}
func (o *PSM_Type) SetWDSEL_ROSC(value uint32) {
	volatile.StoreUint32(&o.WDSEL.Reg, volatile.LoadUint32(&o.WDSEL.Reg)&^(0x1)|value)
}
func (o *PSM_Type) GetWDSEL_ROSC() uint32 {
	return volatile.LoadUint32(&o.WDSEL.Reg) & 0x1
}

// PSM.DONE: Indicates the peripheral's registers are ready to access.
func (o *PSM_Type) SetDONE_PROC1(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x10000)|value<<16)
}
func (o *PSM_Type) GetDONE_PROC1() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x10000) >> 16
}
func (o *PSM_Type) SetDONE_PROC0(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x8000)|value<<15)
}
func (o *PSM_Type) GetDONE_PROC0() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x8000) >> 15
}
func (o *PSM_Type) SetDONE_SIO(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x4000)|value<<14)
}
func (o *PSM_Type) GetDONE_SIO() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x4000) >> 14
}
func (o *PSM_Type) SetDONE_VREG_AND_CHIP_RESET(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x2000)|value<<13)
}
func (o *PSM_Type) GetDONE_VREG_AND_CHIP_RESET() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x2000) >> 13
}
func (o *PSM_Type) SetDONE_XIP(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x1000)|value<<12)
}
func (o *PSM_Type) GetDONE_XIP() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x1000) >> 12
}
func (o *PSM_Type) SetDONE_SRAM5(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x800)|value<<11)
}
func (o *PSM_Type) GetDONE_SRAM5() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x800) >> 11
}
func (o *PSM_Type) SetDONE_SRAM4(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x400)|value<<10)
}
func (o *PSM_Type) GetDONE_SRAM4() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x400) >> 10
}
func (o *PSM_Type) SetDONE_SRAM3(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x200)|value<<9)
}
func (o *PSM_Type) GetDONE_SRAM3() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x200) >> 9
}
func (o *PSM_Type) SetDONE_SRAM2(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x100)|value<<8)
}
func (o *PSM_Type) GetDONE_SRAM2() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x100) >> 8
}
func (o *PSM_Type) SetDONE_SRAM1(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x80)|value<<7)
}
func (o *PSM_Type) GetDONE_SRAM1() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x80) >> 7
}
func (o *PSM_Type) SetDONE_SRAM0(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x40)|value<<6)
}
func (o *PSM_Type) GetDONE_SRAM0() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x40) >> 6
}
func (o *PSM_Type) SetDONE_ROM(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x20)|value<<5)
}
func (o *PSM_Type) GetDONE_ROM() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x20) >> 5
}
func (o *PSM_Type) SetDONE_BUSFABRIC(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x10)|value<<4)
}
func (o *PSM_Type) GetDONE_BUSFABRIC() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x10) >> 4
}
func (o *PSM_Type) SetDONE_RESETS(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x8)|value<<3)
}
func (o *PSM_Type) GetDONE_RESETS() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x8) >> 3
}
func (o *PSM_Type) SetDONE_CLOCKS(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x4)|value<<2)
}
func (o *PSM_Type) GetDONE_CLOCKS() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x4) >> 2
}
func (o *PSM_Type) SetDONE_XOSC(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x2)|value<<1)
}
func (o *PSM_Type) GetDONE_XOSC() uint32 {
	return (volatile.LoadUint32(&o.DONE.Reg) & 0x2) >> 1
}
func (o *PSM_Type) SetDONE_ROSC(value uint32) {
	volatile.StoreUint32(&o.DONE.Reg, volatile.LoadUint32(&o.DONE.Reg)&^(0x1)|value)
}
func (o *PSM_Type) GetDONE_ROSC() uint32 {
	return volatile.LoadUint32(&o.DONE.Reg) & 0x1
}

type IO_BANK0_Type struct {
	GPIO0_STATUS       volatile.Register32 // 0x0
	GPIO0_CTRL         volatile.Register32 // 0x4
	GPIO1_STATUS       volatile.Register32 // 0x8
	GPIO1_CTRL         volatile.Register32 // 0xC
	GPIO2_STATUS       volatile.Register32 // 0x10
	GPIO2_CTRL         volatile.Register32 // 0x14
	GPIO3_STATUS       volatile.Register32 // 0x18
	GPIO3_CTRL         volatile.Register32 // 0x1C
	GPIO4_STATUS       volatile.Register32 // 0x20
	GPIO4_CTRL         volatile.Register32 // 0x24
	GPIO5_STATUS       volatile.Register32 // 0x28
	GPIO5_CTRL         volatile.Register32 // 0x2C
	GPIO6_STATUS       volatile.Register32 // 0x30
	GPIO6_CTRL         volatile.Register32 // 0x34
	GPIO7_STATUS       volatile.Register32 // 0x38
	GPIO7_CTRL         volatile.Register32 // 0x3C
	GPIO8_STATUS       volatile.Register32 // 0x40
	GPIO8_CTRL         volatile.Register32 // 0x44
	GPIO9_STATUS       volatile.Register32 // 0x48
	GPIO9_CTRL         volatile.Register32 // 0x4C
	GPIO10_STATUS      volatile.Register32 // 0x50
	GPIO10_CTRL        volatile.Register32 // 0x54
	GPIO11_STATUS      volatile.Register32 // 0x58
	GPIO11_CTRL        volatile.Register32 // 0x5C
	GPIO12_STATUS      volatile.Register32 // 0x60
	GPIO12_CTRL        volatile.Register32 // 0x64
	GPIO13_STATUS      volatile.Register32 // 0x68
	GPIO13_CTRL        volatile.Register32 // 0x6C
	GPIO14_STATUS      volatile.Register32 // 0x70
	GPIO14_CTRL        volatile.Register32 // 0x74
	GPIO15_STATUS      volatile.Register32 // 0x78
	GPIO15_CTRL        volatile.Register32 // 0x7C
	GPIO16_STATUS      volatile.Register32 // 0x80
	GPIO16_CTRL        volatile.Register32 // 0x84
	GPIO17_STATUS      volatile.Register32 // 0x88
	GPIO17_CTRL        volatile.Register32 // 0x8C
	GPIO18_STATUS      volatile.Register32 // 0x90
	GPIO18_CTRL        volatile.Register32 // 0x94
	GPIO19_STATUS      volatile.Register32 // 0x98
	GPIO19_CTRL        volatile.Register32 // 0x9C
	GPIO20_STATUS      volatile.Register32 // 0xA0
	GPIO20_CTRL        volatile.Register32 // 0xA4
	GPIO21_STATUS      volatile.Register32 // 0xA8
	GPIO21_CTRL        volatile.Register32 // 0xAC
	GPIO22_STATUS      volatile.Register32 // 0xB0
	GPIO22_CTRL        volatile.Register32 // 0xB4
	GPIO23_STATUS      volatile.Register32 // 0xB8
	GPIO23_CTRL        volatile.Register32 // 0xBC
	GPIO24_STATUS      volatile.Register32 // 0xC0
	GPIO24_CTRL        volatile.Register32 // 0xC4
	GPIO25_STATUS      volatile.Register32 // 0xC8
	GPIO25_CTRL        volatile.Register32 // 0xCC
	GPIO26_STATUS      volatile.Register32 // 0xD0
	GPIO26_CTRL        volatile.Register32 // 0xD4
	GPIO27_STATUS      volatile.Register32 // 0xD8
	GPIO27_CTRL        volatile.Register32 // 0xDC
	GPIO28_STATUS      volatile.Register32 // 0xE0
	GPIO28_CTRL        volatile.Register32 // 0xE4
	GPIO29_STATUS      volatile.Register32 // 0xE8
	GPIO29_CTRL        volatile.Register32 // 0xEC
	INTR0              volatile.Register32 // 0xF0
	INTR1              volatile.Register32 // 0xF4
	INTR2              volatile.Register32 // 0xF8
	INTR3              volatile.Register32 // 0xFC
	PROC0_INTE0        volatile.Register32 // 0x100
	PROC0_INTE1        volatile.Register32 // 0x104
	PROC0_INTE2        volatile.Register32 // 0x108
	PROC0_INTE3        volatile.Register32 // 0x10C
	PROC0_INTF0        volatile.Register32 // 0x110
	PROC0_INTF1        volatile.Register32 // 0x114
	PROC0_INTF2        volatile.Register32 // 0x118
	PROC0_INTF3        volatile.Register32 // 0x11C
	PROC0_INTS0        volatile.Register32 // 0x120
	PROC0_INTS1        volatile.Register32 // 0x124
	PROC0_INTS2        volatile.Register32 // 0x128
	PROC0_INTS3        volatile.Register32 // 0x12C
	PROC1_INTE0        volatile.Register32 // 0x130
	PROC1_INTE1        volatile.Register32 // 0x134
	PROC1_INTE2        volatile.Register32 // 0x138
	PROC1_INTE3        volatile.Register32 // 0x13C
	PROC1_INTF0        volatile.Register32 // 0x140
	PROC1_INTF1        volatile.Register32 // 0x144
	PROC1_INTF2        volatile.Register32 // 0x148
	PROC1_INTF3        volatile.Register32 // 0x14C
	PROC1_INTS0        volatile.Register32 // 0x150
	PROC1_INTS1        volatile.Register32 // 0x154
	PROC1_INTS2        volatile.Register32 // 0x158
	PROC1_INTS3        volatile.Register32 // 0x15C
	DORMANT_WAKE_INTE0 volatile.Register32 // 0x160
	DORMANT_WAKE_INTE1 volatile.Register32 // 0x164
	DORMANT_WAKE_INTE2 volatile.Register32 // 0x168
	DORMANT_WAKE_INTE3 volatile.Register32 // 0x16C
	DORMANT_WAKE_INTF0 volatile.Register32 // 0x170
	DORMANT_WAKE_INTF1 volatile.Register32 // 0x174
	DORMANT_WAKE_INTF2 volatile.Register32 // 0x178
	DORMANT_WAKE_INTF3 volatile.Register32 // 0x17C
	DORMANT_WAKE_INTS0 volatile.Register32 // 0x180
	DORMANT_WAKE_INTS1 volatile.Register32 // 0x184
	DORMANT_WAKE_INTS2 volatile.Register32 // 0x188
	DORMANT_WAKE_INTS3 volatile.Register32 // 0x18C
}

// IO_BANK0.GPIO0_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO0_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO0_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO0_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO0_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO0_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO0_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO0_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO0_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO0_STATUS.Reg, volatile.LoadUint32(&o.GPIO0_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO0_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO0_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO0_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO0_CTRL.Reg, volatile.LoadUint32(&o.GPIO0_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO0_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO0_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO0_CTRL.Reg, volatile.LoadUint32(&o.GPIO0_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO0_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO0_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO0_CTRL.Reg, volatile.LoadUint32(&o.GPIO0_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO0_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO0_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO0_CTRL.Reg, volatile.LoadUint32(&o.GPIO0_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO0_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO0_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO0_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0_CTRL.Reg, volatile.LoadUint32(&o.GPIO0_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO0_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO0_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO1_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO1_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO1_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO1_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO1_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO1_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO1_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO1_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO1_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO1_STATUS.Reg, volatile.LoadUint32(&o.GPIO1_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO1_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO1_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO1_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO1_CTRL.Reg, volatile.LoadUint32(&o.GPIO1_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO1_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO1_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO1_CTRL.Reg, volatile.LoadUint32(&o.GPIO1_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO1_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO1_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO1_CTRL.Reg, volatile.LoadUint32(&o.GPIO1_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO1_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO1_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO1_CTRL.Reg, volatile.LoadUint32(&o.GPIO1_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO1_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO1_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO1_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1_CTRL.Reg, volatile.LoadUint32(&o.GPIO1_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO1_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO1_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO2_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO2_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO2_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO2_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO2_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO2_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO2_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO2_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO2_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO2_STATUS.Reg, volatile.LoadUint32(&o.GPIO2_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO2_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO2_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO2_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO2_CTRL.Reg, volatile.LoadUint32(&o.GPIO2_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO2_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO2_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO2_CTRL.Reg, volatile.LoadUint32(&o.GPIO2_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO2_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO2_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO2_CTRL.Reg, volatile.LoadUint32(&o.GPIO2_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO2_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO2_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO2_CTRL.Reg, volatile.LoadUint32(&o.GPIO2_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO2_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO2_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO2_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2_CTRL.Reg, volatile.LoadUint32(&o.GPIO2_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO2_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO2_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO3_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO3_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO3_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO3_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO3_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO3_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO3_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO3_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO3_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO3_STATUS.Reg, volatile.LoadUint32(&o.GPIO3_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO3_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO3_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO3_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO3_CTRL.Reg, volatile.LoadUint32(&o.GPIO3_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO3_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO3_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO3_CTRL.Reg, volatile.LoadUint32(&o.GPIO3_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO3_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO3_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO3_CTRL.Reg, volatile.LoadUint32(&o.GPIO3_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO3_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO3_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO3_CTRL.Reg, volatile.LoadUint32(&o.GPIO3_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO3_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO3_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO3_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3_CTRL.Reg, volatile.LoadUint32(&o.GPIO3_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO3_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO3_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO4_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO4_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO4_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO4_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO4_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO4_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO4_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO4_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO4_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO4_STATUS.Reg, volatile.LoadUint32(&o.GPIO4_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO4_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO4_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO4_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO4_CTRL.Reg, volatile.LoadUint32(&o.GPIO4_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO4_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO4_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO4_CTRL.Reg, volatile.LoadUint32(&o.GPIO4_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO4_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO4_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO4_CTRL.Reg, volatile.LoadUint32(&o.GPIO4_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO4_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO4_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO4_CTRL.Reg, volatile.LoadUint32(&o.GPIO4_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO4_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO4_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO4_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4_CTRL.Reg, volatile.LoadUint32(&o.GPIO4_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO4_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO4_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO5_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO5_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO5_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO5_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO5_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO5_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO5_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO5_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO5_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO5_STATUS.Reg, volatile.LoadUint32(&o.GPIO5_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO5_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO5_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO5_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO5_CTRL.Reg, volatile.LoadUint32(&o.GPIO5_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO5_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO5_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO5_CTRL.Reg, volatile.LoadUint32(&o.GPIO5_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO5_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO5_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO5_CTRL.Reg, volatile.LoadUint32(&o.GPIO5_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO5_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO5_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO5_CTRL.Reg, volatile.LoadUint32(&o.GPIO5_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO5_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO5_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO5_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5_CTRL.Reg, volatile.LoadUint32(&o.GPIO5_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO5_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO5_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO6_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO6_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO6_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO6_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO6_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO6_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO6_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO6_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO6_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO6_STATUS.Reg, volatile.LoadUint32(&o.GPIO6_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO6_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO6_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO6_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO6_CTRL.Reg, volatile.LoadUint32(&o.GPIO6_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO6_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO6_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO6_CTRL.Reg, volatile.LoadUint32(&o.GPIO6_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO6_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO6_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO6_CTRL.Reg, volatile.LoadUint32(&o.GPIO6_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO6_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO6_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO6_CTRL.Reg, volatile.LoadUint32(&o.GPIO6_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO6_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO6_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO6_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6_CTRL.Reg, volatile.LoadUint32(&o.GPIO6_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO6_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO6_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO7_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO7_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO7_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO7_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO7_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO7_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO7_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO7_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO7_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO7_STATUS.Reg, volatile.LoadUint32(&o.GPIO7_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO7_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO7_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO7_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO7_CTRL.Reg, volatile.LoadUint32(&o.GPIO7_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO7_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO7_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO7_CTRL.Reg, volatile.LoadUint32(&o.GPIO7_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO7_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO7_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO7_CTRL.Reg, volatile.LoadUint32(&o.GPIO7_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO7_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO7_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO7_CTRL.Reg, volatile.LoadUint32(&o.GPIO7_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO7_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO7_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO7_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7_CTRL.Reg, volatile.LoadUint32(&o.GPIO7_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO7_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO7_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO8_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO8_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO8_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO8_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO8_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO8_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO8_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO8_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO8_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO8_STATUS.Reg, volatile.LoadUint32(&o.GPIO8_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO8_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO8_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO8_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO8_CTRL.Reg, volatile.LoadUint32(&o.GPIO8_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO8_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO8_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO8_CTRL.Reg, volatile.LoadUint32(&o.GPIO8_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO8_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO8_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO8_CTRL.Reg, volatile.LoadUint32(&o.GPIO8_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO8_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO8_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO8_CTRL.Reg, volatile.LoadUint32(&o.GPIO8_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO8_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO8_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO8_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO8_CTRL.Reg, volatile.LoadUint32(&o.GPIO8_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO8_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO8_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO9_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO9_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO9_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO9_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO9_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO9_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO9_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO9_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO9_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO9_STATUS.Reg, volatile.LoadUint32(&o.GPIO9_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO9_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO9_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO9_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO9_CTRL.Reg, volatile.LoadUint32(&o.GPIO9_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO9_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO9_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO9_CTRL.Reg, volatile.LoadUint32(&o.GPIO9_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO9_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO9_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO9_CTRL.Reg, volatile.LoadUint32(&o.GPIO9_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO9_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO9_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO9_CTRL.Reg, volatile.LoadUint32(&o.GPIO9_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO9_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO9_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO9_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO9_CTRL.Reg, volatile.LoadUint32(&o.GPIO9_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO9_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO9_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO10_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO10_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO10_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO10_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO10_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO10_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO10_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO10_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO10_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO10_STATUS.Reg, volatile.LoadUint32(&o.GPIO10_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO10_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO10_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO10_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO10_CTRL.Reg, volatile.LoadUint32(&o.GPIO10_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO10_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO10_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO10_CTRL.Reg, volatile.LoadUint32(&o.GPIO10_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO10_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO10_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO10_CTRL.Reg, volatile.LoadUint32(&o.GPIO10_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO10_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO10_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO10_CTRL.Reg, volatile.LoadUint32(&o.GPIO10_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO10_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO10_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO10_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO10_CTRL.Reg, volatile.LoadUint32(&o.GPIO10_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO10_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO10_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO11_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO11_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO11_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO11_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO11_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO11_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO11_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO11_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO11_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO11_STATUS.Reg, volatile.LoadUint32(&o.GPIO11_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO11_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO11_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO11_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO11_CTRL.Reg, volatile.LoadUint32(&o.GPIO11_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO11_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO11_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO11_CTRL.Reg, volatile.LoadUint32(&o.GPIO11_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO11_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO11_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO11_CTRL.Reg, volatile.LoadUint32(&o.GPIO11_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO11_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO11_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO11_CTRL.Reg, volatile.LoadUint32(&o.GPIO11_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO11_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO11_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO11_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO11_CTRL.Reg, volatile.LoadUint32(&o.GPIO11_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO11_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO11_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO12_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO12_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO12_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO12_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO12_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO12_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO12_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO12_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO12_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO12_STATUS.Reg, volatile.LoadUint32(&o.GPIO12_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO12_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO12_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO12_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO12_CTRL.Reg, volatile.LoadUint32(&o.GPIO12_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO12_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO12_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO12_CTRL.Reg, volatile.LoadUint32(&o.GPIO12_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO12_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO12_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO12_CTRL.Reg, volatile.LoadUint32(&o.GPIO12_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO12_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO12_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO12_CTRL.Reg, volatile.LoadUint32(&o.GPIO12_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO12_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO12_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO12_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO12_CTRL.Reg, volatile.LoadUint32(&o.GPIO12_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO12_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO12_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO13_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO13_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO13_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO13_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO13_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO13_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO13_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO13_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO13_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO13_STATUS.Reg, volatile.LoadUint32(&o.GPIO13_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO13_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO13_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO13_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO13_CTRL.Reg, volatile.LoadUint32(&o.GPIO13_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO13_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO13_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO13_CTRL.Reg, volatile.LoadUint32(&o.GPIO13_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO13_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO13_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO13_CTRL.Reg, volatile.LoadUint32(&o.GPIO13_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO13_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO13_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO13_CTRL.Reg, volatile.LoadUint32(&o.GPIO13_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO13_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO13_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO13_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO13_CTRL.Reg, volatile.LoadUint32(&o.GPIO13_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO13_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO13_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO14_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO14_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO14_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO14_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO14_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO14_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO14_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO14_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO14_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO14_STATUS.Reg, volatile.LoadUint32(&o.GPIO14_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO14_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO14_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO14_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO14_CTRL.Reg, volatile.LoadUint32(&o.GPIO14_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO14_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO14_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO14_CTRL.Reg, volatile.LoadUint32(&o.GPIO14_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO14_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO14_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO14_CTRL.Reg, volatile.LoadUint32(&o.GPIO14_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO14_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO14_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO14_CTRL.Reg, volatile.LoadUint32(&o.GPIO14_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO14_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO14_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO14_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO14_CTRL.Reg, volatile.LoadUint32(&o.GPIO14_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO14_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO14_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO15_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO15_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO15_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO15_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO15_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO15_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO15_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO15_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO15_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO15_STATUS.Reg, volatile.LoadUint32(&o.GPIO15_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO15_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO15_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO15_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO15_CTRL.Reg, volatile.LoadUint32(&o.GPIO15_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO15_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO15_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO15_CTRL.Reg, volatile.LoadUint32(&o.GPIO15_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO15_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO15_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO15_CTRL.Reg, volatile.LoadUint32(&o.GPIO15_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO15_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO15_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO15_CTRL.Reg, volatile.LoadUint32(&o.GPIO15_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO15_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO15_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO15_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO15_CTRL.Reg, volatile.LoadUint32(&o.GPIO15_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO15_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO15_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO16_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO16_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO16_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO16_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO16_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO16_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO16_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO16_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO16_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO16_STATUS.Reg, volatile.LoadUint32(&o.GPIO16_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO16_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO16_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO16_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO16_CTRL.Reg, volatile.LoadUint32(&o.GPIO16_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO16_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO16_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO16_CTRL.Reg, volatile.LoadUint32(&o.GPIO16_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO16_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO16_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO16_CTRL.Reg, volatile.LoadUint32(&o.GPIO16_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO16_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO16_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO16_CTRL.Reg, volatile.LoadUint32(&o.GPIO16_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO16_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO16_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO16_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO16_CTRL.Reg, volatile.LoadUint32(&o.GPIO16_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO16_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO16_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO17_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO17_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO17_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO17_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO17_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO17_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO17_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO17_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO17_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO17_STATUS.Reg, volatile.LoadUint32(&o.GPIO17_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO17_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO17_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO17_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO17_CTRL.Reg, volatile.LoadUint32(&o.GPIO17_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO17_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO17_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO17_CTRL.Reg, volatile.LoadUint32(&o.GPIO17_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO17_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO17_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO17_CTRL.Reg, volatile.LoadUint32(&o.GPIO17_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO17_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO17_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO17_CTRL.Reg, volatile.LoadUint32(&o.GPIO17_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO17_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO17_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO17_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO17_CTRL.Reg, volatile.LoadUint32(&o.GPIO17_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO17_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO17_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO18_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO18_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO18_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO18_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO18_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO18_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO18_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO18_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO18_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO18_STATUS.Reg, volatile.LoadUint32(&o.GPIO18_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO18_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO18_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO18_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO18_CTRL.Reg, volatile.LoadUint32(&o.GPIO18_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO18_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO18_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO18_CTRL.Reg, volatile.LoadUint32(&o.GPIO18_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO18_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO18_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO18_CTRL.Reg, volatile.LoadUint32(&o.GPIO18_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO18_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO18_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO18_CTRL.Reg, volatile.LoadUint32(&o.GPIO18_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO18_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO18_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO18_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO18_CTRL.Reg, volatile.LoadUint32(&o.GPIO18_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO18_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO18_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO19_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO19_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO19_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO19_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO19_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO19_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO19_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO19_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO19_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO19_STATUS.Reg, volatile.LoadUint32(&o.GPIO19_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO19_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO19_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO19_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO19_CTRL.Reg, volatile.LoadUint32(&o.GPIO19_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO19_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO19_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO19_CTRL.Reg, volatile.LoadUint32(&o.GPIO19_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO19_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO19_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO19_CTRL.Reg, volatile.LoadUint32(&o.GPIO19_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO19_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO19_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO19_CTRL.Reg, volatile.LoadUint32(&o.GPIO19_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO19_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO19_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO19_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO19_CTRL.Reg, volatile.LoadUint32(&o.GPIO19_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO19_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO19_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO20_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO20_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO20_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO20_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO20_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO20_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO20_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO20_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO20_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO20_STATUS.Reg, volatile.LoadUint32(&o.GPIO20_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO20_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO20_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO20_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO20_CTRL.Reg, volatile.LoadUint32(&o.GPIO20_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO20_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO20_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO20_CTRL.Reg, volatile.LoadUint32(&o.GPIO20_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO20_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO20_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO20_CTRL.Reg, volatile.LoadUint32(&o.GPIO20_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO20_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO20_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO20_CTRL.Reg, volatile.LoadUint32(&o.GPIO20_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO20_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO20_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO20_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO20_CTRL.Reg, volatile.LoadUint32(&o.GPIO20_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO20_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO20_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO21_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO21_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO21_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO21_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO21_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO21_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO21_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO21_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO21_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO21_STATUS.Reg, volatile.LoadUint32(&o.GPIO21_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO21_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO21_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO21_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO21_CTRL.Reg, volatile.LoadUint32(&o.GPIO21_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO21_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO21_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO21_CTRL.Reg, volatile.LoadUint32(&o.GPIO21_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO21_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO21_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO21_CTRL.Reg, volatile.LoadUint32(&o.GPIO21_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO21_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO21_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO21_CTRL.Reg, volatile.LoadUint32(&o.GPIO21_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO21_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO21_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO21_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO21_CTRL.Reg, volatile.LoadUint32(&o.GPIO21_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO21_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO21_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO22_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO22_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO22_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO22_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO22_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO22_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO22_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO22_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO22_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO22_STATUS.Reg, volatile.LoadUint32(&o.GPIO22_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO22_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO22_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO22_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO22_CTRL.Reg, volatile.LoadUint32(&o.GPIO22_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO22_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO22_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO22_CTRL.Reg, volatile.LoadUint32(&o.GPIO22_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO22_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO22_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO22_CTRL.Reg, volatile.LoadUint32(&o.GPIO22_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO22_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO22_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO22_CTRL.Reg, volatile.LoadUint32(&o.GPIO22_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO22_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO22_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO22_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO22_CTRL.Reg, volatile.LoadUint32(&o.GPIO22_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO22_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO22_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO23_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO23_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO23_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO23_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO23_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO23_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO23_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO23_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO23_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO23_STATUS.Reg, volatile.LoadUint32(&o.GPIO23_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO23_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO23_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO23_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO23_CTRL.Reg, volatile.LoadUint32(&o.GPIO23_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO23_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO23_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO23_CTRL.Reg, volatile.LoadUint32(&o.GPIO23_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO23_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO23_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO23_CTRL.Reg, volatile.LoadUint32(&o.GPIO23_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO23_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO23_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO23_CTRL.Reg, volatile.LoadUint32(&o.GPIO23_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO23_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO23_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO23_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO23_CTRL.Reg, volatile.LoadUint32(&o.GPIO23_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO23_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO23_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO24_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO24_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO24_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO24_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO24_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO24_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO24_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO24_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO24_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO24_STATUS.Reg, volatile.LoadUint32(&o.GPIO24_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO24_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO24_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO24_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO24_CTRL.Reg, volatile.LoadUint32(&o.GPIO24_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO24_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO24_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO24_CTRL.Reg, volatile.LoadUint32(&o.GPIO24_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO24_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO24_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO24_CTRL.Reg, volatile.LoadUint32(&o.GPIO24_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO24_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO24_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO24_CTRL.Reg, volatile.LoadUint32(&o.GPIO24_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO24_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO24_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO24_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO24_CTRL.Reg, volatile.LoadUint32(&o.GPIO24_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO24_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO24_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO25_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO25_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO25_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO25_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO25_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO25_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO25_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO25_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO25_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO25_STATUS.Reg, volatile.LoadUint32(&o.GPIO25_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO25_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO25_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO25_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO25_CTRL.Reg, volatile.LoadUint32(&o.GPIO25_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO25_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO25_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO25_CTRL.Reg, volatile.LoadUint32(&o.GPIO25_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO25_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO25_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO25_CTRL.Reg, volatile.LoadUint32(&o.GPIO25_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO25_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO25_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO25_CTRL.Reg, volatile.LoadUint32(&o.GPIO25_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO25_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO25_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO25_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO25_CTRL.Reg, volatile.LoadUint32(&o.GPIO25_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO25_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO25_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO26_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO26_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO26_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO26_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO26_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO26_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO26_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO26_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO26_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO26_STATUS.Reg, volatile.LoadUint32(&o.GPIO26_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO26_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO26_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO26_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO26_CTRL.Reg, volatile.LoadUint32(&o.GPIO26_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO26_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO26_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO26_CTRL.Reg, volatile.LoadUint32(&o.GPIO26_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO26_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO26_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO26_CTRL.Reg, volatile.LoadUint32(&o.GPIO26_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO26_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO26_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO26_CTRL.Reg, volatile.LoadUint32(&o.GPIO26_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO26_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO26_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO26_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO26_CTRL.Reg, volatile.LoadUint32(&o.GPIO26_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO26_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO26_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO27_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO27_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO27_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO27_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO27_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO27_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO27_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO27_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO27_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO27_STATUS.Reg, volatile.LoadUint32(&o.GPIO27_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO27_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO27_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO27_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO27_CTRL.Reg, volatile.LoadUint32(&o.GPIO27_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO27_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO27_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO27_CTRL.Reg, volatile.LoadUint32(&o.GPIO27_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO27_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO27_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO27_CTRL.Reg, volatile.LoadUint32(&o.GPIO27_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO27_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO27_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO27_CTRL.Reg, volatile.LoadUint32(&o.GPIO27_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO27_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO27_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO27_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO27_CTRL.Reg, volatile.LoadUint32(&o.GPIO27_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO27_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO27_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO28_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO28_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO28_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO28_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO28_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO28_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO28_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO28_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO28_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO28_STATUS.Reg, volatile.LoadUint32(&o.GPIO28_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO28_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO28_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO28_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO28_CTRL.Reg, volatile.LoadUint32(&o.GPIO28_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO28_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO28_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO28_CTRL.Reg, volatile.LoadUint32(&o.GPIO28_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO28_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO28_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO28_CTRL.Reg, volatile.LoadUint32(&o.GPIO28_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO28_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO28_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO28_CTRL.Reg, volatile.LoadUint32(&o.GPIO28_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO28_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO28_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO28_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO28_CTRL.Reg, volatile.LoadUint32(&o.GPIO28_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO28_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO28_CTRL.Reg) & 0x1f
}

// IO_BANK0.GPIO29_STATUS: GPIO status
func (o *IO_BANK0_Type) SetGPIO29_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetGPIO29_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetGPIO29_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetGPIO29_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetGPIO29_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetGPIO29_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO29_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetGPIO29_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO29_STATUS.Reg, volatile.LoadUint32(&o.GPIO29_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO29_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_STATUS.Reg) & 0x100) >> 8
}

// IO_BANK0.GPIO29_CTRL: GPIO control including function select and overrides.
func (o *IO_BANK0_Type) SetGPIO29_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO29_CTRL.Reg, volatile.LoadUint32(&o.GPIO29_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_BANK0_Type) GetGPIO29_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_BANK0_Type) SetGPIO29_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO29_CTRL.Reg, volatile.LoadUint32(&o.GPIO29_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_BANK0_Type) GetGPIO29_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_BANK0_Type) SetGPIO29_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO29_CTRL.Reg, volatile.LoadUint32(&o.GPIO29_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_BANK0_Type) GetGPIO29_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_BANK0_Type) SetGPIO29_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO29_CTRL.Reg, volatile.LoadUint32(&o.GPIO29_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_BANK0_Type) GetGPIO29_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO29_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_BANK0_Type) SetGPIO29_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO29_CTRL.Reg, volatile.LoadUint32(&o.GPIO29_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_BANK0_Type) GetGPIO29_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO29_CTRL.Reg) & 0x1f
}

// IO_BANK0.INTR0: Raw Interrupts
func (o *IO_BANK0_Type) SetINTR0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetINTR0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetINTR0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetINTR0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetINTR0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetINTR0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetINTR0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetINTR0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetINTR0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetINTR0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetINTR0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetINTR0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetINTR0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetINTR0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetINTR0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetINTR0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetINTR0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetINTR0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetINTR0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetINTR0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetINTR0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetINTR0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetINTR0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetINTR0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetINTR0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetINTR0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetINTR0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetINTR0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetINTR0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetINTR0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetINTR0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetINTR0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR0.Reg, volatile.LoadUint32(&o.INTR0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetINTR0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR0.Reg) & 0x1
}

// IO_BANK0.INTR1: Raw Interrupts
func (o *IO_BANK0_Type) SetINTR1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetINTR1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetINTR1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetINTR1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetINTR1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetINTR1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetINTR1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetINTR1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetINTR1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetINTR1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetINTR1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetINTR1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetINTR1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetINTR1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetINTR1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetINTR1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetINTR1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetINTR1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetINTR1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetINTR1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetINTR1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetINTR1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetINTR1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetINTR1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetINTR1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetINTR1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetINTR1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetINTR1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetINTR1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetINTR1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetINTR1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetINTR1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR1.Reg, volatile.LoadUint32(&o.INTR1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetINTR1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR1.Reg) & 0x1
}

// IO_BANK0.INTR2: Raw Interrupts
func (o *IO_BANK0_Type) SetINTR2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetINTR2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetINTR2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetINTR2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetINTR2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetINTR2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetINTR2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetINTR2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetINTR2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetINTR2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetINTR2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetINTR2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetINTR2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetINTR2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetINTR2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetINTR2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetINTR2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetINTR2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetINTR2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetINTR2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetINTR2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetINTR2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetINTR2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetINTR2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetINTR2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetINTR2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetINTR2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetINTR2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetINTR2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetINTR2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetINTR2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetINTR2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR2.Reg, volatile.LoadUint32(&o.INTR2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetINTR2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR2.Reg) & 0x1
}

// IO_BANK0.INTR3: Raw Interrupts
func (o *IO_BANK0_Type) SetINTR3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetINTR3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetINTR3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetINTR3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetINTR3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetINTR3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetINTR3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetINTR3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetINTR3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetINTR3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetINTR3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetINTR3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetINTR3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetINTR3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetINTR3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetINTR3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetINTR3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetINTR3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetINTR3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetINTR3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetINTR3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetINTR3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetINTR3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetINTR3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR3.Reg, volatile.LoadUint32(&o.INTR3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetINTR3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR3.Reg) & 0x1
}

// IO_BANK0.PROC0_INTE0: Interrupt Enable for proc0
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTE0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE0.Reg, volatile.LoadUint32(&o.PROC0_INTE0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTE0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE0.Reg) & 0x1
}

// IO_BANK0.PROC0_INTE1: Interrupt Enable for proc0
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTE1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE1.Reg, volatile.LoadUint32(&o.PROC0_INTE1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTE1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE1.Reg) & 0x1
}

// IO_BANK0.PROC0_INTE2: Interrupt Enable for proc0
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTE2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE2.Reg, volatile.LoadUint32(&o.PROC0_INTE2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTE2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE2.Reg) & 0x1
}

// IO_BANK0.PROC0_INTE3: Interrupt Enable for proc0
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTE3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE3.Reg, volatile.LoadUint32(&o.PROC0_INTE3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTE3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE3.Reg) & 0x1
}

// IO_BANK0.PROC0_INTF0: Interrupt Force for proc0
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTF0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF0.Reg, volatile.LoadUint32(&o.PROC0_INTF0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTF0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF0.Reg) & 0x1
}

// IO_BANK0.PROC0_INTF1: Interrupt Force for proc0
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTF1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF1.Reg, volatile.LoadUint32(&o.PROC0_INTF1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTF1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF1.Reg) & 0x1
}

// IO_BANK0.PROC0_INTF2: Interrupt Force for proc0
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTF2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF2.Reg, volatile.LoadUint32(&o.PROC0_INTF2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTF2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF2.Reg) & 0x1
}

// IO_BANK0.PROC0_INTF3: Interrupt Force for proc0
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTF3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF3.Reg, volatile.LoadUint32(&o.PROC0_INTF3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTF3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF3.Reg) & 0x1
}

// IO_BANK0.PROC0_INTS0: Interrupt status after masking & forcing for proc0
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTS0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS0.Reg, volatile.LoadUint32(&o.PROC0_INTS0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTS0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS0.Reg) & 0x1
}

// IO_BANK0.PROC0_INTS1: Interrupt status after masking & forcing for proc0
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTS1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS1.Reg, volatile.LoadUint32(&o.PROC0_INTS1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTS1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS1.Reg) & 0x1
}

// IO_BANK0.PROC0_INTS2: Interrupt status after masking & forcing for proc0
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTS2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS2.Reg, volatile.LoadUint32(&o.PROC0_INTS2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTS2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS2.Reg) & 0x1
}

// IO_BANK0.PROC0_INTS3: Interrupt status after masking & forcing for proc0
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC0_INTS3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS3.Reg, volatile.LoadUint32(&o.PROC0_INTS3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC0_INTS3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS3.Reg) & 0x1
}

// IO_BANK0.PROC1_INTE0: Interrupt Enable for proc1
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTE0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE0.Reg, volatile.LoadUint32(&o.PROC1_INTE0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTE0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE0.Reg) & 0x1
}

// IO_BANK0.PROC1_INTE1: Interrupt Enable for proc1
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTE1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE1.Reg, volatile.LoadUint32(&o.PROC1_INTE1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTE1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE1.Reg) & 0x1
}

// IO_BANK0.PROC1_INTE2: Interrupt Enable for proc1
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTE2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE2.Reg, volatile.LoadUint32(&o.PROC1_INTE2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTE2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE2.Reg) & 0x1
}

// IO_BANK0.PROC1_INTE3: Interrupt Enable for proc1
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTE3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE3.Reg, volatile.LoadUint32(&o.PROC1_INTE3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTE3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE3.Reg) & 0x1
}

// IO_BANK0.PROC1_INTF0: Interrupt Force for proc1
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTF0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF0.Reg, volatile.LoadUint32(&o.PROC1_INTF0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTF0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTF0.Reg) & 0x1
}

// IO_BANK0.PROC1_INTF1: Interrupt Force for proc1
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTF1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF1.Reg, volatile.LoadUint32(&o.PROC1_INTF1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTF1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTF1.Reg) & 0x1
}

// IO_BANK0.PROC1_INTF2: Interrupt Force for proc1
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTF2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF2.Reg, volatile.LoadUint32(&o.PROC1_INTF2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTF2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTF2.Reg) & 0x1
}

// IO_BANK0.PROC1_INTF3: Interrupt Force for proc1
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTF3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF3.Reg, volatile.LoadUint32(&o.PROC1_INTF3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTF3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTF3.Reg) & 0x1
}

// IO_BANK0.PROC1_INTS0: Interrupt status after masking & forcing for proc1
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTS0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS0.Reg, volatile.LoadUint32(&o.PROC1_INTS0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTS0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTS0.Reg) & 0x1
}

// IO_BANK0.PROC1_INTS1: Interrupt status after masking & forcing for proc1
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTS1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS1.Reg, volatile.LoadUint32(&o.PROC1_INTS1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTS1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTS1.Reg) & 0x1
}

// IO_BANK0.PROC1_INTS2: Interrupt status after masking & forcing for proc1
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTS2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS2.Reg, volatile.LoadUint32(&o.PROC1_INTS2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTS2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTS2.Reg) & 0x1
}

// IO_BANK0.PROC1_INTS3: Interrupt status after masking & forcing for proc1
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetPROC1_INTS3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS3.Reg, volatile.LoadUint32(&o.PROC1_INTS3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetPROC1_INTS3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTS3.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTE0: Interrupt Enable for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTE0.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTE1: Interrupt Enable for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTE1.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTE2: Interrupt Enable for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTE2.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTE3: Interrupt Enable for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTE3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTE3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTE3.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTF0: Interrupt Force for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTF0.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTF1: Interrupt Force for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTF1.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTF2: Interrupt Force for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTF2.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTF3: Interrupt Force for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTF3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTF3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTF3.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTS0: Interrupt status after masking & forcing for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO7_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO7_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO7_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO7_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO7_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO7_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO7_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO7_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO6_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO6_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO6_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO6_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO6_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO6_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO6_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO6_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO5_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO5_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO5_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO5_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO5_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO5_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO5_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO5_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO4_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO4_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO4_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO4_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO4_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO4_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO4_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO4_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS0_GPIO0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS0.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS0_GPIO0_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTS0.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTS1: Interrupt status after masking & forcing for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO15_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO15_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO15_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO15_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO15_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO15_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO15_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO15_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO14_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO14_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO14_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO14_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO14_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO14_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO14_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO14_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO13_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO13_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO13_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO13_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO13_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO13_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO13_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO13_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO12_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO12_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO12_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO12_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO12_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO12_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO12_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO12_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO11_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO11_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO11_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO11_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO11_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO11_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO11_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO11_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO10_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO10_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO10_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO10_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO10_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO10_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO10_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO10_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO9_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO9_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO9_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO9_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO9_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO9_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO9_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO9_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO8_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO8_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO8_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO8_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO8_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO8_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS1_GPIO8_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS1.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS1_GPIO8_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTS1.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTS2: Interrupt status after masking & forcing for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO23_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x80000000)|value<<31)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO23_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x80000000) >> 31
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO23_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x40000000)|value<<30)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO23_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x40000000) >> 30
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO23_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x20000000)|value<<29)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO23_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x20000000) >> 29
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO23_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x10000000)|value<<28)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO23_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x10000000) >> 28
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO22_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x8000000)|value<<27)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO22_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x8000000) >> 27
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO22_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO22_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x4000000) >> 26
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO22_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x2000000)|value<<25)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO22_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x2000000) >> 25
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO22_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO22_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x1000000) >> 24
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO21_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO21_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO21_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO21_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO21_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO21_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO21_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO21_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO20_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO20_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO20_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO20_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO20_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO20_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO20_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO20_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO19_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO19_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO19_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO19_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO19_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO19_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO19_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO19_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO18_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO18_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO18_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO18_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO18_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO18_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO18_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO18_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO17_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO17_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO17_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO17_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO17_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO17_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO17_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO17_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO16_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO16_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO16_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO16_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO16_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO16_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS2_GPIO16_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS2.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS2_GPIO16_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTS2.Reg) & 0x1
}

// IO_BANK0.DORMANT_WAKE_INTS3: Interrupt status after masking & forcing for dormant_wake
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO29_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x800000)|value<<23)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO29_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x800000) >> 23
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO29_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x400000)|value<<22)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO29_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x400000) >> 22
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO29_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x200000)|value<<21)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO29_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x200000) >> 21
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO29_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x100000)|value<<20)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO29_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x100000) >> 20
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO28_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x80000)|value<<19)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO28_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x80000) >> 19
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO28_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x40000)|value<<18)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO28_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x40000) >> 18
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO28_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x20000)|value<<17)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO28_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x20000) >> 17
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO28_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x10000)|value<<16)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO28_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x10000) >> 16
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO27_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO27_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x8000) >> 15
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO27_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x4000)|value<<14)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO27_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x4000) >> 14
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO27_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x2000)|value<<13)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO27_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x2000) >> 13
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO27_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x1000)|value<<12)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO27_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x1000) >> 12
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO26_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x800)|value<<11)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO26_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x800) >> 11
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO26_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x400)|value<<10)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO26_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x400) >> 10
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO26_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x200)|value<<9)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO26_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x200) >> 9
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO26_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x100)|value<<8)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO26_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x100) >> 8
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO25_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x80)|value<<7)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO25_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x80) >> 7
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO25_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x40)|value<<6)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO25_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x40) >> 6
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO25_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x20)|value<<5)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO25_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x20) >> 5
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO25_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x10)|value<<4)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO25_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x10) >> 4
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO24_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x8)|value<<3)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO24_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x8) >> 3
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO24_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x4)|value<<2)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO24_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x4) >> 2
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO24_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x2)|value<<1)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO24_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x2) >> 1
}
func (o *IO_BANK0_Type) SetDORMANT_WAKE_INTS3_GPIO24_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS3.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg)&^(0x1)|value)
}
func (o *IO_BANK0_Type) GetDORMANT_WAKE_INTS3_GPIO24_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTS3.Reg) & 0x1
}

type IO_QSPI_Type struct {
	GPIO_QSPI_SCLK_STATUS volatile.Register32 // 0x0
	GPIO_QSPI_SCLK_CTRL   volatile.Register32 // 0x4
	GPIO_QSPI_SS_STATUS   volatile.Register32 // 0x8
	GPIO_QSPI_SS_CTRL     volatile.Register32 // 0xC
	GPIO_QSPI_SD0_STATUS  volatile.Register32 // 0x10
	GPIO_QSPI_SD0_CTRL    volatile.Register32 // 0x14
	GPIO_QSPI_SD1_STATUS  volatile.Register32 // 0x18
	GPIO_QSPI_SD1_CTRL    volatile.Register32 // 0x1C
	GPIO_QSPI_SD2_STATUS  volatile.Register32 // 0x20
	GPIO_QSPI_SD2_CTRL    volatile.Register32 // 0x24
	GPIO_QSPI_SD3_STATUS  volatile.Register32 // 0x28
	GPIO_QSPI_SD3_CTRL    volatile.Register32 // 0x2C
	INTR                  volatile.Register32 // 0x30
	PROC0_INTE            volatile.Register32 // 0x34
	PROC0_INTF            volatile.Register32 // 0x38
	PROC0_INTS            volatile.Register32 // 0x3C
	PROC1_INTE            volatile.Register32 // 0x40
	PROC1_INTF            volatile.Register32 // 0x44
	PROC1_INTS            volatile.Register32 // 0x48
	DORMANT_WAKE_INTE     volatile.Register32 // 0x4C
	DORMANT_WAKE_INTF     volatile.Register32 // 0x50
	DORMANT_WAKE_INTS     volatile.Register32 // 0x54
}

// IO_QSPI.GPIO_QSPI_SCLK_STATUS: GPIO status
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_STATUS.Reg) & 0x100) >> 8
}

// IO_QSPI.GPIO_QSPI_SCLK_CTRL: GPIO control including function select and overrides.
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SCLK_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SCLK_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SCLK_CTRL.Reg) & 0x1f
}

// IO_QSPI.GPIO_QSPI_SS_STATUS: GPIO status
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_STATUS.Reg) & 0x100) >> 8
}

// IO_QSPI.GPIO_QSPI_SS_CTRL: GPIO control including function select and overrides.
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SS_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SS_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SS_CTRL.Reg) & 0x1f
}

// IO_QSPI.GPIO_QSPI_SD0_STATUS: GPIO status
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_STATUS.Reg) & 0x100) >> 8
}

// IO_QSPI.GPIO_QSPI_SD0_CTRL: GPIO control including function select and overrides.
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD0_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD0_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD0_CTRL.Reg) & 0x1f
}

// IO_QSPI.GPIO_QSPI_SD1_STATUS: GPIO status
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_STATUS.Reg) & 0x100) >> 8
}

// IO_QSPI.GPIO_QSPI_SD1_CTRL: GPIO control including function select and overrides.
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD1_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD1_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD1_CTRL.Reg) & 0x1f
}

// IO_QSPI.GPIO_QSPI_SD2_STATUS: GPIO status
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_STATUS.Reg) & 0x100) >> 8
}

// IO_QSPI.GPIO_QSPI_SD2_CTRL: GPIO control including function select and overrides.
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD2_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD2_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD2_CTRL.Reg) & 0x1f
}

// IO_QSPI.GPIO_QSPI_SD3_STATUS: GPIO status
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_IRQTOPROC(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_IRQTOPROC() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x4000000) >> 26
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_IRQFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_IRQFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x1000000) >> 24
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_INTOPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_INTOPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_INFROMPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_INFROMPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_OETOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_OETOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_OEFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_OEFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_OUTTOPAD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_OUTTOPAD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_STATUS_OUTFROMPERI(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_STATUS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_STATUS_OUTFROMPERI() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_STATUS.Reg) & 0x100) >> 8
}

// IO_QSPI.GPIO_QSPI_SD3_CTRL: GPIO control including function select and overrides.
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_CTRL_IRQOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg)&^(0x30000000)|value<<28)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_CTRL_IRQOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg) & 0x30000000) >> 28
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_CTRL_INOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg)&^(0x30000)|value<<16)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_CTRL_INOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg) & 0x30000) >> 16
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_CTRL_OEOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_CTRL_OEOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg) & 0x3000) >> 12
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_CTRL_OUTOVER(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_CTRL_OUTOVER() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg) & 0x300) >> 8
}
func (o *IO_QSPI_Type) SetGPIO_QSPI_SD3_CTRL_FUNCSEL(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3_CTRL.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg)&^(0x1f)|value)
}
func (o *IO_QSPI_Type) GetGPIO_QSPI_SD3_CTRL_FUNCSEL() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD3_CTRL.Reg) & 0x1f
}

// IO_QSPI.INTR: Raw Interrupts
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetINTR_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetINTR_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.INTR.Reg) & 0x1
}

// IO_QSPI.PROC0_INTE: Interrupt Enable for proc0
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC0_INTE_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTE.Reg, volatile.LoadUint32(&o.PROC0_INTE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC0_INTE_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTE.Reg) & 0x1
}

// IO_QSPI.PROC0_INTF: Interrupt Force for proc0
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC0_INTF_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTF.Reg, volatile.LoadUint32(&o.PROC0_INTF.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC0_INTF_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTF.Reg) & 0x1
}

// IO_QSPI.PROC0_INTS: Interrupt status after masking & forcing for proc0
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC0_INTS_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC0_INTS.Reg, volatile.LoadUint32(&o.PROC0_INTS.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC0_INTS_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC0_INTS.Reg) & 0x1
}

// IO_QSPI.PROC1_INTE: Interrupt Enable for proc1
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC1_INTE_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTE.Reg, volatile.LoadUint32(&o.PROC1_INTE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC1_INTE_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTE.Reg) & 0x1
}

// IO_QSPI.PROC1_INTF: Interrupt Force for proc1
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC1_INTF_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTF.Reg, volatile.LoadUint32(&o.PROC1_INTF.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC1_INTF_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTF.Reg) & 0x1
}

// IO_QSPI.PROC1_INTS: Interrupt status after masking & forcing for proc1
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetPROC1_INTS_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.PROC1_INTS.Reg, volatile.LoadUint32(&o.PROC1_INTS.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetPROC1_INTS_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.PROC1_INTS.Reg) & 0x1
}

// IO_QSPI.DORMANT_WAKE_INTE: Interrupt Enable for dormant_wake
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTE.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTE_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTE.Reg) & 0x1
}

// IO_QSPI.DORMANT_WAKE_INTF: Interrupt Force for dormant_wake
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTF.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTF_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTF.Reg) & 0x1
}

// IO_QSPI.DORMANT_WAKE_INTS: Interrupt status after masking & forcing for dormant_wake
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x800000)|value<<23)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x800000) >> 23
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x400000)|value<<22)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x400000) >> 22
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x200000)|value<<21)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x200000) >> 21
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x100000)|value<<20)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD3_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x100000) >> 20
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x80000)|value<<19)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x80000) >> 19
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x40000)|value<<18)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x40000) >> 18
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x20000)|value<<17)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x20000) >> 17
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x10000)|value<<16)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD2_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x10000) >> 16
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x8000)|value<<15)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x8000) >> 15
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x4000)|value<<14)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x4000) >> 14
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x2000)|value<<13)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x2000) >> 13
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x1000)|value<<12)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD1_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x1000) >> 12
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x800)|value<<11)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x800) >> 11
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x400)|value<<10)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x400) >> 10
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x200)|value<<9)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x200) >> 9
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x100)|value<<8)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SD0_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x100) >> 8
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x80)|value<<7)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x80) >> 7
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x40)|value<<6)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SS_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x40) >> 6
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x20)|value<<5)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x20) >> 5
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x10)|value<<4)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SS_LEVEL_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x10) >> 4
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x8)|value<<3)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x8) >> 3
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x4)|value<<2)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_EDGE_LOW() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x4) >> 2
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x2)|value<<1)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_HIGH() uint32 {
	return (volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x2) >> 1
}
func (o *IO_QSPI_Type) SetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_LOW(value uint32) {
	volatile.StoreUint32(&o.DORMANT_WAKE_INTS.Reg, volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg)&^(0x1)|value)
}
func (o *IO_QSPI_Type) GetDORMANT_WAKE_INTS_GPIO_QSPI_SCLK_LEVEL_LOW() uint32 {
	return volatile.LoadUint32(&o.DORMANT_WAKE_INTS.Reg) & 0x1
}

type PADS_BANK0_Type struct {
	VOLTAGE_SELECT volatile.Register32 // 0x0
	GPIO0          volatile.Register32 // 0x4
	GPIO1          volatile.Register32 // 0x8
	GPIO2          volatile.Register32 // 0xC
	GPIO3          volatile.Register32 // 0x10
	GPIO4          volatile.Register32 // 0x14
	GPIO5          volatile.Register32 // 0x18
	GPIO6          volatile.Register32 // 0x1C
	GPIO7          volatile.Register32 // 0x20
	GPIO8          volatile.Register32 // 0x24
	GPIO9          volatile.Register32 // 0x28
	GPIO10         volatile.Register32 // 0x2C
	GPIO11         volatile.Register32 // 0x30
	GPIO12         volatile.Register32 // 0x34
	GPIO13         volatile.Register32 // 0x38
	GPIO14         volatile.Register32 // 0x3C
	GPIO15         volatile.Register32 // 0x40
	GPIO16         volatile.Register32 // 0x44
	GPIO17         volatile.Register32 // 0x48
	GPIO18         volatile.Register32 // 0x4C
	GPIO19         volatile.Register32 // 0x50
	GPIO20         volatile.Register32 // 0x54
	GPIO21         volatile.Register32 // 0x58
	GPIO22         volatile.Register32 // 0x5C
	GPIO23         volatile.Register32 // 0x60
	GPIO24         volatile.Register32 // 0x64
	GPIO25         volatile.Register32 // 0x68
	GPIO26         volatile.Register32 // 0x6C
	GPIO27         volatile.Register32 // 0x70
	GPIO28         volatile.Register32 // 0x74
	GPIO29         volatile.Register32 // 0x78
	SWCLK          volatile.Register32 // 0x7C
	SWD            volatile.Register32 // 0x80
}

// PADS_BANK0.VOLTAGE_SELECT: Voltage select. Per bank control
func (o *PADS_BANK0_Type) SetVOLTAGE_SELECT(value uint32) {
	volatile.StoreUint32(&o.VOLTAGE_SELECT.Reg, volatile.LoadUint32(&o.VOLTAGE_SELECT.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetVOLTAGE_SELECT() uint32 {
	return volatile.LoadUint32(&o.VOLTAGE_SELECT.Reg) & 0x1
}

// PADS_BANK0.GPIO0: Pad control register
func (o *PADS_BANK0_Type) SetGPIO0_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO0_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO0_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO0_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO0_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO0_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO0_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO0_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO0_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO0_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO0_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO0_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO0_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO0_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO0.Reg) & 0x1
}

// PADS_BANK0.GPIO1: Pad control register
func (o *PADS_BANK0_Type) SetGPIO1_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO1_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO1_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO1_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO1_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO1_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO1_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO1_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO1_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO1_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO1_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO1_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO1_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO1_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO1.Reg) & 0x1
}

// PADS_BANK0.GPIO2: Pad control register
func (o *PADS_BANK0_Type) SetGPIO2_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO2_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO2_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO2_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO2_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO2_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO2_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO2_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO2_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO2_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO2_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO2_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO2_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO2_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO2.Reg) & 0x1
}

// PADS_BANK0.GPIO3: Pad control register
func (o *PADS_BANK0_Type) SetGPIO3_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO3_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO3_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO3_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO3_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO3_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO3_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO3_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO3_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO3_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO3_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO3_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO3_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO3_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO3.Reg) & 0x1
}

// PADS_BANK0.GPIO4: Pad control register
func (o *PADS_BANK0_Type) SetGPIO4_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO4_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO4_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO4_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO4_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO4_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO4_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO4_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO4_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO4_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO4_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO4_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO4_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO4_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO4.Reg) & 0x1
}

// PADS_BANK0.GPIO5: Pad control register
func (o *PADS_BANK0_Type) SetGPIO5_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO5_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO5_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO5_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO5_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO5_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO5_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO5_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO5_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO5_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO5_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO5_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO5_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO5_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO5.Reg) & 0x1
}

// PADS_BANK0.GPIO6: Pad control register
func (o *PADS_BANK0_Type) SetGPIO6_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO6_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO6_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO6_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO6_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO6_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO6_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO6_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO6_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO6_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO6_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO6_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO6_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO6_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO6.Reg) & 0x1
}

// PADS_BANK0.GPIO7: Pad control register
func (o *PADS_BANK0_Type) SetGPIO7_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO7_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO7_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO7_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO7_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO7_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO7_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO7_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO7_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO7_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO7_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO7_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO7_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO7_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO7.Reg) & 0x1
}

// PADS_BANK0.GPIO8: Pad control register
func (o *PADS_BANK0_Type) SetGPIO8_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO8_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO8_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO8_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO8_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO8_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO8_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO8_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO8_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO8_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO8_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO8_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO8_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO8_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO8.Reg) & 0x1
}

// PADS_BANK0.GPIO9: Pad control register
func (o *PADS_BANK0_Type) SetGPIO9_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO9_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO9_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO9_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO9_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO9_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO9_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO9_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO9_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO9_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO9_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO9_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO9_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO9_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO9.Reg) & 0x1
}

// PADS_BANK0.GPIO10: Pad control register
func (o *PADS_BANK0_Type) SetGPIO10_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO10_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO10_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO10_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO10_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO10_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO10_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO10_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO10_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO10_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO10_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO10_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO10_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO10_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO10.Reg) & 0x1
}

// PADS_BANK0.GPIO11: Pad control register
func (o *PADS_BANK0_Type) SetGPIO11_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO11_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO11_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO11_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO11_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO11_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO11_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO11_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO11_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO11_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO11_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO11_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO11_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO11_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO11.Reg) & 0x1
}

// PADS_BANK0.GPIO12: Pad control register
func (o *PADS_BANK0_Type) SetGPIO12_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO12_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO12_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO12_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO12_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO12_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO12_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO12_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO12_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO12_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO12_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO12_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO12_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO12_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO12.Reg) & 0x1
}

// PADS_BANK0.GPIO13: Pad control register
func (o *PADS_BANK0_Type) SetGPIO13_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO13_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO13_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO13_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO13_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO13_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO13_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO13_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO13_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO13_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO13_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO13_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO13_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO13_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO13.Reg) & 0x1
}

// PADS_BANK0.GPIO14: Pad control register
func (o *PADS_BANK0_Type) SetGPIO14_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO14_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO14_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO14_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO14_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO14_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO14_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO14_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO14_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO14_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO14_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO14_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO14_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO14_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO14.Reg) & 0x1
}

// PADS_BANK0.GPIO15: Pad control register
func (o *PADS_BANK0_Type) SetGPIO15_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO15_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO15_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO15_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO15_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO15_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO15_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO15_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO15_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO15_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO15_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO15_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO15_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO15_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO15.Reg) & 0x1
}

// PADS_BANK0.GPIO16: Pad control register
func (o *PADS_BANK0_Type) SetGPIO16_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO16_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO16_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO16_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO16_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO16_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO16_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO16_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO16_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO16_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO16_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO16_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO16_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO16_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO16.Reg) & 0x1
}

// PADS_BANK0.GPIO17: Pad control register
func (o *PADS_BANK0_Type) SetGPIO17_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO17_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO17_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO17_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO17_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO17_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO17_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO17_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO17_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO17_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO17_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO17_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO17_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO17_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO17.Reg) & 0x1
}

// PADS_BANK0.GPIO18: Pad control register
func (o *PADS_BANK0_Type) SetGPIO18_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO18_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO18_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO18_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO18_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO18_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO18_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO18_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO18_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO18_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO18_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO18_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO18_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO18_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO18.Reg) & 0x1
}

// PADS_BANK0.GPIO19: Pad control register
func (o *PADS_BANK0_Type) SetGPIO19_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO19_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO19_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO19_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO19_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO19_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO19_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO19_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO19_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO19_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO19_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO19_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO19_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO19_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO19.Reg) & 0x1
}

// PADS_BANK0.GPIO20: Pad control register
func (o *PADS_BANK0_Type) SetGPIO20_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO20_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO20_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO20_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO20_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO20_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO20_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO20_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO20_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO20_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO20_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO20_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO20_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO20_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO20.Reg) & 0x1
}

// PADS_BANK0.GPIO21: Pad control register
func (o *PADS_BANK0_Type) SetGPIO21_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO21_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO21_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO21_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO21_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO21_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO21_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO21_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO21_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO21_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO21_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO21_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO21_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO21_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO21.Reg) & 0x1
}

// PADS_BANK0.GPIO22: Pad control register
func (o *PADS_BANK0_Type) SetGPIO22_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO22_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO22_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO22_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO22_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO22_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO22_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO22_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO22_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO22_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO22_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO22_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO22.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO22_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO22.Reg, volatile.LoadUint32(&o.GPIO22.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO22_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO22.Reg) & 0x1
}

// PADS_BANK0.GPIO23: Pad control register
func (o *PADS_BANK0_Type) SetGPIO23_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO23_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO23_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO23_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO23_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO23_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO23_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO23_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO23_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO23_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO23_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO23_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO23.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO23_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO23.Reg, volatile.LoadUint32(&o.GPIO23.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO23_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO23.Reg) & 0x1
}

// PADS_BANK0.GPIO24: Pad control register
func (o *PADS_BANK0_Type) SetGPIO24_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO24_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO24_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO24_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO24_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO24_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO24_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO24_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO24_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO24_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO24_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO24_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO24.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO24_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO24.Reg, volatile.LoadUint32(&o.GPIO24.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO24_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO24.Reg) & 0x1
}

// PADS_BANK0.GPIO25: Pad control register
func (o *PADS_BANK0_Type) SetGPIO25_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO25_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO25_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO25_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO25_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO25_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO25_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO25_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO25_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO25_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO25_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO25_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO25.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO25_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO25.Reg, volatile.LoadUint32(&o.GPIO25.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO25_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO25.Reg) & 0x1
}

// PADS_BANK0.GPIO26: Pad control register
func (o *PADS_BANK0_Type) SetGPIO26_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO26_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO26_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO26_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO26_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO26_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO26_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO26_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO26_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO26_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO26_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO26_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO26_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO26_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO26.Reg) & 0x1
}

// PADS_BANK0.GPIO27: Pad control register
func (o *PADS_BANK0_Type) SetGPIO27_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO27_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO27_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO27_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO27_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO27_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO27_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO27_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO27_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO27_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO27_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO27_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO27_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO27_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO27.Reg) & 0x1
}

// PADS_BANK0.GPIO28: Pad control register
func (o *PADS_BANK0_Type) SetGPIO28_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO28_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO28_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO28_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO28_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO28_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO28_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO28_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO28_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO28_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO28_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO28_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO28_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO28_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO28.Reg) & 0x1
}

// PADS_BANK0.GPIO29: Pad control register
func (o *PADS_BANK0_Type) SetGPIO29_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetGPIO29_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetGPIO29_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetGPIO29_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetGPIO29_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetGPIO29_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetGPIO29_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetGPIO29_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetGPIO29_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetGPIO29_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetGPIO29_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetGPIO29_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetGPIO29_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetGPIO29_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO29.Reg) & 0x1
}

// PADS_BANK0.SWCLK: Pad control register
func (o *PADS_BANK0_Type) SetSWCLK_OD(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetSWCLK_OD() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetSWCLK_IE(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetSWCLK_IE() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetSWCLK_DRIVE(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetSWCLK_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetSWCLK_PUE(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetSWCLK_PUE() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetSWCLK_PDE(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetSWCLK_PDE() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetSWCLK_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetSWCLK_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.SWCLK.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetSWCLK_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.SWCLK.Reg, volatile.LoadUint32(&o.SWCLK.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetSWCLK_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.SWCLK.Reg) & 0x1
}

// PADS_BANK0.SWD: Pad control register
func (o *PADS_BANK0_Type) SetSWD_OD(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x80)|value<<7)
}
func (o *PADS_BANK0_Type) GetSWD_OD() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x80) >> 7
}
func (o *PADS_BANK0_Type) SetSWD_IE(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x40)|value<<6)
}
func (o *PADS_BANK0_Type) GetSWD_IE() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x40) >> 6
}
func (o *PADS_BANK0_Type) SetSWD_DRIVE(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x30)|value<<4)
}
func (o *PADS_BANK0_Type) GetSWD_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x30) >> 4
}
func (o *PADS_BANK0_Type) SetSWD_PUE(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x8)|value<<3)
}
func (o *PADS_BANK0_Type) GetSWD_PUE() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x8) >> 3
}
func (o *PADS_BANK0_Type) SetSWD_PDE(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x4)|value<<2)
}
func (o *PADS_BANK0_Type) GetSWD_PDE() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x4) >> 2
}
func (o *PADS_BANK0_Type) SetSWD_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x2)|value<<1)
}
func (o *PADS_BANK0_Type) GetSWD_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.SWD.Reg) & 0x2) >> 1
}
func (o *PADS_BANK0_Type) SetSWD_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.SWD.Reg, volatile.LoadUint32(&o.SWD.Reg)&^(0x1)|value)
}
func (o *PADS_BANK0_Type) GetSWD_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.SWD.Reg) & 0x1
}

type PADS_QSPI_Type struct {
	VOLTAGE_SELECT volatile.Register32 // 0x0
	GPIO_QSPI_SCLK volatile.Register32 // 0x4
	GPIO_QSPI_SD0  volatile.Register32 // 0x8
	GPIO_QSPI_SD1  volatile.Register32 // 0xC
	GPIO_QSPI_SD2  volatile.Register32 // 0x10
	GPIO_QSPI_SD3  volatile.Register32 // 0x14
	GPIO_QSPI_SS   volatile.Register32 // 0x18
}

// PADS_QSPI.VOLTAGE_SELECT: Voltage select. Per bank control
func (o *PADS_QSPI_Type) SetVOLTAGE_SELECT(value uint32) {
	volatile.StoreUint32(&o.VOLTAGE_SELECT.Reg, volatile.LoadUint32(&o.VOLTAGE_SELECT.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetVOLTAGE_SELECT() uint32 {
	return volatile.LoadUint32(&o.VOLTAGE_SELECT.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SCLK: Pad control register
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SCLK_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SCLK.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SCLK_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SCLK.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SD0: Pad control register
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD0_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD0.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD0_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD0.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SD1: Pad control register
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD1_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD1.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD1_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD1.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SD2: Pad control register
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD2_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD2.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD2_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD2.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SD3: Pad control register
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SD3_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SD3.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SD3_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SD3.Reg) & 0x1
}

// PADS_QSPI.GPIO_QSPI_SS: Pad control register
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_OD(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x80)|value<<7)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_OD() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x80) >> 7
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x40)|value<<6)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x40) >> 6
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_DRIVE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x30)|value<<4)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_DRIVE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x30) >> 4
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_PUE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x8)|value<<3)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_PUE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x8) >> 3
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_PDE(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x4)|value<<2)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_PDE() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x4) >> 2
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_SCHMITT(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x2)|value<<1)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_SCHMITT() uint32 {
	return (volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x2) >> 1
}
func (o *PADS_QSPI_Type) SetGPIO_QSPI_SS_SLEWFAST(value uint32) {
	volatile.StoreUint32(&o.GPIO_QSPI_SS.Reg, volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg)&^(0x1)|value)
}
func (o *PADS_QSPI_Type) GetGPIO_QSPI_SS_SLEWFAST() uint32 {
	return volatile.LoadUint32(&o.GPIO_QSPI_SS.Reg) & 0x1
}

// Controls the crystal oscillator
type XOSC_Type struct {
	CTRL    volatile.Register32 // 0x0
	STATUS  volatile.Register32 // 0x4
	DORMANT volatile.Register32 // 0x8
	STARTUP volatile.Register32 // 0xC
	_       [12]byte
	COUNT   volatile.Register32 // 0x1C
}

// XOSC.CTRL: Crystal Oscillator Control
func (o *XOSC_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfff000)|value<<12)
}
func (o *XOSC_Type) GetCTRL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfff000) >> 12
}
func (o *XOSC_Type) SetCTRL_FREQ_RANGE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfff)|value)
}
func (o *XOSC_Type) GetCTRL_FREQ_RANGE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0xfff
}

// XOSC.STATUS: Crystal Oscillator Status
func (o *XOSC_Type) SetSTATUS_STABLE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80000000)|value<<31)
}
func (o *XOSC_Type) GetSTATUS_STABLE() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80000000) >> 31
}
func (o *XOSC_Type) SetSTATUS_BADWRITE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *XOSC_Type) GetSTATUS_BADWRITE() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x1000000) >> 24
}
func (o *XOSC_Type) SetSTATUS_ENABLED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *XOSC_Type) GetSTATUS_ENABLED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x1000) >> 12
}
func (o *XOSC_Type) SetSTATUS_FREQ_RANGE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x3)|value)
}
func (o *XOSC_Type) GetSTATUS_FREQ_RANGE() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x3
}

// XOSC.STARTUP: Controls the startup delay
func (o *XOSC_Type) SetSTARTUP_X4(value uint32) {
	volatile.StoreUint32(&o.STARTUP.Reg, volatile.LoadUint32(&o.STARTUP.Reg)&^(0x100000)|value<<20)
}
func (o *XOSC_Type) GetSTARTUP_X4() uint32 {
	return (volatile.LoadUint32(&o.STARTUP.Reg) & 0x100000) >> 20
}
func (o *XOSC_Type) SetSTARTUP_DELAY(value uint32) {
	volatile.StoreUint32(&o.STARTUP.Reg, volatile.LoadUint32(&o.STARTUP.Reg)&^(0x3fff)|value)
}
func (o *XOSC_Type) GetSTARTUP_DELAY() uint32 {
	return volatile.LoadUint32(&o.STARTUP.Reg) & 0x3fff
}

// XOSC.COUNT
// A down counter running at the xosc frequency which counts to zero and stops.
// To start the counter write a non-zero value.
// Can be used for short software pauses when setting up time sensitive hardware.
func (o *XOSC_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xff)|value)
}
func (o *XOSC_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg) & 0xff
}

type PLL_SYS_Type struct {
	CS        volatile.Register32 // 0x0
	PWR       volatile.Register32 // 0x4
	FBDIV_INT volatile.Register32 // 0x8
	PRIM      volatile.Register32 // 0xC
}

// PLL_SYS.CS
// Control and Status
// GENERAL CONSTRAINTS:
// Reference clock frequency min=5MHz, max=800MHz
// Feedback divider min=16, max=320
// VCO frequency min=400MHz, max=1600MHz
func (o *PLL_SYS_Type) SetCS_LOCK(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x80000000)|value<<31)
}
func (o *PLL_SYS_Type) GetCS_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CS.Reg) & 0x80000000) >> 31
}
func (o *PLL_SYS_Type) SetCS_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x100)|value<<8)
}
func (o *PLL_SYS_Type) GetCS_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CS.Reg) & 0x100) >> 8
}
func (o *PLL_SYS_Type) SetCS_REFDIV(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x3f)|value)
}
func (o *PLL_SYS_Type) GetCS_REFDIV() uint32 {
	return volatile.LoadUint32(&o.CS.Reg) & 0x3f
}

// PLL_SYS.PWR: Controls the PLL power modes.
func (o *PLL_SYS_Type) SetPWR_VCOPD(value uint32) {
	volatile.StoreUint32(&o.PWR.Reg, volatile.LoadUint32(&o.PWR.Reg)&^(0x20)|value<<5)
}
func (o *PLL_SYS_Type) GetPWR_VCOPD() uint32 {
	return (volatile.LoadUint32(&o.PWR.Reg) & 0x20) >> 5
}
func (o *PLL_SYS_Type) SetPWR_POSTDIVPD(value uint32) {
	volatile.StoreUint32(&o.PWR.Reg, volatile.LoadUint32(&o.PWR.Reg)&^(0x8)|value<<3)
}
func (o *PLL_SYS_Type) GetPWR_POSTDIVPD() uint32 {
	return (volatile.LoadUint32(&o.PWR.Reg) & 0x8) >> 3
}
func (o *PLL_SYS_Type) SetPWR_DSMPD(value uint32) {
	volatile.StoreUint32(&o.PWR.Reg, volatile.LoadUint32(&o.PWR.Reg)&^(0x4)|value<<2)
}
func (o *PLL_SYS_Type) GetPWR_DSMPD() uint32 {
	return (volatile.LoadUint32(&o.PWR.Reg) & 0x4) >> 2
}
func (o *PLL_SYS_Type) SetPWR_PD(value uint32) {
	volatile.StoreUint32(&o.PWR.Reg, volatile.LoadUint32(&o.PWR.Reg)&^(0x1)|value)
}
func (o *PLL_SYS_Type) GetPWR_PD() uint32 {
	return volatile.LoadUint32(&o.PWR.Reg) & 0x1
}

// PLL_SYS.FBDIV_INT
// Feedback divisor
// (note: this PLL does not support fractional division)
func (o *PLL_SYS_Type) SetFBDIV_INT(value uint32) {
	volatile.StoreUint32(&o.FBDIV_INT.Reg, volatile.LoadUint32(&o.FBDIV_INT.Reg)&^(0xfff)|value)
}
func (o *PLL_SYS_Type) GetFBDIV_INT() uint32 {
	return volatile.LoadUint32(&o.FBDIV_INT.Reg) & 0xfff
}

// PLL_SYS.PRIM
// Controls the PLL post dividers for the primary output
// (note: this PLL does not have a secondary output)
// the primary output is driven from VCO divided by postdiv1*postdiv2
func (o *PLL_SYS_Type) SetPRIM_POSTDIV1(value uint32) {
	volatile.StoreUint32(&o.PRIM.Reg, volatile.LoadUint32(&o.PRIM.Reg)&^(0x70000)|value<<16)
}
func (o *PLL_SYS_Type) GetPRIM_POSTDIV1() uint32 {
	return (volatile.LoadUint32(&o.PRIM.Reg) & 0x70000) >> 16
}
func (o *PLL_SYS_Type) SetPRIM_POSTDIV2(value uint32) {
	volatile.StoreUint32(&o.PRIM.Reg, volatile.LoadUint32(&o.PRIM.Reg)&^(0x7000)|value<<12)
}
func (o *PLL_SYS_Type) GetPRIM_POSTDIV2() uint32 {
	return (volatile.LoadUint32(&o.PRIM.Reg) & 0x7000) >> 12
}

// Register block for busfabric control signals and performance counters
type BUSCTRL_Type struct {
	BUS_PRIORITY     volatile.Register32 // 0x0
	BUS_PRIORITY_ACK volatile.Register32 // 0x4
	PERFCTR0         volatile.Register32 // 0x8
	PERFSEL0         volatile.Register32 // 0xC
	PERFCTR1         volatile.Register32 // 0x10
	PERFSEL1         volatile.Register32 // 0x14
	PERFCTR2         volatile.Register32 // 0x18
	PERFSEL2         volatile.Register32 // 0x1C
	PERFCTR3         volatile.Register32 // 0x20
	PERFSEL3         volatile.Register32 // 0x24
}

// BUSCTRL.BUS_PRIORITY: Set the priority of each master for bus arbitration.
func (o *BUSCTRL_Type) SetBUS_PRIORITY_DMA_W(value uint32) {
	volatile.StoreUint32(&o.BUS_PRIORITY.Reg, volatile.LoadUint32(&o.BUS_PRIORITY.Reg)&^(0x1000)|value<<12)
}
func (o *BUSCTRL_Type) GetBUS_PRIORITY_DMA_W() uint32 {
	return (volatile.LoadUint32(&o.BUS_PRIORITY.Reg) & 0x1000) >> 12
}
func (o *BUSCTRL_Type) SetBUS_PRIORITY_DMA_R(value uint32) {
	volatile.StoreUint32(&o.BUS_PRIORITY.Reg, volatile.LoadUint32(&o.BUS_PRIORITY.Reg)&^(0x100)|value<<8)
}
func (o *BUSCTRL_Type) GetBUS_PRIORITY_DMA_R() uint32 {
	return (volatile.LoadUint32(&o.BUS_PRIORITY.Reg) & 0x100) >> 8
}
func (o *BUSCTRL_Type) SetBUS_PRIORITY_PROC1(value uint32) {
	volatile.StoreUint32(&o.BUS_PRIORITY.Reg, volatile.LoadUint32(&o.BUS_PRIORITY.Reg)&^(0x10)|value<<4)
}
func (o *BUSCTRL_Type) GetBUS_PRIORITY_PROC1() uint32 {
	return (volatile.LoadUint32(&o.BUS_PRIORITY.Reg) & 0x10) >> 4
}
func (o *BUSCTRL_Type) SetBUS_PRIORITY_PROC0(value uint32) {
	volatile.StoreUint32(&o.BUS_PRIORITY.Reg, volatile.LoadUint32(&o.BUS_PRIORITY.Reg)&^(0x1)|value)
}
func (o *BUSCTRL_Type) GetBUS_PRIORITY_PROC0() uint32 {
	return volatile.LoadUint32(&o.BUS_PRIORITY.Reg) & 0x1
}

// BUSCTRL.BUS_PRIORITY_ACK: Bus priority acknowledge
func (o *BUSCTRL_Type) SetBUS_PRIORITY_ACK(value uint32) {
	volatile.StoreUint32(&o.BUS_PRIORITY_ACK.Reg, volatile.LoadUint32(&o.BUS_PRIORITY_ACK.Reg)&^(0x1)|value)
}
func (o *BUSCTRL_Type) GetBUS_PRIORITY_ACK() uint32 {
	return volatile.LoadUint32(&o.BUS_PRIORITY_ACK.Reg) & 0x1
}

// BUSCTRL.PERFCTR0: Bus fabric performance counter 0
func (o *BUSCTRL_Type) SetPERFCTR0(value uint32) {
	volatile.StoreUint32(&o.PERFCTR0.Reg, volatile.LoadUint32(&o.PERFCTR0.Reg)&^(0xffffff)|value)
}
func (o *BUSCTRL_Type) GetPERFCTR0() uint32 {
	return volatile.LoadUint32(&o.PERFCTR0.Reg) & 0xffffff
}

// BUSCTRL.PERFSEL0: Bus fabric performance event select for PERFCTR0
func (o *BUSCTRL_Type) SetPERFSEL0(value uint32) {
	volatile.StoreUint32(&o.PERFSEL0.Reg, volatile.LoadUint32(&o.PERFSEL0.Reg)&^(0x1f)|value)
}
func (o *BUSCTRL_Type) GetPERFSEL0() uint32 {
	return volatile.LoadUint32(&o.PERFSEL0.Reg) & 0x1f
}

// BUSCTRL.PERFCTR1: Bus fabric performance counter 1
func (o *BUSCTRL_Type) SetPERFCTR1(value uint32) {
	volatile.StoreUint32(&o.PERFCTR1.Reg, volatile.LoadUint32(&o.PERFCTR1.Reg)&^(0xffffff)|value)
}
func (o *BUSCTRL_Type) GetPERFCTR1() uint32 {
	return volatile.LoadUint32(&o.PERFCTR1.Reg) & 0xffffff
}

// BUSCTRL.PERFSEL1: Bus fabric performance event select for PERFCTR1
func (o *BUSCTRL_Type) SetPERFSEL1(value uint32) {
	volatile.StoreUint32(&o.PERFSEL1.Reg, volatile.LoadUint32(&o.PERFSEL1.Reg)&^(0x1f)|value)
}
func (o *BUSCTRL_Type) GetPERFSEL1() uint32 {
	return volatile.LoadUint32(&o.PERFSEL1.Reg) & 0x1f
}

// BUSCTRL.PERFCTR2: Bus fabric performance counter 2
func (o *BUSCTRL_Type) SetPERFCTR2(value uint32) {
	volatile.StoreUint32(&o.PERFCTR2.Reg, volatile.LoadUint32(&o.PERFCTR2.Reg)&^(0xffffff)|value)
}
func (o *BUSCTRL_Type) GetPERFCTR2() uint32 {
	return volatile.LoadUint32(&o.PERFCTR2.Reg) & 0xffffff
}

// BUSCTRL.PERFSEL2: Bus fabric performance event select for PERFCTR2
func (o *BUSCTRL_Type) SetPERFSEL2(value uint32) {
	volatile.StoreUint32(&o.PERFSEL2.Reg, volatile.LoadUint32(&o.PERFSEL2.Reg)&^(0x1f)|value)
}
func (o *BUSCTRL_Type) GetPERFSEL2() uint32 {
	return volatile.LoadUint32(&o.PERFSEL2.Reg) & 0x1f
}

// BUSCTRL.PERFCTR3: Bus fabric performance counter 3
func (o *BUSCTRL_Type) SetPERFCTR3(value uint32) {
	volatile.StoreUint32(&o.PERFCTR3.Reg, volatile.LoadUint32(&o.PERFCTR3.Reg)&^(0xffffff)|value)
}
func (o *BUSCTRL_Type) GetPERFCTR3() uint32 {
	return volatile.LoadUint32(&o.PERFCTR3.Reg) & 0xffffff
}

// BUSCTRL.PERFSEL3: Bus fabric performance event select for PERFCTR3
func (o *BUSCTRL_Type) SetPERFSEL3(value uint32) {
	volatile.StoreUint32(&o.PERFSEL3.Reg, volatile.LoadUint32(&o.PERFSEL3.Reg)&^(0x1f)|value)
}
func (o *BUSCTRL_Type) GetPERFSEL3() uint32 {
	return volatile.LoadUint32(&o.PERFSEL3.Reg) & 0x1f
}

type UART0_Type struct {
	UARTDR        volatile.Register32 // 0x0
	UARTRSR       volatile.Register32 // 0x4
	_             [16]byte
	UARTFR        volatile.Register32 // 0x18
	_             [4]byte
	UARTILPR      volatile.Register32 // 0x20
	UARTIBRD      volatile.Register32 // 0x24
	UARTFBRD      volatile.Register32 // 0x28
	UARTLCR_H     volatile.Register32 // 0x2C
	UARTCR        volatile.Register32 // 0x30
	UARTIFLS      volatile.Register32 // 0x34
	UARTIMSC      volatile.Register32 // 0x38
	UARTRIS       volatile.Register32 // 0x3C
	UARTMIS       volatile.Register32 // 0x40
	UARTICR       volatile.Register32 // 0x44
	UARTDMACR     volatile.Register32 // 0x48
	_             [3988]byte
	UARTPERIPHID0 volatile.Register32 // 0xFE0
	UARTPERIPHID1 volatile.Register32 // 0xFE4
	UARTPERIPHID2 volatile.Register32 // 0xFE8
	UARTPERIPHID3 volatile.Register32 // 0xFEC
	UARTPCELLID0  volatile.Register32 // 0xFF0
	UARTPCELLID1  volatile.Register32 // 0xFF4
	UARTPCELLID2  volatile.Register32 // 0xFF8
	UARTPCELLID3  volatile.Register32 // 0xFFC
}

// UART0.UARTDR: Data Register, UARTDR
func (o *UART0_Type) SetUARTDR_OE(value uint32) {
	volatile.StoreUint32(&o.UARTDR.Reg, volatile.LoadUint32(&o.UARTDR.Reg)&^(0x800)|value<<11)
}
func (o *UART0_Type) GetUARTDR_OE() uint32 {
	return (volatile.LoadUint32(&o.UARTDR.Reg) & 0x800) >> 11
}
func (o *UART0_Type) SetUARTDR_BE(value uint32) {
	volatile.StoreUint32(&o.UARTDR.Reg, volatile.LoadUint32(&o.UARTDR.Reg)&^(0x400)|value<<10)
}
func (o *UART0_Type) GetUARTDR_BE() uint32 {
	return (volatile.LoadUint32(&o.UARTDR.Reg) & 0x400) >> 10
}
func (o *UART0_Type) SetUARTDR_PE(value uint32) {
	volatile.StoreUint32(&o.UARTDR.Reg, volatile.LoadUint32(&o.UARTDR.Reg)&^(0x200)|value<<9)
}
func (o *UART0_Type) GetUARTDR_PE() uint32 {
	return (volatile.LoadUint32(&o.UARTDR.Reg) & 0x200) >> 9
}
func (o *UART0_Type) SetUARTDR_FE(value uint32) {
	volatile.StoreUint32(&o.UARTDR.Reg, volatile.LoadUint32(&o.UARTDR.Reg)&^(0x100)|value<<8)
}
func (o *UART0_Type) GetUARTDR_FE() uint32 {
	return (volatile.LoadUint32(&o.UARTDR.Reg) & 0x100) >> 8
}
func (o *UART0_Type) SetUARTDR_DATA(value uint32) {
	volatile.StoreUint32(&o.UARTDR.Reg, volatile.LoadUint32(&o.UARTDR.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetUARTDR_DATA() uint32 {
	return volatile.LoadUint32(&o.UARTDR.Reg) & 0xff
}

// UART0.UARTRSR: Receive Status Register/Error Clear Register, UARTRSR/UARTECR
func (o *UART0_Type) SetUARTRSR_OE(value uint32) {
	volatile.StoreUint32(&o.UARTRSR.Reg, volatile.LoadUint32(&o.UARTRSR.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetUARTRSR_OE() uint32 {
	return (volatile.LoadUint32(&o.UARTRSR.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetUARTRSR_BE(value uint32) {
	volatile.StoreUint32(&o.UARTRSR.Reg, volatile.LoadUint32(&o.UARTRSR.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetUARTRSR_BE() uint32 {
	return (volatile.LoadUint32(&o.UARTRSR.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetUARTRSR_PE(value uint32) {
	volatile.StoreUint32(&o.UARTRSR.Reg, volatile.LoadUint32(&o.UARTRSR.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetUARTRSR_PE() uint32 {
	return (volatile.LoadUint32(&o.UARTRSR.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetUARTRSR_FE(value uint32) {
	volatile.StoreUint32(&o.UARTRSR.Reg, volatile.LoadUint32(&o.UARTRSR.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetUARTRSR_FE() uint32 {
	return volatile.LoadUint32(&o.UARTRSR.Reg) & 0x1
}

// UART0.UARTFR: Flag Register, UARTFR
func (o *UART0_Type) SetUARTFR_RI(value uint32) {
	volatile.StoreUint32(&o.UARTFR.Reg, volatile.LoadUint32(&o.UARTFR.Reg)&^(0x100)|value<<8)
}
func (o *UART0_Type) GetUARTFR_RI() uint32 {
	return (volatile.LoadUint32(&o.UARTFR.Reg) & 0x100) >> 8
}
func (o *UART0_Type) SetUARTFR_TXFE(value uint32) {
	volatile.StoreUint32(&o.UARTFR.Reg, volatile.LoadUint32(&o.UARTFR.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetUARTFR_TXFE() uint32 {
	return (volatile.LoadUint32(&o.UARTFR.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetUARTFR_RXFF(value uint32) {
	volatile.StoreUint32(&o.UARTFR.Reg, volatile.LoadUint32(&o.UARTFR.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetUARTFR_RXFF() uint32 {
	return (volatile.LoadUint32(&o.UARTFR.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetUARTFR_TXFF(value uint32) {
	volatile.StoreUint32(&o.UARTFR.Reg, volatile.LoadUint32(&o.UARTFR.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetUARTFR_TXFF() uint32 {
	return (volatile.LoadUint32(&o.UARTFR.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetUARTFR_RXFE(value uint32) {
	volatile.StoreUint32(&o.UARTFR.Reg, volatile.LoadUint32(&o.UARTFR.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetUARTFR_RXFE() uint32 {
	return (volatile.LoadUint32(&o.UARTFR.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetUARTFR_BUSY(value uint32) {
	volatile.StoreUint32(&o.UARTFR.Reg, volatile.LoadUint32(&o.UARTFR.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetUARTFR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.UARTFR.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetUARTFR_DCD(value uint32) {
	volatile.StoreUint32(&o.UARTFR.Reg, volatile.LoadUint32(&o.UARTFR.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetUARTFR_DCD() uint32 {
	return (volatile.LoadUint32(&o.UARTFR.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetUARTFR_DSR(value uint32) {
	volatile.StoreUint32(&o.UARTFR.Reg, volatile.LoadUint32(&o.UARTFR.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetUARTFR_DSR() uint32 {
	return (volatile.LoadUint32(&o.UARTFR.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetUARTFR_CTS(value uint32) {
	volatile.StoreUint32(&o.UARTFR.Reg, volatile.LoadUint32(&o.UARTFR.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetUARTFR_CTS() uint32 {
	return volatile.LoadUint32(&o.UARTFR.Reg) & 0x1
}

// UART0.UARTILPR: IrDA Low-Power Counter Register, UARTILPR
func (o *UART0_Type) SetUARTILPR_ILPDVSR(value uint32) {
	volatile.StoreUint32(&o.UARTILPR.Reg, volatile.LoadUint32(&o.UARTILPR.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetUARTILPR_ILPDVSR() uint32 {
	return volatile.LoadUint32(&o.UARTILPR.Reg) & 0xff
}

// UART0.UARTIBRD: Integer Baud Rate Register, UARTIBRD
func (o *UART0_Type) SetUARTIBRD_BAUD_DIVINT(value uint32) {
	volatile.StoreUint32(&o.UARTIBRD.Reg, volatile.LoadUint32(&o.UARTIBRD.Reg)&^(0xffff)|value)
}
func (o *UART0_Type) GetUARTIBRD_BAUD_DIVINT() uint32 {
	return volatile.LoadUint32(&o.UARTIBRD.Reg) & 0xffff
}

// UART0.UARTFBRD: Fractional Baud Rate Register, UARTFBRD
func (o *UART0_Type) SetUARTFBRD_BAUD_DIVFRAC(value uint32) {
	volatile.StoreUint32(&o.UARTFBRD.Reg, volatile.LoadUint32(&o.UARTFBRD.Reg)&^(0x3f)|value)
}
func (o *UART0_Type) GetUARTFBRD_BAUD_DIVFRAC() uint32 {
	return volatile.LoadUint32(&o.UARTFBRD.Reg) & 0x3f
}

// UART0.UARTLCR_H: Line Control Register, UARTLCR_H
func (o *UART0_Type) SetUARTLCR_H_SPS(value uint32) {
	volatile.StoreUint32(&o.UARTLCR_H.Reg, volatile.LoadUint32(&o.UARTLCR_H.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetUARTLCR_H_SPS() uint32 {
	return (volatile.LoadUint32(&o.UARTLCR_H.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetUARTLCR_H_WLEN(value uint32) {
	volatile.StoreUint32(&o.UARTLCR_H.Reg, volatile.LoadUint32(&o.UARTLCR_H.Reg)&^(0x60)|value<<5)
}
func (o *UART0_Type) GetUARTLCR_H_WLEN() uint32 {
	return (volatile.LoadUint32(&o.UARTLCR_H.Reg) & 0x60) >> 5
}
func (o *UART0_Type) SetUARTLCR_H_FEN(value uint32) {
	volatile.StoreUint32(&o.UARTLCR_H.Reg, volatile.LoadUint32(&o.UARTLCR_H.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetUARTLCR_H_FEN() uint32 {
	return (volatile.LoadUint32(&o.UARTLCR_H.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetUARTLCR_H_STP2(value uint32) {
	volatile.StoreUint32(&o.UARTLCR_H.Reg, volatile.LoadUint32(&o.UARTLCR_H.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetUARTLCR_H_STP2() uint32 {
	return (volatile.LoadUint32(&o.UARTLCR_H.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetUARTLCR_H_EPS(value uint32) {
	volatile.StoreUint32(&o.UARTLCR_H.Reg, volatile.LoadUint32(&o.UARTLCR_H.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetUARTLCR_H_EPS() uint32 {
	return (volatile.LoadUint32(&o.UARTLCR_H.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetUARTLCR_H_PEN(value uint32) {
	volatile.StoreUint32(&o.UARTLCR_H.Reg, volatile.LoadUint32(&o.UARTLCR_H.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetUARTLCR_H_PEN() uint32 {
	return (volatile.LoadUint32(&o.UARTLCR_H.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetUARTLCR_H_BRK(value uint32) {
	volatile.StoreUint32(&o.UARTLCR_H.Reg, volatile.LoadUint32(&o.UARTLCR_H.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetUARTLCR_H_BRK() uint32 {
	return volatile.LoadUint32(&o.UARTLCR_H.Reg) & 0x1
}

// UART0.UARTCR: Control Register, UARTCR
func (o *UART0_Type) SetUARTCR_CTSEN(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x8000)|value<<15)
}
func (o *UART0_Type) GetUARTCR_CTSEN() uint32 {
	return (volatile.LoadUint32(&o.UARTCR.Reg) & 0x8000) >> 15
}
func (o *UART0_Type) SetUARTCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x4000)|value<<14)
}
func (o *UART0_Type) GetUARTCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.UARTCR.Reg) & 0x4000) >> 14
}
func (o *UART0_Type) SetUARTCR_OUT2(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x2000)|value<<13)
}
func (o *UART0_Type) GetUARTCR_OUT2() uint32 {
	return (volatile.LoadUint32(&o.UARTCR.Reg) & 0x2000) >> 13
}
func (o *UART0_Type) SetUARTCR_OUT1(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x1000)|value<<12)
}
func (o *UART0_Type) GetUARTCR_OUT1() uint32 {
	return (volatile.LoadUint32(&o.UARTCR.Reg) & 0x1000) >> 12
}
func (o *UART0_Type) SetUARTCR_RTS(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x800)|value<<11)
}
func (o *UART0_Type) GetUARTCR_RTS() uint32 {
	return (volatile.LoadUint32(&o.UARTCR.Reg) & 0x800) >> 11
}
func (o *UART0_Type) SetUARTCR_DTR(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x400)|value<<10)
}
func (o *UART0_Type) GetUARTCR_DTR() uint32 {
	return (volatile.LoadUint32(&o.UARTCR.Reg) & 0x400) >> 10
}
func (o *UART0_Type) SetUARTCR_RXE(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x200)|value<<9)
}
func (o *UART0_Type) GetUARTCR_RXE() uint32 {
	return (volatile.LoadUint32(&o.UARTCR.Reg) & 0x200) >> 9
}
func (o *UART0_Type) SetUARTCR_TXE(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x100)|value<<8)
}
func (o *UART0_Type) GetUARTCR_TXE() uint32 {
	return (volatile.LoadUint32(&o.UARTCR.Reg) & 0x100) >> 8
}
func (o *UART0_Type) SetUARTCR_LBE(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetUARTCR_LBE() uint32 {
	return (volatile.LoadUint32(&o.UARTCR.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetUARTCR_SIRLP(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetUARTCR_SIRLP() uint32 {
	return (volatile.LoadUint32(&o.UARTCR.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetUARTCR_SIREN(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetUARTCR_SIREN() uint32 {
	return (volatile.LoadUint32(&o.UARTCR.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetUARTCR_UARTEN(value uint32) {
	volatile.StoreUint32(&o.UARTCR.Reg, volatile.LoadUint32(&o.UARTCR.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetUARTCR_UARTEN() uint32 {
	return volatile.LoadUint32(&o.UARTCR.Reg) & 0x1
}

// UART0.UARTIFLS: Interrupt FIFO Level Select Register, UARTIFLS
func (o *UART0_Type) SetUARTIFLS_RXIFLSEL(value uint32) {
	volatile.StoreUint32(&o.UARTIFLS.Reg, volatile.LoadUint32(&o.UARTIFLS.Reg)&^(0x38)|value<<3)
}
func (o *UART0_Type) GetUARTIFLS_RXIFLSEL() uint32 {
	return (volatile.LoadUint32(&o.UARTIFLS.Reg) & 0x38) >> 3
}
func (o *UART0_Type) SetUARTIFLS_TXIFLSEL(value uint32) {
	volatile.StoreUint32(&o.UARTIFLS.Reg, volatile.LoadUint32(&o.UARTIFLS.Reg)&^(0x7)|value)
}
func (o *UART0_Type) GetUARTIFLS_TXIFLSEL() uint32 {
	return volatile.LoadUint32(&o.UARTIFLS.Reg) & 0x7
}

// UART0.UARTIMSC: Interrupt Mask Set/Clear Register, UARTIMSC
func (o *UART0_Type) SetUARTIMSC_OEIM(value uint32) {
	volatile.StoreUint32(&o.UARTIMSC.Reg, volatile.LoadUint32(&o.UARTIMSC.Reg)&^(0x400)|value<<10)
}
func (o *UART0_Type) GetUARTIMSC_OEIM() uint32 {
	return (volatile.LoadUint32(&o.UARTIMSC.Reg) & 0x400) >> 10
}
func (o *UART0_Type) SetUARTIMSC_BEIM(value uint32) {
	volatile.StoreUint32(&o.UARTIMSC.Reg, volatile.LoadUint32(&o.UARTIMSC.Reg)&^(0x200)|value<<9)
}
func (o *UART0_Type) GetUARTIMSC_BEIM() uint32 {
	return (volatile.LoadUint32(&o.UARTIMSC.Reg) & 0x200) >> 9
}
func (o *UART0_Type) SetUARTIMSC_PEIM(value uint32) {
	volatile.StoreUint32(&o.UARTIMSC.Reg, volatile.LoadUint32(&o.UARTIMSC.Reg)&^(0x100)|value<<8)
}
func (o *UART0_Type) GetUARTIMSC_PEIM() uint32 {
	return (volatile.LoadUint32(&o.UARTIMSC.Reg) & 0x100) >> 8
}
func (o *UART0_Type) SetUARTIMSC_FEIM(value uint32) {
	volatile.StoreUint32(&o.UARTIMSC.Reg, volatile.LoadUint32(&o.UARTIMSC.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetUARTIMSC_FEIM() uint32 {
	return (volatile.LoadUint32(&o.UARTIMSC.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetUARTIMSC_RTIM(value uint32) {
	volatile.StoreUint32(&o.UARTIMSC.Reg, volatile.LoadUint32(&o.UARTIMSC.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetUARTIMSC_RTIM() uint32 {
	return (volatile.LoadUint32(&o.UARTIMSC.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetUARTIMSC_TXIM(value uint32) {
	volatile.StoreUint32(&o.UARTIMSC.Reg, volatile.LoadUint32(&o.UARTIMSC.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetUARTIMSC_TXIM() uint32 {
	return (volatile.LoadUint32(&o.UARTIMSC.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetUARTIMSC_RXIM(value uint32) {
	volatile.StoreUint32(&o.UARTIMSC.Reg, volatile.LoadUint32(&o.UARTIMSC.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetUARTIMSC_RXIM() uint32 {
	return (volatile.LoadUint32(&o.UARTIMSC.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetUARTIMSC_DSRMIM(value uint32) {
	volatile.StoreUint32(&o.UARTIMSC.Reg, volatile.LoadUint32(&o.UARTIMSC.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetUARTIMSC_DSRMIM() uint32 {
	return (volatile.LoadUint32(&o.UARTIMSC.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetUARTIMSC_DCDMIM(value uint32) {
	volatile.StoreUint32(&o.UARTIMSC.Reg, volatile.LoadUint32(&o.UARTIMSC.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetUARTIMSC_DCDMIM() uint32 {
	return (volatile.LoadUint32(&o.UARTIMSC.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetUARTIMSC_CTSMIM(value uint32) {
	volatile.StoreUint32(&o.UARTIMSC.Reg, volatile.LoadUint32(&o.UARTIMSC.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetUARTIMSC_CTSMIM() uint32 {
	return (volatile.LoadUint32(&o.UARTIMSC.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetUARTIMSC_RIMIM(value uint32) {
	volatile.StoreUint32(&o.UARTIMSC.Reg, volatile.LoadUint32(&o.UARTIMSC.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetUARTIMSC_RIMIM() uint32 {
	return volatile.LoadUint32(&o.UARTIMSC.Reg) & 0x1
}

// UART0.UARTRIS: Raw Interrupt Status Register, UARTRIS
func (o *UART0_Type) SetUARTRIS_OERIS(value uint32) {
	volatile.StoreUint32(&o.UARTRIS.Reg, volatile.LoadUint32(&o.UARTRIS.Reg)&^(0x400)|value<<10)
}
func (o *UART0_Type) GetUARTRIS_OERIS() uint32 {
	return (volatile.LoadUint32(&o.UARTRIS.Reg) & 0x400) >> 10
}
func (o *UART0_Type) SetUARTRIS_BERIS(value uint32) {
	volatile.StoreUint32(&o.UARTRIS.Reg, volatile.LoadUint32(&o.UARTRIS.Reg)&^(0x200)|value<<9)
}
func (o *UART0_Type) GetUARTRIS_BERIS() uint32 {
	return (volatile.LoadUint32(&o.UARTRIS.Reg) & 0x200) >> 9
}
func (o *UART0_Type) SetUARTRIS_PERIS(value uint32) {
	volatile.StoreUint32(&o.UARTRIS.Reg, volatile.LoadUint32(&o.UARTRIS.Reg)&^(0x100)|value<<8)
}
func (o *UART0_Type) GetUARTRIS_PERIS() uint32 {
	return (volatile.LoadUint32(&o.UARTRIS.Reg) & 0x100) >> 8
}
func (o *UART0_Type) SetUARTRIS_FERIS(value uint32) {
	volatile.StoreUint32(&o.UARTRIS.Reg, volatile.LoadUint32(&o.UARTRIS.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetUARTRIS_FERIS() uint32 {
	return (volatile.LoadUint32(&o.UARTRIS.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetUARTRIS_RTRIS(value uint32) {
	volatile.StoreUint32(&o.UARTRIS.Reg, volatile.LoadUint32(&o.UARTRIS.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetUARTRIS_RTRIS() uint32 {
	return (volatile.LoadUint32(&o.UARTRIS.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetUARTRIS_TXRIS(value uint32) {
	volatile.StoreUint32(&o.UARTRIS.Reg, volatile.LoadUint32(&o.UARTRIS.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetUARTRIS_TXRIS() uint32 {
	return (volatile.LoadUint32(&o.UARTRIS.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetUARTRIS_RXRIS(value uint32) {
	volatile.StoreUint32(&o.UARTRIS.Reg, volatile.LoadUint32(&o.UARTRIS.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetUARTRIS_RXRIS() uint32 {
	return (volatile.LoadUint32(&o.UARTRIS.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetUARTRIS_DSRRMIS(value uint32) {
	volatile.StoreUint32(&o.UARTRIS.Reg, volatile.LoadUint32(&o.UARTRIS.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetUARTRIS_DSRRMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTRIS.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetUARTRIS_DCDRMIS(value uint32) {
	volatile.StoreUint32(&o.UARTRIS.Reg, volatile.LoadUint32(&o.UARTRIS.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetUARTRIS_DCDRMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTRIS.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetUARTRIS_CTSRMIS(value uint32) {
	volatile.StoreUint32(&o.UARTRIS.Reg, volatile.LoadUint32(&o.UARTRIS.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetUARTRIS_CTSRMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTRIS.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetUARTRIS_RIRMIS(value uint32) {
	volatile.StoreUint32(&o.UARTRIS.Reg, volatile.LoadUint32(&o.UARTRIS.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetUARTRIS_RIRMIS() uint32 {
	return volatile.LoadUint32(&o.UARTRIS.Reg) & 0x1
}

// UART0.UARTMIS: Masked Interrupt Status Register, UARTMIS
func (o *UART0_Type) SetUARTMIS_OEMIS(value uint32) {
	volatile.StoreUint32(&o.UARTMIS.Reg, volatile.LoadUint32(&o.UARTMIS.Reg)&^(0x400)|value<<10)
}
func (o *UART0_Type) GetUARTMIS_OEMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTMIS.Reg) & 0x400) >> 10
}
func (o *UART0_Type) SetUARTMIS_BEMIS(value uint32) {
	volatile.StoreUint32(&o.UARTMIS.Reg, volatile.LoadUint32(&o.UARTMIS.Reg)&^(0x200)|value<<9)
}
func (o *UART0_Type) GetUARTMIS_BEMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTMIS.Reg) & 0x200) >> 9
}
func (o *UART0_Type) SetUARTMIS_PEMIS(value uint32) {
	volatile.StoreUint32(&o.UARTMIS.Reg, volatile.LoadUint32(&o.UARTMIS.Reg)&^(0x100)|value<<8)
}
func (o *UART0_Type) GetUARTMIS_PEMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTMIS.Reg) & 0x100) >> 8
}
func (o *UART0_Type) SetUARTMIS_FEMIS(value uint32) {
	volatile.StoreUint32(&o.UARTMIS.Reg, volatile.LoadUint32(&o.UARTMIS.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetUARTMIS_FEMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTMIS.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetUARTMIS_RTMIS(value uint32) {
	volatile.StoreUint32(&o.UARTMIS.Reg, volatile.LoadUint32(&o.UARTMIS.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetUARTMIS_RTMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTMIS.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetUARTMIS_TXMIS(value uint32) {
	volatile.StoreUint32(&o.UARTMIS.Reg, volatile.LoadUint32(&o.UARTMIS.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetUARTMIS_TXMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTMIS.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetUARTMIS_RXMIS(value uint32) {
	volatile.StoreUint32(&o.UARTMIS.Reg, volatile.LoadUint32(&o.UARTMIS.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetUARTMIS_RXMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTMIS.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetUARTMIS_DSRMMIS(value uint32) {
	volatile.StoreUint32(&o.UARTMIS.Reg, volatile.LoadUint32(&o.UARTMIS.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetUARTMIS_DSRMMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTMIS.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetUARTMIS_DCDMMIS(value uint32) {
	volatile.StoreUint32(&o.UARTMIS.Reg, volatile.LoadUint32(&o.UARTMIS.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetUARTMIS_DCDMMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTMIS.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetUARTMIS_CTSMMIS(value uint32) {
	volatile.StoreUint32(&o.UARTMIS.Reg, volatile.LoadUint32(&o.UARTMIS.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetUARTMIS_CTSMMIS() uint32 {
	return (volatile.LoadUint32(&o.UARTMIS.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetUARTMIS_RIMMIS(value uint32) {
	volatile.StoreUint32(&o.UARTMIS.Reg, volatile.LoadUint32(&o.UARTMIS.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetUARTMIS_RIMMIS() uint32 {
	return volatile.LoadUint32(&o.UARTMIS.Reg) & 0x1
}

// UART0.UARTICR: Interrupt Clear Register, UARTICR
func (o *UART0_Type) SetUARTICR_OEIC(value uint32) {
	volatile.StoreUint32(&o.UARTICR.Reg, volatile.LoadUint32(&o.UARTICR.Reg)&^(0x400)|value<<10)
}
func (o *UART0_Type) GetUARTICR_OEIC() uint32 {
	return (volatile.LoadUint32(&o.UARTICR.Reg) & 0x400) >> 10
}
func (o *UART0_Type) SetUARTICR_BEIC(value uint32) {
	volatile.StoreUint32(&o.UARTICR.Reg, volatile.LoadUint32(&o.UARTICR.Reg)&^(0x200)|value<<9)
}
func (o *UART0_Type) GetUARTICR_BEIC() uint32 {
	return (volatile.LoadUint32(&o.UARTICR.Reg) & 0x200) >> 9
}
func (o *UART0_Type) SetUARTICR_PEIC(value uint32) {
	volatile.StoreUint32(&o.UARTICR.Reg, volatile.LoadUint32(&o.UARTICR.Reg)&^(0x100)|value<<8)
}
func (o *UART0_Type) GetUARTICR_PEIC() uint32 {
	return (volatile.LoadUint32(&o.UARTICR.Reg) & 0x100) >> 8
}
func (o *UART0_Type) SetUARTICR_FEIC(value uint32) {
	volatile.StoreUint32(&o.UARTICR.Reg, volatile.LoadUint32(&o.UARTICR.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetUARTICR_FEIC() uint32 {
	return (volatile.LoadUint32(&o.UARTICR.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetUARTICR_RTIC(value uint32) {
	volatile.StoreUint32(&o.UARTICR.Reg, volatile.LoadUint32(&o.UARTICR.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetUARTICR_RTIC() uint32 {
	return (volatile.LoadUint32(&o.UARTICR.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetUARTICR_TXIC(value uint32) {
	volatile.StoreUint32(&o.UARTICR.Reg, volatile.LoadUint32(&o.UARTICR.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetUARTICR_TXIC() uint32 {
	return (volatile.LoadUint32(&o.UARTICR.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetUARTICR_RXIC(value uint32) {
	volatile.StoreUint32(&o.UARTICR.Reg, volatile.LoadUint32(&o.UARTICR.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetUARTICR_RXIC() uint32 {
	return (volatile.LoadUint32(&o.UARTICR.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetUARTICR_DSRMIC(value uint32) {
	volatile.StoreUint32(&o.UARTICR.Reg, volatile.LoadUint32(&o.UARTICR.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetUARTICR_DSRMIC() uint32 {
	return (volatile.LoadUint32(&o.UARTICR.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetUARTICR_DCDMIC(value uint32) {
	volatile.StoreUint32(&o.UARTICR.Reg, volatile.LoadUint32(&o.UARTICR.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetUARTICR_DCDMIC() uint32 {
	return (volatile.LoadUint32(&o.UARTICR.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetUARTICR_CTSMIC(value uint32) {
	volatile.StoreUint32(&o.UARTICR.Reg, volatile.LoadUint32(&o.UARTICR.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetUARTICR_CTSMIC() uint32 {
	return (volatile.LoadUint32(&o.UARTICR.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetUARTICR_RIMIC(value uint32) {
	volatile.StoreUint32(&o.UARTICR.Reg, volatile.LoadUint32(&o.UARTICR.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetUARTICR_RIMIC() uint32 {
	return volatile.LoadUint32(&o.UARTICR.Reg) & 0x1
}

// UART0.UARTDMACR: DMA Control Register, UARTDMACR
func (o *UART0_Type) SetUARTDMACR_DMAONERR(value uint32) {
	volatile.StoreUint32(&o.UARTDMACR.Reg, volatile.LoadUint32(&o.UARTDMACR.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetUARTDMACR_DMAONERR() uint32 {
	return (volatile.LoadUint32(&o.UARTDMACR.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetUARTDMACR_TXDMAE(value uint32) {
	volatile.StoreUint32(&o.UARTDMACR.Reg, volatile.LoadUint32(&o.UARTDMACR.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetUARTDMACR_TXDMAE() uint32 {
	return (volatile.LoadUint32(&o.UARTDMACR.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetUARTDMACR_RXDMAE(value uint32) {
	volatile.StoreUint32(&o.UARTDMACR.Reg, volatile.LoadUint32(&o.UARTDMACR.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetUARTDMACR_RXDMAE() uint32 {
	return volatile.LoadUint32(&o.UARTDMACR.Reg) & 0x1
}

// UART0.UARTPERIPHID0: UARTPeriphID0 Register
func (o *UART0_Type) SetUARTPERIPHID0_PARTNUMBER0(value uint32) {
	volatile.StoreUint32(&o.UARTPERIPHID0.Reg, volatile.LoadUint32(&o.UARTPERIPHID0.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetUARTPERIPHID0_PARTNUMBER0() uint32 {
	return volatile.LoadUint32(&o.UARTPERIPHID0.Reg) & 0xff
}

// UART0.UARTPERIPHID1: UARTPeriphID1 Register
func (o *UART0_Type) SetUARTPERIPHID1_DESIGNER0(value uint32) {
	volatile.StoreUint32(&o.UARTPERIPHID1.Reg, volatile.LoadUint32(&o.UARTPERIPHID1.Reg)&^(0xf0)|value<<4)
}
func (o *UART0_Type) GetUARTPERIPHID1_DESIGNER0() uint32 {
	return (volatile.LoadUint32(&o.UARTPERIPHID1.Reg) & 0xf0) >> 4
}
func (o *UART0_Type) SetUARTPERIPHID1_PARTNUMBER1(value uint32) {
	volatile.StoreUint32(&o.UARTPERIPHID1.Reg, volatile.LoadUint32(&o.UARTPERIPHID1.Reg)&^(0xf)|value)
}
func (o *UART0_Type) GetUARTPERIPHID1_PARTNUMBER1() uint32 {
	return volatile.LoadUint32(&o.UARTPERIPHID1.Reg) & 0xf
}

// UART0.UARTPERIPHID2: UARTPeriphID2 Register
func (o *UART0_Type) SetUARTPERIPHID2_REVISION(value uint32) {
	volatile.StoreUint32(&o.UARTPERIPHID2.Reg, volatile.LoadUint32(&o.UARTPERIPHID2.Reg)&^(0xf0)|value<<4)
}
func (o *UART0_Type) GetUARTPERIPHID2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.UARTPERIPHID2.Reg) & 0xf0) >> 4
}
func (o *UART0_Type) SetUARTPERIPHID2_DESIGNER1(value uint32) {
	volatile.StoreUint32(&o.UARTPERIPHID2.Reg, volatile.LoadUint32(&o.UARTPERIPHID2.Reg)&^(0xf)|value)
}
func (o *UART0_Type) GetUARTPERIPHID2_DESIGNER1() uint32 {
	return volatile.LoadUint32(&o.UARTPERIPHID2.Reg) & 0xf
}

// UART0.UARTPERIPHID3: UARTPeriphID3 Register
func (o *UART0_Type) SetUARTPERIPHID3_CONFIGURATION(value uint32) {
	volatile.StoreUint32(&o.UARTPERIPHID3.Reg, volatile.LoadUint32(&o.UARTPERIPHID3.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetUARTPERIPHID3_CONFIGURATION() uint32 {
	return volatile.LoadUint32(&o.UARTPERIPHID3.Reg) & 0xff
}

// UART0.UARTPCELLID0: UARTPCellID0 Register
func (o *UART0_Type) SetUARTPCELLID0(value uint32) {
	volatile.StoreUint32(&o.UARTPCELLID0.Reg, volatile.LoadUint32(&o.UARTPCELLID0.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetUARTPCELLID0() uint32 {
	return volatile.LoadUint32(&o.UARTPCELLID0.Reg) & 0xff
}

// UART0.UARTPCELLID1: UARTPCellID1 Register
func (o *UART0_Type) SetUARTPCELLID1(value uint32) {
	volatile.StoreUint32(&o.UARTPCELLID1.Reg, volatile.LoadUint32(&o.UARTPCELLID1.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetUARTPCELLID1() uint32 {
	return volatile.LoadUint32(&o.UARTPCELLID1.Reg) & 0xff
}

// UART0.UARTPCELLID2: UARTPCellID2 Register
func (o *UART0_Type) SetUARTPCELLID2(value uint32) {
	volatile.StoreUint32(&o.UARTPCELLID2.Reg, volatile.LoadUint32(&o.UARTPCELLID2.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetUARTPCELLID2() uint32 {
	return volatile.LoadUint32(&o.UARTPCELLID2.Reg) & 0xff
}

// UART0.UARTPCELLID3: UARTPCellID3 Register
func (o *UART0_Type) SetUARTPCELLID3(value uint32) {
	volatile.StoreUint32(&o.UARTPCELLID3.Reg, volatile.LoadUint32(&o.UARTPCELLID3.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetUARTPCELLID3() uint32 {
	return volatile.LoadUint32(&o.UARTPCELLID3.Reg) & 0xff
}

type SPI0_Type struct {
	SSPCR0       volatile.Register32 // 0x0
	SSPCR1       volatile.Register32 // 0x4
	SSPDR        volatile.Register32 // 0x8
	SSPSR        volatile.Register32 // 0xC
	SSPCPSR      volatile.Register32 // 0x10
	SSPIMSC      volatile.Register32 // 0x14
	SSPRIS       volatile.Register32 // 0x18
	SSPMIS       volatile.Register32 // 0x1C
	SSPICR       volatile.Register32 // 0x20
	SSPDMACR     volatile.Register32 // 0x24
	_            [4024]byte
	SSPPERIPHID0 volatile.Register32 // 0xFE0
	SSPPERIPHID1 volatile.Register32 // 0xFE4
	SSPPERIPHID2 volatile.Register32 // 0xFE8
	SSPPERIPHID3 volatile.Register32 // 0xFEC
	SSPPCELLID0  volatile.Register32 // 0xFF0
	SSPPCELLID1  volatile.Register32 // 0xFF4
	SSPPCELLID2  volatile.Register32 // 0xFF8
	SSPPCELLID3  volatile.Register32 // 0xFFC
}

// SPI0.SSPCR0: Control register 0, SSPCR0 on page 3-4
func (o *SPI0_Type) SetSSPCR0_SCR(value uint32) {
	volatile.StoreUint32(&o.SSPCR0.Reg, volatile.LoadUint32(&o.SSPCR0.Reg)&^(0xff00)|value<<8)
}
func (o *SPI0_Type) GetSSPCR0_SCR() uint32 {
	return (volatile.LoadUint32(&o.SSPCR0.Reg) & 0xff00) >> 8
}
func (o *SPI0_Type) SetSSPCR0_SPH(value uint32) {
	volatile.StoreUint32(&o.SSPCR0.Reg, volatile.LoadUint32(&o.SSPCR0.Reg)&^(0x80)|value<<7)
}
func (o *SPI0_Type) GetSSPCR0_SPH() uint32 {
	return (volatile.LoadUint32(&o.SSPCR0.Reg) & 0x80) >> 7
}
func (o *SPI0_Type) SetSSPCR0_SPO(value uint32) {
	volatile.StoreUint32(&o.SSPCR0.Reg, volatile.LoadUint32(&o.SSPCR0.Reg)&^(0x40)|value<<6)
}
func (o *SPI0_Type) GetSSPCR0_SPO() uint32 {
	return (volatile.LoadUint32(&o.SSPCR0.Reg) & 0x40) >> 6
}
func (o *SPI0_Type) SetSSPCR0_FRF(value uint32) {
	volatile.StoreUint32(&o.SSPCR0.Reg, volatile.LoadUint32(&o.SSPCR0.Reg)&^(0x30)|value<<4)
}
func (o *SPI0_Type) GetSSPCR0_FRF() uint32 {
	return (volatile.LoadUint32(&o.SSPCR0.Reg) & 0x30) >> 4
}
func (o *SPI0_Type) SetSSPCR0_DSS(value uint32) {
	volatile.StoreUint32(&o.SSPCR0.Reg, volatile.LoadUint32(&o.SSPCR0.Reg)&^(0xf)|value)
}
func (o *SPI0_Type) GetSSPCR0_DSS() uint32 {
	return volatile.LoadUint32(&o.SSPCR0.Reg) & 0xf
}

// SPI0.SSPCR1: Control register 1, SSPCR1 on page 3-5
func (o *SPI0_Type) SetSSPCR1_SOD(value uint32) {
	volatile.StoreUint32(&o.SSPCR1.Reg, volatile.LoadUint32(&o.SSPCR1.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSSPCR1_SOD() uint32 {
	return (volatile.LoadUint32(&o.SSPCR1.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSSPCR1_MS(value uint32) {
	volatile.StoreUint32(&o.SSPCR1.Reg, volatile.LoadUint32(&o.SSPCR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSSPCR1_MS() uint32 {
	return (volatile.LoadUint32(&o.SSPCR1.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSSPCR1_SSE(value uint32) {
	volatile.StoreUint32(&o.SSPCR1.Reg, volatile.LoadUint32(&o.SSPCR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSSPCR1_SSE() uint32 {
	return (volatile.LoadUint32(&o.SSPCR1.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSSPCR1_LBM(value uint32) {
	volatile.StoreUint32(&o.SSPCR1.Reg, volatile.LoadUint32(&o.SSPCR1.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSSPCR1_LBM() uint32 {
	return volatile.LoadUint32(&o.SSPCR1.Reg) & 0x1
}

// SPI0.SSPDR: Data register, SSPDR on page 3-6
func (o *SPI0_Type) SetSSPDR_DATA(value uint32) {
	volatile.StoreUint32(&o.SSPDR.Reg, volatile.LoadUint32(&o.SSPDR.Reg)&^(0xffff)|value)
}
func (o *SPI0_Type) GetSSPDR_DATA() uint32 {
	return volatile.LoadUint32(&o.SSPDR.Reg) & 0xffff
}

// SPI0.SSPSR: Status register, SSPSR on page 3-7
func (o *SPI0_Type) SetSSPSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SSPSR.Reg, volatile.LoadUint32(&o.SSPSR.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSSPSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SSPSR.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetSSPSR_RFF(value uint32) {
	volatile.StoreUint32(&o.SSPSR.Reg, volatile.LoadUint32(&o.SSPSR.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSSPSR_RFF() uint32 {
	return (volatile.LoadUint32(&o.SSPSR.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSSPSR_RNE(value uint32) {
	volatile.StoreUint32(&o.SSPSR.Reg, volatile.LoadUint32(&o.SSPSR.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSSPSR_RNE() uint32 {
	return (volatile.LoadUint32(&o.SSPSR.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSSPSR_TNF(value uint32) {
	volatile.StoreUint32(&o.SSPSR.Reg, volatile.LoadUint32(&o.SSPSR.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSSPSR_TNF() uint32 {
	return (volatile.LoadUint32(&o.SSPSR.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSSPSR_TFE(value uint32) {
	volatile.StoreUint32(&o.SSPSR.Reg, volatile.LoadUint32(&o.SSPSR.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSSPSR_TFE() uint32 {
	return volatile.LoadUint32(&o.SSPSR.Reg) & 0x1
}

// SPI0.SSPCPSR: Clock prescale register, SSPCPSR on page 3-8
func (o *SPI0_Type) SetSSPCPSR_CPSDVSR(value uint32) {
	volatile.StoreUint32(&o.SSPCPSR.Reg, volatile.LoadUint32(&o.SSPCPSR.Reg)&^(0xff)|value)
}
func (o *SPI0_Type) GetSSPCPSR_CPSDVSR() uint32 {
	return volatile.LoadUint32(&o.SSPCPSR.Reg) & 0xff
}

// SPI0.SSPIMSC: Interrupt mask set or clear register, SSPIMSC on page 3-9
func (o *SPI0_Type) SetSSPIMSC_TXIM(value uint32) {
	volatile.StoreUint32(&o.SSPIMSC.Reg, volatile.LoadUint32(&o.SSPIMSC.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSSPIMSC_TXIM() uint32 {
	return (volatile.LoadUint32(&o.SSPIMSC.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSSPIMSC_RXIM(value uint32) {
	volatile.StoreUint32(&o.SSPIMSC.Reg, volatile.LoadUint32(&o.SSPIMSC.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSSPIMSC_RXIM() uint32 {
	return (volatile.LoadUint32(&o.SSPIMSC.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSSPIMSC_RTIM(value uint32) {
	volatile.StoreUint32(&o.SSPIMSC.Reg, volatile.LoadUint32(&o.SSPIMSC.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSSPIMSC_RTIM() uint32 {
	return (volatile.LoadUint32(&o.SSPIMSC.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSSPIMSC_RORIM(value uint32) {
	volatile.StoreUint32(&o.SSPIMSC.Reg, volatile.LoadUint32(&o.SSPIMSC.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSSPIMSC_RORIM() uint32 {
	return volatile.LoadUint32(&o.SSPIMSC.Reg) & 0x1
}

// SPI0.SSPRIS: Raw interrupt status register, SSPRIS on page 3-10
func (o *SPI0_Type) SetSSPRIS_TXRIS(value uint32) {
	volatile.StoreUint32(&o.SSPRIS.Reg, volatile.LoadUint32(&o.SSPRIS.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSSPRIS_TXRIS() uint32 {
	return (volatile.LoadUint32(&o.SSPRIS.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSSPRIS_RXRIS(value uint32) {
	volatile.StoreUint32(&o.SSPRIS.Reg, volatile.LoadUint32(&o.SSPRIS.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSSPRIS_RXRIS() uint32 {
	return (volatile.LoadUint32(&o.SSPRIS.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSSPRIS_RTRIS(value uint32) {
	volatile.StoreUint32(&o.SSPRIS.Reg, volatile.LoadUint32(&o.SSPRIS.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSSPRIS_RTRIS() uint32 {
	return (volatile.LoadUint32(&o.SSPRIS.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSSPRIS_RORRIS(value uint32) {
	volatile.StoreUint32(&o.SSPRIS.Reg, volatile.LoadUint32(&o.SSPRIS.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSSPRIS_RORRIS() uint32 {
	return volatile.LoadUint32(&o.SSPRIS.Reg) & 0x1
}

// SPI0.SSPMIS: Masked interrupt status register, SSPMIS on page 3-11
func (o *SPI0_Type) SetSSPMIS_TXMIS(value uint32) {
	volatile.StoreUint32(&o.SSPMIS.Reg, volatile.LoadUint32(&o.SSPMIS.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSSPMIS_TXMIS() uint32 {
	return (volatile.LoadUint32(&o.SSPMIS.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSSPMIS_RXMIS(value uint32) {
	volatile.StoreUint32(&o.SSPMIS.Reg, volatile.LoadUint32(&o.SSPMIS.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSSPMIS_RXMIS() uint32 {
	return (volatile.LoadUint32(&o.SSPMIS.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSSPMIS_RTMIS(value uint32) {
	volatile.StoreUint32(&o.SSPMIS.Reg, volatile.LoadUint32(&o.SSPMIS.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSSPMIS_RTMIS() uint32 {
	return (volatile.LoadUint32(&o.SSPMIS.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSSPMIS_RORMIS(value uint32) {
	volatile.StoreUint32(&o.SSPMIS.Reg, volatile.LoadUint32(&o.SSPMIS.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSSPMIS_RORMIS() uint32 {
	return volatile.LoadUint32(&o.SSPMIS.Reg) & 0x1
}

// SPI0.SSPICR: Interrupt clear register, SSPICR on page 3-11
func (o *SPI0_Type) SetSSPICR_RTIC(value uint32) {
	volatile.StoreUint32(&o.SSPICR.Reg, volatile.LoadUint32(&o.SSPICR.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSSPICR_RTIC() uint32 {
	return (volatile.LoadUint32(&o.SSPICR.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSSPICR_RORIC(value uint32) {
	volatile.StoreUint32(&o.SSPICR.Reg, volatile.LoadUint32(&o.SSPICR.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSSPICR_RORIC() uint32 {
	return volatile.LoadUint32(&o.SSPICR.Reg) & 0x1
}

// SPI0.SSPDMACR: DMA control register, SSPDMACR on page 3-12
func (o *SPI0_Type) SetSSPDMACR_TXDMAE(value uint32) {
	volatile.StoreUint32(&o.SSPDMACR.Reg, volatile.LoadUint32(&o.SSPDMACR.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSSPDMACR_TXDMAE() uint32 {
	return (volatile.LoadUint32(&o.SSPDMACR.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSSPDMACR_RXDMAE(value uint32) {
	volatile.StoreUint32(&o.SSPDMACR.Reg, volatile.LoadUint32(&o.SSPDMACR.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSSPDMACR_RXDMAE() uint32 {
	return volatile.LoadUint32(&o.SSPDMACR.Reg) & 0x1
}

// SPI0.SSPPERIPHID0: Peripheral identification registers, SSPPeriphID0-3 on page 3-13
func (o *SPI0_Type) SetSSPPERIPHID0_PARTNUMBER0(value uint32) {
	volatile.StoreUint32(&o.SSPPERIPHID0.Reg, volatile.LoadUint32(&o.SSPPERIPHID0.Reg)&^(0xff)|value)
}
func (o *SPI0_Type) GetSSPPERIPHID0_PARTNUMBER0() uint32 {
	return volatile.LoadUint32(&o.SSPPERIPHID0.Reg) & 0xff
}

// SPI0.SSPPERIPHID1: Peripheral identification registers, SSPPeriphID0-3 on page 3-13
func (o *SPI0_Type) SetSSPPERIPHID1_DESIGNER0(value uint32) {
	volatile.StoreUint32(&o.SSPPERIPHID1.Reg, volatile.LoadUint32(&o.SSPPERIPHID1.Reg)&^(0xf0)|value<<4)
}
func (o *SPI0_Type) GetSSPPERIPHID1_DESIGNER0() uint32 {
	return (volatile.LoadUint32(&o.SSPPERIPHID1.Reg) & 0xf0) >> 4
}
func (o *SPI0_Type) SetSSPPERIPHID1_PARTNUMBER1(value uint32) {
	volatile.StoreUint32(&o.SSPPERIPHID1.Reg, volatile.LoadUint32(&o.SSPPERIPHID1.Reg)&^(0xf)|value)
}
func (o *SPI0_Type) GetSSPPERIPHID1_PARTNUMBER1() uint32 {
	return volatile.LoadUint32(&o.SSPPERIPHID1.Reg) & 0xf
}

// SPI0.SSPPERIPHID2: Peripheral identification registers, SSPPeriphID0-3 on page 3-13
func (o *SPI0_Type) SetSSPPERIPHID2_REVISION(value uint32) {
	volatile.StoreUint32(&o.SSPPERIPHID2.Reg, volatile.LoadUint32(&o.SSPPERIPHID2.Reg)&^(0xf0)|value<<4)
}
func (o *SPI0_Type) GetSSPPERIPHID2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.SSPPERIPHID2.Reg) & 0xf0) >> 4
}
func (o *SPI0_Type) SetSSPPERIPHID2_DESIGNER1(value uint32) {
	volatile.StoreUint32(&o.SSPPERIPHID2.Reg, volatile.LoadUint32(&o.SSPPERIPHID2.Reg)&^(0xf)|value)
}
func (o *SPI0_Type) GetSSPPERIPHID2_DESIGNER1() uint32 {
	return volatile.LoadUint32(&o.SSPPERIPHID2.Reg) & 0xf
}

// SPI0.SSPPERIPHID3: Peripheral identification registers, SSPPeriphID0-3 on page 3-13
func (o *SPI0_Type) SetSSPPERIPHID3_CONFIGURATION(value uint32) {
	volatile.StoreUint32(&o.SSPPERIPHID3.Reg, volatile.LoadUint32(&o.SSPPERIPHID3.Reg)&^(0xff)|value)
}
func (o *SPI0_Type) GetSSPPERIPHID3_CONFIGURATION() uint32 {
	return volatile.LoadUint32(&o.SSPPERIPHID3.Reg) & 0xff
}

// SPI0.SSPPCELLID0: PrimeCell identification registers, SSPPCellID0-3 on page 3-16
func (o *SPI0_Type) SetSSPPCELLID0(value uint32) {
	volatile.StoreUint32(&o.SSPPCELLID0.Reg, volatile.LoadUint32(&o.SSPPCELLID0.Reg)&^(0xff)|value)
}
func (o *SPI0_Type) GetSSPPCELLID0() uint32 {
	return volatile.LoadUint32(&o.SSPPCELLID0.Reg) & 0xff
}

// SPI0.SSPPCELLID1: PrimeCell identification registers, SSPPCellID0-3 on page 3-16
func (o *SPI0_Type) SetSSPPCELLID1(value uint32) {
	volatile.StoreUint32(&o.SSPPCELLID1.Reg, volatile.LoadUint32(&o.SSPPCELLID1.Reg)&^(0xff)|value)
}
func (o *SPI0_Type) GetSSPPCELLID1() uint32 {
	return volatile.LoadUint32(&o.SSPPCELLID1.Reg) & 0xff
}

// SPI0.SSPPCELLID2: PrimeCell identification registers, SSPPCellID0-3 on page 3-16
func (o *SPI0_Type) SetSSPPCELLID2(value uint32) {
	volatile.StoreUint32(&o.SSPPCELLID2.Reg, volatile.LoadUint32(&o.SSPPCELLID2.Reg)&^(0xff)|value)
}
func (o *SPI0_Type) GetSSPPCELLID2() uint32 {
	return volatile.LoadUint32(&o.SSPPCELLID2.Reg) & 0xff
}

// SPI0.SSPPCELLID3: PrimeCell identification registers, SSPPCellID0-3 on page 3-16
func (o *SPI0_Type) SetSSPPCELLID3(value uint32) {
	volatile.StoreUint32(&o.SSPPCELLID3.Reg, volatile.LoadUint32(&o.SSPPCELLID3.Reg)&^(0xff)|value)
}
func (o *SPI0_Type) GetSSPPCELLID3() uint32 {
	return volatile.LoadUint32(&o.SSPPCELLID3.Reg) & 0xff
}

// DW_apb_i2c address block
type I2C0_Type struct {
	IC_CON                volatile.Register32 // 0x0
	IC_TAR                volatile.Register32 // 0x4
	IC_SAR                volatile.Register32 // 0x8
	_                     [4]byte
	IC_DATA_CMD           volatile.Register32 // 0x10
	IC_SS_SCL_HCNT        volatile.Register32 // 0x14
	IC_SS_SCL_LCNT        volatile.Register32 // 0x18
	IC_FS_SCL_HCNT        volatile.Register32 // 0x1C
	IC_FS_SCL_LCNT        volatile.Register32 // 0x20
	_                     [8]byte
	IC_INTR_STAT          volatile.Register32 // 0x2C
	IC_INTR_MASK          volatile.Register32 // 0x30
	IC_RAW_INTR_STAT      volatile.Register32 // 0x34
	IC_RX_TL              volatile.Register32 // 0x38
	IC_TX_TL              volatile.Register32 // 0x3C
	IC_CLR_INTR           volatile.Register32 // 0x40
	IC_CLR_RX_UNDER       volatile.Register32 // 0x44
	IC_CLR_RX_OVER        volatile.Register32 // 0x48
	IC_CLR_TX_OVER        volatile.Register32 // 0x4C
	IC_CLR_RD_REQ         volatile.Register32 // 0x50
	IC_CLR_TX_ABRT        volatile.Register32 // 0x54
	IC_CLR_RX_DONE        volatile.Register32 // 0x58
	IC_CLR_ACTIVITY       volatile.Register32 // 0x5C
	IC_CLR_STOP_DET       volatile.Register32 // 0x60
	IC_CLR_START_DET      volatile.Register32 // 0x64
	IC_CLR_GEN_CALL       volatile.Register32 // 0x68
	IC_ENABLE             volatile.Register32 // 0x6C
	IC_STATUS             volatile.Register32 // 0x70
	IC_TXFLR              volatile.Register32 // 0x74
	IC_RXFLR              volatile.Register32 // 0x78
	IC_SDA_HOLD           volatile.Register32 // 0x7C
	IC_TX_ABRT_SOURCE     volatile.Register32 // 0x80
	IC_SLV_DATA_NACK_ONLY volatile.Register32 // 0x84
	IC_DMA_CR             volatile.Register32 // 0x88
	IC_DMA_TDLR           volatile.Register32 // 0x8C
	IC_DMA_RDLR           volatile.Register32 // 0x90
	IC_SDA_SETUP          volatile.Register32 // 0x94
	IC_ACK_GENERAL_CALL   volatile.Register32 // 0x98
	IC_ENABLE_STATUS      volatile.Register32 // 0x9C
	IC_FS_SPKLEN          volatile.Register32 // 0xA0
	_                     [4]byte
	IC_CLR_RESTART_DET    volatile.Register32 // 0xA8
	_                     [72]byte
	IC_COMP_PARAM_1       volatile.Register32 // 0xF4
	IC_COMP_VERSION       volatile.Register32 // 0xF8
	IC_COMP_TYPE          volatile.Register32 // 0xFC
}

// I2C0.IC_CON
// I2C Control Register. This register can be written only when the DW_apb_i2c is disabled, which corresponds to the IC_ENABLE[0] register being set to 0. Writes at other times have no effect.\n
// Read/Write Access: - bit 10 is read only. - bit 11 is read only - bit 16 is read only - bit 17 is read only - bits 18 and 19 are read only.
func (o *I2C0_Type) SetIC_CON_STOP_DET_IF_MASTER_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.IC_CON.Reg, volatile.LoadUint32(&o.IC_CON.Reg)&^(0x400)|value<<10)
}
func (o *I2C0_Type) GetIC_CON_STOP_DET_IF_MASTER_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.IC_CON.Reg) & 0x400) >> 10
}
func (o *I2C0_Type) SetIC_CON_RX_FIFO_FULL_HLD_CTRL(value uint32) {
	volatile.StoreUint32(&o.IC_CON.Reg, volatile.LoadUint32(&o.IC_CON.Reg)&^(0x200)|value<<9)
}
func (o *I2C0_Type) GetIC_CON_RX_FIFO_FULL_HLD_CTRL() uint32 {
	return (volatile.LoadUint32(&o.IC_CON.Reg) & 0x200) >> 9
}
func (o *I2C0_Type) SetIC_CON_TX_EMPTY_CTRL(value uint32) {
	volatile.StoreUint32(&o.IC_CON.Reg, volatile.LoadUint32(&o.IC_CON.Reg)&^(0x100)|value<<8)
}
func (o *I2C0_Type) GetIC_CON_TX_EMPTY_CTRL() uint32 {
	return (volatile.LoadUint32(&o.IC_CON.Reg) & 0x100) >> 8
}
func (o *I2C0_Type) SetIC_CON_STOP_DET_IFADDRESSED(value uint32) {
	volatile.StoreUint32(&o.IC_CON.Reg, volatile.LoadUint32(&o.IC_CON.Reg)&^(0x80)|value<<7)
}
func (o *I2C0_Type) GetIC_CON_STOP_DET_IFADDRESSED() uint32 {
	return (volatile.LoadUint32(&o.IC_CON.Reg) & 0x80) >> 7
}
func (o *I2C0_Type) SetIC_CON_IC_SLAVE_DISABLE(value uint32) {
	volatile.StoreUint32(&o.IC_CON.Reg, volatile.LoadUint32(&o.IC_CON.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetIC_CON_IC_SLAVE_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.IC_CON.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetIC_CON_IC_RESTART_EN(value uint32) {
	volatile.StoreUint32(&o.IC_CON.Reg, volatile.LoadUint32(&o.IC_CON.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetIC_CON_IC_RESTART_EN() uint32 {
	return (volatile.LoadUint32(&o.IC_CON.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetIC_CON_IC_10BITADDR_MASTER(value uint32) {
	volatile.StoreUint32(&o.IC_CON.Reg, volatile.LoadUint32(&o.IC_CON.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetIC_CON_IC_10BITADDR_MASTER() uint32 {
	return (volatile.LoadUint32(&o.IC_CON.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetIC_CON_IC_10BITADDR_SLAVE(value uint32) {
	volatile.StoreUint32(&o.IC_CON.Reg, volatile.LoadUint32(&o.IC_CON.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetIC_CON_IC_10BITADDR_SLAVE() uint32 {
	return (volatile.LoadUint32(&o.IC_CON.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetIC_CON_SPEED(value uint32) {
	volatile.StoreUint32(&o.IC_CON.Reg, volatile.LoadUint32(&o.IC_CON.Reg)&^(0x6)|value<<1)
}
func (o *I2C0_Type) GetIC_CON_SPEED() uint32 {
	return (volatile.LoadUint32(&o.IC_CON.Reg) & 0x6) >> 1
}
func (o *I2C0_Type) SetIC_CON_MASTER_MODE(value uint32) {
	volatile.StoreUint32(&o.IC_CON.Reg, volatile.LoadUint32(&o.IC_CON.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CON_MASTER_MODE() uint32 {
	return volatile.LoadUint32(&o.IC_CON.Reg) & 0x1
}

// I2C0.IC_TAR
// I2C Target Address Register\n
// This register is 12 bits wide, and bits 31:12 are reserved. This register can be written to only when IC_ENABLE[0] is set to 0.\n
// Note: If the software or application is aware that the DW_apb_i2c is not using the TAR address for the pending commands in the Tx FIFO, then it is possible to update the TAR address even while the Tx FIFO has entries (IC_STATUS[2]= 0). - It is not necessary to perform any write to this register if DW_apb_i2c is enabled as an I2C slave only.
func (o *I2C0_Type) SetIC_TAR_SPECIAL(value uint32) {
	volatile.StoreUint32(&o.IC_TAR.Reg, volatile.LoadUint32(&o.IC_TAR.Reg)&^(0x800)|value<<11)
}
func (o *I2C0_Type) GetIC_TAR_SPECIAL() uint32 {
	return (volatile.LoadUint32(&o.IC_TAR.Reg) & 0x800) >> 11
}
func (o *I2C0_Type) SetIC_TAR_GC_OR_START(value uint32) {
	volatile.StoreUint32(&o.IC_TAR.Reg, volatile.LoadUint32(&o.IC_TAR.Reg)&^(0x400)|value<<10)
}
func (o *I2C0_Type) GetIC_TAR_GC_OR_START() uint32 {
	return (volatile.LoadUint32(&o.IC_TAR.Reg) & 0x400) >> 10
}
func (o *I2C0_Type) SetIC_TAR(value uint32) {
	volatile.StoreUint32(&o.IC_TAR.Reg, volatile.LoadUint32(&o.IC_TAR.Reg)&^(0x3ff)|value)
}
func (o *I2C0_Type) GetIC_TAR() uint32 {
	return volatile.LoadUint32(&o.IC_TAR.Reg) & 0x3ff
}

// I2C0.IC_SAR: I2C Slave Address Register
func (o *I2C0_Type) SetIC_SAR(value uint32) {
	volatile.StoreUint32(&o.IC_SAR.Reg, volatile.LoadUint32(&o.IC_SAR.Reg)&^(0x3ff)|value)
}
func (o *I2C0_Type) GetIC_SAR() uint32 {
	return volatile.LoadUint32(&o.IC_SAR.Reg) & 0x3ff
}

// I2C0.IC_DATA_CMD
// I2C Rx/Tx Data Buffer and Command Register; this is the register the CPU writes to when filling the TX FIFO and the CPU reads from when retrieving bytes from RX FIFO.\n
// The size of the register changes as follows:\n
// Write: - 11 bits when IC_EMPTYFIFO_HOLD_MASTER_EN=1 - 9 bits when IC_EMPTYFIFO_HOLD_MASTER_EN=0 Read: - 12 bits when IC_FIRST_DATA_BYTE_STATUS = 1 - 8 bits when IC_FIRST_DATA_BYTE_STATUS = 0 Note: In order for the DW_apb_i2c to continue acknowledging reads, a read command should be written for every byte that is to be received; otherwise the DW_apb_i2c will stop acknowledging.
func (o *I2C0_Type) SetIC_DATA_CMD_FIRST_DATA_BYTE(value uint32) {
	volatile.StoreUint32(&o.IC_DATA_CMD.Reg, volatile.LoadUint32(&o.IC_DATA_CMD.Reg)&^(0x800)|value<<11)
}
func (o *I2C0_Type) GetIC_DATA_CMD_FIRST_DATA_BYTE() uint32 {
	return (volatile.LoadUint32(&o.IC_DATA_CMD.Reg) & 0x800) >> 11
}
func (o *I2C0_Type) SetIC_DATA_CMD_RESTART(value uint32) {
	volatile.StoreUint32(&o.IC_DATA_CMD.Reg, volatile.LoadUint32(&o.IC_DATA_CMD.Reg)&^(0x400)|value<<10)
}
func (o *I2C0_Type) GetIC_DATA_CMD_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IC_DATA_CMD.Reg) & 0x400) >> 10
}
func (o *I2C0_Type) SetIC_DATA_CMD_STOP(value uint32) {
	volatile.StoreUint32(&o.IC_DATA_CMD.Reg, volatile.LoadUint32(&o.IC_DATA_CMD.Reg)&^(0x200)|value<<9)
}
func (o *I2C0_Type) GetIC_DATA_CMD_STOP() uint32 {
	return (volatile.LoadUint32(&o.IC_DATA_CMD.Reg) & 0x200) >> 9
}
func (o *I2C0_Type) SetIC_DATA_CMD_CMD(value uint32) {
	volatile.StoreUint32(&o.IC_DATA_CMD.Reg, volatile.LoadUint32(&o.IC_DATA_CMD.Reg)&^(0x100)|value<<8)
}
func (o *I2C0_Type) GetIC_DATA_CMD_CMD() uint32 {
	return (volatile.LoadUint32(&o.IC_DATA_CMD.Reg) & 0x100) >> 8
}
func (o *I2C0_Type) SetIC_DATA_CMD_DAT(value uint32) {
	volatile.StoreUint32(&o.IC_DATA_CMD.Reg, volatile.LoadUint32(&o.IC_DATA_CMD.Reg)&^(0xff)|value)
}
func (o *I2C0_Type) GetIC_DATA_CMD_DAT() uint32 {
	return volatile.LoadUint32(&o.IC_DATA_CMD.Reg) & 0xff
}

// I2C0.IC_SS_SCL_HCNT: Standard Speed I2C Clock SCL High Count Register
func (o *I2C0_Type) SetIC_SS_SCL_HCNT(value uint32) {
	volatile.StoreUint32(&o.IC_SS_SCL_HCNT.Reg, volatile.LoadUint32(&o.IC_SS_SCL_HCNT.Reg)&^(0xffff)|value)
}
func (o *I2C0_Type) GetIC_SS_SCL_HCNT() uint32 {
	return volatile.LoadUint32(&o.IC_SS_SCL_HCNT.Reg) & 0xffff
}

// I2C0.IC_SS_SCL_LCNT: Standard Speed I2C Clock SCL Low Count Register
func (o *I2C0_Type) SetIC_SS_SCL_LCNT(value uint32) {
	volatile.StoreUint32(&o.IC_SS_SCL_LCNT.Reg, volatile.LoadUint32(&o.IC_SS_SCL_LCNT.Reg)&^(0xffff)|value)
}
func (o *I2C0_Type) GetIC_SS_SCL_LCNT() uint32 {
	return volatile.LoadUint32(&o.IC_SS_SCL_LCNT.Reg) & 0xffff
}

// I2C0.IC_FS_SCL_HCNT: Fast Mode or Fast Mode Plus I2C Clock SCL High Count Register
func (o *I2C0_Type) SetIC_FS_SCL_HCNT(value uint32) {
	volatile.StoreUint32(&o.IC_FS_SCL_HCNT.Reg, volatile.LoadUint32(&o.IC_FS_SCL_HCNT.Reg)&^(0xffff)|value)
}
func (o *I2C0_Type) GetIC_FS_SCL_HCNT() uint32 {
	return volatile.LoadUint32(&o.IC_FS_SCL_HCNT.Reg) & 0xffff
}

// I2C0.IC_FS_SCL_LCNT: Fast Mode or Fast Mode Plus I2C Clock SCL Low Count Register
func (o *I2C0_Type) SetIC_FS_SCL_LCNT(value uint32) {
	volatile.StoreUint32(&o.IC_FS_SCL_LCNT.Reg, volatile.LoadUint32(&o.IC_FS_SCL_LCNT.Reg)&^(0xffff)|value)
}
func (o *I2C0_Type) GetIC_FS_SCL_LCNT() uint32 {
	return volatile.LoadUint32(&o.IC_FS_SCL_LCNT.Reg) & 0xffff
}

// I2C0.IC_INTR_STAT
// I2C Interrupt Status Register\n
// Each bit in this register has a corresponding mask bit in the IC_INTR_MASK register. These bits are cleared by reading the matching interrupt clear register. The unmasked raw versions of these bits are available in the IC_RAW_INTR_STAT register.
func (o *I2C0_Type) SetIC_INTR_STAT_R_MASTER_ON_HOLD(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x2000)|value<<13)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_MASTER_ON_HOLD() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x2000) >> 13
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_RESTART_DET(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x1000)|value<<12)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_RESTART_DET() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x1000) >> 12
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_GEN_CALL(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x800)|value<<11)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_GEN_CALL() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x800) >> 11
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_START_DET(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x400)|value<<10)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_START_DET() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x400) >> 10
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_STOP_DET(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x200)|value<<9)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_STOP_DET() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x200) >> 9
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x100)|value<<8)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_ACTIVITY() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x100) >> 8
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_RX_DONE(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x80)|value<<7)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_RX_DONE() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x80) >> 7
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_TX_ABRT(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_TX_ABRT() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_RD_REQ(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_RD_REQ() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_TX_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_TX_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_TX_OVER(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_TX_OVER() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_RX_FULL(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_RX_FULL() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_RX_OVER(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_RX_OVER() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetIC_INTR_STAT_R_RX_UNDER(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_INTR_STAT.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_INTR_STAT_R_RX_UNDER() uint32 {
	return volatile.LoadUint32(&o.IC_INTR_STAT.Reg) & 0x1
}

// I2C0.IC_INTR_MASK
// I2C Interrupt Mask Register.\n
// These bits mask their corresponding interrupt status bits. This register is active low; a value of 0 masks the interrupt, whereas a value of 1 unmasks the interrupt.
func (o *I2C0_Type) SetIC_INTR_MASK_M_MASTER_ON_HOLD_READ_ONLY(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x2000)|value<<13)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_MASTER_ON_HOLD_READ_ONLY() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x2000) >> 13
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_RESTART_DET(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x1000)|value<<12)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_RESTART_DET() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x1000) >> 12
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_GEN_CALL(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x800)|value<<11)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_GEN_CALL() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x800) >> 11
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_START_DET(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x400)|value<<10)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_START_DET() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x400) >> 10
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_STOP_DET(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x200)|value<<9)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_STOP_DET() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x200) >> 9
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x100)|value<<8)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_ACTIVITY() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x100) >> 8
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_RX_DONE(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x80)|value<<7)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_RX_DONE() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x80) >> 7
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_TX_ABRT(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_TX_ABRT() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_RD_REQ(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_RD_REQ() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_TX_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_TX_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_TX_OVER(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_TX_OVER() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_RX_FULL(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_RX_FULL() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_RX_OVER(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_RX_OVER() uint32 {
	return (volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetIC_INTR_MASK_M_RX_UNDER(value uint32) {
	volatile.StoreUint32(&o.IC_INTR_MASK.Reg, volatile.LoadUint32(&o.IC_INTR_MASK.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_INTR_MASK_M_RX_UNDER() uint32 {
	return volatile.LoadUint32(&o.IC_INTR_MASK.Reg) & 0x1
}

// I2C0.IC_RAW_INTR_STAT
// I2C Raw Interrupt Status Register\n
// Unlike the IC_INTR_STAT register, these bits are not masked so they always show the true status of the DW_apb_i2c.
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_MASTER_ON_HOLD(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x2000)|value<<13)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_MASTER_ON_HOLD() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x2000) >> 13
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_RESTART_DET(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x1000)|value<<12)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_RESTART_DET() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x1000) >> 12
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_GEN_CALL(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x800)|value<<11)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_GEN_CALL() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x800) >> 11
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_START_DET(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x400)|value<<10)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_START_DET() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x400) >> 10
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_STOP_DET(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x200)|value<<9)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_STOP_DET() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x200) >> 9
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x100)|value<<8)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_ACTIVITY() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x100) >> 8
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_RX_DONE(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x80)|value<<7)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_RX_DONE() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x80) >> 7
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_TX_ABRT(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_TX_ABRT() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_RD_REQ(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_RD_REQ() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_TX_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_TX_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_TX_OVER(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_TX_OVER() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_RX_FULL(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_RX_FULL() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_RX_OVER(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_RX_OVER() uint32 {
	return (volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetIC_RAW_INTR_STAT_RX_UNDER(value uint32) {
	volatile.StoreUint32(&o.IC_RAW_INTR_STAT.Reg, volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_RAW_INTR_STAT_RX_UNDER() uint32 {
	return volatile.LoadUint32(&o.IC_RAW_INTR_STAT.Reg) & 0x1
}

// I2C0.IC_RX_TL: I2C Receive FIFO Threshold Register
func (o *I2C0_Type) SetIC_RX_TL_RX_TL(value uint32) {
	volatile.StoreUint32(&o.IC_RX_TL.Reg, volatile.LoadUint32(&o.IC_RX_TL.Reg)&^(0xff)|value)
}
func (o *I2C0_Type) GetIC_RX_TL_RX_TL() uint32 {
	return volatile.LoadUint32(&o.IC_RX_TL.Reg) & 0xff
}

// I2C0.IC_TX_TL: I2C Transmit FIFO Threshold Register
func (o *I2C0_Type) SetIC_TX_TL_TX_TL(value uint32) {
	volatile.StoreUint32(&o.IC_TX_TL.Reg, volatile.LoadUint32(&o.IC_TX_TL.Reg)&^(0xff)|value)
}
func (o *I2C0_Type) GetIC_TX_TL_TX_TL() uint32 {
	return volatile.LoadUint32(&o.IC_TX_TL.Reg) & 0xff
}

// I2C0.IC_CLR_INTR: Clear Combined and Individual Interrupt Register
func (o *I2C0_Type) SetIC_CLR_INTR_CLR_INTR(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_INTR.Reg, volatile.LoadUint32(&o.IC_CLR_INTR.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_INTR_CLR_INTR() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_INTR.Reg) & 0x1
}

// I2C0.IC_CLR_RX_UNDER: Clear RX_UNDER Interrupt Register
func (o *I2C0_Type) SetIC_CLR_RX_UNDER_CLR_RX_UNDER(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_RX_UNDER.Reg, volatile.LoadUint32(&o.IC_CLR_RX_UNDER.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_RX_UNDER_CLR_RX_UNDER() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_RX_UNDER.Reg) & 0x1
}

// I2C0.IC_CLR_RX_OVER: Clear RX_OVER Interrupt Register
func (o *I2C0_Type) SetIC_CLR_RX_OVER_CLR_RX_OVER(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_RX_OVER.Reg, volatile.LoadUint32(&o.IC_CLR_RX_OVER.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_RX_OVER_CLR_RX_OVER() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_RX_OVER.Reg) & 0x1
}

// I2C0.IC_CLR_TX_OVER: Clear TX_OVER Interrupt Register
func (o *I2C0_Type) SetIC_CLR_TX_OVER_CLR_TX_OVER(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_TX_OVER.Reg, volatile.LoadUint32(&o.IC_CLR_TX_OVER.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_TX_OVER_CLR_TX_OVER() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_TX_OVER.Reg) & 0x1
}

// I2C0.IC_CLR_RD_REQ: Clear RD_REQ Interrupt Register
func (o *I2C0_Type) SetIC_CLR_RD_REQ_CLR_RD_REQ(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_RD_REQ.Reg, volatile.LoadUint32(&o.IC_CLR_RD_REQ.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_RD_REQ_CLR_RD_REQ() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_RD_REQ.Reg) & 0x1
}

// I2C0.IC_CLR_TX_ABRT: Clear TX_ABRT Interrupt Register
func (o *I2C0_Type) SetIC_CLR_TX_ABRT_CLR_TX_ABRT(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_TX_ABRT.Reg, volatile.LoadUint32(&o.IC_CLR_TX_ABRT.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_TX_ABRT_CLR_TX_ABRT() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_TX_ABRT.Reg) & 0x1
}

// I2C0.IC_CLR_RX_DONE: Clear RX_DONE Interrupt Register
func (o *I2C0_Type) SetIC_CLR_RX_DONE_CLR_RX_DONE(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_RX_DONE.Reg, volatile.LoadUint32(&o.IC_CLR_RX_DONE.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_RX_DONE_CLR_RX_DONE() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_RX_DONE.Reg) & 0x1
}

// I2C0.IC_CLR_ACTIVITY: Clear ACTIVITY Interrupt Register
func (o *I2C0_Type) SetIC_CLR_ACTIVITY_CLR_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_ACTIVITY.Reg, volatile.LoadUint32(&o.IC_CLR_ACTIVITY.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_ACTIVITY_CLR_ACTIVITY() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_ACTIVITY.Reg) & 0x1
}

// I2C0.IC_CLR_STOP_DET: Clear STOP_DET Interrupt Register
func (o *I2C0_Type) SetIC_CLR_STOP_DET_CLR_STOP_DET(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_STOP_DET.Reg, volatile.LoadUint32(&o.IC_CLR_STOP_DET.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_STOP_DET_CLR_STOP_DET() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_STOP_DET.Reg) & 0x1
}

// I2C0.IC_CLR_START_DET: Clear START_DET Interrupt Register
func (o *I2C0_Type) SetIC_CLR_START_DET_CLR_START_DET(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_START_DET.Reg, volatile.LoadUint32(&o.IC_CLR_START_DET.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_START_DET_CLR_START_DET() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_START_DET.Reg) & 0x1
}

// I2C0.IC_CLR_GEN_CALL: Clear GEN_CALL Interrupt Register
func (o *I2C0_Type) SetIC_CLR_GEN_CALL_CLR_GEN_CALL(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_GEN_CALL.Reg, volatile.LoadUint32(&o.IC_CLR_GEN_CALL.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_GEN_CALL_CLR_GEN_CALL() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_GEN_CALL.Reg) & 0x1
}

// I2C0.IC_ENABLE: I2C Enable Register
func (o *I2C0_Type) SetIC_ENABLE_TX_CMD_BLOCK(value uint32) {
	volatile.StoreUint32(&o.IC_ENABLE.Reg, volatile.LoadUint32(&o.IC_ENABLE.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetIC_ENABLE_TX_CMD_BLOCK() uint32 {
	return (volatile.LoadUint32(&o.IC_ENABLE.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetIC_ENABLE_ABORT(value uint32) {
	volatile.StoreUint32(&o.IC_ENABLE.Reg, volatile.LoadUint32(&o.IC_ENABLE.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetIC_ENABLE_ABORT() uint32 {
	return (volatile.LoadUint32(&o.IC_ENABLE.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetIC_ENABLE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.IC_ENABLE.Reg, volatile.LoadUint32(&o.IC_ENABLE.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_ENABLE_ENABLE() uint32 {
	return volatile.LoadUint32(&o.IC_ENABLE.Reg) & 0x1
}

// I2C0.IC_STATUS
// I2C Status Register\n
// This is a read-only register used to indicate the current transfer status and FIFO status. The status register may be read at any time. None of the bits in this register request an interrupt.\n
// When the I2C is disabled by writing 0 in bit 0 of the IC_ENABLE register: - Bits 1 and 2 are set to 1 - Bits 3 and 10 are set to 0 When the master or slave state machines goes to idle and ic_en=0: - Bits 5 and 6 are set to 0
func (o *I2C0_Type) SetIC_STATUS_SLV_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.IC_STATUS.Reg, volatile.LoadUint32(&o.IC_STATUS.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetIC_STATUS_SLV_ACTIVITY() uint32 {
	return (volatile.LoadUint32(&o.IC_STATUS.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetIC_STATUS_MST_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.IC_STATUS.Reg, volatile.LoadUint32(&o.IC_STATUS.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetIC_STATUS_MST_ACTIVITY() uint32 {
	return (volatile.LoadUint32(&o.IC_STATUS.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetIC_STATUS_RFF(value uint32) {
	volatile.StoreUint32(&o.IC_STATUS.Reg, volatile.LoadUint32(&o.IC_STATUS.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetIC_STATUS_RFF() uint32 {
	return (volatile.LoadUint32(&o.IC_STATUS.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetIC_STATUS_RFNE(value uint32) {
	volatile.StoreUint32(&o.IC_STATUS.Reg, volatile.LoadUint32(&o.IC_STATUS.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetIC_STATUS_RFNE() uint32 {
	return (volatile.LoadUint32(&o.IC_STATUS.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetIC_STATUS_TFE(value uint32) {
	volatile.StoreUint32(&o.IC_STATUS.Reg, volatile.LoadUint32(&o.IC_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetIC_STATUS_TFE() uint32 {
	return (volatile.LoadUint32(&o.IC_STATUS.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetIC_STATUS_TFNF(value uint32) {
	volatile.StoreUint32(&o.IC_STATUS.Reg, volatile.LoadUint32(&o.IC_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetIC_STATUS_TFNF() uint32 {
	return (volatile.LoadUint32(&o.IC_STATUS.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetIC_STATUS_ACTIVITY(value uint32) {
	volatile.StoreUint32(&o.IC_STATUS.Reg, volatile.LoadUint32(&o.IC_STATUS.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_STATUS_ACTIVITY() uint32 {
	return volatile.LoadUint32(&o.IC_STATUS.Reg) & 0x1
}

// I2C0.IC_TXFLR: I2C Transmit FIFO Level Register This register contains the number of valid data entries in the transmit FIFO buffer. It is cleared whenever: - The I2C is disabled - There is a transmit abort - that is, TX_ABRT bit is set in the IC_RAW_INTR_STAT register - The slave bulk transmit mode is aborted The register increments whenever data is placed into the transmit FIFO and decrements when data is taken from the transmit FIFO.
func (o *I2C0_Type) SetIC_TXFLR_TXFLR(value uint32) {
	volatile.StoreUint32(&o.IC_TXFLR.Reg, volatile.LoadUint32(&o.IC_TXFLR.Reg)&^(0x1f)|value)
}
func (o *I2C0_Type) GetIC_TXFLR_TXFLR() uint32 {
	return volatile.LoadUint32(&o.IC_TXFLR.Reg) & 0x1f
}

// I2C0.IC_RXFLR: I2C Receive FIFO Level Register This register contains the number of valid data entries in the receive FIFO buffer. It is cleared whenever: - The I2C is disabled - Whenever there is a transmit abort caused by any of the events tracked in IC_TX_ABRT_SOURCE The register increments whenever data is placed into the receive FIFO and decrements when data is taken from the receive FIFO.
func (o *I2C0_Type) SetIC_RXFLR_RXFLR(value uint32) {
	volatile.StoreUint32(&o.IC_RXFLR.Reg, volatile.LoadUint32(&o.IC_RXFLR.Reg)&^(0x1f)|value)
}
func (o *I2C0_Type) GetIC_RXFLR_RXFLR() uint32 {
	return volatile.LoadUint32(&o.IC_RXFLR.Reg) & 0x1f
}

// I2C0.IC_SDA_HOLD
// I2C SDA Hold Time Length Register\n
// The bits [15:0] of this register are used to control the hold time of SDA during transmit in both slave and master mode (after SCL goes from HIGH to LOW).\n
// The bits [23:16] of this register are used to extend the SDA transition (if any) whenever SCL is HIGH in the receiver in either master or slave mode.\n
// Writes to this register succeed only when IC_ENABLE[0]=0.\n
// The values in this register are in units of ic_clk period. The value programmed in IC_SDA_TX_HOLD must be greater than the minimum hold time in each mode one cycle in master mode, seven cycles in slave mode for the value to be implemented.\n
// The programmed SDA hold time during transmit (IC_SDA_TX_HOLD) cannot exceed at any time the duration of the low part of scl. Therefore the programmed value cannot be larger than N_SCL_LOW-2, where N_SCL_LOW is the duration of the low part of the scl period measured in ic_clk cycles.
func (o *I2C0_Type) SetIC_SDA_HOLD_IC_SDA_RX_HOLD(value uint32) {
	volatile.StoreUint32(&o.IC_SDA_HOLD.Reg, volatile.LoadUint32(&o.IC_SDA_HOLD.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C0_Type) GetIC_SDA_HOLD_IC_SDA_RX_HOLD() uint32 {
	return (volatile.LoadUint32(&o.IC_SDA_HOLD.Reg) & 0xff0000) >> 16
}
func (o *I2C0_Type) SetIC_SDA_HOLD_IC_SDA_TX_HOLD(value uint32) {
	volatile.StoreUint32(&o.IC_SDA_HOLD.Reg, volatile.LoadUint32(&o.IC_SDA_HOLD.Reg)&^(0xffff)|value)
}
func (o *I2C0_Type) GetIC_SDA_HOLD_IC_SDA_TX_HOLD() uint32 {
	return volatile.LoadUint32(&o.IC_SDA_HOLD.Reg) & 0xffff
}

// I2C0.IC_TX_ABRT_SOURCE
// I2C Transmit Abort Source Register\n
// This register has 32 bits that indicate the source of the TX_ABRT bit. Except for Bit 9, this register is cleared whenever the IC_CLR_TX_ABRT register or the IC_CLR_INTR register is read. To clear Bit 9, the source of the ABRT_SBYTE_NORSTRT must be fixed first; RESTART must be enabled (IC_CON[5]=1), the SPECIAL bit must be cleared (IC_TAR[11]), or the GC_OR_START bit must be cleared (IC_TAR[10]).\n
// Once the source of the ABRT_SBYTE_NORSTRT is fixed, then this bit can be cleared in the same manner as other bits in this register. If the source of the ABRT_SBYTE_NORSTRT is not fixed before attempting to clear this bit, Bit 9 clears for one cycle and is then re-asserted.
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_TX_FLUSH_CNT(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0xff800000)|value<<23)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_TX_FLUSH_CNT() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0xff800000) >> 23
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_USER_ABRT(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x10000)|value<<16)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_USER_ABRT() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x10000) >> 16
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x8000)|value<<15)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x8000) >> 15
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x4000)|value<<14)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x4000) >> 14
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x2000)|value<<13)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x2000) >> 13
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ARB_LOST(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x1000)|value<<12)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ARB_LOST() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x1000) >> 12
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_MASTER_DIS(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x800)|value<<11)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_MASTER_DIS() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x800) >> 11
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x400)|value<<10)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x400) >> 10
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x200)|value<<9)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x200) >> 9
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x100)|value<<8)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x100) >> 8
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x80)|value<<7)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x80) >> 7
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_HS_ACKDET(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_HS_ACKDET() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_GCALL_READ(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_GCALL_READ() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x8)|value<<3)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x8) >> 3
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK() uint32 {
	return (volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetIC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK(value uint32) {
	volatile.StoreUint32(&o.IC_TX_ABRT_SOURCE.Reg, volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK() uint32 {
	return volatile.LoadUint32(&o.IC_TX_ABRT_SOURCE.Reg) & 0x1
}

// I2C0.IC_SLV_DATA_NACK_ONLY
// Generate Slave Data NACK Register\n
// The register is used to generate a NACK for the data part of a transfer when DW_apb_i2c is acting as a slave-receiver. This register only exists when the IC_SLV_DATA_NACK_ONLY parameter is set to 1. When this parameter disabled, this register does not exist and writing to the register's address has no effect.\n
// A write can occur on this register if both of the following conditions are met: - DW_apb_i2c is disabled (IC_ENABLE[0] = 0) - Slave part is inactive (IC_STATUS[6] = 0) Note: The IC_STATUS[6] is a register read-back location for the internal slv_activity signal; the user should poll this before writing the ic_slv_data_nack_only bit.
func (o *I2C0_Type) SetIC_SLV_DATA_NACK_ONLY_NACK(value uint32) {
	volatile.StoreUint32(&o.IC_SLV_DATA_NACK_ONLY.Reg, volatile.LoadUint32(&o.IC_SLV_DATA_NACK_ONLY.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_SLV_DATA_NACK_ONLY_NACK() uint32 {
	return volatile.LoadUint32(&o.IC_SLV_DATA_NACK_ONLY.Reg) & 0x1
}

// I2C0.IC_DMA_CR
// DMA Control Register\n
// The register is used to enable the DMA Controller interface operation. There is a separate bit for transmit and receive. This can be programmed regardless of the state of IC_ENABLE.
func (o *I2C0_Type) SetIC_DMA_CR_TDMAE(value uint32) {
	volatile.StoreUint32(&o.IC_DMA_CR.Reg, volatile.LoadUint32(&o.IC_DMA_CR.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetIC_DMA_CR_TDMAE() uint32 {
	return (volatile.LoadUint32(&o.IC_DMA_CR.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetIC_DMA_CR_RDMAE(value uint32) {
	volatile.StoreUint32(&o.IC_DMA_CR.Reg, volatile.LoadUint32(&o.IC_DMA_CR.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_DMA_CR_RDMAE() uint32 {
	return volatile.LoadUint32(&o.IC_DMA_CR.Reg) & 0x1
}

// I2C0.IC_DMA_TDLR: DMA Transmit Data Level Register
func (o *I2C0_Type) SetIC_DMA_TDLR_DMATDL(value uint32) {
	volatile.StoreUint32(&o.IC_DMA_TDLR.Reg, volatile.LoadUint32(&o.IC_DMA_TDLR.Reg)&^(0xf)|value)
}
func (o *I2C0_Type) GetIC_DMA_TDLR_DMATDL() uint32 {
	return volatile.LoadUint32(&o.IC_DMA_TDLR.Reg) & 0xf
}

// I2C0.IC_DMA_RDLR: I2C Receive Data Level Register
func (o *I2C0_Type) SetIC_DMA_RDLR_DMARDL(value uint32) {
	volatile.StoreUint32(&o.IC_DMA_RDLR.Reg, volatile.LoadUint32(&o.IC_DMA_RDLR.Reg)&^(0xf)|value)
}
func (o *I2C0_Type) GetIC_DMA_RDLR_DMARDL() uint32 {
	return volatile.LoadUint32(&o.IC_DMA_RDLR.Reg) & 0xf
}

// I2C0.IC_SDA_SETUP
// I2C SDA Setup Register\n
// This register controls the amount of time delay (in terms of number of ic_clk clock periods) introduced in the rising edge of SCL - relative to SDA changing - when DW_apb_i2c services a read request in a slave-transmitter operation. The relevant I2C requirement is tSU:DAT (note 4) as detailed in the I2C Bus Specification. This register must be programmed with a value equal to or greater than 2.\n
// Writes to this register succeed only when IC_ENABLE[0] = 0.\n
// Note: The length of setup time is calculated using [(IC_SDA_SETUP - 1) * (ic_clk_period)], so if the user requires 10 ic_clk periods of setup time, they should program a value of 11. The IC_SDA_SETUP register is only used by the DW_apb_i2c when operating as a slave transmitter.
func (o *I2C0_Type) SetIC_SDA_SETUP_SDA_SETUP(value uint32) {
	volatile.StoreUint32(&o.IC_SDA_SETUP.Reg, volatile.LoadUint32(&o.IC_SDA_SETUP.Reg)&^(0xff)|value)
}
func (o *I2C0_Type) GetIC_SDA_SETUP_SDA_SETUP() uint32 {
	return volatile.LoadUint32(&o.IC_SDA_SETUP.Reg) & 0xff
}

// I2C0.IC_ACK_GENERAL_CALL
// I2C ACK General Call Register\n
// The register controls whether DW_apb_i2c responds with a ACK or NACK when it receives an I2C General Call address.\n
// This register is applicable only when the DW_apb_i2c is in slave mode.
func (o *I2C0_Type) SetIC_ACK_GENERAL_CALL_ACK_GEN_CALL(value uint32) {
	volatile.StoreUint32(&o.IC_ACK_GENERAL_CALL.Reg, volatile.LoadUint32(&o.IC_ACK_GENERAL_CALL.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_ACK_GENERAL_CALL_ACK_GEN_CALL() uint32 {
	return volatile.LoadUint32(&o.IC_ACK_GENERAL_CALL.Reg) & 0x1
}

// I2C0.IC_ENABLE_STATUS
// I2C Enable Status Register\n
// The register is used to report the DW_apb_i2c hardware status when the IC_ENABLE[0] register is set from 1 to 0; that is, when DW_apb_i2c is disabled.\n
// If IC_ENABLE[0] has been set to 1, bits 2:1 are forced to 0, and bit 0 is forced to 1.\n
// If IC_ENABLE[0] has been set to 0, bits 2:1 is only be valid as soon as bit 0 is read as '0'.\n
// Note: When IC_ENABLE[0] has been set to 0, a delay occurs for bit 0 to be read as 0 because disabling the DW_apb_i2c depends on I2C bus activities.
func (o *I2C0_Type) SetIC_ENABLE_STATUS_SLV_RX_DATA_LOST(value uint32) {
	volatile.StoreUint32(&o.IC_ENABLE_STATUS.Reg, volatile.LoadUint32(&o.IC_ENABLE_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *I2C0_Type) GetIC_ENABLE_STATUS_SLV_RX_DATA_LOST() uint32 {
	return (volatile.LoadUint32(&o.IC_ENABLE_STATUS.Reg) & 0x4) >> 2
}
func (o *I2C0_Type) SetIC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY(value uint32) {
	volatile.StoreUint32(&o.IC_ENABLE_STATUS.Reg, volatile.LoadUint32(&o.IC_ENABLE_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *I2C0_Type) GetIC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY() uint32 {
	return (volatile.LoadUint32(&o.IC_ENABLE_STATUS.Reg) & 0x2) >> 1
}
func (o *I2C0_Type) SetIC_ENABLE_STATUS_IC_EN(value uint32) {
	volatile.StoreUint32(&o.IC_ENABLE_STATUS.Reg, volatile.LoadUint32(&o.IC_ENABLE_STATUS.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_ENABLE_STATUS_IC_EN() uint32 {
	return volatile.LoadUint32(&o.IC_ENABLE_STATUS.Reg) & 0x1
}

// I2C0.IC_FS_SPKLEN
// I2C SS, FS or FM+ spike suppression limit\n
// This register is used to store the duration, measured in ic_clk cycles, of the longest spike that is filtered out by the spike suppression logic when the component is operating in SS, FS or FM+ modes. The relevant I2C requirement is tSP (table 4) as detailed in the I2C Bus Specification. This register must be programmed with a minimum value of 1.
func (o *I2C0_Type) SetIC_FS_SPKLEN(value uint32) {
	volatile.StoreUint32(&o.IC_FS_SPKLEN.Reg, volatile.LoadUint32(&o.IC_FS_SPKLEN.Reg)&^(0xff)|value)
}
func (o *I2C0_Type) GetIC_FS_SPKLEN() uint32 {
	return volatile.LoadUint32(&o.IC_FS_SPKLEN.Reg) & 0xff
}

// I2C0.IC_CLR_RESTART_DET: Clear RESTART_DET Interrupt Register
func (o *I2C0_Type) SetIC_CLR_RESTART_DET_CLR_RESTART_DET(value uint32) {
	volatile.StoreUint32(&o.IC_CLR_RESTART_DET.Reg, volatile.LoadUint32(&o.IC_CLR_RESTART_DET.Reg)&^(0x1)|value)
}
func (o *I2C0_Type) GetIC_CLR_RESTART_DET_CLR_RESTART_DET() uint32 {
	return volatile.LoadUint32(&o.IC_CLR_RESTART_DET.Reg) & 0x1
}

// I2C0.IC_COMP_PARAM_1
// Component Parameter Register 1\n
// Note This register is not implemented and therefore reads as 0. If it was implemented it would be a constant read-only register that contains encoded information about the component's parameter settings. Fields shown below are the settings for those parameters
func (o *I2C0_Type) SetIC_COMP_PARAM_1_TX_BUFFER_DEPTH(value uint32) {
	volatile.StoreUint32(&o.IC_COMP_PARAM_1.Reg, volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C0_Type) GetIC_COMP_PARAM_1_TX_BUFFER_DEPTH() uint32 {
	return (volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg) & 0xff0000) >> 16
}
func (o *I2C0_Type) SetIC_COMP_PARAM_1_RX_BUFFER_DEPTH(value uint32) {
	volatile.StoreUint32(&o.IC_COMP_PARAM_1.Reg, volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg)&^(0xff00)|value<<8)
}
func (o *I2C0_Type) GetIC_COMP_PARAM_1_RX_BUFFER_DEPTH() uint32 {
	return (volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg) & 0xff00) >> 8
}
func (o *I2C0_Type) SetIC_COMP_PARAM_1_ADD_ENCODED_PARAMS(value uint32) {
	volatile.StoreUint32(&o.IC_COMP_PARAM_1.Reg, volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg)&^(0x80)|value<<7)
}
func (o *I2C0_Type) GetIC_COMP_PARAM_1_ADD_ENCODED_PARAMS() uint32 {
	return (volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg) & 0x80) >> 7
}
func (o *I2C0_Type) SetIC_COMP_PARAM_1_HAS_DMA(value uint32) {
	volatile.StoreUint32(&o.IC_COMP_PARAM_1.Reg, volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg)&^(0x40)|value<<6)
}
func (o *I2C0_Type) GetIC_COMP_PARAM_1_HAS_DMA() uint32 {
	return (volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg) & 0x40) >> 6
}
func (o *I2C0_Type) SetIC_COMP_PARAM_1_INTR_IO(value uint32) {
	volatile.StoreUint32(&o.IC_COMP_PARAM_1.Reg, volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg)&^(0x20)|value<<5)
}
func (o *I2C0_Type) GetIC_COMP_PARAM_1_INTR_IO() uint32 {
	return (volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg) & 0x20) >> 5
}
func (o *I2C0_Type) SetIC_COMP_PARAM_1_HC_COUNT_VALUES(value uint32) {
	volatile.StoreUint32(&o.IC_COMP_PARAM_1.Reg, volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg)&^(0x10)|value<<4)
}
func (o *I2C0_Type) GetIC_COMP_PARAM_1_HC_COUNT_VALUES() uint32 {
	return (volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg) & 0x10) >> 4
}
func (o *I2C0_Type) SetIC_COMP_PARAM_1_MAX_SPEED_MODE(value uint32) {
	volatile.StoreUint32(&o.IC_COMP_PARAM_1.Reg, volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg)&^(0xc)|value<<2)
}
func (o *I2C0_Type) GetIC_COMP_PARAM_1_MAX_SPEED_MODE() uint32 {
	return (volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg) & 0xc) >> 2
}
func (o *I2C0_Type) SetIC_COMP_PARAM_1_APB_DATA_WIDTH(value uint32) {
	volatile.StoreUint32(&o.IC_COMP_PARAM_1.Reg, volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg)&^(0x3)|value)
}
func (o *I2C0_Type) GetIC_COMP_PARAM_1_APB_DATA_WIDTH() uint32 {
	return volatile.LoadUint32(&o.IC_COMP_PARAM_1.Reg) & 0x3
}

// I2C0.IC_COMP_VERSION: I2C Component Version Register
func (o *I2C0_Type) SetIC_COMP_VERSION(value uint32) {
	volatile.StoreUint32(&o.IC_COMP_VERSION.Reg, value)
}
func (o *I2C0_Type) GetIC_COMP_VERSION() uint32 {
	return volatile.LoadUint32(&o.IC_COMP_VERSION.Reg)
}

// I2C0.IC_COMP_TYPE: I2C Component Type Register
func (o *I2C0_Type) SetIC_COMP_TYPE(value uint32) {
	volatile.StoreUint32(&o.IC_COMP_TYPE.Reg, value)
}
func (o *I2C0_Type) GetIC_COMP_TYPE() uint32 {
	return volatile.LoadUint32(&o.IC_COMP_TYPE.Reg)
}

// Control and data interface to SAR ADC
type ADC_Type struct {
	CS     volatile.Register32 // 0x0
	RESULT volatile.Register32 // 0x4
	FCS    volatile.Register32 // 0x8
	FIFO   volatile.Register32 // 0xC
	DIV    volatile.Register32 // 0x10
	INTR   volatile.Register32 // 0x14
	INTE   volatile.Register32 // 0x18
	INTF   volatile.Register32 // 0x1C
	INTS   volatile.Register32 // 0x20
}

// ADC.CS: ADC Control and Status
func (o *ADC_Type) SetCS_RROBIN(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x1f0000)|value<<16)
}
func (o *ADC_Type) GetCS_RROBIN() uint32 {
	return (volatile.LoadUint32(&o.CS.Reg) & 0x1f0000) >> 16
}
func (o *ADC_Type) SetCS_AINSEL(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetCS_AINSEL() uint32 {
	return (volatile.LoadUint32(&o.CS.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetCS_ERR_STICKY(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCS_ERR_STICKY() uint32 {
	return (volatile.LoadUint32(&o.CS.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCS_ERR(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCS_ERR() uint32 {
	return (volatile.LoadUint32(&o.CS.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCS_READY(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCS_READY() uint32 {
	return (volatile.LoadUint32(&o.CS.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCS_START_MANY(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCS_START_MANY() uint32 {
	return (volatile.LoadUint32(&o.CS.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCS_START_ONCE(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCS_START_ONCE() uint32 {
	return (volatile.LoadUint32(&o.CS.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCS_TS_EN(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCS_TS_EN() uint32 {
	return (volatile.LoadUint32(&o.CS.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCS_EN(value uint32) {
	volatile.StoreUint32(&o.CS.Reg, volatile.LoadUint32(&o.CS.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCS_EN() uint32 {
	return volatile.LoadUint32(&o.CS.Reg) & 0x1
}

// ADC.RESULT: Result of most recent ADC conversion
func (o *ADC_Type) SetRESULT(value uint32) {
	volatile.StoreUint32(&o.RESULT.Reg, volatile.LoadUint32(&o.RESULT.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetRESULT() uint32 {
	return volatile.LoadUint32(&o.RESULT.Reg) & 0xfff
}

// ADC.FCS: FIFO control and status
func (o *ADC_Type) SetFCS_THRESH(value uint32) {
	volatile.StoreUint32(&o.FCS.Reg, volatile.LoadUint32(&o.FCS.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetFCS_THRESH() uint32 {
	return (volatile.LoadUint32(&o.FCS.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetFCS_LEVEL(value uint32) {
	volatile.StoreUint32(&o.FCS.Reg, volatile.LoadUint32(&o.FCS.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetFCS_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.FCS.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetFCS_OVER(value uint32) {
	volatile.StoreUint32(&o.FCS.Reg, volatile.LoadUint32(&o.FCS.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetFCS_OVER() uint32 {
	return (volatile.LoadUint32(&o.FCS.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetFCS_UNDER(value uint32) {
	volatile.StoreUint32(&o.FCS.Reg, volatile.LoadUint32(&o.FCS.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetFCS_UNDER() uint32 {
	return (volatile.LoadUint32(&o.FCS.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetFCS_FULL(value uint32) {
	volatile.StoreUint32(&o.FCS.Reg, volatile.LoadUint32(&o.FCS.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetFCS_FULL() uint32 {
	return (volatile.LoadUint32(&o.FCS.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetFCS_EMPTY(value uint32) {
	volatile.StoreUint32(&o.FCS.Reg, volatile.LoadUint32(&o.FCS.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetFCS_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.FCS.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetFCS_DREQ_EN(value uint32) {
	volatile.StoreUint32(&o.FCS.Reg, volatile.LoadUint32(&o.FCS.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetFCS_DREQ_EN() uint32 {
	return (volatile.LoadUint32(&o.FCS.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetFCS_ERR(value uint32) {
	volatile.StoreUint32(&o.FCS.Reg, volatile.LoadUint32(&o.FCS.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetFCS_ERR() uint32 {
	return (volatile.LoadUint32(&o.FCS.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetFCS_SHIFT(value uint32) {
	volatile.StoreUint32(&o.FCS.Reg, volatile.LoadUint32(&o.FCS.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetFCS_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.FCS.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetFCS_EN(value uint32) {
	volatile.StoreUint32(&o.FCS.Reg, volatile.LoadUint32(&o.FCS.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetFCS_EN() uint32 {
	return volatile.LoadUint32(&o.FCS.Reg) & 0x1
}

// ADC.FIFO: Conversion result FIFO
func (o *ADC_Type) SetFIFO_ERR(value uint32) {
	volatile.StoreUint32(&o.FIFO.Reg, volatile.LoadUint32(&o.FIFO.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetFIFO_ERR() uint32 {
	return (volatile.LoadUint32(&o.FIFO.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetFIFO_VAL(value uint32) {
	volatile.StoreUint32(&o.FIFO.Reg, volatile.LoadUint32(&o.FIFO.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetFIFO_VAL() uint32 {
	return volatile.LoadUint32(&o.FIFO.Reg) & 0xfff
}

// ADC.DIV
// Clock divider. If non-zero, CS_START_MANY will start conversions
// at regular intervals rather than back-to-back.
// The divider is reset when either of these fields are written.
// Total period is 1 + INT + FRAC / 256
func (o *ADC_Type) SetDIV_INT(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xffff00)|value<<8)
}
func (o *ADC_Type) GetDIV_INT() uint32 {
	return (volatile.LoadUint32(&o.DIV.Reg) & 0xffff00) >> 8
}
func (o *ADC_Type) SetDIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.DIV.Reg, volatile.LoadUint32(&o.DIV.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetDIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.DIV.Reg) & 0xff
}

// ADC.INTR: Raw Interrupts
func (o *ADC_Type) SetINTR_FIFO(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTR_FIFO() uint32 {
	return volatile.LoadUint32(&o.INTR.Reg) & 0x1
}

// ADC.INTE: Interrupt Enable
func (o *ADC_Type) SetINTE_FIFO(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTE_FIFO() uint32 {
	return volatile.LoadUint32(&o.INTE.Reg) & 0x1
}

// ADC.INTF: Interrupt Force
func (o *ADC_Type) SetINTF_FIFO(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTF_FIFO() uint32 {
	return volatile.LoadUint32(&o.INTF.Reg) & 0x1
}

// ADC.INTS: Interrupt status after masking & forcing
func (o *ADC_Type) SetINTS_FIFO(value uint32) {
	volatile.StoreUint32(&o.INTS.Reg, volatile.LoadUint32(&o.INTS.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTS_FIFO() uint32 {
	return volatile.LoadUint32(&o.INTS.Reg) & 0x1
}

// Simple PWM
type PWM_Type struct {
	CH0_CSR volatile.Register32 // 0x0
	CH0_DIV volatile.Register32 // 0x4
	CH0_CTR volatile.Register32 // 0x8
	CH0_CC  volatile.Register32 // 0xC
	CH0_TOP volatile.Register32 // 0x10
	CH1_CSR volatile.Register32 // 0x14
	CH1_DIV volatile.Register32 // 0x18
	CH1_CTR volatile.Register32 // 0x1C
	CH1_CC  volatile.Register32 // 0x20
	CH1_TOP volatile.Register32 // 0x24
	CH2_CSR volatile.Register32 // 0x28
	CH2_DIV volatile.Register32 // 0x2C
	CH2_CTR volatile.Register32 // 0x30
	CH2_CC  volatile.Register32 // 0x34
	CH2_TOP volatile.Register32 // 0x38
	CH3_CSR volatile.Register32 // 0x3C
	CH3_DIV volatile.Register32 // 0x40
	CH3_CTR volatile.Register32 // 0x44
	CH3_CC  volatile.Register32 // 0x48
	CH3_TOP volatile.Register32 // 0x4C
	CH4_CSR volatile.Register32 // 0x50
	CH4_DIV volatile.Register32 // 0x54
	CH4_CTR volatile.Register32 // 0x58
	CH4_CC  volatile.Register32 // 0x5C
	CH4_TOP volatile.Register32 // 0x60
	CH5_CSR volatile.Register32 // 0x64
	CH5_DIV volatile.Register32 // 0x68
	CH5_CTR volatile.Register32 // 0x6C
	CH5_CC  volatile.Register32 // 0x70
	CH5_TOP volatile.Register32 // 0x74
	CH6_CSR volatile.Register32 // 0x78
	CH6_DIV volatile.Register32 // 0x7C
	CH6_CTR volatile.Register32 // 0x80
	CH6_CC  volatile.Register32 // 0x84
	CH6_TOP volatile.Register32 // 0x88
	CH7_CSR volatile.Register32 // 0x8C
	CH7_DIV volatile.Register32 // 0x90
	CH7_CTR volatile.Register32 // 0x94
	CH7_CC  volatile.Register32 // 0x98
	CH7_TOP volatile.Register32 // 0x9C
	EN      volatile.Register32 // 0xA0
	INTR    volatile.Register32 // 0xA4
	INTE    volatile.Register32 // 0xA8
	INTF    volatile.Register32 // 0xAC
	INTS    volatile.Register32 // 0xB0
}

// PWM.CH0_CSR: Control and status register
func (o *PWM_Type) SetCH0_CSR_PH_ADV(value uint32) {
	volatile.StoreUint32(&o.CH0_CSR.Reg, volatile.LoadUint32(&o.CH0_CSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetCH0_CSR_PH_ADV() uint32 {
	return (volatile.LoadUint32(&o.CH0_CSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetCH0_CSR_PH_RET(value uint32) {
	volatile.StoreUint32(&o.CH0_CSR.Reg, volatile.LoadUint32(&o.CH0_CSR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetCH0_CSR_PH_RET() uint32 {
	return (volatile.LoadUint32(&o.CH0_CSR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetCH0_CSR_DIVMODE(value uint32) {
	volatile.StoreUint32(&o.CH0_CSR.Reg, volatile.LoadUint32(&o.CH0_CSR.Reg)&^(0x30)|value<<4)
}
func (o *PWM_Type) GetCH0_CSR_DIVMODE() uint32 {
	return (volatile.LoadUint32(&o.CH0_CSR.Reg) & 0x30) >> 4
}
func (o *PWM_Type) SetCH0_CSR_B_INV(value uint32) {
	volatile.StoreUint32(&o.CH0_CSR.Reg, volatile.LoadUint32(&o.CH0_CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCH0_CSR_B_INV() uint32 {
	return (volatile.LoadUint32(&o.CH0_CSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCH0_CSR_A_INV(value uint32) {
	volatile.StoreUint32(&o.CH0_CSR.Reg, volatile.LoadUint32(&o.CH0_CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCH0_CSR_A_INV() uint32 {
	return (volatile.LoadUint32(&o.CH0_CSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCH0_CSR_PH_CORRECT(value uint32) {
	volatile.StoreUint32(&o.CH0_CSR.Reg, volatile.LoadUint32(&o.CH0_CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetCH0_CSR_PH_CORRECT() uint32 {
	return (volatile.LoadUint32(&o.CH0_CSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetCH0_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.CH0_CSR.Reg, volatile.LoadUint32(&o.CH0_CSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCH0_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.CH0_CSR.Reg) & 0x1
}

// PWM.CH0_DIV
// INT and FRAC form a fixed-point fractional number.
// Counting rate is system clock frequency divided by this number.
// Fractional division uses simple 1st-order sigma-delta.
func (o *PWM_Type) SetCH0_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CH0_DIV.Reg, volatile.LoadUint32(&o.CH0_DIV.Reg)&^(0xff0)|value<<4)
}
func (o *PWM_Type) GetCH0_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CH0_DIV.Reg) & 0xff0) >> 4
}
func (o *PWM_Type) SetCH0_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CH0_DIV.Reg, volatile.LoadUint32(&o.CH0_DIV.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCH0_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CH0_DIV.Reg) & 0xf
}

// PWM.CH0_CTR: Direct access to the PWM counter
func (o *PWM_Type) SetCH0_CTR(value uint32) {
	volatile.StoreUint32(&o.CH0_CTR.Reg, volatile.LoadUint32(&o.CH0_CTR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH0_CTR() uint32 {
	return volatile.LoadUint32(&o.CH0_CTR.Reg) & 0xffff
}

// PWM.CH0_CC: Counter compare values
func (o *PWM_Type) SetCH0_CC_B(value uint32) {
	volatile.StoreUint32(&o.CH0_CC.Reg, volatile.LoadUint32(&o.CH0_CC.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetCH0_CC_B() uint32 {
	return (volatile.LoadUint32(&o.CH0_CC.Reg) & 0xffff0000) >> 16
}
func (o *PWM_Type) SetCH0_CC_A(value uint32) {
	volatile.StoreUint32(&o.CH0_CC.Reg, volatile.LoadUint32(&o.CH0_CC.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH0_CC_A() uint32 {
	return volatile.LoadUint32(&o.CH0_CC.Reg) & 0xffff
}

// PWM.CH0_TOP: Counter wrap value
func (o *PWM_Type) SetCH0_TOP(value uint32) {
	volatile.StoreUint32(&o.CH0_TOP.Reg, volatile.LoadUint32(&o.CH0_TOP.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH0_TOP() uint32 {
	return volatile.LoadUint32(&o.CH0_TOP.Reg) & 0xffff
}

// PWM.CH1_CSR: Control and status register
func (o *PWM_Type) SetCH1_CSR_PH_ADV(value uint32) {
	volatile.StoreUint32(&o.CH1_CSR.Reg, volatile.LoadUint32(&o.CH1_CSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetCH1_CSR_PH_ADV() uint32 {
	return (volatile.LoadUint32(&o.CH1_CSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetCH1_CSR_PH_RET(value uint32) {
	volatile.StoreUint32(&o.CH1_CSR.Reg, volatile.LoadUint32(&o.CH1_CSR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetCH1_CSR_PH_RET() uint32 {
	return (volatile.LoadUint32(&o.CH1_CSR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetCH1_CSR_DIVMODE(value uint32) {
	volatile.StoreUint32(&o.CH1_CSR.Reg, volatile.LoadUint32(&o.CH1_CSR.Reg)&^(0x30)|value<<4)
}
func (o *PWM_Type) GetCH1_CSR_DIVMODE() uint32 {
	return (volatile.LoadUint32(&o.CH1_CSR.Reg) & 0x30) >> 4
}
func (o *PWM_Type) SetCH1_CSR_B_INV(value uint32) {
	volatile.StoreUint32(&o.CH1_CSR.Reg, volatile.LoadUint32(&o.CH1_CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCH1_CSR_B_INV() uint32 {
	return (volatile.LoadUint32(&o.CH1_CSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCH1_CSR_A_INV(value uint32) {
	volatile.StoreUint32(&o.CH1_CSR.Reg, volatile.LoadUint32(&o.CH1_CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCH1_CSR_A_INV() uint32 {
	return (volatile.LoadUint32(&o.CH1_CSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCH1_CSR_PH_CORRECT(value uint32) {
	volatile.StoreUint32(&o.CH1_CSR.Reg, volatile.LoadUint32(&o.CH1_CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetCH1_CSR_PH_CORRECT() uint32 {
	return (volatile.LoadUint32(&o.CH1_CSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetCH1_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.CH1_CSR.Reg, volatile.LoadUint32(&o.CH1_CSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCH1_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.CH1_CSR.Reg) & 0x1
}

// PWM.CH1_DIV
// INT and FRAC form a fixed-point fractional number.
// Counting rate is system clock frequency divided by this number.
// Fractional division uses simple 1st-order sigma-delta.
func (o *PWM_Type) SetCH1_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CH1_DIV.Reg, volatile.LoadUint32(&o.CH1_DIV.Reg)&^(0xff0)|value<<4)
}
func (o *PWM_Type) GetCH1_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CH1_DIV.Reg) & 0xff0) >> 4
}
func (o *PWM_Type) SetCH1_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CH1_DIV.Reg, volatile.LoadUint32(&o.CH1_DIV.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCH1_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CH1_DIV.Reg) & 0xf
}

// PWM.CH1_CTR: Direct access to the PWM counter
func (o *PWM_Type) SetCH1_CTR(value uint32) {
	volatile.StoreUint32(&o.CH1_CTR.Reg, volatile.LoadUint32(&o.CH1_CTR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH1_CTR() uint32 {
	return volatile.LoadUint32(&o.CH1_CTR.Reg) & 0xffff
}

// PWM.CH1_CC: Counter compare values
func (o *PWM_Type) SetCH1_CC_B(value uint32) {
	volatile.StoreUint32(&o.CH1_CC.Reg, volatile.LoadUint32(&o.CH1_CC.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetCH1_CC_B() uint32 {
	return (volatile.LoadUint32(&o.CH1_CC.Reg) & 0xffff0000) >> 16
}
func (o *PWM_Type) SetCH1_CC_A(value uint32) {
	volatile.StoreUint32(&o.CH1_CC.Reg, volatile.LoadUint32(&o.CH1_CC.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH1_CC_A() uint32 {
	return volatile.LoadUint32(&o.CH1_CC.Reg) & 0xffff
}

// PWM.CH1_TOP: Counter wrap value
func (o *PWM_Type) SetCH1_TOP(value uint32) {
	volatile.StoreUint32(&o.CH1_TOP.Reg, volatile.LoadUint32(&o.CH1_TOP.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH1_TOP() uint32 {
	return volatile.LoadUint32(&o.CH1_TOP.Reg) & 0xffff
}

// PWM.CH2_CSR: Control and status register
func (o *PWM_Type) SetCH2_CSR_PH_ADV(value uint32) {
	volatile.StoreUint32(&o.CH2_CSR.Reg, volatile.LoadUint32(&o.CH2_CSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetCH2_CSR_PH_ADV() uint32 {
	return (volatile.LoadUint32(&o.CH2_CSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetCH2_CSR_PH_RET(value uint32) {
	volatile.StoreUint32(&o.CH2_CSR.Reg, volatile.LoadUint32(&o.CH2_CSR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetCH2_CSR_PH_RET() uint32 {
	return (volatile.LoadUint32(&o.CH2_CSR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetCH2_CSR_DIVMODE(value uint32) {
	volatile.StoreUint32(&o.CH2_CSR.Reg, volatile.LoadUint32(&o.CH2_CSR.Reg)&^(0x30)|value<<4)
}
func (o *PWM_Type) GetCH2_CSR_DIVMODE() uint32 {
	return (volatile.LoadUint32(&o.CH2_CSR.Reg) & 0x30) >> 4
}
func (o *PWM_Type) SetCH2_CSR_B_INV(value uint32) {
	volatile.StoreUint32(&o.CH2_CSR.Reg, volatile.LoadUint32(&o.CH2_CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCH2_CSR_B_INV() uint32 {
	return (volatile.LoadUint32(&o.CH2_CSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCH2_CSR_A_INV(value uint32) {
	volatile.StoreUint32(&o.CH2_CSR.Reg, volatile.LoadUint32(&o.CH2_CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCH2_CSR_A_INV() uint32 {
	return (volatile.LoadUint32(&o.CH2_CSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCH2_CSR_PH_CORRECT(value uint32) {
	volatile.StoreUint32(&o.CH2_CSR.Reg, volatile.LoadUint32(&o.CH2_CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetCH2_CSR_PH_CORRECT() uint32 {
	return (volatile.LoadUint32(&o.CH2_CSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetCH2_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.CH2_CSR.Reg, volatile.LoadUint32(&o.CH2_CSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCH2_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.CH2_CSR.Reg) & 0x1
}

// PWM.CH2_DIV
// INT and FRAC form a fixed-point fractional number.
// Counting rate is system clock frequency divided by this number.
// Fractional division uses simple 1st-order sigma-delta.
func (o *PWM_Type) SetCH2_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CH2_DIV.Reg, volatile.LoadUint32(&o.CH2_DIV.Reg)&^(0xff0)|value<<4)
}
func (o *PWM_Type) GetCH2_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CH2_DIV.Reg) & 0xff0) >> 4
}
func (o *PWM_Type) SetCH2_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CH2_DIV.Reg, volatile.LoadUint32(&o.CH2_DIV.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCH2_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CH2_DIV.Reg) & 0xf
}

// PWM.CH2_CTR: Direct access to the PWM counter
func (o *PWM_Type) SetCH2_CTR(value uint32) {
	volatile.StoreUint32(&o.CH2_CTR.Reg, volatile.LoadUint32(&o.CH2_CTR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH2_CTR() uint32 {
	return volatile.LoadUint32(&o.CH2_CTR.Reg) & 0xffff
}

// PWM.CH2_CC: Counter compare values
func (o *PWM_Type) SetCH2_CC_B(value uint32) {
	volatile.StoreUint32(&o.CH2_CC.Reg, volatile.LoadUint32(&o.CH2_CC.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetCH2_CC_B() uint32 {
	return (volatile.LoadUint32(&o.CH2_CC.Reg) & 0xffff0000) >> 16
}
func (o *PWM_Type) SetCH2_CC_A(value uint32) {
	volatile.StoreUint32(&o.CH2_CC.Reg, volatile.LoadUint32(&o.CH2_CC.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH2_CC_A() uint32 {
	return volatile.LoadUint32(&o.CH2_CC.Reg) & 0xffff
}

// PWM.CH2_TOP: Counter wrap value
func (o *PWM_Type) SetCH2_TOP(value uint32) {
	volatile.StoreUint32(&o.CH2_TOP.Reg, volatile.LoadUint32(&o.CH2_TOP.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH2_TOP() uint32 {
	return volatile.LoadUint32(&o.CH2_TOP.Reg) & 0xffff
}

// PWM.CH3_CSR: Control and status register
func (o *PWM_Type) SetCH3_CSR_PH_ADV(value uint32) {
	volatile.StoreUint32(&o.CH3_CSR.Reg, volatile.LoadUint32(&o.CH3_CSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetCH3_CSR_PH_ADV() uint32 {
	return (volatile.LoadUint32(&o.CH3_CSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetCH3_CSR_PH_RET(value uint32) {
	volatile.StoreUint32(&o.CH3_CSR.Reg, volatile.LoadUint32(&o.CH3_CSR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetCH3_CSR_PH_RET() uint32 {
	return (volatile.LoadUint32(&o.CH3_CSR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetCH3_CSR_DIVMODE(value uint32) {
	volatile.StoreUint32(&o.CH3_CSR.Reg, volatile.LoadUint32(&o.CH3_CSR.Reg)&^(0x30)|value<<4)
}
func (o *PWM_Type) GetCH3_CSR_DIVMODE() uint32 {
	return (volatile.LoadUint32(&o.CH3_CSR.Reg) & 0x30) >> 4
}
func (o *PWM_Type) SetCH3_CSR_B_INV(value uint32) {
	volatile.StoreUint32(&o.CH3_CSR.Reg, volatile.LoadUint32(&o.CH3_CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCH3_CSR_B_INV() uint32 {
	return (volatile.LoadUint32(&o.CH3_CSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCH3_CSR_A_INV(value uint32) {
	volatile.StoreUint32(&o.CH3_CSR.Reg, volatile.LoadUint32(&o.CH3_CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCH3_CSR_A_INV() uint32 {
	return (volatile.LoadUint32(&o.CH3_CSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCH3_CSR_PH_CORRECT(value uint32) {
	volatile.StoreUint32(&o.CH3_CSR.Reg, volatile.LoadUint32(&o.CH3_CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetCH3_CSR_PH_CORRECT() uint32 {
	return (volatile.LoadUint32(&o.CH3_CSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetCH3_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.CH3_CSR.Reg, volatile.LoadUint32(&o.CH3_CSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCH3_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.CH3_CSR.Reg) & 0x1
}

// PWM.CH3_DIV
// INT and FRAC form a fixed-point fractional number.
// Counting rate is system clock frequency divided by this number.
// Fractional division uses simple 1st-order sigma-delta.
func (o *PWM_Type) SetCH3_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CH3_DIV.Reg, volatile.LoadUint32(&o.CH3_DIV.Reg)&^(0xff0)|value<<4)
}
func (o *PWM_Type) GetCH3_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CH3_DIV.Reg) & 0xff0) >> 4
}
func (o *PWM_Type) SetCH3_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CH3_DIV.Reg, volatile.LoadUint32(&o.CH3_DIV.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCH3_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CH3_DIV.Reg) & 0xf
}

// PWM.CH3_CTR: Direct access to the PWM counter
func (o *PWM_Type) SetCH3_CTR(value uint32) {
	volatile.StoreUint32(&o.CH3_CTR.Reg, volatile.LoadUint32(&o.CH3_CTR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH3_CTR() uint32 {
	return volatile.LoadUint32(&o.CH3_CTR.Reg) & 0xffff
}

// PWM.CH3_CC: Counter compare values
func (o *PWM_Type) SetCH3_CC_B(value uint32) {
	volatile.StoreUint32(&o.CH3_CC.Reg, volatile.LoadUint32(&o.CH3_CC.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetCH3_CC_B() uint32 {
	return (volatile.LoadUint32(&o.CH3_CC.Reg) & 0xffff0000) >> 16
}
func (o *PWM_Type) SetCH3_CC_A(value uint32) {
	volatile.StoreUint32(&o.CH3_CC.Reg, volatile.LoadUint32(&o.CH3_CC.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH3_CC_A() uint32 {
	return volatile.LoadUint32(&o.CH3_CC.Reg) & 0xffff
}

// PWM.CH3_TOP: Counter wrap value
func (o *PWM_Type) SetCH3_TOP(value uint32) {
	volatile.StoreUint32(&o.CH3_TOP.Reg, volatile.LoadUint32(&o.CH3_TOP.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH3_TOP() uint32 {
	return volatile.LoadUint32(&o.CH3_TOP.Reg) & 0xffff
}

// PWM.CH4_CSR: Control and status register
func (o *PWM_Type) SetCH4_CSR_PH_ADV(value uint32) {
	volatile.StoreUint32(&o.CH4_CSR.Reg, volatile.LoadUint32(&o.CH4_CSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetCH4_CSR_PH_ADV() uint32 {
	return (volatile.LoadUint32(&o.CH4_CSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetCH4_CSR_PH_RET(value uint32) {
	volatile.StoreUint32(&o.CH4_CSR.Reg, volatile.LoadUint32(&o.CH4_CSR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetCH4_CSR_PH_RET() uint32 {
	return (volatile.LoadUint32(&o.CH4_CSR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetCH4_CSR_DIVMODE(value uint32) {
	volatile.StoreUint32(&o.CH4_CSR.Reg, volatile.LoadUint32(&o.CH4_CSR.Reg)&^(0x30)|value<<4)
}
func (o *PWM_Type) GetCH4_CSR_DIVMODE() uint32 {
	return (volatile.LoadUint32(&o.CH4_CSR.Reg) & 0x30) >> 4
}
func (o *PWM_Type) SetCH4_CSR_B_INV(value uint32) {
	volatile.StoreUint32(&o.CH4_CSR.Reg, volatile.LoadUint32(&o.CH4_CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCH4_CSR_B_INV() uint32 {
	return (volatile.LoadUint32(&o.CH4_CSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCH4_CSR_A_INV(value uint32) {
	volatile.StoreUint32(&o.CH4_CSR.Reg, volatile.LoadUint32(&o.CH4_CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCH4_CSR_A_INV() uint32 {
	return (volatile.LoadUint32(&o.CH4_CSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCH4_CSR_PH_CORRECT(value uint32) {
	volatile.StoreUint32(&o.CH4_CSR.Reg, volatile.LoadUint32(&o.CH4_CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetCH4_CSR_PH_CORRECT() uint32 {
	return (volatile.LoadUint32(&o.CH4_CSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetCH4_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.CH4_CSR.Reg, volatile.LoadUint32(&o.CH4_CSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCH4_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.CH4_CSR.Reg) & 0x1
}

// PWM.CH4_DIV
// INT and FRAC form a fixed-point fractional number.
// Counting rate is system clock frequency divided by this number.
// Fractional division uses simple 1st-order sigma-delta.
func (o *PWM_Type) SetCH4_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CH4_DIV.Reg, volatile.LoadUint32(&o.CH4_DIV.Reg)&^(0xff0)|value<<4)
}
func (o *PWM_Type) GetCH4_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CH4_DIV.Reg) & 0xff0) >> 4
}
func (o *PWM_Type) SetCH4_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CH4_DIV.Reg, volatile.LoadUint32(&o.CH4_DIV.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCH4_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CH4_DIV.Reg) & 0xf
}

// PWM.CH4_CTR: Direct access to the PWM counter
func (o *PWM_Type) SetCH4_CTR(value uint32) {
	volatile.StoreUint32(&o.CH4_CTR.Reg, volatile.LoadUint32(&o.CH4_CTR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH4_CTR() uint32 {
	return volatile.LoadUint32(&o.CH4_CTR.Reg) & 0xffff
}

// PWM.CH4_CC: Counter compare values
func (o *PWM_Type) SetCH4_CC_B(value uint32) {
	volatile.StoreUint32(&o.CH4_CC.Reg, volatile.LoadUint32(&o.CH4_CC.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetCH4_CC_B() uint32 {
	return (volatile.LoadUint32(&o.CH4_CC.Reg) & 0xffff0000) >> 16
}
func (o *PWM_Type) SetCH4_CC_A(value uint32) {
	volatile.StoreUint32(&o.CH4_CC.Reg, volatile.LoadUint32(&o.CH4_CC.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH4_CC_A() uint32 {
	return volatile.LoadUint32(&o.CH4_CC.Reg) & 0xffff
}

// PWM.CH4_TOP: Counter wrap value
func (o *PWM_Type) SetCH4_TOP(value uint32) {
	volatile.StoreUint32(&o.CH4_TOP.Reg, volatile.LoadUint32(&o.CH4_TOP.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH4_TOP() uint32 {
	return volatile.LoadUint32(&o.CH4_TOP.Reg) & 0xffff
}

// PWM.CH5_CSR: Control and status register
func (o *PWM_Type) SetCH5_CSR_PH_ADV(value uint32) {
	volatile.StoreUint32(&o.CH5_CSR.Reg, volatile.LoadUint32(&o.CH5_CSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetCH5_CSR_PH_ADV() uint32 {
	return (volatile.LoadUint32(&o.CH5_CSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetCH5_CSR_PH_RET(value uint32) {
	volatile.StoreUint32(&o.CH5_CSR.Reg, volatile.LoadUint32(&o.CH5_CSR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetCH5_CSR_PH_RET() uint32 {
	return (volatile.LoadUint32(&o.CH5_CSR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetCH5_CSR_DIVMODE(value uint32) {
	volatile.StoreUint32(&o.CH5_CSR.Reg, volatile.LoadUint32(&o.CH5_CSR.Reg)&^(0x30)|value<<4)
}
func (o *PWM_Type) GetCH5_CSR_DIVMODE() uint32 {
	return (volatile.LoadUint32(&o.CH5_CSR.Reg) & 0x30) >> 4
}
func (o *PWM_Type) SetCH5_CSR_B_INV(value uint32) {
	volatile.StoreUint32(&o.CH5_CSR.Reg, volatile.LoadUint32(&o.CH5_CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCH5_CSR_B_INV() uint32 {
	return (volatile.LoadUint32(&o.CH5_CSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCH5_CSR_A_INV(value uint32) {
	volatile.StoreUint32(&o.CH5_CSR.Reg, volatile.LoadUint32(&o.CH5_CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCH5_CSR_A_INV() uint32 {
	return (volatile.LoadUint32(&o.CH5_CSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCH5_CSR_PH_CORRECT(value uint32) {
	volatile.StoreUint32(&o.CH5_CSR.Reg, volatile.LoadUint32(&o.CH5_CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetCH5_CSR_PH_CORRECT() uint32 {
	return (volatile.LoadUint32(&o.CH5_CSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetCH5_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.CH5_CSR.Reg, volatile.LoadUint32(&o.CH5_CSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCH5_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.CH5_CSR.Reg) & 0x1
}

// PWM.CH5_DIV
// INT and FRAC form a fixed-point fractional number.
// Counting rate is system clock frequency divided by this number.
// Fractional division uses simple 1st-order sigma-delta.
func (o *PWM_Type) SetCH5_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CH5_DIV.Reg, volatile.LoadUint32(&o.CH5_DIV.Reg)&^(0xff0)|value<<4)
}
func (o *PWM_Type) GetCH5_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CH5_DIV.Reg) & 0xff0) >> 4
}
func (o *PWM_Type) SetCH5_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CH5_DIV.Reg, volatile.LoadUint32(&o.CH5_DIV.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCH5_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CH5_DIV.Reg) & 0xf
}

// PWM.CH5_CTR: Direct access to the PWM counter
func (o *PWM_Type) SetCH5_CTR(value uint32) {
	volatile.StoreUint32(&o.CH5_CTR.Reg, volatile.LoadUint32(&o.CH5_CTR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH5_CTR() uint32 {
	return volatile.LoadUint32(&o.CH5_CTR.Reg) & 0xffff
}

// PWM.CH5_CC: Counter compare values
func (o *PWM_Type) SetCH5_CC_B(value uint32) {
	volatile.StoreUint32(&o.CH5_CC.Reg, volatile.LoadUint32(&o.CH5_CC.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetCH5_CC_B() uint32 {
	return (volatile.LoadUint32(&o.CH5_CC.Reg) & 0xffff0000) >> 16
}
func (o *PWM_Type) SetCH5_CC_A(value uint32) {
	volatile.StoreUint32(&o.CH5_CC.Reg, volatile.LoadUint32(&o.CH5_CC.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH5_CC_A() uint32 {
	return volatile.LoadUint32(&o.CH5_CC.Reg) & 0xffff
}

// PWM.CH5_TOP: Counter wrap value
func (o *PWM_Type) SetCH5_TOP(value uint32) {
	volatile.StoreUint32(&o.CH5_TOP.Reg, volatile.LoadUint32(&o.CH5_TOP.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH5_TOP() uint32 {
	return volatile.LoadUint32(&o.CH5_TOP.Reg) & 0xffff
}

// PWM.CH6_CSR: Control and status register
func (o *PWM_Type) SetCH6_CSR_PH_ADV(value uint32) {
	volatile.StoreUint32(&o.CH6_CSR.Reg, volatile.LoadUint32(&o.CH6_CSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetCH6_CSR_PH_ADV() uint32 {
	return (volatile.LoadUint32(&o.CH6_CSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetCH6_CSR_PH_RET(value uint32) {
	volatile.StoreUint32(&o.CH6_CSR.Reg, volatile.LoadUint32(&o.CH6_CSR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetCH6_CSR_PH_RET() uint32 {
	return (volatile.LoadUint32(&o.CH6_CSR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetCH6_CSR_DIVMODE(value uint32) {
	volatile.StoreUint32(&o.CH6_CSR.Reg, volatile.LoadUint32(&o.CH6_CSR.Reg)&^(0x30)|value<<4)
}
func (o *PWM_Type) GetCH6_CSR_DIVMODE() uint32 {
	return (volatile.LoadUint32(&o.CH6_CSR.Reg) & 0x30) >> 4
}
func (o *PWM_Type) SetCH6_CSR_B_INV(value uint32) {
	volatile.StoreUint32(&o.CH6_CSR.Reg, volatile.LoadUint32(&o.CH6_CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCH6_CSR_B_INV() uint32 {
	return (volatile.LoadUint32(&o.CH6_CSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCH6_CSR_A_INV(value uint32) {
	volatile.StoreUint32(&o.CH6_CSR.Reg, volatile.LoadUint32(&o.CH6_CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCH6_CSR_A_INV() uint32 {
	return (volatile.LoadUint32(&o.CH6_CSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCH6_CSR_PH_CORRECT(value uint32) {
	volatile.StoreUint32(&o.CH6_CSR.Reg, volatile.LoadUint32(&o.CH6_CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetCH6_CSR_PH_CORRECT() uint32 {
	return (volatile.LoadUint32(&o.CH6_CSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetCH6_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.CH6_CSR.Reg, volatile.LoadUint32(&o.CH6_CSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCH6_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.CH6_CSR.Reg) & 0x1
}

// PWM.CH6_DIV
// INT and FRAC form a fixed-point fractional number.
// Counting rate is system clock frequency divided by this number.
// Fractional division uses simple 1st-order sigma-delta.
func (o *PWM_Type) SetCH6_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CH6_DIV.Reg, volatile.LoadUint32(&o.CH6_DIV.Reg)&^(0xff0)|value<<4)
}
func (o *PWM_Type) GetCH6_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CH6_DIV.Reg) & 0xff0) >> 4
}
func (o *PWM_Type) SetCH6_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CH6_DIV.Reg, volatile.LoadUint32(&o.CH6_DIV.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCH6_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CH6_DIV.Reg) & 0xf
}

// PWM.CH6_CTR: Direct access to the PWM counter
func (o *PWM_Type) SetCH6_CTR(value uint32) {
	volatile.StoreUint32(&o.CH6_CTR.Reg, volatile.LoadUint32(&o.CH6_CTR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH6_CTR() uint32 {
	return volatile.LoadUint32(&o.CH6_CTR.Reg) & 0xffff
}

// PWM.CH6_CC: Counter compare values
func (o *PWM_Type) SetCH6_CC_B(value uint32) {
	volatile.StoreUint32(&o.CH6_CC.Reg, volatile.LoadUint32(&o.CH6_CC.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetCH6_CC_B() uint32 {
	return (volatile.LoadUint32(&o.CH6_CC.Reg) & 0xffff0000) >> 16
}
func (o *PWM_Type) SetCH6_CC_A(value uint32) {
	volatile.StoreUint32(&o.CH6_CC.Reg, volatile.LoadUint32(&o.CH6_CC.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH6_CC_A() uint32 {
	return volatile.LoadUint32(&o.CH6_CC.Reg) & 0xffff
}

// PWM.CH6_TOP: Counter wrap value
func (o *PWM_Type) SetCH6_TOP(value uint32) {
	volatile.StoreUint32(&o.CH6_TOP.Reg, volatile.LoadUint32(&o.CH6_TOP.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH6_TOP() uint32 {
	return volatile.LoadUint32(&o.CH6_TOP.Reg) & 0xffff
}

// PWM.CH7_CSR: Control and status register
func (o *PWM_Type) SetCH7_CSR_PH_ADV(value uint32) {
	volatile.StoreUint32(&o.CH7_CSR.Reg, volatile.LoadUint32(&o.CH7_CSR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetCH7_CSR_PH_ADV() uint32 {
	return (volatile.LoadUint32(&o.CH7_CSR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetCH7_CSR_PH_RET(value uint32) {
	volatile.StoreUint32(&o.CH7_CSR.Reg, volatile.LoadUint32(&o.CH7_CSR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetCH7_CSR_PH_RET() uint32 {
	return (volatile.LoadUint32(&o.CH7_CSR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetCH7_CSR_DIVMODE(value uint32) {
	volatile.StoreUint32(&o.CH7_CSR.Reg, volatile.LoadUint32(&o.CH7_CSR.Reg)&^(0x30)|value<<4)
}
func (o *PWM_Type) GetCH7_CSR_DIVMODE() uint32 {
	return (volatile.LoadUint32(&o.CH7_CSR.Reg) & 0x30) >> 4
}
func (o *PWM_Type) SetCH7_CSR_B_INV(value uint32) {
	volatile.StoreUint32(&o.CH7_CSR.Reg, volatile.LoadUint32(&o.CH7_CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCH7_CSR_B_INV() uint32 {
	return (volatile.LoadUint32(&o.CH7_CSR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCH7_CSR_A_INV(value uint32) {
	volatile.StoreUint32(&o.CH7_CSR.Reg, volatile.LoadUint32(&o.CH7_CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCH7_CSR_A_INV() uint32 {
	return (volatile.LoadUint32(&o.CH7_CSR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCH7_CSR_PH_CORRECT(value uint32) {
	volatile.StoreUint32(&o.CH7_CSR.Reg, volatile.LoadUint32(&o.CH7_CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetCH7_CSR_PH_CORRECT() uint32 {
	return (volatile.LoadUint32(&o.CH7_CSR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetCH7_CSR_EN(value uint32) {
	volatile.StoreUint32(&o.CH7_CSR.Reg, volatile.LoadUint32(&o.CH7_CSR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCH7_CSR_EN() uint32 {
	return volatile.LoadUint32(&o.CH7_CSR.Reg) & 0x1
}

// PWM.CH7_DIV
// INT and FRAC form a fixed-point fractional number.
// Counting rate is system clock frequency divided by this number.
// Fractional division uses simple 1st-order sigma-delta.
func (o *PWM_Type) SetCH7_DIV_INT(value uint32) {
	volatile.StoreUint32(&o.CH7_DIV.Reg, volatile.LoadUint32(&o.CH7_DIV.Reg)&^(0xff0)|value<<4)
}
func (o *PWM_Type) GetCH7_DIV_INT() uint32 {
	return (volatile.LoadUint32(&o.CH7_DIV.Reg) & 0xff0) >> 4
}
func (o *PWM_Type) SetCH7_DIV_FRAC(value uint32) {
	volatile.StoreUint32(&o.CH7_DIV.Reg, volatile.LoadUint32(&o.CH7_DIV.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCH7_DIV_FRAC() uint32 {
	return volatile.LoadUint32(&o.CH7_DIV.Reg) & 0xf
}

// PWM.CH7_CTR: Direct access to the PWM counter
func (o *PWM_Type) SetCH7_CTR(value uint32) {
	volatile.StoreUint32(&o.CH7_CTR.Reg, volatile.LoadUint32(&o.CH7_CTR.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH7_CTR() uint32 {
	return volatile.LoadUint32(&o.CH7_CTR.Reg) & 0xffff
}

// PWM.CH7_CC: Counter compare values
func (o *PWM_Type) SetCH7_CC_B(value uint32) {
	volatile.StoreUint32(&o.CH7_CC.Reg, volatile.LoadUint32(&o.CH7_CC.Reg)&^(0xffff0000)|value<<16)
}
func (o *PWM_Type) GetCH7_CC_B() uint32 {
	return (volatile.LoadUint32(&o.CH7_CC.Reg) & 0xffff0000) >> 16
}
func (o *PWM_Type) SetCH7_CC_A(value uint32) {
	volatile.StoreUint32(&o.CH7_CC.Reg, volatile.LoadUint32(&o.CH7_CC.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH7_CC_A() uint32 {
	return volatile.LoadUint32(&o.CH7_CC.Reg) & 0xffff
}

// PWM.CH7_TOP: Counter wrap value
func (o *PWM_Type) SetCH7_TOP(value uint32) {
	volatile.StoreUint32(&o.CH7_TOP.Reg, volatile.LoadUint32(&o.CH7_TOP.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetCH7_TOP() uint32 {
	return volatile.LoadUint32(&o.CH7_TOP.Reg) & 0xffff
}

// PWM.EN
// This register aliases the CSR_EN bits for all channels.
// Writing to this register allows multiple channels to be enabled
// or disabled simultaneously, so they can run in perfect sync.
// For each channel, there is only one physical EN register bit,
// which can be accessed through here or CHx_CSR.
func (o *PWM_Type) SetEN_CH7(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetEN_CH7() uint32 {
	return (volatile.LoadUint32(&o.EN.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetEN_CH6(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetEN_CH6() uint32 {
	return (volatile.LoadUint32(&o.EN.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetEN_CH5(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetEN_CH5() uint32 {
	return (volatile.LoadUint32(&o.EN.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetEN_CH4(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetEN_CH4() uint32 {
	return (volatile.LoadUint32(&o.EN.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetEN_CH3(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetEN_CH3() uint32 {
	return (volatile.LoadUint32(&o.EN.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetEN_CH2(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetEN_CH2() uint32 {
	return (volatile.LoadUint32(&o.EN.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetEN_CH1(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetEN_CH1() uint32 {
	return (volatile.LoadUint32(&o.EN.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetEN_CH0(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEN_CH0() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0x1
}

// PWM.INTR: Raw Interrupts
func (o *PWM_Type) SetINTR_CH7(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTR_CH7() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetINTR_CH6(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTR_CH6() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTR_CH5(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTR_CH5() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTR_CH4(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTR_CH4() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTR_CH3(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTR_CH3() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTR_CH2(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTR_CH2() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTR_CH1(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTR_CH1() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTR_CH0(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetINTR_CH0() uint32 {
	return volatile.LoadUint32(&o.INTR.Reg) & 0x1
}

// PWM.INTE: Interrupt Enable
func (o *PWM_Type) SetINTE_CH7(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTE_CH7() uint32 {
	return (volatile.LoadUint32(&o.INTE.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetINTE_CH6(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTE_CH6() uint32 {
	return (volatile.LoadUint32(&o.INTE.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTE_CH5(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTE_CH5() uint32 {
	return (volatile.LoadUint32(&o.INTE.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTE_CH4(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTE_CH4() uint32 {
	return (volatile.LoadUint32(&o.INTE.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTE_CH3(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTE_CH3() uint32 {
	return (volatile.LoadUint32(&o.INTE.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTE_CH2(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTE_CH2() uint32 {
	return (volatile.LoadUint32(&o.INTE.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTE_CH1(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTE_CH1() uint32 {
	return (volatile.LoadUint32(&o.INTE.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTE_CH0(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetINTE_CH0() uint32 {
	return volatile.LoadUint32(&o.INTE.Reg) & 0x1
}

// PWM.INTF: Interrupt Force
func (o *PWM_Type) SetINTF_CH7(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTF_CH7() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetINTF_CH6(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTF_CH6() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTF_CH5(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTF_CH5() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTF_CH4(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTF_CH4() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTF_CH3(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTF_CH3() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTF_CH2(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTF_CH2() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTF_CH1(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTF_CH1() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTF_CH0(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetINTF_CH0() uint32 {
	return volatile.LoadUint32(&o.INTF.Reg) & 0x1
}

// PWM.INTS: Interrupt status after masking & forcing
func (o *PWM_Type) SetINTS_CH7(value uint32) {
	volatile.StoreUint32(&o.INTS.Reg, volatile.LoadUint32(&o.INTS.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTS_CH7() uint32 {
	return (volatile.LoadUint32(&o.INTS.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetINTS_CH6(value uint32) {
	volatile.StoreUint32(&o.INTS.Reg, volatile.LoadUint32(&o.INTS.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTS_CH6() uint32 {
	return (volatile.LoadUint32(&o.INTS.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTS_CH5(value uint32) {
	volatile.StoreUint32(&o.INTS.Reg, volatile.LoadUint32(&o.INTS.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTS_CH5() uint32 {
	return (volatile.LoadUint32(&o.INTS.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTS_CH4(value uint32) {
	volatile.StoreUint32(&o.INTS.Reg, volatile.LoadUint32(&o.INTS.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTS_CH4() uint32 {
	return (volatile.LoadUint32(&o.INTS.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTS_CH3(value uint32) {
	volatile.StoreUint32(&o.INTS.Reg, volatile.LoadUint32(&o.INTS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTS_CH3() uint32 {
	return (volatile.LoadUint32(&o.INTS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTS_CH2(value uint32) {
	volatile.StoreUint32(&o.INTS.Reg, volatile.LoadUint32(&o.INTS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTS_CH2() uint32 {
	return (volatile.LoadUint32(&o.INTS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTS_CH1(value uint32) {
	volatile.StoreUint32(&o.INTS.Reg, volatile.LoadUint32(&o.INTS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTS_CH1() uint32 {
	return (volatile.LoadUint32(&o.INTS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTS_CH0(value uint32) {
	volatile.StoreUint32(&o.INTS.Reg, volatile.LoadUint32(&o.INTS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetINTS_CH0() uint32 {
	return volatile.LoadUint32(&o.INTS.Reg) & 0x1
}

// Controls time and alarms
// time is a 64 bit value indicating the time in usec since power-on
// timeh is the top 32 bits of time & timel is the bottom 32 bits
// to change time write to timelw before timehw
// to read time read from timelr before timehr
// An alarm is set by setting alarm_enable and writing to the corresponding alarm register
// When an alarm is pending, the corresponding alarm_running signal will be high
// An alarm can be cancelled before it has finished by clearing the alarm_enable
// When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared
// To clear the interrupt write a 1 to the corresponding alarm_irq
type TIMER_Type struct {
	TIMEHW   volatile.Register32 // 0x0
	TIMELW   volatile.Register32 // 0x4
	TIMEHR   volatile.Register32 // 0x8
	TIMELR   volatile.Register32 // 0xC
	ALARM0   volatile.Register32 // 0x10
	ALARM1   volatile.Register32 // 0x14
	ALARM2   volatile.Register32 // 0x18
	ALARM3   volatile.Register32 // 0x1C
	ARMED    volatile.Register32 // 0x20
	TIMERAWH volatile.Register32 // 0x24
	TIMERAWL volatile.Register32 // 0x28
	DBGPAUSE volatile.Register32 // 0x2C
	PAUSE    volatile.Register32 // 0x30
	INTR     volatile.Register32 // 0x34
	INTE     volatile.Register32 // 0x38
	INTF     volatile.Register32 // 0x3C
	INTS     volatile.Register32 // 0x40
}

// TIMER.ARMED
// Indicates the armed/disarmed status of each alarm.
// A write to the corresponding ALARMx register arms the alarm.
// Alarms automatically disarm upon firing, but writing ones here
// will disarm immediately without waiting to fire.
func (o *TIMER_Type) SetARMED(value uint32) {
	volatile.StoreUint32(&o.ARMED.Reg, volatile.LoadUint32(&o.ARMED.Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetARMED() uint32 {
	return volatile.LoadUint32(&o.ARMED.Reg) & 0xf
}

// TIMER.DBGPAUSE: Set bits high to enable pause when the corresponding debug ports are active
func (o *TIMER_Type) SetDBGPAUSE_DBG1(value uint32) {
	volatile.StoreUint32(&o.DBGPAUSE.Reg, volatile.LoadUint32(&o.DBGPAUSE.Reg)&^(0x4)|value<<2)
}
func (o *TIMER_Type) GetDBGPAUSE_DBG1() uint32 {
	return (volatile.LoadUint32(&o.DBGPAUSE.Reg) & 0x4) >> 2
}
func (o *TIMER_Type) SetDBGPAUSE_DBG0(value uint32) {
	volatile.StoreUint32(&o.DBGPAUSE.Reg, volatile.LoadUint32(&o.DBGPAUSE.Reg)&^(0x2)|value<<1)
}
func (o *TIMER_Type) GetDBGPAUSE_DBG0() uint32 {
	return (volatile.LoadUint32(&o.DBGPAUSE.Reg) & 0x2) >> 1
}

// TIMER.PAUSE: Set high to pause the timer
func (o *TIMER_Type) SetPAUSE(value uint32) {
	volatile.StoreUint32(&o.PAUSE.Reg, volatile.LoadUint32(&o.PAUSE.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetPAUSE() uint32 {
	return volatile.LoadUint32(&o.PAUSE.Reg) & 0x1
}

// TIMER.INTR: Raw Interrupts
func (o *TIMER_Type) SetINTR_ALARM_3(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x8)|value<<3)
}
func (o *TIMER_Type) GetINTR_ALARM_3() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x8) >> 3
}
func (o *TIMER_Type) SetINTR_ALARM_2(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x4)|value<<2)
}
func (o *TIMER_Type) GetINTR_ALARM_2() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x4) >> 2
}
func (o *TIMER_Type) SetINTR_ALARM_1(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x2)|value<<1)
}
func (o *TIMER_Type) GetINTR_ALARM_1() uint32 {
	return (volatile.LoadUint32(&o.INTR.Reg) & 0x2) >> 1
}
func (o *TIMER_Type) SetINTR_ALARM_0(value uint32) {
	volatile.StoreUint32(&o.INTR.Reg, volatile.LoadUint32(&o.INTR.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetINTR_ALARM_0() uint32 {
	return volatile.LoadUint32(&o.INTR.Reg) & 0x1
}

// TIMER.INTE: Interrupt Enable
func (o *TIMER_Type) SetINTE_ALARM_3(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x8)|value<<3)
}
func (o *TIMER_Type) GetINTE_ALARM_3() uint32 {
	return (volatile.LoadUint32(&o.INTE.Reg) & 0x8) >> 3
}
func (o *TIMER_Type) SetINTE_ALARM_2(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x4)|value<<2)
}
func (o *TIMER_Type) GetINTE_ALARM_2() uint32 {
	return (volatile.LoadUint32(&o.INTE.Reg) & 0x4) >> 2
}
func (o *TIMER_Type) SetINTE_ALARM_1(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x2)|value<<1)
}
func (o *TIMER_Type) GetINTE_ALARM_1() uint32 {
	return (volatile.LoadUint32(&o.INTE.Reg) & 0x2) >> 1
}
func (o *TIMER_Type) SetINTE_ALARM_0(value uint32) {
	volatile.StoreUint32(&o.INTE.Reg, volatile.LoadUint32(&o.INTE.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetINTE_ALARM_0() uint32 {
	return volatile.LoadUint32(&o.INTE.Reg) & 0x1
}

// TIMER.INTF: Interrupt Force
func (o *TIMER_Type) SetINTF_ALARM_3(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x8)|value<<3)
}
func (o *TIMER_Type) GetINTF_ALARM_3() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x8) >> 3
}
func (o *TIMER_Type) SetINTF_ALARM_2(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x4)|value<<2)
}
func (o *TIMER_Type) GetINTF_ALARM_2() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x4) >> 2
}
func (o *TIMER_Type) SetINTF_ALARM_1(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x2)|value<<1)
}
func (o *TIMER_Type) GetINTF_ALARM_1() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x2) >> 1
}
func (o *TIMER_Type) SetINTF_ALARM_0(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetINTF_ALARM_0() uint32 {
	return volatile.LoadUint32(&o.INTF.Reg) & 0x1
}

// TIMER.INTS: Interrupt status after masking & forcing
func (o *TIMER_Type) SetINTS_ALARM_3(value uint32) {
	volatile.StoreUint32