/* math-converter.c generated by valac 0.56.1, the Vala compiler
 * generated from math-converter.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "calculator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
typedef struct _MathConverterPrivate MathConverterPrivate;
enum  {
	MATH_CONVERTER_0_PROPERTY,
	MATH_CONVERTER_OUTER_BOX_VISIBLE_PROPERTY,
	MATH_CONVERTER_VIEW_MORE_VISIBLE_PROPERTY,
	MATH_CONVERTER_VIEW_MORE_ACTIVE_PROPERTY,
	MATH_CONVERTER_NUM_PROPERTIES
};
static GParamSpec* math_converter_properties[MATH_CONVERTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_expression_unref0(var) ((var == NULL) ? NULL : (var = (gtk_expression_unref (var), NULL)))
enum  {
	MATH_CONVERTER_CHANGED_SIGNAL,
	MATH_CONVERTER_NUM_SIGNALS
};
static guint math_converter_signals[MATH_CONVERTER_NUM_SIGNALS] = {0};

struct _MathConverter {
	GtkGrid parent_instance;
	MathConverterPrivate * priv;
};

struct _MathConverterClass {
	GtkGridClass parent_class;
};

struct _MathConverterPrivate {
	MathEquation* equation;
	gchar* category;
	gboolean single_category;
	GtkDropDown* category_combo;
	GtkDropDown* from_combo;
	GtkDropDown* to_combo;
	GtkLabel* from_label;
	GtkLabel* to_label;
	gboolean _outer_box_visible;
	gboolean _view_more_visible;
	gboolean _view_more_active;
};

static gint MathConverter_private_offset;
static gpointer math_converter_parent_class = NULL;

VALA_EXTERN GType math_converter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathConverter, g_object_unref)
VALA_EXTERN MathConverter* math_converter_new (MathEquation* equation);
VALA_EXTERN MathConverter* math_converter_construct (GType object_type,
                                         MathEquation* equation);
VALA_EXTERN void math_converter_set_equation (MathConverter* self,
                                  MathEquation* equation);
static void __lambda10_ (MathConverter* self,
                  GParamSpec* pspec);
static void math_converter_update_result_label (MathConverter* self);
static void ___lambda10__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void math_converter_build_category_model (MathConverter* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN void math_converter_set_category (MathConverter* self,
                                  const gchar* category);
VALA_EXTERN gchar* math_converter_get_category (MathConverter* self);
VALA_EXTERN void math_converter_set_conversion (MathConverter* self,
                                    const gchar* unit_a,
                                    const gchar* unit_b);
static gboolean math_converter_set_active_unit (MathConverter* self,
                                         GtkDropDown* combo,
                                         Unit* unit);
VALA_EXTERN void math_converter_get_conversion (MathConverter* self,
                                    Unit** from_unit,
                                    Unit** to_unit);
static void math_converter_update_visibility (MathConverter* self);
VALA_EXTERN void math_converter_set_outer_box_visible (MathConverter* self,
                                           gboolean value);
static Number* math_converter_convert_equation (MathConverter* self,
                                         Number* x,
                                         Unit** source_unit,
                                         Unit** target_unit);
static void math_converter_build_units_model (MathConverter* self);
static void math_converter_category_combobox_changed_cb (MathConverter* self);
static void _math_converter_category_combobox_changed_cb_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void math_converter_to_combobox_changed_cb (MathConverter* self);
static void _math_converter_to_combobox_changed_cb_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void math_converter_swap_button_clicked_cb (MathConverter* self);
static void _math_converter_swap_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void math_converter_do_convert (MathConverter* self,
                                Unit** from_unit,
                                Unit** to_unit);
static void math_converter_convert_button_clicked_cb (MathConverter* self);
static void _math_converter_convert_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
VALA_EXTERN gboolean math_converter_get_outer_box_visible (MathConverter* self);
VALA_EXTERN gboolean math_converter_get_view_more_visible (MathConverter* self);
VALA_EXTERN void math_converter_set_view_more_visible (MathConverter* self,
                                           gboolean value);
VALA_EXTERN gboolean math_converter_get_view_more_active (MathConverter* self);
VALA_EXTERN void math_converter_set_view_more_active (MathConverter* self,
                                          gboolean value);
static GObject * math_converter_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _math_converter___lambda11_ (MathConverter* self);
static void __math_converter___lambda11__currency_manager_updated (CurrencyManager* _sender,
                                                            gpointer self);
static void math_converter_finalize (GObject * obj);
static GType math_converter_get_type_once (void);
static void _vala_math_converter_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_math_converter_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
math_converter_get_instance_private (MathConverter* self)
{
	return G_STRUCT_MEMBER_P (self, MathConverter_private_offset);
}

MathConverter*
math_converter_construct (GType object_type,
                          MathEquation* equation)
{
	MathConverter * self = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathConverter*) g_object_new (object_type, NULL);
	math_converter_set_equation (self, equation);
	return self;
}

MathConverter*
math_converter_new (MathEquation* equation)
{
	return math_converter_construct (TYPE_MATH_CONVERTER, equation);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda10_ (MathConverter* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	math_converter_update_result_label (self);
}

static void
___lambda10__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda10_ ((MathConverter*) self, pspec);
}

void
math_converter_set_equation (MathConverter* self,
                             MathEquation* equation)
{
	MathEquation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (equation != NULL);
	_tmp0_ = _g_object_ref0 (equation);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp0_;
	g_signal_connect_object ((GObject*) equation, "notify::display", (GCallback) ___lambda10__g_object_notify, self, 0);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
math_converter_build_category_model (MathConverter* self)
{
	GListStore* category_model = NULL;
	GListStore* _tmp0_;
	GList* categories = NULL;
	UnitManager* _tmp1_;
	UnitManager* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GtkDropDown* _tmp9_;
	GListStore* _tmp10_;
	GtkPropertyExpression* expression = NULL;
	GtkPropertyExpression* _tmp11_;
	GtkDropDown* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_list_store_new (TYPE_UNIT_CATEGORY);
	category_model = _tmp0_;
	_tmp1_ = unit_manager_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = unit_manager_get_categories (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	categories = _tmp4_;
	_tmp5_ = categories;
	{
		GList* category_collection = NULL;
		GList* category_it = NULL;
		category_collection = _tmp5_;
		for (category_it = category_collection; category_it != NULL; category_it = category_it->next) {
			UnitCategory* _tmp6_;
			UnitCategory* category = NULL;
			_tmp6_ = _g_object_ref0 ((UnitCategory*) category_it->data);
			category = _tmp6_;
			{
				GListStore* _tmp7_;
				UnitCategory* _tmp8_;
				_tmp7_ = category_model;
				_tmp8_ = category;
				g_list_store_append (_tmp7_, (GObject*) _tmp8_);
				_g_object_unref0 (category);
			}
		}
	}
	_tmp9_ = self->priv->category_combo;
	_tmp10_ = category_model;
	gtk_drop_down_set_model (_tmp9_, (GListModel*) _tmp10_);
	_tmp11_ = (GtkPropertyExpression*) gtk_property_expression_new (TYPE_UNIT_CATEGORY, NULL, "display_name");
	expression = _tmp11_;
	_tmp12_ = self->priv->category_combo;
	gtk_drop_down_set_expression (_tmp12_, (GtkExpression*) expression);
	_gtk_expression_unref0 (expression);
	(categories == NULL) ? NULL : (categories = (_g_list_free__g_object_unref0_ (categories), NULL));
	_g_object_unref0 (category_model);
}

void
math_converter_set_category (MathConverter* self,
                             const gchar* category)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category;
	if (g_strcmp0 (_tmp0_, category) == 0) {
		return;
	}
	_tmp1_ = g_strdup (category);
	_g_free0 (self->priv->category);
	self->priv->category = _tmp1_;
	_tmp2_ = self->priv->category;
	if (_tmp2_ != NULL) {
		UnitCategory* unit_category = NULL;
		UnitManager* _tmp3_;
		UnitManager* _tmp4_;
		const gchar* _tmp5_;
		UnitCategory* _tmp6_;
		UnitCategory* _tmp7_;
		guint position = 0U;
		GListStore* model = NULL;
		GtkDropDown* _tmp8_;
		GListModel* _tmp9_;
		GListStore* _tmp10_;
		GListStore* _tmp11_;
		UnitCategory* _tmp12_;
		guint _tmp13_ = 0U;
		GtkDropDown* _tmp14_;
		self->priv->single_category = TRUE;
		_tmp3_ = unit_manager_get_default ();
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->category;
		_tmp6_ = unit_manager_get_category (_tmp4_, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp4_);
		unit_category = _tmp7_;
		position = (guint) 0;
		_tmp8_ = self->priv->category_combo;
		_tmp9_ = gtk_drop_down_get_model (_tmp8_);
		_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, g_list_store_get_type ()) ? ((GListStore*) _tmp9_) : NULL);
		model = _tmp10_;
		_tmp11_ = model;
		_tmp12_ = unit_category;
		g_list_store_find (_tmp11_, (GObject*) _tmp12_, &_tmp13_);
		position = _tmp13_;
		_tmp14_ = self->priv->category_combo;
		gtk_drop_down_set_selected (_tmp14_, position);
		_g_object_unref0 (model);
		_g_object_unref0 (unit_category);
	} else {
		GtkDropDown* _tmp15_;
		self->priv->single_category = FALSE;
		_tmp15_ = self->priv->category_combo;
		gtk_drop_down_set_selected (_tmp15_, (guint) 0);
	}
}

gchar*
math_converter_get_category (MathConverter* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->category;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
math_converter_set_conversion (MathConverter* self,
                               const gchar* unit_a,
                               const gchar* unit_b)
{
	Unit* ua = NULL;
	UnitManager* _tmp0_;
	UnitManager* _tmp1_;
	Unit* _tmp2_;
	Unit* _tmp3_;
	Unit* ub = NULL;
	UnitManager* _tmp4_;
	UnitManager* _tmp5_;
	Unit* _tmp6_;
	Unit* _tmp7_;
	gboolean _tmp8_ = FALSE;
	Unit* _tmp9_;
	GtkDropDown* _tmp12_;
	Unit* _tmp13_;
	GtkDropDown* _tmp14_;
	Unit* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unit_a != NULL);
	g_return_if_fail (unit_b != NULL);
	_tmp0_ = unit_manager_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = unit_manager_get_unit_by_name (_tmp1_, unit_a);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	ua = _tmp3_;
	_tmp4_ = unit_manager_get_default ();
	_tmp5_ = _tmp4_;
	_tmp6_ = unit_manager_get_unit_by_name (_tmp5_, unit_b);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	ub = _tmp7_;
	_tmp9_ = ua;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		Unit* _tmp10_;
		_tmp10_ = ub;
		_tmp8_ = _tmp10_ == NULL;
	}
	if (_tmp8_) {
		GtkDropDown* _tmp11_;
		_tmp11_ = self->priv->from_combo;
		gtk_drop_down_set_selected (_tmp11_, (guint) 0);
		_g_object_unref0 (ub);
		_g_object_unref0 (ua);
		return;
	}
	_tmp12_ = self->priv->from_combo;
	_tmp13_ = ua;
	math_converter_set_active_unit (self, _tmp12_, _tmp13_);
	_tmp14_ = self->priv->to_combo;
	_tmp15_ = ub;
	math_converter_set_active_unit (self, _tmp14_, _tmp15_);
	_g_object_unref0 (ub);
	_g_object_unref0 (ua);
}

void
math_converter_get_conversion (MathConverter* self,
                               Unit** from_unit,
                               Unit** to_unit)
{
	Unit* _vala_from_unit = NULL;
	Unit* _vala_to_unit = NULL;
	GtkDropDown* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	Unit* _tmp3_;
	GtkDropDown* _tmp4_;
	GObject* _tmp5_;
	GObject* _tmp6_;
	Unit* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->from_combo;
	_tmp1_ = gtk_drop_down_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_UNIT) ? ((Unit*) _tmp2_) : NULL);
	_g_object_unref0 (_vala_from_unit);
	_vala_from_unit = _tmp3_;
	_tmp4_ = self->priv->to_combo;
	_tmp5_ = gtk_drop_down_get_selected_item (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_UNIT) ? ((Unit*) _tmp6_) : NULL);
	_g_object_unref0 (_vala_to_unit);
	_vala_to_unit = _tmp7_;
	if (from_unit) {
		*from_unit = _vala_from_unit;
	} else {
		_g_object_unref0 (_vala_from_unit);
	}
	if (to_unit) {
		*to_unit = _vala_to_unit;
	} else {
		_g_object_unref0 (_vala_to_unit);
	}
}

static void
math_converter_update_visibility (MathConverter* self)
{
	GtkDropDown* _tmp0_;
	const gchar* _tmp1_;
	CurrencyManager* _tmp2_;
	CurrencyManager* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category_combo;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, !self->priv->single_category);
	_tmp1_ = self->priv->category;
	if (g_strcmp0 (_tmp1_, "currency") != 0) {
		math_converter_set_outer_box_visible (self, TRUE);
		return;
	}
	_tmp2_ = currency_manager_get_default (TRUE, TRUE);
	_tmp3_ = _tmp2_;
	_tmp4_ = currency_manager_get_loaded (_tmp3_);
	_tmp5_ = _tmp4_;
	math_converter_set_outer_box_visible (self, _tmp5_);
	_g_object_unref0 (_tmp3_);
}

static void
math_converter_update_result_label (MathConverter* self)
{
	MathEquation* _tmp0_;
	Number* x = NULL;
	MathEquation* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Unit* source_unit = NULL;
	Unit* target_unit = NULL;
	Number* z = NULL;
	Number* _tmp5_;
	Unit* _tmp6_ = NULL;
	Unit* _tmp7_ = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->equation;
	_tmp2_ = math_equation_get_number (_tmp1_);
	_tmp3_ = _tmp2_;
	x = _tmp3_;
	_tmp4_ = x;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (x);
		return;
	}
	_tmp5_ = x;
	_tmp8_ = math_converter_convert_equation (self, _tmp5_, &_tmp6_, &_tmp7_);
	_g_object_unref0 (source_unit);
	source_unit = _tmp6_;
	_g_object_unref0 (target_unit);
	target_unit = _tmp7_;
	z = _tmp8_;
	_tmp9_ = z;
	if (_tmp9_ != NULL) {
		gchar* source_text = NULL;
		Unit* _tmp10_;
		Number* _tmp11_;
		gchar* _tmp12_;
		gchar* target_text = NULL;
		Unit* _tmp13_;
		Number* _tmp14_;
		gchar* _tmp15_;
		GtkLabel* _tmp16_;
		const gchar* _tmp17_;
		GtkLabel* _tmp18_;
		const gchar* _tmp19_;
		_tmp10_ = source_unit;
		_tmp11_ = x;
		_tmp12_ = unit_format (_tmp10_, _tmp11_);
		source_text = _tmp12_;
		_tmp13_ = target_unit;
		_tmp14_ = z;
		_tmp15_ = unit_format (_tmp13_, _tmp14_);
		target_text = _tmp15_;
		_tmp16_ = self->priv->from_label;
		_tmp17_ = source_text;
		gtk_label_set_text (_tmp16_, _tmp17_);
		_tmp18_ = self->priv->to_label;
		_tmp19_ = target_text;
		gtk_label_set_text (_tmp18_, _tmp19_);
		_g_free0 (target_text);
		_g_free0 (source_text);
	}
	_g_object_unref0 (z);
	_g_object_unref0 (target_unit);
	_g_object_unref0 (source_unit);
	_g_object_unref0 (x);
}

static void
math_converter_build_units_model (MathConverter* self)
{
	GListStore* unit_model = NULL;
	GListStore* _tmp0_;
	GtkPropertyExpression* expression = NULL;
	GtkPropertyExpression* _tmp1_;
	GtkDropDown* _tmp2_;
	GtkPropertyExpression* _tmp3_;
	GtkDropDown* _tmp4_;
	GtkPropertyExpression* _tmp5_;
	UnitCategory* c = NULL;
	UnitManager* _tmp6_;
	UnitManager* _tmp7_;
	const gchar* _tmp8_;
	UnitCategory* _tmp9_;
	UnitCategory* _tmp10_;
	UnitCategory* _tmp11_;
	GList* _tmp12_;
	guint model_size = 0U;
	GListStore* _tmp16_;
	GtkDropDown* _tmp17_;
	GListStore* _tmp18_;
	GtkDropDown* _tmp19_;
	GtkDropDown* _tmp20_;
	GListStore* _tmp21_;
	GtkDropDown* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_list_store_new (TYPE_UNIT);
	unit_model = _tmp0_;
	_tmp1_ = (GtkPropertyExpression*) gtk_property_expression_new (TYPE_UNIT, NULL, "display_name");
	expression = _tmp1_;
	_tmp2_ = self->priv->from_combo;
	_tmp3_ = expression;
	gtk_drop_down_set_expression (_tmp2_, (GtkExpression*) _tmp3_);
	_tmp4_ = self->priv->to_combo;
	_tmp5_ = expression;
	gtk_drop_down_set_expression (_tmp4_, (GtkExpression*) _tmp5_);
	_tmp6_ = unit_manager_get_default ();
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->category;
	_tmp9_ = unit_manager_get_category (_tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp7_);
	c = _tmp10_;
	_tmp11_ = c;
	_tmp12_ = unit_category_get_units (_tmp11_);
	{
		GList* unit_collection = NULL;
		GList* unit_it = NULL;
		unit_collection = _tmp12_;
		for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
			Unit* _tmp13_;
			Unit* unit = NULL;
			_tmp13_ = _g_object_ref0 ((Unit*) unit_it->data);
			unit = _tmp13_;
			{
				GListStore* _tmp14_;
				Unit* _tmp15_;
				_tmp14_ = unit_model;
				_tmp15_ = unit;
				g_list_store_append (_tmp14_, (GObject*) _tmp15_);
				_g_object_unref0 (unit);
			}
		}
	}
	_tmp16_ = unit_model;
	model_size = g_list_model_get_n_items ((GListModel*) _tmp16_);
	_tmp17_ = self->priv->to_combo;
	_tmp18_ = unit_model;
	gtk_drop_down_set_model (_tmp17_, (GListModel*) _tmp18_);
	_tmp19_ = self->priv->to_combo;
	gtk_drop_down_set_enable_search (_tmp19_, model_size > ((guint) 10));
	_tmp20_ = self->priv->from_combo;
	_tmp21_ = unit_model;
	gtk_drop_down_set_model (_tmp20_, (GListModel*) _tmp21_);
	_tmp22_ = self->priv->from_combo;
	gtk_drop_down_set_enable_search (_tmp22_, model_size > ((guint) 10));
	_g_object_unref0 (c);
	_gtk_expression_unref0 (expression);
	_g_object_unref0 (unit_model);
}

static gboolean
math_converter_set_active_unit (MathConverter* self,
                                GtkDropDown* combo,
                                Unit* unit)
{
	guint position = 0U;
	GListStore* model = NULL;
	GListModel* _tmp0_;
	GListStore* _tmp1_;
	GListStore* _tmp2_;
	guint _tmp3_ = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (combo != NULL, FALSE);
	g_return_val_if_fail (unit != NULL, FALSE);
	position = (guint) 0;
	_tmp0_ = gtk_drop_down_get_model (combo);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_list_store_get_type ()) ? ((GListStore*) _tmp0_) : NULL);
	model = _tmp1_;
	_tmp2_ = model;
	g_list_store_find (_tmp2_, (GObject*) unit, &_tmp3_);
	position = _tmp3_;
	if (position == ((guint) -1)) {
		result = FALSE;
		_g_object_unref0 (model);
		return result;
	}
	gtk_drop_down_set_selected (combo, position);
	result = TRUE;
	_g_object_unref0 (model);
	return result;
}

static void
math_converter_category_combobox_changed_cb (MathConverter* self)
{
	UnitCategory* category = NULL;
	GtkDropDown* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	UnitCategory* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkDropDown* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category_combo;
	_tmp1_ = gtk_drop_down_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_UNIT_CATEGORY) ? ((UnitCategory*) _tmp2_) : NULL);
	category = _tmp3_;
	_tmp4_ = unit_category_get_name (category);
	_tmp5_ = _tmp4_;
	_g_free0 (self->priv->category);
	self->priv->category = _tmp5_;
	math_converter_update_visibility (self);
	math_converter_build_units_model (self);
	_tmp6_ = self->priv->from_combo;
	gtk_drop_down_set_selected (_tmp6_, (guint) 0);
	_g_object_unref0 (category);
}

static void
_math_converter_category_combobox_changed_cb_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	math_converter_category_combobox_changed_cb ((MathConverter*) self);
}

static void
math_converter_to_combobox_changed_cb (MathConverter* self)
{
	g_return_if_fail (self != NULL);
	math_converter_update_result_label (self);
	g_signal_emit (self, math_converter_signals[MATH_CONVERTER_CHANGED_SIGNAL], 0);
}

static void
_math_converter_to_combobox_changed_cb_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	math_converter_to_combobox_changed_cb ((MathConverter*) self);
}

static void
math_converter_swap_button_clicked_cb (MathConverter* self)
{
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	Unit* _tmp0_ = NULL;
	Unit* _tmp1_ = NULL;
	GtkDropDown* _tmp2_;
	GtkDropDown* _tmp3_;
	g_return_if_fail (self != NULL);
	math_converter_get_conversion (self, &_tmp0_, &_tmp1_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp0_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp1_;
	_tmp2_ = self->priv->from_combo;
	math_converter_set_active_unit (self, _tmp2_, to_unit);
	_tmp3_ = self->priv->to_combo;
	math_converter_set_active_unit (self, _tmp3_, from_unit);
	math_converter_update_result_label (self);
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
}

static void
_math_converter_swap_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	math_converter_swap_button_clicked_cb ((MathConverter*) self);
}

static void
math_converter_do_convert (MathConverter* self,
                           Unit** from_unit,
                           Unit** to_unit)
{
	Unit* _vala_from_unit = NULL;
	Unit* _vala_to_unit = NULL;
	Number* x = NULL;
	MathEquation* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_number (_tmp0_);
	_tmp2_ = _tmp1_;
	x = _tmp2_;
	_g_object_unref0 (_vala_from_unit);
	_vala_from_unit = NULL;
	_g_object_unref0 (_vala_to_unit);
	_vala_to_unit = NULL;
	_tmp3_ = x;
	if (_tmp3_ != NULL) {
		Number* z = NULL;
		Number* _tmp4_;
		Unit* _tmp5_ = NULL;
		Unit* _tmp6_ = NULL;
		Number* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		Number* _tmp10_;
		_tmp4_ = x;
		_tmp7_ = math_converter_convert_equation (self, _tmp4_, &_tmp5_, &_tmp6_);
		_g_object_unref0 (_vala_from_unit);
		_vala_from_unit = _tmp5_;
		_g_object_unref0 (_vala_to_unit);
		_vala_to_unit = _tmp6_;
		z = _tmp7_;
		_tmp10_ = z;
		if (_tmp10_ != NULL) {
			Unit* _tmp11_;
			_tmp11_ = _vala_from_unit;
			_tmp9_ = _tmp11_ != NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			Unit* _tmp12_;
			_tmp12_ = _vala_to_unit;
			_tmp8_ = _tmp12_ != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			MathEquation* _tmp13_;
			MathEquation* _tmp14_;
			Serializer* _tmp15_;
			Serializer* _tmp16_;
			Number* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			Unit* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			Unit* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			MathEquation* _tmp28_;
			_tmp13_ = self->priv->equation;
			_tmp14_ = self->priv->equation;
			_tmp15_ = math_equation_get_serializer (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = x;
			_tmp18_ = serializer_to_string (_tmp16_, _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = _vala_from_unit;
			_tmp21_ = unit_get_symbol_from_format (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _vala_to_unit;
			_tmp24_ = unit_get_symbol_from_format (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup_printf ("%s %s %s %s", _tmp19_, _tmp22_, _ ("in"), _tmp25_);
			_tmp27_ = _tmp26_;
			math_equation_set (_tmp13_, _tmp27_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp19_);
			_tmp28_ = self->priv->equation;
			math_equation_solve (_tmp28_);
		}
		_g_object_unref0 (z);
	}
	_g_object_unref0 (x);
	if (from_unit) {
		*from_unit = _vala_from_unit;
	} else {
		_g_object_unref0 (_vala_from_unit);
	}
	if (to_unit) {
		*to_unit = _vala_to_unit;
	} else {
		_g_object_unref0 (_vala_to_unit);
	}
}

static void
math_converter_convert_button_clicked_cb (MathConverter* self)
{
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	Unit* _tmp0_ = NULL;
	Unit* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	math_converter_do_convert (self, &_tmp0_, &_tmp1_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp0_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp1_;
	math_converter_update_result_label (self);
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
}

static void
_math_converter_convert_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	math_converter_convert_button_clicked_cb ((MathConverter*) self);
}

static Number*
math_converter_convert_equation (MathConverter* self,
                                 Number* x,
                                 Unit** source_unit,
                                 Unit** target_unit)
{
	Unit* _vala_source_unit = NULL;
	Unit* _vala_target_unit = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkDropDown* _tmp2_;
	UnitCategory* category = NULL;
	GtkDropDown* _tmp5_;
	GObject* _tmp6_;
	GObject* _tmp7_;
	UnitCategory* _tmp8_;
	GtkDropDown* _tmp9_;
	GObject* _tmp10_;
	GObject* _tmp11_;
	Unit* _tmp12_;
	GtkDropDown* _tmp13_;
	GObject* _tmp14_;
	GObject* _tmp15_;
	Unit* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	UnitCategory* _tmp19_;
	UnitCategory* _tmp22_;
	Unit* _tmp23_;
	Unit* _tmp24_;
	Number* _tmp25_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp2_ = self->priv->category_combo;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		GtkDropDown* _tmp3_;
		_tmp3_ = self->priv->from_combo;
		_tmp1_ = _tmp3_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GtkDropDown* _tmp4_;
		_tmp4_ = self->priv->to_combo;
		_tmp0_ = _tmp4_ == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		if (source_unit) {
			*source_unit = _vala_source_unit;
		} else {
			_g_object_unref0 (_vala_source_unit);
		}
		if (target_unit) {
			*target_unit = _vala_target_unit;
		} else {
			_g_object_unref0 (_vala_target_unit);
		}
		return result;
	}
	_tmp5_ = self->priv->category_combo;
	_tmp6_ = gtk_drop_down_get_selected_item (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_UNIT_CATEGORY) ? ((UnitCategory*) _tmp7_) : NULL);
	category = _tmp8_;
	_tmp9_ = self->priv->from_combo;
	_tmp10_ = gtk_drop_down_get_selected_item (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, TYPE_UNIT) ? ((Unit*) _tmp11_) : NULL);
	_g_object_unref0 (_vala_source_unit);
	_vala_source_unit = _tmp12_;
	_tmp13_ = self->priv->to_combo;
	_tmp14_ = gtk_drop_down_get_selected_item (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, TYPE_UNIT) ? ((Unit*) _tmp15_) : NULL);
	_g_object_unref0 (_vala_target_unit);
	_vala_target_unit = _tmp16_;
	_tmp19_ = category;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		Unit* _tmp20_;
		_tmp20_ = _vala_source_unit;
		_tmp18_ = _tmp20_ == NULL;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		Unit* _tmp21_;
		_tmp21_ = _vala_target_unit;
		_tmp17_ = _tmp21_ == NULL;
	}
	if (_tmp17_) {
		result = NULL;
		_g_object_unref0 (category);
		if (source_unit) {
			*source_unit = _vala_source_unit;
		} else {
			_g_object_unref0 (_vala_source_unit);
		}
		if (target_unit) {
			*target_unit = _vala_target_unit;
		} else {
			_g_object_unref0 (_vala_target_unit);
		}
		return result;
	}
	_tmp22_ = category;
	_tmp23_ = _vala_source_unit;
	_tmp24_ = _vala_target_unit;
	_tmp25_ = unit_category_convert (_tmp22_, x, _tmp23_, _tmp24_);
	result = _tmp25_;
	_g_object_unref0 (category);
	if (source_unit) {
		*source_unit = _vala_source_unit;
	} else {
		_g_object_unref0 (_vala_source_unit);
	}
	if (target_unit) {
		*target_unit = _vala_target_unit;
	} else {
		_g_object_unref0 (_vala_target_unit);
	}
	return result;
}

gboolean
math_converter_get_outer_box_visible (MathConverter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_outer_box_visible;
	return result;
}

void
math_converter_set_outer_box_visible (MathConverter* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = math_converter_get_outer_box_visible (self);
	if (old_value != value) {
		self->priv->_outer_box_visible = value;
		g_object_notify_by_pspec ((GObject *) self, math_converter_properties[MATH_CONVERTER_OUTER_BOX_VISIBLE_PROPERTY]);
	}
}

gboolean
math_converter_get_view_more_visible (MathConverter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_view_more_visible;
	return result;
}

void
math_converter_set_view_more_visible (MathConverter* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = math_converter_get_view_more_visible (self);
	if (old_value != value) {
		self->priv->_view_more_visible = value;
		g_object_notify_by_pspec ((GObject *) self, math_converter_properties[MATH_CONVERTER_VIEW_MORE_VISIBLE_PROPERTY]);
	}
}

gboolean
math_converter_get_view_more_active (MathConverter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_view_more_active;
	return result;
}

void
math_converter_set_view_more_active (MathConverter* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = math_converter_get_view_more_active (self);
	if (old_value != value) {
		self->priv->_view_more_active = value;
		g_object_notify_by_pspec ((GObject *) self, math_converter_properties[MATH_CONVERTER_VIEW_MORE_ACTIVE_PROPERTY]);
	}
}

static void
_math_converter___lambda11_ (MathConverter* self)
{
	math_converter_update_visibility (self);
	math_converter_update_result_label (self);
}

static void
__math_converter___lambda11__currency_manager_updated (CurrencyManager* _sender,
                                                       gpointer self)
{
	_math_converter___lambda11_ ((MathConverter*) self);
}

static GObject *
math_converter_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MathConverter * self;
	CurrencyManager* _tmp0_;
	CurrencyManager* _tmp1_;
	parent_class = G_OBJECT_CLASS (math_converter_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_CONVERTER, MathConverter);
	_tmp0_ = currency_manager_get_default (TRUE, TRUE);
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "updated", (GCallback) __math_converter___lambda11__currency_manager_updated, self, 0);
	_g_object_unref0 (_tmp1_);
	math_converter_build_category_model (self);
	math_converter_update_visibility (self);
	math_converter_build_units_model (self);
	return obj;
}

static void
math_converter_class_init (MathConverterClass * klass,
                           gpointer klass_data)
{
	math_converter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathConverter_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_math_converter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_converter_set_property;
	G_OBJECT_CLASS (klass)->constructor = math_converter_constructor;
	G_OBJECT_CLASS (klass)->finalize = math_converter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_CONVERTER_OUTER_BOX_VISIBLE_PROPERTY, math_converter_properties[MATH_CONVERTER_OUTER_BOX_VISIBLE_PROPERTY] = g_param_spec_boolean ("outer-box-visible", "outer-box-visible", "outer-box-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_CONVERTER_VIEW_MORE_VISIBLE_PROPERTY, math_converter_properties[MATH_CONVERTER_VIEW_MORE_VISIBLE_PROPERTY] = g_param_spec_boolean ("view-more-visible", "view-more-visible", "view-more-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_CONVERTER_VIEW_MORE_ACTIVE_PROPERTY, math_converter_properties[MATH_CONVERTER_VIEW_MORE_ACTIVE_PROPERTY] = g_param_spec_boolean ("view-more-active", "view-more-active", "view-more-active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/math-converter.ui");
	math_converter_signals[MATH_CONVERTER_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_MATH_CONVERTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "category_combo", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, category_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "from_combo", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, from_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "to_combo", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, to_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "from_label", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, from_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "to_label", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, to_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "category_combobox_changed_cb", G_CALLBACK(_math_converter_category_combobox_changed_cb_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "to_combobox_changed_cb", G_CALLBACK(_math_converter_to_combobox_changed_cb_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "swap_button_clicked_cb", G_CALLBACK(_math_converter_swap_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "convert_button_clicked_cb", G_CALLBACK(_math_converter_convert_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "mathconverter");
}

static void
math_converter_instance_init (MathConverter * self,
                              gpointer klass)
{
	self->priv = math_converter_get_instance_private (self);
	self->priv->equation = NULL;
	self->priv->single_category = FALSE;
	self->priv->_outer_box_visible = FALSE;
	self->priv->_view_more_visible = FALSE;
	self->priv->_view_more_active = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
math_converter_finalize (GObject * obj)
{
	MathConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_CONVERTER, MathConverter);
	_g_object_unref0 (self->priv->equation);
	_g_free0 (self->priv->category);
	G_OBJECT_CLASS (math_converter_parent_class)->finalize (obj);
}

static GType
math_converter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathConverterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_converter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathConverter), 0, (GInstanceInitFunc) math_converter_instance_init, NULL };
	GType math_converter_type_id;
	math_converter_type_id = g_type_register_static (gtk_grid_get_type (), "MathConverter", &g_define_type_info, 0);
	MathConverter_private_offset = g_type_add_instance_private (math_converter_type_id, sizeof (MathConverterPrivate));
	return math_converter_type_id;
}

GType
math_converter_get_type (void)
{
	static volatile gsize math_converter_type_id__once = 0;
	if (g_once_init_enter (&math_converter_type_id__once)) {
		GType math_converter_type_id;
		math_converter_type_id = math_converter_get_type_once ();
		g_once_init_leave (&math_converter_type_id__once, math_converter_type_id);
	}
	return math_converter_type_id__once;
}

static void
_vala_math_converter_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	MathConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_CONVERTER, MathConverter);
	switch (property_id) {
		case MATH_CONVERTER_OUTER_BOX_VISIBLE_PROPERTY:
		g_value_set_boolean (value, math_converter_get_outer_box_visible (self));
		break;
		case MATH_CONVERTER_VIEW_MORE_VISIBLE_PROPERTY:
		g_value_set_boolean (value, math_converter_get_view_more_visible (self));
		break;
		case MATH_CONVERTER_VIEW_MORE_ACTIVE_PROPERTY:
		g_value_set_boolean (value, math_converter_get_view_more_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_math_converter_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	MathConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_CONVERTER, MathConverter);
	switch (property_id) {
		case MATH_CONVERTER_OUTER_BOX_VISIBLE_PROPERTY:
		math_converter_set_outer_box_visible (self, g_value_get_boolean (value));
		break;
		case MATH_CONVERTER_VIEW_MORE_VISIBLE_PROPERTY:
		math_converter_set_view_more_visible (self, g_value_get_boolean (value));
		break;
		case MATH_CONVERTER_VIEW_MORE_ACTIVE_PROPERTY:
		math_converter_set_view_more_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

