/* math-preferences.c generated by valac 0.56.1, the Vala compiler
 * generated from math-preferences.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "calculator.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MATH_PREFERENCES_DIALOG (math_preferences_dialog_get_type ())
#define MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog))
#define MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))
#define IS_MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_PREFERENCES_DIALOG))
#define IS_MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_PREFERENCES_DIALOG))
#define MATH_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))

typedef struct _MathPreferencesDialog MathPreferencesDialog;
typedef struct _MathPreferencesDialogClass MathPreferencesDialogClass;
typedef struct _MathPreferencesDialogPrivate MathPreferencesDialogPrivate;
enum  {
	MATH_PREFERENCES_DIALOG_0_PROPERTY,
	MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY,
	MATH_PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* math_preferences_dialog_properties[MATH_PREFERENCES_DIALOG_NUM_PROPERTIES];
typedef enum  {
	MATH_PREFERENCES_DIALOG_WORD_SIZE_8_BIT = 8,
	MATH_PREFERENCES_DIALOG_WORD_SIZE_16_BIT = 16,
	MATH_PREFERENCES_DIALOG_WORD_SIZE_32_BIT = 32,
	MATH_PREFERENCES_DIALOG_WORD_SIZE_64_BIT = 64
} MathPreferencesDialogWordSize;

#define MATH_PREFERENCES_DIALOG_TYPE_WORD_SIZE (math_preferences_dialog_word_size_get_type ())
typedef enum  {
	MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_NEVER = 0,
	MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_DAILY = 86400,
	MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_WEEKLY = 604800
} MathPreferencesDialogRefreshInterval;

#define MATH_PREFERENCES_DIALOG_TYPE_REFRESH_INTERVAL (math_preferences_dialog_refresh_interval_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_expression_unref0(var) ((var == NULL) ? NULL : (var = (gtk_expression_unref (var), NULL)))

struct _MathPreferencesDialog {
	AdwPreferencesWindow parent_instance;
	MathPreferencesDialogPrivate * priv;
};

struct _MathPreferencesDialogClass {
	AdwPreferencesWindowClass parent_class;
};

struct _MathPreferencesDialogPrivate {
	MathEquation* _equation;
	AdwComboRow* row_angle_units;
	AdwComboRow* row_word_size;
	AdwComboRow* row_refresh_interval;
	GtkSpinButton* spinbutton_decimals;
	GtkSwitch* switch_thousands_separators;
	GtkSwitch* switch_trailing_zeroes;
	GSettings* settings;
};

static gint MathPreferencesDialog_private_offset;
static gpointer math_preferences_dialog_parent_class = NULL;

VALA_EXTERN GType math_preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathPreferencesDialog, g_object_unref)
VALA_EXTERN GType math_preferences_dialog_word_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType math_preferences_dialog_refresh_interval_get_type (void) G_GNUC_CONST ;
VALA_EXTERN MathPreferencesDialog* math_preferences_dialog_new (MathEquation* eq);
VALA_EXTERN MathPreferencesDialog* math_preferences_dialog_construct (GType object_type,
                                                          MathEquation* eq);
static gchar* math_preferences_dialog_angle_units_name (AdwEnumListItem* item);
static gchar* math_preferences_dialog_word_size_name (AdwEnumListItem* item);
static gchar* math_preferences_dialog_refresh_interval_name (AdwEnumListItem* item);
static void math_preferences_dialog_row_angle_units_changed_cb (MathPreferencesDialog* self);
static MathEquation* math_preferences_dialog_get_equation (MathPreferencesDialog* self);
static void math_preferences_dialog_row_word_size_changed_cb (MathPreferencesDialog* self);
static void math_preferences_dialog_row_refresh_interval_changed_cb (MathPreferencesDialog* self);
static gboolean math_preferences_dialog_real_close_request (GtkWindow* base);
static void math_preferences_dialog_set_combo_row_from_int (MathPreferencesDialog* self,
                                                     AdwComboRow* row,
                                                     gint value);
static void math_preferences_dialog_set_equation (MathPreferencesDialog* self,
                                           MathEquation* value);
static GObject * math_preferences_dialog_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _math_preferences_dialog___lambda43_ (MathPreferencesDialog* self);
static void __math_preferences_dialog___lambda43__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                          gpointer self);
static gboolean _math_preferences_dialog___lambda44_ (MathPreferencesDialog* self,
                                               gboolean state);
static gboolean __math_preferences_dialog___lambda44__gtk_switch_state_set (GtkSwitch* _sender,
                                                                     gboolean state,
                                                                     gpointer self);
static gboolean _math_preferences_dialog___lambda45_ (MathPreferencesDialog* self,
                                               gboolean state);
static gboolean __math_preferences_dialog___lambda45__gtk_switch_state_set (GtkSwitch* _sender,
                                                                     gboolean state,
                                                                     gpointer self);
static void _math_preferences_dialog_row_angle_units_changed_cb_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self);
static void _math_preferences_dialog_row_word_size_changed_cb_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
static void _math_preferences_dialog_row_refresh_interval_changed_cb_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self);
static void _math_preferences_dialog___lambda46_ (MathPreferencesDialog* self,
                                           GParamSpec* pspec);
static void __math_preferences_dialog___lambda46__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _math_preferences_dialog___lambda47_ (MathPreferencesDialog* self);
static void __math_preferences_dialog___lambda47__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _math_preferences_dialog___lambda48_ (MathPreferencesDialog* self);
static void __math_preferences_dialog___lambda48__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _math_preferences_dialog___lambda49_ (MathPreferencesDialog* self,
                                           GParamSpec* pspec);
static void __math_preferences_dialog___lambda49__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _math_preferences_dialog___lambda50_ (MathPreferencesDialog* self,
                                           GParamSpec* pspec);
static void __math_preferences_dialog___lambda50__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void math_preferences_dialog_finalize (GObject * obj);
static GType math_preferences_dialog_get_type_once (void);
static void _vala_math_preferences_dialog_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_math_preferences_dialog_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
math_preferences_dialog_get_instance_private (MathPreferencesDialog* self)
{
	return G_STRUCT_MEMBER_P (self, MathPreferencesDialog_private_offset);
}

static GType
math_preferences_dialog_word_size_get_type_once (void)
{
	static const GEnumValue values[] = {{MATH_PREFERENCES_DIALOG_WORD_SIZE_8_BIT, "MATH_PREFERENCES_DIALOG_WORD_SIZE_8_BIT", "8-bit"}, {MATH_PREFERENCES_DIALOG_WORD_SIZE_16_BIT, "MATH_PREFERENCES_DIALOG_WORD_SIZE_16_BIT", "16-bit"}, {MATH_PREFERENCES_DIALOG_WORD_SIZE_32_BIT, "MATH_PREFERENCES_DIALOG_WORD_SIZE_32_BIT", "32-bit"}, {MATH_PREFERENCES_DIALOG_WORD_SIZE_64_BIT, "MATH_PREFERENCES_DIALOG_WORD_SIZE_64_BIT", "64-bit"}, {0, NULL, NULL}};
	GType math_preferences_dialog_word_size_type_id;
	math_preferences_dialog_word_size_type_id = g_enum_register_static ("MathPreferencesDialogWordSize", values);
	return math_preferences_dialog_word_size_type_id;
}

GType
math_preferences_dialog_word_size_get_type (void)
{
	static volatile gsize math_preferences_dialog_word_size_type_id__once = 0;
	if (g_once_init_enter (&math_preferences_dialog_word_size_type_id__once)) {
		GType math_preferences_dialog_word_size_type_id;
		math_preferences_dialog_word_size_type_id = math_preferences_dialog_word_size_get_type_once ();
		g_once_init_leave (&math_preferences_dialog_word_size_type_id__once, math_preferences_dialog_word_size_type_id);
	}
	return math_preferences_dialog_word_size_type_id__once;
}

static GType
math_preferences_dialog_refresh_interval_get_type_once (void)
{
	static const GEnumValue values[] = {{MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_NEVER, "MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_NEVER", "never"}, {MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_DAILY, "MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_DAILY", "daily"}, {MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_WEEKLY, "MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_WEEKLY", "weekly"}, {0, NULL, NULL}};
	GType math_preferences_dialog_refresh_interval_type_id;
	math_preferences_dialog_refresh_interval_type_id = g_enum_register_static ("MathPreferencesDialogRefreshInterval", values);
	return math_preferences_dialog_refresh_interval_type_id;
}

GType
math_preferences_dialog_refresh_interval_get_type (void)
{
	static volatile gsize math_preferences_dialog_refresh_interval_type_id__once = 0;
	if (g_once_init_enter (&math_preferences_dialog_refresh_interval_type_id__once)) {
		GType math_preferences_dialog_refresh_interval_type_id;
		math_preferences_dialog_refresh_interval_type_id = math_preferences_dialog_refresh_interval_get_type_once ();
		g_once_init_leave (&math_preferences_dialog_refresh_interval_type_id__once, math_preferences_dialog_refresh_interval_type_id);
	}
	return math_preferences_dialog_refresh_interval_type_id__once;
}

MathPreferencesDialog*
math_preferences_dialog_construct (GType object_type,
                                   MathEquation* eq)
{
	MathPreferencesDialog * self = NULL;
	g_return_val_if_fail (eq != NULL, NULL);
	g_type_ensure (MATH_PREFERENCES_DIALOG_TYPE_WORD_SIZE);
	g_type_ensure (MATH_PREFERENCES_DIALOG_TYPE_REFRESH_INTERVAL);
	self = (MathPreferencesDialog*) g_object_new (object_type, "equation", eq, NULL);
	return self;
}

MathPreferencesDialog*
math_preferences_dialog_new (MathEquation* eq)
{
	return math_preferences_dialog_construct (TYPE_MATH_PREFERENCES_DIALOG, eq);
}

static gchar*
math_preferences_dialog_angle_units_name (AdwEnumListItem* item)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = adw_enum_list_item_get_value (item);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case ANGLE_UNIT_DEGREES:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Degrees"));
			result = _tmp2_;
			return result;
		}
		case ANGLE_UNIT_RADIANS:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Radians"));
			result = _tmp3_;
			return result;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Gradians"));
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("");
			result = _tmp5_;
			return result;
		}
	}
}

static gchar*
math_preferences_dialog_word_size_name (AdwEnumListItem* item)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = adw_enum_list_item_get_value (item);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case MATH_PREFERENCES_DIALOG_WORD_SIZE_8_BIT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("8-bit"));
			result = _tmp2_;
			return result;
		}
		case MATH_PREFERENCES_DIALOG_WORD_SIZE_16_BIT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("16-bit"));
			result = _tmp3_;
			return result;
		}
		case MATH_PREFERENCES_DIALOG_WORD_SIZE_32_BIT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("32-bit"));
			result = _tmp4_;
			return result;
		}
		case MATH_PREFERENCES_DIALOG_WORD_SIZE_64_BIT:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("64-bit"));
			result = _tmp5_;
			return result;
		}
		default:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("");
			result = _tmp6_;
			return result;
		}
	}
}

static gchar*
math_preferences_dialog_refresh_interval_name (AdwEnumListItem* item)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = adw_enum_list_item_get_value (item);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_NEVER:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Never"));
			result = _tmp2_;
			return result;
		}
		case MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_DAILY:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Daily"));
			result = _tmp3_;
			return result;
		}
		case MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_WEEKLY:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Weekly"));
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("");
			result = _tmp5_;
			return result;
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
math_preferences_dialog_row_angle_units_changed_cb (MathPreferencesDialog* self)
{
	AdwEnumListItem* item = NULL;
	AdwComboRow* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	AdwEnumListItem* _tmp3_;
	MathEquation* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->row_angle_units;
	_tmp1_ = adw_combo_row_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, adw_enum_list_item_get_type (), AdwEnumListItem));
	item = _tmp3_;
	_tmp4_ = self->priv->_equation;
	_tmp5_ = adw_enum_list_item_get_value (item);
	_tmp6_ = _tmp5_;
	math_equation_set_angle_units (_tmp4_, (AngleUnit) _tmp6_);
	_g_object_unref0 (item);
}

static void
math_preferences_dialog_row_word_size_changed_cb (MathPreferencesDialog* self)
{
	AdwEnumListItem* item = NULL;
	AdwComboRow* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	AdwEnumListItem* _tmp3_;
	MathEquation* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->row_word_size;
	_tmp1_ = adw_combo_row_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, adw_enum_list_item_get_type (), AdwEnumListItem));
	item = _tmp3_;
	_tmp4_ = self->priv->_equation;
	_tmp5_ = adw_enum_list_item_get_value (item);
	_tmp6_ = _tmp5_;
	math_equation_set_word_size (_tmp4_, (gint) ((MathPreferencesDialogWordSize) _tmp6_));
	_g_object_unref0 (item);
}

static void
math_preferences_dialog_row_refresh_interval_changed_cb (MathPreferencesDialog* self)
{
	AdwEnumListItem* item = NULL;
	AdwComboRow* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	AdwEnumListItem* _tmp3_;
	MathPreferencesDialogRefreshInterval value = 0;
	gint _tmp4_;
	gint _tmp5_;
	GSettings* _tmp6_;
	CurrencyManager* _tmp7_;
	CurrencyManager* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->row_refresh_interval;
	_tmp1_ = adw_combo_row_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, adw_enum_list_item_get_type (), AdwEnumListItem));
	item = _tmp3_;
	_tmp4_ = adw_enum_list_item_get_value (item);
	_tmp5_ = _tmp4_;
	value = (MathPreferencesDialogRefreshInterval) _tmp5_;
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "refresh-interval", (gint) value);
	_tmp7_ = currency_manager_get_default (TRUE, TRUE);
	_tmp8_ = _tmp7_;
	currency_manager_set_refresh_interval (_tmp8_, (gint) value);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (item);
}

static gboolean
math_preferences_dialog_real_close_request (GtkWindow* base)
{
	MathPreferencesDialog * self;
	gboolean result;
	self = (MathPreferencesDialog*) base;
	gtk_widget_hide ((GtkWidget*) self);
	result = TRUE;
	return result;
}

static void
math_preferences_dialog_set_combo_row_from_int (MathPreferencesDialog* self,
                                                AdwComboRow* row,
                                                gint value)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListModel* _tmp2_;
				GListModel* _tmp3_;
				GListModel* _tmp4_;
				GListModel* _tmp5_;
				GObject* _tmp6_;
				AdwEnumListItem* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = adw_combo_row_get_model (row);
				_tmp3_ = _tmp2_;
				if (!(((guint) i) < g_list_model_get_n_items (_tmp3_))) {
					break;
				}
				_tmp4_ = adw_combo_row_get_model (row);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_list_model_get_item (_tmp5_, (guint) i);
				_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, adw_enum_list_item_get_type (), AdwEnumListItem);
				_tmp8_ = adw_enum_list_item_get_value (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = ((gint) _tmp9_) == value;
				_g_object_unref0 (_tmp7_);
				if (_tmp10_) {
					adw_combo_row_set_selected (row, (guint) i);
					break;
				}
			}
		}
	}
}

static MathEquation*
math_preferences_dialog_get_equation (MathPreferencesDialog* self)
{
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}

static void
math_preferences_dialog_set_equation (MathPreferencesDialog* self,
                                      MathEquation* value)
{
	MathEquation* old_value;
	g_return_if_fail (self != NULL);
	old_value = math_preferences_dialog_get_equation (self);
	if (old_value != value) {
		MathEquation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_equation);
		self->priv->_equation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, math_preferences_dialog_properties[MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY]);
	}
}

static void
_math_preferences_dialog___lambda43_ (MathPreferencesDialog* self)
{
	MathEquation* _tmp0_;
	GtkSpinButton* _tmp1_;
	_tmp0_ = self->priv->_equation;
	_tmp1_ = self->priv->spinbutton_decimals;
	math_equation_set_accuracy (_tmp0_, gtk_spin_button_get_value_as_int (_tmp1_));
}

static void
__math_preferences_dialog___lambda43__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                     gpointer self)
{
	_math_preferences_dialog___lambda43_ ((MathPreferencesDialog*) self);
}

static gboolean
_math_preferences_dialog___lambda44_ (MathPreferencesDialog* self,
                                      gboolean state)
{
	MathEquation* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->_equation;
	math_equation_set_show_trailing_zeroes (_tmp0_, state);
	result = FALSE;
	return result;
}

static gboolean
__math_preferences_dialog___lambda44__gtk_switch_state_set (GtkSwitch* _sender,
                                                            gboolean state,
                                                            gpointer self)
{
	gboolean result;
	result = _math_preferences_dialog___lambda44_ ((MathPreferencesDialog*) self, state);
	return result;
}

static gboolean
_math_preferences_dialog___lambda45_ (MathPreferencesDialog* self,
                                      gboolean state)
{
	MathEquation* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->_equation;
	math_equation_set_show_thousands_separators (_tmp0_, state);
	result = FALSE;
	return result;
}

static gboolean
__math_preferences_dialog___lambda45__gtk_switch_state_set (GtkSwitch* _sender,
                                                            gboolean state,
                                                            gpointer self)
{
	gboolean result;
	result = _math_preferences_dialog___lambda45_ ((MathPreferencesDialog*) self, state);
	return result;
}

static void
_math_preferences_dialog_row_angle_units_changed_cb_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self)
{
	math_preferences_dialog_row_angle_units_changed_cb ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog_row_word_size_changed_cb_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	math_preferences_dialog_row_word_size_changed_cb ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog_row_refresh_interval_changed_cb_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self)
{
	math_preferences_dialog_row_refresh_interval_changed_cb ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog___lambda46_ (MathPreferencesDialog* self,
                                      GParamSpec* pspec)
{
	GtkSpinButton* _tmp0_;
	MathEquation* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->spinbutton_decimals;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_accuracy (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_spin_button_set_value (_tmp0_, (gdouble) _tmp3_);
}

static void
__math_preferences_dialog___lambda46__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_math_preferences_dialog___lambda46_ ((MathPreferencesDialog*) self, pspec);
}

static void
_math_preferences_dialog___lambda47_ (MathPreferencesDialog* self)
{
	GtkSwitch* _tmp0_;
	MathEquation* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->switch_thousands_separators;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_show_thousands_separators (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_switch_set_active (_tmp0_, _tmp3_);
}

static void
__math_preferences_dialog___lambda47__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_math_preferences_dialog___lambda47_ ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog___lambda48_ (MathPreferencesDialog* self)
{
	GtkSwitch* _tmp0_;
	MathEquation* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->switch_trailing_zeroes;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_show_trailing_zeroes (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_switch_set_active (_tmp0_, _tmp3_);
}

static void
__math_preferences_dialog___lambda48__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_math_preferences_dialog___lambda48_ ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog___lambda49_ (MathPreferencesDialog* self,
                                      GParamSpec* pspec)
{
	AdwComboRow* _tmp0_;
	MathEquation* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->row_word_size;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_word_size (_tmp1_);
	_tmp3_ = _tmp2_;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp0_, _tmp3_);
}

static void
__math_preferences_dialog___lambda49__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_math_preferences_dialog___lambda49_ ((MathPreferencesDialog*) self, pspec);
}

static void
_math_preferences_dialog___lambda50_ (MathPreferencesDialog* self,
                                      GParamSpec* pspec)
{
	AdwComboRow* _tmp0_;
	MathEquation* _tmp1_;
	AngleUnit _tmp2_;
	AngleUnit _tmp3_;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->row_angle_units;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_angle_units (_tmp1_);
	_tmp3_ = _tmp2_;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp0_, (gint) _tmp3_);
}

static void
__math_preferences_dialog___lambda50__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_math_preferences_dialog___lambda50_ ((MathPreferencesDialog*) self, pspec);
}

static GObject *
math_preferences_dialog_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MathPreferencesDialog * self;
	GSettings* _tmp0_;
	AdwEnumListModel* model = NULL;
	AdwEnumListModel* _tmp1_;
	GtkCClosureExpression* expression = NULL;
	GtkExpression** _tmp2_;
	GtkCClosureExpression* _tmp3_;
	AdwComboRow* _tmp4_;
	GtkCClosureExpression* _tmp5_;
	AdwComboRow* _tmp6_;
	AdwEnumListModel* _tmp7_;
	AdwEnumListModel* _tmp8_;
	GtkExpression** _tmp9_;
	GtkCClosureExpression* _tmp10_;
	AdwComboRow* _tmp11_;
	GtkCClosureExpression* _tmp12_;
	AdwComboRow* _tmp13_;
	AdwEnumListModel* _tmp14_;
	AdwEnumListModel* _tmp15_;
	GtkExpression** _tmp16_;
	GtkCClosureExpression* _tmp17_;
	AdwComboRow* _tmp18_;
	GtkCClosureExpression* _tmp19_;
	AdwComboRow* _tmp20_;
	AdwEnumListModel* _tmp21_;
	GtkSpinButton* _tmp22_;
	GtkSwitch* _tmp23_;
	GtkSwitch* _tmp24_;
	AdwComboRow* _tmp25_;
	AdwComboRow* _tmp26_;
	AdwComboRow* _tmp27_;
	GtkSpinButton* _tmp28_;
	MathEquation* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	MathEquation* _tmp32_;
	GtkSwitch* _tmp33_;
	MathEquation* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	MathEquation* _tmp37_;
	GtkSwitch* _tmp38_;
	MathEquation* _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	MathEquation* _tmp42_;
	AdwComboRow* _tmp43_;
	MathEquation* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	MathEquation* _tmp47_;
	AdwComboRow* _tmp48_;
	MathEquation* _tmp49_;
	AngleUnit _tmp50_;
	AngleUnit _tmp51_;
	MathEquation* _tmp52_;
	AdwComboRow* _tmp53_;
	GSettings* _tmp54_;
	parent_class = G_OBJECT_CLASS (math_preferences_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	_tmp0_ = g_settings_new ("org.gnome.calculator");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = adw_enum_list_model_new (TYPE_ANGLE_UNIT);
	model = _tmp1_;
	_tmp2_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp3_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp2_, (GCallback) math_preferences_dialog_angle_units_name, NULL, NULL);
	expression = _tmp3_;
	_tmp4_ = self->priv->row_angle_units;
	_tmp5_ = expression;
	adw_combo_row_set_expression (_tmp4_, (GtkExpression*) _tmp5_);
	_tmp6_ = self->priv->row_angle_units;
	_tmp7_ = model;
	adw_combo_row_set_model (_tmp6_, (GListModel*) _tmp7_);
	_tmp8_ = adw_enum_list_model_new (MATH_PREFERENCES_DIALOG_TYPE_WORD_SIZE);
	_g_object_unref0 (model);
	model = _tmp8_;
	_tmp9_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp10_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp9_, (GCallback) math_preferences_dialog_word_size_name, NULL, NULL);
	_gtk_expression_unref0 (expression);
	expression = _tmp10_;
	_tmp11_ = self->priv->row_word_size;
	_tmp12_ = expression;
	adw_combo_row_set_expression (_tmp11_, (GtkExpression*) _tmp12_);
	_tmp13_ = self->priv->row_word_size;
	_tmp14_ = model;
	adw_combo_row_set_model (_tmp13_, (GListModel*) _tmp14_);
	_tmp15_ = adw_enum_list_model_new (MATH_PREFERENCES_DIALOG_TYPE_REFRESH_INTERVAL);
	_g_object_unref0 (model);
	model = _tmp15_;
	_tmp16_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp17_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp16_, (GCallback) math_preferences_dialog_refresh_interval_name, NULL, NULL);
	_gtk_expression_unref0 (expression);
	expression = _tmp17_;
	_tmp18_ = self->priv->row_refresh_interval;
	_tmp19_ = expression;
	adw_combo_row_set_expression (_tmp18_, (GtkExpression*) _tmp19_);
	_tmp20_ = self->priv->row_refresh_interval;
	_tmp21_ = model;
	adw_combo_row_set_model (_tmp20_, (GListModel*) _tmp21_);
	_tmp22_ = self->priv->spinbutton_decimals;
	g_signal_connect_object (_tmp22_, "value-changed", (GCallback) __math_preferences_dialog___lambda43__gtk_spin_button_value_changed, self, 0);
	_tmp23_ = self->priv->switch_trailing_zeroes;
	g_signal_connect_object (_tmp23_, "state-set", (GCallback) __math_preferences_dialog___lambda44__gtk_switch_state_set, self, 0);
	_tmp24_ = self->priv->switch_thousands_separators;
	g_signal_connect_object (_tmp24_, "state-set", (GCallback) __math_preferences_dialog___lambda45__gtk_switch_state_set, self, 0);
	_tmp25_ = self->priv->row_angle_units;
	g_signal_connect_object ((GObject*) _tmp25_, "notify::selected", (GCallback) _math_preferences_dialog_row_angle_units_changed_cb_g_object_notify, self, 0);
	_tmp26_ = self->priv->row_word_size;
	g_signal_connect_object ((GObject*) _tmp26_, "notify::selected", (GCallback) _math_preferences_dialog_row_word_size_changed_cb_g_object_notify, self, 0);
	_tmp27_ = self->priv->row_refresh_interval;
	g_signal_connect_object ((GObject*) _tmp27_, "notify::selected", (GCallback) _math_preferences_dialog_row_refresh_interval_changed_cb_g_object_notify, self, 0);
	_tmp28_ = self->priv->spinbutton_decimals;
	_tmp29_ = self->priv->_equation;
	_tmp30_ = math_equation_get_accuracy (_tmp29_);
	_tmp31_ = _tmp30_;
	gtk_spin_button_set_value (_tmp28_, (gdouble) _tmp31_);
	_tmp32_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp32_, "notify::accuracy", (GCallback) __math_preferences_dialog___lambda46__g_object_notify, self, 0);
	_tmp33_ = self->priv->switch_thousands_separators;
	_tmp34_ = self->priv->_equation;
	_tmp35_ = math_equation_get_show_thousands_separators (_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_switch_set_active (_tmp33_, _tmp36_);
	_tmp37_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp37_, "notify::show-thousands-separators", (GCallback) __math_preferences_dialog___lambda47__g_object_notify, self, 0);
	_tmp38_ = self->priv->switch_trailing_zeroes;
	_tmp39_ = self->priv->_equation;
	_tmp40_ = math_equation_get_show_trailing_zeroes (_tmp39_);
	_tmp41_ = _tmp40_;
	gtk_switch_set_active (_tmp38_, _tmp41_);
	_tmp42_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp42_, "notify::show-trailing_zeroes", (GCallback) __math_preferences_dialog___lambda48__g_object_notify, self, 0);
	_tmp43_ = self->priv->row_word_size;
	_tmp44_ = self->priv->_equation;
	_tmp45_ = math_equation_get_word_size (_tmp44_);
	_tmp46_ = _tmp45_;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp43_, _tmp46_);
	_tmp47_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp47_, "notify::word-size", (GCallback) __math_preferences_dialog___lambda49__g_object_notify, self, 0);
	_tmp48_ = self->priv->row_angle_units;
	_tmp49_ = self->priv->_equation;
	_tmp50_ = math_equation_get_angle_units (_tmp49_);
	_tmp51_ = _tmp50_;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp48_, (gint) _tmp51_);
	_tmp52_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp52_, "notify::angle-units", (GCallback) __math_preferences_dialog___lambda50__g_object_notify, self, 0);
	_tmp53_ = self->priv->row_refresh_interval;
	_tmp54_ = self->priv->settings;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp53_, g_settings_get_int (_tmp54_, "refresh-interval"));
	if (DEVELOPMENT_BUILD) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	_gtk_expression_unref0 (expression);
	_g_object_unref0 (model);
	return obj;
}

static void
math_preferences_dialog_class_init (MathPreferencesDialogClass * klass,
                                    gpointer klass_data)
{
	math_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathPreferencesDialog_private_offset);
	((GtkWindowClass *) klass)->close_request = (gboolean (*) (GtkWindow*)) math_preferences_dialog_real_close_request;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_preferences_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_preferences_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = math_preferences_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = math_preferences_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY, math_preferences_dialog_properties[MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY] = g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/math-preferences.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_angle_units", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, row_angle_units));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_word_size", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, row_word_size));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_refresh_interval", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, row_refresh_interval));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinbutton_decimals", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, spinbutton_decimals));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_thousands_separators", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, switch_thousands_separators));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_trailing_zeroes", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, switch_trailing_zeroes));
}

static void
math_preferences_dialog_instance_init (MathPreferencesDialog * self,
                                       gpointer klass)
{
	self->priv = math_preferences_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
math_preferences_dialog_finalize (GObject * obj)
{
	MathPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (math_preferences_dialog_parent_class)->finalize (obj);
}

static GType
math_preferences_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathPreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathPreferencesDialog), 0, (GInstanceInitFunc) math_preferences_dialog_instance_init, NULL };
	GType math_preferences_dialog_type_id;
	math_preferences_dialog_type_id = g_type_register_static (adw_preferences_window_get_type (), "MathPreferencesDialog", &g_define_type_info, 0);
	MathPreferencesDialog_private_offset = g_type_add_instance_private (math_preferences_dialog_type_id, sizeof (MathPreferencesDialogPrivate));
	return math_preferences_dialog_type_id;
}

GType
math_preferences_dialog_get_type (void)
{
	static volatile gsize math_preferences_dialog_type_id__once = 0;
	if (g_once_init_enter (&math_preferences_dialog_type_id__once)) {
		GType math_preferences_dialog_type_id;
		math_preferences_dialog_type_id = math_preferences_dialog_get_type_once ();
		g_once_init_leave (&math_preferences_dialog_type_id__once, math_preferences_dialog_type_id);
	}
	return math_preferences_dialog_type_id__once;
}

static void
_vala_math_preferences_dialog_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	MathPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	switch (property_id) {
		case MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY:
		g_value_set_object (value, math_preferences_dialog_get_equation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_math_preferences_dialog_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	MathPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	switch (property_id) {
		case MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY:
		math_preferences_dialog_set_equation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

