/* rygel-tracker-category-all-container.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-tracker-category-all-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-tracker3.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "rygel-server.h"
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <libtracker-sparql/tracker-sparql.h>

#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_TRACKER_SERVICE "org.freedesktop.Tracker3.Miner.Files"
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_RESOURCES_PATH "/org/freedesktop/Tracker3/Endpoint"
#define RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_TRACKER_INTERFACE "org.freedesktop.Tracker3.Endpoint"

enum  {
	RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_0_PROPERTY,
	RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY,
	RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY,
	RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_tracker_category_all_container_properties[RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
typedef struct _RygelTrackerCategoryAllContainerAddItemData RygelTrackerCategoryAllContainerAddItemData;
typedef struct _RygelTrackerCategoryAllContainerAddContainerData RygelTrackerCategoryAllContainerAddContainerData;
typedef struct _RygelTrackerCategoryAllContainerRemoveItemData RygelTrackerCategoryAllContainerRemoveItemData;
typedef struct _RygelTrackerCategoryAllContainerRemoveContainerData RygelTrackerCategoryAllContainerRemoveContainerData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelTrackerCategoryAllContainerSearchData RygelTrackerCategoryAllContainerSearchData;
typedef struct _RygelTrackerCategoryAllContainerCreateEntryInStoreData RygelTrackerCategoryAllContainerCreateEntryInStoreData;
typedef struct _RygelTrackerCategoryAllContainerRemoveEntryFromStoreData RygelTrackerCategoryAllContainerRemoveEntryFromStoreData;

struct _RygelTrackerCategoryAllContainerPrivate {
	GeeArrayList* _create_classes;
	GeeArrayList* _search_classes;
};

struct _RygelTrackerCategoryAllContainerAddItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackerCategoryAllContainer* self;
	RygelMediaFileItem* item;
	GCancellable* cancellable;
	gchar* urn;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_;
};

struct _RygelTrackerCategoryAllContainerAddContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackerCategoryAllContainer* self;
	RygelMediaContainer* container;
	GCancellable* cancellable;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _RygelTrackerCategoryAllContainerRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackerCategoryAllContainer* self;
	gchar* id;
	GCancellable* cancellable;
	gchar* parent_id;
	gchar* urn;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_;
};

struct _RygelTrackerCategoryAllContainerRemoveContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackerCategoryAllContainer* self;
	gchar* id;
	GCancellable* cancellable;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _RygelTrackerCategoryAllContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackerCategoryAllContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	guint _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	GError* _inner_error0_;
};

struct _RygelTrackerCategoryAllContainerCreateEntryInStoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackerCategoryAllContainer* self;
	RygelMediaFileItem* item;
	gchar* result;
	gchar* category;
	RygelTrackerItemFactory* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	RygelTrackerInsertionQuery* query;
	RygelTrackerInsertionQuery* _tmp3_;
	TrackerSparqlConnection* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_;
};

struct _RygelTrackerCategoryAllContainerRemoveEntryFromStoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackerCategoryAllContainer* self;
	gchar* id;
	RygelTrackerDeletionQuery* query;
	RygelTrackerDeletionQuery* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	GError* _inner_error0_;
};

static gint RygelTrackerCategoryAllContainer_private_offset;
static gpointer rygel_tracker_category_all_container_parent_class = NULL;
static RygelWritableContainerIface * rygel_tracker_category_all_container_rygel_writable_container_parent_iface = NULL;
static RygelSearchableContainerIface * rygel_tracker_category_all_container_rygel_searchable_container_parent_iface = NULL;

static void rygel_tracker_category_all_container_on_graph_updated (RygelTrackerCategoryAllContainer* self,
                                                            GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* signal_path,
                                                            GVariant* parameters);
static void _rygel_tracker_category_all_container_on_graph_updated_gd_bus_signal_callback (GDBusConnection* connection,
                                                                                    const gchar* sender_name,
                                                                                    const gchar* object_path,
                                                                                    const gchar* interface_name,
                                                                                    const gchar* signal_name,
                                                                                    GVariant* parameters,
                                                                                    gpointer self);
static void __lambda5_ (RygelTrackerCategoryAllContainer* self);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void rygel_tracker_category_all_container_real_add_item_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_add_item (RygelWritableContainer* base,
                                                         RygelMediaFileItem* item,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_add_item_co (RygelTrackerCategoryAllContainerAddItemData* _data_);
static void rygel_tracker_category_all_container_create_entry_in_store (RygelTrackerCategoryAllContainer* self,
                                                                 RygelMediaFileItem* item,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static gchar* rygel_tracker_category_all_container_create_entry_in_store_finish (RygelTrackerCategoryAllContainer* self,
                                                                          GAsyncResult* _res_,
                                                                          GError** error);
static void rygel_tracker_category_all_container_add_item_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void rygel_tracker_category_all_container_real_add_container_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_add_container (RygelWritableContainer* base,
                                                              RygelMediaContainer* container,
                                                              GCancellable* cancellable,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_add_container_co (RygelTrackerCategoryAllContainerAddContainerData* _data_);
static void rygel_tracker_category_all_container_real_remove_item_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_remove_item (RygelWritableContainer* base,
                                                            const gchar* id,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_remove_item_co (RygelTrackerCategoryAllContainerRemoveItemData* _data_);
static void rygel_tracker_category_all_container_remove_entry_from_store (RygelTrackerCategoryAllContainer* self,
                                                                   const gchar* id,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
static void rygel_tracker_category_all_container_remove_entry_from_store_finish (RygelTrackerCategoryAllContainer* self,
                                                                          GAsyncResult* _res_,
                                                                          GError** error);
static void rygel_tracker_category_all_container_remove_item_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void rygel_tracker_category_all_container_real_remove_container_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_remove_container (RygelWritableContainer* base,
                                                                 const gchar* id,
                                                                 GCancellable* cancellable,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_remove_container_co (RygelTrackerCategoryAllContainerRemoveContainerData* _data_);
static void rygel_tracker_category_all_container_real_search_data_free (gpointer _data);
static void rygel_tracker_category_all_container_real_search (RygelSearchableContainer* base,
                                                       RygelSearchExpression* expression,
                                                       guint offset,
                                                       guint max_count,
                                                       const gchar* sort_criteria,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean rygel_tracker_category_all_container_real_search_co (RygelTrackerCategoryAllContainerSearchData* _data_);
static void rygel_tracker_category_all_container_search_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
VALA_EXTERN void rygel_tracker_search_container_get_children_count (RygelTrackerSearchContainer* self,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
VALA_EXTERN void rygel_tracker_search_container_get_children_count_finish (RygelTrackerSearchContainer* self,
                                                               GAsyncResult* _res_);
static void rygel_tracker_category_all_container_create_entry_in_store_data_free (gpointer _data);
static gboolean rygel_tracker_category_all_container_create_entry_in_store_co (RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_);
static void rygel_tracker_category_all_container_create_entry_in_store_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_);
static void rygel_tracker_category_all_container_remove_entry_from_store_data_free (gpointer _data);
static gboolean rygel_tracker_category_all_container_remove_entry_from_store_co (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_);
static void rygel_tracker_category_all_container_remove_entry_from_store_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_);
static void rygel_tracker_category_all_container_finalize (GObject * obj);
static GType rygel_tracker_category_all_container_get_type_once (void);
static void _vala_rygel_tracker_category_all_container_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_rygel_tracker_category_all_container_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);

static inline gpointer
rygel_tracker_category_all_container_get_instance_private (RygelTrackerCategoryAllContainer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelTrackerCategoryAllContainer_private_offset);
}

static void
_rygel_tracker_category_all_container_on_graph_updated_gd_bus_signal_callback (GDBusConnection* connection,
                                                                               const gchar* sender_name,
                                                                               const gchar* object_path,
                                                                               const gchar* interface_name,
                                                                               const gchar* signal_name,
                                                                               GVariant* parameters,
                                                                               gpointer self)
{
	rygel_tracker_category_all_container_on_graph_updated ((RygelTrackerCategoryAllContainer*) self, connection, sender_name, object_path, interface_name, signal_name, parameters);
}

static void
__lambda5_ (RygelTrackerCategoryAllContainer* self)
{
	RygelTrackerSelectionQuery* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	_tmp0_ = ((RygelTrackerSearchContainer*) self)->query;
	_tmp1_ = _tmp0_->result;
	if (_tmp1_ != NULL) {
		RygelTrackerSelectionQuery* _tmp2_;
		TrackerSparqlCursor* _tmp3_;
		_tmp2_ = ((RygelTrackerSearchContainer*) self)->query;
		_tmp3_ = _tmp2_->result;
		tracker_sparql_cursor_close (_tmp3_);
	}
}

static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda5_ ((RygelTrackerCategoryAllContainer*) self);
	g_object_unref (self);
}

RygelTrackerCategoryAllContainer*
rygel_tracker_category_all_container_construct (GType object_type,
                                                RygelTrackerCategoryContainer* parent)
{
	RygelTrackerCategoryAllContainer * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	RygelTrackerItemFactory* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	RygelTrackerItemFactory* _tmp9_;
	const gchar* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	RygelTrackerItemFactory* _tmp13_;
	const gchar* _tmp14_;
	RygelTrackerItemFactory* _tmp28_;
	const gchar* _tmp29_;
	RygelTrackerCleanupQuery* cleanup_query = NULL;
	RygelTrackerItemFactory* _tmp30_;
	const gchar* _tmp31_;
	RygelTrackerCleanupQuery* _tmp32_;
	TrackerSparqlConnection* _tmp33_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) parent);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("All", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = parent->item_factory;
	self = (RygelTrackerCategoryAllContainer*) rygel_tracker_search_container_construct (object_type, _tmp3_, (RygelMediaContainer*) parent, "All", _tmp4_, NULL, NULL);
	_g_free0 (_tmp3_);
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp6_ = _tmp5_;
	rygel_writable_container_set_create_classes ((RygelWritableContainer*) self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = rygel_writable_container_get_create_classes ((RygelWritableContainer*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = ((RygelTrackerSearchContainer*) self)->item_factory;
	_tmp10_ = _tmp9_->upnp_class;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp10_);
	_tmp11_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp12_ = _tmp11_;
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = ((RygelTrackerSearchContainer*) self)->item_factory;
	_tmp14_ = _tmp13_->upload_dir;
	if (_tmp14_ != NULL) {
		{
			gchar* uri = NULL;
			RygelTrackerItemFactory* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp15_ = ((RygelTrackerSearchContainer*) self)->item_factory;
			_tmp16_ = _tmp15_->upload_dir;
			_tmp17_ = g_filename_to_uri (_tmp16_, NULL, &_inner_error0_);
			uri = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp18_ = uri;
			rygel_media_object_add_uri ((RygelMediaObject*) self, _tmp18_);
			_g_free0 (uri);
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* _error_ = NULL;
			RygelTrackerItemFactory* _tmp19_;
			const gchar* _tmp20_;
			GError* _tmp21_;
			const gchar* _tmp22_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp19_ = ((RygelTrackerSearchContainer*) self)->item_factory;
			_tmp20_ = _tmp19_->upload_dir;
			_tmp21_ = _error_;
			_tmp22_ = _tmp21_->message;
			g_warning (_ ("Failed to construct URI for folder “%s”: %s"), _tmp20_, _tmp22_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp23_;
		RygelTrackerItemFactory* _tmp24_;
		const gchar* _tmp25_;
		_tmp23_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		connection = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp24_ = ((RygelTrackerSearchContainer*) self)->item_factory;
		_tmp25_ = _tmp24_->category_iri;
		g_dbus_connection_signal_subscribe (connection, RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_TRACKER_SERVICE, RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_TRACKER_INTERFACE, "GraphUpdated", RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_RESOURCES_PATH, _tmp25_, G_DBUS_SIGNAL_FLAGS_NONE, _rygel_tracker_category_all_container_on_graph_updated_gd_bus_signal_callback, g_object_ref (self), g_object_unref);
		_g_object_unref0 (connection);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = _error_;
		_tmp27_ = _tmp26_->message;
		g_critical (_ ("Could not subscribe to Tracker signals: %s"), _tmp27_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp28_ = ((RygelTrackerSearchContainer*) self)->item_factory;
	_tmp29_ = _tmp28_->category;
	g_message ("rygel-tracker-category-all-container.vala:75: Running cleanup query fo" \
"r %s", _tmp29_);
	_tmp30_ = ((RygelTrackerSearchContainer*) self)->item_factory;
	_tmp31_ = _tmp30_->category;
	_tmp32_ = rygel_tracker_cleanup_query_new (_tmp31_);
	cleanup_query = _tmp32_;
	_tmp33_ = rygel_tracker_root_container_connection;
	rygel_tracker_query_execute ((RygelTrackerQuery*) cleanup_query, _tmp33_, ___lambda5__gasync_ready_callback, g_object_ref (self));
	_rygel_tracker_query_unref0 (cleanup_query);
	return self;
}

RygelTrackerCategoryAllContainer*
rygel_tracker_category_all_container_new (RygelTrackerCategoryContainer* parent)
{
	return rygel_tracker_category_all_container_construct (RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, parent);
}

static void
rygel_tracker_category_all_container_real_add_item_data_free (gpointer _data)
{
	RygelTrackerCategoryAllContainerAddItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->item);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerAddItemData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_tracker_category_all_container_real_add_item (RygelWritableContainer* base,
                                                    RygelMediaFileItem* item,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerAddItemData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	RygelMediaFileItem* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (item != NULL);
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerAddItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_add_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (item);
	_g_object_unref0 (_data_->item);
	_data_->item = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_tracker_category_all_container_real_add_item_co (_data_);
}

static void
rygel_tracker_category_all_container_add_item_finish (RygelWritableContainer* base,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	RygelTrackerCategoryAllContainerAddItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_tracker_category_all_container_add_item_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	RygelTrackerCategoryAllContainerAddItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_category_all_container_real_add_item_co (_data_);
}

static gboolean
rygel_tracker_category_all_container_real_add_item_co (RygelTrackerCategoryAllContainerAddItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	rygel_tracker_category_all_container_create_entry_in_store (_data_->self, _data_->item, rygel_tracker_category_all_container_add_item_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = rygel_tracker_category_all_container_create_entry_in_store_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->urn = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = rygel_tracker_search_container_create_child_id_for_urn ((RygelTrackerSearchContainer*) _data_->self, _data_->urn);
	_data_->_tmp2_ = _data_->_tmp1_;
	rygel_media_object_set_id ((RygelMediaObject*) _data_->item, _data_->_tmp2_);
	_g_free0 (_data_->_tmp2_);
	rygel_media_object_set_parent ((RygelMediaObject*) _data_->item, (RygelMediaContainer*) _data_->self);
	_g_free0 (_data_->urn);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_tracker_category_all_container_real_add_container_data_free (gpointer _data)
{
	RygelTrackerCategoryAllContainerAddContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerAddContainerData, _data_);
}

static void
rygel_tracker_category_all_container_real_add_container (RygelWritableContainer* base,
                                                         RygelMediaContainer* container,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerAddContainerData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (container != NULL);
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerAddContainerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_add_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (container);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_tracker_category_all_container_real_add_container_co (_data_);
}

static void
rygel_tracker_category_all_container_add_container_finish (RygelWritableContainer* base,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	RygelTrackerCategoryAllContainerAddContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
rygel_tracker_category_all_container_real_add_container_co (RygelTrackerCategoryAllContainerAddContainerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, _ ("Not supported"));
	_data_->_inner_error0_ = _data_->_tmp0_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_tracker_category_all_container_real_remove_item_data_free (gpointer _data)
{
	RygelTrackerCategoryAllContainerRemoveItemData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerRemoveItemData, _data_);
}

static void
rygel_tracker_category_all_container_real_remove_item (RygelWritableContainer* base,
                                                       const gchar* id,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerRemoveItemData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (id != NULL);
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerRemoveItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_remove_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_tracker_category_all_container_real_remove_item_co (_data_);
}

static void
rygel_tracker_category_all_container_remove_item_finish (RygelWritableContainer* base,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	RygelTrackerCategoryAllContainerRemoveItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_tracker_category_all_container_remove_item_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	RygelTrackerCategoryAllContainerRemoveItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_category_all_container_real_remove_item_co (_data_);
}

static gboolean
rygel_tracker_category_all_container_real_remove_item_co (RygelTrackerCategoryAllContainerRemoveItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp1_ = rygel_tracker_search_container_get_item_info ((RygelTrackerSearchContainer*) _data_->self, _data_->id, &_data_->_tmp0_);
	_g_free0 (_data_->parent_id);
	_data_->parent_id = _data_->_tmp0_;
	_data_->urn = _data_->_tmp1_;
	_data_->_state_ = 1;
	rygel_tracker_category_all_container_remove_entry_from_store (_data_->self, _data_->urn, rygel_tracker_category_all_container_remove_item_ready, _data_);
	return FALSE;
	_state_1:
	rygel_tracker_category_all_container_remove_entry_from_store_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->urn);
		_g_free0 (_data_->parent_id);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->urn);
	_g_free0 (_data_->parent_id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_tracker_category_all_container_real_remove_container_data_free (gpointer _data)
{
	RygelTrackerCategoryAllContainerRemoveContainerData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerRemoveContainerData, _data_);
}

static void
rygel_tracker_category_all_container_real_remove_container (RygelWritableContainer* base,
                                                            const gchar* id,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerRemoveContainerData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (id != NULL);
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerRemoveContainerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_remove_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_tracker_category_all_container_real_remove_container_co (_data_);
}

static void
rygel_tracker_category_all_container_remove_container_finish (RygelWritableContainer* base,
                                                              GAsyncResult* _res_,
                                                              GError** error)
{
	RygelTrackerCategoryAllContainerRemoveContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
rygel_tracker_category_all_container_real_remove_container_co (RygelTrackerCategoryAllContainerRemoveContainerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, "Not supported");
	_data_->_inner_error0_ = _data_->_tmp0_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_tracker_category_all_container_real_search_data_free (gpointer _data)
{
	RygelTrackerCategoryAllContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerSearchData, _data_);
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

static void
rygel_tracker_category_all_container_real_search (RygelSearchableContainer* base,
                                                  RygelSearchExpression* expression,
                                                  guint offset,
                                                  guint max_count,
                                                  const gchar* sort_criteria,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	RygelTrackerCategoryAllContainer * self;
	RygelTrackerCategoryAllContainerSearchData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (sort_criteria != NULL);
	self = (RygelTrackerCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp2_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	rygel_tracker_category_all_container_real_search_co (_data_);
}

static RygelMediaObjects*
rygel_tracker_category_all_container_search_finish (RygelSearchableContainer* base,
                                                    GAsyncResult* _res_,
                                                    guint* total_matches,
                                                    GError** error)
{
	RygelMediaObjects* result;
	RygelTrackerCategoryAllContainerSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_tracker_category_all_container_search_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	RygelTrackerCategoryAllContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_category_all_container_real_search_co (_data_);
}

static gboolean
rygel_tracker_category_all_container_real_search_co (RygelTrackerCategoryAllContainerSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->expression, _data_->offset, _data_->max_count, _data_->sort_criteria, _data_->cancellable, rygel_tracker_category_all_container_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->total_matches = _data_->_tmp1_;
	_data_->_tmp0_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_tracker_category_all_container_on_graph_updated (RygelTrackerCategoryAllContainer* self,
                                                       GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* signal_path,
                                                       GVariant* parameters)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_path != NULL);
	g_return_if_fail (parameters != NULL);
	rygel_tracker_search_container_get_children_count ((RygelTrackerSearchContainer*) self, NULL, NULL);
}

static void
rygel_tracker_category_all_container_create_entry_in_store_data_free (gpointer _data)
{
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->item);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerCreateEntryInStoreData, _data_);
}

static void
rygel_tracker_category_all_container_create_entry_in_store (RygelTrackerCategoryAllContainer* self,
                                                            RygelMediaFileItem* item,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	RygelMediaFileItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerCreateEntryInStoreData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_create_entry_in_store_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (item);
	_g_object_unref0 (_data_->item);
	_data_->item = _tmp1_;
	rygel_tracker_category_all_container_create_entry_in_store_co (_data_);
}

static gchar*
rygel_tracker_category_all_container_create_entry_in_store_finish (RygelTrackerCategoryAllContainer* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error)
{
	gchar* result;
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_tracker_category_all_container_create_entry_in_store_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_)
{
	RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_category_all_container_create_entry_in_store_co (_data_);
}

static gboolean
rygel_tracker_category_all_container_create_entry_in_store_co (RygelTrackerCategoryAllContainerCreateEntryInStoreData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((RygelTrackerSearchContainer*) _data_->self)->item_factory;
	_data_->_tmp1_ = _data_->_tmp0_->category;
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->category = _data_->_tmp2_;
	_data_->_tmp3_ = rygel_tracker_insertion_query_new (_data_->item, _data_->category);
	_data_->query = _data_->_tmp3_;
	_data_->_tmp4_ = rygel_tracker_root_container_connection;
	_data_->_state_ = 1;
	rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->query, _data_->_tmp4_, rygel_tracker_category_all_container_create_entry_in_store_ready, _data_);
	return FALSE;
	_state_1:
	rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->query, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_rygel_tracker_query_unref0 (_data_->query);
		_g_free0 (_data_->category);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->query->id;
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
	_data_->result = _data_->_tmp6_;
	_rygel_tracker_query_unref0 (_data_->query);
	_g_free0 (_data_->category);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_tracker_category_all_container_remove_entry_from_store_data_free (gpointer _data)
{
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData, _data_);
}

static void
rygel_tracker_category_all_container_remove_entry_from_store (RygelTrackerCategoryAllContainer* self,
                                                              const gchar* id,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_)
{
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_;
	RygelTrackerCategoryAllContainer* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_category_all_container_remove_entry_from_store_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	rygel_tracker_category_all_container_remove_entry_from_store_co (_data_);
}

static void
rygel_tracker_category_all_container_remove_entry_from_store_finish (RygelTrackerCategoryAllContainer* self,
                                                                     GAsyncResult* _res_,
                                                                     GError** error)
{
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_tracker_category_all_container_remove_entry_from_store_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_)
{
	RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_tracker_category_all_container_remove_entry_from_store_co (_data_);
}

static gboolean
rygel_tracker_category_all_container_remove_entry_from_store_co (RygelTrackerCategoryAllContainerRemoveEntryFromStoreData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_tracker_deletion_query_new (_data_->id);
	_data_->query = _data_->_tmp0_;
	_data_->_tmp1_ = rygel_tracker_root_container_connection;
	_data_->_state_ = 1;
	rygel_tracker_query_execute ((RygelTrackerQuery*) _data_->query, _data_->_tmp1_, rygel_tracker_category_all_container_remove_entry_from_store_ready, _data_);
	return FALSE;
	_state_1:
	rygel_tracker_query_execute_finish ((RygelTrackerQuery*) _data_->query, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_rygel_tracker_query_unref0 (_data_->query);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_rygel_tracker_query_unref0 (_data_->query);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GeeArrayList*
rygel_tracker_category_all_container_real_get_create_classes (RygelWritableContainer* base)
{
	GeeArrayList* result;
	RygelTrackerCategoryAllContainer* self;
	GeeArrayList* _tmp0_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_tmp0_ = self->priv->_create_classes;
	result = _tmp0_;
	return result;
}

static void
rygel_tracker_category_all_container_real_set_create_classes (RygelWritableContainer* base,
                                                              GeeArrayList* value)
{
	RygelTrackerCategoryAllContainer* self;
	GeeArrayList* old_value;
	self = (RygelTrackerCategoryAllContainer*) base;
	old_value = rygel_tracker_category_all_container_real_get_create_classes (base);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_create_classes);
		self->priv->_create_classes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_tracker_category_all_container_properties[RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY]);
	}
}

static GeeArrayList*
rygel_tracker_category_all_container_real_get_search_classes (RygelSearchableContainer* base)
{
	GeeArrayList* result;
	RygelTrackerCategoryAllContainer* self;
	GeeArrayList* _tmp0_;
	self = (RygelTrackerCategoryAllContainer*) base;
	_tmp0_ = self->priv->_search_classes;
	result = _tmp0_;
	return result;
}

static void
rygel_tracker_category_all_container_real_set_search_classes (RygelSearchableContainer* base,
                                                              GeeArrayList* value)
{
	RygelTrackerCategoryAllContainer* self;
	GeeArrayList* old_value;
	self = (RygelTrackerCategoryAllContainer*) base;
	old_value = rygel_tracker_category_all_container_real_get_search_classes (base);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_search_classes);
		self->priv->_search_classes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_tracker_category_all_container_properties[RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY]);
	}
}

static void
rygel_tracker_category_all_container_class_init (RygelTrackerCategoryAllContainerClass * klass,
                                                 gpointer klass_data)
{
	rygel_tracker_category_all_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelTrackerCategoryAllContainer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_tracker_category_all_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_tracker_category_all_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_category_all_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY, rygel_tracker_category_all_container_properties[RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY] = g_param_spec_object ("create-classes", "create-classes", "create-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY, rygel_tracker_category_all_container_properties[RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY] = g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_tracker_category_all_container_rygel_writable_container_interface_init (RygelWritableContainerIface * iface,
                                                                              gpointer iface_data)
{
	rygel_tracker_category_all_container_rygel_writable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_item = (void (*) (RygelWritableContainer*, RygelMediaFileItem*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_category_all_container_real_add_item;
	iface->add_item_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_tracker_category_all_container_add_item_finish;
	iface->add_container = (void (*) (RygelWritableContainer*, RygelMediaContainer*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_category_all_container_real_add_container;
	iface->add_container_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_tracker_category_all_container_add_container_finish;
	iface->remove_item = (void (*) (RygelWritableContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_category_all_container_real_remove_item;
	iface->remove_item_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_tracker_category_all_container_remove_item_finish;
	iface->remove_container = (void (*) (RygelWritableContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_category_all_container_real_remove_container;
	iface->remove_container_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_tracker_category_all_container_remove_container_finish;
	iface->get_create_classes = rygel_tracker_category_all_container_real_get_create_classes;
	iface->set_create_classes = rygel_tracker_category_all_container_real_set_create_classes;
}

static void
rygel_tracker_category_all_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface,
                                                                                gpointer iface_data)
{
	rygel_tracker_category_all_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (RygelSearchableContainer*, RygelSearchExpression*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_tracker_category_all_container_real_search;
	iface->search_finish = (RygelMediaObjects* (*) (RygelSearchableContainer*, GAsyncResult*, guint*, GError**)) rygel_tracker_category_all_container_search_finish;
	iface->get_search_classes = rygel_tracker_category_all_container_real_get_search_classes;
	iface->set_search_classes = rygel_tracker_category_all_container_real_set_search_classes;
}

static void
rygel_tracker_category_all_container_instance_init (RygelTrackerCategoryAllContainer * self,
                                                    gpointer klass)
{
	self->priv = rygel_tracker_category_all_container_get_instance_private (self);
}

static void
rygel_tracker_category_all_container_finalize (GObject * obj)
{
	RygelTrackerCategoryAllContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainer);
	_g_object_unref0 (self->priv->_create_classes);
	_g_object_unref0 (self->priv->_search_classes);
	G_OBJECT_CLASS (rygel_tracker_category_all_container_parent_class)->finalize (obj);
}

/**
 * A search container that contains all the items in a category.
 */
static GType
rygel_tracker_category_all_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerCategoryAllContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_category_all_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerCategoryAllContainer), 0, (GInstanceInitFunc) rygel_tracker_category_all_container_instance_init, NULL };
	static const GInterfaceInfo rygel_writable_container_info = { (GInterfaceInitFunc) rygel_tracker_category_all_container_rygel_writable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_tracker_category_all_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_tracker_category_all_container_type_id;
	rygel_tracker_category_all_container_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, "RygelTrackerCategoryAllContainer", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_tracker_category_all_container_type_id, RYGEL_TYPE_WRITABLE_CONTAINER, &rygel_writable_container_info);
	g_type_add_interface_static (rygel_tracker_category_all_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
	RygelTrackerCategoryAllContainer_private_offset = g_type_add_instance_private (rygel_tracker_category_all_container_type_id, sizeof (RygelTrackerCategoryAllContainerPrivate));
	return rygel_tracker_category_all_container_type_id;
}

GType
rygel_tracker_category_all_container_get_type (void)
{
	static volatile gsize rygel_tracker_category_all_container_type_id__once = 0;
	if (g_once_init_enter (&rygel_tracker_category_all_container_type_id__once)) {
		GType rygel_tracker_category_all_container_type_id;
		rygel_tracker_category_all_container_type_id = rygel_tracker_category_all_container_get_type_once ();
		g_once_init_leave (&rygel_tracker_category_all_container_type_id__once, rygel_tracker_category_all_container_type_id);
	}
	return rygel_tracker_category_all_container_type_id__once;
}

static void
_vala_rygel_tracker_category_all_container_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	RygelTrackerCategoryAllContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainer);
	switch (property_id) {
		case RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY:
		g_value_set_object (value, rygel_writable_container_get_create_classes ((RygelWritableContainer*) self));
		break;
		case RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY:
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_tracker_category_all_container_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	RygelTrackerCategoryAllContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TRACKER_TYPE_CATEGORY_ALL_CONTAINER, RygelTrackerCategoryAllContainer);
	switch (property_id) {
		case RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY:
		rygel_writable_container_set_create_classes ((RygelWritableContainer*) self, g_value_get_object (value));
		break;
		case RYGEL_TRACKER_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY:
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

