/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.views;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.controls.LayoutFactory;
import info.monitorenter.gui.chart.layouts.FlowLayoutCorrectMinimumSize;
import info.monitorenter.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChartPanel
extends JPanel
implements PropertyChangeListener {
    private Chart2D m_chart;
    protected JPanel m_labelPanel;

    public ChartPanel(Chart2D chart) {
        this.m_chart = chart;
        this.setBackground(chart.getBackground());
        chart.setPaintLabels(false);
        LayoutFactory factory = LayoutFactory.getInstance();
        factory.createPopupMenu(chart, true);
        this.setLayout(new BorderLayout());
        this.add((Component)chart, "Center");
        this.m_labelPanel = new JPanel();
        this.m_labelPanel.setFont(chart.getFont());
        this.m_labelPanel.setLayout(new FlowLayoutCorrectMinimumSize(0));
        this.m_labelPanel.setBackground(chart.getBackground());
        for (ITrace2D trace : chart) {
            JLabel label = factory.createContextMenuLabel(chart, trace, true);
            if (label != null) {
                this.m_labelPanel.add(label);
            }
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_PHYSICALUNITS", this);
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_NAME", this);
        }
        this.add((Component)this.m_labelPanel, "South");
        chart.addPropertyChangeListener("Chart2D.PROPERTY_BACKGROUND_COLOR", this);
        List<IAxis> allAxes = chart.getAxes();
        for (IAxis currentAxis : allAxes) {
            currentAxis.addPropertyChangeListener("ITrace2D.PROPERTY_ADD_REMOVE_TRACE", this);
        }
        chart.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_X", this);
        chart.addPropertyChangeListener("Chart2D.PROPERTY_AXIS_Y", this);
    }

    private boolean containsTraceLabel(ITrace2D tracetoAdd) {
        boolean result = false;
        Component[] traceLabels = this.m_labelPanel.getComponents();
        String labelName = tracetoAdd.getLabel();
        for (int i = traceLabels.length - 1; i >= 0; --i) {
            JLabel label = (JLabel)traceLabels[i];
            if (!labelName.equals(label.getText())) continue;
            result = true;
            break;
        }
        return result;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("Chart2D.PROPERTY_BACKGROUND_COLOR")) {
            Color color = (Color)evt.getNewValue();
            this.setBackground(color);
            this.m_labelPanel.setBackground(color);
        } else if (prop.equals("ITrace2D.PROPERTY_ADD_REMOVE_TRACE")) {
            ITrace2D oldTrace = (ITrace2D)evt.getOldValue();
            ITrace2D newTrace = (ITrace2D)evt.getNewValue();
            if (oldTrace == null && newTrace != null) {
                JLabel label;
                if (!this.containsTraceLabel(newTrace) && (label = LayoutFactory.getInstance().createContextMenuLabel(this.m_chart, newTrace, true)) != null) {
                    this.m_labelPanel.add(label);
                    this.invalidate();
                    this.m_labelPanel.invalidate();
                    this.validateTree();
                    this.m_labelPanel.doLayout();
                }
            } else if (oldTrace != null && newTrace == null) {
                String labelName = oldTrace.getLabel();
                if (!StringUtil.isEmpty(labelName)) {
                    Component[] labels = this.m_labelPanel.getComponents();
                    for (int i = 0; i < labels.length; ++i) {
                        if (!((JLabel)labels[i]).getText().equals(labelName)) continue;
                        this.m_labelPanel.remove(labels[i]);
                        this.m_chart.removePropertyChangeListener((PropertyChangeListener)((Object)labels[i]));
                        oldTrace.removePropertyChangeListener((PropertyChangeListener)((Object)labels[i]));
                        MouseListener[] mouseListeners = labels[i].getMouseListeners();
                        for (int j = 0; j < mouseListeners.length; ++j) {
                            labels[i].removeMouseListener(mouseListeners[j]);
                        }
                        this.m_labelPanel.doLayout();
                        this.doLayout();
                        break;
                    }
                }
            } else if (prop.equals("Chart2D.PROPERTY_AXIS_X") || prop.equals("Chart2D.PROPERTY_AXIS_Y")) {
                IAxis newAxis = (IAxis)evt.getNewValue();
                IAxis oldAxis = (IAxis)evt.getOldValue();
                if (oldAxis != null) {
                    oldAxis.removePropertyChangeListener("ITrace2D.PROPERTY_ADD_REMOVE_TRACE", this);
                }
                if (newAxis != null) {
                    newAxis.addPropertyChangeListener("ITrace2D.PROPERTY_ADD_REMOVE_TRACE", this);
                }
            } else if (prop.equals("ITrace2D.PROPERTY_LABEL")) {
                JLabel label;
                ITrace2D trace = (ITrace2D)evt.getSource();
                String oldLabel = (String)evt.getOldValue();
                String newLabel = (String)evt.getNewValue();
                if (!StringUtil.isEmpty(oldLabel) && StringUtil.isEmpty(newLabel)) {
                    Component[] labels = this.m_labelPanel.getComponents();
                    for (int i = 0; i < labels.length; ++i) {
                        if (!((JLabel)labels[i]).getText().equals(oldLabel)) continue;
                        this.m_labelPanel.remove(labels[i]);
                        this.m_chart.removePropertyChangeListener((PropertyChangeListener)((Object)labels[i]));
                        trace.removePropertyChangeListener((PropertyChangeListener)((Object)labels[i]));
                        MouseListener[] mouseListeners = labels[i].getMouseListeners();
                        for (int j = 0; j < mouseListeners.length; ++j) {
                            labels[i].removeMouseListener(mouseListeners[j]);
                        }
                        this.m_labelPanel.doLayout();
                        this.doLayout();
                        break;
                    }
                } else if (StringUtil.isEmpty(oldLabel) && !StringUtil.isEmpty(newLabel) && !this.containsTraceLabel(newTrace) && (label = LayoutFactory.getInstance().createContextMenuLabel(this.m_chart, newTrace, true)) != null) {
                    this.m_labelPanel.add(label);
                    this.invalidate();
                    this.m_labelPanel.invalidate();
                    this.validateTree();
                    this.m_labelPanel.doLayout();
                }
            } else {
                throw new IllegalArgumentException("Bad property change event for add / remove trace.");
            }
        }
    }
}

