/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javajs.api.JSONEncodable;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.BS;
import javajs.util.Base64;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M34;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.modelset.BondSet;
import org.jmol.script.ScriptContext;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.viewer.Viewer;

public class SV
extends T
implements JSONEncodable {
    public static final SV vT = SV.newSV(1073742335, 1, "true");
    public static final SV vF = SV.newSV(1073742334, 0, "false");
    public static final SV vNaN = SV.newSV(3, Integer.MAX_VALUE, Float.valueOf(Float.NaN));
    public int index = Integer.MAX_VALUE;
    public String myName;
    static final P3 pt0 = new P3();

    public static SV newV(int tok, Object value) {
        SV sv = new SV();
        sv.tok = tok;
        sv.value = value;
        return sv;
    }

    public static SV newI(int i) {
        SV sv = new SV();
        sv.tok = 2;
        sv.intValue = i;
        return sv;
    }

    public static SV newF(float f) {
        if (f != f) {
            return vNaN;
        }
        SV sv = new SV();
        sv.tok = 3;
        sv.value = Float.valueOf(f);
        return sv;
    }

    public static SV newS(String s) {
        return SV.newV(4, s);
    }

    public static SV newT(T x) {
        return SV.newSV(x.tok, x.intValue, x.value);
    }

    static SV newSV(int tok, int intValue, Object value) {
        SV sv = SV.newV(tok, value);
        sv.intValue = intValue;
        return sv;
    }

    SV setv(SV v) {
        this.index = v.index;
        this.intValue = v.intValue;
        this.tok = v.tok;
        this.value = v.value;
        return this;
    }

    static int sizeOf(T x) {
        switch (x == null ? 0 : x.tok) {
            case 10: {
                return SV.bsSelectToken(x).cardinality();
            }
            case 15: {
                return ((BArray)x.value).data.length;
            }
            case 4: {
                return ((String)x.value).length();
            }
            case 7: {
                return x.intValue == Integer.MAX_VALUE ? ((SV)x).getList().size() : SV.sizeOf(SV.selectItemTok(x, Integer.MIN_VALUE));
            }
            case 6: {
                return ((Map)x.value).size();
            }
            case 14: {
                return ((ScriptContext)x.value).getFullMap().size();
            }
            case 1073742334: 
            case 1073742335: {
                return -1;
            }
            case 2: {
                return -2;
            }
            case 3: {
                return -4;
            }
            case 8: {
                return -8;
            }
            case 9: {
                return -16;
            }
            case 11: {
                return -32;
            }
            case 12: {
                return -64;
            }
        }
        return 0;
    }

    public static boolean isVariableType(Object x) {
        return x instanceof SV || x instanceof Boolean || x instanceof Integer || x instanceof Float || x instanceof String || x instanceof T3 || x instanceof BS || x instanceof P4 || x instanceof Quat || x instanceof M34 || x instanceof Map || x instanceof Lst || x instanceof BArray || x instanceof ScriptContext || SV.isArray(x);
    }

    private static boolean isArray(Object x) {
        return x instanceof SV[] || x instanceof int[] || x instanceof byte[] || x instanceof float[] || x instanceof double[] || x instanceof String[] || x instanceof T3[] || x instanceof int[][] || x instanceof float[][] || x instanceof String[][] || x instanceof double[][] || x instanceof Float[] || x instanceof Object[];
    }

    public static SV getVariable(Object x) {
        if (x == null) {
            return SV.newS("");
        }
        if (x instanceof SV) {
            return (SV)x;
        }
        if (x instanceof Boolean) {
            return SV.getBoolean((Boolean)x);
        }
        if (x instanceof Integer) {
            return SV.newI((Integer)x);
        }
        if (x instanceof Float) {
            return SV.newV(3, x);
        }
        if (x instanceof String) {
            if ((x = SV.unescapePointOrBitsetAsVariable(x)) instanceof SV) {
                return (SV)x;
            }
            return SV.newV(4, x);
        }
        if (x instanceof P3) {
            return SV.newV(8, x);
        }
        if (x instanceof V3) {
            return SV.newV(8, P3.newP((V3)x));
        }
        if (x instanceof BS) {
            return SV.newV(10, x);
        }
        if (x instanceof P4) {
            return SV.newV(9, x);
        }
        if (x instanceof Quat) {
            return SV.newV(9, ((Quat)x).toPoint4f());
        }
        if (x instanceof M34) {
            return SV.newV(x instanceof M4 ? 12 : 11, x);
        }
        if (x instanceof Map) {
            return SV.getVariableMap((Map)x);
        }
        if (x instanceof Lst) {
            return SV.getVariableList((Lst)x);
        }
        if (x instanceof BArray) {
            return SV.newV(15, x);
        }
        if (x instanceof ScriptContext) {
            return SV.newV(14, x);
        }
        if (SV.isASV(x)) {
            return SV.getVariableAV((SV[])x);
        }
        if (AU.isAI(x)) {
            return SV.getVariableAI((int[])x);
        }
        if (AU.isAB(x)) {
            return SV.getVariableAB((byte[])x);
        }
        if (AU.isAF(x)) {
            return SV.getVariableAF((float[])x);
        }
        if (AU.isAD(x)) {
            return SV.getVariableAD((double[])x);
        }
        if (AU.isAS(x)) {
            return SV.getVariableAS((String[])x);
        }
        if (AU.isAP(x)) {
            return SV.getVariableAP((T3[])x);
        }
        if (AU.isAII(x)) {
            return SV.getVariableAII((int[][])x);
        }
        if (AU.isAFF(x)) {
            return SV.getVariableAFF((float[][])x);
        }
        if (AU.isASS(x)) {
            return SV.getVariableASS((String[][])x);
        }
        if (AU.isADD(x)) {
            return SV.getVariableADD((double[][])x);
        }
        if (AU.isAFloat(x)) {
            return SV.newV(13, x);
        }
        return SV.newJSVar(x);
    }

    private static boolean isASV(Object x) {
        if (!Viewer.isSwingJS) {
            // empty if block
        }
        return x instanceof SV[];
    }

    private static SV newJSVar(Object x) {
        if (x instanceof Object[]) {
            return SV.getVariableAO((Object[])x);
        }
        return SV.newS(x.toString());
    }

    public static SV getVariableMap(Map<String, ?> x) {
        Map<String, ?> ht = x;
        Object o = null;
        Iterator<?> iterator = ht.values().iterator();
        if (iterator.hasNext()) {
            Object oo = iterator.next();
            o = oo;
        }
        if (!(o instanceof SV)) {
            Hashtable x2 = new Hashtable();
            for (Map.Entry<String, ?> entry : ht.entrySet()) {
                x2.put(entry.getKey(), SV.getVariable(entry.getValue()));
            }
            x = x2;
        }
        return SV.newV(6, x);
    }

    public static SV getVariableList(Lst<?> v) {
        int len = v.size();
        if (len > 0 && v.get(0) instanceof SV) {
            return SV.newV(7, v);
        }
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < len; ++i) {
            objects.addLast(SV.getVariable(v.get(i)));
        }
        return SV.newV(7, objects);
    }

    static SV getVariableAV(SV[] v) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < v.length; ++i) {
            objects.addLast(v[i]);
        }
        return SV.newV(7, objects);
    }

    public static SV getVariableAD(double[] f) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < f.length; ++i) {
            objects.addLast(SV.newV(3, Float.valueOf((float)f[i])));
        }
        return SV.newV(7, objects);
    }

    static SV getVariableAO(Object[] o) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < o.length; ++i) {
            objects.addLast(SV.getVariable(o[i]));
        }
        return SV.newV(7, objects);
    }

    static SV getVariableAS(String[] s) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < s.length; ++i) {
            objects.addLast(SV.newV(4, s[i]));
        }
        return SV.newV(7, objects);
    }

    static SV getVariableAP(T3[] p) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < p.length; ++i) {
            objects.addLast(SV.newV(8, p[i]));
        }
        return SV.newV(7, objects);
    }

    static SV getVariableAFF(float[][] fx) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < fx.length; ++i) {
            objects.addLast(SV.getVariableAF(fx[i]));
        }
        return SV.newV(7, objects);
    }

    static SV getVariableADD(double[][] fx) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < fx.length; ++i) {
            objects.addLast(SV.getVariableAD(fx[i]));
        }
        return SV.newV(7, objects);
    }

    static SV getVariableASS(String[][] fx) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < fx.length; ++i) {
            objects.addLast(SV.getVariableAS(fx[i]));
        }
        return SV.newV(7, objects);
    }

    static SV getVariableAII(int[][] ix) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < ix.length; ++i) {
            objects.addLast(SV.getVariableAI(ix[i]));
        }
        return SV.newV(7, objects);
    }

    static SV getVariableAF(float[] f) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < f.length; ++i) {
            objects.addLast(SV.newV(3, Float.valueOf(f[i])));
        }
        return SV.newV(7, objects);
    }

    static SV getVariableAI(int[] ix) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < ix.length; ++i) {
            objects.addLast(SV.newI(ix[i]));
        }
        return SV.newV(7, objects);
    }

    static SV getVariableAB(byte[] ix) {
        Lst<SV> objects = new Lst<SV>();
        for (int i = 0; i < ix.length; ++i) {
            objects.addLast(SV.newI(ix[i]));
        }
        return SV.newV(7, objects);
    }

    public SV setName(String name) {
        this.myName = name;
        return this;
    }

    boolean canIncrement() {
        switch (this.tok) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    boolean increment(int n) {
        switch (this.tok) {
            case 2: {
                this.intValue += n;
                return true;
            }
            case 3: {
                this.value = Float.valueOf(((Float)this.value).floatValue() + (float)n);
                return true;
            }
        }
        return false;
    }

    public boolean asBoolean() {
        return SV.bValue(this);
    }

    public int asInt() {
        return SV.iValue(this);
    }

    public float asFloat() {
        return SV.fValue(this);
    }

    public String asString() {
        return SV.sValue(this);
    }

    public static Object oValue(Object xx) {
        if (!(xx instanceof SV)) {
            return xx;
        }
        SV x = (SV)xx;
        switch (x.tok) {
            case 1073742335: {
                return Boolean.TRUE;
            }
            case 0: 
            case 1073742334: {
                return Boolean.FALSE;
            }
            case 2: {
                return x.intValue;
            }
            case 10: 
            case 1275068418: {
                return SV.selectItemVar((SV)x).value;
            }
        }
        return x.value;
    }

    static Object nValue(T x) {
        int iValue;
        switch (x == null ? 0 : x.tok) {
            case 3: {
                return x.value;
            }
            case 2: {
                iValue = x.intValue;
                break;
            }
            case 4: {
                if (((String)x.value).indexOf(".") >= 0) {
                    return Float.valueOf(SV.toFloat((String)x.value));
                }
                iValue = (int)SV.toFloat((String)x.value);
                break;
            }
            case 8: {
                return Float.valueOf(((T3)x.value).length());
            }
            default: {
                iValue = 0;
            }
        }
        return iValue;
    }

    public static boolean bValue(T x) {
        switch (x == null ? 0 : x.tok) {
            case 14: 
            case 1073742335: {
                return true;
            }
            case 1073742334: {
                return false;
            }
            case 2: {
                return x.intValue != 0;
            }
            case 3: 
            case 4: 
            case 7: {
                return SV.fValue(x) != 0.0f;
            }
            case 10: 
            case 15: {
                return SV.iValue(x) != 0;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return Math.abs(SV.fValue(x)) > 1.0E-4f;
            }
            case 6: {
                return !((SV)x).getMap().isEmpty();
            }
        }
        return false;
    }

    public static int iValue(T x) {
        switch (x == null ? 0 : x.tok) {
            case 1073742335: {
                return 1;
            }
            case 1073742334: {
                return 0;
            }
            case 2: {
                return x.intValue;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 134221850: {
                return (int)SV.fValue(x);
            }
            case 10: {
                return SV.bsSelectToken(x).cardinality();
            }
            case 15: {
                return ((BArray)x.value).data.length;
            }
        }
        return 0;
    }

    public static float fValue(T x) {
        switch (x == null ? 0 : x.tok) {
            case 1073742335: {
                return 1.0f;
            }
            case 1073742334: {
                return 0.0f;
            }
            case 2: {
                return x.intValue;
            }
            case 3: {
                return ((Float)x.value).floatValue();
            }
            case 7: {
                int i = x.intValue;
                if (i == Integer.MAX_VALUE) {
                    return ((SV)x).getList().size();
                }
            }
            case 4: {
                return SV.toFloat(SV.sValue(x));
            }
            case 10: 
            case 15: {
                return SV.iValue(x);
            }
            case 8: {
                return ((P3)x.value).length();
            }
            case 9: {
                return Measure.distanceToPlane((P4)x.value, pt0);
            }
            case 11: {
                P3 pt = new P3();
                ((M3)x.value).rotate(pt);
                return pt.length();
            }
            case 12: {
                P3 pt1 = new P3();
                ((M4)x.value).rotTrans(pt1);
                return pt1.length();
            }
        }
        return 0.0f;
    }

    public static String sValue(T x) {
        if (x == null) {
            return "";
        }
        switch (x.tok) {
            case 1073742335: {
                return "true";
            }
            case 1073742334: {
                return "false";
            }
            case 2: {
                return "" + x.intValue;
            }
            case 10: {
                BS bs = SV.bsSelectToken(x);
                return x.value instanceof BondSet ? Escape.eBond(bs) : Escape.eBS(bs);
            }
            case 7: {
                Lst<SV> sv = ((SV)x).getList();
                int i = x.intValue;
                if (i <= 0) {
                    i = sv.size() - i;
                }
                if (i != Integer.MAX_VALUE) {
                    return i < 1 || i > sv.size() ? "" : SV.sValue((T)sv.get(i - 1));
                }
            }
            case 6: 
            case 14: {
                if (x.value instanceof String) {
                    return (String)x.value;
                }
                SB sb = new SB();
                SV.sValueArray(sb, (SV)x, "", "", false, true, true, Integer.MAX_VALUE, false);
                return PT.rep(sb.toString(), "\n\u0000", " ");
            }
            case 4: {
                String s = (String)x.value;
                int i = x.intValue;
                if (i <= 0) {
                    i = s.length() - i;
                }
                if (i == Integer.MAX_VALUE) {
                    return s;
                }
                if (i < 1 || i > s.length()) {
                    return "";
                }
                return "" + s.charAt(i - 1);
            }
            case 8: {
                return Escape.eP((T3)x.value);
            }
            case 9: {
                return Escape.eP4((P4)x.value);
            }
            case 11: 
            case 12: {
                return Escape.e(x.value);
            }
        }
        return x.value.toString();
    }

    private static void sValueArray(SB sb, SV vx, String path, String tabs, boolean isEscaped, boolean isRaw, boolean addValues, int maxLevels, boolean skipEmpty) {
        switch (vx.tok) {
            case 6: 
            case 7: 
            case 14: {
                String thiskey = ";" + vx.hashCode() + ";";
                if (path.indexOf(thiskey) >= 0) {
                    sb.append(isEscaped ? (vx.tok == 7 ? "[ ]" : "{ }") : (vx.tok == 7 ? "" : "\u0000") + "\"<" + (vx.myName == null ? "circular reference" : vx.myName) + ">\"");
                    break;
                }
                path = path + thiskey;
                if (vx.tok == 7) {
                    if (!addValues) {
                        return;
                    }
                    if (!isRaw) {
                        sb.append(isEscaped ? "[ " : tabs + "[\n");
                    }
                    Lst<SV> sx = vx.getList();
                    for (int i = 0; i < sx.size(); ++i) {
                        if (isEscaped && i > 0) {
                            sb.append(",");
                        }
                        SV sv = (SV)sx.get(i);
                        SV.sValueArray(sb, sv, path, tabs + "  ", isEscaped, tabs.length() == 0 && !isEscaped && SV.isRawType(sv.tok), addValues, maxLevels, skipEmpty);
                        if (isEscaped) continue;
                        sb.append("\n");
                    }
                    if (isRaw) break;
                    sb.append(isEscaped ? " ]" : tabs + "]");
                    break;
                }
                if (--maxLevels < 0) break;
                Map<String, SV> ht = vx.tok == 14 ? ((ScriptContext)vx.value).getFullMap() : vx.getMap();
                SV.sValueAddKeys(sb, path, ht, tabs, isEscaped, addValues, maxLevels, skipEmpty);
                break;
            }
            default: {
                if (!addValues) {
                    return;
                }
                if (!isRaw && !isEscaped) {
                    sb.append(tabs);
                }
                sb.append(isEscaped ? vx.escape() : SV.sValue(vx));
            }
        }
    }

    private static void sValueAddKeys(SB sb, String path, Map<String, SV> ht, String tabs, boolean isEscaped, boolean addValues, int maxLevels, boolean skipEmpty) {
        if (maxLevels < 0) {
            return;
        }
        Set<String> keyset = ht.keySet();
        Object[] keys = ht.keySet().toArray(new String[keyset.size()]);
        Arrays.sort(keys);
        if (isEscaped) {
            sb.append("{ ");
            String sep = "";
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                SV val = ht.get(key);
                if (skipEmpty && (val.tok == 7 && val.getList().size() == 0 || val.tok == 6 && val.getMap().isEmpty())) continue;
                if (addValues) {
                    sb.append(sep).append(PT.esc((String)key)).append(":");
                } else {
                    sb.appendC(' ').append((String)key);
                }
                SV.sValueArray(sb, val, path, tabs + "  ", true, false, addValues, maxLevels, skipEmpty);
                sep = ",";
            }
            sb.append(" }");
            if (!addValues) {
                sb.append("\n");
            }
            return;
        }
        sb.append(tabs).append("{\n");
        tabs = tabs + "  ";
        for (int i = 0; i < keys.length; ++i) {
            sb.append(tabs);
            Object key = keys[i];
            sb.append(PT.esc((String)key)).append("  :");
            SB sb2 = new SB();
            if (!(ht.get(key) instanceof SV)) {
                ht.put((String)key, SV.getVariable(ht.get(key)));
            }
            SV v = ht.get(key);
            isEscaped = SV.isRawType(v.tok);
            SV.sValueArray(sb2, v, path, tabs, isEscaped, false, addValues, maxLevels, skipEmpty);
            String value = sb2.toString();
            if (isEscaped && addValues) {
                sb.append("  ");
            } else {
                sb.append("\n");
            }
            sb.append(value).append("\n");
        }
        sb.append(tabs.substring(1)).append("}");
    }

    private static boolean isRawType(int tok) {
        switch (tok) {
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 1073742334: 
            case 1073742335: {
                return true;
            }
        }
        return false;
    }

    public static P3 ptValue(SV x) {
        switch (x.tok) {
            case 8: {
                return (P3)x.value;
            }
            case 4: {
                Object o = Escape.uP((String)x.value);
                if (!(o instanceof P3)) break;
                return (P3)o;
            }
        }
        return null;
    }

    public static P4 pt4Value(SV x) {
        switch (x.tok) {
            case 9: {
                return (P4)x.value;
            }
            case 4: {
                Object o = Escape.uP((String)x.value);
                if (!(o instanceof P4)) break;
                return (P4)o;
            }
        }
        return null;
    }

    private static float toFloat(String s) {
        return s.equalsIgnoreCase("true") ? 1.0f : (s.length() == 0 || s.equalsIgnoreCase("false") ? 0.0f : PT.parseFloatStrict(PT.trim(s, " \t\n")));
    }

    public static SV concatList(SV x1, SV x2, boolean asNew) {
        int i;
        Lst<SV> v1 = x1.getList();
        Lst<SV> v2 = x2.getList();
        if (!asNew) {
            if (v2 == null) {
                v1.addLast(SV.newT(x2));
            } else {
                for (int i2 = 0; i2 < v2.size(); ++i2) {
                    v1.addLast((SV)v2.get(i2));
                }
            }
            return x1;
        }
        Lst<SV> vlist = new Lst<SV>();
        if (v1 == null) {
            vlist.addLast(x1);
        } else {
            for (i = 0; i < v1.size(); ++i) {
                vlist.addLast((SV)v1.get(i));
            }
        }
        if (v2 == null) {
            vlist.addLast(x2);
        } else {
            for (i = 0; i < v2.size(); ++i) {
                vlist.addLast((SV)v2.get(i));
            }
        }
        return SV.getVariableList(vlist);
    }

    private static BS bsSelectToken(T x) {
        return (BS)SV.selectItemTok((T)x, (int)Integer.MIN_VALUE).value;
    }

    static BS bsSelectRange(T x, int n) {
        x = SV.selectItemTok(x, Integer.MIN_VALUE);
        x = SV.selectItemTok(x, n <= 0 ? n : 1);
        x = SV.selectItemTok(x, n <= 0 ? 0x7FFFFFFE : n);
        return (BS)x.value;
    }

    static SV selectItemVar(SV var) {
        return var.index != Integer.MAX_VALUE || (var.tok == 7 || var.tok == 15) && var.intValue == Integer.MAX_VALUE ? var : (SV)SV.selectItemTok(var, Integer.MIN_VALUE);
    }

    static T selectItemTok(T tokenIn, int i2) {
        boolean isOne;
        switch (tokenIn.tok) {
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            default: {
                return tokenIn instanceof SV && ((SV)tokenIn).myName != null ? SV.newI(0).setv((SV)tokenIn) : tokenIn;
            }
        }
        BS bs = null;
        String s = null;
        int i1 = tokenIn.intValue;
        boolean bl = isOne = i2 == Integer.MIN_VALUE;
        if (i1 == Integer.MAX_VALUE) {
            return SV.newSV(tokenIn.tok, isOne ? i1 : i2, tokenIn.value);
        }
        int len = 0;
        boolean isInputSelected = tokenIn instanceof SV && ((SV)tokenIn).index != Integer.MAX_VALUE;
        SV tokenOut = SV.newSV(tokenIn.tok, Integer.MAX_VALUE, null);
        switch (tokenIn.tok) {
            case 10: {
                if (tokenIn.value instanceof BondSet) {
                    bs = BondSet.newBS((BS)tokenIn.value, ((BondSet)tokenIn.value).associatedAtoms);
                    len = bs.cardinality();
                    break;
                }
                bs = BSUtil.copy((BS)tokenIn.value);
                len = isInputSelected ? 1 : bs.cardinality();
                break;
            }
            case 15: {
                len = ((BArray)((SV)tokenIn).value).data.length;
                break;
            }
            case 7: {
                len = ((SV)tokenIn).getList().size();
                break;
            }
            case 4: {
                s = (String)tokenIn.value;
                len = s.length();
                break;
            }
            case 11: {
                len = -3;
                break;
            }
            case 12: {
                len = -4;
            }
        }
        if (len < 0) {
            len = -len;
            if (i1 > 0 && Math.abs(i1) > len) {
                int col = i1 % 10;
                int row = (i1 - col) / 10;
                if (col > 0 && col <= len && row <= len) {
                    if (tokenIn.tok == 11) {
                        return SV.newV(3, Float.valueOf(((M3)tokenIn.value).getElement(row - 1, col - 1)));
                    }
                    return SV.newV(3, Float.valueOf(((M4)tokenIn.value).getElement(row - 1, col - 1)));
                }
                return SV.newV(4, "");
            }
            if (Math.abs(i1) > len) {
                return SV.newV(4, "");
            }
            float[] data = new float[len];
            if (len == 3) {
                if (i1 < 0) {
                    ((M3)tokenIn.value).getColumn(-1 - i1, data);
                } else {
                    ((M3)tokenIn.value).getRow(i1 - 1, data);
                }
            } else if (i1 < 0) {
                ((M4)tokenIn.value).getColumn(-1 - i1, data);
            } else {
                ((M4)tokenIn.value).getRow(i1 - 1, data);
            }
            if (isOne) {
                return SV.getVariableAF(data);
            }
            if (i2 < 1 || i2 > len) {
                return SV.newV(4, "");
            }
            return SV.newV(3, Float.valueOf(data[i2 - 1]));
        }
        if (i1 <= 0) {
            i1 = len + i1;
        }
        if (!isOne) {
            if (i1 < 1) {
                i1 = 1;
            }
            if (i2 == 0) {
                i2 = len;
            } else if (i2 < 0) {
                i2 = len + i2;
            }
            if (i2 < i1) {
                i2 = i1;
            }
        }
        switch (tokenIn.tok) {
            case 10: {
                tokenOut.value = bs;
                if (isInputSelected) {
                    if (i1 <= 1) break;
                    bs.clearAll();
                    break;
                }
                if (isOne) {
                    if (i1 == len) {
                        i2 = bs.length() - 1;
                    } else if (i1 == 1) {
                        i2 = bs.nextSetBit(0);
                    }
                    if (i2 >= -1) {
                        bs.clearAll();
                        if (i2 < 0) break;
                        bs.set(i2);
                        break;
                    }
                    i2 = i1;
                }
                int n = 0;
                int j = bs.nextSetBit(0);
                while (j >= 0) {
                    if (++n < i1 || n > i2) {
                        bs.clear(j);
                    }
                    j = bs.nextSetBit(j + 1);
                }
                break;
            }
            case 4: {
                tokenOut.value = --i1 < 0 || i1 >= len ? "" : (isOne ? s.substring(i1, i1 + 1) : s.substring(i1, Math.min(i2, len)));
                break;
            }
            case 7: {
                if (--i1 < 0 || i1 >= len) {
                    return SV.newV(4, "");
                }
                if (isOne) {
                    return (T)((SV)tokenIn).getList().get(i1);
                }
                Lst<SV> o2 = new Lst<SV>();
                Lst<SV> o1 = ((SV)tokenIn).getList();
                int nn = Math.min(i2, len) - i1;
                for (int i = 0; i < nn; ++i) {
                    o2.addLast(SV.newT((T)o1.get(i + i1)));
                }
                tokenOut.value = o2;
                break;
            }
            case 15: {
                if (--i1 < 0 || i1 >= len) {
                    return SV.newV(4, "");
                }
                byte[] data = ((BArray)((SV)tokenIn).value).data;
                if (isOne) {
                    return SV.newI(data[i1]);
                }
                byte[] b = new byte[Math.min(i2, len) - i1];
                int i = b.length;
                while (--i >= 0) {
                    b[i] = data[i1 + i];
                }
                tokenOut.value = new BArray(b);
            }
        }
        return tokenOut;
    }

    void setSelectedValue(int pt1, int pt2, SV var) {
        if (pt1 == Integer.MAX_VALUE) {
            return;
        }
        switch (this.tok) {
            case 11: 
            case 12: {
                Lst<SV> sv;
                int len;
                int n = len = this.tok == 11 ? 3 : 4;
                if (pt2 != Integer.MAX_VALUE) {
                    int col = pt2;
                    int row = pt1;
                    if (col > 0 && col <= len && row <= len) {
                        if (this.tok == 11) {
                            ((M3)this.value).setElement(row - 1, col - 1, SV.fValue(var));
                        } else {
                            ((M4)this.value).setElement(row - 1, col - 1, SV.fValue(var));
                        }
                        return;
                    }
                }
                if (pt1 == 0 || Math.abs(pt1) > len || var.tok != 7 || (sv = var.getList()).size() != len) break;
                float[] data = new float[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = SV.fValue((T)sv.get(i));
                }
                if (pt1 > 0) {
                    if (this.tok == 11) {
                        ((M3)this.value).setRowA(pt1 - 1, data);
                        break;
                    }
                    ((M4)this.value).setRowA(pt1 - 1, data);
                    break;
                }
                if (this.tok == 11) {
                    ((M3)this.value).setColumnA(-1 - pt1, data);
                    break;
                }
                ((M4)this.value).setColumnA(-1 - pt1, data);
                break;
            }
            case 4: {
                String str = (String)this.value;
                int pt = str.length();
                if (pt1 <= 0) {
                    pt1 = pt + pt1;
                }
                if (--pt1 < 0) {
                    pt1 = 0;
                }
                while (pt1 >= str.length()) {
                    str = str + " ";
                }
                if (pt2 == Integer.MAX_VALUE) {
                    pt2 = pt1;
                } else {
                    if (--pt2 < 0) {
                        pt2 = pt + pt2;
                    }
                    while (pt2 >= str.length()) {
                        str = str + " ";
                    }
                }
                if (pt2 >= pt1) {
                    this.value = str.substring(0, pt1) + SV.sValue(var) + str.substring(++pt2);
                }
                this.index = Integer.MAX_VALUE;
                this.intValue = Integer.MAX_VALUE;
                break;
            }
            case 7: {
                Lst v = (Lst)this.value;
                int len = v.size();
                if (pt1 <= 0) {
                    pt1 = len + pt1;
                }
                if (--pt1 < 0) {
                    pt1 = 0;
                }
                if (len <= pt1) {
                    for (int i = len; i <= pt1; ++i) {
                        v.addLast(SV.newV(4, ""));
                    }
                }
                v.set(pt1, var);
            }
        }
    }

    public String escape() {
        switch (this.tok) {
            case 4: {
                return PT.esc((String)this.value);
            }
            case 11: 
            case 12: {
                return PT.toJSON(null, this.value);
            }
            case 6: 
            case 7: 
            case 14: {
                SB sb = new SB();
                SV.sValueArray(sb, this, "", "", true, false, true, Integer.MAX_VALUE, false);
                return sb.toString();
            }
        }
        return SV.sValue(this);
    }

    public static Object unescapePointOrBitsetAsVariable(Object o) {
        if (o == null) {
            return o;
        }
        Object v = null;
        String s = null;
        if (o instanceof SV) {
            SV sv = (SV)o;
            switch (sv.tok) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    v = sv.value;
                    break;
                }
                case 4: {
                    s = (String)sv.value;
                    break;
                }
                default: {
                    s = SV.sValue(sv);
                    break;
                }
            }
        } else if (o instanceof String) {
            s = (String)o;
        }
        if (s != null && s.length() == 0) {
            return s;
        }
        if (v == null) {
            v = Escape.uABsM(s);
        }
        if (v instanceof P3) {
            return SV.newV(8, v);
        }
        if (v instanceof P4) {
            return SV.newV(9, v);
        }
        if (v instanceof BS) {
            if (s != null && s.indexOf("[{") == 0) {
                v = BondSet.newBS((BS)v, null);
            }
            return SV.newV(10, v);
        }
        if (v instanceof M34) {
            return SV.newV(v instanceof M3 ? 11 : 12, v);
        }
        return o;
    }

    public static SV getBoolean(boolean value) {
        return SV.newT(value ? vT : vF);
    }

    public static Object sprintf(String strFormat, SV var) {
        if (var == null) {
            return strFormat;
        }
        boolean isArray = var.tok == 7;
        int[] vd = (int[])(strFormat.indexOf("d") >= 0 || strFormat.indexOf("i") >= 0 ? new int[1] : null);
        float[] vf = strFormat.indexOf("f") >= 0 ? new float[1] : null;
        double[] ve = strFormat.indexOf("e") >= 0 ? new double[1] : null;
        boolean getS = strFormat.indexOf("s") >= 0;
        boolean getP = strFormat.indexOf("p") >= 0 && (isArray || var.tok == 8);
        boolean getQ = strFormat.indexOf("q") >= 0 && (isArray || var.tok == 9);
        Object[] of = new Object[]{vd, vf, ve, null, null, null};
        if (!isArray) {
            return SV.sprintf(strFormat, var, of, vd, vf, ve, getS, getP, getQ);
        }
        Lst<SV> sv = var.getList();
        String[] list2 = new String[sv.size()];
        for (int i = 0; i < list2.length; ++i) {
            list2[i] = SV.sprintf(strFormat, (SV)sv.get(i), of, vd, vf, ve, getS, getP, getQ);
        }
        return list2;
    }

    private static String sprintf(String strFormat, SV var, Object[] of, int[] vd, float[] vf, double[] ve, boolean getS, boolean getP, boolean getQ) {
        int pt;
        if (var.tok == 6 && (pt = strFormat.indexOf("[")) >= 0) {
            int pt1 = strFormat.indexOf("]");
            var = var.getMap().get(strFormat.substring(pt + 1, pt1));
            strFormat = strFormat.substring(0, pt) + strFormat.substring(pt1 + 1);
        }
        if (vd != null) {
            vd[0] = SV.iValue(var);
        }
        if (vf != null) {
            vf[0] = SV.fValue(var);
        }
        if (ve != null) {
            ve[0] = SV.fValue(var);
        }
        if (getS) {
            of[3] = SV.sValue(var);
        }
        if (getP) {
            of[4] = var.value;
        }
        if (getQ) {
            of[5] = var.value;
        }
        return PT.sprintf(strFormat, "IFDspq", of);
    }

    public static int getFormatType(String format) {
        return format.indexOf(";") >= 0 ? -1 : ";json;base64;bytearray;array;".indexOf(";" + format.toLowerCase() + ";");
    }

    public static Object format(SV[] args, int pt) {
        switch (args.length) {
            case 0: {
                return "";
            }
            case 1: {
                return SV.sValue(args[0]);
            }
            case 2: {
                if (pt == Integer.MAX_VALUE) {
                    pt = SV.getFormatType(args[0].asString());
                }
                switch (pt) {
                    case 0: {
                        String name = args[1].myName;
                        args[1].myName = null;
                        String o = args[1].toJSON();
                        args[1].myName = name;
                        return o;
                    }
                    case 5: 
                    case 12: 
                    case 22: {
                        byte[] bytes;
                        switch (args[1].tok) {
                            case 15: {
                                bytes = AU.arrayCopyByte(((BArray)args[1].value).data, -1);
                                break;
                            }
                            case 7: {
                                Lst<SV> l = args[1].getList();
                                if (pt == 22) {
                                    Lst l1 = new Lst();
                                    int i = l.size();
                                    while (--i >= 0) {
                                        l1.addLast(l.get(i));
                                    }
                                    return l1;
                                }
                                bytes = new byte[l.size()];
                                int i = bytes.length;
                                while (--i >= 0) {
                                    bytes[i] = (byte)((SV)l.get(i)).asInt();
                                }
                                break;
                            }
                            default: {
                                String s = args[1].asString();
                                if (s.startsWith(";base64,")) {
                                    if (pt == 5) {
                                        return s;
                                    }
                                    bytes = Base64.decodeBase64(s);
                                    break;
                                }
                                bytes = s.getBytes();
                            }
                        }
                        return pt == 22 ? SV.getVariable(bytes) : (pt == 12 ? new BArray(bytes) : ";base64," + Base64.getBase64(bytes).toString());
                    }
                }
            }
        }
        String[] format = PT.split(PT.rep(SV.sValue(args[0]), "%%", "\u0001"), "%");
        if (format.length == 0) {
            return "";
        }
        SB sb = new SB();
        sb.append(format[0]);
        for (int i = 1; i < format.length; ++i) {
            Object ret = SV.sprintf(PT.formatCheck("%" + format[i]), args[1].tok == 6 ? args[1] : (args[1].tok == 7 ? (SV)args[1].getList().get(i - 1) : (i < args.length ? args[i] : null)));
            if (AU.isAS(ret)) {
                String[] list = (String[])ret;
                for (int j = 0; j < list.length; ++j) {
                    sb.append(list[j]).append("\n");
                }
                continue;
            }
            sb.append((String)ret);
        }
        return sb.toString();
    }

    public static BS getBitSet(SV x, boolean allowNull) {
        switch (x.tok) {
            case 10: {
                return (BS)(x.index == Integer.MAX_VALUE ? (SV)SV.selectItemTok((T)x, (int)Integer.MIN_VALUE) : x).value;
            }
            case 7: {
                return SV.unEscapeBitSetArray(x.getList(), allowNull);
            }
        }
        return allowNull ? null : new BS();
    }

    static BS unEscapeBitSetArray(Lst<SV> x, boolean allowNull) {
        BS bs = new BS();
        for (int i = 0; i < x.size(); ++i) {
            SV v = (SV)x.get(i);
            if (v.tok == 2 && v.intValue >= 0) {
                bs.set(v.intValue);
                continue;
            }
            if (v.tok == 7) {
                BS bs2 = SV.unEscapeBitSetArray(v.getList(), true);
                if (bs2 == null) {
                    return allowNull ? null : new BS();
                }
                bs.or(bs2);
                continue;
            }
            if (SV.unEscapeBitSet(v, bs)) continue;
            return allowNull ? null : new BS();
        }
        return bs;
    }

    public static boolean areEqual(SV x1, SV x2) {
        if (x1 == null || x2 == null) {
            return false;
        }
        if (x1.value == x2.value) {
            return true;
        }
        if (x1.tok == x2.tok) {
            switch (x1.tok) {
                case 2: {
                    if (x2.tok != 2) break;
                    return x1.intValue == x2.intValue;
                }
                case 4: {
                    return ((String)x1.value).equalsIgnoreCase((String)x2.value);
                }
                case 6: 
                case 7: 
                case 10: 
                case 14: 
                case 15: {
                    return x1.equals(x2);
                }
                case 8: {
                    return (double)((P3)x1.value).distance((P3)x2.value) < 1.0E-6;
                }
                case 9: {
                    return (double)((P4)x1.value).distance4((P4)x2.value) < 1.0E-6;
                }
                case 11: {
                    return ((M3)x1.value).equals(x2.value);
                }
                case 12: {
                    return ((M4)x1.value).equals(x2.value);
                }
            }
        }
        return x1.isNaN() ? x2.isNaN() : (double)Math.abs(SV.fValue(x1) - SV.fValue(x2)) < 1.0E-6;
    }

    public static boolean isLike(SV x1, SV x2) {
        return x1 != null && x2 != null && x1.tok == 4 && x2.tok == 4 && PT.isLike((String)x1.value, (String)x2.value);
    }

    public SV sortOrReverse(int arrayPt) {
        Lst<SV> x = this.getList();
        if (x != null && x.size() > 1) {
            if (arrayPt == Integer.MIN_VALUE) {
                int n = x.size();
                for (int i = 0; i < n; ++i) {
                    SV v = (SV)x.get(i);
                    x.set(i, x.get(--n));
                    x.set(n, v);
                }
            } else {
                Collections.sort(this.getList(), new Sort(--arrayPt, null));
            }
        }
        return this;
    }

    public SV pushPop(SV mapKey, SV value) {
        if (mapKey == null) {
            Map<String, SV> m = this.getMap();
            if (m == null) {
                Lst<SV> x = this.getList();
                if (value == null || x == null) {
                    return x == null || x.size() == 0 ? SV.newS("") : x.removeItemAt(x.size() - 1);
                }
                x.addLast(SV.newI(0).setv(value));
            } else if (value == null) {
                m.clear();
            } else {
                Map<String, SV> m1 = value.getMap();
                if (m1 != null) {
                    m.putAll(m1);
                }
            }
        } else {
            Map<String, SV> m = this.getMap();
            if (value == null) {
                SV v = null;
                if (m == null) {
                    Lst<SV> lst = this.getList();
                    int len = lst.size();
                    int i = SV.iValue(mapKey) - 1;
                    if (i < 0) {
                        i += len;
                    }
                    if (i >= 0 && i < len) {
                        v = lst.removeItemAt(i);
                    }
                } else {
                    v = m.remove(mapKey.asString());
                }
                return v == null ? SV.newS("") : v;
            }
            if (m != null) {
                m.put(mapKey.asString(), SV.newI(0).setv(value));
            }
        }
        return this;
    }

    private static boolean unEscapeBitSet(SV x, BS bs) {
        switch (x.tok) {
            case 4: {
                BS bs1 = BS.unescape((String)x.value);
                if (bs1 == null) {
                    return false;
                }
                bs.or(bs1);
                return true;
            }
            case 10: {
                bs.or((BS)x.value);
                return true;
            }
        }
        return false;
    }

    public static String[] strListValue(T x) {
        if (x.tok != 7) {
            return new String[]{SV.sValue(x)};
        }
        Lst<SV> sv = ((SV)x).getList();
        String[] list = new String[sv.size()];
        int i = sv.size();
        while (--i >= 0) {
            list[i] = SV.sValue((T)sv.get(i));
        }
        return list;
    }

    public static int getArrayDepth(T x) {
        Lst<SV> sv;
        int n = 0;
        while (x.tok == 7 && (sv = ((SV)x).getList()).size() > 0) {
            ++n;
            x = (T)sv.get(0);
        }
        return n;
    }

    public static float[][] fflistValue(T x, int nMin) {
        if (x.tok != 7) {
            return new float[][]{{SV.fValue(x)}};
        }
        Lst<SV> sv = ((SV)x).getList();
        int svlen = sv.size();
        float[][] list = AU.newFloat2(svlen);
        if (nMin == 0) {
            nMin = list.length;
        }
        int i = list.length;
        while (--i >= 0) {
            list[i] = SV.flistValue(i >= svlen ? null : (SV)sv.get(i), 0);
        }
        return list;
    }

    public static float[] flistValue(T x, int nMin) {
        if (x == null || x.tok != 7) {
            return new float[]{SV.fValue(x)};
        }
        Lst<SV> sv = ((SV)x).getList();
        float[] list = new float[Math.max(nMin, sv.size())];
        if (nMin == 0) {
            nMin = list.length;
        }
        int i = Math.min(sv.size(), nMin);
        while (--i >= 0) {
            list[i] = SV.fValue((T)sv.get(i));
        }
        return list;
    }

    public SV toArray() {
        int dim;
        M3 m3 = null;
        M4 m4 = null;
        switch (this.tok) {
            case 11: {
                m3 = (M3)this.value;
                dim = 3;
                break;
            }
            case 12: {
                m4 = (M4)this.value;
                dim = 4;
                break;
            }
            case 7: {
                return this;
            }
            default: {
                Lst<SV> o2 = new Lst<SV>();
                o2.addLast(this);
                return SV.newV(7, o2);
            }
        }
        Lst<SV> o2 = new Lst<SV>();
        for (int i = 0; i < dim; ++i) {
            float[] a = new float[dim];
            if (m3 == null) {
                m4.getRow(i, a);
            } else {
                m3.getRow(i, a);
            }
            o2.addLast(SV.getVariableAF(a));
        }
        return SV.newV(7, o2);
    }

    SV mapValue(String key) {
        switch (this.tok) {
            case 6: {
                return (SV)((Map)this.value).get(key);
            }
            case 14: {
                ScriptContext sc = (ScriptContext)this.value;
                return key.equals("_path") ? SV.newS(sc.contextPath) : sc.getVariable(key);
            }
        }
        return null;
    }

    public Lst<SV> getList() {
        return this.tok == 7 ? (Lst)this.value : null;
    }

    public static boolean isScalar(SV x) {
        switch (x.tok) {
            case 7: {
                return false;
            }
            case 4: {
                return ((String)x.value).indexOf("\n") < 0;
            }
        }
        return true;
    }

    @Override
    public String toJSON() {
        switch (this.tok) {
            case 2: 
            case 3: 
            case 1073742334: 
            case 1073742335: {
                return SV.sValue(this);
            }
            case 15: {
                return PT.byteArrayToJSON(((BArray)this.value).data);
            }
            case 14: {
                return PT.toJSON(null, ((ScriptContext)this.value).getFullMap());
            }
            case 6: 
            case 7: {
                if (this.myName != null) {
                    this.myName = null;
                    return this.tok == 6 ? "{  }" : "[  ]";
                }
                this.myName = "x";
                String s = PT.toJSON(null, this.value);
                this.myName = null;
                return s;
            }
        }
        return PT.toJSON(null, this.value);
    }

    public SV mapGet(String key) {
        return this.getMap().get(key);
    }

    public void mapPut(String key, SV v) {
        this.getMap().put(key, v);
    }

    public Map<String, SV> getMap() {
        switch (this.tok) {
            case 6: {
                return (Map)this.value;
            }
            case 14: {
                return ((ScriptContext)this.value).vars;
            }
        }
        return null;
    }

    public String getMapKeys(int nLevels, boolean skipEmpty) {
        if (this.tok != 6) {
            return "";
        }
        SB sb = new SB();
        SV.sValueArray(sb, this, "", "", true, false, false, nLevels + 1, skipEmpty);
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString2() + "[" + this.myName + " index =" + this.index + " intValue=" + this.intValue + "]";
    }

    public String[] getKeys(boolean isAll) {
        switch (this.tok) {
            case 6: 
            case 7: 
            case 14: {
                break;
            }
            default: {
                return null;
            }
        }
        Lst<String> keys = new Lst<String>();
        this.getKeyList(isAll, keys, "");
        Object[] skeys = keys.toArray(new String[keys.size()]);
        Arrays.sort(skeys);
        return skeys;
    }

    private void getKeyList(boolean isAll, Lst<String> keys, String prefix) {
        Map<String, SV> map = this.getMap();
        if (map == null) {
            int n;
            Lst<SV> lst;
            if (isAll && (lst = this.getList()) != null && (n = lst.size()) > 0) {
                ((SV)lst.get(n - 1)).getKeyList(true, keys, prefix + "." + n + ".");
            }
            return;
        }
        for (Map.Entry<String, SV> e : map.entrySet()) {
            String k = e.getKey();
            if (isAll && (k.length() == 0 || !PT.isLetter(k.charAt(0)))) {
                if (prefix.endsWith(".")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                }
                k = "[" + PT.esc(k) + "]";
            }
            keys.addLast(prefix + k);
            if (!isAll) continue;
            e.getValue().getKeyList(true, keys, prefix + k + ".");
        }
    }

    public static Object deepCopy(Object v, boolean isHash, boolean isDeep) {
        if (isHash) {
            Map vold = (Map)v;
            Hashtable vnew = new Hashtable();
            for (Map.Entry e : vold.entrySet()) {
                SV v1 = (SV)e.getValue();
                vnew.put(e.getKey(), isDeep ? SV.deepCopySV(v1) : v1);
            }
            return vnew;
        }
        Lst vold2 = (Lst)v;
        Lst<SV> vnew2 = new Lst<SV>();
        int n = vold2.size();
        for (int i = 0; i < n; ++i) {
            SV vm = (SV)vold2.get(i);
            vnew2.addLast(isDeep ? SV.deepCopySV(vm) : vm);
        }
        return vnew2;
    }

    private static SV deepCopySV(SV vm) {
        switch (vm.tok) {
            case 6: 
            case 7: {
                if ("\r".equals(vm.myName)) {
                    vm.myName = null;
                    vm = SV.newV(vm.tok, vm.tok == 6 ? new Hashtable() : new Lst());
                    break;
                }
                String name0 = vm.myName;
                vm.myName = "\r";
                SV vm0 = vm;
                vm = SV.newV(vm.tok, SV.deepCopy(vm.value, vm.tok == 6, true));
                vm0.myName = name0;
            }
        }
        return vm;
    }

    public SV sortMapArray(String key) {
        Lst<SV> lst = this.getList();
        if (lst != null) {
            Collections.sort(this.getList(), new Sort(0, key));
        }
        return this;
    }

    public static Object safeJSON(String key, Object property) {
        return "{" + (property instanceof SV ? PT.esc(key) + " : " + SV.format(new SV[]{null, (SV)property}, 0) : PT.toJSON(key, property)) + "}";
    }

    public boolean isNaN() {
        return this.value == "NaN" || this == vNaN;
    }

    protected class Sort
    implements Comparator<SV> {
        private int arrayPt;
        private String myKey;

        protected Sort(int arrayPt, String myKey) {
            this.arrayPt = arrayPt;
            this.myKey = myKey;
        }

        @Override
        public int compare(SV x, SV y) {
            if (x.tok != y.tok) {
                if (x.tok == 3 || x.tok == 2 || y.tok == 3 || y.tok == 2) {
                    float fy;
                    float fx = SV.fValue(x);
                    return fx < (fy = SV.fValue(y)) ? -1 : (fx > fy ? 1 : 0);
                }
                if (x.tok == 4 || y.tok == 4) {
                    return SV.sValue(x).compareTo(SV.sValue(y));
                }
            }
            switch (x.tok) {
                case 2: {
                    return x.intValue < y.intValue ? -1 : (x.intValue > y.intValue ? 1 : 0);
                }
                case 4: {
                    return SV.sValue(x).compareTo(SV.sValue(y));
                }
                case 7: {
                    Lst<SV> sx = x.getList();
                    Lst<SV> sy = y.getList();
                    if (sx.size() != sy.size()) {
                        return sx.size() < sy.size() ? -1 : 1;
                    }
                    int iPt = this.arrayPt;
                    if (iPt < 0) {
                        iPt += sx.size();
                    }
                    if (iPt < 0 || iPt >= sx.size()) {
                        return 0;
                    }
                    return this.compare((SV)sx.get(iPt), (SV)sy.get(iPt));
                }
                case 6: {
                    if (this.myKey == null) break;
                    return this.compare(x.getMap().get(this.myKey), y.getMap().get(this.myKey));
                }
            }
            float fx = SV.fValue(x);
            float fy = SV.fValue(y);
            return fx < fy ? -1 : (fx > fy ? 1 : 0);
        }
    }
}

