/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class BoxedDoubleArrayParameterConverter
implements ToNativeConverter<Double[], double[]> {
    private static final ToNativeConverter<Double[], double[]> IN = new BoxedDoubleArrayParameterConverter(2);
    private static final ToNativeConverter<Double[], double[]> OUT = new Out(1);
    private static final ToNativeConverter<Double[], double[]> INOUT = new Out(3);
    private final int parameterFlags;

    public static ToNativeConverter<Double[], double[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return ParameterFlags.isOut(parameterFlags) ? (ParameterFlags.isIn(parameterFlags) ? INOUT : OUT) : IN;
    }

    BoxedDoubleArrayParameterConverter(int parameterFlags) {
        this.parameterFlags = parameterFlags;
    }

    @Override
    public double[] toNative(Double[] array2, ToNativeContext context) {
        if (array2 == null) {
            return null;
        }
        double[] primitive = new double[array2.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            for (int i2 = 0; i2 < array2.length; ++i2) {
                primitive[i2] = array2[i2] != null ? array2[i2] : 0.0;
            }
        }
        return primitive;
    }

    @Override
    public Class<double[]> nativeType() {
        return double[].class;
    }

    public static final class Out
    extends BoxedDoubleArrayParameterConverter
    implements ToNativeConverter.PostInvocation<Double[], double[]> {
        Out(int parameterFlags) {
            super(parameterFlags);
        }

        @Override
        public void postInvoke(Double[] array2, double[] primitive, ToNativeContext context) {
            if (array2 != null && primitive != null) {
                for (int i2 = 0; i2 < array2.length; ++i2) {
                    array2[i2] = primitive[i2];
                }
            }
        }
    }
}

