/*
 * Decompiled with CFR 0.152.
 */
package com.jwetherell.openmap.common;

import com.jwetherell.openmap.common.MoreMath;

public abstract class ProjMath {
    public static final transient float NORTH_POLE_F = 1.5707964f;
    public static final transient float SOUTH_POLE_F = -1.5707964f;
    public static final transient double NORTH_POLE_D = 1.5707963267948966;
    public static final transient double NORTH_POLE_DEG_D = 90.0;
    public static final transient double SOUTH_POLE_D = -1.5707963267948966;
    public static final transient double SOUTH_POLE_DEG_D = -90.0;
    public static final transient float DATELINE_F = (float)Math.PI;
    public static final transient double DATELINE_D = Math.PI;
    public static final transient double DATELINE_DEG_D = 180.0;
    public static final transient float LON_RANGE_F = (float)Math.PI * 2;
    public static final transient double LON_RANGE_D = Math.PI * 2;
    public static final transient double LON_RANGE_DEG_D = 360.0;
    public static final double DEGREES_TO_MILS = 17.77777777777778;

    public static final double roundAdjust(double x) {
        return ProjMath.qint_old(x);
    }

    public static final double qint(double x) {
        return ProjMath.qint_new(x);
    }

    private static final double qint_old(double x) {
        return (int)x < 0 ? x - 0.5 : x + 0.5;
    }

    private static final double qint_new(double x) {
        return x <= 0.0 ? x - 1.0 : x + 1.0;
    }

    public static final float lonDistance(float lon1, float lon2) {
        return (float)Math.min((double)Math.abs(lon1 - lon2), (lon1 < 0.0f ? (double)lon1 + Math.PI : Math.PI - (double)lon1) + (lon2 < 0.0f ? (double)lon2 + Math.PI : Math.PI - (double)lon2));
    }

    public static final long DEG_TO_SC(double deg) {
        return (long)(deg * 3600000.0);
    }

    public static final double SC_TO_DEG(int sc) {
        return (double)sc / 3600000.0;
    }

    public static final double radToMils(double rad) {
        double degrees = Math.toDegrees(rad);
        degrees = degrees < 0.0 ? 360.0 + degrees : degrees;
        return degrees * 17.77777777777778;
    }

    public static final double radToDeg(double rad) {
        return Math.toDegrees(rad);
    }

    public static final float radToDeg(float rad) {
        return (float)Math.toDegrees(rad);
    }

    public static final double degToRad(double deg) {
        return Math.toRadians(deg);
    }

    public static final float degToRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public static final int hashLatLon(float lat, float lon) {
        if (lat == -0.0f) {
            lat = 0.0f;
        }
        if (lon == -0.0f) {
            lon = 0.0f;
        }
        int tmp = Float.floatToIntBits(lat);
        int hash = tmp << 5 | tmp >> 27;
        return hash ^ Float.floatToIntBits(lon);
    }

    public static final float[] arrayDegToRad(float[] degs) {
        for (int i = 0; i < degs.length; ++i) {
            degs[i] = ProjMath.degToRad(degs[i]);
        }
        return degs;
    }

    public static final float[] arrayRadToDeg(float[] rads) {
        for (int i = 0; i < rads.length; ++i) {
            rads[i] = ProjMath.radToDeg(rads[i]);
        }
        return rads;
    }

    public static final double[] arrayDegToRad(double[] degs) {
        for (int i = 0; i < degs.length; ++i) {
            degs[i] = ProjMath.degToRad(degs[i]);
        }
        return degs;
    }

    public static final double[] arrayRadToDeg(double[] rads) {
        for (int i = 0; i < rads.length; ++i) {
            rads[i] = ProjMath.radToDeg(rads[i]);
        }
        return rads;
    }

    public static final float normalizeLatitude(float lat, float epsilon) {
        if (lat > 1.5707964f - epsilon) {
            return 1.5707964f - epsilon;
        }
        if (lat < -1.5707964f + epsilon) {
            return -1.5707964f + epsilon;
        }
        return lat;
    }

    public static final double normalizeLatitude(double lat, double epsilon) {
        if (lat > 1.5707963267948966 - epsilon) {
            return 1.5707963267948966 - epsilon;
        }
        if (lat < -1.5707963267948966 + epsilon) {
            return -1.5707963267948966 + epsilon;
        }
        return lat;
    }

    public static final float wrapLongitude(float lon) {
        if (lon < (float)(-Math.PI) || lon > (float)Math.PI) {
            lon += (float)Math.PI;
            lon += (lon %= (float)Math.PI * 2) < 0.0f ? (float)Math.PI : (float)(-Math.PI);
        }
        return lon;
    }

    public static final double wrapLongitude(double lon) {
        if (lon < -Math.PI || lon > Math.PI) {
            lon += Math.PI;
            lon += (lon %= Math.PI * 2) < 0.0 ? Math.PI : -Math.PI;
        }
        return lon;
    }

    public static final double wrapLongitudeDeg(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            lon += 180.0;
            lon += (lon %= 360.0) < 0.0 ? 180.0 : -180.0;
        }
        return lon;
    }

    public static final float sphericalUnitsToDeg(float u, float uCircumference) {
        return 360.0f * (u / uCircumference);
    }

    public static final float sphericalUnitsToRad(float u, float uCircumference) {
        return (float)Math.PI * 2 * (u / uCircumference);
    }

    public static final float geocentricLatitude(float lat, float flat) {
        float f = 1.0f - flat;
        return (float)Math.atan(f * f * (float)Math.tan(lat));
    }

    public static final float geographicLatitude(float lat, float flat) {
        float f = 1.0f - flat;
        return (float)Math.atan((float)Math.tan(lat) / (f * f));
    }

    public static boolean isCrossingDateline(double leftLon, double rightLon, float projScale) {
        return leftLon > rightLon || MoreMath.approximately_equal(leftLon, rightLon, (double)0.001f) && projScale > 1000000.0f;
    }
}

