"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppAnalyticsAdaptor = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class AppAnalyticsAdaptor {
  constructor() {
    _defineProperty(this, "fetchApps", async client => {
      try {
        const response = await client.callAsCurrentUser('observability.getObject', {
          objectType: 'application'
        });
        return response.observabilityObjectList.map(application => {
          const composition = application.application.servicesEntities.concat(application.application.traceGroups);
          const decodedComposition = composition.map(rec => decodeURI(rec));
          return {
            name: application.application.name,
            id: application.objectId,
            panelId: application.application.panelId,
            composition: decodedComposition,
            availability: {
              name: '',
              color: '',
              mainVisId: application.application.availabilityVisId || ''
            },
            dateModified: application.lastUpdatedTimeMs,
            dateCreated: application.createdTimeMs
          };
        });
      } catch (err) {
        throw new Error('Fetch All Applications Error: ' + err);
      }
    });

    _defineProperty(this, "fetchAppById", async (client, appId) => {
      try {
        const response = await client.callAsCurrentUser('observability.getObjectById', {
          objectId: appId
        });
        return response.observabilityObjectList[0];
      } catch (err) {
        throw new Error('Fetch Application By Id Error: ' + err);
      }
    });

    _defineProperty(this, "createNewApp", async (client, name, description, baseQuery, servicesEntities, traceGroups, availabilityVisId) => {
      const appBody = {
        name,
        description,
        baseQuery,
        servicesEntities,
        traceGroups,
        availabilityVisId
      };

      try {
        const response = await client.callAsCurrentUser('observability.createObject', {
          body: {
            application: appBody
          }
        });
        return response.objectId;
      } catch (err) {
        throw new Error('Create New Application Error: ' + err);
      }
    });

    _defineProperty(this, "renameApp", async (client, appId, name) => {
      const updateApplicationBody = {
        name
      };

      try {
        const response = await client.callAsCurrentUser('observability.updateObjectById', {
          objectId: appId,
          body: {
            application: updateApplicationBody
          }
        });
        return response.objectId;
      } catch (err) {
        throw new Error('Rename Application Error: ' + err);
      }
    });

    _defineProperty(this, "updateApp", async (client, appId, updateAppBody) => {
      try {
        const response = await client.callAsCurrentUser('observability.updateObjectById', {
          objectId: appId,
          body: {
            application: updateAppBody
          }
        });
        return response.objectId;
      } catch (err) {
        throw new Error('Update Panel Error: ' + err);
      }
    });

    _defineProperty(this, "deleteApp", async (client, appList) => {
      try {
        const response = await client.callAsCurrentUser('observability.deleteObjectByIdList', {
          objectIdList: appList
        });
        return {
          status: 'OK',
          message: response
        };
      } catch (err) {
        throw new Error('Delete Application Error: ' + err);
      }
    });
  }

}

exports.AppAnalyticsAdaptor = AppAnalyticsAdaptor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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