/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.function.Supplier;

public class CharDeduplication {
    static final char[][] ASCII_CHARS = new char[128][];
    public static final int TABLE_SIZE = 30;
    public static final int INTERNAL_TABLE_SIZE = 6;
    public static final int OPTIMIZED_LENGTH = 6;
    private static final char[] CHAR_ARRAY0;
    private static final ThreadLocal<CacheReference<CharDeduplication>> mutableCache;
    public final char[][][][] charArray_length = new char[5][30][6][];
    int newEntry2 = 0;
    int newEntry3 = 0;
    int newEntry4 = 0;
    int newEntry5 = 0;
    int newEntry6 = 0;

    private static final char[] optimizedCurrentTokenSource1(char[] cArray, int n) {
        char c = cArray[n];
        if (c < ASCII_CHARS.length) {
            return ASCII_CHARS[c];
        }
        return new char[]{c};
    }

    public static CharDeduplication getThreadLocalInstance() {
        return mutableCache.get().get();
    }

    private CharDeduplication() {
        this.init();
    }

    private void init() {
        for (int i = 0; i < 5; ++i) {
            char[] cArray = new char[i + 2];
            for (int j = 0; j < 30; ++j) {
                for (int k = 0; k < 6; ++k) {
                    this.charArray_length[i][j][k] = cArray;
                }
            }
        }
    }

    @Deprecated
    public void reset() {
        this.init();
    }

    public char[] sharedCopyOfRange(char[] cArray, int n, int n2) {
        int n3 = n2 - n;
        switch (n3) {
            case 1: {
                return CharDeduplication.optimizedCurrentTokenSource1(cArray, n);
            }
            case 2: {
                return this.optimizedCurrentTokenSource2(cArray, n);
            }
            case 3: {
                return this.optimizedCurrentTokenSource3(cArray, n);
            }
            case 4: {
                return this.optimizedCurrentTokenSource4(cArray, n);
            }
            case 5: {
                return this.optimizedCurrentTokenSource5(cArray, n);
            }
            case 6: {
                return this.optimizedCurrentTokenSource6(cArray, n);
            }
            case 0: {
                return CHAR_ARRAY0;
            }
        }
        return Arrays.copyOfRange(cArray, n, n2);
    }

    private final char[] optimizedCurrentTokenSource2(char[] cArray, int n) {
        char[] cArray2;
        char[] cArray3 = cArray;
        int n2 = n;
        char c = cArray3[n2];
        char c2 = cArray3[n2 + 1];
        int n3 = ((c << 6) + c2) % 30;
        char[][] cArray4 = this.charArray_length[0][n3];
        int n4 = this.newEntry2;
        while (++n4 < 6) {
            char[] cArray5 = cArray4[n4];
            if (c != cArray5[0] || c2 != cArray5[1]) continue;
            return cArray5;
        }
        n4 = -1;
        int n5 = this.newEntry2;
        while (++n4 <= n5) {
            cArray2 = cArray4[n4];
            if (c != cArray2[0] || c2 != cArray2[1]) continue;
            return cArray2;
        }
        if (++n5 >= 6) {
            n5 = 0;
        }
        cArray2 = new char[2];
        System.arraycopy(cArray3, n2, cArray2, 0, 2);
        this.newEntry2 = n5;
        cArray4[this.newEntry2] = cArray2;
        return cArray2;
    }

    private final char[] optimizedCurrentTokenSource3(char[] cArray, int n) {
        char[] cArray2;
        char[] cArray3 = cArray;
        int n2 = n;
        char c = cArray3[n2 + 1];
        char c2 = cArray3[n2];
        char c3 = cArray3[n2 + 2];
        int n3 = ((c2 << 6) + c3) % 30;
        char[][] cArray4 = this.charArray_length[1][n3];
        int n4 = this.newEntry3;
        while (++n4 < 6) {
            char[] cArray5 = cArray4[n4];
            if (c2 != cArray5[0] || c != cArray5[1] || c3 != cArray5[2]) continue;
            return cArray5;
        }
        n4 = -1;
        int n5 = this.newEntry3;
        while (++n4 <= n5) {
            cArray2 = cArray4[n4];
            if (c2 != cArray2[0] || c != cArray2[1] || c3 != cArray2[2]) continue;
            return cArray2;
        }
        if (++n5 >= 6) {
            n5 = 0;
        }
        cArray2 = new char[3];
        System.arraycopy(cArray3, n2, cArray2, 0, 3);
        this.newEntry3 = n5;
        cArray4[this.newEntry3] = cArray2;
        return cArray2;
    }

    private final char[] optimizedCurrentTokenSource4(char[] cArray, int n) {
        char[] cArray2;
        char[] cArray3 = cArray;
        int n2 = n;
        char c = cArray3[n2 + 1];
        char c2 = cArray3[n2 + 3];
        char c3 = cArray3[n2];
        char c4 = cArray3[n2 + 2];
        int n3 = ((c3 << 6) + c4) % 30;
        char[][] cArray4 = this.charArray_length[2][n3];
        int n4 = this.newEntry4;
        while (++n4 < 6) {
            char[] cArray5 = cArray4[n4];
            if (c3 != cArray5[0] || c != cArray5[1] || c4 != cArray5[2] || c2 != cArray5[3]) continue;
            return cArray5;
        }
        n4 = -1;
        int n5 = this.newEntry4;
        while (++n4 <= n5) {
            cArray2 = cArray4[n4];
            if (c3 != cArray2[0] || c != cArray2[1] || c4 != cArray2[2] || c2 != cArray2[3]) continue;
            return cArray2;
        }
        if (++n5 >= 6) {
            n5 = 0;
        }
        cArray2 = new char[4];
        System.arraycopy(cArray3, n2, cArray2, 0, 4);
        this.newEntry4 = n5;
        cArray4[this.newEntry4] = cArray2;
        return cArray2;
    }

    private final char[] optimizedCurrentTokenSource5(char[] cArray, int n) {
        char[] cArray2;
        char[] cArray3 = cArray;
        int n2 = n;
        char c = cArray3[n2 + 1];
        char c2 = cArray3[n2 + 3];
        char c3 = cArray3[n2];
        char c4 = cArray3[n2 + 2];
        char c5 = cArray3[n2 + 4];
        int n3 = ((c3 << 12) + (c4 << 6) + c5) % 30;
        char[][] cArray4 = this.charArray_length[3][n3];
        int n4 = this.newEntry5;
        while (++n4 < 6) {
            char[] cArray5 = cArray4[n4];
            if (c3 != cArray5[0] || c != cArray5[1] || c4 != cArray5[2] || c2 != cArray5[3] || c5 != cArray5[4]) continue;
            return cArray5;
        }
        n4 = -1;
        int n5 = this.newEntry5;
        while (++n4 <= n5) {
            cArray2 = cArray4[n4];
            if (c3 != cArray2[0] || c != cArray2[1] || c4 != cArray2[2] || c2 != cArray2[3] || c5 != cArray2[4]) continue;
            return cArray2;
        }
        if (++n5 >= 6) {
            n5 = 0;
        }
        cArray2 = new char[5];
        System.arraycopy(cArray3, n2, cArray2, 0, 5);
        this.newEntry5 = n5;
        cArray4[this.newEntry5] = cArray2;
        return cArray2;
    }

    private final char[] optimizedCurrentTokenSource6(char[] cArray, int n) {
        char[] cArray2;
        char[] cArray3 = cArray;
        int n2 = n;
        char c = cArray3[n2 + 1];
        char c2 = cArray3[n2 + 3];
        char c3 = cArray3[n2 + 5];
        char c4 = cArray3[n2];
        char c5 = cArray3[n2 + 2];
        char c6 = cArray3[n2 + 4];
        int n3 = ((c4 << 12) + (c5 << 6) + c6) % 30;
        char[][] cArray4 = this.charArray_length[4][n3];
        int n4 = this.newEntry6;
        while (++n4 < 6) {
            char[] cArray5 = cArray4[n4];
            if (c4 != cArray5[0] || c != cArray5[1] || c5 != cArray5[2] || c2 != cArray5[3] || c6 != cArray5[4] || c3 != cArray5[5]) continue;
            return cArray5;
        }
        n4 = -1;
        int n5 = this.newEntry6;
        while (++n4 <= n5) {
            cArray2 = cArray4[n4];
            if (c4 != cArray2[0] || c != cArray2[1] || c5 != cArray2[2] || c2 != cArray2[3] || c6 != cArray2[4] || c3 != cArray2[5]) continue;
            return cArray2;
        }
        if (++n5 >= 6) {
            n5 = 0;
        }
        cArray2 = new char[6];
        System.arraycopy(cArray3, n2, cArray2, 0, 6);
        this.newEntry6 = n5;
        cArray4[this.newEntry6] = cArray2;
        return cArray2;
    }

    static {
        for (int i = 0; i < ASCII_CHARS.length; ++i) {
            CharDeduplication.ASCII_CHARS[i] = new char[]{(char)i};
        }
        CHAR_ARRAY0 = new char[0];
        mutableCache = ThreadLocal.withInitial(() -> new CacheReference<CharDeduplication>(CharDeduplication::new));
    }

    static final class CacheReference<T> {
        private SoftReference<T> reference;
        private final Supplier<? extends T> supplier;

        CacheReference(Supplier<? extends T> supplier) {
            this.supplier = supplier;
            this.reference = new SoftReference<T>(supplier.get());
        }

        T get() {
            T t = this.reference.get();
            if (t == null) {
                t = this.supplier.get();
                this.reference = new SoftReference<T>(t);
            }
            return t;
        }
    }
}

