// components/services/filesystem/public/mojom/types.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/filesystem/public/mojom/types.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/services/filesystem/public/mojom/types.mojom-params-data.h"
#include "components/services/filesystem/public/mojom/types.mojom-shared-message-ids.h"

#include "components/services/filesystem/public/mojom/types.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_BLINK_JUMBO_H_
#define COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_BLINK_JUMBO_H_
#endif
namespace filesystem {
namespace mojom {
namespace blink {
TimespecOrNow::TimespecOrNow()
    : now(),
      seconds() {}

TimespecOrNow::TimespecOrNow(
    bool now_in,
    double seconds_in)
    : now(std::move(now_in)),
      seconds(std::move(seconds_in)) {}

TimespecOrNow::~TimespecOrNow() = default;
size_t TimespecOrNow::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->now);
  seed = mojo::internal::WTFHash(seed, this->seconds);
  return seed;
}

void TimespecOrNow::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("now", this->now);
  value->SetDouble("seconds", this->seconds);
}

bool TimespecOrNow::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FileInformation::FileInformation()
    : type(),
      size(),
      atime(),
      mtime(),
      ctime() {}

FileInformation::FileInformation(
    FsFileType type_in,
    int64_t size_in,
    double atime_in,
    double mtime_in,
    double ctime_in)
    : type(std::move(type_in)),
      size(std::move(size_in)),
      atime(std::move(atime_in)),
      mtime(std::move(mtime_in)),
      ctime(std::move(ctime_in)) {}

FileInformation::~FileInformation() = default;
size_t FileInformation::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->type);
  seed = mojo::internal::WTFHash(seed, this->size);
  seed = mojo::internal::WTFHash(seed, this->atime);
  seed = mojo::internal::WTFHash(seed, this->mtime);
  seed = mojo::internal::WTFHash(seed, this->ctime);
  return seed;
}

void FileInformation::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->SetString("size", base::NumberToString(this->size));
  value->SetDouble("atime", this->atime);
  value->SetDouble("mtime", this->mtime);
  value->SetDouble("ctime", this->ctime);
}

bool FileInformation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DirectoryEntry::DirectoryEntry()
    : name(),
      type() {}

DirectoryEntry::DirectoryEntry(
    const ::base::FilePath& name_in,
    FsFileType type_in)
    : name(std::move(name_in)),
      type(std::move(type_in)) {}

DirectoryEntry::~DirectoryEntry() = default;

void DirectoryEntry::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("name", base::trace_event::ValueToString(this->name, "<value of type const ::base::FilePath&>"));
  value->SetString("type", base::trace_event::ValueToString(this->type));
}

bool DirectoryEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace filesystem

namespace mojo {


// static
bool StructTraits<::filesystem::mojom::blink::TimespecOrNow::DataView, ::filesystem::mojom::blink::TimespecOrNowPtr>::Read(
    ::filesystem::mojom::blink::TimespecOrNow::DataView input,
    ::filesystem::mojom::blink::TimespecOrNowPtr* output) {
  bool success = true;
  ::filesystem::mojom::blink::TimespecOrNowPtr result(::filesystem::mojom::blink::TimespecOrNow::New());
  
      if (success)
        result->now = input.now();
      if (success)
        result->seconds = input.seconds();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::filesystem::mojom::blink::FileInformation::DataView, ::filesystem::mojom::blink::FileInformationPtr>::Read(
    ::filesystem::mojom::blink::FileInformation::DataView input,
    ::filesystem::mojom::blink::FileInformationPtr* output) {
  bool success = true;
  ::filesystem::mojom::blink::FileInformationPtr result(::filesystem::mojom::blink::FileInformation::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->size = input.size();
      if (success)
        result->atime = input.atime();
      if (success)
        result->mtime = input.mtime();
      if (success)
        result->ctime = input.ctime();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::filesystem::mojom::blink::DirectoryEntry::DataView, ::filesystem::mojom::blink::DirectoryEntryPtr>::Read(
    ::filesystem::mojom::blink::DirectoryEntry::DataView input,
    ::filesystem::mojom::blink::DirectoryEntryPtr* output) {
  bool success = true;
  ::filesystem::mojom::blink::DirectoryEntryPtr result(::filesystem::mojom::blink::DirectoryEntry::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif