// components/services/storage/public/mojom/storage_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/storage_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "components/services/storage/public/mojom/storage_service.mojom-params-data.h"
#include "components/services/storage/public/mojom/storage_service.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/storage_service.mojom-import-headers.h"


#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_SERVICE_MOJOM_JUMBO_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_SERVICE_MOJOM_JUMBO_H_
#endif
namespace storage {
namespace mojom {
const char StorageService::Name_[] = "storage.mojom.StorageService";

StorageServiceProxy::StorageServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StorageServiceProxy::EnableAggressiveDomStorageFlushing(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "storage::mojom::StorageService::EnableAggressiveDomStorageFlushing");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStorageService_EnableAggressiveDomStorageFlushing_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::StorageService_EnableAggressiveDomStorageFlushing_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageService::Name_);
  message.set_method_name("EnableAggressiveDomStorageFlushing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void StorageServiceProxy::SetDataDirectory(
    const ::base::FilePath& in_path, ::mojo::PendingRemote<::storage::mojom::Directory> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::StorageService::SetDataDirectory", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("path", base::trace_event::ValueToString(in_path, "<value of type const ::base::FilePath&>"));
      raw_value->SetBoolean("directory", in_directory.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStorageService_SetDataDirectory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::StorageService_SetDataDirectory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->path)::BaseType::BufferWriter
      path_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, buffer, &path_writer, &serialization_context);
  params->path.Set(
      path_writer.is_null() ? nullptr : path_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in StorageService.SetDataDirectory request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::DirectoryInterfaceBase>>(
      in_directory, &params->directory, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->directory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid directory in StorageService.SetDataDirectory request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageService::Name_);
  message.set_method_name("SetDataDirectory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void StorageServiceProxy::BindPartition(
    const base::Optional<::base::FilePath>& in_path, ::mojo::PendingReceiver<::storage::mojom::Partition> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::StorageService::BindPartition", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("path", base::trace_event::ValueToString(in_path, "<value of type const base::Optional<::base::FilePath>&>"));
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStorageService_BindPartition_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::StorageService_BindPartition_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->path)::BaseType::BufferWriter
      path_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path, buffer, &path_writer, &serialization_context);
  params->path.Set(
      path_writer.is_null() ? nullptr : path_writer.data());
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::PartitionInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in StorageService.BindPartition request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageService::Name_);
  message.set_method_name("BindPartition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void StorageServiceProxy::BindTestApi(
    ::mojo::ScopedMessagePipeHandle in_test_api_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "storage::mojom::StorageService::BindTestApi", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("test_api_receiver", in_test_api_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kStorageService_BindTestApi_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::storage::mojom::internal::StorageService_BindTestApi_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_test_api_receiver, &params->test_api_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->test_api_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid test_api_receiver in StorageService.BindTestApi request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StorageService::Name_);
  message.set_method_name("BindTestApi");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool StorageServiceStubDispatch::Accept(
    StorageService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kStorageService_EnableAggressiveDomStorageFlushing_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::StorageService::EnableAggressiveDomStorageFlushing",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::StorageService::EnableAggressiveDomStorageFlushing");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StorageService_EnableAggressiveDomStorageFlushing_Params_Data* params =
          reinterpret_cast<internal::StorageService_EnableAggressiveDomStorageFlushing_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      StorageService_EnableAggressiveDomStorageFlushing_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableAggressiveDomStorageFlushing();
      return true;
    }
    case internal::kStorageService_SetDataDirectory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::StorageService::SetDataDirectory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::StorageService::SetDataDirectory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StorageService_SetDataDirectory_Params_Data* params =
          reinterpret_cast<internal::StorageService_SetDataDirectory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_path{};
      ::mojo::PendingRemote<::storage::mojom::Directory> p_directory{};
      StorageService_SetDataDirectory_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success) {
        p_directory =
            input_data_view.TakeDirectory<decltype(p_directory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDataDirectory(
std::move(p_path), 
std::move(p_directory));
      return true;
    }
    case internal::kStorageService_BindPartition_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::StorageService::BindPartition",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::StorageService::BindPartition");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StorageService_BindPartition_Params_Data* params =
          reinterpret_cast<internal::StorageService_BindPartition_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::base::FilePath> p_path{};
      ::mojo::PendingReceiver<::storage::mojom::Partition> p_receiver{};
      StorageService_BindPartition_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindPartition(
std::move(p_path), 
std::move(p_receiver));
      return true;
    }
    case internal::kStorageService_BindTestApi_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)storage::mojom::StorageService::BindTestApi",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)storage::mojom::StorageService::BindTestApi");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::StorageService_BindTestApi_Params_Data* params =
          reinterpret_cast<internal::StorageService_BindTestApi_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::ScopedMessagePipeHandle p_test_api_receiver{};
      StorageService_BindTestApi_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_test_api_receiver = input_data_view.TakeTestApiReceiver();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StorageService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTestApi(
std::move(p_test_api_receiver));
      return true;
    }
  }
  return false;
}

// static
bool StorageServiceStubDispatch::AcceptWithResponder(
    StorageService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kStorageService_EnableAggressiveDomStorageFlushing_Name: {
      break;
    }
    case internal::kStorageService_SetDataDirectory_Name: {
      break;
    }
    case internal::kStorageService_BindPartition_Name: {
      break;
    }
    case internal::kStorageService_BindTestApi_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kStorageServiceValidationInfo[] = {
    {internal::kStorageService_EnableAggressiveDomStorageFlushing_Name,
     {&internal::StorageService_EnableAggressiveDomStorageFlushing_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kStorageService_SetDataDirectory_Name,
     {&internal::StorageService_SetDataDirectory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kStorageService_BindPartition_Name,
     {&internal::StorageService_BindPartition_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kStorageService_BindTestApi_Name,
     {&internal::StorageService_BindTestApi_Params_Data::Validate,
      nullptr /* no response */}},
};

bool StorageServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::StorageService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kStorageServiceValidationInfo);
}

}  // namespace mojom
}  // namespace storage

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif