// Copyright (c) 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   qtwebengine/common/extensions/api/webrtc_desktop_capture_private.idl
// DO NOT EDIT.

#include "tools/json_schema_compiler/util.h"
#include "base/check.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "qtwebengine/common/extensions/api/webrtc_desktop_capture_private.h"
#include <set>
#include <utility>

using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace webrtc_desktop_capture_private {
//
// Types
//

RequestInfo::RequestInfo()
: guest_process_id(0),
guest_render_frame_id(0) {}

RequestInfo::~RequestInfo() {}
RequestInfo::RequestInfo(RequestInfo&& rhs)

#if !defined(__GNUC__) || __GNUC__ > 5
: guest_process_id(rhs.guest_process_id),
guest_render_frame_id(rhs.guest_render_frame_id)
{
}
#else
: guest_process_id(rhs.guest_process_id),
guest_render_frame_id(rhs.guest_render_frame_id)
{
}
#endif

RequestInfo& RequestInfo::operator=(RequestInfo&& rhs)

#if !defined(__GNUC__) || __GNUC__ > 5
{guest_process_id = rhs.guest_process_id;
guest_render_frame_id = rhs.guest_render_frame_id;
return *this;
}
#else
{guest_process_id = rhs.guest_process_id;
guest_render_frame_id = rhs.guest_render_frame_id;
return *this;
}
#endif

// static
bool RequestInfo::Populate(
    const base::Value& value, RequestInfo* out) {
  if (!value.is_dict()) {
    return false;
  }
  const base::DictionaryValue* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* guest_process_id_value = NULL;
  if (!dict->GetWithoutPathExpansion("guestProcessId", &guest_process_id_value)) {
    return false;
  }
  {
    if (!guest_process_id_value->GetAsInteger(&out->guest_process_id)) {
      return false;
    }
  }

  const base::Value* guest_render_frame_id_value = NULL;
  if (!dict->GetWithoutPathExpansion("guestRenderFrameId", &guest_render_frame_id_value)) {
    return false;
  }
  {
    if (!guest_render_frame_id_value->GetAsInteger(&out->guest_render_frame_id)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<RequestInfo> RequestInfo::FromValue(const base::Value& value) {
  std::unique_ptr<RequestInfo> out(new RequestInfo());
  if (!Populate(value, out.get()))
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> RequestInfo::ToValue() const {
  std::unique_ptr<base::DictionaryValue> to_value_result(new base::DictionaryValue());

  to_value_result->SetWithoutPathExpansion("guestProcessId", std::make_unique<base::Value>(this->guest_process_id));

  to_value_result->SetWithoutPathExpansion("guestRenderFrameId", std::make_unique<base::Value>(this->guest_render_frame_id));


  return to_value_result;
}


Options::Options()
: can_request_audio_track(false) {}

Options::~Options() {}
Options::Options(Options&& rhs)

#if !defined(__GNUC__) || __GNUC__ > 5
: can_request_audio_track(rhs.can_request_audio_track)
{
}
#else
: can_request_audio_track(rhs.can_request_audio_track)
{
}
#endif

Options& Options::operator=(Options&& rhs)

#if !defined(__GNUC__) || __GNUC__ > 5
{can_request_audio_track = rhs.can_request_audio_track;
return *this;
}
#else
{can_request_audio_track = rhs.can_request_audio_track;
return *this;
}
#endif

// static
bool Options::Populate(
    const base::Value& value, Options* out) {
  if (!value.is_dict()) {
    return false;
  }
  const base::DictionaryValue* dict = static_cast<const base::DictionaryValue*>(&value);
  const base::Value* can_request_audio_track_value = NULL;
  if (!dict->GetWithoutPathExpansion("canRequestAudioTrack", &can_request_audio_track_value)) {
    return false;
  }
  {
    if (!can_request_audio_track_value->GetAsBoolean(&out->can_request_audio_track)) {
      return false;
    }
  }

  return true;
}

// static
std::unique_ptr<Options> Options::FromValue(const base::Value& value) {
  std::unique_ptr<Options> out(new Options());
  if (!Populate(value, out.get()))
    return nullptr;
  return out;
}

std::unique_ptr<base::DictionaryValue> Options::ToValue() const {
  std::unique_ptr<base::DictionaryValue> to_value_result(new base::DictionaryValue());

  to_value_result->SetWithoutPathExpansion("canRequestAudioTrack", std::make_unique<base::Value>(this->can_request_audio_track));


  return to_value_result;
}



//
// Functions
//

namespace ChooseDesktopMedia {

Params::Params() {}
Params::~Params() {}

// static
std::unique_ptr<Params> Params::Create(const base::ListValue& args) {
  if (args.GetSize() != 1) {
    return nullptr;
  }
  std::unique_ptr<Params> params(new Params());

  const base::Value* request_value = NULL;
  if (args.Get(0, &request_value) &&
      !request_value->is_none()) {
    {
      const base::DictionaryValue* dictionary = NULL;
      if (!request_value->GetAsDictionary(&dictionary)) {
        return std::unique_ptr<Params>();
      }
      if (!RequestInfo::Populate(*dictionary, &params->request)) {
        return std::unique_ptr<Params>();
      }
    }
  }
  else {
    return std::unique_ptr<Params>();
  }

  return params;
}


std::unique_ptr<base::ListValue> Results::Create(const std::string& stream_id, const Options& options) {
  std::unique_ptr<base::ListValue> create_results(new base::ListValue());
  create_results->Append(std::make_unique<base::Value>(stream_id));

  create_results->Append((options).ToValue());

  return create_results;
}
}  // namespace ChooseDesktopMedia

}  // namespace webrtc_desktop_capture_private
}  // namespace api
}  // namespace extensions

