// services/device/public/mojom/geolocation.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/geolocation.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/device/public/mojom/geolocation.mojom-params-data.h"
#include "services/device/public/mojom/geolocation.mojom-shared-message-ids.h"

#include "services/device/public/mojom/geolocation.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_MOJOM_BLINK_JUMBO_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_MOJOM_BLINK_JUMBO_H_
#endif
namespace device {
namespace mojom {
namespace blink {
const char Geolocation::Name_[] = "device.mojom.Geolocation";

class Geolocation_QueryNextPosition_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Geolocation_QueryNextPosition_ForwardToCallback(
      Geolocation::QueryNextPositionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Geolocation::QueryNextPositionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Geolocation_QueryNextPosition_ForwardToCallback);
};

GeolocationProxy::GeolocationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GeolocationProxy::SetHighAccuracy(
    bool in_high_accuracy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "device::mojom::Geolocation::SetHighAccuracy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("high_accuracy", in_high_accuracy);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGeolocation_SetHighAccuracy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::Geolocation_SetHighAccuracy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->high_accuracy = in_high_accuracy;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Geolocation::Name_);
  message.set_method_name("SetHighAccuracy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void GeolocationProxy::QueryNextPosition(
    QueryNextPositionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "device::mojom::Geolocation::QueryNextPosition");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGeolocation_QueryNextPosition_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::Geolocation_QueryNextPosition_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Geolocation::Name_);
  message.set_method_name("QueryNextPosition");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Geolocation_QueryNextPosition_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class Geolocation_QueryNextPosition_ProxyToResponder {
 public:
  static Geolocation::QueryNextPositionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Geolocation_QueryNextPosition_ProxyToResponder> proxy(
        new Geolocation_QueryNextPosition_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Geolocation_QueryNextPosition_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Geolocation_QueryNextPosition_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Geolocation_QueryNextPosition_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Geolocation::QueryNextPositionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::blink::GeopositionPtr in_geoposition);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Geolocation_QueryNextPosition_ProxyToResponder);
};

bool Geolocation_QueryNextPosition_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "device::mojom::Geolocation::QueryNextPositionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Geolocation_QueryNextPosition_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Geolocation_QueryNextPosition_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::device::mojom::blink::GeopositionPtr p_geoposition{};
  Geolocation_QueryNextPosition_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadGeoposition(&p_geoposition))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Geolocation::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_geoposition));
  return true;
}

void Geolocation_QueryNextPosition_ProxyToResponder::Run(
    ::device::mojom::blink::GeopositionPtr in_geoposition) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)device::mojom::Geolocation::QueryNextPositionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_geoposition.is_null()) {
        raw_value->SetString("geoposition", "nullptr");
      } else {
        raw_value->BeginDictionary("geoposition");
        in_geoposition->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kGeolocation_QueryNextPosition_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::device::mojom::internal::Geolocation_QueryNextPosition_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->geoposition)::BaseType::BufferWriter
      geoposition_writer;
  mojo::internal::Serialize<::device::mojom::GeopositionDataView>(
      in_geoposition, buffer, &geoposition_writer, &serialization_context);
  params->geoposition.Set(
      geoposition_writer.is_null() ? nullptr : geoposition_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->geoposition.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null geoposition in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)device::mojom::Geolocation::QueryNextPositionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Geolocation::Name_);
  message.set_method_name("QueryNextPosition");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GeolocationStubDispatch::Accept(
    Geolocation* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kGeolocation_SetHighAccuracy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::Geolocation::SetHighAccuracy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::Geolocation::SetHighAccuracy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Geolocation_SetHighAccuracy_Params_Data* params =
          reinterpret_cast<internal::Geolocation_SetHighAccuracy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_high_accuracy{};
      Geolocation_SetHighAccuracy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_high_accuracy = input_data_view.high_accuracy();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Geolocation::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHighAccuracy(
std::move(p_high_accuracy));
      return true;
    }
    case internal::kGeolocation_QueryNextPosition_Name: {
      break;
    }
  }
  return false;
}

// static
bool GeolocationStubDispatch::AcceptWithResponder(
    Geolocation* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kGeolocation_SetHighAccuracy_Name: {
      break;
    }
    case internal::kGeolocation_QueryNextPosition_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)device::mojom::Geolocation::QueryNextPosition",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)device::mojom::Geolocation::QueryNextPosition");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Geolocation_QueryNextPosition_Params_Data* params =
          reinterpret_cast<
              internal::Geolocation_QueryNextPosition_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Geolocation_QueryNextPosition_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Geolocation::Name_, 1, false);
        return false;
      }
      Geolocation::QueryNextPositionCallback callback =
          Geolocation_QueryNextPosition_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryNextPosition(std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGeolocationValidationInfo[] = {
    {internal::kGeolocation_SetHighAccuracy_Name,
     {&internal::Geolocation_SetHighAccuracy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kGeolocation_QueryNextPosition_Name,
     {&internal::Geolocation_QueryNextPosition_Params_Data::Validate,
      &internal::Geolocation_QueryNextPosition_ResponseParams_Data::Validate}},
};

bool GeolocationRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::Geolocation::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGeolocationValidationInfo);
}

bool GeolocationResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::Geolocation::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGeolocationValidationInfo);

}
}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif