/* rygel-trackable-container.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-trackable-container.vala, do not modify */

/*
 * Copyright (C) 2012,2013 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelTrackableContainerClearData RygelTrackableContainerClearData;
typedef struct _RygelTrackableContainerAddChildTrackedData RygelTrackableContainerAddChildTrackedData;
typedef struct _RygelTrackableContainerRemoveChildTrackedData RygelTrackableContainerRemoveChildTrackedData;
enum  {
	RYGEL_TRACKABLE_CONTAINER_CHILD_ADDED_SIGNAL,
	RYGEL_TRACKABLE_CONTAINER_CHILD_REMOVED_SIGNAL,
	RYGEL_TRACKABLE_CONTAINER_NUM_SIGNALS
};
static guint rygel_trackable_container_signals[RYGEL_TRACKABLE_CONTAINER_NUM_SIGNALS] = {0};

struct _RygelTrackableContainerClearData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackableContainer* self;
	RygelMediaObjects* children;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	RygelMediaObjects* _child_list;
	RygelMediaObjects* _tmp4_;
	gint _child_size;
	RygelMediaObjects* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _child_index;
	gint _tmp8_;
	gint _tmp9_;
	RygelMediaObject* child;
	RygelMediaObjects* _tmp10_;
	gpointer _tmp11_;
	RygelMediaObject* _tmp12_;
	GError* _error_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _RygelTrackableContainerAddChildTrackedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackableContainer* self;
	RygelMediaObject* object;
	RygelTrackableContainer* trackable;
	RygelTrackableContainer* _tmp0_;
	RygelTrackableContainer* _tmp1_;
};

struct _RygelTrackableContainerRemoveChildTrackedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelTrackableContainer* self;
	RygelMediaObject* object;
	RygelTrackableContainer* trackable;
	RygelTrackableContainer* _tmp0_;
	RygelTrackableContainer* _tmp1_;
	gint64 _tmp2_;
};

static void rygel_trackable_container_clear_data_free (gpointer _data);
static gboolean rygel_trackable_container_clear_co (RygelTrackableContainerClearData* _data_);
static void rygel_trackable_container_clear_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void rygel_trackable_container_add_child_tracked_data_free (gpointer _data);
static gboolean rygel_trackable_container_add_child_tracked_co (RygelTrackableContainerAddChildTrackedData* _data_);
static void rygel_trackable_container_add_child_tracked_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void rygel_trackable_container_thaw_events (RygelTrackableContainer* self);
static void rygel_trackable_container_remove_child_tracked_data_free (gpointer _data);
static gboolean rygel_trackable_container_remove_child_tracked_co (RygelTrackableContainerRemoveChildTrackedData* _data_);
static void rygel_trackable_container_remove_child_tracked_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static gchar* rygel_trackable_container_real_get_service_reset_token (RygelTrackableContainer* self);
static void rygel_trackable_container_real_set_service_reset_token (RygelTrackableContainer* self,
                                                             const gchar* token);
static guint32 rygel_trackable_container_real_get_system_update_id (RygelTrackableContainer* self);
static GType rygel_trackable_container_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static void
rygel_trackable_container_clear_data_free (gpointer _data)
{
	RygelTrackableContainerClearData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackableContainerClearData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
rygel_trackable_container_clear (RygelTrackableContainer* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	RygelTrackableContainerClearData* _data_;
	RygelTrackableContainer* _tmp0_;
	_data_ = g_slice_new0 (RygelTrackableContainerClearData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_trackable_container_clear_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_trackable_container_clear_co (_data_);
}

void
rygel_trackable_container_clear_finish (RygelTrackableContainer* self,
                                        GAsyncResult* _res_)
{
	RygelTrackableContainerClearData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_trackable_container_clear_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	RygelTrackableContainerClearData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_trackable_container_clear_co (_data_);
}

static gboolean
rygel_trackable_container_clear_co (RygelTrackableContainerClearData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = rygel_media_container_get_sort_criteria ((RygelMediaContainer*) _data_->self);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_state_ = 1;
		rygel_media_container_get_children ((RygelMediaContainer*) _data_->self, (guint) 0, (guint) -1, _data_->_tmp1_, NULL, rygel_trackable_container_clear_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = rygel_media_container_get_children_finish ((RygelMediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->children = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->children;
		if (_data_->_tmp3_ == NULL) {
			_g_object_unref0 (_data_->children);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		{
			_data_->_tmp4_ = _data_->children;
			_data_->_child_list = _data_->_tmp4_;
			_data_->_tmp5_ = _data_->_child_list;
			_data_->_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp5_);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_child_size = _data_->_tmp7_;
			_data_->_child_index = -1;
			while (TRUE) {
				_data_->_child_index = _data_->_child_index + 1;
				_data_->_tmp8_ = _data_->_child_index;
				_data_->_tmp9_ = _data_->_child_size;
				if (!(_data_->_tmp8_ < _data_->_tmp9_)) {
					break;
				}
				_data_->_tmp10_ = _data_->_child_list;
				_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp10_, _data_->_child_index);
				_data_->child = (RygelMediaObject*) _data_->_tmp11_;
				_data_->_tmp12_ = _data_->child;
				_data_->_state_ = 2;
				rygel_trackable_container_remove_child_tracked (_data_->self, _data_->_tmp12_, rygel_trackable_container_clear_ready, _data_);
				return FALSE;
				_state_2:
				rygel_trackable_container_remove_child_tracked_finish (_data_->self, _data_->_res_);
				_g_object_unref0 (_data_->child);
			}
		}
		_g_object_unref0 (_data_->children);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->self);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = _data_->_error_;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		g_warning ("rygel-trackable-container.vala:49: Failed to clear trackable container" \
" %s: %s", _data_->_tmp14_, _data_->_tmp16_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_trackable_container_add_child (RygelTrackableContainer* self,
                                     RygelMediaObject* object,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	RygelTrackableContainerIface* _iface_;
	_iface_ = RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->add_child) {
		_iface_->add_child (self, object, _callback_, _user_data_);
	}
}

void
rygel_trackable_container_add_child_finish (RygelTrackableContainer* self,
                                            GAsyncResult* _res_)
{
	RygelTrackableContainerIface* _iface_;
	_iface_ = RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->add_child_finish) {
		_iface_->add_child_finish (self, _res_);
	}
}

static void
rygel_trackable_container_add_child_tracked_data_free (gpointer _data)
{
	RygelTrackableContainerAddChildTrackedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackableContainerAddChildTrackedData, _data_);
}

void
rygel_trackable_container_add_child_tracked (RygelTrackableContainer* self,
                                             RygelMediaObject* object,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	RygelTrackableContainerAddChildTrackedData* _data_;
	RygelTrackableContainer* _tmp0_;
	RygelMediaObject* _tmp1_;
	g_return_if_fail (object != NULL);
	_data_ = g_slice_new0 (RygelTrackableContainerAddChildTrackedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_trackable_container_add_child_tracked_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (object);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp1_;
	rygel_trackable_container_add_child_tracked_co (_data_);
}

void
rygel_trackable_container_add_child_tracked_finish (RygelTrackableContainer* self,
                                                    GAsyncResult* _res_)
{
	RygelTrackableContainerAddChildTrackedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Add a child object, emitting the #RygelContainer::container_updated signal
     * with the object.
     * @see rygel_trackable_object_remove_child_tracked()
     *
     * @param object The child item or child container to be added.
     */
static void
rygel_trackable_container_add_child_tracked_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	RygelTrackableContainerAddChildTrackedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_trackable_container_add_child_tracked_co (_data_);
}

static gboolean
rygel_trackable_container_add_child_tracked_co (RygelTrackableContainerAddChildTrackedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	rygel_trackable_container_add_child (_data_->self, _data_->object, rygel_trackable_container_add_child_tracked_ready, _data_);
	return FALSE;
	_state_1:
	rygel_trackable_container_add_child_finish (_data_->self, _data_->_res_);
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, _data_->object, RYGEL_OBJECT_EVENT_TYPE_ADDED, FALSE);
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	if (RYGEL_IS_TRACKABLE_CONTAINER (_data_->object)) {
		_data_->_tmp0_ = _g_object_ref0 (RYGEL_IS_TRACKABLE_CONTAINER (_data_->object) ? ((RygelTrackableContainer*) _data_->object) : NULL);
		_data_->trackable = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->trackable;
		rygel_trackable_container_thaw_events (_data_->_tmp1_);
		_g_object_unref0 (_data_->trackable);
	}
	g_signal_emit (_data_->self, rygel_trackable_container_signals[RYGEL_TRACKABLE_CONTAINER_CHILD_ADDED_SIGNAL], 0, _data_->object);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
rygel_trackable_container_remove_child (RygelTrackableContainer* self,
                                        RygelMediaObject* object,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	RygelTrackableContainerIface* _iface_;
	_iface_ = RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->remove_child) {
		_iface_->remove_child (self, object, _callback_, _user_data_);
	}
}

void
rygel_trackable_container_remove_child_finish (RygelTrackableContainer* self,
                                               GAsyncResult* _res_)
{
	RygelTrackableContainerIface* _iface_;
	_iface_ = RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->remove_child_finish) {
		_iface_->remove_child_finish (self, _res_);
	}
}

static void
rygel_trackable_container_remove_child_tracked_data_free (gpointer _data)
{
	RygelTrackableContainerRemoveChildTrackedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->object);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelTrackableContainerRemoveChildTrackedData, _data_);
}

void
rygel_trackable_container_remove_child_tracked (RygelTrackableContainer* self,
                                                RygelMediaObject* object,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	RygelTrackableContainerRemoveChildTrackedData* _data_;
	RygelTrackableContainer* _tmp0_;
	RygelMediaObject* _tmp1_;
	g_return_if_fail (object != NULL);
	_data_ = g_slice_new0 (RygelTrackableContainerRemoveChildTrackedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_trackable_container_remove_child_tracked_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (object);
	_g_object_unref0 (_data_->object);
	_data_->object = _tmp1_;
	rygel_trackable_container_remove_child_tracked_co (_data_);
}

void
rygel_trackable_container_remove_child_tracked_finish (RygelTrackableContainer* self,
                                                       GAsyncResult* _res_)
{
	RygelTrackableContainerRemoveChildTrackedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Add a child object, emitting the #RygelContainer::container_updated signal
     * with the object.
     * @see rygel_trackable_object_add_child_tracked()
     *
     * @param object The child item or child container to be added.
     */
static void
rygel_trackable_container_remove_child_tracked_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	RygelTrackableContainerRemoveChildTrackedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_trackable_container_remove_child_tracked_co (_data_);
}

static gboolean
rygel_trackable_container_remove_child_tracked_co (RygelTrackableContainerRemoveChildTrackedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (RYGEL_IS_TRACKABLE_CONTAINER (_data_->object)) {
		_data_->_tmp0_ = _g_object_ref0 (RYGEL_IS_TRACKABLE_CONTAINER (_data_->object) ? ((RygelTrackableContainer*) _data_->object) : NULL);
		_data_->trackable = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->trackable;
		_data_->_state_ = 1;
		rygel_trackable_container_clear (_data_->_tmp1_, rygel_trackable_container_remove_child_tracked_ready, _data_);
		return FALSE;
		_state_1:
		rygel_trackable_container_clear_finish (_data_->_tmp1_, _data_->_res_);
		_g_object_unref0 (_data_->trackable);
	}
	_data_->_state_ = 2;
	rygel_trackable_container_remove_child (_data_->self, _data_->object, rygel_trackable_container_remove_child_tracked_ready, _data_);
	return FALSE;
	_state_2:
	rygel_trackable_container_remove_child_finish (_data_->self, _data_->_res_);
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, _data_->object, RYGEL_OBJECT_EVENT_TYPE_DELETED, FALSE);
	_data_->_tmp2_ = ((RygelMediaContainer*) _data_->self)->total_deleted_child_count;
	((RygelMediaContainer*) _data_->self)->total_deleted_child_count = _data_->_tmp2_ + 1;
	rygel_media_container_updated ((RygelMediaContainer*) _data_->self, NULL, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	g_signal_emit (_data_->self, rygel_trackable_container_signals[RYGEL_TRACKABLE_CONTAINER_CHILD_REMOVED_SIGNAL], 0, _data_->object);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Used to query the (persisted) service reset token from the plug-in.
     *
     * If a plugin implements PLUGIN_CAPABILITIES_TRACK_CHANGES, it should
     * persist the ServiceResetToken. To do this override this virtual
     * function in the root container implementation and provide the persisted
     * version.
     */
static gchar*
rygel_trackable_container_real_get_service_reset_token (RygelTrackableContainer* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = gupnp_get_uuid ();
	result = _tmp0_;
	return result;
}

gchar*
rygel_trackable_container_get_service_reset_token (RygelTrackableContainer* self)
{
	RygelTrackableContainerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->get_service_reset_token) {
		return _iface_->get_service_reset_token (self);
	}
	return NULL;
}

/**
     * Set a new service reset token.
     *
     * If the service reset procedure has to be performed, the content
     * directory service will set the new service reset token.
     *
     * @param token the new service reset token.
     */
static void
rygel_trackable_container_real_set_service_reset_token (RygelTrackableContainer* self,
                                                        const gchar* token)
{
	g_return_if_fail (token != NULL);
}

void
rygel_trackable_container_set_service_reset_token (RygelTrackableContainer* self,
                                                   const gchar* token)
{
	RygelTrackableContainerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->set_service_reset_token) {
		_iface_->set_service_reset_token (self, token);
	}
}

/**
     * Query the current system update ID,
     * used for the UPnP GetSystemUpdateID implementation.
     *
     * This should be overriden by the root container of the back-end
     * implementation. This will only be called once, at service startup, 
     * to discover the cached system Update ID, if any, that was known
     * when the service last shut down.
     *
     * Derived classes may need to delay part of their initialization
     * until this function has been called, doing that initialization in
     * the function override. That can prevent other parts of their 
     * implementation from changing the cached System Update ID before
     * it has been provided.
     *
     * @return the current SystemUpdateID as persisted by the back-end.
     */
static guint32
rygel_trackable_container_real_get_system_update_id (RygelTrackableContainer* self)
{
	guint32 result;
	result = (guint32) 0;
	return result;
}

guint32
rygel_trackable_container_get_system_update_id (RygelTrackableContainer* self)
{
	RygelTrackableContainerIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = RYGEL_TRACKABLE_CONTAINER_GET_INTERFACE (self);
	if (_iface_->get_system_update_id) {
		return _iface_->get_system_update_id (self);
	}
	return 0U;
}

static void
rygel_trackable_container_thaw_events (RygelTrackableContainer* self)
{
}

static void
rygel_trackable_container_default_init (RygelTrackableContainerIface * iface,
                                        gpointer iface_data)
{
	rygel_trackable_container_signals[RYGEL_TRACKABLE_CONTAINER_CHILD_ADDED_SIGNAL] = g_signal_new ("child-added", RYGEL_TYPE_TRACKABLE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_OBJECT);
	rygel_trackable_container_signals[RYGEL_TRACKABLE_CONTAINER_CHILD_REMOVED_SIGNAL] = g_signal_new ("child-removed", RYGEL_TYPE_TRACKABLE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_MEDIA_OBJECT);
	iface->get_service_reset_token = rygel_trackable_container_real_get_service_reset_token;
	iface->set_service_reset_token = rygel_trackable_container_real_set_service_reset_token;
	iface->get_system_update_id = rygel_trackable_container_real_get_system_update_id;
}

/**
 * The base class for containers that provide automatic change tracking.
 *
 * Derived classes should implement the add_child() and remove_child()
 * virtual functions to keep track of child items and child containers.
 *
 * Rygel server plugins (See #RygelMediaServer) may then call
 * rygel_trackable_container_add_child_tracked() and
 * rygel_trackable_container_remove_child_tracked() to add and remove
 * items, which will then cause the #RygelContainer::container_updated signal
 * to be emitted.
 */
static GType
rygel_trackable_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelTrackableContainerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_trackable_container_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType rygel_trackable_container_type_id;
	rygel_trackable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelTrackableContainer", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rygel_trackable_container_type_id, RYGEL_TYPE_MEDIA_CONTAINER);
	return rygel_trackable_container_type_id;
}

GType
rygel_trackable_container_get_type (void)
{
	static volatile gsize rygel_trackable_container_type_id__once = 0;
	if (g_once_init_enter (&rygel_trackable_container_type_id__once)) {
		GType rygel_trackable_container_type_id;
		rygel_trackable_container_type_id = rygel_trackable_container_get_type_once ();
		g_once_init_leave (&rygel_trackable_container_type_id__once, rygel_trackable_container_type_id);
	}
	return rygel_trackable_container_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

