/* rygel-lms-album.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-lms-album.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-lms.h"
#include <sqlite3.h>
#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#define RYGEL_LMS_ALBUM_SQL_ALL_TEMPLATE "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "WHERE dtime = 0 AND audios.id = files.id AND audios.album_id = %s " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ALBUM_SQL_COUNT_TEMPLATE "SELECT COUNT(audios.id) " "FROM audios, files " "WHERE dtime = 0 AND audios.id = files.id AND audios.album_id = %s;"
#define RYGEL_LMS_ALBUM_SQL_COUNT_WITH_FILTER_TEMPLATE "SELECT COUNT(audios.id), audios.title as title, " "audio_artists.name as artist, " "audio_albums.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "WHERE dtime = 0 AND audios.id = files.id AND audios.album_id = %s;"
#define RYGEL_LMS_ALBUM_SQL_FIND_OBJECT_TEMPLATE "SELECT files.id, files.path, files.size, " "audios.title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name, " "audio_albums.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "WHERE dtime = 0 AND files.id = ? AND audios.id = files.id " "AND audios.album_id = %s;"
#define RYGEL_LMS_ALBUM_SQL_ADDED_TEMPLATE "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "WHERE dtime = 0 AND audios.id = files.id AND audios.album_id = %s " "AND update_id > ? AND update_id <= ?;"
#define RYGEL_LMS_ALBUM_SQL_REMOVED_TEMPLATE "SELECT files.id, files.path, files.size, " "audios.title as title, audios.trackno, audios.length, " "audios.channels, audios.sampling_rate, audios.bitrate, " "audios.dlna_profile, audios.dlna_mime, " "audio_artists.name as artist, " "audio_albums.name " "FROM audios, files " "LEFT JOIN audio_artists " "ON audios.artist_id = audio_artists.id " "LEFT JOIN audio_albums " "ON audios.album_id = audio_albums.id " "WHERE dtime <> 0 AND audios.id = files.id AND audios.album_id = %s " "AND update_id > ? AND update_id <= ?;"

enum  {
	RYGEL_LMS_ALBUM_0_PROPERTY,
	RYGEL_LMS_ALBUM_NUM_PROPERTIES
};
static GParamSpec* rygel_lms_album_properties[RYGEL_LMS_ALBUM_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer rygel_lms_album_parent_class = NULL;

static RygelMediaObject* rygel_lms_album_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                              sqlite3_stmt* statement);
static gchar* rygel_lms_album_get_sql_all (const gchar* db_id);
static gchar* rygel_lms_album_get_sql_find_object (const gchar* db_id);
static gchar* rygel_lms_album_get_sql_count (const gchar* db_id);
static gchar* rygel_lms_album_get_sql_added (const gchar* db_id);
static gchar* rygel_lms_album_get_sql_removed (const gchar* db_id);
static gchar* rygel_lms_album_real_get_sql_all_with_filter (RygelLMSCategoryContainer* base,
                                                     const gchar* filter);
static gchar* rygel_lms_album_real_get_sql_count_with_filter (RygelLMSCategoryContainer* base,
                                                       const gchar* filter);
static GType rygel_lms_album_get_type_once (void);

static RygelMediaObject*
rygel_lms_album_real_object_from_statement (RygelLMSCategoryContainer* base,
                                            sqlite3_stmt* statement)
{
	RygelLMSAlbum * self;
	gint id = 0;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* mime_type = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gchar* title = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* song_id = NULL;
	gchar* _tmp12_;
	RygelMusicItem* song = NULL;
	RygelMusicItem* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GFile* file = NULL;
	const gchar* _tmp20_;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	RygelMediaObject* result;
	self = (RygelLMSAlbum*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	id = sqlite3_column_int (statement, 0);
	_tmp0_ = (const gchar*) sqlite3_column_text (statement, 1);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp2_ = (const gchar*) sqlite3_column_text (statement, 10);
	_tmp3_ = g_strdup (_tmp2_);
	mime_type = _tmp3_;
	_tmp5_ = mime_type;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = mime_type;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ == 0;
	}
	if (_tmp4_) {
		const gchar* _tmp9_;
		_tmp9_ = path;
		g_debug ("rygel-lms-album.vala:111: Music item %d (%s) has no MIME type", id, _tmp9_);
	}
	_tmp10_ = (const gchar*) sqlite3_column_text (statement, 3);
	_tmp11_ = g_strdup (_tmp10_);
	title = _tmp11_;
	_tmp12_ = rygel_lms_category_container_build_child_id ((RygelLMSCategoryContainer*) self, id);
	song_id = _tmp12_;
	_tmp13_ = rygel_music_item_new (song_id, (RygelMediaContainer*) self, title, RYGEL_MUSIC_ITEM_UPNP_CLASS);
	song = _tmp13_;
	_tmp14_ = rygel_lms_category_container_build_reference_id ((RygelLMSCategoryContainer*) self, id);
	_tmp15_ = _tmp14_;
	rygel_media_object_set_ref_id ((RygelMediaObject*) song, _tmp15_);
	_g_free0 (_tmp15_);
	rygel_media_file_item_set_size ((RygelMediaFileItem*) song, (gint64) sqlite3_column_int (statement, 2));
	rygel_music_item_set_track_number (song, sqlite3_column_int (statement, 4));
	rygel_audio_item_set_duration ((RygelAudioItem*) song, (glong) sqlite3_column_int (statement, 5));
	rygel_audio_item_set_channels ((RygelAudioItem*) song, sqlite3_column_int (statement, 6));
	rygel_audio_item_set_sample_freq ((RygelAudioItem*) song, sqlite3_column_int (statement, 7));
	rygel_audio_item_set_bitrate ((RygelAudioItem*) song, sqlite3_column_int (statement, 8));
	_tmp16_ = (const gchar*) sqlite3_column_text (statement, 9);
	rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) song, _tmp16_);
	_tmp17_ = mime_type;
	rygel_media_file_item_set_mime_type ((RygelMediaFileItem*) song, _tmp17_);
	_tmp18_ = (const gchar*) sqlite3_column_text (statement, 11);
	rygel_media_object_set_artist ((RygelMediaObject*) song, _tmp18_);
	_tmp19_ = (const gchar*) sqlite3_column_text (statement, 12);
	rygel_audio_item_set_album ((RygelAudioItem*) song, _tmp19_);
	_tmp20_ = path;
	_tmp21_ = g_file_new_for_path (_tmp20_);
	file = _tmp21_;
	_tmp22_ = g_file_get_uri (file);
	_tmp23_ = _tmp22_;
	rygel_media_object_add_uri ((RygelMediaObject*) song, _tmp23_);
	_g_free0 (_tmp23_);
	result = (RygelMediaObject*) song;
	_g_object_unref0 (file);
	_g_free0 (song_id);
	_g_free0 (title);
	_g_free0 (mime_type);
	_g_free0 (path);
	return result;
}

static gchar*
rygel_lms_album_get_sql_all (const gchar* db_id)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (db_id != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_ALL_TEMPLATE, db_id);
	result = _tmp0_;
	return result;
}

static gchar*
rygel_lms_album_get_sql_find_object (const gchar* db_id)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (db_id != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_FIND_OBJECT_TEMPLATE, db_id);
	result = _tmp0_;
	return result;
}

static gchar*
rygel_lms_album_get_sql_count (const gchar* db_id)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (db_id != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_COUNT_TEMPLATE, db_id);
	result = _tmp0_;
	return result;
}

static gchar*
rygel_lms_album_get_sql_added (const gchar* db_id)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (db_id != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_ADDED_TEMPLATE, db_id);
	result = _tmp0_;
	return result;
}

static gchar*
rygel_lms_album_get_sql_removed (const gchar* db_id)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (db_id != NULL, NULL);
	_tmp0_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_REMOVED_TEMPLATE, db_id);
	result = _tmp0_;
	return result;
}

static gchar*
rygel_lms_album_real_get_sql_all_with_filter (RygelLMSCategoryContainer* base,
                                              const gchar* filter)
{
	RygelLMSAlbum * self;
	gint _tmp0_;
	gint _tmp1_;
	gchar* filter_str = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	self = (RygelLMSAlbum*) base;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = strlen (filter);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = rygel_lms_category_container_get_sql_all ((RygelLMSCategoryContainer*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = rygel_lms_category_container_get_db_id ((RygelLMSCategoryContainer*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s AND %s", _tmp6_, filter);
	filter_str = _tmp7_;
	_tmp8_ = filter_str;
	_tmp9_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_ALL_TEMPLATE, _tmp8_);
	result = _tmp9_;
	_g_free0 (filter_str);
	return result;
}

static gchar*
rygel_lms_album_real_get_sql_count_with_filter (RygelLMSCategoryContainer* base,
                                                const gchar* filter)
{
	RygelLMSAlbum * self;
	gint _tmp0_;
	gint _tmp1_;
	gchar* filter_str = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	self = (RygelLMSAlbum*) base;
	g_return_val_if_fail (filter != NULL, NULL);
	_tmp0_ = strlen (filter);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = rygel_lms_category_container_get_sql_count ((RygelLMSCategoryContainer*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = rygel_lms_category_container_get_db_id ((RygelLMSCategoryContainer*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s AND %s", _tmp6_, filter);
	filter_str = _tmp7_;
	_tmp8_ = filter_str;
	_tmp9_ = g_strdup_printf (RYGEL_LMS_ALBUM_SQL_COUNT_WITH_FILTER_TEMPLATE, _tmp8_);
	result = _tmp9_;
	_g_free0 (filter_str);
	return result;
}

RygelLMSAlbum*
rygel_lms_album_construct (GType object_type,
                           const gchar* db_id,
                           RygelMediaContainer* parent,
                           const gchar* title,
                           RygelLMSDatabase* lms_db)
{
	RygelLMSAlbum * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (db_id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	_tmp0_ = rygel_lms_album_get_sql_all (db_id);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_lms_album_get_sql_find_object (db_id);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_lms_album_get_sql_count (db_id);
	_tmp5_ = _tmp4_;
	_tmp6_ = rygel_lms_album_get_sql_added (db_id);
	_tmp7_ = _tmp6_;
	_tmp8_ = rygel_lms_album_get_sql_removed (db_id);
	_tmp9_ = _tmp8_;
	self = (RygelLMSAlbum*) rygel_lms_category_container_construct (object_type, db_id, parent, title, lms_db, _tmp1_, _tmp3_, _tmp5_, _tmp7_, _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}

RygelLMSAlbum*
rygel_lms_album_new (const gchar* db_id,
                     RygelMediaContainer* parent,
                     const gchar* title,
                     RygelLMSDatabase* lms_db)
{
	return rygel_lms_album_construct (RYGEL_LMS_TYPE_ALBUM, db_id, parent, title, lms_db);
}

static void
rygel_lms_album_class_init (RygelLMSAlbumClass * klass,
                            gpointer klass_data)
{
	rygel_lms_album_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = (RygelMediaObject* (*) (RygelLMSCategoryContainer*, sqlite3_stmt*)) rygel_lms_album_real_object_from_statement;
	((RygelLMSCategoryContainerClass *) klass)->get_sql_all_with_filter = (gchar* (*) (RygelLMSCategoryContainer*, const gchar*)) rygel_lms_album_real_get_sql_all_with_filter;
	((RygelLMSCategoryContainerClass *) klass)->get_sql_count_with_filter = (gchar* (*) (RygelLMSCategoryContainer*, const gchar*)) rygel_lms_album_real_get_sql_count_with_filter;
}

static void
rygel_lms_album_instance_init (RygelLMSAlbum * self,
                               gpointer klass)
{
}

static GType
rygel_lms_album_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLMSAlbumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_album_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSAlbum), 0, (GInstanceInitFunc) rygel_lms_album_instance_init, NULL };
	GType rygel_lms_album_type_id;
	rygel_lms_album_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSAlbum", &g_define_type_info, 0);
	return rygel_lms_album_type_id;
}

GType
rygel_lms_album_get_type (void)
{
	static volatile gsize rygel_lms_album_type_id__once = 0;
	if (g_once_init_enter (&rygel_lms_album_type_id__once)) {
		GType rygel_lms_album_type_id;
		rygel_lms_album_type_id = rygel_lms_album_get_type_once ();
		g_once_init_leave (&rygel_lms_album_type_id__once, rygel_lms_album_type_id);
	}
	return rygel_lms_album_type_id__once;
}

